# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DedicatedCloudServiceArgs', 'DedicatedCloudService']

@pulumi.input_type
class DedicatedCloudServiceArgs:
    def __init__(__self__, *,
                 gateway_subnet: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 dedicated_cloud_service_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DedicatedCloudService resource.
        :param pulumi.Input[str] gateway_subnet: gateway Subnet for the account. It will collect the subnet address and always treat it as /28
        :param pulumi.Input[str] resource_group_name: The name of the resource group
        :param pulumi.Input[str] dedicated_cloud_service_name: dedicated cloud Service name
        :param pulumi.Input[str] location: Azure region
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The list of tags
        """
        pulumi.set(__self__, "gateway_subnet", gateway_subnet)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if dedicated_cloud_service_name is not None:
            pulumi.set(__self__, "dedicated_cloud_service_name", dedicated_cloud_service_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="gatewaySubnet")
    def gateway_subnet(self) -> pulumi.Input[str]:
        """
        gateway Subnet for the account. It will collect the subnet address and always treat it as /28
        """
        return pulumi.get(self, "gateway_subnet")

    @gateway_subnet.setter
    def gateway_subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway_subnet", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="dedicatedCloudServiceName")
    def dedicated_cloud_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        dedicated cloud Service name
        """
        return pulumi.get(self, "dedicated_cloud_service_name")

    @dedicated_cloud_service_name.setter
    def dedicated_cloud_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_cloud_service_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Azure region
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The list of tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class DedicatedCloudService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_cloud_service_name: Optional[pulumi.Input[str]] = None,
                 gateway_subnet: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Dedicated cloud service model
        API Version: 2019-04-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dedicated_cloud_service_name: dedicated cloud Service name
        :param pulumi.Input[str] gateway_subnet: gateway Subnet for the account. It will collect the subnet address and always treat it as /28
        :param pulumi.Input[str] location: Azure region
        :param pulumi.Input[str] resource_group_name: The name of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The list of tags
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedCloudServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Dedicated cloud service model
        API Version: 2019-04-01.

        :param str resource_name: The name of the resource.
        :param DedicatedCloudServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedCloudServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dedicated_cloud_service_name: Optional[pulumi.Input[str]] = None,
                 gateway_subnet: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedCloudServiceArgs.__new__(DedicatedCloudServiceArgs)

            __props__.__dict__["dedicated_cloud_service_name"] = dedicated_cloud_service_name
            if gateway_subnet is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_subnet'")
            __props__.__dict__["gateway_subnet"] = gateway_subnet
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["is_account_onboarded"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["service_url"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:vmwarecloudsimple:DedicatedCloudService"), pulumi.Alias(type_="azure-native:vmwarecloudsimple/v20190401:DedicatedCloudService"), pulumi.Alias(type_="azure-nextgen:vmwarecloudsimple/v20190401:DedicatedCloudService")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DedicatedCloudService, __self__).__init__(
            'azure-native:vmwarecloudsimple:DedicatedCloudService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DedicatedCloudService':
        """
        Get an existing DedicatedCloudService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DedicatedCloudServiceArgs.__new__(DedicatedCloudServiceArgs)

        __props__.__dict__["gateway_subnet"] = None
        __props__.__dict__["is_account_onboarded"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["nodes"] = None
        __props__.__dict__["service_url"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return DedicatedCloudService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gatewaySubnet")
    def gateway_subnet(self) -> pulumi.Output[str]:
        """
        gateway Subnet for the account. It will collect the subnet address and always treat it as /28
        """
        return pulumi.get(self, "gateway_subnet")

    @property
    @pulumi.getter(name="isAccountOnboarded")
    def is_account_onboarded(self) -> pulumi.Output[str]:
        """
        indicates whether account onboarded or not in a given region
        """
        return pulumi.get(self, "is_account_onboarded")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Azure region
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        {dedicatedCloudServiceName}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[int]:
        """
        total nodes purchased
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="serviceURL")
    def service_url(self) -> pulumi.Output[str]:
        """
        link to a service management web portal
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The list of tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        {resourceProviderNamespace}/{resourceType}
        """
        return pulumi.get(self, "type")

