# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AccountEncryptionArgs',
    'EccTokenKeyArgs',
    'JwtAuthenticationArgs',
    'KeyVaultPropertiesArgs',
    'ResourceIdentityArgs',
    'RsaTokenKeyArgs',
    'StorageAccountArgs',
    'TokenClaimArgs',
    'VideoAnalyzerIdentityArgs',
]

@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'AccountEncryptionKeyType']],
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None):
        """
        Defines how the Video Analyzer account is (optionally) encrypted.
        :param pulumi.Input[Union[str, 'AccountEncryptionKeyType']] type: The type of key used to encrypt the Account Key.
        :param pulumi.Input['ResourceIdentityArgs'] identity: The Key Vault identity.
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: The properties of the key used to encrypt the account.
        """
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'AccountEncryptionKeyType']]:
        """
        The type of key used to encrypt the Account Key.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'AccountEncryptionKeyType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        The Key Vault identity.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        The properties of the key used to encrypt the account.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)


@pulumi.input_type
class EccTokenKeyArgs:
    def __init__(__self__, *,
                 alg: pulumi.Input[Union[str, 'AccessPolicyEccAlgo']],
                 kid: pulumi.Input[str],
                 type: pulumi.Input[str],
                 x: pulumi.Input[str],
                 y: pulumi.Input[str]):
        """
        Required validation properties for tokens generated with Elliptical Curve algorithm.
        :param pulumi.Input[Union[str, 'AccessPolicyEccAlgo']] alg: Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        :param pulumi.Input[str] kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        :param pulumi.Input[str] x: X coordinate.
        :param pulumi.Input[str] y: Y coordinate.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.EccTokenKey')
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def alg(self) -> pulumi.Input[Union[str, 'AccessPolicyEccAlgo']]:
        """
        Elliptical curve algorithm to be used: ES256, ES384 or ES512.
        """
        return pulumi.get(self, "alg")

    @alg.setter
    def alg(self, value: pulumi.Input[Union[str, 'AccessPolicyEccAlgo']]):
        pulumi.set(self, "alg", value)

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Input[str]:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: pulumi.Input[str]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.EccTokenKey'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def x(self) -> pulumi.Input[str]:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: pulumi.Input[str]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def y(self) -> pulumi.Input[str]:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: pulumi.Input[str]):
        pulumi.set(self, "y", value)


@pulumi.input_type
class JwtAuthenticationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 claims: Optional[pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]]] = None,
                 issuers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]]] = None):
        """
        Properties for access validation based on JSON Web Tokens (JWT).
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audiences: List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        :param pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]] claims: List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] issuers: List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]] keys: List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.JwtAuthentication')
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if issuers is not None:
            pulumi.set(__self__, "issuers", issuers)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.JwtAuthentication'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of expected token audiences. Token audience is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audiences", value)

    @property
    @pulumi.getter
    def claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]]]:
        """
        List of additional token claims to be validated. Token must contains all claims and respective values for it to be valid.
        """
        return pulumi.get(self, "claims")

    @claims.setter
    def claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenClaimArgs']]]]):
        pulumi.set(self, "claims", value)

    @property
    @pulumi.getter
    def issuers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of expected token issuers. Token issuer is valid if it matches at least one of the given values.
        """
        return pulumi.get(self, "issuers")

    @issuers.setter
    def issuers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "issuers", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]]]:
        """
        List of keys which can be used to validate access tokens. Having multiple keys allow for seamless key rotation of the token signing key. Token signature must match exactly one key.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EccTokenKeyArgs', 'RsaTokenKeyArgs']]]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: pulumi.Input[str]):
        """
        The details for accessing the encryption keys in Key Vault.
        :param pulumi.Input[str] key_identifier: The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> pulumi.Input[str]:
        """
        The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_identifier", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 user_assigned_identity: pulumi.Input[str]):
        """
        The user assigned managed identity to use when accessing a resource.
        :param pulumi.Input[str] user_assigned_identity: The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> pulumi.Input[str]:
        """
        The user assigned managed identity's resource identifier to use when accessing a resource.
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class RsaTokenKeyArgs:
    def __init__(__self__, *,
                 alg: pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']],
                 e: pulumi.Input[str],
                 kid: pulumi.Input[str],
                 n: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Required validation properties for tokens generated with RSA algorithm.
        :param pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']] alg: RSA algorithm to be used: RS256, RS384 or RS512.
        :param pulumi.Input[str] e: RSA public key exponent.
        :param pulumi.Input[str] kid: JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        :param pulumi.Input[str] n: RSA public key modulus.
        :param pulumi.Input[str] type: The discriminator for derived types.
               Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "e", e)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "n", n)
        pulumi.set(__self__, "type", '#Microsoft.VideoAnalyzer.RsaTokenKey')

    @property
    @pulumi.getter
    def alg(self) -> pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']]:
        """
        RSA algorithm to be used: RS256, RS384 or RS512.
        """
        return pulumi.get(self, "alg")

    @alg.setter
    def alg(self, value: pulumi.Input[Union[str, 'AccessPolicyRsaAlgo']]):
        pulumi.set(self, "alg", value)

    @property
    @pulumi.getter
    def e(self) -> pulumi.Input[str]:
        """
        RSA public key exponent.
        """
        return pulumi.get(self, "e")

    @e.setter
    def e(self, value: pulumi.Input[str]):
        pulumi.set(self, "e", value)

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Input[str]:
        """
        JWT token key id. Validation keys are looked up based on the key id present on the JWT token header.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: pulumi.Input[str]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def n(self) -> pulumi.Input[str]:
        """
        RSA public key modulus.
        """
        return pulumi.get(self, "n")

    @n.setter
    def n(self, value: pulumi.Input[str]):
        pulumi.set(self, "n", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.VideoAnalyzer.RsaTokenKey'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['ResourceIdentityArgs']] = None):
        """
        The details about the associated storage account.
        :param pulumi.Input[str] id: The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        :param pulumi.Input['ResourceIdentityArgs'] identity: A managed identity that Video Analyzer will use to access the storage account.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the storage account resource. Video Analyzer relies on tables, queues, and blobs. The primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceIdentityArgs']]:
        """
        A managed identity that Video Analyzer will use to access the storage account.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceIdentityArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class TokenClaimArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Properties for expected token claims.
        :param pulumi.Input[str] name: Name of the claim which must be present on the token.
        :param pulumi.Input[str] value: Expected value of the claim to be present on the token.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the claim which must be present on the token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Expected value of the claim to be present on the token.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class VideoAnalyzerIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The managed identity for the Video Analyzer resource.
        :param pulumi.Input[str] type: The identity type.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The User Assigned Managed Identities.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The User Assigned Managed Identities.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


