# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'EnvironmentStateDetailsResponse',
    'EnvironmentStatusResponse',
    'IngressEnvironmentStatusResponse',
    'PartitionKeyPropertyResponse',
    'ReferenceDataSetKeyPropertyResponse',
    'SkuResponse',
]

@pulumi.output_type
class EnvironmentStateDetailsResponse(dict):
    """
    An object that contains the details about an environment's state.
    """
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        An object that contains the details about an environment's state.
        :param str code: Contains the code that represents the reason of an environment being in a particular state. Can be used to programmatically handle specific cases.
        :param str message: A message that describes the state in detail.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Contains the code that represents the reason of an environment being in a particular state. Can be used to programmatically handle specific cases.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A message that describes the state in detail.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class EnvironmentStatusResponse(dict):
    """
    An object that represents the status of the environment, and its internal state in the Time Series Insights service.
    """
    def __init__(__self__, *,
                 ingress: 'outputs.IngressEnvironmentStatusResponse'):
        """
        An object that represents the status of the environment, and its internal state in the Time Series Insights service.
        :param 'IngressEnvironmentStatusResponse' ingress: An object that represents the status of ingress on an environment.
        """
        pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> 'outputs.IngressEnvironmentStatusResponse':
        """
        An object that represents the status of ingress on an environment.
        """
        return pulumi.get(self, "ingress")


@pulumi.output_type
class IngressEnvironmentStatusResponse(dict):
    """
    An object that represents the status of ingress on an environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateDetails":
            suggest = "state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressEnvironmentStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressEnvironmentStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressEnvironmentStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state_details: 'outputs.EnvironmentStateDetailsResponse',
                 state: Optional[str] = None):
        """
        An object that represents the status of ingress on an environment.
        :param 'EnvironmentStateDetailsResponse' state_details: An object that contains the details about an environment's state.
        :param str state: This string represents the state of ingress operations on an environment. It can be "Disabled", "Ready", "Running", "Paused" or "Unknown"
        """
        pulumi.set(__self__, "state_details", state_details)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> 'outputs.EnvironmentStateDetailsResponse':
        """
        An object that contains the details about an environment's state.
        """
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        This string represents the state of ingress operations on an environment. It can be "Disabled", "Ready", "Running", "Paused" or "Unknown"
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PartitionKeyPropertyResponse(dict):
    """
    The structure of the property that a partition key can have. An environment can have multiple such properties.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The structure of the property that a partition key can have. An environment can have multiple such properties.
        :param str name: The name of the property.
        :param str type: The type of the property.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the property.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReferenceDataSetKeyPropertyResponse(dict):
    """
    A key property for the reference data set. A reference data set can have multiple key properties.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        A key property for the reference data set. A reference data set can have multiple key properties.
        :param str name: The name of the key property.
        :param str type: The type of the key property.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the key property.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the key property.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SkuResponse(dict):
    """
    The sku determines the capacity of the environment, the SLA (in queries-per-minute and total capacity), and the billing rate.
    """
    def __init__(__self__, *,
                 capacity: int,
                 name: str):
        """
        The sku determines the capacity of the environment, the SLA (in queries-per-minute and total capacity), and the billing rate.
        :param int capacity: The capacity of the sku. This value can be changed to support scale out of environments after they have been created.
        :param str name: The name of this SKU.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> int:
        """
        The capacity of the sku. This value can be changed to support scale out of environments after they have been created.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this SKU.
        """
        return pulumi.get(self, "name")


