# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SqlPoolVulnerabilityAssessmentRuleBaselineArgs', 'SqlPoolVulnerabilityAssessmentRuleBaseline']

@pulumi.input_type
class SqlPoolVulnerabilityAssessmentRuleBaselineArgs:
    def __init__(__self__, *,
                 baseline_results: pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]],
                 resource_group_name: pulumi.Input[str],
                 rule_id: pulumi.Input[str],
                 sql_pool_name: pulumi.Input[str],
                 vulnerability_assessment_name: pulumi.Input[str],
                 workspace_name: pulumi.Input[str],
                 baseline_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SqlPoolVulnerabilityAssessmentRuleBaseline resource.
        :param pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]] baseline_results: The rule baseline result
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] rule_id: The vulnerability assessment rule ID.
        :param pulumi.Input[str] sql_pool_name: SQL pool name
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        :param pulumi.Input[str] workspace_name: The name of the workspace
        :param pulumi.Input[str] baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule).
        """
        pulumi.set(__self__, "baseline_results", baseline_results)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "sql_pool_name", sql_pool_name)
        pulumi.set(__self__, "vulnerability_assessment_name", vulnerability_assessment_name)
        pulumi.set(__self__, "workspace_name", workspace_name)
        if baseline_name is not None:
            pulumi.set(__self__, "baseline_name", baseline_name)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "baseline_results")

    @baseline_results.setter
    def baseline_results(self, value: pulumi.Input[Sequence[pulumi.Input['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]]):
        pulumi.set(self, "baseline_results", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        The vulnerability assessment rule ID.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="sqlPoolName")
    def sql_pool_name(self) -> pulumi.Input[str]:
        """
        SQL pool name
        """
        return pulumi.get(self, "sql_pool_name")

    @sql_pool_name.setter
    def sql_pool_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sql_pool_name", value)

    @property
    @pulumi.getter(name="vulnerabilityAssessmentName")
    def vulnerability_assessment_name(self) -> pulumi.Input[str]:
        """
        The name of the vulnerability assessment.
        """
        return pulumi.get(self, "vulnerability_assessment_name")

    @vulnerability_assessment_name.setter
    def vulnerability_assessment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vulnerability_assessment_name", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> pulumi.Input[str]:
        """
        The name of the workspace
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_name", value)

    @property
    @pulumi.getter(name="baselineName")
    def baseline_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule).
        """
        return pulumi.get(self, "baseline_name")

    @baseline_name.setter
    def baseline_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_name", value)


class SqlPoolVulnerabilityAssessmentRuleBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 sql_pool_name: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Sql pool vulnerability assessment rule baseline.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for workspace level rule).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]]] baseline_results: The rule baseline result
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] rule_id: The vulnerability assessment rule ID.
        :param pulumi.Input[str] sql_pool_name: SQL pool name
        :param pulumi.Input[str] vulnerability_assessment_name: The name of the vulnerability assessment.
        :param pulumi.Input[str] workspace_name: The name of the workspace
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlPoolVulnerabilityAssessmentRuleBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Sql pool vulnerability assessment rule baseline.

        :param str resource_name: The name of the resource.
        :param SqlPoolVulnerabilityAssessmentRuleBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlPoolVulnerabilityAssessmentRuleBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_name: Optional[pulumi.Input[str]] = None,
                 baseline_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 sql_pool_name: Optional[pulumi.Input[str]] = None,
                 vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlPoolVulnerabilityAssessmentRuleBaselineArgs.__new__(SqlPoolVulnerabilityAssessmentRuleBaselineArgs)

            __props__.__dict__["baseline_name"] = baseline_name
            if baseline_results is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_results'")
            __props__.__dict__["baseline_results"] = baseline_results
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
            if sql_pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'sql_pool_name'")
            __props__.__dict__["sql_pool_name"] = sql_pool_name
            if vulnerability_assessment_name is None and not opts.urn:
                raise TypeError("Missing required property 'vulnerability_assessment_name'")
            __props__.__dict__["vulnerability_assessment_name"] = vulnerability_assessment_name
            if workspace_name is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_name'")
            __props__.__dict__["workspace_name"] = workspace_name
            __props__.__dict__["name"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:synapse/v20210301:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse/v20190601preview:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse/v20190601preview:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse/v20201201:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse/v20201201:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse/v20210401preview:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse/v20210401preview:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse/v20210501:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse/v20210501:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse/v20210601:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse/v20210601:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-native:synapse/v20210601preview:SqlPoolVulnerabilityAssessmentRuleBaseline"), pulumi.Alias(type_="azure-nextgen:synapse/v20210601preview:SqlPoolVulnerabilityAssessmentRuleBaseline")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SqlPoolVulnerabilityAssessmentRuleBaseline, __self__).__init__(
            'azure-native:synapse/v20210301:SqlPoolVulnerabilityAssessmentRuleBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SqlPoolVulnerabilityAssessmentRuleBaseline':
        """
        Get an existing SqlPoolVulnerabilityAssessmentRuleBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SqlPoolVulnerabilityAssessmentRuleBaselineArgs.__new__(SqlPoolVulnerabilityAssessmentRuleBaselineArgs)

        __props__.__dict__["baseline_results"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["type"] = None
        return SqlPoolVulnerabilityAssessmentRuleBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> pulumi.Output[Sequence['outputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse']]:
        """
        The rule baseline result
        """
        return pulumi.get(self, "baseline_results")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

