# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = ['StorageSyncServiceArgs', 'StorageSyncService']

@pulumi.input_type
class StorageSyncServiceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 incoming_traffic_policy: Optional[pulumi.Input[Union[str, 'IncomingTrafficPolicy']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 storage_sync_service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a StorageSyncService resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Union[str, 'IncomingTrafficPolicy']] incoming_traffic_policy: Incoming Traffic Policy
        :param pulumi.Input[str] location: Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
        :param pulumi.Input[str] storage_sync_service_name: Name of Storage Sync Service resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if incoming_traffic_policy is not None:
            pulumi.set(__self__, "incoming_traffic_policy", incoming_traffic_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if storage_sync_service_name is not None:
            pulumi.set(__self__, "storage_sync_service_name", storage_sync_service_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="incomingTrafficPolicy")
    def incoming_traffic_policy(self) -> Optional[pulumi.Input[Union[str, 'IncomingTrafficPolicy']]]:
        """
        Incoming Traffic Policy
        """
        return pulumi.get(self, "incoming_traffic_policy")

    @incoming_traffic_policy.setter
    def incoming_traffic_policy(self, value: Optional[pulumi.Input[Union[str, 'IncomingTrafficPolicy']]]):
        pulumi.set(self, "incoming_traffic_policy", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="storageSyncServiceName")
    def storage_sync_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Storage Sync Service resource.
        """
        return pulumi.get(self, "storage_sync_service_name")

    @storage_sync_service_name.setter
    def storage_sync_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_sync_service_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class StorageSyncService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 incoming_traffic_policy: Optional[pulumi.Input[Union[str, 'IncomingTrafficPolicy']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 storage_sync_service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Storage Sync Service object.
        API Version: 2020-03-01.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[str, 'IncomingTrafficPolicy']] incoming_traffic_policy: Incoming Traffic Policy
        :param pulumi.Input[str] location: Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] storage_sync_service_name: Name of Storage Sync Service resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageSyncServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Storage Sync Service object.
        API Version: 2020-03-01.

        :param str resource_name: The name of the resource.
        :param StorageSyncServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageSyncServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 incoming_traffic_policy: Optional[pulumi.Input[Union[str, 'IncomingTrafficPolicy']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 storage_sync_service_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageSyncServiceArgs.__new__(StorageSyncServiceArgs)

            __props__.__dict__["incoming_traffic_policy"] = incoming_traffic_policy
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["storage_sync_service_name"] = storage_sync_service_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["last_operation_name"] = None
            __props__.__dict__["last_workflow_id"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["private_endpoint_connections"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["storage_sync_service_status"] = None
            __props__.__dict__["storage_sync_service_uid"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:storagesync:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20170605preview:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20170605preview:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20180402:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20180402:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20180701:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20180701:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20181001:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20181001:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20190201:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20190201:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20190301:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20190301:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20190601:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20190601:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20191001:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20191001:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20200301:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20200301:StorageSyncService"), pulumi.Alias(type_="azure-native:storagesync/v20200901:StorageSyncService"), pulumi.Alias(type_="azure-nextgen:storagesync/v20200901:StorageSyncService")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(StorageSyncService, __self__).__init__(
            'azure-native:storagesync:StorageSyncService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StorageSyncService':
        """
        Get an existing StorageSyncService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StorageSyncServiceArgs.__new__(StorageSyncServiceArgs)

        __props__.__dict__["incoming_traffic_policy"] = None
        __props__.__dict__["last_operation_name"] = None
        __props__.__dict__["last_workflow_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["private_endpoint_connections"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["storage_sync_service_status"] = None
        __props__.__dict__["storage_sync_service_uid"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return StorageSyncService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="incomingTrafficPolicy")
    def incoming_traffic_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Incoming Traffic Policy
        """
        return pulumi.get(self, "incoming_traffic_policy")

    @property
    @pulumi.getter(name="lastOperationName")
    def last_operation_name(self) -> pulumi.Output[str]:
        """
        Resource Last Operation Name
        """
        return pulumi.get(self, "last_operation_name")

    @property
    @pulumi.getter(name="lastWorkflowId")
    def last_workflow_id(self) -> pulumi.Output[str]:
        """
        StorageSyncService lastWorkflowId
        """
        return pulumi.get(self, "last_workflow_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> pulumi.Output[Sequence['outputs.PrivateEndpointConnectionResponse']]:
        """
        List of private endpoint connection associated with the specified storage sync service
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        StorageSyncService Provisioning State
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="storageSyncServiceStatus")
    def storage_sync_service_status(self) -> pulumi.Output[int]:
        """
        Storage Sync service status.
        """
        return pulumi.get(self, "storage_sync_service_status")

    @property
    @pulumi.getter(name="storageSyncServiceUid")
    def storage_sync_service_uid(self) -> pulumi.Output[str]:
        """
        Storage Sync service Uid
        """
        return pulumi.get(self, "storage_sync_service_uid")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

