# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ResourceSkuArgs',
    'SignalRCorsSettingsArgs',
    'SignalRCreateOrUpdatePropertiesArgs',
    'SignalRFeatureArgs',
]

@pulumi.input_type
class ResourceSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'SignalRSkuTier']]] = None):
        """
        The billing information of the SignalR resource.
        :param pulumi.Input[str] name: The name of the SKU. Required.
               
               Allowed values: Standard_S1, Free_F1
        :param pulumi.Input[int] capacity: Optional, integer. The unit count of SignalR resource. 1 by default.
               
               If present, following values are allowed:
                   Free: 1
                   Standard: 1,2,5,10,20,50,100
        :param pulumi.Input[str] family: Optional string. For future use.
        :param pulumi.Input[str] size: Optional string. For future use.
        :param pulumi.Input[Union[str, 'SignalRSkuTier']] tier: Optional tier of this particular SKU. 'Standard' or 'Free'. 
               
               `Basic` is deprecated, use `Standard` instead.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU. Required.
        
        Allowed values: Standard_S1, Free_F1
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Optional, integer. The unit count of SignalR resource. 1 by default.
        
        If present, following values are allowed:
            Free: 1
            Standard: 1,2,5,10,20,50,100
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        Optional string. For future use.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Optional string. For future use.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'SignalRSkuTier']]]:
        """
        Optional tier of this particular SKU. 'Standard' or 'Free'. 
        
        `Basic` is deprecated, use `Standard` instead.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'SignalRSkuTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SignalRCorsSettingsArgs:
    def __init__(__self__, *,
                 allowed_origins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Cross-Origin Resource Sharing (CORS) settings.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
        """
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345). Use "*" to allow all. If omitted, allow all by default.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_origins", value)


@pulumi.input_type
class SignalRCreateOrUpdatePropertiesArgs:
    def __init__(__self__, *,
                 cors: Optional[pulumi.Input['SignalRCorsSettingsArgs']] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input['SignalRFeatureArgs']]]] = None,
                 host_name_prefix: Optional[pulumi.Input[str]] = None):
        """
        Settings used to provision or configure the resource.
        :param pulumi.Input['SignalRCorsSettingsArgs'] cors: Cross-Origin Resource Sharing (CORS) settings.
        :param pulumi.Input[Sequence[pulumi.Input['SignalRFeatureArgs']]] features: List of SignalR featureFlags. e.g. ServiceMode.
               
               FeatureFlags that are not included in the parameters for the update operation will not be modified.
               And the response will only include featureFlags that are explicitly set. 
               When a featureFlag is not explicitly set, SignalR service will use its globally default value. 
               But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
        :param pulumi.Input[str] host_name_prefix: Prefix for the hostName of the SignalR service. Retained for future use.
               The hostname will be of format: &lt;hostNamePrefix&gt;.service.signalr.net.
        """
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if host_name_prefix is not None:
            pulumi.set(__self__, "host_name_prefix", host_name_prefix)

    @property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['SignalRCorsSettingsArgs']]:
        """
        Cross-Origin Resource Sharing (CORS) settings.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['SignalRCorsSettingsArgs']]):
        pulumi.set(self, "cors", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SignalRFeatureArgs']]]]:
        """
        List of SignalR featureFlags. e.g. ServiceMode.
        
        FeatureFlags that are not included in the parameters for the update operation will not be modified.
        And the response will only include featureFlags that are explicitly set. 
        When a featureFlag is not explicitly set, SignalR service will use its globally default value. 
        But keep in mind, the default value doesn't mean "false". It varies in terms of different FeatureFlags.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SignalRFeatureArgs']]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix for the hostName of the SignalR service. Retained for future use.
        The hostname will be of format: &lt;hostNamePrefix&gt;.service.signalr.net.
        """
        return pulumi.get(self, "host_name_prefix")

    @host_name_prefix.setter
    def host_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name_prefix", value)


@pulumi.input_type
class SignalRFeatureArgs:
    def __init__(__self__, *,
                 flag: pulumi.Input[Union[str, 'FeatureFlags']],
                 value: pulumi.Input[str],
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Feature of a SignalR resource, which controls the SignalR runtime behavior.
        :param pulumi.Input[Union[str, 'FeatureFlags']] flag: FeatureFlags is the supported features of Azure SignalR service.
               - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
               - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        :param pulumi.Input[str] value: Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Optional properties related to this feature.
        """
        pulumi.set(__self__, "flag", flag)
        pulumi.set(__self__, "value", value)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def flag(self) -> pulumi.Input[Union[str, 'FeatureFlags']]:
        """
        FeatureFlags is the supported features of Azure SignalR service.
        - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
        - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        """
        return pulumi.get(self, "flag")

    @flag.setter
    def flag(self, value: pulumi.Input[Union[str, 'FeatureFlags']]):
        pulumi.set(self, "flag", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional properties related to this feature.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


