# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['SecretValueArgs', 'SecretValue']

@pulumi.input_type
class SecretValueArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 secret_resource_name: pulumi.Input[str],
                 location: Optional[pulumi.Input[str]] = None,
                 secret_value_resource_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretValue resource.
        :param pulumi.Input[str] resource_group_name: Azure resource group name
        :param pulumi.Input[str] secret_resource_name: The name of the secret resource.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] secret_value_resource_name: The name of the secret resource value which is typically the version identifier for the value.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] value: The actual value of the secret.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "secret_resource_name", secret_resource_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if secret_value_resource_name is not None:
            pulumi.set(__self__, "secret_value_resource_name", secret_value_resource_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        Azure resource group name
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secretResourceName")
    def secret_resource_name(self) -> pulumi.Input[str]:
        """
        The name of the secret resource.
        """
        return pulumi.get(self, "secret_resource_name")

    @secret_resource_name.setter
    def secret_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_resource_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="secretValueResourceName")
    def secret_value_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the secret resource value which is typically the version identifier for the value.
        """
        return pulumi.get(self, "secret_value_resource_name")

    @secret_value_resource_name.setter
    def secret_value_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_value_resource_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The actual value of the secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


class SecretValue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 secret_resource_name: Optional[pulumi.Input[str]] = None,
                 secret_value_resource_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] resource_group_name: Azure resource group name
        :param pulumi.Input[str] secret_resource_name: The name of the secret resource.
        :param pulumi.Input[str] secret_value_resource_name: The name of the secret resource value which is typically the version identifier for the value.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] value: The actual value of the secret.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretValueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.

        :param str resource_name: The name of the resource.
        :param SecretValueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretValueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 secret_resource_name: Optional[pulumi.Input[str]] = None,
                 secret_value_resource_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretValueArgs.__new__(SecretValueArgs)

            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if secret_resource_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_resource_name'")
            __props__.__dict__["secret_resource_name"] = secret_resource_name
            __props__.__dict__["secret_value_resource_name"] = secret_value_resource_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["value"] = value
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:servicefabricmesh/v20180901preview:SecretValue"), pulumi.Alias(type_="azure-native:servicefabricmesh:SecretValue"), pulumi.Alias(type_="azure-nextgen:servicefabricmesh:SecretValue")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(SecretValue, __self__).__init__(
            'azure-native:servicefabricmesh/v20180901preview:SecretValue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SecretValue':
        """
        Get an existing SecretValue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SecretValueArgs.__new__(SecretValueArgs)

        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["value"] = None
        return SecretValue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        State of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[str]]:
        """
        The actual value of the secret.
        """
        return pulumi.get(self, "value")

