# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationDeltaHealthPolicyResponse',
    'ApplicationHealthPolicyResponse',
    'ApplicationMetricDescriptionResponse',
    'ApplicationTypeVersionsCleanupPolicyResponse',
    'ApplicationUpgradePolicyResponse',
    'ApplicationUserAssignedIdentityResponse',
    'ArmApplicationHealthPolicyResponse',
    'ArmRollingUpgradeMonitoringPolicyResponse',
    'ArmServiceTypeHealthPolicyResponse',
    'AzureActiveDirectoryResponse',
    'CertificateDescriptionResponse',
    'ClientCertificateCommonNameResponse',
    'ClientCertificateThumbprintResponse',
    'ClusterHealthPolicyResponse',
    'ClusterUpgradeDeltaHealthPolicyResponse',
    'ClusterUpgradePolicyResponse',
    'ClusterVersionDetailsResponse',
    'DiagnosticsStorageAccountConfigResponse',
    'EndpointRangeDescriptionResponse',
    'ManagedIdentityResponse',
    'NamedPartitionSchemeDescriptionResponse',
    'NodeTypeDescriptionResponse',
    'ServerCertificateCommonNameResponse',
    'ServerCertificateCommonNamesResponse',
    'ServiceCorrelationDescriptionResponse',
    'ServiceLoadMetricDescriptionResponse',
    'ServicePlacementPolicyDescriptionResponse',
    'ServiceTypeDeltaHealthPolicyResponse',
    'ServiceTypeHealthPolicyResponse',
    'SettingsParameterDescriptionResponse',
    'SettingsSectionDescriptionResponse',
    'SingletonPartitionSchemeDescriptionResponse',
    'UniformInt64RangePartitionSchemeDescriptionResponse',
    'UserAssignedIdentityResponse',
]

@pulumi.output_type
class ApplicationDeltaHealthPolicyResponse(dict):
    """
    Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultServiceTypeDeltaHealthPolicy":
            suggest = "default_service_type_delta_health_policy"
        elif key == "serviceTypeDeltaHealthPolicies":
            suggest = "service_type_delta_health_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_service_type_delta_health_policy: Optional['outputs.ServiceTypeDeltaHealthPolicyResponse'] = None,
                 service_type_delta_health_policies: Optional[Mapping[str, 'outputs.ServiceTypeDeltaHealthPolicyResponse']] = None):
        """
        Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.

        :param 'ServiceTypeDeltaHealthPolicyResponse' default_service_type_delta_health_policy: The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        :param Mapping[str, 'ServiceTypeDeltaHealthPolicyResponse'] service_type_delta_health_policies: The map with service type delta health policy per service type name. The map is empty by default.
        """
        if default_service_type_delta_health_policy is not None:
            pulumi.set(__self__, "default_service_type_delta_health_policy", default_service_type_delta_health_policy)
        if service_type_delta_health_policies is not None:
            pulumi.set(__self__, "service_type_delta_health_policies", service_type_delta_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeDeltaHealthPolicy")
    def default_service_type_delta_health_policy(self) -> Optional['outputs.ServiceTypeDeltaHealthPolicyResponse']:
        """
        The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        """
        return pulumi.get(self, "default_service_type_delta_health_policy")

    @property
    @pulumi.getter(name="serviceTypeDeltaHealthPolicies")
    def service_type_delta_health_policies(self) -> Optional[Mapping[str, 'outputs.ServiceTypeDeltaHealthPolicyResponse']]:
        """
        The map with service type delta health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_delta_health_policies")


@pulumi.output_type
class ApplicationHealthPolicyResponse(dict):
    """
    Defines a health policy used to evaluate the health of an application or one of its children entities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultServiceTypeHealthPolicy":
            suggest = "default_service_type_health_policy"
        elif key == "serviceTypeHealthPolicies":
            suggest = "service_type_health_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_service_type_health_policy: Optional['outputs.ServiceTypeHealthPolicyResponse'] = None,
                 service_type_health_policies: Optional[Mapping[str, 'outputs.ServiceTypeHealthPolicyResponse']] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param 'ServiceTypeHealthPolicyResponse' default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param Mapping[str, 'ServiceTypeHealthPolicyResponse'] service_type_health_policies: The map with service type health policy per service type name. The map is empty by default.
        """
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if service_type_health_policies is not None:
            pulumi.set(__self__, "service_type_health_policies", service_type_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional['outputs.ServiceTypeHealthPolicyResponse']:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @property
    @pulumi.getter(name="serviceTypeHealthPolicies")
    def service_type_health_policies(self) -> Optional[Mapping[str, 'outputs.ServiceTypeHealthPolicyResponse']]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policies")


@pulumi.output_type
class ApplicationMetricDescriptionResponse(dict):
    """
    Describes capacity information for a custom resource balancing metric. This can be used to limit the total consumption of this metric by the services of this application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumCapacity":
            suggest = "maximum_capacity"
        elif key == "reservationCapacity":
            suggest = "reservation_capacity"
        elif key == "totalApplicationCapacity":
            suggest = "total_application_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationMetricDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationMetricDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationMetricDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_capacity: Optional[float] = None,
                 name: Optional[str] = None,
                 reservation_capacity: Optional[float] = None,
                 total_application_capacity: Optional[float] = None):
        """
        Describes capacity information for a custom resource balancing metric. This can be used to limit the total consumption of this metric by the services of this application.

        :param float maximum_capacity: The maximum node capacity for Service Fabric application.
               This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
               If set to zero, capacity for this metric is unlimited on each node.
               When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
               When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
        :param str name: The name of the metric.
        :param float reservation_capacity: The node reservation capacity for Service Fabric application.
               This is the amount of load which is reserved on nodes which have instances of this application.
               If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
               If set to zero, no capacity is reserved for this metric.
               When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
        :param float total_application_capacity: The total metric capacity for Service Fabric application.
               This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
               When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
        """
        if maximum_capacity is not None:
            pulumi.set(__self__, "maximum_capacity", maximum_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reservation_capacity is not None:
            pulumi.set(__self__, "reservation_capacity", reservation_capacity)
        if total_application_capacity is not None:
            pulumi.set(__self__, "total_application_capacity", total_application_capacity)

    @property
    @pulumi.getter(name="maximumCapacity")
    def maximum_capacity(self) -> Optional[float]:
        """
        The maximum node capacity for Service Fabric application.
        This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
        If set to zero, capacity for this metric is unlimited on each node.
        When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
        When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
        """
        return pulumi.get(self, "maximum_capacity")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reservationCapacity")
    def reservation_capacity(self) -> Optional[float]:
        """
        The node reservation capacity for Service Fabric application.
        This is the amount of load which is reserved on nodes which have instances of this application.
        If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
        If set to zero, no capacity is reserved for this metric.
        When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
        """
        return pulumi.get(self, "reservation_capacity")

    @property
    @pulumi.getter(name="totalApplicationCapacity")
    def total_application_capacity(self) -> Optional[float]:
        """
        The total metric capacity for Service Fabric application.
        This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
        When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
        """
        return pulumi.get(self, "total_application_capacity")


@pulumi.output_type
class ApplicationTypeVersionsCleanupPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnusedVersionsToKeep":
            suggest = "max_unused_versions_to_keep"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationTypeVersionsCleanupPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationTypeVersionsCleanupPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationTypeVersionsCleanupPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unused_versions_to_keep: float):
        """
        :param float max_unused_versions_to_keep: Number of unused versions per application type to keep.
        """
        pulumi.set(__self__, "max_unused_versions_to_keep", max_unused_versions_to_keep)

    @property
    @pulumi.getter(name="maxUnusedVersionsToKeep")
    def max_unused_versions_to_keep(self) -> float:
        """
        Number of unused versions per application type to keep.
        """
        return pulumi.get(self, "max_unused_versions_to_keep")


@pulumi.output_type
class ApplicationUpgradePolicyResponse(dict):
    """
    Describes the policy for a monitored application upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationHealthPolicy":
            suggest = "application_health_policy"
        elif key == "forceRestart":
            suggest = "force_restart"
        elif key == "recreateApplication":
            suggest = "recreate_application"
        elif key == "rollingUpgradeMonitoringPolicy":
            suggest = "rolling_upgrade_monitoring_policy"
        elif key == "upgradeMode":
            suggest = "upgrade_mode"
        elif key == "upgradeReplicaSetCheckTimeout":
            suggest = "upgrade_replica_set_check_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_health_policy: Optional['outputs.ArmApplicationHealthPolicyResponse'] = None,
                 force_restart: Optional[bool] = None,
                 recreate_application: Optional[bool] = None,
                 rolling_upgrade_monitoring_policy: Optional['outputs.ArmRollingUpgradeMonitoringPolicyResponse'] = None,
                 upgrade_mode: Optional[str] = None,
                 upgrade_replica_set_check_timeout: Optional[str] = None):
        """
        Describes the policy for a monitored application upgrade.
        :param 'ArmApplicationHealthPolicyResponse' application_health_policy: Defines a health policy used to evaluate the health of an application or one of its children entities.
        :param bool force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        :param bool recreate_application: Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed and it will result in availability loss.
        :param 'ArmRollingUpgradeMonitoringPolicyResponse' rolling_upgrade_monitoring_policy: The policy used for monitoring the application upgrade
        :param str upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored.
        :param str upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
        """
        if application_health_policy is not None:
            pulumi.set(__self__, "application_health_policy", application_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)
        if recreate_application is not None:
            pulumi.set(__self__, "recreate_application", recreate_application)
        if rolling_upgrade_monitoring_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_monitoring_policy", rolling_upgrade_monitoring_policy)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if upgrade_replica_set_check_timeout is not None:
            pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)

    @property
    @pulumi.getter(name="applicationHealthPolicy")
    def application_health_policy(self) -> Optional['outputs.ArmApplicationHealthPolicyResponse']:
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policy")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[bool]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="recreateApplication")
    def recreate_application(self) -> Optional[bool]:
        """
        Determines whether the application should be recreated on update. If value=true, the rest of the upgrade policy parameters are not allowed and it will result in availability loss.
        """
        return pulumi.get(self, "recreate_application")

    @property
    @pulumi.getter(name="rollingUpgradeMonitoringPolicy")
    def rolling_upgrade_monitoring_policy(self) -> Optional['outputs.ArmRollingUpgradeMonitoringPolicyResponse']:
        """
        The policy used for monitoring the application upgrade
        """
        return pulumi.get(self, "rolling_upgrade_monitoring_policy")

    @property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[str]:
        """
        The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto, UnmonitoredManual, and Monitored.
        """
        return pulumi.get(self, "upgrade_mode")

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> Optional[str]:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned 32-bit integer).
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")


@pulumi.output_type
class ApplicationUserAssignedIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationUserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationUserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationUserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 principal_id: str):
        """
        :param str name: The friendly name of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The friendly name of user assigned identity.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class ArmApplicationHealthPolicyResponse(dict):
    """
    Defines a health policy used to evaluate the health of an application or one of its children entities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "considerWarningAsError":
            suggest = "consider_warning_as_error"
        elif key == "defaultServiceTypeHealthPolicy":
            suggest = "default_service_type_health_policy"
        elif key == "maxPercentUnhealthyDeployedApplications":
            suggest = "max_percent_unhealthy_deployed_applications"
        elif key == "serviceTypeHealthPolicyMap":
            suggest = "service_type_health_policy_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmApplicationHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmApplicationHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmApplicationHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consider_warning_as_error: Optional[bool] = None,
                 default_service_type_health_policy: Optional['outputs.ArmServiceTypeHealthPolicyResponse'] = None,
                 max_percent_unhealthy_deployed_applications: Optional[int] = None,
                 service_type_health_policy_map: Optional[Mapping[str, 'outputs.ArmServiceTypeHealthPolicyResponse']] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param bool consider_warning_as_error: Indicates whether warnings are treated with the same severity as errors.
        :param 'ArmServiceTypeHealthPolicyResponse' default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param int max_percent_unhealthy_deployed_applications: The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
               The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
               This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
        :param Mapping[str, 'ArmServiceTypeHealthPolicyResponse'] service_type_health_policy_map: The map with service type health policy per service type name. The map is empty by default.
        """
        if consider_warning_as_error is None:
            consider_warning_as_error = False
        if consider_warning_as_error is not None:
            pulumi.set(__self__, "consider_warning_as_error", consider_warning_as_error)
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if max_percent_unhealthy_deployed_applications is None:
            max_percent_unhealthy_deployed_applications = 0
        if max_percent_unhealthy_deployed_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_deployed_applications", max_percent_unhealthy_deployed_applications)
        if service_type_health_policy_map is not None:
            pulumi.set(__self__, "service_type_health_policy_map", service_type_health_policy_map)

    @property
    @pulumi.getter(name="considerWarningAsError")
    def consider_warning_as_error(self) -> Optional[bool]:
        """
        Indicates whether warnings are treated with the same severity as errors.
        """
        return pulumi.get(self, "consider_warning_as_error")

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional['outputs.ArmServiceTypeHealthPolicyResponse']:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @property
    @pulumi.getter(name="maxPercentUnhealthyDeployedApplications")
    def max_percent_unhealthy_deployed_applications(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
        The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
        This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_deployed_applications")

    @property
    @pulumi.getter(name="serviceTypeHealthPolicyMap")
    def service_type_health_policy_map(self) -> Optional[Mapping[str, 'outputs.ArmServiceTypeHealthPolicyResponse']]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policy_map")


@pulumi.output_type
class ArmRollingUpgradeMonitoringPolicyResponse(dict):
    """
    The policy used for monitoring the application upgrade
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureAction":
            suggest = "failure_action"
        elif key == "healthCheckRetryTimeout":
            suggest = "health_check_retry_timeout"
        elif key == "healthCheckStableDuration":
            suggest = "health_check_stable_duration"
        elif key == "healthCheckWaitDuration":
            suggest = "health_check_wait_duration"
        elif key == "upgradeDomainTimeout":
            suggest = "upgrade_domain_timeout"
        elif key == "upgradeTimeout":
            suggest = "upgrade_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmRollingUpgradeMonitoringPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmRollingUpgradeMonitoringPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmRollingUpgradeMonitoringPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_action: Optional[str] = None,
                 health_check_retry_timeout: Optional[str] = None,
                 health_check_stable_duration: Optional[str] = None,
                 health_check_wait_duration: Optional[str] = None,
                 upgrade_domain_timeout: Optional[str] = None,
                 upgrade_timeout: Optional[str] = None):
        """
        The policy used for monitoring the application upgrade
        :param str failure_action: The activation Mode of the service package
        :param str health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param str health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param str health_check_wait_duration: The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param str upgrade_domain_timeout: The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        :param str upgrade_timeout: The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if health_check_retry_timeout is not None:
            pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        if health_check_stable_duration is not None:
            pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        if health_check_wait_duration is not None:
            pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        if upgrade_domain_timeout is not None:
            pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        if upgrade_timeout is not None:
            pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[str]:
        """
        The activation Mode of the service package
        """
        return pulumi.get(self, "failure_action")

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> Optional[str]:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> Optional[str]:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> Optional[str]:
        """
        The amount of time to wait after completing an upgrade domain before applying health policies. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> Optional[str]:
        """
        The amount of time each upgrade domain has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> Optional[str]:
        """
        The amount of time the overall upgrade has to complete before FailureAction is executed. It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it is interpreted as a number representing the total number of milliseconds.
        """
        return pulumi.get(self, "upgrade_timeout")


@pulumi.output_type
class ArmServiceTypeHealthPolicyResponse(dict):
    """
    Represents the health policy used to evaluate the health of services belonging to a service type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentUnhealthyPartitionsPerService":
            suggest = "max_percent_unhealthy_partitions_per_service"
        elif key == "maxPercentUnhealthyReplicasPerPartition":
            suggest = "max_percent_unhealthy_replicas_per_partition"
        elif key == "maxPercentUnhealthyServices":
            suggest = "max_percent_unhealthy_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmServiceTypeHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmServiceTypeHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmServiceTypeHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_unhealthy_partitions_per_service: Optional[int] = None,
                 max_percent_unhealthy_replicas_per_partition: Optional[int] = None,
                 max_percent_unhealthy_services: Optional[int] = None):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param int max_percent_unhealthy_partitions_per_service: The maximum percentage of partitions per service allowed to be unhealthy before your application is considered in error.
        :param int max_percent_unhealthy_replicas_per_partition: The maximum percentage of replicas per partition allowed to be unhealthy before your application is considered in error.
        :param int max_percent_unhealthy_services: The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        if max_percent_unhealthy_partitions_per_service is None:
            max_percent_unhealthy_partitions_per_service = 0
        if max_percent_unhealthy_partitions_per_service is not None:
            pulumi.set(__self__, "max_percent_unhealthy_partitions_per_service", max_percent_unhealthy_partitions_per_service)
        if max_percent_unhealthy_replicas_per_partition is None:
            max_percent_unhealthy_replicas_per_partition = 0
        if max_percent_unhealthy_replicas_per_partition is not None:
            pulumi.set(__self__, "max_percent_unhealthy_replicas_per_partition", max_percent_unhealthy_replicas_per_partition)
        if max_percent_unhealthy_services is None:
            max_percent_unhealthy_services = 0
        if max_percent_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyPartitionsPerService")
    def max_percent_unhealthy_partitions_per_service(self) -> Optional[int]:
        """
        The maximum percentage of partitions per service allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_partitions_per_service")

    @property
    @pulumi.getter(name="maxPercentUnhealthyReplicasPerPartition")
    def max_percent_unhealthy_replicas_per_partition(self) -> Optional[int]:
        """
        The maximum percentage of replicas per partition allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_replicas_per_partition")

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> Optional[int]:
        """
        The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")


@pulumi.output_type
class AzureActiveDirectoryResponse(dict):
    """
    The settings to enable AAD authentication on the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientApplication":
            suggest = "client_application"
        elif key == "clusterApplication":
            suggest = "cluster_application"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_application: Optional[str] = None,
                 cluster_application: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        The settings to enable AAD authentication on the cluster.
        :param str client_application: Azure active directory client application id.
        :param str cluster_application: Azure active directory cluster application id.
        :param str tenant_id: Azure active directory tenant id.
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[str]:
        """
        Azure active directory client application id.
        """
        return pulumi.get(self, "client_application")

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[str]:
        """
        Azure active directory cluster application id.
        """
        return pulumi.get(self, "cluster_application")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Azure active directory tenant id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CertificateDescriptionResponse(dict):
    """
    Describes the certificate details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thumbprintSecondary":
            suggest = "thumbprint_secondary"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 thumbprint: str,
                 thumbprint_secondary: Optional[str] = None,
                 x509_store_name: Optional[str] = None):
        """
        Describes the certificate details.
        :param str thumbprint: Thumbprint of the primary certificate.
        :param str thumbprint_secondary: Thumbprint of the secondary certificate.
        :param str x509_store_name: The local certificate store location.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the primary certificate.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[str]:
        """
        Thumbprint of the secondary certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[str]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ClientCertificateCommonNameResponse(dict):
    """
    Describes the client certificate details using common name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"
        elif key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateCommonNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateCommonNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateCommonNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: str,
                 certificate_issuer_thumbprint: str,
                 is_admin: bool):
        """
        Describes the client certificate details using common name.
        :param str certificate_common_name: The common name of the client certificate.
        :param str certificate_issuer_thumbprint: The issuer thumbprint of the client certificate.
        :param bool is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> str:
        """
        The common name of the client certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> str:
        """
        The issuer thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")


@pulumi.output_type
class ClientCertificateThumbprintResponse(dict):
    """
    Describes the client certificate details using thumbprint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateThumbprint":
            suggest = "certificate_thumbprint"
        elif key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateThumbprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateThumbprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateThumbprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_thumbprint: str,
                 is_admin: bool):
        """
        Describes the client certificate details using thumbprint.
        :param str certificate_thumbprint: The thumbprint of the client certificate.
        :param bool is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> str:
        """
        The thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")


@pulumi.output_type
class ClusterHealthPolicyResponse(dict):
    """
    Defines a health policy used to evaluate the health of the cluster or of a cluster node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationHealthPolicies":
            suggest = "application_health_policies"
        elif key == "maxPercentUnhealthyApplications":
            suggest = "max_percent_unhealthy_applications"
        elif key == "maxPercentUnhealthyNodes":
            suggest = "max_percent_unhealthy_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_health_policies: Optional[Mapping[str, 'outputs.ApplicationHealthPolicyResponse']] = None,
                 max_percent_unhealthy_applications: Optional[int] = None,
                 max_percent_unhealthy_nodes: Optional[int] = None):
        """
        Defines a health policy used to evaluate the health of the cluster or of a cluster node.

        :param Mapping[str, 'ApplicationHealthPolicyResponse'] application_health_policies: Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        :param int max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
               This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
               The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        :param int max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
               The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
               
               In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        if application_health_policies is not None:
            pulumi.set(__self__, "application_health_policies", application_health_policies)
        if max_percent_unhealthy_applications is None:
            max_percent_unhealthy_applications = 0
        if max_percent_unhealthy_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_applications", max_percent_unhealthy_applications)
        if max_percent_unhealthy_nodes is None:
            max_percent_unhealthy_nodes = 0
        if max_percent_unhealthy_nodes is not None:
            pulumi.set(__self__, "max_percent_unhealthy_nodes", max_percent_unhealthy_nodes)

    @property
    @pulumi.getter(name="applicationHealthPolicies")
    def application_health_policies(self) -> Optional[Mapping[str, 'outputs.ApplicationHealthPolicyResponse']]:
        """
        Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policies")

    @property
    @pulumi.getter(name="maxPercentUnhealthyApplications")
    def max_percent_unhealthy_applications(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
        This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
        The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_applications")

    @property
    @pulumi.getter(name="maxPercentUnhealthyNodes")
    def max_percent_unhealthy_nodes(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
        The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.

        In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        return pulumi.get(self, "max_percent_unhealthy_nodes")


@pulumi.output_type
class ClusterUpgradeDeltaHealthPolicyResponse(dict):
    """
    Describes the delta health policies for the cluster upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentDeltaUnhealthyApplications":
            suggest = "max_percent_delta_unhealthy_applications"
        elif key == "maxPercentDeltaUnhealthyNodes":
            suggest = "max_percent_delta_unhealthy_nodes"
        elif key == "maxPercentUpgradeDomainDeltaUnhealthyNodes":
            suggest = "max_percent_upgrade_domain_delta_unhealthy_nodes"
        elif key == "applicationDeltaHealthPolicies":
            suggest = "application_delta_health_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradeDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradeDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradeDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_delta_unhealthy_applications: int,
                 max_percent_delta_unhealthy_nodes: int,
                 max_percent_upgrade_domain_delta_unhealthy_nodes: int,
                 application_delta_health_policies: Optional[Mapping[str, 'outputs.ApplicationDeltaHealthPolicyResponse']] = None):
        """
        Describes the delta health policies for the cluster upgrade.
        :param int max_percent_delta_unhealthy_applications: The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
               The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        :param int max_percent_delta_unhealthy_nodes: The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        :param int max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        :param Mapping[str, 'ApplicationDeltaHealthPolicyResponse'] application_delta_health_policies: Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        pulumi.set(__self__, "max_percent_delta_unhealthy_applications", max_percent_delta_unhealthy_applications)
        pulumi.set(__self__, "max_percent_delta_unhealthy_nodes", max_percent_delta_unhealthy_nodes)
        pulumi.set(__self__, "max_percent_upgrade_domain_delta_unhealthy_nodes", max_percent_upgrade_domain_delta_unhealthy_nodes)
        if application_delta_health_policies is not None:
            pulumi.set(__self__, "application_delta_health_policies", application_delta_health_policies)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyApplications")
    def max_percent_delta_unhealthy_applications(self) -> int:
        """
        The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
        The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_applications")

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyNodes")
    def max_percent_delta_unhealthy_nodes(self) -> int:
        """
        The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_nodes")

    @property
    @pulumi.getter(name="maxPercentUpgradeDomainDeltaUnhealthyNodes")
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self) -> int:
        """
        The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_upgrade_domain_delta_unhealthy_nodes")

    @property
    @pulumi.getter(name="applicationDeltaHealthPolicies")
    def application_delta_health_policies(self) -> Optional[Mapping[str, 'outputs.ApplicationDeltaHealthPolicyResponse']]:
        """
        Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        return pulumi.get(self, "application_delta_health_policies")


@pulumi.output_type
class ClusterUpgradePolicyResponse(dict):
    """
    Describes the policy used when upgrading the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckRetryTimeout":
            suggest = "health_check_retry_timeout"
        elif key == "healthCheckStableDuration":
            suggest = "health_check_stable_duration"
        elif key == "healthCheckWaitDuration":
            suggest = "health_check_wait_duration"
        elif key == "healthPolicy":
            suggest = "health_policy"
        elif key == "upgradeDomainTimeout":
            suggest = "upgrade_domain_timeout"
        elif key == "upgradeReplicaSetCheckTimeout":
            suggest = "upgrade_replica_set_check_timeout"
        elif key == "upgradeTimeout":
            suggest = "upgrade_timeout"
        elif key == "deltaHealthPolicy":
            suggest = "delta_health_policy"
        elif key == "forceRestart":
            suggest = "force_restart"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_retry_timeout: str,
                 health_check_stable_duration: str,
                 health_check_wait_duration: str,
                 health_policy: 'outputs.ClusterHealthPolicyResponse',
                 upgrade_domain_timeout: str,
                 upgrade_replica_set_check_timeout: str,
                 upgrade_timeout: str,
                 delta_health_policy: Optional['outputs.ClusterUpgradeDeltaHealthPolicyResponse'] = None,
                 force_restart: Optional[bool] = None):
        """
        Describes the policy used when upgrading the cluster.
        :param str health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str health_check_wait_duration: The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param 'ClusterHealthPolicyResponse' health_policy: The cluster health policy used when upgrading the cluster.
        :param str upgrade_domain_timeout: The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str upgrade_timeout: The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param 'ClusterUpgradeDeltaHealthPolicyResponse' delta_health_policy: The cluster delta health policy used when upgrading the cluster.
        :param bool force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "health_policy", health_policy)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> str:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> str:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> str:
        """
        The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> 'outputs.ClusterHealthPolicyResponse':
        """
        The cluster health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "health_policy")

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> str:
        """
        The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> str:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> str:
        """
        The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_timeout")

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional['outputs.ClusterUpgradeDeltaHealthPolicyResponse']:
        """
        The cluster delta health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "delta_health_policy")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[bool]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")


@pulumi.output_type
class ClusterVersionDetailsResponse(dict):
    """
    The detail of the Service Fabric runtime version result
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeVersion":
            suggest = "code_version"
        elif key == "supportExpiryUtc":
            suggest = "support_expiry_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVersionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVersionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVersionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_version: Optional[str] = None,
                 environment: Optional[str] = None,
                 support_expiry_utc: Optional[str] = None):
        """
        The detail of the Service Fabric runtime version result
        :param str code_version: The Service Fabric runtime version of the cluster.
        :param str environment: Indicates if this version is for Windows or Linux operating system.
        :param str support_expiry_utc: The date of expiry of support of the version.
        """
        if code_version is not None:
            pulumi.set(__self__, "code_version", code_version)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if support_expiry_utc is not None:
            pulumi.set(__self__, "support_expiry_utc", support_expiry_utc)

    @property
    @pulumi.getter(name="codeVersion")
    def code_version(self) -> Optional[str]:
        """
        The Service Fabric runtime version of the cluster.
        """
        return pulumi.get(self, "code_version")

    @property
    @pulumi.getter
    def environment(self) -> Optional[str]:
        """
        Indicates if this version is for Windows or Linux operating system.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="supportExpiryUtc")
    def support_expiry_utc(self) -> Optional[str]:
        """
        The date of expiry of support of the version.
        """
        return pulumi.get(self, "support_expiry_utc")


@pulumi.output_type
class DiagnosticsStorageAccountConfigResponse(dict):
    """
    The storage account information for storing Service Fabric diagnostic logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobEndpoint":
            suggest = "blob_endpoint"
        elif key == "protectedAccountKeyName":
            suggest = "protected_account_key_name"
        elif key == "queueEndpoint":
            suggest = "queue_endpoint"
        elif key == "storageAccountName":
            suggest = "storage_account_name"
        elif key == "tableEndpoint":
            suggest = "table_endpoint"
        elif key == "protectedAccountKeyName2":
            suggest = "protected_account_key_name2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsStorageAccountConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsStorageAccountConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsStorageAccountConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_endpoint: str,
                 protected_account_key_name: str,
                 queue_endpoint: str,
                 storage_account_name: str,
                 table_endpoint: str,
                 protected_account_key_name2: Optional[str] = None):
        """
        The storage account information for storing Service Fabric diagnostic logs.
        :param str blob_endpoint: The blob endpoint of the azure storage account.
        :param str protected_account_key_name: The protected diagnostics storage key name.
        :param str queue_endpoint: The queue endpoint of the azure storage account.
        :param str storage_account_name: The Azure storage account name.
        :param str table_endpoint: The table endpoint of the azure storage account.
        :param str protected_account_key_name2: The secondary protected diagnostics storage key name. If one of the storage account keys is rotated the cluster will fallback to using the other.
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)
        if protected_account_key_name2 is not None:
            pulumi.set(__self__, "protected_account_key_name2", protected_account_key_name2)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> str:
        """
        The blob endpoint of the azure storage account.
        """
        return pulumi.get(self, "blob_endpoint")

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> str:
        """
        The protected diagnostics storage key name.
        """
        return pulumi.get(self, "protected_account_key_name")

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> str:
        """
        The queue endpoint of the azure storage account.
        """
        return pulumi.get(self, "queue_endpoint")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> str:
        """
        The Azure storage account name.
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> str:
        """
        The table endpoint of the azure storage account.
        """
        return pulumi.get(self, "table_endpoint")

    @property
    @pulumi.getter(name="protectedAccountKeyName2")
    def protected_account_key_name2(self) -> Optional[str]:
        """
        The secondary protected diagnostics storage key name. If one of the storage account keys is rotated the cluster will fallback to using the other.
        """
        return pulumi.get(self, "protected_account_key_name2")


@pulumi.output_type
class EndpointRangeDescriptionResponse(dict):
    """
    Port range details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRangeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: int,
                 start_port: int):
        """
        Port range details
        :param int end_port: End port of a range of ports
        :param int start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> int:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> int:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")


@pulumi.output_type
class ManagedIdentityResponse(dict):
    """
    Describes the managed identities for an Azure resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Describes the managed identities for an Azure resource.
        :param str principal_id: The principal id of the managed identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant id of the managed identity. This property will only be provided for a system assigned identity.
        :param str type: The type of managed identity for the resource.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of the managed identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant id of the managed identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of managed identity for the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class NamedPartitionSchemeDescriptionResponse(dict):
    """
    Describes the named partition scheme of the service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionScheme":
            suggest = "partition_scheme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamedPartitionSchemeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamedPartitionSchemeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamedPartitionSchemeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: int,
                 names: Sequence[str],
                 partition_scheme: str):
        """
        Describes the named partition scheme of the service.
        :param int count: The number of partitions.
        :param Sequence[str] names: Array of size specified by the ‘count’ parameter, for the names of the partitions.
        :param str partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'Named'.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "partition_scheme", 'Named')

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of partitions.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        Array of size specified by the ‘count’ parameter, for the names of the partitions.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> str:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'Named'.
        """
        return pulumi.get(self, "partition_scheme")


@pulumi.output_type
class NodeTypeDescriptionResponse(dict):
    """
    Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConnectionEndpointPort":
            suggest = "client_connection_endpoint_port"
        elif key == "httpGatewayEndpointPort":
            suggest = "http_gateway_endpoint_port"
        elif key == "isPrimary":
            suggest = "is_primary"
        elif key == "vmInstanceCount":
            suggest = "vm_instance_count"
        elif key == "applicationPorts":
            suggest = "application_ports"
        elif key == "durabilityLevel":
            suggest = "durability_level"
        elif key == "ephemeralPorts":
            suggest = "ephemeral_ports"
        elif key == "placementProperties":
            suggest = "placement_properties"
        elif key == "reverseProxyEndpointPort":
            suggest = "reverse_proxy_endpoint_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeTypeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeTypeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeTypeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_connection_endpoint_port: int,
                 http_gateway_endpoint_port: int,
                 is_primary: bool,
                 name: str,
                 vm_instance_count: int,
                 application_ports: Optional['outputs.EndpointRangeDescriptionResponse'] = None,
                 capacities: Optional[Mapping[str, str]] = None,
                 durability_level: Optional[str] = None,
                 ephemeral_ports: Optional['outputs.EndpointRangeDescriptionResponse'] = None,
                 placement_properties: Optional[Mapping[str, str]] = None,
                 reverse_proxy_endpoint_port: Optional[int] = None):
        """
        Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
        :param int client_connection_endpoint_port: The TCP cluster management endpoint port.
        :param int http_gateway_endpoint_port: The HTTP cluster management endpoint port.
        :param bool is_primary: The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        :param str name: The name of the node type.
        :param int vm_instance_count: The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        :param 'EndpointRangeDescriptionResponse' application_ports: The range of ports from which cluster assigned port to Service Fabric applications.
        :param Mapping[str, str] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        :param str durability_level: The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
               
                 - Bronze - No privileges. This is the default.
                 - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
                 - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM skus like D15_V2, G5 etc.
        :param 'EndpointRangeDescriptionResponse' ephemeral_ports: The range of ephemeral ports that nodes in this node type should be configured with.
        :param Mapping[str, str] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        :param int reverse_proxy_endpoint_port: The endpoint used by reverse proxy.
        """
        pulumi.set(__self__, "client_connection_endpoint_port", client_connection_endpoint_port)
        pulumi.set(__self__, "http_gateway_endpoint_port", http_gateway_endpoint_port)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientConnectionEndpointPort")
    def client_connection_endpoint_port(self) -> int:
        """
        The TCP cluster management endpoint port.
        """
        return pulumi.get(self, "client_connection_endpoint_port")

    @property
    @pulumi.getter(name="httpGatewayEndpointPort")
    def http_gateway_endpoint_port(self) -> int:
        """
        The HTTP cluster management endpoint port.
        """
        return pulumi.get(self, "http_gateway_endpoint_port")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the node type.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> int:
        """
        The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        """
        return pulumi.get(self, "vm_instance_count")

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional['outputs.EndpointRangeDescriptionResponse']:
        """
        The range of ports from which cluster assigned port to Service Fabric applications.
        """
        return pulumi.get(self, "application_ports")

    @property
    @pulumi.getter
    def capacities(self) -> Optional[Mapping[str, str]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[str]:
        """
        The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).

          - Bronze - No privileges. This is the default.
          - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
          - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM skus like D15_V2, G5 etc.
        """
        return pulumi.get(self, "durability_level")

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional['outputs.EndpointRangeDescriptionResponse']:
        """
        The range of ephemeral ports that nodes in this node type should be configured with.
        """
        return pulumi.get(self, "ephemeral_ports")

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[Mapping[str, str]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        return pulumi.get(self, "placement_properties")

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[int]:
        """
        The endpoint used by reverse proxy.
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")


@pulumi.output_type
class ServerCertificateCommonNameResponse(dict):
    """
    Describes the server certificate details using common name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCertificateCommonNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCertificateCommonNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCertificateCommonNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: str,
                 certificate_issuer_thumbprint: str):
        """
        Describes the server certificate details using common name.
        :param str certificate_common_name: The common name of the server certificate.
        :param str certificate_issuer_thumbprint: The issuer thumbprint of the server certificate.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> str:
        """
        The common name of the server certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> str:
        """
        The issuer thumbprint of the server certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")


@pulumi.output_type
class ServerCertificateCommonNamesResponse(dict):
    """
    Describes a list of server certificates referenced by common name that are used to secure the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonNames":
            suggest = "common_names"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCertificateCommonNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCertificateCommonNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCertificateCommonNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_names: Optional[Sequence['outputs.ServerCertificateCommonNameResponse']] = None,
                 x509_store_name: Optional[str] = None):
        """
        Describes a list of server certificates referenced by common name that are used to secure the cluster.
        :param Sequence['ServerCertificateCommonNameResponse'] common_names: The list of server certificates referenced by common name that are used to secure the cluster.
        :param str x509_store_name: The local certificate store location.
        """
        if common_names is not None:
            pulumi.set(__self__, "common_names", common_names)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> Optional[Sequence['outputs.ServerCertificateCommonNameResponse']]:
        """
        The list of server certificates referenced by common name that are used to secure the cluster.
        """
        return pulumi.get(self, "common_names")

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[str]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ServiceCorrelationDescriptionResponse(dict):
    """
    Creates a particular correlation between services.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCorrelationDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCorrelationDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCorrelationDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scheme: str,
                 service_name: str):
        """
        Creates a particular correlation between services.
        :param str scheme: The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
        :param str service_name: The name of the service that the correlation relationship is established with.
        """
        pulumi.set(__self__, "scheme", scheme)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the service that the correlation relationship is established with.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class ServiceLoadMetricDescriptionResponse(dict):
    """
    Specifies a metric to load balance a service during runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLoad":
            suggest = "default_load"
        elif key == "primaryDefaultLoad":
            suggest = "primary_default_load"
        elif key == "secondaryDefaultLoad":
            suggest = "secondary_default_load"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLoadMetricDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLoadMetricDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLoadMetricDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 default_load: Optional[int] = None,
                 primary_default_load: Optional[int] = None,
                 secondary_default_load: Optional[int] = None,
                 weight: Optional[str] = None):
        """
        Specifies a metric to load balance a service during runtime.
        :param str name: The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
        :param int default_load: Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
        :param int primary_default_load: Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
        :param int secondary_default_load: Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
        :param str weight: The service load metric relative weight, compared to other metrics configured for this service, as a number.
        """
        pulumi.set(__self__, "name", name)
        if default_load is not None:
            pulumi.set(__self__, "default_load", default_load)
        if primary_default_load is not None:
            pulumi.set(__self__, "primary_default_load", primary_default_load)
        if secondary_default_load is not None:
            pulumi.set(__self__, "secondary_default_load", secondary_default_load)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="defaultLoad")
    def default_load(self) -> Optional[int]:
        """
        Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
        """
        return pulumi.get(self, "default_load")

    @property
    @pulumi.getter(name="primaryDefaultLoad")
    def primary_default_load(self) -> Optional[int]:
        """
        Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
        """
        return pulumi.get(self, "primary_default_load")

    @property
    @pulumi.getter(name="secondaryDefaultLoad")
    def secondary_default_load(self) -> Optional[int]:
        """
        Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
        """
        return pulumi.get(self, "secondary_default_load")

    @property
    @pulumi.getter
    def weight(self) -> Optional[str]:
        """
        The service load metric relative weight, compared to other metrics configured for this service, as a number.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServicePlacementPolicyDescriptionResponse(dict):
    """
    Describes the policy to be used for placement of a Service Fabric service.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Describes the policy to be used for placement of a Service Fabric service.
        :param str type: The type of placement policy for a service fabric service. Following are the possible values.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of placement policy for a service fabric service. Following are the possible values.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTypeDeltaHealthPolicyResponse(dict):
    """
    Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentDeltaUnhealthyServices":
            suggest = "max_percent_delta_unhealthy_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTypeDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTypeDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTypeDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_delta_unhealthy_services: Optional[int] = None):
        """
        Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.

        :param int max_percent_delta_unhealthy_services: The maximum allowed percentage of services health degradation allowed during cluster upgrades.
               The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        if max_percent_delta_unhealthy_services is None:
            max_percent_delta_unhealthy_services = 0
        if max_percent_delta_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_delta_unhealthy_services", max_percent_delta_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyServices")
    def max_percent_delta_unhealthy_services(self) -> Optional[int]:
        """
        The maximum allowed percentage of services health degradation allowed during cluster upgrades.
        The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_services")


@pulumi.output_type
class ServiceTypeHealthPolicyResponse(dict):
    """
    Represents the health policy used to evaluate the health of services belonging to a service type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentUnhealthyServices":
            suggest = "max_percent_unhealthy_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTypeHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTypeHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTypeHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_unhealthy_services: Optional[int] = None):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param int max_percent_unhealthy_services: The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        if max_percent_unhealthy_services is None:
            max_percent_unhealthy_services = 0
        if max_percent_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> Optional[int]:
        """
        The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")


@pulumi.output_type
class SettingsParameterDescriptionResponse(dict):
    """
    Describes a parameter in fabric settings of the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Describes a parameter in fabric settings of the cluster.
        :param str name: The parameter name of fabric setting.
        :param str value: The parameter value of fabric setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name of fabric setting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value of fabric setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingsSectionDescriptionResponse(dict):
    """
    Describes a section in the fabric settings of the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: Sequence['outputs.SettingsParameterDescriptionResponse']):
        """
        Describes a section in the fabric settings of the cluster.
        :param str name: The section name of the fabric settings.
        :param Sequence['SettingsParameterDescriptionResponse'] parameters: The collection of parameters in the section.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The section name of the fabric settings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.SettingsParameterDescriptionResponse']:
        """
        The collection of parameters in the section.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class SingletonPartitionSchemeDescriptionResponse(dict):
    """
    Describes the partition scheme of a singleton-partitioned, or non-partitioned service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionScheme":
            suggest = "partition_scheme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingletonPartitionSchemeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingletonPartitionSchemeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingletonPartitionSchemeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_scheme: str):
        """
        Describes the partition scheme of a singleton-partitioned, or non-partitioned service.
        :param str partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'Singleton'.
        """
        pulumi.set(__self__, "partition_scheme", 'Singleton')

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> str:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'Singleton'.
        """
        return pulumi.get(self, "partition_scheme")


@pulumi.output_type
class UniformInt64RangePartitionSchemeDescriptionResponse(dict):
    """
    Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highKey":
            suggest = "high_key"
        elif key == "lowKey":
            suggest = "low_key"
        elif key == "partitionScheme":
            suggest = "partition_scheme"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UniformInt64RangePartitionSchemeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UniformInt64RangePartitionSchemeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UniformInt64RangePartitionSchemeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: int,
                 high_key: str,
                 low_key: str,
                 partition_scheme: str):
        """
        Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.
        :param int count: The number of partitions.
        :param str high_key: String indicating the upper bound of the partition key range that
               should be split between the partition ‘count’
        :param str low_key: String indicating the lower bound of the partition key range that
               should be split between the partition ‘count’
        :param str partition_scheme: Enumerates the ways that a service can be partitioned.
               Expected value is 'UniformInt64Range'.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "high_key", high_key)
        pulumi.set(__self__, "low_key", low_key)
        pulumi.set(__self__, "partition_scheme", 'UniformInt64Range')

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        The number of partitions.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="highKey")
    def high_key(self) -> str:
        """
        String indicating the upper bound of the partition key range that
        should be split between the partition ‘count’
        """
        return pulumi.get(self, "high_key")

    @property
    @pulumi.getter(name="lowKey")
    def low_key(self) -> str:
        """
        String indicating the lower bound of the partition key range that
        should be split between the partition ‘count’
        """
        return pulumi.get(self, "low_key")

    @property
    @pulumi.getter(name="partitionScheme")
    def partition_scheme(self) -> str:
        """
        Enumerates the ways that a service can be partitioned.
        Expected value is 'UniformInt64Range'.
        """
        return pulumi.get(self, "partition_scheme")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


