# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ApplicationDeltaHealthPolicyResponse',
    'ApplicationHealthPolicyResponse',
    'AzureActiveDirectoryResponse',
    'CertificateDescriptionResponse',
    'ClientCertificateCommonNameResponse',
    'ClientCertificateThumbprintResponse',
    'ClusterHealthPolicyResponse',
    'ClusterUpgradeDeltaHealthPolicyResponse',
    'ClusterUpgradePolicyResponse',
    'ClusterVersionDetailsResponse',
    'DiagnosticsStorageAccountConfigResponse',
    'EndpointRangeDescriptionResponse',
    'NodeTypeDescriptionResponse',
    'ServerCertificateCommonNameResponse',
    'ServerCertificateCommonNamesResponse',
    'ServiceTypeDeltaHealthPolicyResponse',
    'ServiceTypeHealthPolicyResponse',
    'SettingsParameterDescriptionResponse',
    'SettingsSectionDescriptionResponse',
]

@pulumi.output_type
class ApplicationDeltaHealthPolicyResponse(dict):
    """
    Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultServiceTypeDeltaHealthPolicy":
            suggest = "default_service_type_delta_health_policy"
        elif key == "serviceTypeDeltaHealthPolicies":
            suggest = "service_type_delta_health_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_service_type_delta_health_policy: Optional['outputs.ServiceTypeDeltaHealthPolicyResponse'] = None,
                 service_type_delta_health_policies: Optional[Mapping[str, 'outputs.ServiceTypeDeltaHealthPolicyResponse']] = None):
        """
        Defines a delta health policy used to evaluate the health of an application or one of its child entities when upgrading the cluster.

        :param 'ServiceTypeDeltaHealthPolicyResponse' default_service_type_delta_health_policy: The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        :param Mapping[str, 'ServiceTypeDeltaHealthPolicyResponse'] service_type_delta_health_policies: The map with service type delta health policy per service type name. The map is empty by default.
        """
        if default_service_type_delta_health_policy is not None:
            pulumi.set(__self__, "default_service_type_delta_health_policy", default_service_type_delta_health_policy)
        if service_type_delta_health_policies is not None:
            pulumi.set(__self__, "service_type_delta_health_policies", service_type_delta_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeDeltaHealthPolicy")
    def default_service_type_delta_health_policy(self) -> Optional['outputs.ServiceTypeDeltaHealthPolicyResponse']:
        """
        The delta health policy used by default to evaluate the health of a service type when upgrading the cluster.
        """
        return pulumi.get(self, "default_service_type_delta_health_policy")

    @property
    @pulumi.getter(name="serviceTypeDeltaHealthPolicies")
    def service_type_delta_health_policies(self) -> Optional[Mapping[str, 'outputs.ServiceTypeDeltaHealthPolicyResponse']]:
        """
        The map with service type delta health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_delta_health_policies")


@pulumi.output_type
class ApplicationHealthPolicyResponse(dict):
    """
    Defines a health policy used to evaluate the health of an application or one of its children entities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultServiceTypeHealthPolicy":
            suggest = "default_service_type_health_policy"
        elif key == "serviceTypeHealthPolicies":
            suggest = "service_type_health_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_service_type_health_policy: Optional['outputs.ServiceTypeHealthPolicyResponse'] = None,
                 service_type_health_policies: Optional[Mapping[str, 'outputs.ServiceTypeHealthPolicyResponse']] = None):
        """
        Defines a health policy used to evaluate the health of an application or one of its children entities.

        :param 'ServiceTypeHealthPolicyResponse' default_service_type_health_policy: The health policy used by default to evaluate the health of a service type.
        :param Mapping[str, 'ServiceTypeHealthPolicyResponse'] service_type_health_policies: The map with service type health policy per service type name. The map is empty by default.
        """
        if default_service_type_health_policy is not None:
            pulumi.set(__self__, "default_service_type_health_policy", default_service_type_health_policy)
        if service_type_health_policies is not None:
            pulumi.set(__self__, "service_type_health_policies", service_type_health_policies)

    @property
    @pulumi.getter(name="defaultServiceTypeHealthPolicy")
    def default_service_type_health_policy(self) -> Optional['outputs.ServiceTypeHealthPolicyResponse']:
        """
        The health policy used by default to evaluate the health of a service type.
        """
        return pulumi.get(self, "default_service_type_health_policy")

    @property
    @pulumi.getter(name="serviceTypeHealthPolicies")
    def service_type_health_policies(self) -> Optional[Mapping[str, 'outputs.ServiceTypeHealthPolicyResponse']]:
        """
        The map with service type health policy per service type name. The map is empty by default.
        """
        return pulumi.get(self, "service_type_health_policies")


@pulumi.output_type
class AzureActiveDirectoryResponse(dict):
    """
    The settings to enable AAD authentication on the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientApplication":
            suggest = "client_application"
        elif key == "clusterApplication":
            suggest = "cluster_application"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureActiveDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureActiveDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_application: Optional[str] = None,
                 cluster_application: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        The settings to enable AAD authentication on the cluster.
        :param str client_application: Azure active directory client application id.
        :param str cluster_application: Azure active directory cluster application id.
        :param str tenant_id: Azure active directory tenant id.
        """
        if client_application is not None:
            pulumi.set(__self__, "client_application", client_application)
        if cluster_application is not None:
            pulumi.set(__self__, "cluster_application", cluster_application)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientApplication")
    def client_application(self) -> Optional[str]:
        """
        Azure active directory client application id.
        """
        return pulumi.get(self, "client_application")

    @property
    @pulumi.getter(name="clusterApplication")
    def cluster_application(self) -> Optional[str]:
        """
        Azure active directory cluster application id.
        """
        return pulumi.get(self, "cluster_application")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Azure active directory tenant id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class CertificateDescriptionResponse(dict):
    """
    Describes the certificate details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "thumbprintSecondary":
            suggest = "thumbprint_secondary"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 thumbprint: str,
                 thumbprint_secondary: Optional[str] = None,
                 x509_store_name: Optional[str] = None):
        """
        Describes the certificate details.
        :param str thumbprint: Thumbprint of the primary certificate.
        :param str thumbprint_secondary: Thumbprint of the secondary certificate.
        :param str x509_store_name: The local certificate store location.
        """
        pulumi.set(__self__, "thumbprint", thumbprint)
        if thumbprint_secondary is not None:
            pulumi.set(__self__, "thumbprint_secondary", thumbprint_secondary)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the primary certificate.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="thumbprintSecondary")
    def thumbprint_secondary(self) -> Optional[str]:
        """
        Thumbprint of the secondary certificate.
        """
        return pulumi.get(self, "thumbprint_secondary")

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[str]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ClientCertificateCommonNameResponse(dict):
    """
    Describes the client certificate details using common name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"
        elif key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateCommonNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateCommonNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateCommonNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: str,
                 certificate_issuer_thumbprint: str,
                 is_admin: bool):
        """
        Describes the client certificate details using common name.
        :param str certificate_common_name: The common name of the client certificate.
        :param str certificate_issuer_thumbprint: The issuer thumbprint of the client certificate.
        :param bool is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> str:
        """
        The common name of the client certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> str:
        """
        The issuer thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")


@pulumi.output_type
class ClientCertificateThumbprintResponse(dict):
    """
    Describes the client certificate details using thumbprint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateThumbprint":
            suggest = "certificate_thumbprint"
        elif key == "isAdmin":
            suggest = "is_admin"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateThumbprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateThumbprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateThumbprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_thumbprint: str,
                 is_admin: bool):
        """
        Describes the client certificate details using thumbprint.
        :param str certificate_thumbprint: The thumbprint of the client certificate.
        :param bool is_admin: Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        pulumi.set(__self__, "certificate_thumbprint", certificate_thumbprint)
        pulumi.set(__self__, "is_admin", is_admin)

    @property
    @pulumi.getter(name="certificateThumbprint")
    def certificate_thumbprint(self) -> str:
        """
        The thumbprint of the client certificate.
        """
        return pulumi.get(self, "certificate_thumbprint")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> bool:
        """
        Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
        """
        return pulumi.get(self, "is_admin")


@pulumi.output_type
class ClusterHealthPolicyResponse(dict):
    """
    Defines a health policy used to evaluate the health of the cluster or of a cluster node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationHealthPolicies":
            suggest = "application_health_policies"
        elif key == "maxPercentUnhealthyApplications":
            suggest = "max_percent_unhealthy_applications"
        elif key == "maxPercentUnhealthyNodes":
            suggest = "max_percent_unhealthy_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_health_policies: Optional[Mapping[str, 'outputs.ApplicationHealthPolicyResponse']] = None,
                 max_percent_unhealthy_applications: Optional[int] = None,
                 max_percent_unhealthy_nodes: Optional[int] = None):
        """
        Defines a health policy used to evaluate the health of the cluster or of a cluster node.

        :param Mapping[str, 'ApplicationHealthPolicyResponse'] application_health_policies: Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        :param int max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
               This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
               The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        :param int max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
               
               The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
               If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
               The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
               The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
               
               In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        if application_health_policies is not None:
            pulumi.set(__self__, "application_health_policies", application_health_policies)
        if max_percent_unhealthy_applications is None:
            max_percent_unhealthy_applications = 0
        if max_percent_unhealthy_applications is not None:
            pulumi.set(__self__, "max_percent_unhealthy_applications", max_percent_unhealthy_applications)
        if max_percent_unhealthy_nodes is None:
            max_percent_unhealthy_nodes = 0
        if max_percent_unhealthy_nodes is not None:
            pulumi.set(__self__, "max_percent_unhealthy_nodes", max_percent_unhealthy_nodes)

    @property
    @pulumi.getter(name="applicationHealthPolicies")
    def application_health_policies(self) -> Optional[Mapping[str, 'outputs.ApplicationHealthPolicyResponse']]:
        """
        Defines the application health policy map used to evaluate the health of an application or one of its children entities.
        """
        return pulumi.get(self, "application_health_policies")

    @property
    @pulumi.getter(name="maxPercentUnhealthyApplications")
    def max_percent_unhealthy_applications(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of applications that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy application, the health is evaluated as Warning.
        This is calculated by dividing the number of unhealthy applications over the total number of application instances in the cluster, excluding applications of application types that are included in the ApplicationTypeHealthPolicyMap.
        The computation rounds up to tolerate one failure on small numbers of applications. Default percentage is zero.
        """
        return pulumi.get(self, "max_percent_unhealthy_applications")

    @property
    @pulumi.getter(name="maxPercentUnhealthyNodes")
    def max_percent_unhealthy_nodes(self) -> Optional[int]:
        """
        The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.

        The percentage represents the maximum tolerated percentage of nodes that can be unhealthy before the cluster is considered in error.
        If the percentage is respected but there is at least one unhealthy node, the health is evaluated as Warning.
        The percentage is calculated by dividing the number of unhealthy nodes over the total number of nodes in the cluster.
        The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.

        In large clusters, some nodes will always be down or out for repairs, so this percentage should be configured to tolerate that.
        """
        return pulumi.get(self, "max_percent_unhealthy_nodes")


@pulumi.output_type
class ClusterUpgradeDeltaHealthPolicyResponse(dict):
    """
    Describes the delta health policies for the cluster upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentDeltaUnhealthyApplications":
            suggest = "max_percent_delta_unhealthy_applications"
        elif key == "maxPercentDeltaUnhealthyNodes":
            suggest = "max_percent_delta_unhealthy_nodes"
        elif key == "maxPercentUpgradeDomainDeltaUnhealthyNodes":
            suggest = "max_percent_upgrade_domain_delta_unhealthy_nodes"
        elif key == "applicationDeltaHealthPolicies":
            suggest = "application_delta_health_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradeDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradeDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradeDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_delta_unhealthy_applications: int,
                 max_percent_delta_unhealthy_nodes: int,
                 max_percent_upgrade_domain_delta_unhealthy_nodes: int,
                 application_delta_health_policies: Optional[Mapping[str, 'outputs.ApplicationDeltaHealthPolicyResponse']] = None):
        """
        Describes the delta health policies for the cluster upgrade.
        :param int max_percent_delta_unhealthy_applications: The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
               The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        :param int max_percent_delta_unhealthy_nodes: The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        :param int max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
               The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        :param Mapping[str, 'ApplicationDeltaHealthPolicyResponse'] application_delta_health_policies: Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        pulumi.set(__self__, "max_percent_delta_unhealthy_applications", max_percent_delta_unhealthy_applications)
        pulumi.set(__self__, "max_percent_delta_unhealthy_nodes", max_percent_delta_unhealthy_nodes)
        pulumi.set(__self__, "max_percent_upgrade_domain_delta_unhealthy_nodes", max_percent_upgrade_domain_delta_unhealthy_nodes)
        if application_delta_health_policies is not None:
            pulumi.set(__self__, "application_delta_health_policies", application_delta_health_policies)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyApplications")
    def max_percent_delta_unhealthy_applications(self) -> int:
        """
        The maximum allowed percentage of applications health degradation allowed during cluster upgrades.
        The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_applications")

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyNodes")
    def max_percent_delta_unhealthy_nodes(self) -> int:
        """
        The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_nodes")

    @property
    @pulumi.getter(name="maxPercentUpgradeDomainDeltaUnhealthyNodes")
    def max_percent_upgrade_domain_delta_unhealthy_nodes(self) -> int:
        """
        The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades.
        The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_upgrade_domain_delta_unhealthy_nodes")

    @property
    @pulumi.getter(name="applicationDeltaHealthPolicies")
    def application_delta_health_policies(self) -> Optional[Mapping[str, 'outputs.ApplicationDeltaHealthPolicyResponse']]:
        """
        Defines the application delta health policy map used to evaluate the health of an application or one of its child entities when upgrading the cluster.
        """
        return pulumi.get(self, "application_delta_health_policies")


@pulumi.output_type
class ClusterUpgradePolicyResponse(dict):
    """
    Describes the policy used when upgrading the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckRetryTimeout":
            suggest = "health_check_retry_timeout"
        elif key == "healthCheckStableDuration":
            suggest = "health_check_stable_duration"
        elif key == "healthCheckWaitDuration":
            suggest = "health_check_wait_duration"
        elif key == "healthPolicy":
            suggest = "health_policy"
        elif key == "upgradeDomainTimeout":
            suggest = "upgrade_domain_timeout"
        elif key == "upgradeReplicaSetCheckTimeout":
            suggest = "upgrade_replica_set_check_timeout"
        elif key == "upgradeTimeout":
            suggest = "upgrade_timeout"
        elif key == "deltaHealthPolicy":
            suggest = "delta_health_policy"
        elif key == "forceRestart":
            suggest = "force_restart"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_retry_timeout: str,
                 health_check_stable_duration: str,
                 health_check_wait_duration: str,
                 health_policy: 'outputs.ClusterHealthPolicyResponse',
                 upgrade_domain_timeout: str,
                 upgrade_replica_set_check_timeout: str,
                 upgrade_timeout: str,
                 delta_health_policy: Optional['outputs.ClusterUpgradeDeltaHealthPolicyResponse'] = None,
                 force_restart: Optional[bool] = None):
        """
        Describes the policy used when upgrading the cluster.
        :param str health_check_retry_timeout: The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str health_check_stable_duration: The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str health_check_wait_duration: The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param 'ClusterHealthPolicyResponse' health_policy: The cluster health policy used when upgrading the cluster.
        :param str upgrade_domain_timeout: The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param str upgrade_timeout: The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        :param 'ClusterUpgradeDeltaHealthPolicyResponse' delta_health_policy: The cluster delta health policy used when upgrading the cluster.
        :param bool force_restart: If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        pulumi.set(__self__, "health_check_retry_timeout", health_check_retry_timeout)
        pulumi.set(__self__, "health_check_stable_duration", health_check_stable_duration)
        pulumi.set(__self__, "health_check_wait_duration", health_check_wait_duration)
        pulumi.set(__self__, "health_policy", health_policy)
        pulumi.set(__self__, "upgrade_domain_timeout", upgrade_domain_timeout)
        pulumi.set(__self__, "upgrade_replica_set_check_timeout", upgrade_replica_set_check_timeout)
        pulumi.set(__self__, "upgrade_timeout", upgrade_timeout)
        if delta_health_policy is not None:
            pulumi.set(__self__, "delta_health_policy", delta_health_policy)
        if force_restart is not None:
            pulumi.set(__self__, "force_restart", force_restart)

    @property
    @pulumi.getter(name="healthCheckRetryTimeout")
    def health_check_retry_timeout(self) -> str:
        """
        The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_retry_timeout")

    @property
    @pulumi.getter(name="healthCheckStableDuration")
    def health_check_stable_duration(self) -> str:
        """
        The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_stable_duration")

    @property
    @pulumi.getter(name="healthCheckWaitDuration")
    def health_check_wait_duration(self) -> str:
        """
        The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "health_check_wait_duration")

    @property
    @pulumi.getter(name="healthPolicy")
    def health_policy(self) -> 'outputs.ClusterHealthPolicyResponse':
        """
        The cluster health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "health_policy")

    @property
    @pulumi.getter(name="upgradeDomainTimeout")
    def upgrade_domain_timeout(self) -> str:
        """
        The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_domain_timeout")

    @property
    @pulumi.getter(name="upgradeReplicaSetCheckTimeout")
    def upgrade_replica_set_check_timeout(self) -> str:
        """
        The maximum amount of time to block processing of an upgrade domain and prevent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_replica_set_check_timeout")

    @property
    @pulumi.getter(name="upgradeTimeout")
    def upgrade_timeout(self) -> str:
        """
        The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
        """
        return pulumi.get(self, "upgrade_timeout")

    @property
    @pulumi.getter(name="deltaHealthPolicy")
    def delta_health_policy(self) -> Optional['outputs.ClusterUpgradeDeltaHealthPolicyResponse']:
        """
        The cluster delta health policy used when upgrading the cluster.
        """
        return pulumi.get(self, "delta_health_policy")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> Optional[bool]:
        """
        If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
        """
        return pulumi.get(self, "force_restart")


@pulumi.output_type
class ClusterVersionDetailsResponse(dict):
    """
    The detail of the Service Fabric runtime version result
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeVersion":
            suggest = "code_version"
        elif key == "supportExpiryUtc":
            suggest = "support_expiry_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterVersionDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterVersionDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterVersionDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_version: Optional[str] = None,
                 environment: Optional[str] = None,
                 support_expiry_utc: Optional[str] = None):
        """
        The detail of the Service Fabric runtime version result
        :param str code_version: The Service Fabric runtime version of the cluster.
        :param str environment: Indicates if this version is for Windows or Linux operating system.
        :param str support_expiry_utc: The date of expiry of support of the version.
        """
        if code_version is not None:
            pulumi.set(__self__, "code_version", code_version)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if support_expiry_utc is not None:
            pulumi.set(__self__, "support_expiry_utc", support_expiry_utc)

    @property
    @pulumi.getter(name="codeVersion")
    def code_version(self) -> Optional[str]:
        """
        The Service Fabric runtime version of the cluster.
        """
        return pulumi.get(self, "code_version")

    @property
    @pulumi.getter
    def environment(self) -> Optional[str]:
        """
        Indicates if this version is for Windows or Linux operating system.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="supportExpiryUtc")
    def support_expiry_utc(self) -> Optional[str]:
        """
        The date of expiry of support of the version.
        """
        return pulumi.get(self, "support_expiry_utc")


@pulumi.output_type
class DiagnosticsStorageAccountConfigResponse(dict):
    """
    The storage account information for storing Service Fabric diagnostic logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobEndpoint":
            suggest = "blob_endpoint"
        elif key == "protectedAccountKeyName":
            suggest = "protected_account_key_name"
        elif key == "queueEndpoint":
            suggest = "queue_endpoint"
        elif key == "storageAccountName":
            suggest = "storage_account_name"
        elif key == "tableEndpoint":
            suggest = "table_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiagnosticsStorageAccountConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiagnosticsStorageAccountConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiagnosticsStorageAccountConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_endpoint: str,
                 protected_account_key_name: str,
                 queue_endpoint: str,
                 storage_account_name: str,
                 table_endpoint: str):
        """
        The storage account information for storing Service Fabric diagnostic logs.
        :param str blob_endpoint: The blob endpoint of the azure storage account.
        :param str protected_account_key_name: The protected diagnostics storage key name.
        :param str queue_endpoint: The queue endpoint of the azure storage account.
        :param str storage_account_name: The Azure storage account name.
        :param str table_endpoint: The table endpoint of the azure storage account.
        """
        pulumi.set(__self__, "blob_endpoint", blob_endpoint)
        pulumi.set(__self__, "protected_account_key_name", protected_account_key_name)
        pulumi.set(__self__, "queue_endpoint", queue_endpoint)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "table_endpoint", table_endpoint)

    @property
    @pulumi.getter(name="blobEndpoint")
    def blob_endpoint(self) -> str:
        """
        The blob endpoint of the azure storage account.
        """
        return pulumi.get(self, "blob_endpoint")

    @property
    @pulumi.getter(name="protectedAccountKeyName")
    def protected_account_key_name(self) -> str:
        """
        The protected diagnostics storage key name.
        """
        return pulumi.get(self, "protected_account_key_name")

    @property
    @pulumi.getter(name="queueEndpoint")
    def queue_endpoint(self) -> str:
        """
        The queue endpoint of the azure storage account.
        """
        return pulumi.get(self, "queue_endpoint")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> str:
        """
        The Azure storage account name.
        """
        return pulumi.get(self, "storage_account_name")

    @property
    @pulumi.getter(name="tableEndpoint")
    def table_endpoint(self) -> str:
        """
        The table endpoint of the azure storage account.
        """
        return pulumi.get(self, "table_endpoint")


@pulumi.output_type
class EndpointRangeDescriptionResponse(dict):
    """
    Port range details
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRangeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRangeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_port: int,
                 start_port: int):
        """
        Port range details
        :param int end_port: End port of a range of ports
        :param int start_port: Starting port of a range of ports
        """
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "start_port", start_port)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> int:
        """
        End port of a range of ports
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> int:
        """
        Starting port of a range of ports
        """
        return pulumi.get(self, "start_port")


@pulumi.output_type
class NodeTypeDescriptionResponse(dict):
    """
    Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConnectionEndpointPort":
            suggest = "client_connection_endpoint_port"
        elif key == "httpGatewayEndpointPort":
            suggest = "http_gateway_endpoint_port"
        elif key == "isPrimary":
            suggest = "is_primary"
        elif key == "vmInstanceCount":
            suggest = "vm_instance_count"
        elif key == "applicationPorts":
            suggest = "application_ports"
        elif key == "durabilityLevel":
            suggest = "durability_level"
        elif key == "ephemeralPorts":
            suggest = "ephemeral_ports"
        elif key == "placementProperties":
            suggest = "placement_properties"
        elif key == "reverseProxyEndpointPort":
            suggest = "reverse_proxy_endpoint_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeTypeDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeTypeDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeTypeDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_connection_endpoint_port: int,
                 http_gateway_endpoint_port: int,
                 is_primary: bool,
                 name: str,
                 vm_instance_count: int,
                 application_ports: Optional['outputs.EndpointRangeDescriptionResponse'] = None,
                 capacities: Optional[Mapping[str, str]] = None,
                 durability_level: Optional[str] = None,
                 ephemeral_ports: Optional['outputs.EndpointRangeDescriptionResponse'] = None,
                 placement_properties: Optional[Mapping[str, str]] = None,
                 reverse_proxy_endpoint_port: Optional[int] = None):
        """
        Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
        :param int client_connection_endpoint_port: The TCP cluster management endpoint port.
        :param int http_gateway_endpoint_port: The HTTP cluster management endpoint port.
        :param bool is_primary: The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        :param str name: The name of the node type.
        :param int vm_instance_count: The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        :param 'EndpointRangeDescriptionResponse' application_ports: The range of ports from which cluster assigned port to Service Fabric applications.
        :param Mapping[str, str] capacities: The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        :param str durability_level: The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).
               
                 - Bronze - No privileges. This is the default.
                 - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
                 - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM SKUs like D15_V2, G5 etc.
        :param 'EndpointRangeDescriptionResponse' ephemeral_ports: The range of ephemeral ports that nodes in this node type should be configured with.
        :param Mapping[str, str] placement_properties: The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        :param int reverse_proxy_endpoint_port: The endpoint used by reverse proxy.
        """
        pulumi.set(__self__, "client_connection_endpoint_port", client_connection_endpoint_port)
        pulumi.set(__self__, "http_gateway_endpoint_port", http_gateway_endpoint_port)
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vm_instance_count", vm_instance_count)
        if application_ports is not None:
            pulumi.set(__self__, "application_ports", application_ports)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if durability_level is not None:
            pulumi.set(__self__, "durability_level", durability_level)
        if ephemeral_ports is not None:
            pulumi.set(__self__, "ephemeral_ports", ephemeral_ports)
        if placement_properties is not None:
            pulumi.set(__self__, "placement_properties", placement_properties)
        if reverse_proxy_endpoint_port is not None:
            pulumi.set(__self__, "reverse_proxy_endpoint_port", reverse_proxy_endpoint_port)

    @property
    @pulumi.getter(name="clientConnectionEndpointPort")
    def client_connection_endpoint_port(self) -> int:
        """
        The TCP cluster management endpoint port.
        """
        return pulumi.get(self, "client_connection_endpoint_port")

    @property
    @pulumi.getter(name="httpGatewayEndpointPort")
    def http_gateway_endpoint_port(self) -> int:
        """
        The HTTP cluster management endpoint port.
        """
        return pulumi.get(self, "http_gateway_endpoint_port")

    @property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> bool:
        """
        The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
        """
        return pulumi.get(self, "is_primary")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the node type.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="vmInstanceCount")
    def vm_instance_count(self) -> int:
        """
        The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
        """
        return pulumi.get(self, "vm_instance_count")

    @property
    @pulumi.getter(name="applicationPorts")
    def application_ports(self) -> Optional['outputs.EndpointRangeDescriptionResponse']:
        """
        The range of ports from which cluster assigned port to Service Fabric applications.
        """
        return pulumi.get(self, "application_ports")

    @property
    @pulumi.getter
    def capacities(self) -> Optional[Mapping[str, str]]:
        """
        The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="durabilityLevel")
    def durability_level(self) -> Optional[str]:
        """
        The durability level of the node type. Learn about [DurabilityLevel](https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity).

          - Bronze - No privileges. This is the default.
          - Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
          - Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold durability can be enabled only on full node VM SKUs like D15_V2, G5 etc.
        """
        return pulumi.get(self, "durability_level")

    @property
    @pulumi.getter(name="ephemeralPorts")
    def ephemeral_ports(self) -> Optional['outputs.EndpointRangeDescriptionResponse']:
        """
        The range of ephemeral ports that nodes in this node type should be configured with.
        """
        return pulumi.get(self, "ephemeral_ports")

    @property
    @pulumi.getter(name="placementProperties")
    def placement_properties(self) -> Optional[Mapping[str, str]]:
        """
        The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
        """
        return pulumi.get(self, "placement_properties")

    @property
    @pulumi.getter(name="reverseProxyEndpointPort")
    def reverse_proxy_endpoint_port(self) -> Optional[int]:
        """
        The endpoint used by reverse proxy.
        """
        return pulumi.get(self, "reverse_proxy_endpoint_port")


@pulumi.output_type
class ServerCertificateCommonNameResponse(dict):
    """
    Describes the server certificate details using common name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateCommonName":
            suggest = "certificate_common_name"
        elif key == "certificateIssuerThumbprint":
            suggest = "certificate_issuer_thumbprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCertificateCommonNameResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCertificateCommonNameResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCertificateCommonNameResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_common_name: str,
                 certificate_issuer_thumbprint: str):
        """
        Describes the server certificate details using common name.
        :param str certificate_common_name: The common name of the server certificate.
        :param str certificate_issuer_thumbprint: The issuer thumbprint of the server certificate.
        """
        pulumi.set(__self__, "certificate_common_name", certificate_common_name)
        pulumi.set(__self__, "certificate_issuer_thumbprint", certificate_issuer_thumbprint)

    @property
    @pulumi.getter(name="certificateCommonName")
    def certificate_common_name(self) -> str:
        """
        The common name of the server certificate.
        """
        return pulumi.get(self, "certificate_common_name")

    @property
    @pulumi.getter(name="certificateIssuerThumbprint")
    def certificate_issuer_thumbprint(self) -> str:
        """
        The issuer thumbprint of the server certificate.
        """
        return pulumi.get(self, "certificate_issuer_thumbprint")


@pulumi.output_type
class ServerCertificateCommonNamesResponse(dict):
    """
    Describes a list of server certificates referenced by common name that are used to secure the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonNames":
            suggest = "common_names"
        elif key == "x509StoreName":
            suggest = "x509_store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerCertificateCommonNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerCertificateCommonNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerCertificateCommonNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_names: Optional[Sequence['outputs.ServerCertificateCommonNameResponse']] = None,
                 x509_store_name: Optional[str] = None):
        """
        Describes a list of server certificates referenced by common name that are used to secure the cluster.
        :param Sequence['ServerCertificateCommonNameResponse'] common_names: The list of server certificates referenced by common name that are used to secure the cluster.
        :param str x509_store_name: The local certificate store location.
        """
        if common_names is not None:
            pulumi.set(__self__, "common_names", common_names)
        if x509_store_name is not None:
            pulumi.set(__self__, "x509_store_name", x509_store_name)

    @property
    @pulumi.getter(name="commonNames")
    def common_names(self) -> Optional[Sequence['outputs.ServerCertificateCommonNameResponse']]:
        """
        The list of server certificates referenced by common name that are used to secure the cluster.
        """
        return pulumi.get(self, "common_names")

    @property
    @pulumi.getter(name="x509StoreName")
    def x509_store_name(self) -> Optional[str]:
        """
        The local certificate store location.
        """
        return pulumi.get(self, "x509_store_name")


@pulumi.output_type
class ServiceTypeDeltaHealthPolicyResponse(dict):
    """
    Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentDeltaUnhealthyServices":
            suggest = "max_percent_delta_unhealthy_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTypeDeltaHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTypeDeltaHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTypeDeltaHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_delta_unhealthy_services: Optional[int] = None):
        """
        Represents the delta health policy used to evaluate the health of services belonging to a service type when upgrading the cluster.

        :param int max_percent_delta_unhealthy_services: The maximum allowed percentage of services health degradation allowed during cluster upgrades.
               The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
               The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        if max_percent_delta_unhealthy_services is None:
            max_percent_delta_unhealthy_services = 0
        if max_percent_delta_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_delta_unhealthy_services", max_percent_delta_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentDeltaUnhealthyServices")
    def max_percent_delta_unhealthy_services(self) -> Optional[int]:
        """
        The maximum allowed percentage of services health degradation allowed during cluster upgrades.
        The delta is measured between the state of the services at the beginning of upgrade and the state of the services at the time of the health evaluation.
        The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
        """
        return pulumi.get(self, "max_percent_delta_unhealthy_services")


@pulumi.output_type
class ServiceTypeHealthPolicyResponse(dict):
    """
    Represents the health policy used to evaluate the health of services belonging to a service type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPercentUnhealthyServices":
            suggest = "max_percent_unhealthy_services"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTypeHealthPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTypeHealthPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTypeHealthPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_percent_unhealthy_services: Optional[int] = None):
        """
        Represents the health policy used to evaluate the health of services belonging to a service type.

        :param int max_percent_unhealthy_services: The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        if max_percent_unhealthy_services is None:
            max_percent_unhealthy_services = 0
        if max_percent_unhealthy_services is not None:
            pulumi.set(__self__, "max_percent_unhealthy_services", max_percent_unhealthy_services)

    @property
    @pulumi.getter(name="maxPercentUnhealthyServices")
    def max_percent_unhealthy_services(self) -> Optional[int]:
        """
        The maximum percentage of services allowed to be unhealthy before your application is considered in error.
        """
        return pulumi.get(self, "max_percent_unhealthy_services")


@pulumi.output_type
class SettingsParameterDescriptionResponse(dict):
    """
    Describes a parameter in fabric settings of the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Describes a parameter in fabric settings of the cluster.
        :param str name: The parameter name of fabric setting.
        :param str value: The parameter value of fabric setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The parameter name of fabric setting.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The parameter value of fabric setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SettingsSectionDescriptionResponse(dict):
    """
    Describes a section in the fabric settings of the cluster.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: Sequence['outputs.SettingsParameterDescriptionResponse']):
        """
        Describes a section in the fabric settings of the cluster.
        :param str name: The section name of the fabric settings.
        :param Sequence['SettingsParameterDescriptionResponse'] parameters: The collection of parameters in the section.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The section name of the fabric settings.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.SettingsParameterDescriptionResponse']:
        """
        The collection of parameters in the section.
        """
        return pulumi.get(self, "parameters")


