# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AlertsDataTypeOfDataConnectorResponse',
    'AwsCloudTrailDataConnectorDataTypesResponse',
    'AwsCloudTrailDataConnectorDataTypesResponseLogs',
    'DataConnectorDataTypeCommonResponse',
    'IncidentAdditionalDataResponse',
    'IncidentInfoResponse',
    'IncidentLabelResponse',
    'IncidentOwnerInfoResponse',
    'MCASDataConnectorDataTypesResponse',
    'OfficeDataConnectorDataTypesResponse',
    'OfficeDataConnectorDataTypesResponseExchange',
    'OfficeDataConnectorDataTypesResponseSharePoint',
    'OfficeDataConnectorDataTypesResponseTeams',
    'TIDataConnectorDataTypesResponse',
    'TIDataConnectorDataTypesResponseIndicators',
    'UserInfoResponse',
]

@pulumi.output_type
class AlertsDataTypeOfDataConnectorResponse(dict):
    """
    Alerts data type for data connectors.
    """
    def __init__(__self__, *,
                 alerts: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None):
        """
        Alerts data type for data connectors.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponse(dict):
    """
    The available data types for Amazon Web Services CloudTrail data connector.
    """
    def __init__(__self__, *,
                 logs: Optional['outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs'] = None):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param 'AwsCloudTrailDataConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> Optional['outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs']:
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class DataConnectorDataTypeCommonResponse(dict):
    """
    Common field for data type in data connectors.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Common field for data type in data connectors.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class IncidentAdditionalDataResponse(dict):
    """
    Incident additional data property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertProductNames":
            suggest = "alert_product_names"
        elif key == "alertsCount":
            suggest = "alerts_count"
        elif key == "bookmarksCount":
            suggest = "bookmarks_count"
        elif key == "commentsCount":
            suggest = "comments_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentAdditionalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_product_names: Sequence[str],
                 alerts_count: int,
                 bookmarks_count: int,
                 comments_count: int,
                 tactics: Sequence[str]):
        """
        Incident additional data property bag.
        :param Sequence[str] alert_product_names: List of product names of alerts in the incident
        :param int alerts_count: The number of alerts in the incident
        :param int bookmarks_count: The number of bookmarks in the incident
        :param int comments_count: The number of comments in the incident
        :param Sequence[str] tactics: The tactics associated with incident
        """
        pulumi.set(__self__, "alert_product_names", alert_product_names)
        pulumi.set(__self__, "alerts_count", alerts_count)
        pulumi.set(__self__, "bookmarks_count", bookmarks_count)
        pulumi.set(__self__, "comments_count", comments_count)
        pulumi.set(__self__, "tactics", tactics)

    @property
    @pulumi.getter(name="alertProductNames")
    def alert_product_names(self) -> Sequence[str]:
        """
        List of product names of alerts in the incident
        """
        return pulumi.get(self, "alert_product_names")

    @property
    @pulumi.getter(name="alertsCount")
    def alerts_count(self) -> int:
        """
        The number of alerts in the incident
        """
        return pulumi.get(self, "alerts_count")

    @property
    @pulumi.getter(name="bookmarksCount")
    def bookmarks_count(self) -> int:
        """
        The number of bookmarks in the incident
        """
        return pulumi.get(self, "bookmarks_count")

    @property
    @pulumi.getter(name="commentsCount")
    def comments_count(self) -> int:
        """
        The number of comments in the incident
        """
        return pulumi.get(self, "comments_count")

    @property
    @pulumi.getter
    def tactics(self) -> Sequence[str]:
        """
        The tactics associated with incident
        """
        return pulumi.get(self, "tactics")


@pulumi.output_type
class IncidentInfoResponse(dict):
    """
    Describes related incident information for the bookmark
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incidentId":
            suggest = "incident_id"
        elif key == "relationName":
            suggest = "relation_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incident_id: Optional[str] = None,
                 relation_name: Optional[str] = None,
                 severity: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Describes related incident information for the bookmark
        :param str incident_id: Incident Id
        :param str relation_name: Relation Name
        :param str severity: The severity of the incident
        :param str title: The title of the incident
        """
        if incident_id is not None:
            pulumi.set(__self__, "incident_id", incident_id)
        if relation_name is not None:
            pulumi.set(__self__, "relation_name", relation_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="incidentId")
    def incident_id(self) -> Optional[str]:
        """
        Incident Id
        """
        return pulumi.get(self, "incident_id")

    @property
    @pulumi.getter(name="relationName")
    def relation_name(self) -> Optional[str]:
        """
        Relation Name
        """
        return pulumi.get(self, "relation_name")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        The title of the incident
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IncidentLabelResponse(dict):
    """
    Represents an incident label
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"
        elif key == "labelType":
            suggest = "label_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentLabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: str,
                 label_type: str):
        """
        Represents an incident label
        :param str label_name: The name of the label
        :param str label_type: The type of the label
        """
        pulumi.set(__self__, "label_name", label_name)
        pulumi.set(__self__, "label_type", label_type)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> str:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @property
    @pulumi.getter(name="labelType")
    def label_type(self) -> str:
        """
        The type of the label
        """
        return pulumi.get(self, "label_type")


@pulumi.output_type
class IncidentOwnerInfoResponse(dict):
    """
    Information on the user an incident is assigned to
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedTo":
            suggest = "assigned_to"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentOwnerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_to: Optional[str] = None,
                 email: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the user an incident is assigned to
        :param str assigned_to: The name of the user the incident is assigned to.
        :param str email: The email of the user the incident is assigned to.
        :param str object_id: The object id of the user the incident is assigned to.
        :param str user_principal_name: The user principal name of the user the incident is assigned to.
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[str]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class MCASDataConnectorDataTypesResponse(dict):
    """
    The available data types for MCAS (Microsoft Cloud App Security) data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryLogs":
            suggest = "discovery_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MCASDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None,
                 discovery_logs: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        :param 'DataConnectorDataTypeCommonResponse' discovery_logs: Discovery log data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponse(dict):
    """
    The available data types for office data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharePoint":
            suggest = "share_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfficeDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exchange: Optional['outputs.OfficeDataConnectorDataTypesResponseExchange'] = None,
                 share_point: Optional['outputs.OfficeDataConnectorDataTypesResponseSharePoint'] = None,
                 teams: Optional['outputs.OfficeDataConnectorDataTypesResponseTeams'] = None):
        """
        The available data types for office data connector.
        :param 'OfficeDataConnectorDataTypesResponseExchange' exchange: Exchange data type connection.
        :param 'OfficeDataConnectorDataTypesResponseSharePoint' share_point: SharePoint data type connection.
        :param 'OfficeDataConnectorDataTypesResponseTeams' teams: Teams data type connection.
        """
        if exchange is not None:
            pulumi.set(__self__, "exchange", exchange)
        if share_point is not None:
            pulumi.set(__self__, "share_point", share_point)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> Optional['outputs.OfficeDataConnectorDataTypesResponseExchange']:
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> Optional['outputs.OfficeDataConnectorDataTypesResponseSharePoint']:
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @property
    @pulumi.getter
    def teams(self) -> Optional['outputs.OfficeDataConnectorDataTypesResponseTeams']:
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseExchange(dict):
    """
    Exchange data type connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Exchange data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseSharePoint(dict):
    """
    SharePoint data type connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        SharePoint data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseTeams(dict):
    """
    Teams data type connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Teams data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class TIDataConnectorDataTypesResponse(dict):
    """
    The available data types for TI (Threat Intelligence) data connector.
    """
    def __init__(__self__, *,
                 indicators: Optional['outputs.TIDataConnectorDataTypesResponseIndicators'] = None):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param 'TIDataConnectorDataTypesResponseIndicators' indicators: Data type for indicators connection.
        """
        if indicators is not None:
            pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> Optional['outputs.TIDataConnectorDataTypesResponseIndicators']:
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")


@pulumi.output_type
class TIDataConnectorDataTypesResponseIndicators(dict):
    """
    Data type for indicators connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Data type for indicators connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class UserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: str):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


