# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AssessmentStatusArgs',
    'AzureResourceDetailsArgs',
    'OnPremiseResourceDetailsArgs',
    'OnPremiseSqlResourceDetailsArgs',
    'SecurityAssessmentMetadataPartnerDataArgs',
    'SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs',
    'SecurityAssessmentMetadataPropertiesArgs',
    'SecurityAssessmentPartnerDataArgs',
]

@pulumi.input_type
class AssessmentStatusArgs:
    def __init__(__self__, *,
                 code: pulumi.Input[Union[str, 'AssessmentStatusCode']],
                 cause: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        The result of the assessment
        :param pulumi.Input[Union[str, 'AssessmentStatusCode']] code: Programmatic code for the status of the assessment
        :param pulumi.Input[str] cause: Programmatic code for the cause of the assessment status
        :param pulumi.Input[str] description: Human readable description of the assessment status
        """
        pulumi.set(__self__, "code", code)
        if cause is not None:
            pulumi.set(__self__, "cause", cause)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input[Union[str, 'AssessmentStatusCode']]:
        """
        Programmatic code for the status of the assessment
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input[Union[str, 'AssessmentStatusCode']]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def cause(self) -> Optional[pulumi.Input[str]]:
        """
        Programmatic code for the cause of the assessment status
        """
        return pulumi.get(self, "cause")

    @cause.setter
    def cause(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cause", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of the assessment status
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AzureResourceDetailsArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[str]):
        """
        Details of the Azure resource that was assessed
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'Azure'.
        """
        pulumi.set(__self__, "source", 'Azure')

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'Azure'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class OnPremiseResourceDetailsArgs:
    def __init__(__self__, *,
                 machine_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_computer_id: pulumi.Input[str],
                 vmuuid: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        Details of the On Premise resource that was assessed
        :param pulumi.Input[str] machine_name: The name of the machine
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'OnPremise'.
        :param pulumi.Input[str] source_computer_id: The oms agent Id installed on the machine
        :param pulumi.Input[str] vmuuid: The unique Id of the machine
        :param pulumi.Input[str] workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "source", 'OnPremise')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremise'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> pulumi.Input[str]:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @source_computer_id.setter
    def source_computer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_computer_id", value)

    @property
    @pulumi.getter
    def vmuuid(self) -> pulumi.Input[str]:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @vmuuid.setter
    def vmuuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmuuid", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class OnPremiseSqlResourceDetailsArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 machine_name: pulumi.Input[str],
                 server_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 source_computer_id: pulumi.Input[str],
                 vmuuid: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        Details of the On Premise Sql resource that was assessed
        :param pulumi.Input[str] database_name: The Sql database name installed on the machine
        :param pulumi.Input[str] machine_name: The name of the machine
        :param pulumi.Input[str] server_name: The Sql server name installed on the machine
        :param pulumi.Input[str] source: The platform where the assessed resource resides
               Expected value is 'OnPremiseSql'.
        :param pulumi.Input[str] source_computer_id: The oms agent Id installed on the machine
        :param pulumi.Input[str] vmuuid: The unique Id of the machine
        :param pulumi.Input[str] workspace_id: Azure resource Id of the workspace the machine is attached to
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "machine_name", machine_name)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "source", 'OnPremiseSql')
        pulumi.set(__self__, "source_computer_id", source_computer_id)
        pulumi.set(__self__, "vmuuid", vmuuid)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        The Sql database name installed on the machine
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> pulumi.Input[str]:
        """
        The name of the machine
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "machine_name", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        """
        The Sql server name installed on the machine
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The platform where the assessed resource resides
        Expected value is 'OnPremiseSql'.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceComputerId")
    def source_computer_id(self) -> pulumi.Input[str]:
        """
        The oms agent Id installed on the machine
        """
        return pulumi.get(self, "source_computer_id")

    @source_computer_id.setter
    def source_computer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_computer_id", value)

    @property
    @pulumi.getter
    def vmuuid(self) -> pulumi.Input[str]:
        """
        The unique Id of the machine
        """
        return pulumi.get(self, "vmuuid")

    @vmuuid.setter
    def vmuuid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmuuid", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        Azure resource Id of the workspace the machine is attached to
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class SecurityAssessmentMetadataPartnerDataArgs:
    def __init__(__self__, *,
                 partner_name: pulumi.Input[str],
                 secret: pulumi.Input[str],
                 product_name: Optional[pulumi.Input[str]] = None):
        """
        Describes the partner that created the assessment
        :param pulumi.Input[str] partner_name: Name of the company of the partner
        :param pulumi.Input[str] secret: Secret to authenticate the partner and verify it created the assessment - write only
        :param pulumi.Input[str] product_name: Name of the product of the partner that created the assessment
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secret to authenticate the partner and verify it created the assessment - write only
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the product of the partner that created the assessment
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)


@pulumi.input_type
class SecurityAssessmentMetadataPropertiesResponsePublishDatesArgs:
    def __init__(__self__, *,
                 public: pulumi.Input[str],
                 g_a: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "public", public)
        if g_a is not None:
            pulumi.set(__self__, "g_a", g_a)

    @property
    @pulumi.getter
    def public(self) -> pulumi.Input[str]:
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: pulumi.Input[str]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="gA")
    def g_a(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "g_a")

    @g_a.setter
    def g_a(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "g_a", value)


@pulumi.input_type
class SecurityAssessmentMetadataPropertiesArgs:
    def __init__(__self__, *,
                 assessment_type: pulumi.Input[Union[str, 'AssessmentType']],
                 display_name: pulumi.Input[str],
                 severity: pulumi.Input[Union[str, 'Severity']],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 implementation_effort: Optional[pulumi.Input[Union[str, 'ImplementationEffort']]] = None,
                 partner_data: Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 remediation_description: Optional[pulumi.Input[str]] = None,
                 threats: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]] = None,
                 user_impact: Optional[pulumi.Input[Union[str, 'UserImpact']]] = None):
        """
        Describes properties of an assessment metadata.
        :param pulumi.Input[Union[str, 'AssessmentType']] assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        :param pulumi.Input[str] display_name: User friendly display name of the assessment
        :param pulumi.Input[Union[str, 'Severity']] severity: The severity level of the assessment
        :param pulumi.Input[str] description: Human readable description of the assessment
        :param pulumi.Input[Union[str, 'ImplementationEffort']] implementation_effort: The implementation effort required to remediate this assessment
        :param pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs'] partner_data: Describes the partner that created the assessment
        :param pulumi.Input[bool] preview: True if this assessment is in preview release status
        :param pulumi.Input[str] remediation_description: Human readable description of what you should do to mitigate this security issue
        :param pulumi.Input[Union[str, 'UserImpact']] user_impact: The user impact of the assessment
        """
        pulumi.set(__self__, "assessment_type", assessment_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "severity", severity)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if implementation_effort is not None:
            pulumi.set(__self__, "implementation_effort", implementation_effort)
        if partner_data is not None:
            pulumi.set(__self__, "partner_data", partner_data)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if remediation_description is not None:
            pulumi.set(__self__, "remediation_description", remediation_description)
        if threats is not None:
            pulumi.set(__self__, "threats", threats)
        if user_impact is not None:
            pulumi.set(__self__, "user_impact", user_impact)

    @property
    @pulumi.getter(name="assessmentType")
    def assessment_type(self) -> pulumi.Input[Union[str, 'AssessmentType']]:
        """
        BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
        """
        return pulumi.get(self, "assessment_type")

    @assessment_type.setter
    def assessment_type(self, value: pulumi.Input[Union[str, 'AssessmentType']]):
        pulumi.set(self, "assessment_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        User friendly display name of the assessment
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[Union[str, 'Severity']]:
        """
        The severity level of the assessment
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[Union[str, 'Severity']]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]]:
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Categories']]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of the assessment
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="implementationEffort")
    def implementation_effort(self) -> Optional[pulumi.Input[Union[str, 'ImplementationEffort']]]:
        """
        The implementation effort required to remediate this assessment
        """
        return pulumi.get(self, "implementation_effort")

    @implementation_effort.setter
    def implementation_effort(self, value: Optional[pulumi.Input[Union[str, 'ImplementationEffort']]]):
        pulumi.set(self, "implementation_effort", value)

    @property
    @pulumi.getter(name="partnerData")
    def partner_data(self) -> Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']]:
        """
        Describes the partner that created the assessment
        """
        return pulumi.get(self, "partner_data")

    @partner_data.setter
    def partner_data(self, value: Optional[pulumi.Input['SecurityAssessmentMetadataPartnerDataArgs']]):
        pulumi.set(self, "partner_data", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input[bool]]:
        """
        True if this assessment is in preview release status
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter(name="remediationDescription")
    def remediation_description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description of what you should do to mitigate this security issue
        """
        return pulumi.get(self, "remediation_description")

    @remediation_description.setter
    def remediation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation_description", value)

    @property
    @pulumi.getter
    def threats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]]:
        return pulumi.get(self, "threats")

    @threats.setter
    def threats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Threats']]]]]):
        pulumi.set(self, "threats", value)

    @property
    @pulumi.getter(name="userImpact")
    def user_impact(self) -> Optional[pulumi.Input[Union[str, 'UserImpact']]]:
        """
        The user impact of the assessment
        """
        return pulumi.get(self, "user_impact")

    @user_impact.setter
    def user_impact(self, value: Optional[pulumi.Input[Union[str, 'UserImpact']]]):
        pulumi.set(self, "user_impact", value)


@pulumi.input_type
class SecurityAssessmentPartnerDataArgs:
    def __init__(__self__, *,
                 partner_name: pulumi.Input[str],
                 secret: pulumi.Input[str]):
        """
        Data regarding 3rd party partner integration
        :param pulumi.Input[str] partner_name: Name of the company of the partner
        :param pulumi.Input[str] secret: secret to authenticate the partner - write only
        """
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        Name of the company of the partner
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        secret to authenticate the partner - write only
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)


