# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'JitNetworkAccessPolicyVirtualMachineArgs',
    'JitNetworkAccessPortRuleArgs',
    'JitNetworkAccessRequestPortArgs',
    'JitNetworkAccessRequestVirtualMachineArgs',
    'JitNetworkAccessRequestArgs',
    'PathRecommendationArgs',
    'ProtectionModeArgs',
    'PublisherInfoArgs',
    'UserRecommendationArgs',
    'VmRecommendationArgs',
]

@pulumi.input_type
class JitNetworkAccessPolicyVirtualMachineArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ports: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]],
                 public_ip_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Resource ID of the virtual machine that is linked to this policy
        :param pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]] ports: Port configurations for the virtual machine
        :param pulumi.Input[str] public_ip_address: Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]]:
        """
        Port configurations for the virtual machine
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessPortRuleArgs']]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the Azure Firewall that is linked to this policy, if applicable
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address", value)


@pulumi.input_type
class JitNetworkAccessPortRuleArgs:
    def __init__(__self__, *,
                 max_request_access_duration: pulumi.Input[str],
                 number: pulumi.Input[int],
                 protocol: pulumi.Input[Union[str, 'Protocol']],
                 allowed_source_address_prefix: Optional[pulumi.Input[str]] = None,
                 allowed_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] max_request_access_duration: Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        :param pulumi.Input[str] allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        pulumi.set(__self__, "max_request_access_duration", max_request_access_duration)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "protocol", protocol)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)

    @property
    @pulumi.getter(name="maxRequestAccessDuration")
    def max_request_access_duration(self) -> pulumi.Input[str]:
        """
        Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
        """
        return pulumi.get(self, "max_request_access_duration")

    @max_request_access_duration.setter
    def max_request_access_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "max_request_access_duration", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[Union[str, 'Protocol']]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[Union[str, 'Protocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @allowed_source_address_prefix.setter
    def allowed_source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_source_address_prefix", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @allowed_source_address_prefixes.setter
    def allowed_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_source_address_prefixes", value)


@pulumi.input_type
class JitNetworkAccessRequestPortArgs:
    def __init__(__self__, *,
                 end_time_utc: pulumi.Input[str],
                 number: pulumi.Input[int],
                 status: pulumi.Input[Union[str, 'Status']],
                 status_reason: pulumi.Input[Union[str, 'StatusReason']],
                 allowed_source_address_prefix: Optional[pulumi.Input[str]] = None,
                 allowed_source_address_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mapped_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] end_time_utc: The date & time at which the request ends in UTC
        :param pulumi.Input[Union[str, 'Status']] status: The status of the port
        :param pulumi.Input[Union[str, 'StatusReason']] status_reason: A description of why the `status` has its value
        :param pulumi.Input[str] allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        :param pulumi.Input[int] mapped_port: The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_reason", status_reason)
        if allowed_source_address_prefix is not None:
            pulumi.set(__self__, "allowed_source_address_prefix", allowed_source_address_prefix)
        if allowed_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_source_address_prefixes", allowed_source_address_prefixes)
        if mapped_port is not None:
            pulumi.set(__self__, "mapped_port", mapped_port)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> pulumi.Input[str]:
        """
        The date & time at which the request ends in UTC
        """
        return pulumi.get(self, "end_time_utc")

    @end_time_utc.setter
    def end_time_utc(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time_utc", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'Status']]:
        """
        The status of the port
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'Status']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Input[Union[str, 'StatusReason']]:
        """
        A description of why the `status` has its value
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: pulumi.Input[Union[str, 'StatusReason']]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefix")
    def allowed_source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
        """
        return pulumi.get(self, "allowed_source_address_prefix")

    @allowed_source_address_prefix.setter
    def allowed_source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_source_address_prefix", value)

    @property
    @pulumi.getter(name="allowedSourceAddressPrefixes")
    def allowed_source_address_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
        """
        return pulumi.get(self, "allowed_source_address_prefixes")

    @allowed_source_address_prefixes.setter
    def allowed_source_address_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_source_address_prefixes", value)

    @property
    @pulumi.getter(name="mappedPort")
    def mapped_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port which is mapped to this port's `number` in the Azure Firewall, if applicable
        """
        return pulumi.get(self, "mapped_port")

    @mapped_port.setter
    def mapped_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mapped_port", value)


@pulumi.input_type
class JitNetworkAccessRequestVirtualMachineArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 ports: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]):
        """
        :param pulumi.Input[str] id: Resource ID of the virtual machine that is linked to this policy
        :param pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]] ports: The ports that were opened for the virtual machine
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Resource ID of the virtual machine that is linked to this policy
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]:
        """
        The ports that were opened for the virtual machine
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestPortArgs']]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class JitNetworkAccessRequestArgs:
    def __init__(__self__, *,
                 requestor: pulumi.Input[str],
                 start_time_utc: pulumi.Input[str],
                 virtual_machines: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]],
                 justification: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] requestor: The identity of the person who made the request
        :param pulumi.Input[str] start_time_utc: The start time of the request in UTC
        :param pulumi.Input[str] justification: The justification for making the initiate request
        """
        pulumi.set(__self__, "requestor", requestor)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "virtual_machines", virtual_machines)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)

    @property
    @pulumi.getter
    def requestor(self) -> pulumi.Input[str]:
        """
        The identity of the person who made the request
        """
        return pulumi.get(self, "requestor")

    @requestor.setter
    def requestor(self, value: pulumi.Input[str]):
        pulumi.set(self, "requestor", value)

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> pulumi.Input[str]:
        """
        The start time of the request in UTC
        """
        return pulumi.get(self, "start_time_utc")

    @start_time_utc.setter
    def start_time_utc(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time_utc", value)

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]]:
        return pulumi.get(self, "virtual_machines")

    @virtual_machines.setter
    def virtual_machines(self, value: pulumi.Input[Sequence[pulumi.Input['JitNetworkAccessRequestVirtualMachineArgs']]]):
        pulumi.set(self, "virtual_machines", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[str]]:
        """
        The justification for making the initiate request
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "justification", value)


@pulumi.input_type
class PathRecommendationArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 common: Optional[pulumi.Input[bool]] = None,
                 configuration_status: Optional[pulumi.Input[str]] = None,
                 file_type: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 publisher_info: Optional[pulumi.Input['PublisherInfoArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_sids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 usernames: Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]] = None):
        """
        Represents a path that is recommended to be allowed and its properties
        :param pulumi.Input[str] action: The recommendation action of the VM/server or rule
        :param pulumi.Input[bool] common: Whether the path is commonly run on the machine
        :param pulumi.Input[str] configuration_status: The configuration status of the VM/server group or machine or rule on the machine
        :param pulumi.Input[str] file_type: The type of the file (for Linux files - Executable is used)
        :param pulumi.Input[str] path: The full path to whitelist
        :param pulumi.Input['PublisherInfoArgs'] publisher_info: Represents the publisher information of a process/rule
        :param pulumi.Input[str] type: The type of the rule to be allowed
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if common is not None:
            pulumi.set(__self__, "common", common)
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if file_type is not None:
            pulumi.set(__self__, "file_type", file_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if publisher_info is not None:
            pulumi.set(__self__, "publisher_info", publisher_info)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_sids is not None:
            pulumi.set(__self__, "user_sids", user_sids)
        if usernames is not None:
            pulumi.set(__self__, "usernames", usernames)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the VM/server or rule
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def common(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the path is commonly run on the machine
        """
        return pulumi.get(self, "common")

    @common.setter
    def common(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "common", value)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration status of the VM/server group or machine or rule on the machine
        """
        return pulumi.get(self, "configuration_status")

    @configuration_status.setter
    def configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_status", value)

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the file (for Linux files - Executable is used)
        """
        return pulumi.get(self, "file_type")

    @file_type.setter
    def file_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to whitelist
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="publisherInfo")
    def publisher_info(self) -> Optional[pulumi.Input['PublisherInfoArgs']]:
        """
        Represents the publisher information of a process/rule
        """
        return pulumi.get(self, "publisher_info")

    @publisher_info.setter
    def publisher_info(self, value: Optional[pulumi.Input['PublisherInfoArgs']]):
        pulumi.set(self, "publisher_info", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the rule to be allowed
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userSids")
    def user_sids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "user_sids")

    @user_sids.setter
    def user_sids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_sids", value)

    @property
    @pulumi.getter
    def usernames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]]:
        return pulumi.get(self, "usernames")

    @usernames.setter
    def usernames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserRecommendationArgs']]]]):
        pulumi.set(self, "usernames", value)


@pulumi.input_type
class ProtectionModeArgs:
    def __init__(__self__, *,
                 exe: Optional[pulumi.Input[str]] = None,
                 executable: Optional[pulumi.Input[str]] = None,
                 msi: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None):
        """
        The protection mode of the collection/file types. Exe/Msi/Script are used for Windows, Executable is used for Linux.
        :param pulumi.Input[str] exe: The application control policy enforcement/protection mode of the VM/server group
        :param pulumi.Input[str] executable: The application control policy enforcement/protection mode of the VM/server group
        :param pulumi.Input[str] msi: The application control policy enforcement/protection mode of the VM/server group
        :param pulumi.Input[str] script: The application control policy enforcement/protection mode of the VM/server group
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if msi is not None:
            pulumi.set(__self__, "msi", msi)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def exe(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "exe")

    @exe.setter
    def exe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exe", value)

    @property
    @pulumi.getter
    def executable(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "executable")

    @executable.setter
    def executable(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "executable", value)

    @property
    @pulumi.getter
    def msi(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "msi")

    @msi.setter
    def msi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msi", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        The application control policy enforcement/protection mode of the VM/server group
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


@pulumi.input_type
class PublisherInfoArgs:
    def __init__(__self__, *,
                 binary_name: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 publisher_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Represents the publisher information of a process/rule
        :param pulumi.Input[str] binary_name: The "OriginalName" field taken from the file's version resource
        :param pulumi.Input[str] product_name: The product name taken from the file's version resource
        :param pulumi.Input[str] publisher_name: The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        :param pulumi.Input[str] version: The binary file version taken from the file's version resource
        """
        if binary_name is not None:
            pulumi.set(__self__, "binary_name", binary_name)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="binaryName")
    def binary_name(self) -> Optional[pulumi.Input[str]]:
        """
        The "OriginalName" field taken from the file's version resource
        """
        return pulumi.get(self, "binary_name")

    @binary_name.setter
    def binary_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binary_name", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        The product name taken from the file's version resource
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The binary file version taken from the file's version resource
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class UserRecommendationArgs:
    def __init__(__self__, *,
                 recommendation_action: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Represents a user that is recommended to be allowed for a certain rule
        :param pulumi.Input[str] recommendation_action: The recommendation action of the VM/server or rule
        :param pulumi.Input[str] username: Represents a user that is recommended to be allowed for a certain rule
        """
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the VM/server or rule
        """
        return pulumi.get(self, "recommendation_action")

    @recommendation_action.setter
    def recommendation_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_action", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Represents a user that is recommended to be allowed for a certain rule
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VmRecommendationArgs:
    def __init__(__self__, *,
                 configuration_status: Optional[pulumi.Input[str]] = None,
                 enforcement_support: Optional[pulumi.Input[str]] = None,
                 recommendation_action: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Represents a machine that is part of a VM/server group
        :param pulumi.Input[str] configuration_status: The configuration status of the VM/server group or machine or rule on the machine
        :param pulumi.Input[str] enforcement_support: The VM/server supportability of Enforce feature
        :param pulumi.Input[str] recommendation_action: The recommendation action of the VM/server or rule
        :param pulumi.Input[str] resource_id: The full azure resource id of the machine
        """
        if configuration_status is not None:
            pulumi.set(__self__, "configuration_status", configuration_status)
        if enforcement_support is not None:
            pulumi.set(__self__, "enforcement_support", enforcement_support)
        if recommendation_action is not None:
            pulumi.set(__self__, "recommendation_action", recommendation_action)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="configurationStatus")
    def configuration_status(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration status of the VM/server group or machine or rule on the machine
        """
        return pulumi.get(self, "configuration_status")

    @configuration_status.setter
    def configuration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_status", value)

    @property
    @pulumi.getter(name="enforcementSupport")
    def enforcement_support(self) -> Optional[pulumi.Input[str]]:
        """
        The VM/server supportability of Enforce feature
        """
        return pulumi.get(self, "enforcement_support")

    @enforcement_support.setter
    def enforcement_support(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enforcement_support", value)

    @property
    @pulumi.getter(name="recommendationAction")
    def recommendation_action(self) -> Optional[pulumi.Input[str]]:
        """
        The recommendation action of the VM/server or rule
        """
        return pulumi.get(self, "recommendation_action")

    @recommendation_action.setter
    def recommendation_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recommendation_action", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The full azure resource id of the machine
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


