# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'BackupManagementType',
    'CreateMode',
    'DataSourceType',
    'HealthStatus',
    'LastBackupStatus',
    'ProtectedItemHealthStatus',
    'ProtectedItemState',
    'ProtectionState',
    'ResourceHealthStatus',
]


class BackupManagementType(str, Enum):
    """
    Type of backup management for the backed up item.
    """
    INVALID = "Invalid"
    AZURE_IAAS_VM = "AzureIaasVM"
    MAB = "MAB"
    DPM = "DPM"
    AZURE_BACKUP_SERVER = "AzureBackupServer"
    AZURE_SQL = "AzureSql"
    AZURE_STORAGE = "AzureStorage"
    AZURE_WORKLOAD = "AzureWorkload"
    DEFAULT_BACKUP = "DefaultBackup"


class CreateMode(str, Enum):
    """
    Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
    """
    INVALID = "Invalid"
    DEFAULT = "Default"
    RECOVER = "Recover"


class DataSourceType(str, Enum):
    """
    Type of workload this item represents.
    """
    INVALID = "Invalid"
    VM = "VM"
    FILE_FOLDER = "FileFolder"
    AZURE_SQL_DB = "AzureSqlDb"
    SQLDB = "SQLDB"
    EXCHANGE = "Exchange"
    SHAREPOINT = "Sharepoint"
    V_MWARE_VM = "VMwareVM"
    SYSTEM_STATE = "SystemState"
    CLIENT = "Client"
    GENERIC_DATA_SOURCE = "GenericDataSource"
    SQL_DATA_BASE = "SQLDataBase"
    AZURE_FILE_SHARE = "AzureFileShare"
    SAP_HANA_DATABASE = "SAPHanaDatabase"
    SAPASE_DATABASE = "SAPAseDatabase"


class HealthStatus(str, Enum):
    """
    Health status of protected item.
    """
    PASSED = "Passed"
    ACTION_REQUIRED = "ActionRequired"
    ACTION_SUGGESTED = "ActionSuggested"
    INVALID = "Invalid"


class LastBackupStatus(str, Enum):
    """
    Last backup operation status. Possible values: Healthy, Unhealthy.
    """
    INVALID = "Invalid"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    IR_PENDING = "IRPending"


class ProtectedItemHealthStatus(str, Enum):
    """
    Health status of the backup item, evaluated based on last heartbeat received
    """
    INVALID = "Invalid"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    NOT_REACHABLE = "NotReachable"
    IR_PENDING = "IRPending"


class ProtectedItemState(str, Enum):
    """
    Protection state of the backup engine
    """
    INVALID = "Invalid"
    IR_PENDING = "IRPending"
    PROTECTED = "Protected"
    PROTECTION_ERROR = "ProtectionError"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_PAUSED = "ProtectionPaused"


class ProtectionState(str, Enum):
    """
    Backup state of this backup item.
    """
    INVALID = "Invalid"
    IR_PENDING = "IRPending"
    PROTECTED = "Protected"
    PROTECTION_ERROR = "ProtectionError"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_PAUSED = "ProtectionPaused"


class ResourceHealthStatus(str, Enum):
    """
    Resource Health Status
    """
    HEALTHY = "Healthy"
    TRANSIENT_DEGRADED = "TransientDegraded"
    PERSISTENT_DEGRADED = "PersistentDegraded"
    TRANSIENT_UNHEALTHY = "TransientUnhealthy"
    PERSISTENT_UNHEALTHY = "PersistentUnhealthy"
    INVALID = "Invalid"
