# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureBackupServerContainerArgs',
    'AzureIaaSClassicComputeVMContainerArgs',
    'AzureIaaSComputeVMContainerArgs',
    'AzureSQLAGWorkloadContainerProtectionContainerArgs',
    'AzureSqlContainerArgs',
    'AzureStorageContainerArgs',
    'AzureVMAppContainerProtectionContainerArgs',
    'AzureWorkloadContainerExtendedInfoArgs',
    'AzureWorkloadContainerArgs',
    'ContainerIdentityInfoArgs',
    'DPMContainerExtendedInfoArgs',
    'DistributedNodesInfoArgs',
    'DpmContainerArgs',
    'GenericContainerExtendedInfoArgs',
    'GenericContainerArgs',
    'IaaSVMContainerArgs',
    'InquiryInfoArgs',
    'InquiryValidationArgs',
    'MABContainerHealthDetailsArgs',
    'MabContainerExtendedInfoArgs',
    'MabContainerArgs',
    'WorkloadInquiryDetailsArgs',
]

@pulumi.input_type
class AzureBackupServerContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 can_re_register: Optional[pulumi.Input[bool]] = None,
                 container_id: Optional[pulumi.Input[str]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 dpm_agent_version: Optional[pulumi.Input[str]] = None,
                 dpm_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_info: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 upgrade_available: Optional[pulumi.Input[bool]] = None):
        """
        AzureBackupServer (DPMVenus) workload-specific protection container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[bool] can_re_register: Specifies whether the container is re-registrable.
        :param pulumi.Input[str] container_id: ID of container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureBackupServerContainer'.
        :param pulumi.Input[str] dpm_agent_version: Backup engine Agent version
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dpm_servers: List of BackupEngines protecting the container
        :param pulumi.Input['DPMContainerExtendedInfoArgs'] extended_info: Extended Info of the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[float] protected_item_count: Number of protected items in the BackupEngine
        :param pulumi.Input[str] protection_status: Protection status of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[bool] upgrade_available: To check if upgrade available
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'AzureBackupServerContainer')
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @can_re_register.setter
    def can_re_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_re_register", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureBackupServerContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @dpm_agent_version.setter
    def dpm_agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpm_agent_version", value)

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @dpm_servers.setter
    def dpm_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dpm_servers", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")

    @upgrade_available.setter
    def upgrade_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_available", value)


@pulumi.input_type
class AzureIaaSClassicComputeVMContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_version: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific backup item representing a classic virtual machine.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param pulumi.Input[str] virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'Microsoft.ClassicCompute/virtualMachines')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")

    @virtual_machine_version.setter
    def virtual_machine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_version", value)


@pulumi.input_type
class AzureIaaSComputeVMContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_version: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param pulumi.Input[str] virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'Microsoft.Compute/virtualMachines')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")

    @virtual_machine_version.setter
    def virtual_machine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_version", value)


@pulumi.input_type
class AzureSQLAGWorkloadContainerProtectionContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[Union[str, 'OperationType']]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Container for SQL workloads under SQL Availability Group.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'SQLAGWorkLoadContainer'.
        :param pulumi.Input['AzureWorkloadContainerExtendedInfoArgs'] extended_info: Additional details of a workload container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] last_updated_time: Time stamp when this container was updated.
        :param pulumi.Input[Union[str, 'OperationType']] operation_type: Re-Do Operation
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param pulumi.Input[Union[str, 'WorkloadType']] workload_type: Workload type for which registration was sent.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'SQLAGWorkLoadContainer')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'SQLAGWorkLoadContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[Union[str, 'OperationType']]]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[Union[str, 'OperationType']]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureSqlContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None):
        """
        Azure Sql workload-specific container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureSqlContainer'.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'AzureSqlContainer')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureSqlContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)


@pulumi.input_type
class AzureStorageContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 storage_account_version: Optional[pulumi.Input[str]] = None):
        """
        Azure Storage Account workload-specific container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'StorageContainer'.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[float] protected_item_count: Number of items backed up in this container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: Fully qualified ARM url.
        :param pulumi.Input[str] storage_account_version: Storage account version.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'StorageContainer')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if storage_account_version is not None:
            pulumi.set(__self__, "storage_account_version", storage_account_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'StorageContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="storageAccountVersion")
    def storage_account_version(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account version.
        """
        return pulumi.get(self, "storage_account_version")

    @storage_account_version.setter
    def storage_account_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_version", value)


@pulumi.input_type
class AzureVMAppContainerProtectionContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[Union[str, 'OperationType']]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Container for SQL workloads under Azure Virtual Machines.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'VMAppContainer'.
        :param pulumi.Input['AzureWorkloadContainerExtendedInfoArgs'] extended_info: Additional details of a workload container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] last_updated_time: Time stamp when this container was updated.
        :param pulumi.Input[Union[str, 'OperationType']] operation_type: Re-Do Operation
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param pulumi.Input[Union[str, 'WorkloadType']] workload_type: Workload type for which registration was sent.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'VMAppContainer')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'VMAppContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[Union[str, 'OperationType']]]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[Union[str, 'OperationType']]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureWorkloadContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 host_server_name: Optional[pulumi.Input[str]] = None,
                 inquiry_info: Optional[pulumi.Input['InquiryInfoArgs']] = None,
                 nodes_list: Optional[pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]]] = None):
        """
        Extended information of the container.
        :param pulumi.Input[str] host_server_name: Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        :param pulumi.Input['InquiryInfoArgs'] inquiry_info: Inquiry Status for the container.
        :param pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]] nodes_list: List of the nodes in case of distributed container.
        """
        if host_server_name is not None:
            pulumi.set(__self__, "host_server_name", host_server_name)
        if inquiry_info is not None:
            pulumi.set(__self__, "inquiry_info", inquiry_info)
        if nodes_list is not None:
            pulumi.set(__self__, "nodes_list", nodes_list)

    @property
    @pulumi.getter(name="hostServerName")
    def host_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        """
        return pulumi.get(self, "host_server_name")

    @host_server_name.setter
    def host_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_server_name", value)

    @property
    @pulumi.getter(name="inquiryInfo")
    def inquiry_info(self) -> Optional[pulumi.Input['InquiryInfoArgs']]:
        """
        Inquiry Status for the container.
        """
        return pulumi.get(self, "inquiry_info")

    @inquiry_info.setter
    def inquiry_info(self, value: Optional[pulumi.Input['InquiryInfoArgs']]):
        pulumi.set(self, "inquiry_info", value)

    @property
    @pulumi.getter(name="nodesList")
    def nodes_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]]]:
        """
        List of the nodes in case of distributed container.
        """
        return pulumi.get(self, "nodes_list")

    @nodes_list.setter
    def nodes_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]]]):
        pulumi.set(self, "nodes_list", value)


@pulumi.input_type
class AzureWorkloadContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[Union[str, 'OperationType']]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Container for the workloads running inside Azure Compute or Classic Compute.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureWorkloadContainer'.
        :param pulumi.Input['AzureWorkloadContainerExtendedInfoArgs'] extended_info: Additional details of a workload container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] last_updated_time: Time stamp when this container was updated.
        :param pulumi.Input[Union[str, 'OperationType']] operation_type: Re-Do Operation
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param pulumi.Input[Union[str, 'WorkloadType']] workload_type: Workload type for which registration was sent.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'AzureWorkloadContainer')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureWorkloadContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[Union[str, 'OperationType']]]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[Union[str, 'OperationType']]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class ContainerIdentityInfoArgs:
    def __init__(__self__, *,
                 aad_tenant_id: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 service_principal_client_id: Optional[pulumi.Input[str]] = None,
                 unique_name: Optional[pulumi.Input[str]] = None):
        """
        Container identity information
        :param pulumi.Input[str] aad_tenant_id: Protection container identity - AAD Tenant
        :param pulumi.Input[str] audience: Protection container identity - Audience
        :param pulumi.Input[str] service_principal_client_id: Protection container identity - AAD Service Principal
        :param pulumi.Input[str] unique_name: Unique name of the container
        """
        if aad_tenant_id is not None:
            pulumi.set(__self__, "aad_tenant_id", aad_tenant_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if service_principal_client_id is not None:
            pulumi.set(__self__, "service_principal_client_id", service_principal_client_id)
        if unique_name is not None:
            pulumi.set(__self__, "unique_name", unique_name)

    @property
    @pulumi.getter(name="aadTenantId")
    def aad_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Protection container identity - AAD Tenant
        """
        return pulumi.get(self, "aad_tenant_id")

    @aad_tenant_id.setter
    def aad_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_tenant_id", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Protection container identity - Audience
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="servicePrincipalClientId")
    def service_principal_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Protection container identity - AAD Service Principal
        """
        return pulumi.get(self, "service_principal_client_id")

    @service_principal_client_id.setter
    def service_principal_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_client_id", value)

    @property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the container
        """
        return pulumi.get(self, "unique_name")

    @unique_name.setter
    def unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_name", value)


@pulumi.input_type
class DPMContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None):
        """
        Additional information of the DPMContainer.
        :param pulumi.Input[str] last_refreshed_at: Last refresh time of the DPMContainer.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last refresh time of the DPMContainer.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)


@pulumi.input_type
class DistributedNodesInfoArgs:
    def __init__(__self__, *,
                 node_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        This is used to represent the various nodes of the distributed container.
        :param pulumi.Input[str] node_name: Name of the node under a distributed container.
        :param pulumi.Input[str] status: Status of this Node.
               Failed | Succeeded
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the node under a distributed container.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of this Node.
        Failed | Succeeded
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class DpmContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 can_re_register: Optional[pulumi.Input[bool]] = None,
                 container_id: Optional[pulumi.Input[str]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 dpm_agent_version: Optional[pulumi.Input[str]] = None,
                 dpm_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_info: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 upgrade_available: Optional[pulumi.Input[bool]] = None):
        """
        DPM workload-specific protection container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[bool] can_re_register: Specifies whether the container is re-registrable.
        :param pulumi.Input[str] container_id: ID of container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'DPMContainer'.
        :param pulumi.Input[str] dpm_agent_version: Backup engine Agent version
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dpm_servers: List of BackupEngines protecting the container
        :param pulumi.Input['DPMContainerExtendedInfoArgs'] extended_info: Extended Info of the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[float] protected_item_count: Number of protected items in the BackupEngine
        :param pulumi.Input[str] protection_status: Protection status of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[bool] upgrade_available: To check if upgrade available
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'DPMContainer')
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @can_re_register.setter
    def can_re_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_re_register", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'DPMContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @dpm_agent_version.setter
    def dpm_agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpm_agent_version", value)

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @dpm_servers.setter
    def dpm_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dpm_servers", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")

    @upgrade_available.setter
    def upgrade_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_available", value)


@pulumi.input_type
class GenericContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 container_identity_info: Optional[pulumi.Input['ContainerIdentityInfoArgs']] = None,
                 raw_cert_data: Optional[pulumi.Input[str]] = None,
                 service_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container extended information
        :param pulumi.Input['ContainerIdentityInfoArgs'] container_identity_info: Container identity information
        :param pulumi.Input[str] raw_cert_data: Public key of container cert
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_endpoints: Azure Backup Service Endpoints for the container
        """
        if container_identity_info is not None:
            pulumi.set(__self__, "container_identity_info", container_identity_info)
        if raw_cert_data is not None:
            pulumi.set(__self__, "raw_cert_data", raw_cert_data)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter(name="containerIdentityInfo")
    def container_identity_info(self) -> Optional[pulumi.Input['ContainerIdentityInfoArgs']]:
        """
        Container identity information
        """
        return pulumi.get(self, "container_identity_info")

    @container_identity_info.setter
    def container_identity_info(self, value: Optional[pulumi.Input['ContainerIdentityInfoArgs']]):
        pulumi.set(self, "container_identity_info", value)

    @property
    @pulumi.getter(name="rawCertData")
    def raw_cert_data(self) -> Optional[pulumi.Input[str]]:
        """
        Public key of container cert
        """
        return pulumi.get(self, "raw_cert_data")

    @raw_cert_data.setter
    def raw_cert_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_cert_data", value)

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Azure Backup Service Endpoints for the container
        """
        return pulumi.get(self, "service_endpoints")

    @service_endpoints.setter
    def service_endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "service_endpoints", value)


@pulumi.input_type
class GenericContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 extended_information: Optional[pulumi.Input['GenericContainerExtendedInfoArgs']] = None,
                 fabric_name: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None):
        """
        Base class for generic container of backup items
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'GenericContainer'.
        :param pulumi.Input['GenericContainerExtendedInfoArgs'] extended_information: Extended information (not returned in List container API calls)
        :param pulumi.Input[str] fabric_name: Name of the container's fabric
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'GenericContainer')
        if extended_information is not None:
            pulumi.set(__self__, "extended_information", extended_information)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'GenericContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="extendedInformation")
    def extended_information(self) -> Optional[pulumi.Input['GenericContainerExtendedInfoArgs']]:
        """
        Extended information (not returned in List container API calls)
        """
        return pulumi.get(self, "extended_information")

    @extended_information.setter
    def extended_information(self, value: Optional[pulumi.Input['GenericContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_information", value)

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container's fabric
        """
        return pulumi.get(self, "fabric_name")

    @fabric_name.setter
    def fabric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_name", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)


@pulumi.input_type
class IaaSVMContainerArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_version: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'IaaSVMContainer'.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param pulumi.Input[str] virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'IaaSVMContainer')
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'IaaSVMContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")

    @virtual_machine_version.setter
    def virtual_machine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_version", value)


@pulumi.input_type
class InquiryInfoArgs:
    def __init__(__self__, *,
                 inquiry_details: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Details about inquired protectable items under a given container.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]] inquiry_details: Inquiry Details which will have workload specific details.
               For e.g. - For SQL and oracle this will contain different details.
        :param pulumi.Input[str] status: Inquiry Status for this container such as
               InProgress | Failed | Succeeded
        """
        if inquiry_details is not None:
            pulumi.set(__self__, "inquiry_details", inquiry_details)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="inquiryDetails")
    def inquiry_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]]]:
        """
        Inquiry Details which will have workload specific details.
        For e.g. - For SQL and oracle this will contain different details.
        """
        return pulumi.get(self, "inquiry_details")

    @inquiry_details.setter
    def inquiry_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]]]):
        pulumi.set(self, "inquiry_details", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Inquiry Status for this container such as
        InProgress | Failed | Succeeded
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class InquiryValidationArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Validation for inquired protectable items under a given container.
        :param pulumi.Input[str] status: Status for the Inquiry Validation.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status for the Inquiry Validation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class MABContainerHealthDetailsArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 recommendations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        MAB workload-specific Health Details.
        :param pulumi.Input[int] code: Health Code
        :param pulumi.Input[str] message: Health Message
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recommendations: Health Recommended Actions
        :param pulumi.Input[str] title: Health Title
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if recommendations is not None:
            pulumi.set(__self__, "recommendations", recommendations)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def recommendations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @recommendations.setter
    def recommendations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "recommendations", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Health Title
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class MabContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 backup_item_type: Optional[pulumi.Input[Union[str, 'BackupItemType']]] = None,
                 backup_items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        Additional information of the container.
        :param pulumi.Input[Union[str, 'BackupItemType']] backup_item_type: Type of backup items associated with this container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_items: List of backup items associated with this container.
        :param pulumi.Input[str] last_backup_status: Latest backup status of this container.
        :param pulumi.Input[str] last_refreshed_at: Time stamp when this container was refreshed.
        :param pulumi.Input[str] policy_name: Backup policy associated with this container.
        """
        if backup_item_type is not None:
            pulumi.set(__self__, "backup_item_type", backup_item_type)
        if backup_items is not None:
            pulumi.set(__self__, "backup_items", backup_items)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="backupItemType")
    def backup_item_type(self) -> Optional[pulumi.Input[Union[str, 'BackupItemType']]]:
        """
        Type of backup items associated with this container.
        """
        return pulumi.get(self, "backup_item_type")

    @backup_item_type.setter
    def backup_item_type(self, value: Optional[pulumi.Input[Union[str, 'BackupItemType']]]):
        pulumi.set(self, "backup_item_type", value)

    @property
    @pulumi.getter(name="backupItems")
    def backup_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of backup items associated with this container.
        """
        return pulumi.get(self, "backup_items")

    @backup_items.setter
    def backup_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_items", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Latest backup status of this container.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was refreshed.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Backup policy associated with this container.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


@pulumi.input_type
class MabContainerArgs:
    def __init__(__self__, *,
                 agent_version: Optional[pulumi.Input[str]] = None,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 can_re_register: Optional[pulumi.Input[bool]] = None,
                 container_health_state: Optional[pulumi.Input[str]] = None,
                 container_id: Optional[pulumi.Input[float]] = None,
                 container_type: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['MabContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 mab_container_health_details: Optional[pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None):
        """
        Container with items backed up using MAB backup engine.
        :param pulumi.Input[str] agent_version: Agent version of this container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[bool] can_re_register: Can the container be registered one more time.
        :param pulumi.Input[str] container_health_state: Health state of mab container.
        :param pulumi.Input[float] container_id: ContainerID represents the container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Windows'.
        :param pulumi.Input['MabContainerExtendedInfoArgs'] extended_info: Additional information for this container
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]] mab_container_health_details: Health details on this mab container.
        :param pulumi.Input[float] protected_item_count: Number of items backed up in this container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_health_state is not None:
            pulumi.set(__self__, "container_health_state", container_health_state)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if container_type is not None:
            pulumi.set(__self__, "container_type", 'Windows')
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if mab_container_health_details is not None:
            pulumi.set(__self__, "mab_container_health_details", mab_container_health_details)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Agent version of this container.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Can the container be registered one more time.
        """
        return pulumi.get(self, "can_re_register")

    @can_re_register.setter
    def can_re_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_re_register", value)

    @property
    @pulumi.getter(name="containerHealthState")
    def container_health_state(self) -> Optional[pulumi.Input[str]]:
        """
        Health state of mab container.
        """
        return pulumi.get(self, "container_health_state")

    @container_health_state.setter
    def container_health_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_health_state", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[float]]:
        """
        ContainerID represents the container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['MabContainerExtendedInfoArgs']]:
        """
        Additional information for this container
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['MabContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="mabContainerHealthDetails")
    def mab_container_health_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]]]:
        """
        Health details on this mab container.
        """
        return pulumi.get(self, "mab_container_health_details")

    @mab_container_health_details.setter
    def mab_container_health_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]]]):
        pulumi.set(self, "mab_container_health_details", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)


@pulumi.input_type
class WorkloadInquiryDetailsArgs:
    def __init__(__self__, *,
                 inquiry_validation: Optional[pulumi.Input['InquiryValidationArgs']] = None,
                 item_count: Optional[pulumi.Input[float]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Details of an inquired protectable item.
        :param pulumi.Input['InquiryValidationArgs'] inquiry_validation: Inquiry validation such as permissions and other backup validations.
        :param pulumi.Input[float] item_count: Contains the protectable item Count inside this Container.
        :param pulumi.Input[str] type: Type of the Workload such as SQL, Oracle etc.
        """
        if inquiry_validation is not None:
            pulumi.set(__self__, "inquiry_validation", inquiry_validation)
        if item_count is not None:
            pulumi.set(__self__, "item_count", item_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inquiryValidation")
    def inquiry_validation(self) -> Optional[pulumi.Input['InquiryValidationArgs']]:
        """
        Inquiry validation such as permissions and other backup validations.
        """
        return pulumi.get(self, "inquiry_validation")

    @inquiry_validation.setter
    def inquiry_validation(self, value: Optional[pulumi.Input['InquiryValidationArgs']]):
        pulumi.set(self, "inquiry_validation", value)

    @property
    @pulumi.getter(name="itemCount")
    def item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Contains the protectable item Count inside this Container.
        """
        return pulumi.get(self, "item_count")

    @item_count.setter
    def item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "item_count", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the Workload such as SQL, Oracle etc.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


