# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConsolePropertiesResponse',
    'DashboardLensResponse',
    'DashboardPartsResponse',
    'DashboardPartsResponsePosition',
    'MarkdownPartMetadataResponse',
    'MarkdownPartMetadataResponseContent',
    'MarkdownPartMetadataResponseSettings',
    'MarkdownPartMetadataResponseSettingsSettings',
    'StorageProfileResponse',
    'TerminalSettingsResponse',
    'UserPropertiesResponse',
    'ViolationResponse',
]

@pulumi.output_type
class ConsolePropertiesResponse(dict):
    """
    Cloud shell console properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConsolePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConsolePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConsolePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 provisioning_state: str,
                 uri: str):
        """
        Cloud shell console properties.
        :param str os_type: The operating system type of the cloud shell.
        :param str provisioning_state: Provisioning state of the console.
        :param str uri: Uri of the console.
        """
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the cloud shell.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state of the console.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Uri of the console.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class DashboardLensResponse(dict):
    """
    A dashboard lens.
    """
    def __init__(__self__, *,
                 order: int,
                 parts: Sequence['outputs.DashboardPartsResponse'],
                 metadata: Optional[Mapping[str, Any]] = None):
        """
        A dashboard lens.
        :param int order: The lens order.
        :param Sequence['DashboardPartsResponse'] parts: The dashboard parts.
        :param Mapping[str, Any] metadata: The dashboard len's metadata.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "parts", parts)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The lens order.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def parts(self) -> Sequence['outputs.DashboardPartsResponse']:
        """
        The dashboard parts.
        """
        return pulumi.get(self, "parts")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, Any]]:
        """
        The dashboard len's metadata.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class DashboardPartsResponse(dict):
    """
    A dashboard part.
    """
    def __init__(__self__, *,
                 position: 'outputs.DashboardPartsResponsePosition',
                 metadata: Optional['outputs.MarkdownPartMetadataResponse'] = None):
        """
        A dashboard part.
        :param 'DashboardPartsResponsePosition' position: The dashboard's part position.
        :param 'MarkdownPartMetadataResponse' metadata: The dashboard part's metadata.
        """
        pulumi.set(__self__, "position", position)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def position(self) -> 'outputs.DashboardPartsResponsePosition':
        """
        The dashboard's part position.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.MarkdownPartMetadataResponse']:
        """
        The dashboard part's metadata.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class DashboardPartsResponsePosition(dict):
    """
    The dashboard's part position.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colSpan":
            suggest = "col_span"
        elif key == "rowSpan":
            suggest = "row_span"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardPartsResponsePosition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardPartsResponsePosition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardPartsResponsePosition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 col_span: int,
                 row_span: int,
                 x: int,
                 y: int,
                 metadata: Optional[Mapping[str, Any]] = None):
        """
        The dashboard's part position.
        :param int col_span: The dashboard's part column span.
        :param int row_span: The dashboard's part row span.
        :param int x: The dashboard's part x coordinate.
        :param int y: The dashboard's part y coordinate.
        :param Mapping[str, Any] metadata: The dashboard part's metadata.
        """
        pulumi.set(__self__, "col_span", col_span)
        pulumi.set(__self__, "row_span", row_span)
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="colSpan")
    def col_span(self) -> int:
        """
        The dashboard's part column span.
        """
        return pulumi.get(self, "col_span")

    @property
    @pulumi.getter(name="rowSpan")
    def row_span(self) -> int:
        """
        The dashboard's part row span.
        """
        return pulumi.get(self, "row_span")

    @property
    @pulumi.getter
    def x(self) -> int:
        """
        The dashboard's part x coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> int:
        """
        The dashboard's part y coordinate.
        """
        return pulumi.get(self, "y")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, Any]]:
        """
        The dashboard part's metadata.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class MarkdownPartMetadataResponse(dict):
    """
    Markdown part metadata.
    """
    def __init__(__self__, *,
                 type: str,
                 inputs: Optional[Sequence[Any]] = None,
                 settings: Optional['outputs.MarkdownPartMetadataResponseSettings'] = None):
        """
        Markdown part metadata.
        :param str type: The type of dashboard part.
               Expected value is 'Extension/HubsExtension/PartType/MarkdownPart'.
        :param Sequence[Any] inputs: Input to dashboard part.
        :param 'MarkdownPartMetadataResponseSettings' settings: Markdown part settings.
        """
        pulumi.set(__self__, "type", 'Extension/HubsExtension/PartType/MarkdownPart')
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of dashboard part.
        Expected value is 'Extension/HubsExtension/PartType/MarkdownPart'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def inputs(self) -> Optional[Sequence[Any]]:
        """
        Input to dashboard part.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.MarkdownPartMetadataResponseSettings']:
        """
        Markdown part settings.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class MarkdownPartMetadataResponseContent(dict):
    """
    The content of markdown part.
    """
    def __init__(__self__, *,
                 settings: Optional['outputs.MarkdownPartMetadataResponseSettingsSettings'] = None):
        """
        The content of markdown part.
        :param 'MarkdownPartMetadataResponseSettingsSettings' settings: The setting of the content of markdown part.
        """
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.MarkdownPartMetadataResponseSettingsSettings']:
        """
        The setting of the content of markdown part.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class MarkdownPartMetadataResponseSettings(dict):
    """
    Markdown part settings.
    """
    def __init__(__self__, *,
                 content: Optional['outputs.MarkdownPartMetadataResponseContent'] = None):
        """
        Markdown part settings.
        :param 'MarkdownPartMetadataResponseContent' content: The content of markdown part.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def content(self) -> Optional['outputs.MarkdownPartMetadataResponseContent']:
        """
        The content of markdown part.
        """
        return pulumi.get(self, "content")


@pulumi.output_type
class MarkdownPartMetadataResponseSettingsSettings(dict):
    """
    The setting of the content of markdown part.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "markdownSource":
            suggest = "markdown_source"
        elif key == "markdownUri":
            suggest = "markdown_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MarkdownPartMetadataResponseSettingsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MarkdownPartMetadataResponseSettingsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MarkdownPartMetadataResponseSettingsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: Optional[str] = None,
                 markdown_source: Optional[int] = None,
                 markdown_uri: Optional[str] = None,
                 subtitle: Optional[str] = None,
                 title: Optional[str] = None):
        """
        The setting of the content of markdown part.
        :param str content: The content of the markdown part.
        :param int markdown_source: The source of the content of the markdown part.
        :param str markdown_uri: The uri of markdown content.
        :param str subtitle: The subtitle of the markdown part.
        :param str title: The title of the markdown part.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if markdown_source is not None:
            pulumi.set(__self__, "markdown_source", markdown_source)
        if markdown_uri is not None:
            pulumi.set(__self__, "markdown_uri", markdown_uri)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The content of the markdown part.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="markdownSource")
    def markdown_source(self) -> Optional[int]:
        """
        The source of the content of the markdown part.
        """
        return pulumi.get(self, "markdown_source")

    @property
    @pulumi.getter(name="markdownUri")
    def markdown_uri(self) -> Optional[str]:
        """
        The uri of markdown content.
        """
        return pulumi.get(self, "markdown_uri")

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[str]:
        """
        The subtitle of the markdown part.
        """
        return pulumi.get(self, "subtitle")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        The title of the markdown part.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class StorageProfileResponse(dict):
    """
    The storage profile of the user settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeInGB":
            suggest = "disk_size_in_gb"
        elif key == "fileShareName":
            suggest = "file_share_name"
        elif key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_in_gb: Optional[int] = None,
                 file_share_name: Optional[str] = None,
                 storage_account_resource_id: Optional[str] = None):
        """
        The storage profile of the user settings.
        :param int disk_size_in_gb: Size of file share
        :param str file_share_name: Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
        :param str storage_account_resource_id: Full resource ID of storage account.
        """
        if disk_size_in_gb is not None:
            pulumi.set(__self__, "disk_size_in_gb", disk_size_in_gb)
        if file_share_name is not None:
            pulumi.set(__self__, "file_share_name", file_share_name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="diskSizeInGB")
    def disk_size_in_gb(self) -> Optional[int]:
        """
        Size of file share
        """
        return pulumi.get(self, "disk_size_in_gb")

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> Optional[str]:
        """
        Name of the mounted file share. 63 characters or less, lowercase alphabet, numbers, and -
        """
        return pulumi.get(self, "file_share_name")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[str]:
        """
        Full resource ID of storage account.
        """
        return pulumi.get(self, "storage_account_resource_id")


@pulumi.output_type
class TerminalSettingsResponse(dict):
    """
    Settings for terminal appearance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fontSize":
            suggest = "font_size"
        elif key == "fontStyle":
            suggest = "font_style"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TerminalSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TerminalSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TerminalSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 font_size: Optional[str] = None,
                 font_style: Optional[str] = None):
        """
        Settings for terminal appearance.
        :param str font_size: Size of terminal font.
        :param str font_style: Style of terminal font.
        """
        if font_size is not None:
            pulumi.set(__self__, "font_size", font_size)
        if font_style is not None:
            pulumi.set(__self__, "font_style", font_style)

    @property
    @pulumi.getter(name="fontSize")
    def font_size(self) -> Optional[str]:
        """
        Size of terminal font.
        """
        return pulumi.get(self, "font_size")

    @property
    @pulumi.getter(name="fontStyle")
    def font_style(self) -> Optional[str]:
        """
        Style of terminal font.
        """
        return pulumi.get(self, "font_style")


@pulumi.output_type
class UserPropertiesResponse(dict):
    """
    The cloud shell user settings properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredLocation":
            suggest = "preferred_location"
        elif key == "preferredOsType":
            suggest = "preferred_os_type"
        elif key == "preferredShellType":
            suggest = "preferred_shell_type"
        elif key == "storageProfile":
            suggest = "storage_profile"
        elif key == "terminalSettings":
            suggest = "terminal_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_location: str,
                 preferred_os_type: str,
                 preferred_shell_type: str,
                 storage_profile: 'outputs.StorageProfileResponse',
                 terminal_settings: 'outputs.TerminalSettingsResponse'):
        """
        The cloud shell user settings properties.
        :param str preferred_location: The preferred location of the cloud shell.
        :param str preferred_os_type: The operating system type of the cloud shell. Deprecated, use preferredShellType.
        :param str preferred_shell_type: The shell type of the cloud shell.
        :param 'StorageProfileResponse' storage_profile: The storage profile of the user settings.
        :param 'TerminalSettingsResponse' terminal_settings: Settings for terminal appearance.
        """
        pulumi.set(__self__, "preferred_location", preferred_location)
        pulumi.set(__self__, "preferred_os_type", preferred_os_type)
        pulumi.set(__self__, "preferred_shell_type", preferred_shell_type)
        pulumi.set(__self__, "storage_profile", storage_profile)
        pulumi.set(__self__, "terminal_settings", terminal_settings)

    @property
    @pulumi.getter(name="preferredLocation")
    def preferred_location(self) -> str:
        """
        The preferred location of the cloud shell.
        """
        return pulumi.get(self, "preferred_location")

    @property
    @pulumi.getter(name="preferredOsType")
    def preferred_os_type(self) -> str:
        """
        The operating system type of the cloud shell. Deprecated, use preferredShellType.
        """
        return pulumi.get(self, "preferred_os_type")

    @property
    @pulumi.getter(name="preferredShellType")
    def preferred_shell_type(self) -> str:
        """
        The shell type of the cloud shell.
        """
        return pulumi.get(self, "preferred_shell_type")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> 'outputs.StorageProfileResponse':
        """
        The storage profile of the user settings.
        """
        return pulumi.get(self, "storage_profile")

    @property
    @pulumi.getter(name="terminalSettings")
    def terminal_settings(self) -> 'outputs.TerminalSettingsResponse':
        """
        Settings for terminal appearance.
        """
        return pulumi.get(self, "terminal_settings")


@pulumi.output_type
class ViolationResponse(dict):
    """
    Violation information.
    """
    def __init__(__self__, *,
                 error_message: str,
                 id: str,
                 user_id: str):
        """
        Violation information.
        :param str error_message: Error message.
        :param str id: Id of the item that violates tenant configuration.
        :param str user_id: Id of the user who owns violated item.
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        Error message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Id of the item that violates tenant configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Id of the user who owns violated item.
        """
        return pulumi.get(self, "user_id")


