# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'MasterSitePropertiesResponse',
    'SiteAgentPropertiesResponse',
    'SitePropertiesResponse',
    'SiteSpnPropertiesResponse',
]

@pulumi.output_type
class MasterSitePropertiesResponse(dict):
    """
    Class for site properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMultipleSites":
            suggest = "allow_multiple_sites"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MasterSitePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MasterSitePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MasterSitePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_multiple_sites: Optional[bool] = None,
                 public_network_access: Optional[str] = None,
                 sites: Optional[Sequence[str]] = None):
        """
        Class for site properties.
        :param bool allow_multiple_sites: Value indicating whether multiple sites per site type are allowed.
        :param str public_network_access: State of public network access.
        :param Sequence[str] sites: List of sites that are a part of Master Site.
        """
        if allow_multiple_sites is not None:
            pulumi.set(__self__, "allow_multiple_sites", allow_multiple_sites)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if sites is not None:
            pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter(name="allowMultipleSites")
    def allow_multiple_sites(self) -> Optional[bool]:
        """
        Value indicating whether multiple sites per site type are allowed.
        """
        return pulumi.get(self, "allow_multiple_sites")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        State of public network access.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter
    def sites(self) -> Optional[Sequence[str]]:
        """
        List of sites that are a part of Master Site.
        """
        return pulumi.get(self, "sites")


@pulumi.output_type
class SiteAgentPropertiesResponse(dict):
    """
    Class for site agent properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastHeartBeatUtc":
            suggest = "last_heart_beat_utc"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "keyVaultUri":
            suggest = "key_vault_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteAgentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteAgentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteAgentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 last_heart_beat_utc: str,
                 version: str,
                 key_vault_id: Optional[str] = None,
                 key_vault_uri: Optional[str] = None):
        """
        Class for site agent properties.
        :param str id: ID of the agent.
        :param str last_heart_beat_utc: Last heartbeat time of the agent in UTC.
        :param str version: Version of the agent.
        :param str key_vault_id: Key vault ARM Id.
        :param str key_vault_uri: Key vault URI.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_heart_beat_utc", last_heart_beat_utc)
        pulumi.set(__self__, "version", version)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_vault_uri is not None:
            pulumi.set(__self__, "key_vault_uri", key_vault_uri)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the agent.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastHeartBeatUtc")
    def last_heart_beat_utc(self) -> str:
        """
        Last heartbeat time of the agent in UTC.
        """
        return pulumi.get(self, "last_heart_beat_utc")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the agent.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[str]:
        """
        Key vault ARM Id.
        """
        return pulumi.get(self, "key_vault_id")

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> Optional[str]:
        """
        Key vault URI.
        """
        return pulumi.get(self, "key_vault_uri")


@pulumi.output_type
class SitePropertiesResponse(dict):
    """
    Class for site properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceEndpoint":
            suggest = "service_endpoint"
        elif key == "agentDetails":
            suggest = "agent_details"
        elif key == "applianceName":
            suggest = "appliance_name"
        elif key == "discoverySolutionId":
            suggest = "discovery_solution_id"
        elif key == "servicePrincipalIdentityDetails":
            suggest = "service_principal_identity_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SitePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SitePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SitePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_endpoint: str,
                 agent_details: Optional['outputs.SiteAgentPropertiesResponse'] = None,
                 appliance_name: Optional[str] = None,
                 discovery_solution_id: Optional[str] = None,
                 service_principal_identity_details: Optional['outputs.SiteSpnPropertiesResponse'] = None):
        """
        Class for site properties.
        :param str service_endpoint: Service endpoint.
        :param 'SiteAgentPropertiesResponse' agent_details: On-premises agent details.
        :param str appliance_name: Appliance Name.
        :param str discovery_solution_id: ARM ID of migration hub solution for SDS.
        :param 'SiteSpnPropertiesResponse' service_principal_identity_details: Service principal identity details used by agent for communication to the service.
        """
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        if agent_details is not None:
            pulumi.set(__self__, "agent_details", agent_details)
        if appliance_name is not None:
            pulumi.set(__self__, "appliance_name", appliance_name)
        if discovery_solution_id is not None:
            pulumi.set(__self__, "discovery_solution_id", discovery_solution_id)
        if service_principal_identity_details is not None:
            pulumi.set(__self__, "service_principal_identity_details", service_principal_identity_details)

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        Service endpoint.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="agentDetails")
    def agent_details(self) -> Optional['outputs.SiteAgentPropertiesResponse']:
        """
        On-premises agent details.
        """
        return pulumi.get(self, "agent_details")

    @property
    @pulumi.getter(name="applianceName")
    def appliance_name(self) -> Optional[str]:
        """
        Appliance Name.
        """
        return pulumi.get(self, "appliance_name")

    @property
    @pulumi.getter(name="discoverySolutionId")
    def discovery_solution_id(self) -> Optional[str]:
        """
        ARM ID of migration hub solution for SDS.
        """
        return pulumi.get(self, "discovery_solution_id")

    @property
    @pulumi.getter(name="servicePrincipalIdentityDetails")
    def service_principal_identity_details(self) -> Optional['outputs.SiteSpnPropertiesResponse']:
        """
        Service principal identity details used by agent for communication to the service.
        """
        return pulumi.get(self, "service_principal_identity_details")


@pulumi.output_type
class SiteSpnPropertiesResponse(dict):
    """
    Class for site properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadAuthority":
            suggest = "aad_authority"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "rawCertData":
            suggest = "raw_cert_data"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteSpnPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteSpnPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteSpnPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_authority: Optional[str] = None,
                 application_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 object_id: Optional[str] = None,
                 raw_cert_data: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Class for site properties.
        :param str aad_authority: AAD Authority URL which was used to request the token for the service principal.
        :param str application_id: Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str audience: Intended audience for the service principal.
        :param str object_id: Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param str raw_cert_data: Raw certificate data for building certificate expiry flows.
        :param str tenant_id: Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        if aad_authority is not None:
            pulumi.set(__self__, "aad_authority", aad_authority)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if raw_cert_data is not None:
            pulumi.set(__self__, "raw_cert_data", raw_cert_data)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aadAuthority")
    def aad_authority(self) -> Optional[str]:
        """
        AAD Authority URL which was used to request the token for the service principal.
        """
        return pulumi.get(self, "aad_authority")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Intended audience for the service principal.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="rawCertData")
    def raw_cert_data(self) -> Optional[str]:
        """
        Raw certificate data for building certificate expiry flows.
        """
        return pulumi.get(self, "raw_cert_data")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "tenant_id")


