# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AdmCredentialResponse',
    'ApnsCredentialResponse',
    'BaiduCredentialResponse',
    'GcmCredentialResponse',
    'MpnsCredentialResponse',
    'SharedAccessAuthorizationRulePropertiesResponse',
    'SharedAccessAuthorizationRuleResourceResponse',
    'SkuResponse',
    'WnsCredentialResponse',
]

@pulumi.output_type
class AdmCredentialResponse(dict):
    """
    Description of a NotificationHub AdmCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTokenUrl":
            suggest = "auth_token_url"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdmCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdmCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdmCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_token_url: Optional[str] = None,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None):
        """
        Description of a NotificationHub AdmCredential.
        :param str auth_token_url: The URL of the authorization token.
        :param str client_id: The client identifier.
        :param str client_secret: The credential secret access key.
        """
        if auth_token_url is not None:
            pulumi.set(__self__, "auth_token_url", auth_token_url)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="authTokenUrl")
    def auth_token_url(self) -> Optional[str]:
        """
        The URL of the authorization token.
        """
        return pulumi.get(self, "auth_token_url")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client identifier.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The credential secret access key.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class ApnsCredentialResponse(dict):
    """
    Description of a NotificationHub ApnsCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apnsCertificate":
            suggest = "apns_certificate"
        elif key == "appId":
            suggest = "app_id"
        elif key == "appName":
            suggest = "app_name"
        elif key == "certificateKey":
            suggest = "certificate_key"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApnsCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApnsCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApnsCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apns_certificate: Optional[str] = None,
                 app_id: Optional[str] = None,
                 app_name: Optional[str] = None,
                 certificate_key: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 key_id: Optional[str] = None,
                 thumbprint: Optional[str] = None,
                 token: Optional[str] = None):
        """
        Description of a NotificationHub ApnsCredential.
        :param str apns_certificate: The APNS certificate. Specify if using Certificate Authentication Mode.
        :param str app_id: The issuer (iss) registered claim key. The value is a 10-character TeamId, obtained from your developer account. Specify if using Token Authentication Mode.
        :param str app_name: The name of the application or BundleId. Specify if using Token Authentication Mode.
        :param str certificate_key: The APNS certificate password if it exists.
        :param str endpoint: The APNS endpoint of this credential. If using Certificate Authentication Mode and Sandbox specify 'gateway.sandbox.push.apple.com'. If using Certificate Authentication Mode and Production specify 'gateway.push.apple.com'. If using Token Authentication Mode and Sandbox specify 'https://api.development.push.apple.com:443/3/device'. If using Token Authentication Mode and Production specify 'https://api.push.apple.com:443/3/device'.
        :param str key_id: A 10-character key identifier (kid) key, obtained from your developer account. Specify if using Token Authentication Mode.
        :param str thumbprint: The APNS certificate thumbprint. Specify if using Certificate Authentication Mode.
        :param str token: Provider Authentication Token, obtained through your developer account. Specify if using Token Authentication Mode.
        """
        if apns_certificate is not None:
            pulumi.set(__self__, "apns_certificate", apns_certificate)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if certificate_key is not None:
            pulumi.set(__self__, "certificate_key", certificate_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="apnsCertificate")
    def apns_certificate(self) -> Optional[str]:
        """
        The APNS certificate. Specify if using Certificate Authentication Mode.
        """
        return pulumi.get(self, "apns_certificate")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        The issuer (iss) registered claim key. The value is a 10-character TeamId, obtained from your developer account. Specify if using Token Authentication Mode.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[str]:
        """
        The name of the application or BundleId. Specify if using Token Authentication Mode.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="certificateKey")
    def certificate_key(self) -> Optional[str]:
        """
        The APNS certificate password if it exists.
        """
        return pulumi.get(self, "certificate_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        The APNS endpoint of this credential. If using Certificate Authentication Mode and Sandbox specify 'gateway.sandbox.push.apple.com'. If using Certificate Authentication Mode and Production specify 'gateway.push.apple.com'. If using Token Authentication Mode and Sandbox specify 'https://api.development.push.apple.com:443/3/device'. If using Token Authentication Mode and Production specify 'https://api.push.apple.com:443/3/device'.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        A 10-character key identifier (kid) key, obtained from your developer account. Specify if using Token Authentication Mode.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The APNS certificate thumbprint. Specify if using Certificate Authentication Mode.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        Provider Authentication Token, obtained through your developer account. Specify if using Token Authentication Mode.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class BaiduCredentialResponse(dict):
    """
    Description of a NotificationHub BaiduCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baiduApiKey":
            suggest = "baidu_api_key"
        elif key == "baiduEndPoint":
            suggest = "baidu_end_point"
        elif key == "baiduSecretKey":
            suggest = "baidu_secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BaiduCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BaiduCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BaiduCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 baidu_api_key: Optional[str] = None,
                 baidu_end_point: Optional[str] = None,
                 baidu_secret_key: Optional[str] = None):
        """
        Description of a NotificationHub BaiduCredential.
        :param str baidu_api_key: Baidu Api Key.
        :param str baidu_end_point: Baidu Endpoint.
        :param str baidu_secret_key: Baidu Secret Key
        """
        if baidu_api_key is not None:
            pulumi.set(__self__, "baidu_api_key", baidu_api_key)
        if baidu_end_point is not None:
            pulumi.set(__self__, "baidu_end_point", baidu_end_point)
        if baidu_secret_key is not None:
            pulumi.set(__self__, "baidu_secret_key", baidu_secret_key)

    @property
    @pulumi.getter(name="baiduApiKey")
    def baidu_api_key(self) -> Optional[str]:
        """
        Baidu Api Key.
        """
        return pulumi.get(self, "baidu_api_key")

    @property
    @pulumi.getter(name="baiduEndPoint")
    def baidu_end_point(self) -> Optional[str]:
        """
        Baidu Endpoint.
        """
        return pulumi.get(self, "baidu_end_point")

    @property
    @pulumi.getter(name="baiduSecretKey")
    def baidu_secret_key(self) -> Optional[str]:
        """
        Baidu Secret Key
        """
        return pulumi.get(self, "baidu_secret_key")


@pulumi.output_type
class GcmCredentialResponse(dict):
    """
    Description of a NotificationHub GcmCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcmEndpoint":
            suggest = "gcm_endpoint"
        elif key == "googleApiKey":
            suggest = "google_api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcmCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcmCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcmCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcm_endpoint: Optional[str] = None,
                 google_api_key: Optional[str] = None):
        """
        Description of a NotificationHub GcmCredential.
        :param str gcm_endpoint: The FCM legacy endpoint. Default value is 'https://fcm.googleapis.com/fcm/send'
        :param str google_api_key: The Google API key.
        """
        if gcm_endpoint is not None:
            pulumi.set(__self__, "gcm_endpoint", gcm_endpoint)
        if google_api_key is not None:
            pulumi.set(__self__, "google_api_key", google_api_key)

    @property
    @pulumi.getter(name="gcmEndpoint")
    def gcm_endpoint(self) -> Optional[str]:
        """
        The FCM legacy endpoint. Default value is 'https://fcm.googleapis.com/fcm/send'
        """
        return pulumi.get(self, "gcm_endpoint")

    @property
    @pulumi.getter(name="googleApiKey")
    def google_api_key(self) -> Optional[str]:
        """
        The Google API key.
        """
        return pulumi.get(self, "google_api_key")


@pulumi.output_type
class MpnsCredentialResponse(dict):
    """
    Description of a NotificationHub MpnsCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateKey":
            suggest = "certificate_key"
        elif key == "mpnsCertificate":
            suggest = "mpns_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MpnsCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MpnsCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MpnsCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_key: Optional[str] = None,
                 mpns_certificate: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        Description of a NotificationHub MpnsCredential.
        :param str certificate_key: The certificate key for this credential.
        :param str mpns_certificate: The MPNS certificate.
        :param str thumbprint: The MPNS certificate Thumbprint
        """
        if certificate_key is not None:
            pulumi.set(__self__, "certificate_key", certificate_key)
        if mpns_certificate is not None:
            pulumi.set(__self__, "mpns_certificate", mpns_certificate)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certificateKey")
    def certificate_key(self) -> Optional[str]:
        """
        The certificate key for this credential.
        """
        return pulumi.get(self, "certificate_key")

    @property
    @pulumi.getter(name="mpnsCertificate")
    def mpns_certificate(self) -> Optional[str]:
        """
        The MPNS certificate.
        """
        return pulumi.get(self, "mpns_certificate")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The MPNS certificate Thumbprint
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class SharedAccessAuthorizationRulePropertiesResponse(dict):
    """
    SharedAccessAuthorizationRule properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimType":
            suggest = "claim_type"
        elif key == "claimValue":
            suggest = "claim_value"
        elif key == "createdTime":
            suggest = "created_time"
        elif key == "keyName":
            suggest = "key_name"
        elif key == "modifiedTime":
            suggest = "modified_time"
        elif key == "primaryKey":
            suggest = "primary_key"
        elif key == "secondaryKey":
            suggest = "secondary_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedAccessAuthorizationRulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedAccessAuthorizationRulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedAccessAuthorizationRulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_type: str,
                 claim_value: str,
                 created_time: str,
                 key_name: str,
                 modified_time: str,
                 primary_key: str,
                 revision: int,
                 secondary_key: str,
                 rights: Optional[Sequence[str]] = None):
        """
        SharedAccessAuthorizationRule properties.
        :param str claim_type: A string that describes the claim type
        :param str claim_value: A string that describes the claim value
        :param str created_time: The created time for this rule
        :param str key_name: A string that describes the authorization rule.
        :param str modified_time: The last modified time for this rule
        :param str primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        :param int revision: The revision number for the rule
        :param str secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        :param Sequence[str] rights: The rights associated with the rule.
        """
        pulumi.set(__self__, "claim_type", claim_type)
        pulumi.set(__self__, "claim_value", claim_value)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "primary_key", primary_key)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "secondary_key", secondary_key)
        if rights is not None:
            pulumi.set(__self__, "rights", rights)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> str:
        """
        A string that describes the claim type
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> str:
        """
        A string that describes the claim value
        """
        return pulumi.get(self, "claim_value")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The created time for this rule
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        A string that describes the authorization rule.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The last modified time for this rule
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> str:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The revision number for the rule
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> str:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter
    def rights(self) -> Optional[Sequence[str]]:
        """
        The rights associated with the rule.
        """
        return pulumi.get(self, "rights")


@pulumi.output_type
class SharedAccessAuthorizationRuleResourceResponse(dict):
    """
    Description of a Namespace AuthorizationRules.
    """
    def __init__(__self__, *,
                 claim_type: str,
                 claim_value: str,
                 created_time: str,
                 id: str,
                 key_name: str,
                 modified_time: str,
                 name: str,
                 primary_key: str,
                 revision: int,
                 secondary_key: str,
                 type: str,
                 location: Optional[str] = None,
                 rights: Optional[Sequence[str]] = None,
                 sku: Optional['outputs.SkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Description of a Namespace AuthorizationRules.
        :param str claim_type: A string that describes the claim type
        :param str claim_value: A string that describes the claim value
        :param str created_time: The created time for this rule
        :param str id: Resource Id
        :param str key_name: A string that describes the authorization rule.
        :param str modified_time: The last modified time for this rule
        :param str name: Resource name
        :param str primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        :param int revision: The revision number for the rule
        :param str secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS token.
        :param str type: Resource type
        :param str location: Resource location
        :param Sequence[str] rights: The rights associated with the rule.
        :param 'SkuResponse' sku: The sku of the created namespace
        :param Mapping[str, str] tags: Resource tags
        """
        pulumi.set(__self__, "claim_type", claim_type)
        pulumi.set(__self__, "claim_value", claim_value)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_key", primary_key)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "secondary_key", secondary_key)
        pulumi.set(__self__, "type", type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if rights is not None:
            pulumi.set(__self__, "rights", rights)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> str:
        """
        A string that describes the claim type
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> str:
        """
        A string that describes the claim value
        """
        return pulumi.get(self, "claim_value")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The created time for this rule
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        A string that describes the authorization rule.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The last modified time for this rule
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> str:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The revision number for the rule
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> str:
        """
        A base64-encoded 256-bit primary key for signing and validating the SAS token.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def rights(self) -> Optional[Sequence[str]]:
        """
        The rights associated with the rule.
        """
        return pulumi.get(self, "rights")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuResponse']:
        """
        The sku of the created namespace
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SkuResponse(dict):
    """
    The Sku description for a namespace
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 size: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        The Sku description for a namespace
        :param str name: Name of the notification hub sku
        :param int capacity: The capacity of the resource
        :param str family: The Sku Family
        :param str size: The Sku size
        :param str tier: The tier of particular sku
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the notification hub sku
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The capacity of the resource
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        The Sku Family
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        The Sku size
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The tier of particular sku
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class WnsCredentialResponse(dict):
    """
    Description of a NotificationHub WnsCredential.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageSid":
            suggest = "package_sid"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "windowsLiveEndpoint":
            suggest = "windows_live_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WnsCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WnsCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WnsCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 package_sid: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 windows_live_endpoint: Optional[str] = None):
        """
        Description of a NotificationHub WnsCredential.
        :param str package_sid: The package ID for this credential.
        :param str secret_key: The secret key.
        :param str windows_live_endpoint: The Windows Live endpoint.
        """
        if package_sid is not None:
            pulumi.set(__self__, "package_sid", package_sid)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if windows_live_endpoint is not None:
            pulumi.set(__self__, "windows_live_endpoint", windows_live_endpoint)

    @property
    @pulumi.getter(name="packageSid")
    def package_sid(self) -> Optional[str]:
        """
        The package ID for this credential.
        """
        return pulumi.get(self, "package_sid")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        The secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="windowsLiveEndpoint")
    def windows_live_endpoint(self) -> Optional[str]:
        """
        The Windows Live endpoint.
        """
        return pulumi.get(self, "windows_live_endpoint")


