# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'ARecordResponse',
    'AaaaRecordResponse',
    'CnameRecordResponse',
    'MxRecordResponse',
    'NsRecordResponse',
    'PtrRecordResponse',
    'SoaRecordResponse',
    'SrvRecordResponse',
    'TxtRecordResponse',
    'ZonePropertiesResponse',
]

@pulumi.output_type
class ARecordResponse(dict):
    """
    An A record.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ARecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ARecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ARecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_address: Optional[str] = None):
        """
        An A record.
        :param str ipv4_address: Gets or sets the IPv4 address of this A record in string notation.
        """
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[str]:
        """
        Gets or sets the IPv4 address of this A record in string notation.
        """
        return pulumi.get(self, "ipv4_address")


@pulumi.output_type
class AaaaRecordResponse(dict):
    """
    An AAAA record.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv6Address":
            suggest = "ipv6_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AaaaRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AaaaRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AaaaRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv6_address: Optional[str] = None):
        """
        An AAAA record.
        :param str ipv6_address: Gets or sets the IPv6 address of this AAAA record in string notation.
        """
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[str]:
        """
        Gets or sets the IPv6 address of this AAAA record in string notation.
        """
        return pulumi.get(self, "ipv6_address")


@pulumi.output_type
class CnameRecordResponse(dict):
    """
    A CNAME record.
    """
    def __init__(__self__, *,
                 cname: Optional[str] = None):
        """
        A CNAME record.
        :param str cname: Gets or sets the canonical name for this record without a terminating dot.
        """
        if cname is not None:
            pulumi.set(__self__, "cname", cname)

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        Gets or sets the canonical name for this record without a terminating dot.
        """
        return pulumi.get(self, "cname")


@pulumi.output_type
class MxRecordResponse(dict):
    """
    An MX record.
    """
    def __init__(__self__, *,
                 exchange: Optional[str] = None,
                 preference: Optional[int] = None):
        """
        An MX record.
        :param str exchange: Gets or sets the domain name of the mail host, without a terminating dot.
        :param int preference: Gets or sets the preference metric for this record.
        """
        if exchange is not None:
            pulumi.set(__self__, "exchange", exchange)
        if preference is not None:
            pulumi.set(__self__, "preference", preference)

    @property
    @pulumi.getter
    def exchange(self) -> Optional[str]:
        """
        Gets or sets the domain name of the mail host, without a terminating dot.
        """
        return pulumi.get(self, "exchange")

    @property
    @pulumi.getter
    def preference(self) -> Optional[int]:
        """
        Gets or sets the preference metric for this record.
        """
        return pulumi.get(self, "preference")


@pulumi.output_type
class NsRecordResponse(dict):
    """
    An NS record.
    """
    def __init__(__self__, *,
                 nsdname: Optional[str] = None):
        """
        An NS record.
        :param str nsdname: Gets or sets the name server name for this record, without a terminating dot.
        """
        if nsdname is not None:
            pulumi.set(__self__, "nsdname", nsdname)

    @property
    @pulumi.getter
    def nsdname(self) -> Optional[str]:
        """
        Gets or sets the name server name for this record, without a terminating dot.
        """
        return pulumi.get(self, "nsdname")


@pulumi.output_type
class PtrRecordResponse(dict):
    """
    A PTR record.
    """
    def __init__(__self__, *,
                 ptrdname: Optional[str] = None):
        """
        A PTR record.
        :param str ptrdname: Gets or sets the PTR target domain name for this record without a terminating dot.
        """
        if ptrdname is not None:
            pulumi.set(__self__, "ptrdname", ptrdname)

    @property
    @pulumi.getter
    def ptrdname(self) -> Optional[str]:
        """
        Gets or sets the PTR target domain name for this record without a terminating dot.
        """
        return pulumi.get(self, "ptrdname")


@pulumi.output_type
class SoaRecordResponse(dict):
    """
    An SOA record.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"
        elif key == "minimumTTL":
            suggest = "minimum_ttl"
        elif key == "refreshTime":
            suggest = "refresh_time"
        elif key == "retryTime":
            suggest = "retry_time"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoaRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoaRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoaRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: Optional[str] = None,
                 expire_time: Optional[float] = None,
                 host: Optional[str] = None,
                 minimum_ttl: Optional[float] = None,
                 refresh_time: Optional[float] = None,
                 retry_time: Optional[float] = None,
                 serial_number: Optional[float] = None):
        """
        An SOA record.
        :param str email: Gets or sets the email for this record.
        :param float expire_time: Gets or sets the expire time for this record.
        :param str host: Gets or sets the domain name of the authoritative name server, without a terminating dot.
        :param float minimum_ttl: Gets or sets the minimum TTL value for this record.
        :param float refresh_time: Gets or sets the refresh value for this record.
        :param float retry_time: Gets or sets the retry time for this record.
        :param float serial_number: Gets or sets the serial number for this record.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)
        if refresh_time is not None:
            pulumi.set(__self__, "refresh_time", refresh_time)
        if retry_time is not None:
            pulumi.set(__self__, "retry_time", retry_time)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Gets or sets the email for this record.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[float]:
        """
        Gets or sets the expire time for this record.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        Gets or sets the domain name of the authoritative name server, without a terminating dot.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="minimumTTL")
    def minimum_ttl(self) -> Optional[float]:
        """
        Gets or sets the minimum TTL value for this record.
        """
        return pulumi.get(self, "minimum_ttl")

    @property
    @pulumi.getter(name="refreshTime")
    def refresh_time(self) -> Optional[float]:
        """
        Gets or sets the refresh value for this record.
        """
        return pulumi.get(self, "refresh_time")

    @property
    @pulumi.getter(name="retryTime")
    def retry_time(self) -> Optional[float]:
        """
        Gets or sets the retry time for this record.
        """
        return pulumi.get(self, "retry_time")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[float]:
        """
        Gets or sets the serial number for this record.
        """
        return pulumi.get(self, "serial_number")


@pulumi.output_type
class SrvRecordResponse(dict):
    """
    An SRV record.
    """
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 priority: Optional[int] = None,
                 target: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        An SRV record.
        :param int port: Gets or sets the port of the service for this record.
        :param int priority: Gets or sets the priority metric for this record.
        :param str target: Gets or sets the domain name of the target for this record, without a terminating dot.
        :param int weight: Gets or sets the weight metric for this record.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Gets or sets the port of the service for this record.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Gets or sets the priority metric for this record.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Gets or sets the domain name of the target for this record, without a terminating dot.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Gets or sets the weight metric for this record.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TxtRecordResponse(dict):
    """
    A TXT record.
    """
    def __init__(__self__, *,
                 value: Optional[Sequence[str]] = None):
        """
        A TXT record.
        :param Sequence[str] value: Gets or sets the text value of this record.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the text value of this record.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ZonePropertiesResponse(dict):
    """
    Represents the properties of the zone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNumberOfRecordsPerRecordSet":
            suggest = "max_number_of_records_per_record_set"
        elif key == "maxNumberOfRecordSets":
            suggest = "max_number_of_record_sets"
        elif key == "numberOfRecordSets":
            suggest = "number_of_record_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZonePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZonePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZonePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_number_of_records_per_record_set: float,
                 max_number_of_record_sets: Optional[float] = None,
                 number_of_record_sets: Optional[float] = None):
        """
        Represents the properties of the zone.
        :param float max_number_of_records_per_record_set: The maximum number of records per record set that can be created in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
        :param float max_number_of_record_sets: Gets or sets the maximum number of record sets that can be created in this zone.
        :param float number_of_record_sets: Gets or sets the current number of record sets in this zone.
        """
        pulumi.set(__self__, "max_number_of_records_per_record_set", max_number_of_records_per_record_set)
        if max_number_of_record_sets is not None:
            pulumi.set(__self__, "max_number_of_record_sets", max_number_of_record_sets)
        if number_of_record_sets is not None:
            pulumi.set(__self__, "number_of_record_sets", number_of_record_sets)

    @property
    @pulumi.getter(name="maxNumberOfRecordsPerRecordSet")
    def max_number_of_records_per_record_set(self) -> float:
        """
        The maximum number of records per record set that can be created in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
        """
        return pulumi.get(self, "max_number_of_records_per_record_set")

    @property
    @pulumi.getter(name="maxNumberOfRecordSets")
    def max_number_of_record_sets(self) -> Optional[float]:
        """
        Gets or sets the maximum number of record sets that can be created in this zone.
        """
        return pulumi.get(self, "max_number_of_record_sets")

    @property
    @pulumi.getter(name="numberOfRecordSets")
    def number_of_record_sets(self) -> Optional[float]:
        """
        Gets or sets the current number of record sets in this zone.
        """
        return pulumi.get(self, "number_of_record_sets")


