# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AssessmentPropertiesArgs',
    'AvailabilitySetResourceSettingsArgs',
    'CollectorAgentPropertiesArgs',
    'CollectorBodyAgentSpnPropertiesArgs',
    'CollectorPropertiesArgs',
    'DiskEncryptionSetResourceSettingsArgs',
    'GroupPropertiesArgs',
    'IdentityArgs',
    'ImportCollectorPropertiesArgs',
    'KeyVaultResourceSettingsArgs',
    'LBBackendAddressPoolResourceSettingsArgs',
    'LBFrontendIPConfigurationResourceSettingsArgs',
    'LoadBalancerBackendAddressPoolReferenceArgs',
    'LoadBalancerNatRuleReferenceArgs',
    'LoadBalancerResourceSettingsArgs',
    'MigrateProjectPropertiesArgs',
    'MigrateProjectTagsArgs',
    'MoveCollectionPropertiesArgs',
    'MoveResourceDependencyOverrideArgs',
    'MoveResourcePropertiesArgs',
    'NetworkInterfaceResourceSettingsArgs',
    'NetworkSecurityGroupResourceSettingsArgs',
    'NicIpConfigurationResourceSettingsArgs',
    'NsgReferenceArgs',
    'NsgSecurityRuleArgs',
    'PrivateEndpointConnectionPropertiesArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ProjectPropertiesArgs',
    'PublicIPAddressResourceSettingsArgs',
    'PublicIpReferenceArgs',
    'ResourceGroupResourceSettingsArgs',
    'SolutionDetailsArgs',
    'SolutionPropertiesArgs',
    'SqlDatabaseResourceSettingsArgs',
    'SqlElasticPoolResourceSettingsArgs',
    'SqlServerResourceSettingsArgs',
    'SubnetReferenceArgs',
    'SubnetResourceSettingsArgs',
    'VirtualMachineResourceSettingsArgs',
    'VirtualNetworkResourceSettingsArgs',
    'VmUptimeArgs',
]

@pulumi.input_type
class AssessmentPropertiesArgs:
    def __init__(__self__, *,
                 azure_disk_type: pulumi.Input[Union[str, 'AzureDiskType']],
                 azure_hybrid_use_benefit: pulumi.Input[Union[str, 'AzureHybridUseBenefit']],
                 azure_location: pulumi.Input[Union[str, 'AzureLocation']],
                 azure_offer_code: pulumi.Input[Union[str, 'AzureOfferCode']],
                 azure_pricing_tier: pulumi.Input[Union[str, 'AzurePricingTier']],
                 azure_storage_redundancy: pulumi.Input[Union[str, 'AzureStorageRedundancy']],
                 azure_vm_families: pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureVmFamily']]]],
                 currency: pulumi.Input[Union[str, 'Currency']],
                 discount_percentage: pulumi.Input[float],
                 percentile: pulumi.Input[Union[str, 'Percentile']],
                 reserved_instance: pulumi.Input[Union[str, 'ReservedInstance']],
                 scaling_factor: pulumi.Input[float],
                 sizing_criterion: pulumi.Input[Union[str, 'AssessmentSizingCriterion']],
                 stage: pulumi.Input[Union[str, 'AssessmentStage']],
                 time_range: pulumi.Input[Union[str, 'TimeRange']],
                 vm_uptime: pulumi.Input['VmUptimeArgs']):
        """
        Properties of an assessment.
        :param pulumi.Input[Union[str, 'AzureDiskType']] azure_disk_type: Storage type selected for this disk.
        :param pulumi.Input[Union[str, 'AzureHybridUseBenefit']] azure_hybrid_use_benefit: AHUB discount on windows virtual machines.
        :param pulumi.Input[Union[str, 'AzureLocation']] azure_location: Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
        :param pulumi.Input[Union[str, 'AzureOfferCode']] azure_offer_code: Offer code according to which cost estimation is done.
        :param pulumi.Input[Union[str, 'AzurePricingTier']] azure_pricing_tier: Pricing tier for Size evaluation.
        :param pulumi.Input[Union[str, 'AzureStorageRedundancy']] azure_storage_redundancy: Storage Redundancy type offered by Azure.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureVmFamily']]]] azure_vm_families: List of azure VM families.
        :param pulumi.Input[Union[str, 'Currency']] currency: Currency to report prices in.
        :param pulumi.Input[float] discount_percentage: Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
        :param pulumi.Input[Union[str, 'Percentile']] percentile: Percentile of performance data used to recommend Azure size.
        :param pulumi.Input[Union[str, 'ReservedInstance']] reserved_instance: Azure reserved instance.
        :param pulumi.Input[float] scaling_factor: Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
        :param pulumi.Input[Union[str, 'AssessmentSizingCriterion']] sizing_criterion: Assessment sizing criterion.
        :param pulumi.Input[Union[str, 'AssessmentStage']] stage: User configurable setting that describes the status of the assessment.
        :param pulumi.Input[Union[str, 'TimeRange']] time_range: Time range of performance data used to recommend a size.
        :param pulumi.Input['VmUptimeArgs'] vm_uptime: Specify the duration for which the VMs are up in the on-premises environment.
        """
        pulumi.set(__self__, "azure_disk_type", azure_disk_type)
        pulumi.set(__self__, "azure_hybrid_use_benefit", azure_hybrid_use_benefit)
        pulumi.set(__self__, "azure_location", azure_location)
        pulumi.set(__self__, "azure_offer_code", azure_offer_code)
        pulumi.set(__self__, "azure_pricing_tier", azure_pricing_tier)
        pulumi.set(__self__, "azure_storage_redundancy", azure_storage_redundancy)
        pulumi.set(__self__, "azure_vm_families", azure_vm_families)
        pulumi.set(__self__, "currency", currency)
        pulumi.set(__self__, "discount_percentage", discount_percentage)
        pulumi.set(__self__, "percentile", percentile)
        pulumi.set(__self__, "reserved_instance", reserved_instance)
        pulumi.set(__self__, "scaling_factor", scaling_factor)
        pulumi.set(__self__, "sizing_criterion", sizing_criterion)
        pulumi.set(__self__, "stage", stage)
        pulumi.set(__self__, "time_range", time_range)
        pulumi.set(__self__, "vm_uptime", vm_uptime)

    @property
    @pulumi.getter(name="azureDiskType")
    def azure_disk_type(self) -> pulumi.Input[Union[str, 'AzureDiskType']]:
        """
        Storage type selected for this disk.
        """
        return pulumi.get(self, "azure_disk_type")

    @azure_disk_type.setter
    def azure_disk_type(self, value: pulumi.Input[Union[str, 'AzureDiskType']]):
        pulumi.set(self, "azure_disk_type", value)

    @property
    @pulumi.getter(name="azureHybridUseBenefit")
    def azure_hybrid_use_benefit(self) -> pulumi.Input[Union[str, 'AzureHybridUseBenefit']]:
        """
        AHUB discount on windows virtual machines.
        """
        return pulumi.get(self, "azure_hybrid_use_benefit")

    @azure_hybrid_use_benefit.setter
    def azure_hybrid_use_benefit(self, value: pulumi.Input[Union[str, 'AzureHybridUseBenefit']]):
        pulumi.set(self, "azure_hybrid_use_benefit", value)

    @property
    @pulumi.getter(name="azureLocation")
    def azure_location(self) -> pulumi.Input[Union[str, 'AzureLocation']]:
        """
        Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
        """
        return pulumi.get(self, "azure_location")

    @azure_location.setter
    def azure_location(self, value: pulumi.Input[Union[str, 'AzureLocation']]):
        pulumi.set(self, "azure_location", value)

    @property
    @pulumi.getter(name="azureOfferCode")
    def azure_offer_code(self) -> pulumi.Input[Union[str, 'AzureOfferCode']]:
        """
        Offer code according to which cost estimation is done.
        """
        return pulumi.get(self, "azure_offer_code")

    @azure_offer_code.setter
    def azure_offer_code(self, value: pulumi.Input[Union[str, 'AzureOfferCode']]):
        pulumi.set(self, "azure_offer_code", value)

    @property
    @pulumi.getter(name="azurePricingTier")
    def azure_pricing_tier(self) -> pulumi.Input[Union[str, 'AzurePricingTier']]:
        """
        Pricing tier for Size evaluation.
        """
        return pulumi.get(self, "azure_pricing_tier")

    @azure_pricing_tier.setter
    def azure_pricing_tier(self, value: pulumi.Input[Union[str, 'AzurePricingTier']]):
        pulumi.set(self, "azure_pricing_tier", value)

    @property
    @pulumi.getter(name="azureStorageRedundancy")
    def azure_storage_redundancy(self) -> pulumi.Input[Union[str, 'AzureStorageRedundancy']]:
        """
        Storage Redundancy type offered by Azure.
        """
        return pulumi.get(self, "azure_storage_redundancy")

    @azure_storage_redundancy.setter
    def azure_storage_redundancy(self, value: pulumi.Input[Union[str, 'AzureStorageRedundancy']]):
        pulumi.set(self, "azure_storage_redundancy", value)

    @property
    @pulumi.getter(name="azureVmFamilies")
    def azure_vm_families(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureVmFamily']]]]:
        """
        List of azure VM families.
        """
        return pulumi.get(self, "azure_vm_families")

    @azure_vm_families.setter
    def azure_vm_families(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'AzureVmFamily']]]]):
        pulumi.set(self, "azure_vm_families", value)

    @property
    @pulumi.getter
    def currency(self) -> pulumi.Input[Union[str, 'Currency']]:
        """
        Currency to report prices in.
        """
        return pulumi.get(self, "currency")

    @currency.setter
    def currency(self, value: pulumi.Input[Union[str, 'Currency']]):
        pulumi.set(self, "currency", value)

    @property
    @pulumi.getter(name="discountPercentage")
    def discount_percentage(self) -> pulumi.Input[float]:
        """
        Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
        """
        return pulumi.get(self, "discount_percentage")

    @discount_percentage.setter
    def discount_percentage(self, value: pulumi.Input[float]):
        pulumi.set(self, "discount_percentage", value)

    @property
    @pulumi.getter
    def percentile(self) -> pulumi.Input[Union[str, 'Percentile']]:
        """
        Percentile of performance data used to recommend Azure size.
        """
        return pulumi.get(self, "percentile")

    @percentile.setter
    def percentile(self, value: pulumi.Input[Union[str, 'Percentile']]):
        pulumi.set(self, "percentile", value)

    @property
    @pulumi.getter(name="reservedInstance")
    def reserved_instance(self) -> pulumi.Input[Union[str, 'ReservedInstance']]:
        """
        Azure reserved instance.
        """
        return pulumi.get(self, "reserved_instance")

    @reserved_instance.setter
    def reserved_instance(self, value: pulumi.Input[Union[str, 'ReservedInstance']]):
        pulumi.set(self, "reserved_instance", value)

    @property
    @pulumi.getter(name="scalingFactor")
    def scaling_factor(self) -> pulumi.Input[float]:
        """
        Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
        """
        return pulumi.get(self, "scaling_factor")

    @scaling_factor.setter
    def scaling_factor(self, value: pulumi.Input[float]):
        pulumi.set(self, "scaling_factor", value)

    @property
    @pulumi.getter(name="sizingCriterion")
    def sizing_criterion(self) -> pulumi.Input[Union[str, 'AssessmentSizingCriterion']]:
        """
        Assessment sizing criterion.
        """
        return pulumi.get(self, "sizing_criterion")

    @sizing_criterion.setter
    def sizing_criterion(self, value: pulumi.Input[Union[str, 'AssessmentSizingCriterion']]):
        pulumi.set(self, "sizing_criterion", value)

    @property
    @pulumi.getter
    def stage(self) -> pulumi.Input[Union[str, 'AssessmentStage']]:
        """
        User configurable setting that describes the status of the assessment.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: pulumi.Input[Union[str, 'AssessmentStage']]):
        pulumi.set(self, "stage", value)

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Input[Union[str, 'TimeRange']]:
        """
        Time range of performance data used to recommend a size.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: pulumi.Input[Union[str, 'TimeRange']]):
        pulumi.set(self, "time_range", value)

    @property
    @pulumi.getter(name="vmUptime")
    def vm_uptime(self) -> pulumi.Input['VmUptimeArgs']:
        """
        Specify the duration for which the VMs are up in the on-premises environment.
        """
        return pulumi.get(self, "vm_uptime")

    @vm_uptime.setter
    def vm_uptime(self, value: pulumi.Input['VmUptimeArgs']):
        pulumi.set(self, "vm_uptime", value)


@pulumi.input_type
class AvailabilitySetResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 fault_domain: Optional[pulumi.Input[int]] = None,
                 update_domain: Optional[pulumi.Input[int]] = None):
        """
        Gets or sets the availability set resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/availabilitySets'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[int] fault_domain: Gets or sets the target fault domain.
        :param pulumi.Input[int] update_domain: Gets or sets the target update domain.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/availabilitySets')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if update_domain is not None:
            pulumi.set(__self__, "update_domain", update_domain)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/availabilitySets'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the target fault domain.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="updateDomain")
    def update_domain(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the target update domain.
        """
        return pulumi.get(self, "update_domain")

    @update_domain.setter
    def update_domain(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "update_domain", value)


@pulumi.input_type
class CollectorAgentPropertiesArgs:
    def __init__(__self__, *,
                 spn_details: Optional[pulumi.Input['CollectorBodyAgentSpnPropertiesArgs']] = None):
        if spn_details is not None:
            pulumi.set(__self__, "spn_details", spn_details)

    @property
    @pulumi.getter(name="spnDetails")
    def spn_details(self) -> Optional[pulumi.Input['CollectorBodyAgentSpnPropertiesArgs']]:
        return pulumi.get(self, "spn_details")

    @spn_details.setter
    def spn_details(self, value: Optional[pulumi.Input['CollectorBodyAgentSpnPropertiesArgs']]):
        pulumi.set(self, "spn_details", value)


@pulumi.input_type
class CollectorBodyAgentSpnPropertiesArgs:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authority: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] application_id: Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param pulumi.Input[str] audience: Intended audience for the service principal.
        :param pulumi.Input[str] authority: AAD Authority URL which was used to request the token for the service principal.
        :param pulumi.Input[str] object_id: Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        :param pulumi.Input[str] tenant_id: Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if authority is not None:
            pulumi.set(__self__, "authority", authority)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Intended audience for the service principal.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def authority(self) -> Optional[pulumi.Input[str]]:
        """
        AAD Authority URL which was used to request the token for the service principal.
        """
        return pulumi.get(self, "authority")

    @authority.setter
    def authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class CollectorPropertiesArgs:
    def __init__(__self__, *,
                 agent_properties: Optional[pulumi.Input['CollectorAgentPropertiesArgs']] = None,
                 discovery_site_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] discovery_site_id: The ARM id of the discovery service site.
        """
        if agent_properties is not None:
            pulumi.set(__self__, "agent_properties", agent_properties)
        if discovery_site_id is not None:
            pulumi.set(__self__, "discovery_site_id", discovery_site_id)

    @property
    @pulumi.getter(name="agentProperties")
    def agent_properties(self) -> Optional[pulumi.Input['CollectorAgentPropertiesArgs']]:
        return pulumi.get(self, "agent_properties")

    @agent_properties.setter
    def agent_properties(self, value: Optional[pulumi.Input['CollectorAgentPropertiesArgs']]):
        pulumi.set(self, "agent_properties", value)

    @property
    @pulumi.getter(name="discoverySiteId")
    def discovery_site_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM id of the discovery service site.
        """
        return pulumi.get(self, "discovery_site_id")

    @discovery_site_id.setter
    def discovery_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_site_id", value)


@pulumi.input_type
class DiskEncryptionSetResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the disk encryption set resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/diskEncryptionSets'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/diskEncryptionSets')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/diskEncryptionSets'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class GroupPropertiesArgs:
    def __init__(__self__, *,
                 group_type: Optional[pulumi.Input[str]] = None):
        """
        Properties of group resource.
        :param pulumi.Input[str] group_type: The type of group.
        """
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of group.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_type", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]] = None):
        """
        Defines the MSI properties of the Move Collection.
        :param pulumi.Input[str] principal_id: Gets or sets the principal id.
        :param pulumi.Input[str] tenant_id: Gets or sets the tenant id.
        :param pulumi.Input[Union[str, 'ResourceIdentityType']] type: The type of identity used for the resource mover service.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the principal id.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]:
        """
        The type of identity used for the resource mover service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ResourceIdentityType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ImportCollectorPropertiesArgs:
    def __init__(__self__, *,
                 discovery_site_id: Optional[pulumi.Input[str]] = None):
        if discovery_site_id is not None:
            pulumi.set(__self__, "discovery_site_id", discovery_site_id)

    @property
    @pulumi.getter(name="discoverySiteId")
    def discovery_site_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "discovery_site_id")

    @discovery_site_id.setter
    def discovery_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_site_id", value)


@pulumi.input_type
class KeyVaultResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the key vault resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.KeyVault/vaults'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.KeyVault/vaults')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.KeyVault/vaults'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class LBBackendAddressPoolResourceSettingsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines load balancer backend address pool properties.
        :param pulumi.Input[str] name: Gets or sets the backend address pool name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the backend address pool name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LBFrontendIPConfigurationResourceSettingsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input['SubnetReferenceArgs']] = None,
                 zones: Optional[pulumi.Input[str]] = None):
        """
        Defines load balancer frontend IP configuration properties.
        :param pulumi.Input[str] name: Gets or sets the frontend IP configuration name.
        :param pulumi.Input[str] private_ip_address: Gets or sets the IP address of the Load Balancer.This is only specified if a specific
               private IP address shall be allocated from the subnet specified in subnetRef.
        :param pulumi.Input[str] private_ip_allocation_method: Gets or sets PrivateIP allocation method (Static/Dynamic).
        :param pulumi.Input['SubnetReferenceArgs'] subnet: Defines reference to subnet.
        :param pulumi.Input[str] zones: Gets or sets the csv list of zones.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the frontend IP configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the IP address of the Load Balancer.This is only specified if a specific
        private IP address shall be allocated from the subnet specified in subnetRef.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets PrivateIP allocation method (Static/Dynamic).
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetReferenceArgs']]:
        """
        Defines reference to subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetReferenceArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the csv list of zones.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class LoadBalancerBackendAddressPoolReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines reference to load balancer backend address pools.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param pulumi.Input[str] name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoadBalancerNatRuleReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines reference to load balancer NAT rules.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param pulumi.Input[str] name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoadBalancerResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[str]] = None):
        """
        Defines the load balancer resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/loadBalancers'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]] backend_address_pools: Gets or sets the backend address pools of the load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]] frontend_ip_configurations: Gets or sets the frontend IP configurations of the load balancer.
        :param pulumi.Input[str] sku: Gets or sets load balancer sku (Basic/Standard).
        :param pulumi.Input[str] zones: Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
                precedence only if frontend IP configurations settings are not present.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/loadBalancers')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if backend_address_pools is not None:
            pulumi.set(__self__, "backend_address_pools", backend_address_pools)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/loadBalancers'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]]]:
        """
        Gets or sets the backend address pools of the load balancer.
        """
        return pulumi.get(self, "backend_address_pools")

    @backend_address_pools.setter
    def backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LBBackendAddressPoolResourceSettingsArgs']]]]):
        pulumi.set(self, "backend_address_pools", value)

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]]]:
        """
        Gets or sets the frontend IP configurations of the load balancer.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LBFrontendIPConfigurationResourceSettingsArgs']]]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets load balancer sku (Basic/Standard).
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
         precedence only if frontend IP configurations settings are not present.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class MigrateProjectPropertiesArgs:
    def __init__(__self__, *,
                 provisioning_state: Optional[pulumi.Input[Union[str, 'ProvisioningState']]] = None,
                 registered_tools: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Class for migrate project properties.
        :param pulumi.Input[Union[str, 'ProvisioningState']] provisioning_state: Provisioning state of the migrate project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] registered_tools: Gets or sets the list of tools registered with the migrate project.
        """
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if registered_tools is not None:
            pulumi.set(__self__, "registered_tools", registered_tools)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[Union[str, 'ProvisioningState']]]:
        """
        Provisioning state of the migrate project.
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[Union[str, 'ProvisioningState']]]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter(name="registeredTools")
    def registered_tools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of tools registered with the migrate project.
        """
        return pulumi.get(self, "registered_tools")

    @registered_tools.setter
    def registered_tools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "registered_tools", value)


@pulumi.input_type
class MigrateProjectTagsArgs:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the tags.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_properties", value)


@pulumi.input_type
class MoveCollectionPropertiesArgs:
    def __init__(__self__, *,
                 source_region: pulumi.Input[str],
                 target_region: pulumi.Input[str]):
        """
        Defines the move collection properties.
        :param pulumi.Input[str] source_region: Gets or sets the source region.
        :param pulumi.Input[str] target_region: Gets or sets the target region.
        """
        pulumi.set(__self__, "source_region", source_region)
        pulumi.set(__self__, "target_region", target_region)

    @property
    @pulumi.getter(name="sourceRegion")
    def source_region(self) -> pulumi.Input[str]:
        """
        Gets or sets the source region.
        """
        return pulumi.get(self, "source_region")

    @source_region.setter
    def source_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_region", value)

    @property
    @pulumi.getter(name="targetRegion")
    def target_region(self) -> pulumi.Input[str]:
        """
        Gets or sets the target region.
        """
        return pulumi.get(self, "target_region")

    @target_region.setter
    def target_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_region", value)


@pulumi.input_type
class MoveResourceDependencyOverrideArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None):
        """
        Defines the dependency override of the move resource.
        :param pulumi.Input[str] id: Gets or sets the ARM ID of the dependent resource.
        :param pulumi.Input[str] target_id: Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
               the dependent resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the ARM ID of the dependent resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
        the dependent resource.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class MoveResourcePropertiesArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[str],
                 depends_on_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]]] = None,
                 existing_target_id: Optional[pulumi.Input[str]] = None,
                 resource_settings: Optional[pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']]] = None):
        """
        Defines the move resource properties.
        :param pulumi.Input[str] source_id: Gets or sets the Source ARM Id of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]] depends_on_overrides: Gets or sets the move resource dependencies overrides.
        :param pulumi.Input[str] existing_target_id: Gets or sets the existing target ARM Id of the resource.
        :param pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']] resource_settings: Gets or sets the resource settings.
        """
        pulumi.set(__self__, "source_id", source_id)
        if depends_on_overrides is not None:
            pulumi.set(__self__, "depends_on_overrides", depends_on_overrides)
        if existing_target_id is not None:
            pulumi.set(__self__, "existing_target_id", existing_target_id)
        if resource_settings is not None:
            pulumi.set(__self__, "resource_settings", resource_settings)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[str]:
        """
        Gets or sets the Source ARM Id of the resource.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="dependsOnOverrides")
    def depends_on_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]]]:
        """
        Gets or sets the move resource dependencies overrides.
        """
        return pulumi.get(self, "depends_on_overrides")

    @depends_on_overrides.setter
    def depends_on_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MoveResourceDependencyOverrideArgs']]]]):
        pulumi.set(self, "depends_on_overrides", value)

    @property
    @pulumi.getter(name="existingTargetId")
    def existing_target_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the existing target ARM Id of the resource.
        """
        return pulumi.get(self, "existing_target_id")

    @existing_target_id.setter
    def existing_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_target_id", value)

    @property
    @pulumi.getter(name="resourceSettings")
    def resource_settings(self) -> Optional[pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']]]:
        """
        Gets or sets the resource settings.
        """
        return pulumi.get(self, "resource_settings")

    @resource_settings.setter
    def resource_settings(self, value: Optional[pulumi.Input[Union['AvailabilitySetResourceSettingsArgs', 'DiskEncryptionSetResourceSettingsArgs', 'KeyVaultResourceSettingsArgs', 'LoadBalancerResourceSettingsArgs', 'NetworkInterfaceResourceSettingsArgs', 'NetworkSecurityGroupResourceSettingsArgs', 'PublicIPAddressResourceSettingsArgs', 'ResourceGroupResourceSettingsArgs', 'SqlDatabaseResourceSettingsArgs', 'SqlElasticPoolResourceSettingsArgs', 'SqlServerResourceSettingsArgs', 'VirtualMachineResourceSettingsArgs', 'VirtualNetworkResourceSettingsArgs']]]):
        pulumi.set(self, "resource_settings", value)


@pulumi.input_type
class NetworkInterfaceResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 enable_accelerated_networking: Optional[pulumi.Input[bool]] = None,
                 ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]]] = None):
        """
        Defines the network interface resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/networkInterfaces'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[bool] enable_accelerated_networking: Gets or sets a value indicating whether accelerated networking is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]] ip_configurations: Gets or sets the IP configurations of the NIC.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/networkInterfaces')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if ip_configurations is not None:
            pulumi.set(__self__, "ip_configurations", ip_configurations)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/networkInterfaces'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether accelerated networking is enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @enable_accelerated_networking.setter
    def enable_accelerated_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_accelerated_networking", value)

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]]]:
        """
        Gets or sets the IP configurations of the NIC.
        """
        return pulumi.get(self, "ip_configurations")

    @ip_configurations.setter
    def ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NicIpConfigurationResourceSettingsArgs']]]]):
        pulumi.set(self, "ip_configurations", value)


@pulumi.input_type
class NetworkSecurityGroupResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]]] = None):
        """
        Defines the NSG resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/networkSecurityGroups'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]] security_rules: Gets or sets Security rules of network security group.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/networkSecurityGroups')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/networkSecurityGroups'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]]]:
        """
        Gets or sets Security rules of network security group.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NsgSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)


@pulumi.input_type
class NicIpConfigurationResourceSettingsArgs:
    def __init__(__self__, *,
                 load_balancer_backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]]] = None,
                 load_balancer_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 private_ip_allocation_method: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input['PublicIpReferenceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubnetReferenceArgs']] = None):
        """
        Defines NIC IP configuration properties.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]] load_balancer_backend_address_pools: Gets or sets the references of the load balancer backend address pools.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]] load_balancer_nat_rules: Gets or sets the references of the load balancer NAT rules.
        :param pulumi.Input[str] name: Gets or sets the IP configuration name.
        :param pulumi.Input[bool] primary: Gets or sets a value indicating whether this IP configuration is the primary.
        :param pulumi.Input[str] private_ip_address: Gets or sets the private IP address of the network interface IP Configuration.
        :param pulumi.Input[str] private_ip_allocation_method: Gets or sets the private IP address allocation method.
        :param pulumi.Input['PublicIpReferenceArgs'] public_ip: Defines reference to a public IP.
        :param pulumi.Input['SubnetReferenceArgs'] subnet: Defines reference to subnet.
        """
        if load_balancer_backend_address_pools is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pools", load_balancer_backend_address_pools)
        if load_balancer_nat_rules is not None:
            pulumi.set(__self__, "load_balancer_nat_rules", load_balancer_nat_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="loadBalancerBackendAddressPools")
    def load_balancer_backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]]]:
        """
        Gets or sets the references of the load balancer backend address pools.
        """
        return pulumi.get(self, "load_balancer_backend_address_pools")

    @load_balancer_backend_address_pools.setter
    def load_balancer_backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerBackendAddressPoolReferenceArgs']]]]):
        pulumi.set(self, "load_balancer_backend_address_pools", value)

    @property
    @pulumi.getter(name="loadBalancerNatRules")
    def load_balancer_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]]]:
        """
        Gets or sets the references of the load balancer NAT rules.
        """
        return pulumi.get(self, "load_balancer_nat_rules")

    @load_balancer_nat_rules.setter
    def load_balancer_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerNatRuleReferenceArgs']]]]):
        pulumi.set(self, "load_balancer_nat_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the IP configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def primary(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether this IP configuration is the primary.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the private IP address of the network interface IP Configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="privateIpAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the private IP address allocation method.
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @private_ip_allocation_method.setter
    def private_ip_allocation_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_allocation_method", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['PublicIpReferenceArgs']]:
        """
        Defines reference to a public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['PublicIpReferenceArgs']]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubnetReferenceArgs']]:
        """
        Defines reference to subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubnetReferenceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class NsgReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str]):
        """
        Defines reference to NSG.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)


@pulumi.input_type
class NsgSecurityRuleArgs:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_address_prefix: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_address_prefix: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None):
        """
        Security Rule data model for Network Security Groups.
        :param pulumi.Input[str] access: Gets or sets whether network traffic is allowed or denied.
               Possible values are “Allow” and “Deny”.
        :param pulumi.Input[str] description: Gets or sets a description for this rule. Restricted to 140 chars.
        :param pulumi.Input[str] destination_address_prefix: Gets or sets destination address prefix. CIDR or source IP range.
                A “*” can also be used to match all source IPs. Default tags such
               as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
        :param pulumi.Input[str] destination_port_range: Gets or sets Destination Port or Range. Integer or range between
               0 and 65535. A “*” can also be used to match all ports.
        :param pulumi.Input[str] direction: Gets or sets the direction of the rule.InBound or Outbound. The
               direction specifies if rule will be evaluated on incoming or outgoing traffic.
        :param pulumi.Input[str] name: Gets or sets the Security rule name.
        :param pulumi.Input[int] priority: Gets or sets the priority of the rule. The value can be between
               100 and 4096. The priority number must be unique for each rule in the collection.
               The lower the priority number, the higher the priority of the rule.
        :param pulumi.Input[str] protocol: Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        :param pulumi.Input[str] source_address_prefix: Gets or sets source address prefix. CIDR or source IP range. A
               “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
               ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
               rule, specifies where network traffic originates from.
        :param pulumi.Input[str] source_port_range: Gets or sets Source Port or Range. Integer or range between 0 and
               65535. A “*” can also be used to match all ports.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_address_prefix is not None:
            pulumi.set(__self__, "destination_address_prefix", destination_address_prefix)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_address_prefix is not None:
            pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets whether network traffic is allowed or denied.
        Possible values are “Allow” and “Deny”.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets a description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationAddressPrefix")
    def destination_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets destination address prefix. CIDR or source IP range.
         A “*” can also be used to match all source IPs. Default tags such
        as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
        """
        return pulumi.get(self, "destination_address_prefix")

    @destination_address_prefix.setter
    def destination_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_address_prefix", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Destination Port or Range. Integer or range between
        0 and 65535. A “*” can also be used to match all ports.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the direction of the rule.InBound or Outbound. The
        direction specifies if rule will be evaluated on incoming or outgoing traffic.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Security rule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the priority of the rule. The value can be between
        100 and 4096. The priority number must be unique for each rule in the collection.
        The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets source address prefix. CIDR or source IP range. A
        “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
        ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
        rule, specifies where network traffic originates from.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Source Port or Range. Integer or range between 0 and
        65535. A “*” can also be used to match all ports.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)


@pulumi.input_type
class PrivateEndpointConnectionPropertiesArgs:
    def __init__(__self__, *,
                 private_link_service_connection_state: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']] = None):
        """
        Private endpoint connection properties.
        :param pulumi.Input['PrivateLinkServiceConnectionStateArgs'] private_link_service_connection_state: State of the private endpoint connection.
        """
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]:
        """
        State of the private endpoint connection.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @private_link_service_connection_state.setter
    def private_link_service_connection_state(self, value: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]):
        pulumi.set(self, "private_link_service_connection_state", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        State of a private endpoint connection.
        :param pulumi.Input[str] actions_required: Actions required on the private endpoint connection.
        :param pulumi.Input[str] description: Description of the private endpoint connection.
        :param pulumi.Input[str] status: Connection status of the private endpoint connection.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        Actions required on the private endpoint connection.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the private endpoint connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Connection status of the private endpoint connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ProjectPropertiesArgs:
    def __init__(__self__, *,
                 assessment_solution_id: Optional[pulumi.Input[str]] = None,
                 customer_storage_account_arm_id: Optional[pulumi.Input[str]] = None,
                 customer_workspace_id: Optional[pulumi.Input[str]] = None,
                 customer_workspace_location: Optional[pulumi.Input[str]] = None,
                 project_status: Optional[pulumi.Input[Union[str, 'ProjectStatus']]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None):
        """
        Properties of a project.
        :param pulumi.Input[str] assessment_solution_id: Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
        :param pulumi.Input[str] customer_storage_account_arm_id: The ARM id of the storage account used for interactions when public access is disabled.
        :param pulumi.Input[str] customer_workspace_id: The ARM id of service map workspace created by customer.
        :param pulumi.Input[str] customer_workspace_location: Location of service map workspace created by customer.
        :param pulumi.Input[Union[str, 'ProjectStatus']] project_status: Assessment project status.
        :param pulumi.Input[str] public_network_access: This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
        """
        if assessment_solution_id is not None:
            pulumi.set(__self__, "assessment_solution_id", assessment_solution_id)
        if customer_storage_account_arm_id is not None:
            pulumi.set(__self__, "customer_storage_account_arm_id", customer_storage_account_arm_id)
        if customer_workspace_id is not None:
            pulumi.set(__self__, "customer_workspace_id", customer_workspace_id)
        if customer_workspace_location is not None:
            pulumi.set(__self__, "customer_workspace_location", customer_workspace_location)
        if project_status is not None:
            pulumi.set(__self__, "project_status", project_status)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="assessmentSolutionId")
    def assessment_solution_id(self) -> Optional[pulumi.Input[str]]:
        """
        Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
        """
        return pulumi.get(self, "assessment_solution_id")

    @assessment_solution_id.setter
    def assessment_solution_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assessment_solution_id", value)

    @property
    @pulumi.getter(name="customerStorageAccountArmId")
    def customer_storage_account_arm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM id of the storage account used for interactions when public access is disabled.
        """
        return pulumi.get(self, "customer_storage_account_arm_id")

    @customer_storage_account_arm_id.setter
    def customer_storage_account_arm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_storage_account_arm_id", value)

    @property
    @pulumi.getter(name="customerWorkspaceId")
    def customer_workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM id of service map workspace created by customer.
        """
        return pulumi.get(self, "customer_workspace_id")

    @customer_workspace_id.setter
    def customer_workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_workspace_id", value)

    @property
    @pulumi.getter(name="customerWorkspaceLocation")
    def customer_workspace_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of service map workspace created by customer.
        """
        return pulumi.get(self, "customer_workspace_location")

    @customer_workspace_location.setter
    def customer_workspace_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_workspace_location", value)

    @property
    @pulumi.getter(name="projectStatus")
    def project_status(self) -> Optional[pulumi.Input[Union[str, 'ProjectStatus']]]:
        """
        Assessment project status.
        """
        return pulumi.get(self, "project_status")

    @project_status.setter
    def project_status(self, value: Optional[pulumi.Input[Union[str, 'ProjectStatus']]]):
        pulumi.set(self, "project_status", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[str]]:
        """
        This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access", value)


@pulumi.input_type
class PublicIPAddressResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 domain_name_label: Optional[pulumi.Input[str]] = None,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 public_ip_allocation_method: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[str]] = None):
        """
        Defines the public IP address resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/publicIPAddresses'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[str] domain_name_label: Gets or sets the domain name label.
        :param pulumi.Input[str] fqdn: Gets or sets the fully qualified domain name.
        :param pulumi.Input[str] public_ip_allocation_method: Gets or sets public IP allocation method.
        :param pulumi.Input[str] sku: Gets or sets public IP sku.
        :param pulumi.Input[str] zones: Gets or sets public IP zones.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/publicIPAddresses')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if public_ip_allocation_method is not None:
            pulumi.set(__self__, "public_ip_allocation_method", public_ip_allocation_method)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/publicIPAddresses'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the domain name label.
        """
        return pulumi.get(self, "domain_name_label")

    @domain_name_label.setter
    def domain_name_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name_label", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the fully qualified domain name.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="publicIpAllocationMethod")
    def public_ip_allocation_method(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets public IP allocation method.
        """
        return pulumi.get(self, "public_ip_allocation_method")

    @public_ip_allocation_method.setter
    def public_ip_allocation_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_allocation_method", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets public IP sku.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets public IP zones.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class PublicIpReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str]):
        """
        Defines reference to a public IP.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)


@pulumi.input_type
class ResourceGroupResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the resource group resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'resourceGroups'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'resourceGroups')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'resourceGroups'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class SolutionDetailsArgs:
    def __init__(__self__, *,
                 assessment_count: Optional[pulumi.Input[int]] = None,
                 extended_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 group_count: Optional[pulumi.Input[int]] = None):
        """
        Class representing the details of the solution.
        :param pulumi.Input[int] assessment_count: Gets or sets the count of assessments reported by the solution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extended_details: Gets or sets the extended details reported by the solution.
        :param pulumi.Input[int] group_count: Gets or sets the count of groups reported by the solution.
        """
        if assessment_count is not None:
            pulumi.set(__self__, "assessment_count", assessment_count)
        if extended_details is not None:
            pulumi.set(__self__, "extended_details", extended_details)
        if group_count is not None:
            pulumi.set(__self__, "group_count", group_count)

    @property
    @pulumi.getter(name="assessmentCount")
    def assessment_count(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the count of assessments reported by the solution.
        """
        return pulumi.get(self, "assessment_count")

    @assessment_count.setter
    def assessment_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "assessment_count", value)

    @property
    @pulumi.getter(name="extendedDetails")
    def extended_details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the extended details reported by the solution.
        """
        return pulumi.get(self, "extended_details")

    @extended_details.setter
    def extended_details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extended_details", value)

    @property
    @pulumi.getter(name="groupCount")
    def group_count(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the count of groups reported by the solution.
        """
        return pulumi.get(self, "group_count")

    @group_count.setter
    def group_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_count", value)


@pulumi.input_type
class SolutionPropertiesArgs:
    def __init__(__self__, *,
                 cleanup_state: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input['SolutionDetailsArgs']] = None,
                 goal: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tool: Optional[pulumi.Input[str]] = None):
        """
        Class for solution properties.
        :param pulumi.Input[str] cleanup_state: Gets or sets the cleanup state of the solution.
        :param pulumi.Input['SolutionDetailsArgs'] details: Gets or sets the details of the solution.
        :param pulumi.Input[str] goal: Gets or sets the goal of the solution.
        :param pulumi.Input[str] purpose: Gets or sets the purpose of the solution.
        :param pulumi.Input[str] status: Gets or sets the current status of the solution.
        :param pulumi.Input[str] tool: Gets or sets the tool being used in the solution.
        """
        if cleanup_state is not None:
            pulumi.set(__self__, "cleanup_state", cleanup_state)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if goal is not None:
            pulumi.set(__self__, "goal", goal)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tool is not None:
            pulumi.set(__self__, "tool", tool)

    @property
    @pulumi.getter(name="cleanupState")
    def cleanup_state(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the cleanup state of the solution.
        """
        return pulumi.get(self, "cleanup_state")

    @cleanup_state.setter
    def cleanup_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cleanup_state", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input['SolutionDetailsArgs']]:
        """
        Gets or sets the details of the solution.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input['SolutionDetailsArgs']]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def goal(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the goal of the solution.
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "goal", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the purpose of the solution.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the current status of the solution.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tool(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the tool being used in the solution.
        """
        return pulumi.get(self, "tool")

    @tool.setter
    def tool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tool", value)


@pulumi.input_type
class SqlDatabaseResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 zone_redundant: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]] = None):
        """
        Defines the Sql Database resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Union[str, 'ZoneRedundant']] zone_redundant: Defines the zone redundant resource setting.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers/databases')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]:
        """
        Defines the zone redundant resource setting.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class SqlElasticPoolResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 zone_redundant: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]] = None):
        """
        Defines the Sql ElasticPool resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers/elasticPools'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Union[str, 'ZoneRedundant']] zone_redundant: Defines the zone redundant resource setting.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers/elasticPools')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers/elasticPools'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]:
        """
        Defines the zone redundant resource setting.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[Union[str, 'ZoneRedundant']]]):
        pulumi.set(self, "zone_redundant", value)


@pulumi.input_type
class SqlServerResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str]):
        """
        Defines the SQL Server resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Sql/servers'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Sql/servers')
        pulumi.set(__self__, "target_resource_name", target_resource_name)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Sql/servers'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)


@pulumi.input_type
class SubnetReferenceArgs:
    def __init__(__self__, *,
                 source_arm_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Defines reference to subnet.
        :param pulumi.Input[str] source_arm_resource_id: Gets the ARM resource ID of the tracked resource being referenced.
        :param pulumi.Input[str] name: Gets the name of the proxy resource on the target side.
        """
        pulumi.set(__self__, "source_arm_resource_id", source_arm_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="sourceArmResourceId")
    def source_arm_resource_id(self) -> pulumi.Input[str]:
        """
        Gets the ARM resource ID of the tracked resource being referenced.
        """
        return pulumi.get(self, "source_arm_resource_id")

    @source_arm_resource_id.setter
    def source_arm_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_arm_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the name of the proxy resource on the target side.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SubnetResourceSettingsArgs:
    def __init__(__self__, *,
                 address_prefix: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_security_group: Optional[pulumi.Input['NsgReferenceArgs']] = None):
        """
        Defines the virtual network subnets resource settings.
        :param pulumi.Input[str] address_prefix: Gets or sets address prefix for the subnet.
        :param pulumi.Input[str] name: Gets or sets the Subnet name.
        :param pulumi.Input['NsgReferenceArgs'] network_security_group: Defines reference to NSG.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_security_group is not None:
            pulumi.set(__self__, "network_security_group", network_security_group)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets address prefix for the subnet.
        """
        return pulumi.get(self, "address_prefix")

    @address_prefix.setter
    def address_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_prefix", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Subnet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkSecurityGroup")
    def network_security_group(self) -> Optional[pulumi.Input['NsgReferenceArgs']]:
        """
        Defines reference to NSG.
        """
        return pulumi.get(self, "network_security_group")

    @network_security_group.setter
    def network_security_group(self, value: Optional[pulumi.Input['NsgReferenceArgs']]):
        pulumi.set(self, "network_security_group", value)


@pulumi.input_type
class VirtualMachineResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 target_availability_set_id: Optional[pulumi.Input[str]] = None,
                 target_availability_zone: Optional[pulumi.Input[Union[str, 'TargetAvailabilityZone']]] = None,
                 target_vm_size: Optional[pulumi.Input[str]] = None):
        """
        Gets or sets the virtual machine resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[str] target_availability_set_id: Gets or sets the target availability set id for virtual machines not in an availability set at source.
        :param pulumi.Input[Union[str, 'TargetAvailabilityZone']] target_availability_zone: Gets or sets the target availability zone.
        :param pulumi.Input[str] target_vm_size: Gets or sets the target virtual machine size.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Compute/virtualMachines')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if target_availability_set_id is not None:
            pulumi.set(__self__, "target_availability_set_id", target_availability_set_id)
        if target_availability_zone is not None:
            pulumi.set(__self__, "target_availability_zone", target_availability_zone)
        if target_vm_size is not None:
            pulumi.set(__self__, "target_vm_size", target_vm_size)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="targetAvailabilitySetId")
    def target_availability_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target availability set id for virtual machines not in an availability set at source.
        """
        return pulumi.get(self, "target_availability_set_id")

    @target_availability_set_id.setter
    def target_availability_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_availability_set_id", value)

    @property
    @pulumi.getter(name="targetAvailabilityZone")
    def target_availability_zone(self) -> Optional[pulumi.Input[Union[str, 'TargetAvailabilityZone']]]:
        """
        Gets or sets the target availability zone.
        """
        return pulumi.get(self, "target_availability_zone")

    @target_availability_zone.setter
    def target_availability_zone(self, value: Optional[pulumi.Input[Union[str, 'TargetAvailabilityZone']]]):
        pulumi.set(self, "target_availability_zone", value)

    @property
    @pulumi.getter(name="targetVmSize")
    def target_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "target_vm_size")

    @target_vm_size.setter
    def target_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_vm_size", value)


@pulumi.input_type
class VirtualNetworkResourceSettingsArgs:
    def __init__(__self__, *,
                 resource_type: pulumi.Input[str],
                 target_resource_name: pulumi.Input[str],
                 address_space: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_ddos_protection: Optional[pulumi.Input[bool]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]]] = None):
        """
        Defines the virtual network resource settings.
        :param pulumi.Input[str] resource_type: The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
               Expected value is 'Microsoft.Network/virtualNetworks'.
        :param pulumi.Input[str] target_resource_name: Gets or sets the target Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] address_space: Gets or sets the address prefixes for the virtual network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_servers: Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
               deployed in the virtual network.
        :param pulumi.Input[bool] enable_ddos_protection: Gets or sets a value indicating whether gets or sets whether the
               DDOS protection should be switched on.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]] subnets: Gets or sets List of subnets in a VirtualNetwork.
        """
        pulumi.set(__self__, "resource_type", 'Microsoft.Network/virtualNetworks')
        pulumi.set(__self__, "target_resource_name", target_resource_name)
        if address_space is not None:
            pulumi.set(__self__, "address_space", address_space)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_ddos_protection is not None:
            pulumi.set(__self__, "enable_ddos_protection", enable_ddos_protection)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
        Expected value is 'Microsoft.Network/virtualNetworks'.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="targetResourceName")
    def target_resource_name(self) -> pulumi.Input[str]:
        """
        Gets or sets the target Resource name.
        """
        return pulumi.get(self, "target_resource_name")

    @target_resource_name.setter
    def target_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_resource_name", value)

    @property
    @pulumi.getter(name="addressSpace")
    def address_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the address prefixes for the virtual network.
        """
        return pulumi.get(self, "address_space")

    @address_space.setter
    def address_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "address_space", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
        deployed in the virtual network.
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="enableDdosProtection")
    def enable_ddos_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether gets or sets whether the
        DDOS protection should be switched on.
        """
        return pulumi.get(self, "enable_ddos_protection")

    @enable_ddos_protection.setter
    def enable_ddos_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ddos_protection", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]]]:
        """
        Gets or sets List of subnets in a VirtualNetwork.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetResourceSettingsArgs']]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class VmUptimeArgs:
    def __init__(__self__, *,
                 days_per_month: Optional[pulumi.Input[float]] = None,
                 hours_per_day: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] days_per_month: Number of days in a month for VM uptime.
        :param pulumi.Input[float] hours_per_day: Number of hours per day for VM uptime.
        """
        if days_per_month is not None:
            pulumi.set(__self__, "days_per_month", days_per_month)
        if hours_per_day is not None:
            pulumi.set(__self__, "hours_per_day", hours_per_day)

    @property
    @pulumi.getter(name="daysPerMonth")
    def days_per_month(self) -> Optional[pulumi.Input[float]]:
        """
        Number of days in a month for VM uptime.
        """
        return pulumi.get(self, "days_per_month")

    @days_per_month.setter
    def days_per_month(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "days_per_month", value)

    @property
    @pulumi.getter(name="hoursPerDay")
    def hours_per_day(self) -> Optional[pulumi.Input[float]]:
        """
        Number of hours per day for VM uptime.
        """
        return pulumi.get(self, "hours_per_day")

    @hours_per_day.setter
    def hours_per_day(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "hours_per_day", value)


