# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetMediaServiceResult',
    'AwaitableGetMediaServiceResult',
    'get_media_service',
]

@pulumi.output_type
class GetMediaServiceResult:
    """
    The properties of a Media Service resource.
    """
    def __init__(__self__, api_endpoints=None, id=None, location=None, name=None, storage_accounts=None, tags=None, type=None):
        if api_endpoints and not isinstance(api_endpoints, list):
            raise TypeError("Expected argument 'api_endpoints' to be a list")
        pulumi.set(__self__, "api_endpoints", api_endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if storage_accounts and not isinstance(storage_accounts, list):
            raise TypeError("Expected argument 'storage_accounts' to be a list")
        pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiEndpoints")
    def api_endpoints(self) -> Sequence['outputs.ApiEndpointResponse']:
        """
        Read-only property that lists the Media Services REST API endpoints for this resource. If supplied on a PUT or PATCH, the value will be ignored.
        """
        return pulumi.get(self, "api_endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The geographic location of the resource. This must be one of the supported and registered Azure Geo Regions (for example, West US, East US, Southeast Asia, and so forth).
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[Sequence['outputs.StorageAccountResponse']]:
        """
        The storage accounts for this resource.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags to help categorize the resource in the Azure portal.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource
        """
        return pulumi.get(self, "type")


class AwaitableGetMediaServiceResult(GetMediaServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaServiceResult(
            api_endpoints=self.api_endpoints,
            id=self.id,
            location=self.location,
            name=self.name,
            storage_accounts=self.storage_accounts,
            tags=self.tags,
            type=self.type)


def get_media_service(media_service_name: Optional[str] = None,
                      resource_group_name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaServiceResult:
    """
    The properties of a Media Service resource.


    :param str media_service_name: Name of the Media Service.
    :param str resource_group_name: Name of the resource group within the Azure subscription.
    """
    __args__ = dict()
    __args__['mediaServiceName'] = media_service_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:media/v20151001:getMediaService', __args__, opts=opts, typ=GetMediaServiceResult).value

    return AwaitableGetMediaServiceResult(
        api_endpoints=__ret__.api_endpoints,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        storage_accounts=__ret__.storage_accounts,
        tags=__ret__.tags,
        type=__ret__.type)
