# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AKSResponse',
    'AKSResponseProperties',
    'AccountKeyDatastoreCredentialsResponse',
    'AksNetworkingConfigurationResponse',
    'AmlComputeNodeInformationResponse',
    'AmlComputeResponse',
    'AmlComputeResponseProperties',
    'AmlTokenResponse',
    'AssignedUserResponse',
    'AutoPausePropertiesResponse',
    'AutoScalePropertiesResponse',
    'AutoScaleSettingsResponse',
    'AzureBlobContentsResponse',
    'AzureDataLakeGen1ContentsResponse',
    'AzureDataLakeGen2ContentsResponse',
    'AzureFileContentsResponse',
    'AzurePostgreSqlContentsResponse',
    'AzureSqlDatabaseContentsResponse',
    'BanditPolicyResponse',
    'BatchDeploymentResponse',
    'BatchEndpointResponse',
    'BatchOutputConfigurationResponse',
    'BatchRetrySettingsResponse',
    'CertificateDatastoreCredentialsResponse',
    'CodeConfigurationResponse',
    'CodeContainerResponse',
    'CodeVersionResponse',
    'CommandJobResponse',
    'ComputeConfigurationResponse',
    'ComputeInstanceApplicationResponse',
    'ComputeInstanceConnectivityEndpointsResponse',
    'ComputeInstanceCreatedByResponse',
    'ComputeInstanceLastOperationResponse',
    'ComputeInstanceResponse',
    'ComputeInstanceResponseProperties',
    'ComputeInstanceSshSettingsResponse',
    'ComputeSchedulesResponse',
    'ComputeStartStopScheduleResponse',
    'ContainerResourceRequirementsResponse',
    'CosmosDbSettingsResponse',
    'CronResponse',
    'DataContainerResponse',
    'DataFactoryResponse',
    'DataLakeAnalyticsResponse',
    'DataLakeAnalyticsResponseProperties',
    'DataPathAssetReferenceResponse',
    'DataVersionResponse',
    'DatabricksResponse',
    'DatabricksResponseProperties',
    'DatastorePropertiesResponse',
    'DockerBuildResponse',
    'DockerImagePlatformResponse',
    'DockerImageResponse',
    'EncryptionPropertyResponse',
    'EnvironmentContainerResponse',
    'EnvironmentSpecificationVersionResponse',
    'ErrorAdditionalInfoResponse',
    'ErrorDetailResponse',
    'ErrorResponseResponse',
    'FlavorDataResponse',
    'GlusterFsContentsResponse',
    'HDInsightResponse',
    'HDInsightResponseProperties',
    'IdAssetReferenceResponse',
    'IdentityForCmkResponse',
    'IdentityResponse',
    'InferenceContainerPropertiesResponse',
    'InputDataBindingResponse',
    'JobEndpointResponse',
    'JobOutputResponse',
    'K8sOnlineDeploymentResponse',
    'KeyVaultPropertiesResponse',
    'LabelCategoryResponse',
    'LabelClassResponse',
    'LabelingDatasetConfigurationResponse',
    'LabelingJobImagePropertiesResponse',
    'LabelingJobInstructionsResponse',
    'LabelingJobResponse',
    'LabelingJobTextPropertiesResponse',
    'LinkedInfoResponse',
    'ListNotebookKeysResultResponse',
    'MLAssistConfigurationResponse',
    'ManagedIdentityResponse',
    'ManagedOnlineDeploymentResponse',
    'ManualScaleSettingsResponse',
    'MedianStoppingPolicyResponse',
    'ModelContainerResponse',
    'ModelVersionResponse',
    'MpiResponse',
    'NodeStateCountsResponse',
    'NoneDatastoreCredentialsResponse',
    'NotebookPreparationErrorResponse',
    'NotebookResourceInfoResponse',
    'ObjectiveResponse',
    'OnlineEndpointResponse',
    'OnlineRequestSettingsResponse',
    'OutputDataBindingResponse',
    'OutputPathAssetReferenceResponse',
    'PasswordResponse',
    'PersonalComputeInstanceSettingsResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ProbeSettingsResponse',
    'ProgressMetricsResponse',
    'PyTorchResponse',
    'RecurrenceResponse',
    'RecurrenceScheduleResponse',
    'RegistryListCredentialsResultResponse',
    'ResourceIdResponse',
    'ResourceIdentityResponse',
    'RouteResponse',
    'SasDatastoreCredentialsResponse',
    'ScaleSettingsResponse',
    'ScriptReferenceResponse',
    'ScriptsToExecuteResponse',
    'ServiceManagedResourcesSettingsResponse',
    'ServicePrincipalDatastoreCredentialsResponse',
    'SetupScriptsResponse',
    'SharedPrivateLinkResourceResponse',
    'SkuResponse',
    'SqlAdminDatastoreCredentialsResponse',
    'SslConfigurationResponse',
    'StatusMessageResponse',
    'SweepJobResponse',
    'SynapseSparkPoolPropertiesResponseProperties',
    'SynapseSparkResponse',
    'SystemDataResponse',
    'SystemServiceResponse',
    'TensorFlowResponse',
    'TrialComponentResponse',
    'TruncationSelectionPolicyResponse',
    'UserAccountCredentialsResponse',
    'UserAssignedIdentityMetaResponse',
    'UserAssignedIdentityResponse',
    'VirtualMachineImageResponse',
    'VirtualMachineResponse',
    'VirtualMachineResponseProperties',
    'VirtualMachineSshCredentialsResponse',
]

@pulumi.output_type
class AKSResponse(dict):
    """
    A Machine Learning compute based on AKS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.AKSResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on AKS.
        :param str compute_type: The type of compute
               Expected value is 'AKS'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'AKSResponseProperties' properties: AKS properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AKSResponseProperties']:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AKSResponseProperties(dict):
    """
    AKS properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemServices":
            suggest = "system_services"
        elif key == "agentCount":
            suggest = "agent_count"
        elif key == "agentVmSize":
            suggest = "agent_vm_size"
        elif key == "aksNetworkingConfiguration":
            suggest = "aks_networking_configuration"
        elif key == "clusterFqdn":
            suggest = "cluster_fqdn"
        elif key == "clusterPurpose":
            suggest = "cluster_purpose"
        elif key == "loadBalancerSubnet":
            suggest = "load_balancer_subnet"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"
        elif key == "sslConfiguration":
            suggest = "ssl_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_services: Sequence['outputs.SystemServiceResponse'],
                 agent_count: Optional[int] = None,
                 agent_vm_size: Optional[str] = None,
                 aks_networking_configuration: Optional['outputs.AksNetworkingConfigurationResponse'] = None,
                 cluster_fqdn: Optional[str] = None,
                 cluster_purpose: Optional[str] = None,
                 load_balancer_subnet: Optional[str] = None,
                 load_balancer_type: Optional[str] = None,
                 ssl_configuration: Optional['outputs.SslConfigurationResponse'] = None):
        """
        AKS properties
        :param Sequence['SystemServiceResponse'] system_services: System services
        :param int agent_count: Number of agents
        :param str agent_vm_size: Agent virtual machine size
        :param 'AksNetworkingConfigurationResponse' aks_networking_configuration: AKS networking configuration for vnet
        :param str cluster_fqdn: Cluster full qualified domain name
        :param str cluster_purpose: Intended usage of the cluster
        :param str load_balancer_subnet: Load Balancer Subnet
        :param str load_balancer_type: Load Balancer Type
        :param 'SslConfigurationResponse' ssl_configuration: SSL configuration
        """
        pulumi.set(__self__, "system_services", system_services)
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if cluster_purpose is None:
            cluster_purpose = 'FastProd'
        if cluster_purpose is not None:
            pulumi.set(__self__, "cluster_purpose", cluster_purpose)
        if load_balancer_subnet is not None:
            pulumi.set(__self__, "load_balancer_subnet", load_balancer_subnet)
        if load_balancer_type is None:
            load_balancer_type = 'PublicIp'
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="systemServices")
    def system_services(self) -> Sequence['outputs.SystemServiceResponse']:
        """
        System services
        """
        return pulumi.get(self, "system_services")

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[int]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @property
    @pulumi.getter(name="agentVmSize")
    def agent_vm_size(self) -> Optional[str]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional['outputs.AksNetworkingConfigurationResponse']:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[str]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @property
    @pulumi.getter(name="clusterPurpose")
    def cluster_purpose(self) -> Optional[str]:
        """
        Intended usage of the cluster
        """
        return pulumi.get(self, "cluster_purpose")

    @property
    @pulumi.getter(name="loadBalancerSubnet")
    def load_balancer_subnet(self) -> Optional[str]:
        """
        Load Balancer Subnet
        """
        return pulumi.get(self, "load_balancer_subnet")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[str]:
        """
        Load Balancer Type
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional['outputs.SslConfigurationResponse']:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")


@pulumi.output_type
class AccountKeyDatastoreCredentialsResponse(dict):
    """
    Account key datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountKeyDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountKeyDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountKeyDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str):
        """
        Account key datastore credentials configuration.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'AccountKey'.
        """
        pulumi.set(__self__, "credentials_type", 'AccountKey')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'AccountKey'.
        """
        return pulumi.get(self, "credentials_type")


@pulumi.output_type
class AksNetworkingConfigurationResponse(dict):
    """
    Advance configuration for AKS networking
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServiceIP":
            suggest = "dns_service_ip"
        elif key == "dockerBridgeCidr":
            suggest = "docker_bridge_cidr"
        elif key == "serviceCidr":
            suggest = "service_cidr"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AksNetworkingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AksNetworkingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_service_ip: Optional[str] = None,
                 docker_bridge_cidr: Optional[str] = None,
                 service_cidr: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        Advance configuration for AKS networking
        :param str dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param str docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param str service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param str subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[str]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[str]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class AmlComputeNodeInformationResponse(dict):
    """
    Compute node information related to a AmlCompute.
    """
    def __init__(__self__, *,
                 node_id: str,
                 node_state: str,
                 port: float,
                 private_ip_address: str,
                 public_ip_address: str,
                 run_id: str):
        """
        Compute node information related to a AmlCompute.
        :param str node_id: ID of the compute node.
        :param str node_state: State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        :param float port: SSH port number of the node.
        :param str private_ip_address: Private IP address of the compute node.
        :param str public_ip_address: Public IP address of the compute node.
        :param str run_id: ID of the Experiment running on the node, if any else null.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_state", node_state)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "run_id", run_id)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        ID of the compute node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeState")
    def node_state(self) -> str:
        """
        State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
        """
        return pulumi.get(self, "node_state")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        SSH port number of the node.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP address of the compute node.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address of the compute node.
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        ID of the Experiment running on the node, if any else null.
        """
        return pulumi.get(self, "run_id")


@pulumi.output_type
class AmlComputeResponse(dict):
    """
    An Azure Machine Learning compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.AmlComputeResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute.
        :param str compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'AmlComputeResponseProperties' properties: AML Compute properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.AmlComputeResponseProperties']:
        """
        AML Compute properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class AmlComputeResponseProperties(dict):
    """
    AML Compute properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationState":
            suggest = "allocation_state"
        elif key == "allocationStateTransitionTime":
            suggest = "allocation_state_transition_time"
        elif key == "currentNodeCount":
            suggest = "current_node_count"
        elif key == "nodeStateCounts":
            suggest = "node_state_counts"
        elif key == "targetNodeCount":
            suggest = "target_node_count"
        elif key == "enableNodePublicIp":
            suggest = "enable_node_public_ip"
        elif key == "isolatedNetwork":
            suggest = "isolated_network"
        elif key == "osType":
            suggest = "os_type"
        elif key == "remoteLoginPortPublicAccess":
            suggest = "remote_login_port_public_access"
        elif key == "scaleSettings":
            suggest = "scale_settings"
        elif key == "userAccountCredentials":
            suggest = "user_account_credentials"
        elif key == "virtualMachineImage":
            suggest = "virtual_machine_image"
        elif key == "vmPriority":
            suggest = "vm_priority"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlComputeResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlComputeResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlComputeResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_state: str,
                 allocation_state_transition_time: str,
                 current_node_count: int,
                 errors: Sequence['outputs.ErrorResponseResponse'],
                 node_state_counts: 'outputs.NodeStateCountsResponse',
                 target_node_count: int,
                 enable_node_public_ip: Optional[bool] = None,
                 isolated_network: Optional[bool] = None,
                 os_type: Optional[str] = None,
                 remote_login_port_public_access: Optional[str] = None,
                 scale_settings: Optional['outputs.ScaleSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 user_account_credentials: Optional['outputs.UserAccountCredentialsResponse'] = None,
                 virtual_machine_image: Optional['outputs.VirtualMachineImageResponse'] = None,
                 vm_priority: Optional[str] = None,
                 vm_size: Optional[str] = None):
        """
        AML Compute properties
        :param str allocation_state: Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        :param str allocation_state_transition_time: The time at which the compute entered its current allocation state.
        :param int current_node_count: The number of compute nodes currently assigned to the compute.
        :param Sequence['ErrorResponseResponse'] errors: Collection of errors encountered by various compute nodes during node setup.
        :param 'NodeStateCountsResponse' node_state_counts: Counts of various node states on the compute.
        :param int target_node_count: The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        :param bool enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param bool isolated_network: Network is isolated or not
        :param str os_type: Compute OS Type
        :param str remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param 'ScaleSettingsResponse' scale_settings: Scale settings for AML Compute
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param 'UserAccountCredentialsResponse' user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param 'VirtualMachineImageResponse' virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param str vm_priority: Virtual Machine priority
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "allocation_state", allocation_state)
        pulumi.set(__self__, "allocation_state_transition_time", allocation_state_transition_time)
        pulumi.set(__self__, "current_node_count", current_node_count)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "node_state_counts", node_state_counts)
        pulumi.set(__self__, "target_node_count", target_node_count)
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="allocationState")
    def allocation_state(self) -> str:
        """
        Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There are no changes to the number of compute nodes in the compute in progress. A compute enters this state when it is created and when no operations are being performed on the compute to change the number of compute nodes. resizing - Indicates that the compute is resizing; that is, compute nodes are being added to or removed from the compute.
        """
        return pulumi.get(self, "allocation_state")

    @property
    @pulumi.getter(name="allocationStateTransitionTime")
    def allocation_state_transition_time(self) -> str:
        """
        The time at which the compute entered its current allocation state.
        """
        return pulumi.get(self, "allocation_state_transition_time")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> int:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Collection of errors encountered by various compute nodes during node setup.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="nodeStateCounts")
    def node_state_counts(self) -> 'outputs.NodeStateCountsResponse':
        """
        Counts of various node states on the compute.
        """
        return pulumi.get(self, "node_state_counts")

    @property
    @pulumi.getter(name="targetNodeCount")
    def target_node_count(self) -> int:
        """
        The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes the target node count for the ongoing resize operation. If the allocationState is steady, this property denotes the target node count for the previous resize operation.
        """
        return pulumi.get(self, "target_node_count")

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[bool]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[bool]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional['outputs.ScaleSettingsResponse']:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional['outputs.UserAccountCredentialsResponse']:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional['outputs.VirtualMachineImageResponse']:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[str]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class AmlTokenResponse(dict):
    """
    AML Token identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AmlTokenResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AmlTokenResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AmlTokenResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str):
        """
        AML Token identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'AMLToken'.
        """
        pulumi.set(__self__, "identity_type", 'AMLToken')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'AMLToken'.
        """
        return pulumi.get(self, "identity_type")


@pulumi.output_type
class AssignedUserResponse(dict):
    """
    A user that can be assigned to a compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignedUserResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignedUserResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignedUserResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: str,
                 tenant_id: str):
        """
        A user that can be assigned to a compute instance.
        :param str object_id: User’s AAD Object Id.
        :param str tenant_id: User’s AAD Tenant Id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AutoPausePropertiesResponse(dict):
    """
    Auto pause properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "delayInMinutes":
            suggest = "delay_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoPausePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoPausePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoPausePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay_in_minutes: Optional[int] = None,
                 enabled: Optional[bool] = None):
        """
        Auto pause properties
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[int]:
        return pulumi.get(self, "delay_in_minutes")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AutoScalePropertiesResponse(dict):
    """
    Auto scale properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 max_node_count: Optional[int] = None,
                 min_node_count: Optional[int] = None):
        """
        Auto scale properties
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[int]:
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class AutoScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"
        elif key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"
        elif key == "pollingInterval":
            suggest = "polling_interval"
        elif key == "targetUtilizationPercentage":
            suggest = "target_utilization_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_type: str,
                 max_instances: Optional[int] = None,
                 min_instances: Optional[int] = None,
                 polling_interval: Optional[str] = None,
                 target_utilization_percentage: Optional[int] = None):
        """
        :param str scale_type: 
               Expected value is 'Auto'.
        :param int max_instances: Maximum number of instances for this deployment.
        :param int min_instances: Minimum number of instances for this deployment.
        :param str polling_interval: The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        :param int target_utilization_percentage: Target CPU usage for the autoscaler.
        """
        pulumi.set(__self__, "scale_type", 'Auto')
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if polling_interval is not None:
            pulumi.set(__self__, "polling_interval", polling_interval)
        if target_utilization_percentage is not None:
            pulumi.set(__self__, "target_utilization_percentage", target_utilization_percentage)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> str:
        """

        Expected value is 'Auto'.
        """
        return pulumi.get(self, "scale_type")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[int]:
        """
        Maximum number of instances for this deployment.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[int]:
        """
        Minimum number of instances for this deployment.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> Optional[str]:
        """
        The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "polling_interval")

    @property
    @pulumi.getter(name="targetUtilizationPercentage")
    def target_utilization_percentage(self) -> Optional[int]:
        """
        Target CPU usage for the autoscaler.
        """
        return pulumi.get(self, "target_utilization_percentage")


@pulumi.output_type
class AzureBlobContentsResponse(dict):
    """
    Azure Blob datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "contentsType":
            suggest = "contents_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container_name: str,
                 contents_type: str,
                 credentials: Any,
                 endpoint: str,
                 protocol: str):
        """
        Azure Blob datastore configuration.
        :param str account_name: Storage account name.
        :param str container_name: Storage account container name.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureBlob'.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse', 'SqlAdminDatastoreCredentialsResponse'] credentials: Account credentials.
        :param str endpoint: Azure cloud endpoint for the storage account.
        :param str protocol: Protocol used to communicate with the storage account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "contents_type", 'AzureBlob')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureBlob'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class AzureDataLakeGen1ContentsResponse(dict):
    """
    Azure Data Lake Gen1 datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentsType":
            suggest = "contents_type"
        elif key == "storeName":
            suggest = "store_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeGen1ContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeGen1ContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeGen1ContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contents_type: str,
                 credentials: Any,
                 store_name: str):
        """
        Azure Data Lake Gen1 datastore configuration.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen1'.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse', 'SqlAdminDatastoreCredentialsResponse'] credentials: Account credentials.
        :param str store_name: Azure Data Lake store name.
        """
        pulumi.set(__self__, "contents_type", 'AzureDataLakeGen1')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "store_name", store_name)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen1'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> str:
        """
        Azure Data Lake store name.
        """
        return pulumi.get(self, "store_name")


@pulumi.output_type
class AzureDataLakeGen2ContentsResponse(dict):
    """
    Azure Data Lake Gen2 datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "contentsType":
            suggest = "contents_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDataLakeGen2ContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDataLakeGen2ContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDataLakeGen2ContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container_name: str,
                 contents_type: str,
                 credentials: Any,
                 endpoint: str,
                 protocol: str):
        """
        Azure Data Lake Gen2 datastore configuration.
        :param str account_name: Storage account name.
        :param str container_name: Storage account container name.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen2'.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse', 'SqlAdminDatastoreCredentialsResponse'] credentials: Account credentials.
        :param str endpoint: Azure cloud endpoint for the storage account.
        :param str protocol: Protocol used to communicate with the storage account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "contents_type", 'AzureDataLakeGen2')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen2'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class AzureFileContentsResponse(dict):
    """
    Azure File datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "contentsType":
            suggest = "contents_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: str,
                 container_name: str,
                 contents_type: str,
                 credentials: Any,
                 endpoint: str,
                 protocol: str):
        """
        Azure File datastore configuration.
        :param str account_name: Storage account name.
        :param str container_name: Storage account container name.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureFile'.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse', 'SqlAdminDatastoreCredentialsResponse'] credentials: Account credentials.
        :param str endpoint: Azure cloud endpoint for the storage account.
        :param str protocol: Protocol used to communicate with the storage account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "contents_type", 'AzureFile')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        Storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureFile'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class AzurePostgreSqlContentsResponse(dict):
    """
    Azure Postgre SQL datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentsType":
            suggest = "contents_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "portNumber":
            suggest = "port_number"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "enableSSL":
            suggest = "enable_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzurePostgreSqlContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzurePostgreSqlContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzurePostgreSqlContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contents_type: str,
                 credentials: Any,
                 database_name: str,
                 endpoint: str,
                 port_number: int,
                 server_name: str,
                 enable_ssl: Optional[bool] = None):
        """
        Azure Postgre SQL datastore configuration.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzurePostgreSql'.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse', 'SqlAdminDatastoreCredentialsResponse'] credentials: Account credentials.
        :param str database_name: Azure SQL database name.
        :param str endpoint: Azure cloud endpoint for the database.
        :param int port_number: Azure SQL server port.
        :param str server_name: Azure SQL server name.
        :param bool enable_ssl: Whether the Azure PostgreSQL server requires SSL.
        """
        pulumi.set(__self__, "contents_type", 'AzurePostgreSql')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "port_number", port_number)
        pulumi.set(__self__, "server_name", server_name)
        if enable_ssl is not None:
            pulumi.set(__self__, "enable_ssl", enable_ssl)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzurePostgreSql'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Azure cloud endpoint for the database.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> int:
        """
        Azure SQL server port.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        Azure SQL server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter(name="enableSSL")
    def enable_ssl(self) -> Optional[bool]:
        """
        Whether the Azure PostgreSQL server requires SSL.
        """
        return pulumi.get(self, "enable_ssl")


@pulumi.output_type
class AzureSqlDatabaseContentsResponse(dict):
    """
    Azure SQL Database datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentsType":
            suggest = "contents_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "portNumber":
            suggest = "port_number"
        elif key == "serverName":
            suggest = "server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureSqlDatabaseContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureSqlDatabaseContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureSqlDatabaseContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contents_type: str,
                 credentials: Any,
                 database_name: str,
                 endpoint: str,
                 port_number: int,
                 server_name: str):
        """
        Azure SQL Database datastore configuration.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'AzureSqlDatabase'.
        :param Union['AccountKeyDatastoreCredentialsResponse', 'CertificateDatastoreCredentialsResponse', 'NoneDatastoreCredentialsResponse', 'SasDatastoreCredentialsResponse', 'ServicePrincipalDatastoreCredentialsResponse', 'SqlAdminDatastoreCredentialsResponse'] credentials: Account credentials.
        :param str database_name: Azure SQL database name.
        :param str endpoint: Azure cloud endpoint for the database.
        :param int port_number: Azure SQL server port.
        :param str server_name: Azure SQL server name.
        """
        pulumi.set(__self__, "contents_type", 'AzureSqlDatabase')
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "port_number", port_number)
        pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureSqlDatabase'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter
    def credentials(self) -> Any:
        """
        Account credentials.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        Azure SQL database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        Azure cloud endpoint for the database.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> int:
        """
        Azure SQL server port.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> str:
        """
        Azure SQL server name.
        """
        return pulumi.get(self, "server_name")


@pulumi.output_type
class BanditPolicyResponse(dict):
    """
    Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "slackAmount":
            suggest = "slack_amount"
        elif key == "slackFactor":
            suggest = "slack_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BanditPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BanditPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BanditPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None,
                 slack_amount: Optional[float] = None,
                 slack_factor: Optional[float] = None):
        """
        Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation.
        :param str policy_type: 
               Expected value is 'Bandit'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        :param float slack_amount: Absolute distance allowed from the best performing run.
        :param float slack_factor: Ratio of the allowed distance from the best performing run.
        """
        pulumi.set(__self__, "policy_type", 'Bandit')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if slack_amount is not None:
            pulumi.set(__self__, "slack_amount", slack_amount)
        if slack_factor is not None:
            pulumi.set(__self__, "slack_factor", slack_factor)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'Bandit'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="slackAmount")
    def slack_amount(self) -> Optional[float]:
        """
        Absolute distance allowed from the best performing run.
        """
        return pulumi.get(self, "slack_amount")

    @property
    @pulumi.getter(name="slackFactor")
    def slack_factor(self) -> Optional[float]:
        """
        Ratio of the allowed distance from the best performing run.
        """
        return pulumi.get(self, "slack_factor")


@pulumi.output_type
class BatchDeploymentResponse(dict):
    """
    Batch inference settings per deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "errorThreshold":
            suggest = "error_threshold"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "miniBatchSize":
            suggest = "mini_batch_size"
        elif key == "outputConfiguration":
            suggest = "output_configuration"
        elif key == "partitionKeys":
            suggest = "partition_keys"
        elif key == "retrySettings":
            suggest = "retry_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 compute: Optional['outputs.ComputeConfigurationResponse'] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 error_threshold: Optional[int] = None,
                 logging_level: Optional[str] = None,
                 mini_batch_size: Optional[float] = None,
                 model: Optional[Any] = None,
                 output_configuration: Optional['outputs.BatchOutputConfigurationResponse'] = None,
                 partition_keys: Optional[Sequence[str]] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 retry_settings: Optional['outputs.BatchRetrySettingsResponse'] = None):
        """
        Batch inference settings per deployment.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param 'ComputeConfigurationResponse' compute: Configuration for compute binding.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param int error_threshold: Error threshold, if the error count for the entire input goes above this value,
               the batch inference will be aborted. Range is [-1, int.MaxValue].
               For FileDataset, this value is the count of file failures.
               For TabularDataset, this value is the count of record failures.
               If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :param str logging_level: Logging level for batch inference operation.
        :param float mini_batch_size: Size of the mini-batch passed to each batch invocation.
               For FileDataset, this is the number of files per mini-batch.
               For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param 'BatchOutputConfigurationResponse' output_configuration: Output configuration for the batch inference operation.
        :param Sequence[str] partition_keys: Partition keys list used for Named partitioning.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'BatchRetrySettingsResponse' retry_settings: Retry Settings for the batch inference operation.
        """
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if mini_batch_size is not None:
            pulumi.set(__self__, "mini_batch_size", mini_batch_size)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if output_configuration is not None:
            pulumi.set(__self__, "output_configuration", output_configuration)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if retry_settings is not None:
            pulumi.set(__self__, "retry_settings", retry_settings)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter
    def compute(self) -> Optional['outputs.ComputeConfigurationResponse']:
        """
        Configuration for compute binding.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[int]:
        """
        Error threshold, if the error count for the entire input goes above this value,
        the batch inference will be aborted. Range is [-1, int.MaxValue].
        For FileDataset, this value is the count of file failures.
        For TabularDataset, this value is the count of record failures.
        If set to -1 (the lower bound), all failures during batch inference will be ignored.
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[str]:
        """
        Logging level for batch inference operation.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="miniBatchSize")
    def mini_batch_size(self) -> Optional[float]:
        """
        Size of the mini-batch passed to each batch invocation.
        For FileDataset, this is the number of files per mini-batch.
        For TabularDataset, this is the size of the records in bytes, per mini-batch.
        """
        return pulumi.get(self, "mini_batch_size")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="outputConfiguration")
    def output_configuration(self) -> Optional['outputs.BatchOutputConfigurationResponse']:
        """
        Output configuration for the batch inference operation.
        """
        return pulumi.get(self, "output_configuration")

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[Sequence[str]]:
        """
        Partition keys list used for Named partitioning.
        """
        return pulumi.get(self, "partition_keys")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="retrySettings")
    def retry_settings(self) -> Optional['outputs.BatchRetrySettingsResponse']:
        """
        Retry Settings for the batch inference operation.
        """
        return pulumi.get(self, "retry_settings")


@pulumi.output_type
class BatchEndpointResponse(dict):
    """
    Batch endpoint configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"
        elif key == "authMode":
            suggest = "auth_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scoring_uri: str,
                 swagger_uri: str,
                 auth_mode: Optional[str] = None,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 traffic: Optional[Mapping[str, int]] = None):
        """
        Batch endpoint configuration.
        :param str scoring_uri: Endpoint URI.
        :param str swagger_uri: Endpoint Swagger URI.
        :param str auth_mode: Enum to determine endpoint authentication mode.
        :param str description: Description of the inference endpoint.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param Mapping[str, int] traffic: Traffic rules on how the traffic will be routed across deployments.
        """
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        Endpoint URI.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        Endpoint Swagger URI.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[str]:
        """
        Enum to determine endpoint authentication mode.
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Mapping[str, int]]:
        """
        Traffic rules on how the traffic will be routed across deployments.
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class BatchOutputConfigurationResponse(dict):
    """
    Batch inference output configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appendRowFileName":
            suggest = "append_row_file_name"
        elif key == "outputAction":
            suggest = "output_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOutputConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOutputConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOutputConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 append_row_file_name: Optional[str] = None,
                 output_action: Optional[str] = None):
        """
        Batch inference output configuration.
        :param str append_row_file_name: Customized output file name for append_row output action.
        :param str output_action: Indicates how the output will be organized.
        """
        if append_row_file_name is not None:
            pulumi.set(__self__, "append_row_file_name", append_row_file_name)
        if output_action is not None:
            pulumi.set(__self__, "output_action", output_action)

    @property
    @pulumi.getter(name="appendRowFileName")
    def append_row_file_name(self) -> Optional[str]:
        """
        Customized output file name for append_row output action.
        """
        return pulumi.get(self, "append_row_file_name")

    @property
    @pulumi.getter(name="outputAction")
    def output_action(self) -> Optional[str]:
        """
        Indicates how the output will be organized.
        """
        return pulumi.get(self, "output_action")


@pulumi.output_type
class BatchRetrySettingsResponse(dict):
    """
    Retry settings for a batch inference operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetries":
            suggest = "max_retries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchRetrySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchRetrySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchRetrySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_retries: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Retry settings for a batch inference operation.
        :param int max_retries: Maximum retry count for a mini-batch
        :param str timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[int]:
        """
        Maximum retry count for a mini-batch
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class CertificateDatastoreCredentialsResponse(dict):
    """
    Certificate datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "credentialsType":
            suggest = "credentials_type"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "authorityUrl":
            suggest = "authority_url"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 credentials_type: str,
                 tenant_id: str,
                 thumbprint: str,
                 authority_url: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        Certificate datastore credentials configuration.
        :param str client_id: Service principal client ID.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Certificate'.
        :param str tenant_id: ID of the tenant to which the service principal belongs.
        :param str thumbprint: Thumbprint of the certificate used for authentication.
        :param str authority_url: Authority URL used for authentication.
        :param str resource_uri: Resource the service principal has access to.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'Certificate')
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "thumbprint", thumbprint)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Certificate'.
        """
        return pulumi.get(self, "credentials_type")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        Thumbprint of the certificate used for authentication.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class CodeConfigurationResponse(dict):
    """
    Configuration for a scoring code asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scoringScript":
            suggest = "scoring_script"
        elif key == "codeId":
            suggest = "code_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scoring_script: str,
                 code_id: Optional[str] = None):
        """
        Configuration for a scoring code asset.
        :param str scoring_script: The script to execute on startup. eg. "score.py"
        :param str code_id: ARM resource ID of the code asset.
        """
        pulumi.set(__self__, "scoring_script", scoring_script)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)

    @property
    @pulumi.getter(name="scoringScript")
    def scoring_script(self) -> str:
        """
        The script to execute on startup. eg. "score.py"
        """
        return pulumi.get(self, "scoring_script")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")


@pulumi.output_type
class CodeContainerResponse(dict):
    """
    Container for code asset versions.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for code asset versions.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class CodeVersionResponse(dict):
    """
    Code asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CodeVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CodeVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CodeVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 datastore_id: Optional[str] = None,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Code asset version details.
        :param str path: The path of the file/directory in the datastore.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class CommandJobResponse(dict):
    """
    Command job definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interactionEndpoints":
            suggest = "interaction_endpoints"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "codeId":
            suggest = "code_id"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "inputDataBindings":
            suggest = "input_data_bindings"
        elif key == "outputDataBindings":
            suggest = "output_data_bindings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: str,
                 compute: 'outputs.ComputeConfigurationResponse',
                 interaction_endpoints: Mapping[str, 'outputs.JobEndpointResponse'],
                 job_type: str,
                 output: 'outputs.JobOutputResponse',
                 parameters: Any,
                 provisioning_state: str,
                 status: str,
                 code_id: Optional[str] = None,
                 description: Optional[str] = None,
                 distribution: Optional[Any] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 input_data_bindings: Optional[Mapping[str, 'outputs.InputDataBindingResponse']] = None,
                 output_data_bindings: Optional[Mapping[str, 'outputs.OutputDataBindingResponse']] = None,
                 priority: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 timeout: Optional[str] = None):
        """
        Command job definition.
        :param str command: The command to execute on startup of the job. eg. "python train.py"
        :param 'ComputeConfigurationResponse' compute: Compute binding for the job.
        :param Mapping[str, 'JobEndpointResponse'] interaction_endpoints: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Command'.
        :param 'JobOutputResponse' output: Location of the job output logs and artifacts.
        :param Any parameters: Input parameters.
        :param str provisioning_state: Specifies the job provisioning state.
        :param str status: Status of the job.
        :param str code_id: ARM resource ID of the code asset.
        :param str description: The asset description text.
        :param Union['MpiResponse', 'PyTorchResponse', 'TensorFlowResponse'] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param str environment_id: The ARM resource ID of the Environment specification for the job.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, or null.
               Defaults to AmlToken if null.
        :param Mapping[str, 'InputDataBindingResponse'] input_data_bindings: Mapping of input data bindings used in the job.
        :param Mapping[str, 'OutputDataBindingResponse'] output_data_bindings: Mapping of output data bindings used in the job.
        :param int priority: Job priority for scheduling policy. Only applies to AMLCompute.
               Private preview feature and only available to users on the allow list.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        :param str timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "interaction_endpoints", interaction_endpoints)
        pulumi.set(__self__, "job_type", 'Command')
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if input_data_bindings is not None:
            pulumi.set(__self__, "input_data_bindings", input_data_bindings)
        if output_data_bindings is not None:
            pulumi.set(__self__, "output_data_bindings", output_data_bindings)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def compute(self) -> 'outputs.ComputeConfigurationResponse':
        """
        Compute binding for the job.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter(name="interactionEndpoints")
    def interaction_endpoints(self) -> Mapping[str, 'outputs.JobEndpointResponse']:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "interaction_endpoints")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.JobOutputResponse':
        """
        Location of the job output logs and artifacts.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def parameters(self) -> Any:
        """
        Input parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Specifies the job provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distribution(self) -> Optional[Any]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="inputDataBindings")
    def input_data_bindings(self) -> Optional[Mapping[str, 'outputs.InputDataBindingResponse']]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "input_data_bindings")

    @property
    @pulumi.getter(name="outputDataBindings")
    def output_data_bindings(self) -> Optional[Mapping[str, 'outputs.OutputDataBindingResponse']]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "output_data_bindings")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Job priority for scheduling policy. Only applies to AMLCompute.
        Private preview feature and only available to users on the allow list.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ComputeConfigurationResponse(dict):
    """
    Configuration for compute binding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "isLocal":
            suggest = "is_local"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: Optional[int] = None,
                 instance_type: Optional[str] = None,
                 is_local: Optional[bool] = None,
                 location: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 target: Optional[str] = None):
        """
        Configuration for compute binding.
        :param int instance_count: Number of instances or nodes.
        :param str instance_type: SKU type to run on.
        :param bool is_local: Set to true for jobs running on local compute.
        :param str location: Location for virtual cluster run.
        :param Mapping[str, str] properties: Additional properties.
        :param str target: ARM resource ID of the compute resource.
        """
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if is_local is not None:
            pulumi.set(__self__, "is_local", is_local)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Number of instances or nodes.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        SKU type to run on.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> Optional[bool]:
        """
        Set to true for jobs running on local compute.
        """
        return pulumi.get(self, "is_local")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location for virtual cluster run.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Additional properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ComputeInstanceApplicationResponse(dict):
    """
    Defines an Aml Instance application and its connectivity endpoint URI.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "endpointUri":
            suggest = "endpoint_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 endpoint_uri: Optional[str] = None):
        """
        Defines an Aml Instance application and its connectivity endpoint URI.
        :param str display_name: Name of the ComputeInstance application.
        :param str endpoint_uri: Application' endpoint URI.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Name of the ComputeInstance application.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[str]:
        """
        Application' endpoint URI.
        """
        return pulumi.get(self, "endpoint_uri")


@pulumi.output_type
class ComputeInstanceConnectivityEndpointsResponse(dict):
    """
    Defines all connectivity endpoints and properties for an ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIpAddress":
            suggest = "private_ip_address"
        elif key == "publicIpAddress":
            suggest = "public_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceConnectivityEndpointsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceConnectivityEndpointsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceConnectivityEndpointsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_ip_address: str,
                 public_ip_address: str):
        """
        Defines all connectivity endpoints and properties for an ComputeInstance.
        :param str private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
        :param str public_ip_address: Public IP Address of this ComputeInstance.
        """
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP Address of this ComputeInstance.
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class ComputeInstanceCreatedByResponse(dict):
    """
    Describes information on user who created this ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userId":
            suggest = "user_id"
        elif key == "userName":
            suggest = "user_name"
        elif key == "userOrgId":
            suggest = "user_org_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceCreatedByResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceCreatedByResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceCreatedByResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_id: str,
                 user_name: str,
                 user_org_id: str):
        """
        Describes information on user who created this ComputeInstance.
        :param str user_id: Uniquely identifies the user within his/her organization.
        :param str user_name: Name of the user.
        :param str user_org_id: Uniquely identifies user' Azure Active Directory organization.
        """
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_org_id", user_org_id)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        Uniquely identifies the user within his/her organization.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Name of the user.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userOrgId")
    def user_org_id(self) -> str:
        """
        Uniquely identifies user' Azure Active Directory organization.
        """
        return pulumi.get(self, "user_org_id")


@pulumi.output_type
class ComputeInstanceLastOperationResponse(dict):
    """
    The last operation on ComputeInstance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationName":
            suggest = "operation_name"
        elif key == "operationStatus":
            suggest = "operation_status"
        elif key == "operationTime":
            suggest = "operation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceLastOperationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceLastOperationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceLastOperationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_name: Optional[str] = None,
                 operation_status: Optional[str] = None,
                 operation_time: Optional[str] = None):
        """
        The last operation on ComputeInstance.
        :param str operation_name: Name of the last operation.
        :param str operation_status: Operation status.
        :param str operation_time: Time of the last operation.
        """
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if operation_status is not None:
            pulumi.set(__self__, "operation_status", operation_status)
        if operation_time is not None:
            pulumi.set(__self__, "operation_time", operation_time)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[str]:
        """
        Name of the last operation.
        """
        return pulumi.get(self, "operation_name")

    @property
    @pulumi.getter(name="operationStatus")
    def operation_status(self) -> Optional[str]:
        """
        Operation status.
        """
        return pulumi.get(self, "operation_status")

    @property
    @pulumi.getter(name="operationTime")
    def operation_time(self) -> Optional[str]:
        """
        Time of the last operation.
        """
        return pulumi.get(self, "operation_time")


@pulumi.output_type
class ComputeInstanceResponse(dict):
    """
    An Azure Machine Learning compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.ComputeInstanceResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        An Azure Machine Learning compute instance.
        :param str compute_type: The type of compute
               Expected value is 'ComputeInstance'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'ComputeInstanceResponseProperties' properties: Compute Instance properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'ComputeInstance')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'ComputeInstance'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ComputeInstanceResponseProperties']:
        """
        Compute Instance properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ComputeInstanceResponseProperties(dict):
    """
    Compute Instance properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectivityEndpoints":
            suggest = "connectivity_endpoints"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "lastOperation":
            suggest = "last_operation"
        elif key == "applicationSharingPolicy":
            suggest = "application_sharing_policy"
        elif key == "computeInstanceAuthorizationType":
            suggest = "compute_instance_authorization_type"
        elif key == "enableNodePublicIp":
            suggest = "enable_node_public_ip"
        elif key == "personalComputeInstanceSettings":
            suggest = "personal_compute_instance_settings"
        elif key == "setupScripts":
            suggest = "setup_scripts"
        elif key == "sshSettings":
            suggest = "ssh_settings"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 applications: Sequence['outputs.ComputeInstanceApplicationResponse'],
                 connectivity_endpoints: 'outputs.ComputeInstanceConnectivityEndpointsResponse',
                 created_by: 'outputs.ComputeInstanceCreatedByResponse',
                 errors: Sequence['outputs.ErrorResponseResponse'],
                 last_operation: 'outputs.ComputeInstanceLastOperationResponse',
                 state: str,
                 application_sharing_policy: Optional[str] = None,
                 compute_instance_authorization_type: Optional[str] = None,
                 enable_node_public_ip: Optional[bool] = None,
                 personal_compute_instance_settings: Optional['outputs.PersonalComputeInstanceSettingsResponse'] = None,
                 schedules: Optional['outputs.ComputeSchedulesResponse'] = None,
                 setup_scripts: Optional['outputs.SetupScriptsResponse'] = None,
                 ssh_settings: Optional['outputs.ComputeInstanceSshSettingsResponse'] = None,
                 subnet: Optional['outputs.ResourceIdResponse'] = None,
                 vm_size: Optional[str] = None):
        """
        Compute Instance properties
        :param Sequence['ComputeInstanceApplicationResponse'] applications: Describes available applications and their endpoints on this ComputeInstance.
        :param 'ComputeInstanceConnectivityEndpointsResponse' connectivity_endpoints: Describes all connectivity endpoints available for this ComputeInstance.
        :param 'ComputeInstanceCreatedByResponse' created_by: Describes information on user who created this ComputeInstance.
        :param Sequence['ErrorResponseResponse'] errors: Collection of errors encountered on this ComputeInstance.
        :param 'ComputeInstanceLastOperationResponse' last_operation: The last operation on ComputeInstance.
        :param str state: The current state of this ComputeInstance.
        :param str application_sharing_policy: Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        :param str compute_instance_authorization_type: The Compute Instance Authorization type. Available values are personal (default).
        :param bool enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param 'PersonalComputeInstanceSettingsResponse' personal_compute_instance_settings: Settings for a personal compute instance.
        :param 'ComputeSchedulesResponse' schedules: The list of schedules to be applied on the compute instance.
        :param 'SetupScriptsResponse' setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :param 'ComputeInstanceSshSettingsResponse' ssh_settings: Specifies policy and settings for SSH access.
        :param 'ResourceIdResponse' subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param str vm_size: Virtual Machine Size
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "connectivity_endpoints", connectivity_endpoints)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "errors", errors)
        pulumi.set(__self__, "last_operation", last_operation)
        pulumi.set(__self__, "state", state)
        if application_sharing_policy is None:
            application_sharing_policy = 'Shared'
        if application_sharing_policy is not None:
            pulumi.set(__self__, "application_sharing_policy", application_sharing_policy)
        if compute_instance_authorization_type is None:
            compute_instance_authorization_type = 'personal'
        if compute_instance_authorization_type is not None:
            pulumi.set(__self__, "compute_instance_authorization_type", compute_instance_authorization_type)
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if personal_compute_instance_settings is not None:
            pulumi.set(__self__, "personal_compute_instance_settings", personal_compute_instance_settings)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if setup_scripts is not None:
            pulumi.set(__self__, "setup_scripts", setup_scripts)
        if ssh_settings is not None:
            pulumi.set(__self__, "ssh_settings", ssh_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.ComputeInstanceApplicationResponse']:
        """
        Describes available applications and their endpoints on this ComputeInstance.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="connectivityEndpoints")
    def connectivity_endpoints(self) -> 'outputs.ComputeInstanceConnectivityEndpointsResponse':
        """
        Describes all connectivity endpoints available for this ComputeInstance.
        """
        return pulumi.get(self, "connectivity_endpoints")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> 'outputs.ComputeInstanceCreatedByResponse':
        """
        Describes information on user who created this ComputeInstance.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Collection of errors encountered on this ComputeInstance.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="lastOperation")
    def last_operation(self) -> 'outputs.ComputeInstanceLastOperationResponse':
        """
        The last operation on ComputeInstance.
        """
        return pulumi.get(self, "last_operation")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of this ComputeInstance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="applicationSharingPolicy")
    def application_sharing_policy(self) -> Optional[str]:
        """
        Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        """
        return pulumi.get(self, "application_sharing_policy")

    @property
    @pulumi.getter(name="computeInstanceAuthorizationType")
    def compute_instance_authorization_type(self) -> Optional[str]:
        """
        The Compute Instance Authorization type. Available values are personal (default).
        """
        return pulumi.get(self, "compute_instance_authorization_type")

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[bool]:
        """
        Enable or disable node public IP address provisioning. Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @property
    @pulumi.getter(name="personalComputeInstanceSettings")
    def personal_compute_instance_settings(self) -> Optional['outputs.PersonalComputeInstanceSettingsResponse']:
        """
        Settings for a personal compute instance.
        """
        return pulumi.get(self, "personal_compute_instance_settings")

    @property
    @pulumi.getter
    def schedules(self) -> Optional['outputs.ComputeSchedulesResponse']:
        """
        The list of schedules to be applied on the compute instance.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter(name="setupScripts")
    def setup_scripts(self) -> Optional['outputs.SetupScriptsResponse']:
        """
        Details of customized scripts to execute for setting up the cluster.
        """
        return pulumi.get(self, "setup_scripts")

    @property
    @pulumi.getter(name="sshSettings")
    def ssh_settings(self) -> Optional['outputs.ComputeInstanceSshSettingsResponse']:
        """
        Specifies policy and settings for SSH access.
        """
        return pulumi.get(self, "ssh_settings")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.ResourceIdResponse']:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class ComputeInstanceSshSettingsResponse(dict):
    """
    Specifies policy and settings for SSH access.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "adminPublicKey":
            suggest = "admin_public_key"
        elif key == "sshPublicAccess":
            suggest = "ssh_public_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceSshSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceSshSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceSshSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 ssh_port: int,
                 admin_public_key: Optional[str] = None,
                 ssh_public_access: Optional[str] = None):
        """
        Specifies policy and settings for SSH access.
        :param str admin_user_name: Describes the admin user name.
        :param int ssh_port: Describes the port for connecting through SSH.
        :param str admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param str ssh_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        pulumi.set(__self__, "ssh_port", ssh_port)
        if admin_public_key is not None:
            pulumi.set(__self__, "admin_public_key", admin_public_key)
        if ssh_public_access is None:
            ssh_public_access = 'Disabled'
        if ssh_public_access is not None:
            pulumi.set(__self__, "ssh_public_access", ssh_public_access)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Describes the admin user name.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> int:
        """
        Describes the port for connecting through SSH.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="adminPublicKey")
    def admin_public_key(self) -> Optional[str]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "admin_public_key")

    @property
    @pulumi.getter(name="sshPublicAccess")
    def ssh_public_access(self) -> Optional[str]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        return pulumi.get(self, "ssh_public_access")


@pulumi.output_type
class ComputeSchedulesResponse(dict):
    """
    The list of schedules to be applied on the computes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeStartStop":
            suggest = "compute_start_stop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeSchedulesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeSchedulesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeSchedulesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_start_stop: Optional[Sequence['outputs.ComputeStartStopScheduleResponse']] = None):
        """
        The list of schedules to be applied on the computes
        :param Sequence['ComputeStartStopScheduleResponse'] compute_start_stop: The list of compute start stop schedules to be applied.
        """
        if compute_start_stop is not None:
            pulumi.set(__self__, "compute_start_stop", compute_start_stop)

    @property
    @pulumi.getter(name="computeStartStop")
    def compute_start_stop(self) -> Optional[Sequence['outputs.ComputeStartStopScheduleResponse']]:
        """
        The list of compute start stop schedules to be applied.
        """
        return pulumi.get(self, "compute_start_stop")


@pulumi.output_type
class ComputeStartStopScheduleResponse(dict):
    """
    Compute start stop schedule properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningStatus":
            suggest = "provisioning_status"
        elif key == "triggerType":
            suggest = "trigger_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeStartStopScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeStartStopScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeStartStopScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 provisioning_status: str,
                 action: Optional[str] = None,
                 cron: Optional['outputs.CronResponse'] = None,
                 recurrence: Optional['outputs.RecurrenceResponse'] = None,
                 status: Optional[str] = None,
                 trigger_type: Optional[str] = None):
        """
        Compute start stop schedule properties
        :param str id: Schedule id.
        :param str provisioning_status: The current deployment state of schedule.
        :param str action: The compute power action.
        :param 'CronResponse' cron: The workflow trigger cron for ComputeStartStop schedule type.
        :param 'RecurrenceResponse' recurrence: The workflow trigger recurrence for ComputeStartStop schedule type.
        :param str status: The schedule status.
        :param str trigger_type: The schedule trigger type.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provisioning_status", provisioning_status)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_type is not None:
            pulumi.set(__self__, "trigger_type", trigger_type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Schedule id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> str:
        """
        The current deployment state of schedule.
        """
        return pulumi.get(self, "provisioning_status")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The compute power action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def cron(self) -> Optional['outputs.CronResponse']:
        """
        The workflow trigger cron for ComputeStartStop schedule type.
        """
        return pulumi.get(self, "cron")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.RecurrenceResponse']:
        """
        The workflow trigger recurrence for ComputeStartStop schedule type.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The schedule status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> Optional[str]:
        """
        The schedule trigger type.
        """
        return pulumi.get(self, "trigger_type")


@pulumi.output_type
class ContainerResourceRequirementsResponse(dict):
    """
    The resource requirements for the container (cpu and memory).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuLimit":
            suggest = "cpu_limit"
        elif key == "memoryInGB":
            suggest = "memory_in_gb"
        elif key == "memoryInGBLimit":
            suggest = "memory_in_gb_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResourceRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResourceRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResourceRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[float] = None,
                 cpu_limit: Optional[float] = None,
                 fpga: Optional[int] = None,
                 gpu: Optional[int] = None,
                 memory_in_gb: Optional[float] = None,
                 memory_in_gb_limit: Optional[float] = None):
        """
        The resource requirements for the container (cpu and memory).
        :param float cpu: The minimum amount of CPU cores to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param float cpu_limit: The maximum amount of CPU cores allowed to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param int fpga: The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        :param int gpu: The number of GPU cores in the container.
        :param float memory_in_gb: The minimum amount of memory (in GB) to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param float memory_in_gb_limit: The maximum amount of memory (in GB) allowed to be used by the container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if fpga is not None:
            pulumi.set(__self__, "fpga", fpga)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if memory_in_gb is not None:
            pulumi.set(__self__, "memory_in_gb", memory_in_gb)
        if memory_in_gb_limit is not None:
            pulumi.set(__self__, "memory_in_gb_limit", memory_in_gb_limit)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        The minimum amount of CPU cores to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[float]:
        """
        The maximum amount of CPU cores allowed to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter
    def fpga(self) -> Optional[int]:
        """
        The number of FPGA PCIE devices exposed to the container. Must be multiple of 2.
        """
        return pulumi.get(self, "fpga")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[int]:
        """
        The number of GPU cores in the container.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter(name="memoryInGB")
    def memory_in_gb(self) -> Optional[float]:
        """
        The minimum amount of memory (in GB) to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory_in_gb")

    @property
    @pulumi.getter(name="memoryInGBLimit")
    def memory_in_gb_limit(self) -> Optional[float]:
        """
        The maximum amount of memory (in GB) allowed to be used by the container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory_in_gb_limit")


@pulumi.output_type
class CosmosDbSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectionsThroughput":
            suggest = "collections_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CosmosDbSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CosmosDbSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CosmosDbSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collections_throughput: Optional[int] = None):
        """
        :param int collections_throughput: The throughput of the collections in cosmosdb database
        """
        if collections_throughput is not None:
            pulumi.set(__self__, "collections_throughput", collections_throughput)

    @property
    @pulumi.getter(name="collectionsThroughput")
    def collections_throughput(self) -> Optional[int]:
        """
        The throughput of the collections in cosmosdb database
        """
        return pulumi.get(self, "collections_throughput")


@pulumi.output_type
class CronResponse(dict):
    """
    The workflow trigger cron for ComputeStartStop schedule type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CronResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CronResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CronResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: Optional[str] = None,
                 start_time: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        The workflow trigger cron for ComputeStartStop schedule type.
        :param str expression: The cron expression.
        :param str start_time: The start time.
        :param str time_zone: The time zone.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def expression(self) -> Optional[str]:
        """
        The cron expression.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time zone.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class DataContainerResponse(dict):
    """
    Container for data asset versions.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for data asset versions.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DataFactoryResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataFactoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataFactoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponse(dict):
    """
    A DataLakeAnalytics compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.DataLakeAnalyticsResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataLakeAnalytics compute.
        :param str compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DataLakeAnalyticsResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DataLakeAnalyticsResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakeStoreAccountName":
            suggest = "data_lake_store_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataLakeAnalyticsResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataLakeAnalyticsResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataLakeAnalyticsResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[str] = None):
        """
        :param str data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[str]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")


@pulumi.output_type
class DataPathAssetReferenceResponse(dict):
    """
    Reference to an asset via its path in a datastore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "datastoreId":
            suggest = "datastore_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataPathAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataPathAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataPathAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: str,
                 datastore_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Reference to an asset via its path in a datastore.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'DataPath'.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str path: The path of the file/directory in the datastore.
        """
        pulumi.set(__self__, "reference_type", 'DataPath')
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'DataPath'.
        """
        return pulumi.get(self, "reference_type")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DataVersionResponse(dict):
    """
    Data asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datastoreId":
            suggest = "datastore_id"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 dataset_type: Optional[str] = None,
                 datastore_id: Optional[str] = None,
                 description: Optional[str] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Data asset version details.
        :param str path: The path of the file/directory in the datastore.
        :param str dataset_type: The Format of dataset.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str description: The asset description text.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if dataset_type is not None:
            pulumi.set(__self__, "dataset_type", dataset_type)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> Optional[str]:
        """
        The Format of dataset.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DatabricksResponse(dict):
    """
    A DataFactory compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.DatabricksResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A DataFactory compute.
        :param str compute_type: The type of compute
               Expected value is 'Databricks'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.DatabricksResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class DatabricksResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databricksAccessToken":
            suggest = "databricks_access_token"
        elif key == "workspaceUrl":
            suggest = "workspace_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabricksResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabricksResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabricksResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 databricks_access_token: Optional[str] = None,
                 workspace_url: Optional[str] = None):
        """
        :param str databricks_access_token: Databricks access token
        :param str workspace_url: Workspace Url
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[str]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[str]:
        """
        Workspace Url
        """
        return pulumi.get(self, "workspace_url")


@pulumi.output_type
class DatastorePropertiesResponse(dict):
    """
    Datastore definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hasBeenValidated":
            suggest = "has_been_validated"
        elif key == "isDefault":
            suggest = "is_default"
        elif key == "linkedInfo":
            suggest = "linked_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastorePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastorePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastorePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contents: Any,
                 has_been_validated: bool,
                 description: Optional[str] = None,
                 is_default: Optional[bool] = None,
                 linked_info: Optional['outputs.LinkedInfoResponse'] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Datastore definition.
        :param Union['AzureBlobContentsResponse', 'AzureDataLakeGen1ContentsResponse', 'AzureDataLakeGen2ContentsResponse', 'AzureFileContentsResponse', 'AzurePostgreSqlContentsResponse', 'AzureSqlDatabaseContentsResponse', 'GlusterFsContentsResponse'] contents: Reference to the datastore storage contents.
        :param bool has_been_validated: Whether the service has validated access to the datastore with the provided credentials.
        :param str description: The asset description text.
        :param bool is_default: Whether this datastore is the default for the workspace.
        :param 'LinkedInfoResponse' linked_info: Information about the datastore origin, if linked.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "contents", contents)
        pulumi.set(__self__, "has_been_validated", has_been_validated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if linked_info is not None:
            pulumi.set(__self__, "linked_info", linked_info)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def contents(self) -> Any:
        """
        Reference to the datastore storage contents.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter(name="hasBeenValidated")
    def has_been_validated(self) -> bool:
        """
        Whether the service has validated access to the datastore with the provided credentials.
        """
        return pulumi.get(self, "has_been_validated")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Whether this datastore is the default for the workspace.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="linkedInfo")
    def linked_info(self) -> Optional['outputs.LinkedInfoResponse']:
        """
        Information about the datastore origin, if linked.
        """
        return pulumi.get(self, "linked_info")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DockerBuildResponse(dict):
    """
    Class to represent configuration settings for Docker Build
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerSpecificationType":
            suggest = "docker_specification_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerBuildResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerBuildResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerBuildResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_specification_type: str,
                 dockerfile: str,
                 context: Optional[str] = None,
                 platform: Optional['outputs.DockerImagePlatformResponse'] = None):
        """
        Class to represent configuration settings for Docker Build
        :param str docker_specification_type: Enum to determine docker specification type. Must be either Build or Image.
               Expected value is 'Build'.
        :param str dockerfile: Docker command line instructions to assemble an image.
               <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
        :param str context: Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
               The path is relative to the asset path which must contain a single Blob URI value.
               <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
        :param 'DockerImagePlatformResponse' platform: The platform information of the docker image.
        """
        pulumi.set(__self__, "docker_specification_type", 'Build')
        pulumi.set(__self__, "dockerfile", dockerfile)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="dockerSpecificationType")
    def docker_specification_type(self) -> str:
        """
        Enum to determine docker specification type. Must be either Build or Image.
        Expected value is 'Build'.
        """
        return pulumi.get(self, "docker_specification_type")

    @property
    @pulumi.getter
    def dockerfile(self) -> str:
        """
        Docker command line instructions to assemble an image.
        <seealso href="https://repo2docker.readthedocs.io/en/latest/config_files.html#dockerfile-advanced-environments" />
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Path to a snapshot of the Docker Context. This property is only valid if Dockerfile is specified.
        The path is relative to the asset path which must contain a single Blob URI value.
        <seealso href="https://docs.docker.com/engine/context/working-with-contexts/" />
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter
    def platform(self) -> Optional['outputs.DockerImagePlatformResponse']:
        """
        The platform information of the docker image.
        """
        return pulumi.get(self, "platform")


@pulumi.output_type
class DockerImagePlatformResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatingSystemType":
            suggest = "operating_system_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerImagePlatformResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerImagePlatformResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerImagePlatformResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operating_system_type: Optional[str] = None):
        """
        :param str operating_system_type: The OS type the Environment.
        """
        if operating_system_type is not None:
            pulumi.set(__self__, "operating_system_type", operating_system_type)

    @property
    @pulumi.getter(name="operatingSystemType")
    def operating_system_type(self) -> Optional[str]:
        """
        The OS type the Environment.
        """
        return pulumi.get(self, "operating_system_type")


@pulumi.output_type
class DockerImageResponse(dict):
    """
    Class to represent configuration settings for Docker Build
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerImageUri":
            suggest = "docker_image_uri"
        elif key == "dockerSpecificationType":
            suggest = "docker_specification_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DockerImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DockerImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DockerImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_image_uri: str,
                 docker_specification_type: str,
                 platform: Optional['outputs.DockerImagePlatformResponse'] = None):
        """
        Class to represent configuration settings for Docker Build
        :param str docker_image_uri: Image name of a custom base image.
               <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        :param str docker_specification_type: Enum to determine docker specification type. Must be either Build or Image.
               Expected value is 'Image'.
        :param 'DockerImagePlatformResponse' platform: The platform information of the docker image.
        """
        pulumi.set(__self__, "docker_image_uri", docker_image_uri)
        pulumi.set(__self__, "docker_specification_type", 'Image')
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="dockerImageUri")
    def docker_image_uri(self) -> str:
        """
        Image name of a custom base image.
        <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        """
        return pulumi.get(self, "docker_image_uri")

    @property
    @pulumi.getter(name="dockerSpecificationType")
    def docker_specification_type(self) -> str:
        """
        Enum to determine docker specification type. Must be either Build or Image.
        Expected value is 'Image'.
        """
        return pulumi.get(self, "docker_specification_type")

    @property
    @pulumi.getter
    def platform(self) -> Optional['outputs.DockerImagePlatformResponse']:
        """
        The platform information of the docker image.
        """
        return pulumi.get(self, "platform")


@pulumi.output_type
class EncryptionPropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_properties: 'outputs.KeyVaultPropertiesResponse',
                 status: str,
                 identity: Optional['outputs.IdentityForCmkResponse'] = None):
        """
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Customer Key vault properties.
        :param str status: Indicates whether or not the encryption is enabled for the workspace.
        :param 'IdentityForCmkResponse' identity: The identity that will be used to access the key vault for encryption at rest.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> 'outputs.KeyVaultPropertiesResponse':
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.IdentityForCmkResponse']:
        """
        The identity that will be used to access the key vault for encryption at rest.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class EnvironmentContainerResponse(dict):
    """
    Container for environment specification versions.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Container for environment specification versions.
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class EnvironmentSpecificationVersionResponse(dict):
    """
    Environment specification version details.
    <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentSpecificationType":
            suggest = "environment_specification_type"
        elif key == "condaFile":
            suggest = "conda_file"
        elif key == "inferenceContainerProperties":
            suggest = "inference_container_properties"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentSpecificationVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentSpecificationVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentSpecificationVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_specification_type: str,
                 conda_file: Optional[str] = None,
                 description: Optional[str] = None,
                 docker: Optional[Any] = None,
                 inference_container_properties: Optional['outputs.InferenceContainerPropertiesResponse'] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Environment specification version details.
        <see href="https://repo2docker.readthedocs.io/en/latest/specification.html" />
        :param str environment_specification_type: Environment specification is either user managed or curated by the Azure ML service
               <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
        :param str conda_file: Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
               <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        :param str description: The asset description text.
        :param Union['DockerBuildResponse', 'DockerImageResponse'] docker: Configuration settings for Docker.
        :param 'InferenceContainerPropertiesResponse' inference_container_properties: Defines configuration specific to inference.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "environment_specification_type", environment_specification_type)
        if conda_file is not None:
            pulumi.set(__self__, "conda_file", conda_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if inference_container_properties is not None:
            pulumi.set(__self__, "inference_container_properties", inference_container_properties)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="environmentSpecificationType")
    def environment_specification_type(self) -> str:
        """
        Environment specification is either user managed or curated by the Azure ML service
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/resource-curated-environments" />
        """
        return pulumi.get(self, "environment_specification_type")

    @property
    @pulumi.getter(name="condaFile")
    def conda_file(self) -> Optional[str]:
        """
        Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
        <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        """
        return pulumi.get(self, "conda_file")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def docker(self) -> Optional[Any]:
        """
        Configuration settings for Docker.
        """
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter(name="inferenceContainerProperties")
    def inference_container_properties(self) -> Optional['outputs.InferenceContainerPropertiesResponse']:
        """
        Defines configuration specific to inference.
        """
        return pulumi.get(self, "inference_container_properties")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ErrorAdditionalInfoResponse(dict):
    """
    The resource management error additional info.
    """
    def __init__(__self__, *,
                 info: Any,
                 type: str):
        """
        The resource management error additional info.
        :param Any info: The additional info.
        :param str type: The additional info type.
        """
        pulumi.set(__self__, "info", info)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def info(self) -> Any:
        """
        The additional info.
        """
        return pulumi.get(self, "info")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The additional info type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ErrorDetailResponse(dict):
    """
    The error detail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalInfo":
            suggest = "additional_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_info: Sequence['outputs.ErrorAdditionalInfoResponse'],
                 code: str,
                 details: Sequence['outputs.ErrorDetailResponse'],
                 message: str,
                 target: str):
        """
        The error detail.
        :param Sequence['ErrorAdditionalInfoResponse'] additional_info: The error additional info.
        :param str code: The error code.
        :param Sequence['ErrorDetailResponse'] details: The error details.
        :param str message: The error message.
        :param str target: The error target.
        """
        pulumi.set(__self__, "additional_info", additional_info)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Sequence['outputs.ErrorAdditionalInfoResponse']:
        """
        The error additional info.
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDetailResponse']:
        """
        The error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ErrorResponseResponse(dict):
    """
    Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
    """
    def __init__(__self__, *,
                 error: Optional['outputs.ErrorDetailResponse'] = None):
        """
        Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
        :param 'ErrorDetailResponse' error: The error object.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorDetailResponse']:
        """
        The error object.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class FlavorDataResponse(dict):
    def __init__(__self__, *,
                 data: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] data: Model flavor-specific data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, str]]:
        """
        Model flavor-specific data.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class GlusterFsContentsResponse(dict):
    """
    GlusterFs datastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentsType":
            suggest = "contents_type"
        elif key == "serverAddress":
            suggest = "server_address"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlusterFsContentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlusterFsContentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlusterFsContentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contents_type: str,
                 server_address: str,
                 volume_name: str):
        """
        GlusterFs datastore configuration.
        :param str contents_type: Enum to determine the datastore contents type.
               Expected value is 'GlusterFs'.
        :param str server_address: GlusterFS server address (can be the IP address or server name).
        :param str volume_name: GlusterFS volume name.
        """
        pulumi.set(__self__, "contents_type", 'GlusterFs')
        pulumi.set(__self__, "server_address", server_address)
        pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="contentsType")
    def contents_type(self) -> str:
        """
        Enum to determine the datastore contents type.
        Expected value is 'GlusterFs'.
        """
        return pulumi.get(self, "contents_type")

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> str:
        """
        GlusterFS server address (can be the IP address or server name).
        """
        return pulumi.get(self, "server_address")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> str:
        """
        GlusterFS volume name.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class HDInsightResponse(dict):
    """
    A HDInsight compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.HDInsightResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A HDInsight compute.
        :param str compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.HDInsightResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class HDInsightResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "sshPort":
            suggest = "ssh_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HDInsightResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HDInsightResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 ssh_port: Optional[int] = None):
        """
        :param str address: Public IP address of the master node of the cluster.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for master node of the cluster
        :param int ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")


@pulumi.output_type
class IdAssetReferenceResponse(dict):
    """
    Reference to an asset via its ARM resource ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetId":
            suggest = "asset_id"
        elif key == "referenceType":
            suggest = "reference_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_id: str,
                 reference_type: str):
        """
        Reference to an asset via its ARM resource ID.
        :param str asset_id: ARM resource ID of the asset.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'Id'.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "reference_type", 'Id')

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> str:
        """
        ARM resource ID of the asset.
        """
        return pulumi.get(self, "asset_id")

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'Id'.
        """
        return pulumi.get(self, "reference_type")


@pulumi.output_type
class IdentityForCmkResponse(dict):
    """
    Identity that will be used to access key vault for encryption at rest
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityForCmkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityForCmkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityForCmkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity: Optional[str] = None):
        """
        Identity that will be used to access key vault for encryption at rest
        :param str user_assigned_identity: The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The user assigned identities associated with the resource.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The user assigned identities associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class InferenceContainerPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "livenessRoute":
            suggest = "liveness_route"
        elif key == "readinessRoute":
            suggest = "readiness_route"
        elif key == "scoringRoute":
            suggest = "scoring_route"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceContainerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceContainerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceContainerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 liveness_route: Optional['outputs.RouteResponse'] = None,
                 readiness_route: Optional['outputs.RouteResponse'] = None,
                 scoring_route: Optional['outputs.RouteResponse'] = None):
        """
        :param 'RouteResponse' liveness_route: The route to check the liveness of the inference server container.
        :param 'RouteResponse' readiness_route: The route to check the readiness of the inference server container.
        :param 'RouteResponse' scoring_route: The port to send the scoring requests to, within the inference server container.
        """
        if liveness_route is not None:
            pulumi.set(__self__, "liveness_route", liveness_route)
        if readiness_route is not None:
            pulumi.set(__self__, "readiness_route", readiness_route)
        if scoring_route is not None:
            pulumi.set(__self__, "scoring_route", scoring_route)

    @property
    @pulumi.getter(name="livenessRoute")
    def liveness_route(self) -> Optional['outputs.RouteResponse']:
        """
        The route to check the liveness of the inference server container.
        """
        return pulumi.get(self, "liveness_route")

    @property
    @pulumi.getter(name="readinessRoute")
    def readiness_route(self) -> Optional['outputs.RouteResponse']:
        """
        The route to check the readiness of the inference server container.
        """
        return pulumi.get(self, "readiness_route")

    @property
    @pulumi.getter(name="scoringRoute")
    def scoring_route(self) -> Optional['outputs.RouteResponse']:
        """
        The port to send the scoring requests to, within the inference server container.
        """
        return pulumi.get(self, "scoring_route")


@pulumi.output_type
class InputDataBindingResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataId":
            suggest = "data_id"
        elif key == "pathOnCompute":
            suggest = "path_on_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InputDataBindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InputDataBindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InputDataBindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_id: Optional[str] = None,
                 mode: Optional[str] = None,
                 path_on_compute: Optional[str] = None):
        """
        :param str data_id: ARM resource ID of the registered dataVersion.
        :param str mode: Mechanism for accessing the data artifact.
        :param str path_on_compute: Location of data inside the container process.
        """
        if data_id is not None:
            pulumi.set(__self__, "data_id", data_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path_on_compute is not None:
            pulumi.set(__self__, "path_on_compute", path_on_compute)

    @property
    @pulumi.getter(name="dataId")
    def data_id(self) -> Optional[str]:
        """
        ARM resource ID of the registered dataVersion.
        """
        return pulumi.get(self, "data_id")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Mechanism for accessing the data artifact.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="pathOnCompute")
    def path_on_compute(self) -> Optional[str]:
        """
        Location of data inside the container process.
        """
        return pulumi.get(self, "path_on_compute")


@pulumi.output_type
class JobEndpointResponse(dict):
    """
    Job endpoint definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobEndpointType":
            suggest = "job_endpoint_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: Optional[str] = None,
                 job_endpoint_type: Optional[str] = None,
                 port: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None):
        """
        Job endpoint definition
        :param str endpoint: Url for endpoint.
        :param str job_endpoint_type: Endpoint type.
        :param int port: Port for endpoint.
        :param Mapping[str, str] properties: Additional properties to set on the endpoint.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if job_endpoint_type is not None:
            pulumi.set(__self__, "job_endpoint_type", job_endpoint_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Url for endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="jobEndpointType")
    def job_endpoint_type(self) -> Optional[str]:
        """
        Endpoint type.
        """
        return pulumi.get(self, "job_endpoint_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Port for endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Additional properties to set on the endpoint.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class JobOutputResponse(dict):
    """
    Job output definition container information on where to find job output/logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datastore_id: str,
                 path: str):
        """
        Job output definition container information on where to find job output/logs.
        :param str datastore_id: ARM ID of the datastore where the job logs and artifacts are stored, or null for the default container ("azureml") in the workspace's storage account.
        :param str path: Path within the datastore to the job logs and artifacts.
        """
        pulumi.set(__self__, "datastore_id", datastore_id)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> str:
        """
        ARM ID of the datastore where the job logs and artifacts are stored, or null for the default container ("azureml") in the workspace's storage account.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path within the datastore to the job logs and artifacts.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class K8sOnlineDeploymentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointComputeType":
            suggest = "endpoint_compute_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "containerResourceRequirements":
            suggest = "container_resource_requirements"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "requestSettings":
            suggest = "request_settings"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K8sOnlineDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K8sOnlineDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K8sOnlineDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_compute_type: str,
                 provisioning_state: str,
                 app_insights_enabled: Optional[bool] = None,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 container_resource_requirements: Optional['outputs.ContainerResourceRequirementsResponse'] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 liveness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 model: Optional[Any] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 request_settings: Optional['outputs.OnlineRequestSettingsResponse'] = None,
                 scale_settings: Optional[Any] = None):
        """
        :param str endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'K8S'.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param bool app_insights_enabled: If true, enables Application Insights logging.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param 'ContainerResourceRequirementsResponse' container_resource_requirements: Resource requirements for each container instance within an online deployment.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param 'ProbeSettingsResponse' liveness_probe: Deployment container liveness/readiness probe configuration.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'OnlineRequestSettingsResponse' request_settings: Online deployment scoring requests configuration.
        :param Union['AutoScaleSettingsResponse', 'ManualScaleSettingsResponse'] scale_settings: Online deployment scaling configuration.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'K8S')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> str:
        """
        Enum to determine endpoint compute type.
        Expected value is 'K8S'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional['outputs.ContainerResourceRequirementsResponse']:
        """
        Resource requirements for each container instance within an online deployment.
        """
        return pulumi.get(self, "container_resource_requirements")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional['outputs.OnlineRequestSettingsResponse']:
        """
        Online deployment scoring requests configuration.
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[Any]:
        """
        Online deployment scaling configuration.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyIdentifier":
            suggest = "key_identifier"
        elif key == "keyVaultArmId":
            suggest = "key_vault_arm_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_identifier: str,
                 key_vault_arm_id: str,
                 identity_client_id: Optional[str] = None):
        """
        :param str key_identifier: Key vault uri to access the encryption key.
        :param str key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param str identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> str:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> str:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[str]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class LabelCategoryResponse(dict):
    """
    Label category definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMultiSelect":
            suggest = "allow_multi_select"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelCategoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelCategoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelCategoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_multi_select: Optional[bool] = None,
                 classes: Optional[Mapping[str, 'outputs.LabelClassResponse']] = None,
                 display_name: Optional[str] = None):
        """
        Label category definition
        :param bool allow_multi_select: Indicates whether it is allowed to select multiple classes in this category.
        :param Mapping[str, 'LabelClassResponse'] classes: Dictionary of label classes in this category.
        :param str display_name: Display name of the label category.
        """
        if allow_multi_select is not None:
            pulumi.set(__self__, "allow_multi_select", allow_multi_select)
        if classes is not None:
            pulumi.set(__self__, "classes", classes)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="allowMultiSelect")
    def allow_multi_select(self) -> Optional[bool]:
        """
        Indicates whether it is allowed to select multiple classes in this category.
        """
        return pulumi.get(self, "allow_multi_select")

    @property
    @pulumi.getter
    def classes(self) -> Optional[Mapping[str, 'outputs.LabelClassResponse']]:
        """
        Dictionary of label classes in this category.
        """
        return pulumi.get(self, "classes")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the label category.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class LabelClassResponse(dict):
    """
    Label class definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelClassResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelClassResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelClassResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 subclasses: Optional[Mapping[str, 'outputs.LabelClassResponse']] = None):
        """
        Label class definition
        :param str display_name: Display name of the label class.
        :param Mapping[str, 'LabelClassResponse'] subclasses: Dictionary of subclasses of the label class.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if subclasses is not None:
            pulumi.set(__self__, "subclasses", subclasses)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the label class.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def subclasses(self) -> Optional[Mapping[str, 'outputs.LabelClassResponse']]:
        """
        Dictionary of subclasses of the label class.
        """
        return pulumi.get(self, "subclasses")


@pulumi.output_type
class LabelingDatasetConfigurationResponse(dict):
    """
    Labeling dataset configuration definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assetName":
            suggest = "asset_name"
        elif key == "datasetVersion":
            suggest = "dataset_version"
        elif key == "incrementalDatasetRefreshEnabled":
            suggest = "incremental_dataset_refresh_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingDatasetConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingDatasetConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingDatasetConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asset_name: Optional[str] = None,
                 dataset_version: Optional[str] = None,
                 incremental_dataset_refresh_enabled: Optional[bool] = None):
        """
        Labeling dataset configuration definition
        :param str asset_name: Name of the data asset to perform labeling.
        :param str dataset_version: AML dataset version.
        :param bool incremental_dataset_refresh_enabled: Indicates whether to enable incremental dataset refresh.
        """
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if dataset_version is not None:
            pulumi.set(__self__, "dataset_version", dataset_version)
        if incremental_dataset_refresh_enabled is not None:
            pulumi.set(__self__, "incremental_dataset_refresh_enabled", incremental_dataset_refresh_enabled)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[str]:
        """
        Name of the data asset to perform labeling.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter(name="datasetVersion")
    def dataset_version(self) -> Optional[str]:
        """
        AML dataset version.
        """
        return pulumi.get(self, "dataset_version")

    @property
    @pulumi.getter(name="incrementalDatasetRefreshEnabled")
    def incremental_dataset_refresh_enabled(self) -> Optional[bool]:
        """
        Indicates whether to enable incremental dataset refresh.
        """
        return pulumi.get(self, "incremental_dataset_refresh_enabled")


@pulumi.output_type
class LabelingJobImagePropertiesResponse(dict):
    """
    Properties of a labeling job for image data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaType":
            suggest = "media_type"
        elif key == "annotationType":
            suggest = "annotation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingJobImagePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingJobImagePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingJobImagePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_type: str,
                 annotation_type: Optional[str] = None):
        """
        Properties of a labeling job for image data
        :param str media_type: Media type of data asset.
               Expected value is 'Image'.
        :param str annotation_type: Annotation type of image labeling job.
        """
        pulumi.set(__self__, "media_type", 'Image')
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> str:
        """
        Media type of data asset.
        Expected value is 'Image'.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[str]:
        """
        Annotation type of image labeling job.
        """
        return pulumi.get(self, "annotation_type")


@pulumi.output_type
class LabelingJobInstructionsResponse(dict):
    """
    Instructions for labeling job
    """
    def __init__(__self__, *,
                 uri: Optional[str] = None):
        """
        Instructions for labeling job
        :param str uri: The link to a page with detailed labeling instructions for labelers.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The link to a page with detailed labeling instructions for labelers.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class LabelingJobResponse(dict):
    """
    Labeling job definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimeUtc":
            suggest = "created_time_utc"
        elif key == "interactionEndpoints":
            suggest = "interaction_endpoints"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "progressMetrics":
            suggest = "progress_metrics"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "statusMessages":
            suggest = "status_messages"
        elif key == "datasetConfiguration":
            suggest = "dataset_configuration"
        elif key == "jobInstructions":
            suggest = "job_instructions"
        elif key == "labelCategories":
            suggest = "label_categories"
        elif key == "labelingJobMediaProperties":
            suggest = "labeling_job_media_properties"
        elif key == "mlAssistConfiguration":
            suggest = "ml_assist_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_time_utc: str,
                 interaction_endpoints: Mapping[str, 'outputs.JobEndpointResponse'],
                 job_type: str,
                 progress_metrics: 'outputs.ProgressMetricsResponse',
                 project_id: str,
                 provisioning_state: str,
                 status: str,
                 status_messages: Sequence['outputs.StatusMessageResponse'],
                 dataset_configuration: Optional['outputs.LabelingDatasetConfigurationResponse'] = None,
                 description: Optional[str] = None,
                 job_instructions: Optional['outputs.LabelingJobInstructionsResponse'] = None,
                 label_categories: Optional[Mapping[str, 'outputs.LabelCategoryResponse']] = None,
                 labeling_job_media_properties: Optional[Any] = None,
                 ml_assist_configuration: Optional['outputs.MLAssistConfigurationResponse'] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Labeling job definition
        :param str created_time_utc: Created time of the job in UTC timezone.
        :param Mapping[str, 'JobEndpointResponse'] interaction_endpoints: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param str job_type: Specifies the type of job. This field should always be set to "Labeling".
        :param 'ProgressMetricsResponse' progress_metrics: Progress metrics of the job.
        :param str project_id: Internal id of the job(Previously called project).
        :param str provisioning_state: Specifies the labeling job provisioning state.
        :param str status: Status of the job.
        :param Sequence['StatusMessageResponse'] status_messages: Status messages of the job.
        :param 'LabelingDatasetConfigurationResponse' dataset_configuration: Configuration of dataset used in the job.
        :param str description: The asset description text.
        :param 'LabelingJobInstructionsResponse' job_instructions: Labeling instructions of the job.
        :param Mapping[str, 'LabelCategoryResponse'] label_categories: Label categories of the job.
        :param Union['LabelingJobImagePropertiesResponse', 'LabelingJobTextPropertiesResponse'] labeling_job_media_properties: Media type specific properties in the job.
        :param 'MLAssistConfigurationResponse' ml_assist_configuration: Configuration of MLAssist feature in the job.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "created_time_utc", created_time_utc)
        pulumi.set(__self__, "interaction_endpoints", interaction_endpoints)
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "progress_metrics", progress_metrics)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_messages", status_messages)
        if dataset_configuration is not None:
            pulumi.set(__self__, "dataset_configuration", dataset_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if job_instructions is not None:
            pulumi.set(__self__, "job_instructions", job_instructions)
        if label_categories is not None:
            pulumi.set(__self__, "label_categories", label_categories)
        if labeling_job_media_properties is not None:
            pulumi.set(__self__, "labeling_job_media_properties", labeling_job_media_properties)
        if ml_assist_configuration is not None:
            pulumi.set(__self__, "ml_assist_configuration", ml_assist_configuration)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="createdTimeUtc")
    def created_time_utc(self) -> str:
        """
        Created time of the job in UTC timezone.
        """
        return pulumi.get(self, "created_time_utc")

    @property
    @pulumi.getter(name="interactionEndpoints")
    def interaction_endpoints(self) -> Mapping[str, 'outputs.JobEndpointResponse']:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "interaction_endpoints")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Specifies the type of job. This field should always be set to "Labeling".
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter(name="progressMetrics")
    def progress_metrics(self) -> 'outputs.ProgressMetricsResponse':
        """
        Progress metrics of the job.
        """
        return pulumi.get(self, "progress_metrics")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Internal id of the job(Previously called project).
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Specifies the labeling job provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessages")
    def status_messages(self) -> Sequence['outputs.StatusMessageResponse']:
        """
        Status messages of the job.
        """
        return pulumi.get(self, "status_messages")

    @property
    @pulumi.getter(name="datasetConfiguration")
    def dataset_configuration(self) -> Optional['outputs.LabelingDatasetConfigurationResponse']:
        """
        Configuration of dataset used in the job.
        """
        return pulumi.get(self, "dataset_configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="jobInstructions")
    def job_instructions(self) -> Optional['outputs.LabelingJobInstructionsResponse']:
        """
        Labeling instructions of the job.
        """
        return pulumi.get(self, "job_instructions")

    @property
    @pulumi.getter(name="labelCategories")
    def label_categories(self) -> Optional[Mapping[str, 'outputs.LabelCategoryResponse']]:
        """
        Label categories of the job.
        """
        return pulumi.get(self, "label_categories")

    @property
    @pulumi.getter(name="labelingJobMediaProperties")
    def labeling_job_media_properties(self) -> Optional[Any]:
        """
        Media type specific properties in the job.
        """
        return pulumi.get(self, "labeling_job_media_properties")

    @property
    @pulumi.getter(name="mlAssistConfiguration")
    def ml_assist_configuration(self) -> Optional['outputs.MLAssistConfigurationResponse']:
        """
        Configuration of MLAssist feature in the job.
        """
        return pulumi.get(self, "ml_assist_configuration")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class LabelingJobTextPropertiesResponse(dict):
    """
    Properties of a labeling job for text data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaType":
            suggest = "media_type"
        elif key == "annotationType":
            suggest = "annotation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LabelingJobTextPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LabelingJobTextPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LabelingJobTextPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_type: str,
                 annotation_type: Optional[str] = None):
        """
        Properties of a labeling job for text data
        :param str media_type: Media type of data asset.
               Expected value is 'Text'.
        :param str annotation_type: Annotation type of text labeling job.
        """
        pulumi.set(__self__, "media_type", 'Text')
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> str:
        """
        Media type of data asset.
        Expected value is 'Text'.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[str]:
        """
        Annotation type of text labeling job.
        """
        return pulumi.get(self, "annotation_type")


@pulumi.output_type
class LinkedInfoResponse(dict):
    """
    Information about a datastore origin, if linked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linkedId":
            suggest = "linked_id"
        elif key == "linkedResourceName":
            suggest = "linked_resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linked_id: Optional[str] = None,
                 linked_resource_name: Optional[str] = None,
                 origin: Optional[str] = None):
        """
        Information about a datastore origin, if linked.
        :param str linked_id: Linked service ID.
        :param str linked_resource_name: Linked service resource name.
        :param str origin: Type of the linked service.
        """
        if linked_id is not None:
            pulumi.set(__self__, "linked_id", linked_id)
        if linked_resource_name is not None:
            pulumi.set(__self__, "linked_resource_name", linked_resource_name)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)

    @property
    @pulumi.getter(name="linkedId")
    def linked_id(self) -> Optional[str]:
        """
        Linked service ID.
        """
        return pulumi.get(self, "linked_id")

    @property
    @pulumi.getter(name="linkedResourceName")
    def linked_resource_name(self) -> Optional[str]:
        """
        Linked service resource name.
        """
        return pulumi.get(self, "linked_resource_name")

    @property
    @pulumi.getter
    def origin(self) -> Optional[str]:
        """
        Type of the linked service.
        """
        return pulumi.get(self, "origin")


@pulumi.output_type
class ListNotebookKeysResultResponse(dict):
    def __init__(__self__, *,
                 primary_access_key: str,
                 secondary_access_key: str):
        pulumi.set(__self__, "primary_access_key", primary_access_key)
        pulumi.set(__self__, "secondary_access_key", secondary_access_key)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> str:
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> str:
        return pulumi.get(self, "secondary_access_key")


@pulumi.output_type
class MLAssistConfigurationResponse(dict):
    """
    Labeling MLAssist configuration definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inferencingComputeBinding":
            suggest = "inferencing_compute_binding"
        elif key == "mlAssistEnabled":
            suggest = "ml_assist_enabled"
        elif key == "trainingComputeBinding":
            suggest = "training_compute_binding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MLAssistConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MLAssistConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MLAssistConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inferencing_compute_binding: Optional['outputs.ComputeConfigurationResponse'] = None,
                 ml_assist_enabled: Optional[bool] = None,
                 training_compute_binding: Optional['outputs.ComputeConfigurationResponse'] = None):
        """
        Labeling MLAssist configuration definition
        :param 'ComputeConfigurationResponse' inferencing_compute_binding: AML compute binding used in inferencing.
        :param bool ml_assist_enabled: Indicates whether MLAssist feature is enabled.
        :param 'ComputeConfigurationResponse' training_compute_binding: AML compute binding used in training.
        """
        if inferencing_compute_binding is not None:
            pulumi.set(__self__, "inferencing_compute_binding", inferencing_compute_binding)
        if ml_assist_enabled is not None:
            pulumi.set(__self__, "ml_assist_enabled", ml_assist_enabled)
        if training_compute_binding is not None:
            pulumi.set(__self__, "training_compute_binding", training_compute_binding)

    @property
    @pulumi.getter(name="inferencingComputeBinding")
    def inferencing_compute_binding(self) -> Optional['outputs.ComputeConfigurationResponse']:
        """
        AML compute binding used in inferencing.
        """
        return pulumi.get(self, "inferencing_compute_binding")

    @property
    @pulumi.getter(name="mlAssistEnabled")
    def ml_assist_enabled(self) -> Optional[bool]:
        """
        Indicates whether MLAssist feature is enabled.
        """
        return pulumi.get(self, "ml_assist_enabled")

    @property
    @pulumi.getter(name="trainingComputeBinding")
    def training_compute_binding(self) -> Optional['outputs.ComputeConfigurationResponse']:
        """
        AML compute binding used in training.
        """
        return pulumi.get(self, "training_compute_binding")


@pulumi.output_type
class ManagedIdentityResponse(dict):
    """
    Managed identity configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: str,
                 client_id: Optional[str] = None,
                 object_id: Optional[str] = None,
                 resource_id: Optional[str] = None):
        """
        Managed identity configuration.
        :param str identity_type: Enum to determine identity framework.
               Expected value is 'Managed'.
        :param str client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        :param str object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        :param str resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        pulumi.set(__self__, "identity_type", 'Managed')
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> str:
        """
        Enum to determine identity framework.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ManagedOnlineDeploymentResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointComputeType":
            suggest = "endpoint_compute_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "appInsightsEnabled":
            suggest = "app_insights_enabled"
        elif key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "requestSettings":
            suggest = "request_settings"
        elif key == "scaleSettings":
            suggest = "scale_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedOnlineDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedOnlineDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedOnlineDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_compute_type: str,
                 provisioning_state: str,
                 app_insights_enabled: Optional[bool] = None,
                 code_configuration: Optional['outputs.CodeConfigurationResponse'] = None,
                 description: Optional[str] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 instance_type: Optional[str] = None,
                 liveness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 model: Optional[Any] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 readiness_probe: Optional['outputs.ProbeSettingsResponse'] = None,
                 request_settings: Optional['outputs.OnlineRequestSettingsResponse'] = None,
                 scale_settings: Optional[Any] = None):
        """
        :param str endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Managed'.
        :param str provisioning_state: Provisioning state for the endpoint deployment.
        :param bool app_insights_enabled: If true, enables Application Insights logging.
        :param 'CodeConfigurationResponse' code_configuration: Code configuration for the endpoint deployment.
        :param str description: Description of the endpoint deployment.
        :param str environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param Mapping[str, str] environment_variables: Environment variables configuration for the deployment.
        :param str instance_type: Compute instance type.
        :param 'ProbeSettingsResponse' liveness_probe: Deployment container liveness/readiness probe configuration.
        :param Union['DataPathAssetReferenceResponse', 'IdAssetReferenceResponse', 'OutputPathAssetReferenceResponse'] model: Reference to the model asset for the endpoint deployment.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param 'ProbeSettingsResponse' readiness_probe: Deployment container liveness/readiness probe configuration.
        :param 'OnlineRequestSettingsResponse' request_settings: Online deployment scoring requests configuration.
        :param Union['AutoScaleSettingsResponse', 'ManualScaleSettingsResponse'] scale_settings: Online deployment scaling configuration.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Managed')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> str:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state for the endpoint deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[bool]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.CodeConfigurationResponse']:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def model(self) -> Optional[Any]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.ProbeSettingsResponse']:
        """
        Deployment container liveness/readiness probe configuration.
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional['outputs.OnlineRequestSettingsResponse']:
        """
        Online deployment scoring requests configuration.
        """
        return pulumi.get(self, "request_settings")

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[Any]:
        """
        Online deployment scaling configuration.
        """
        return pulumi.get(self, "scale_settings")


@pulumi.output_type
class ManualScaleSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scaleType":
            suggest = "scale_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManualScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManualScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManualScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scale_type: str,
                 instance_count: Optional[int] = None,
                 max_instances: Optional[int] = None,
                 min_instances: Optional[int] = None):
        """
        :param str scale_type: 
               Expected value is 'Manual'.
        :param int instance_count: Fixed number of instances for this deployment.
        :param int max_instances: Maximum number of instances for this deployment.
        :param int min_instances: Minimum number of instances for this deployment.
        """
        pulumi.set(__self__, "scale_type", 'Manual')
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> str:
        """

        Expected value is 'Manual'.
        """
        return pulumi.get(self, "scale_type")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        Fixed number of instances for this deployment.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[int]:
        """
        Maximum number of instances for this deployment.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[int]:
        """
        Minimum number of instances for this deployment.
        """
        return pulumi.get(self, "min_instances")


@pulumi.output_type
class MedianStoppingPolicyResponse(dict):
    """
    Defines an early termination policy based on running averages of the primary metric of all runs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MedianStoppingPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MedianStoppingPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MedianStoppingPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None):
        """
        Defines an early termination policy based on running averages of the primary metric of all runs.
        :param str policy_type: 
               Expected value is 'MedianStopping'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        """
        pulumi.set(__self__, "policy_type", 'MedianStopping')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'MedianStopping'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")


@pulumi.output_type
class ModelContainerResponse(dict):
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param str description: The asset description text.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ModelVersionResponse(dict):
    """
    Model asset version details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"
        elif key == "isAnonymous":
            suggest = "is_anonymous"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 datastore_id: Optional[str] = None,
                 description: Optional[str] = None,
                 flavors: Optional[Mapping[str, 'outputs.FlavorDataResponse']] = None,
                 is_anonymous: Optional[bool] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        Model asset version details.
        :param str path: The path of the file/directory in the datastore.
        :param str datastore_id: ARM resource ID of the datastore where the asset is located.
        :param str description: The asset description text.
        :param Mapping[str, 'FlavorDataResponse'] flavors: Mapping of model flavors to their properties.
        :param bool is_anonymous: If the name version are system generated (anonymous registration).
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "path", path)
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def flavors(self) -> Optional[Mapping[str, 'outputs.FlavorDataResponse']]:
        """
        Mapping of model flavors to their properties.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[bool]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class MpiResponse(dict):
    """
    MPI distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "processCountPerInstance":
            suggest = "process_count_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MpiResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MpiResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MpiResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 process_count_per_instance: Optional[int] = None):
        """
        MPI distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'Mpi'.
        :param int process_count_per_instance: Number of processes per MPI node.
        """
        pulumi.set(__self__, "distribution_type", 'Mpi')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'Mpi'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[int]:
        """
        Number of processes per MPI node.
        """
        return pulumi.get(self, "process_count_per_instance")


@pulumi.output_type
class NodeStateCountsResponse(dict):
    """
    Counts of various compute node states on the amlCompute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleNodeCount":
            suggest = "idle_node_count"
        elif key == "leavingNodeCount":
            suggest = "leaving_node_count"
        elif key == "preemptedNodeCount":
            suggest = "preempted_node_count"
        elif key == "preparingNodeCount":
            suggest = "preparing_node_count"
        elif key == "runningNodeCount":
            suggest = "running_node_count"
        elif key == "unusableNodeCount":
            suggest = "unusable_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStateCountsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStateCountsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_node_count: int,
                 leaving_node_count: int,
                 preempted_node_count: int,
                 preparing_node_count: int,
                 running_node_count: int,
                 unusable_node_count: int):
        """
        Counts of various compute node states on the amlCompute.
        :param int idle_node_count: Number of compute nodes in idle state.
        :param int leaving_node_count: Number of compute nodes which are leaving the amlCompute.
        :param int preempted_node_count: Number of compute nodes which are in preempted state.
        :param int preparing_node_count: Number of compute nodes which are being prepared.
        :param int running_node_count: Number of compute nodes which are running jobs.
        :param int unusable_node_count: Number of compute nodes which are in unusable state.
        """
        pulumi.set(__self__, "idle_node_count", idle_node_count)
        pulumi.set(__self__, "leaving_node_count", leaving_node_count)
        pulumi.set(__self__, "preempted_node_count", preempted_node_count)
        pulumi.set(__self__, "preparing_node_count", preparing_node_count)
        pulumi.set(__self__, "running_node_count", running_node_count)
        pulumi.set(__self__, "unusable_node_count", unusable_node_count)

    @property
    @pulumi.getter(name="idleNodeCount")
    def idle_node_count(self) -> int:
        """
        Number of compute nodes in idle state.
        """
        return pulumi.get(self, "idle_node_count")

    @property
    @pulumi.getter(name="leavingNodeCount")
    def leaving_node_count(self) -> int:
        """
        Number of compute nodes which are leaving the amlCompute.
        """
        return pulumi.get(self, "leaving_node_count")

    @property
    @pulumi.getter(name="preemptedNodeCount")
    def preempted_node_count(self) -> int:
        """
        Number of compute nodes which are in preempted state.
        """
        return pulumi.get(self, "preempted_node_count")

    @property
    @pulumi.getter(name="preparingNodeCount")
    def preparing_node_count(self) -> int:
        """
        Number of compute nodes which are being prepared.
        """
        return pulumi.get(self, "preparing_node_count")

    @property
    @pulumi.getter(name="runningNodeCount")
    def running_node_count(self) -> int:
        """
        Number of compute nodes which are running jobs.
        """
        return pulumi.get(self, "running_node_count")

    @property
    @pulumi.getter(name="unusableNodeCount")
    def unusable_node_count(self) -> int:
        """
        Number of compute nodes which are in unusable state.
        """
        return pulumi.get(self, "unusable_node_count")


@pulumi.output_type
class NoneDatastoreCredentialsResponse(dict):
    """
    Empty/none datastore credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoneDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoneDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoneDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str):
        """
        Empty/none datastore credentials.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'None'.
        """
        pulumi.set(__self__, "credentials_type", 'None')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'None'.
        """
        return pulumi.get(self, "credentials_type")


@pulumi.output_type
class NotebookPreparationErrorResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookPreparationErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookPreparationErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookPreparationErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: Optional[str] = None,
                 status_code: Optional[int] = None):
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[int]:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class NotebookResourceInfoResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notebookPreparationError":
            suggest = "notebook_preparation_error"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotebookResourceInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotebookResourceInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotebookResourceInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 notebook_preparation_error: Optional['outputs.NotebookPreparationErrorResponse'] = None,
                 resource_id: Optional[str] = None):
        """
        :param 'NotebookPreparationErrorResponse' notebook_preparation_error: The error that occurs when preparing notebook.
        :param str resource_id: the data plane resourceId that used to initialize notebook component
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if notebook_preparation_error is not None:
            pulumi.set(__self__, "notebook_preparation_error", notebook_preparation_error)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="notebookPreparationError")
    def notebook_preparation_error(self) -> Optional['outputs.NotebookPreparationErrorResponse']:
        """
        The error that occurs when preparing notebook.
        """
        return pulumi.get(self, "notebook_preparation_error")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        the data plane resourceId that used to initialize notebook component
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class ObjectiveResponse(dict):
    """
    Optimization objective.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryMetric":
            suggest = "primary_metric"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectiveResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectiveResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectiveResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 goal: str,
                 primary_metric: str):
        """
        Optimization objective.
        :param str goal: Defines supported metric goals for hyperparameter tuning
        :param str primary_metric: Name of the metric to optimize.
        """
        pulumi.set(__self__, "goal", goal)
        pulumi.set(__self__, "primary_metric", primary_metric)

    @property
    @pulumi.getter
    def goal(self) -> str:
        """
        Defines supported metric goals for hyperparameter tuning
        """
        return pulumi.get(self, "goal")

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> str:
        """
        Name of the metric to optimize.
        """
        return pulumi.get(self, "primary_metric")


@pulumi.output_type
class OnlineEndpointResponse(dict):
    """
    Online endpoint configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authMode":
            suggest = "auth_mode"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "scoringUri":
            suggest = "scoring_uri"
        elif key == "swaggerUri":
            suggest = "swagger_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_mode: str,
                 provisioning_state: str,
                 scoring_uri: str,
                 swagger_uri: str,
                 description: Optional[str] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 target: Optional[str] = None,
                 traffic: Optional[Mapping[str, int]] = None):
        """
        Online endpoint configuration
        :param str auth_mode: Inference endpoint authentication mode type
        :param str provisioning_state: State of endpoint provisioning.
        :param str scoring_uri: Endpoint URI.
        :param str swagger_uri: Endpoint Swagger URI.
        :param str description: Description of the inference endpoint.
        :param Mapping[str, str] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param str target: ARM resource ID of the compute if it exists.
               optional
        :param Mapping[str, int] traffic: Traffic rules on how the traffic will be routed across deployments.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "scoring_uri", scoring_uri)
        pulumi.set(__self__, "swagger_uri", swagger_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> str:
        """
        Inference endpoint authentication mode type
        """
        return pulumi.get(self, "auth_mode")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        State of endpoint provisioning.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="scoringUri")
    def scoring_uri(self) -> str:
        """
        Endpoint URI.
        """
        return pulumi.get(self, "scoring_uri")

    @property
    @pulumi.getter(name="swaggerUri")
    def swagger_uri(self) -> str:
        """
        Endpoint Swagger URI.
        """
        return pulumi.get(self, "swagger_uri")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        ARM resource ID of the compute if it exists.
        optional
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Mapping[str, int]]:
        """
        Traffic rules on how the traffic will be routed across deployments.
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class OnlineRequestSettingsResponse(dict):
    """
    Online deployment scoring requests configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentRequestsPerInstance":
            suggest = "max_concurrent_requests_per_instance"
        elif key == "maxQueueWait":
            suggest = "max_queue_wait"
        elif key == "requestTimeout":
            suggest = "request_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnlineRequestSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnlineRequestSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnlineRequestSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_requests_per_instance: Optional[int] = None,
                 max_queue_wait: Optional[str] = None,
                 request_timeout: Optional[str] = None):
        """
        Online deployment scoring requests configuration.
        :param int max_concurrent_requests_per_instance: The number of requests allowed to queue at once for this deployment.
        :param str max_queue_wait: The maximum queue wait time in ISO 8601 format. Supports millisecond precision.
        :param str request_timeout: The request timeout in ISO 8601 format. Supports millisecond precision.
        """
        if max_concurrent_requests_per_instance is not None:
            pulumi.set(__self__, "max_concurrent_requests_per_instance", max_concurrent_requests_per_instance)
        if max_queue_wait is not None:
            pulumi.set(__self__, "max_queue_wait", max_queue_wait)
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)

    @property
    @pulumi.getter(name="maxConcurrentRequestsPerInstance")
    def max_concurrent_requests_per_instance(self) -> Optional[int]:
        """
        The number of requests allowed to queue at once for this deployment.
        """
        return pulumi.get(self, "max_concurrent_requests_per_instance")

    @property
    @pulumi.getter(name="maxQueueWait")
    def max_queue_wait(self) -> Optional[str]:
        """
        The maximum queue wait time in ISO 8601 format. Supports millisecond precision.
        """
        return pulumi.get(self, "max_queue_wait")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[str]:
        """
        The request timeout in ISO 8601 format. Supports millisecond precision.
        """
        return pulumi.get(self, "request_timeout")


@pulumi.output_type
class OutputDataBindingResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datastoreId":
            suggest = "datastore_id"
        elif key == "pathOnCompute":
            suggest = "path_on_compute"
        elif key == "pathOnDatastore":
            suggest = "path_on_datastore"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutputDataBindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutputDataBindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutputDataBindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datastore_id: Optional[str] = None,
                 mode: Optional[str] = None,
                 path_on_compute: Optional[str] = None,
                 path_on_datastore: Optional[str] = None):
        """
        :param str datastore_id: ARM resource ID of the datastore where the data output will be stored.
        :param str mode: Mechanism for data movement to datastore.
        :param str path_on_compute: Location of data inside the container process.
        :param str path_on_datastore: Path within the datastore to the data.
        """
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path_on_compute is not None:
            pulumi.set(__self__, "path_on_compute", path_on_compute)
        if path_on_datastore is not None:
            pulumi.set(__self__, "path_on_datastore", path_on_datastore)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[str]:
        """
        ARM resource ID of the datastore where the data output will be stored.
        """
        return pulumi.get(self, "datastore_id")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Mechanism for data movement to datastore.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="pathOnCompute")
    def path_on_compute(self) -> Optional[str]:
        """
        Location of data inside the container process.
        """
        return pulumi.get(self, "path_on_compute")

    @property
    @pulumi.getter(name="pathOnDatastore")
    def path_on_datastore(self) -> Optional[str]:
        """
        Path within the datastore to the data.
        """
        return pulumi.get(self, "path_on_datastore")


@pulumi.output_type
class OutputPathAssetReferenceResponse(dict):
    """
    Reference to an asset via its path in a job output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "referenceType":
            suggest = "reference_type"
        elif key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutputPathAssetReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutputPathAssetReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutputPathAssetReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 reference_type: str,
                 job_id: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Reference to an asset via its path in a job output.
        :param str reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'OutputPath'.
        :param str job_id: ARM resource ID of the job.
        :param str path: The path of the file/directory in the job output.
        """
        pulumi.set(__self__, "reference_type", 'OutputPath')
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> str:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'OutputPath'.
        """
        return pulumi.get(self, "reference_type")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[str]:
        """
        ARM resource ID of the job.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the file/directory in the job output.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class PasswordResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class PersonalComputeInstanceSettingsResponse(dict):
    """
    Settings for a personal compute instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedUser":
            suggest = "assigned_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersonalComputeInstanceSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersonalComputeInstanceSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersonalComputeInstanceSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_user: Optional['outputs.AssignedUserResponse'] = None):
        """
        Settings for a personal compute instance.
        :param 'AssignedUserResponse' assigned_user: A user explicitly assigned to a personal compute instance.
        """
        if assigned_user is not None:
            pulumi.set(__self__, "assigned_user", assigned_user)

    @property
    @pulumi.getter(name="assignedUser")
    def assigned_user(self) -> Optional['outputs.AssignedUserResponse']:
        """
        A user explicitly assigned to a personal compute instance.
        """
        return pulumi.get(self, "assigned_user")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 identity: Optional['outputs.IdentityResponse'] = None,
                 location: Optional[str] = None,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 sku: Optional['outputs.SkuResponse'] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Metadata pertaining to creation and last modification of the resource.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'IdentityResponse' identity: The identity of the resource.
        :param str location: Specifies the location of the resource.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        :param 'SkuResponse' sku: The sku of the workspace.
        :param Mapping[str, str] tags: Contains resource tags defined as key/value pairs.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.IdentityResponse']:
        """
        The identity of the resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Specifies the location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuResponse']:
        """
        The sku of the workspace.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Contains resource tags defined as key/value pairs.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetArmId":
            suggest = "subnet_arm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 subnet_arm_id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        :param str subnet_arm_id: The ARM identifier for Subnet resource that private endpoint links to
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "subnet_arm_id", subnet_arm_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subnetArmId")
    def subnet_arm_id(self) -> str:
        """
        The ARM identifier for Subnet resource that private endpoint links to
        """
        return pulumi.get(self, "subnet_arm_id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ProbeSettingsResponse(dict):
    """
    Deployment container liveness/readiness probe configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 initial_delay: Optional[str] = None,
                 period: Optional[str] = None,
                 success_threshold: Optional[int] = None,
                 timeout: Optional[str] = None):
        """
        Deployment container liveness/readiness probe configuration.
        :param int failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param str initial_delay: The delay before the first probe in ISO 8601 format.
        :param str period: The length of time between probes in ISO 8601 format.
        :param int success_threshold: The number of successful probes before returning a healthy status.
        :param str timeout: The probe timeout in ISO 8601 format.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[str]:
        """
        The delay before the first probe in ISO 8601 format.
        """
        return pulumi.get(self, "initial_delay")

    @property
    @pulumi.getter
    def period(self) -> Optional[str]:
        """
        The length of time between probes in ISO 8601 format.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The probe timeout in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ProgressMetricsResponse(dict):
    """
    Progress metrics definition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completedDatapointCount":
            suggest = "completed_datapoint_count"
        elif key == "incrementalDatasetLastRefreshTime":
            suggest = "incremental_dataset_last_refresh_time"
        elif key == "skippedDatapointCount":
            suggest = "skipped_datapoint_count"
        elif key == "totalDatapointCount":
            suggest = "total_datapoint_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProgressMetricsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProgressMetricsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProgressMetricsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completed_datapoint_count: float,
                 incremental_dataset_last_refresh_time: str,
                 skipped_datapoint_count: float,
                 total_datapoint_count: float):
        """
        Progress metrics definition
        :param float completed_datapoint_count: The completed datapoint count.
        :param str incremental_dataset_last_refresh_time: The time of last successful incremental dataset refresh in UTC.
        :param float skipped_datapoint_count: The skipped datapoint count.
        :param float total_datapoint_count: The total datapoint count.
        """
        pulumi.set(__self__, "completed_datapoint_count", completed_datapoint_count)
        pulumi.set(__self__, "incremental_dataset_last_refresh_time", incremental_dataset_last_refresh_time)
        pulumi.set(__self__, "skipped_datapoint_count", skipped_datapoint_count)
        pulumi.set(__self__, "total_datapoint_count", total_datapoint_count)

    @property
    @pulumi.getter(name="completedDatapointCount")
    def completed_datapoint_count(self) -> float:
        """
        The completed datapoint count.
        """
        return pulumi.get(self, "completed_datapoint_count")

    @property
    @pulumi.getter(name="incrementalDatasetLastRefreshTime")
    def incremental_dataset_last_refresh_time(self) -> str:
        """
        The time of last successful incremental dataset refresh in UTC.
        """
        return pulumi.get(self, "incremental_dataset_last_refresh_time")

    @property
    @pulumi.getter(name="skippedDatapointCount")
    def skipped_datapoint_count(self) -> float:
        """
        The skipped datapoint count.
        """
        return pulumi.get(self, "skipped_datapoint_count")

    @property
    @pulumi.getter(name="totalDatapointCount")
    def total_datapoint_count(self) -> float:
        """
        The total datapoint count.
        """
        return pulumi.get(self, "total_datapoint_count")


@pulumi.output_type
class PyTorchResponse(dict):
    """
    PyTorch distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "processCount":
            suggest = "process_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PyTorchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PyTorchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PyTorchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 process_count: Optional[int] = None):
        """
        PyTorch distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'PyTorch'.
        :param int process_count: Total process count for the distributed job.
        """
        pulumi.set(__self__, "distribution_type", 'PyTorch')
        if process_count is not None:
            pulumi.set(__self__, "process_count", process_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'PyTorch'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="processCount")
    def process_count(self) -> Optional[int]:
        """
        Total process count for the distributed job.
        """
        return pulumi.get(self, "process_count")


@pulumi.output_type
class RecurrenceResponse(dict):
    """
    The workflow trigger recurrence for ComputeStartStop schedule type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: Optional[str] = None,
                 interval: Optional[int] = None,
                 schedule: Optional['outputs.RecurrenceScheduleResponse'] = None,
                 start_time: Optional[str] = None,
                 time_zone: Optional[str] = None):
        """
        The workflow trigger recurrence for ComputeStartStop schedule type.
        :param str frequency: The recurrence frequency.
        :param int interval: The interval.
        :param 'RecurrenceScheduleResponse' schedule: The recurrence schedule
        :param str start_time: The start time.
        :param str time_zone: The time zone.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        The recurrence frequency.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The interval.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.RecurrenceScheduleResponse']:
        """
        The recurrence schedule
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        The time zone.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class RecurrenceScheduleResponse(dict):
    """
    The recurrence schedule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurrenceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurrenceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hours: Optional[Sequence[int]] = None,
                 minutes: Optional[Sequence[int]] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        The recurrence schedule
        :param Sequence[int] hours: The hours.
        :param Sequence[int] minutes: The minutes.
        :param Sequence[str] week_days: The days of the week.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[Sequence[int]]:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[Sequence[int]]:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        The days of the week.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class RegistryListCredentialsResultResponse(dict):
    def __init__(__self__, *,
                 location: str,
                 username: str,
                 passwords: Optional[Sequence['outputs.PasswordResponse']] = None):
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "username", username)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence['outputs.PasswordResponse']]:
        return pulumi.get(self, "passwords")


@pulumi.output_type
class ResourceIdResponse(dict):
    """
    Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
    """
    def __init__(__self__, *,
                 id: str):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param str id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    """
    Service identity associated with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityMetaResponse']] = None):
        """
        Service identity associated with a resource.
        :param str principal_id: Client ID that is used when authenticating.
        :param str tenant_id: AAD Tenant where this identity lives.
        :param str type: Defines values for a ResourceIdentity's type.
        :param Mapping[str, 'UserAssignedIdentityMetaResponse'] user_assigned_identities: Dictionary of the user assigned identities, key is ARM resource ID of the UAI.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Client ID that is used when authenticating.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        AAD Tenant where this identity lives.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Defines values for a ResourceIdentity's type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityMetaResponse']]:
        """
        Dictionary of the user assigned identities, key is ARM resource ID of the UAI.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class RouteResponse(dict):
    def __init__(__self__, *,
                 path: str,
                 port: int):
        """
        :param str path: The path for the route.
        :param int port: The port for the route.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path for the route.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port for the route.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class SasDatastoreCredentialsResponse(dict):
    """
    SAS datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SasDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SasDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SasDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str):
        """
        SAS datastore credentials configuration.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Sas'.
        """
        pulumi.set(__self__, "credentials_type", 'Sas')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "credentials_type")


@pulumi.output_type
class ScaleSettingsResponse(dict):
    """
    scale settings for AML Compute
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "nodeIdleTimeBeforeScaleDown":
            suggest = "node_idle_time_before_scale_down"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: Optional[int] = None,
                 node_idle_time_before_scale_down: Optional[str] = None):
        """
        scale settings for AML Compute
        :param int max_node_count: Max number of nodes to use
        :param int min_node_count: Min number of nodes to use
        :param str node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[int]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[str]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")


@pulumi.output_type
class ScriptReferenceResponse(dict):
    """
    Script reference
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptArguments":
            suggest = "script_arguments"
        elif key == "scriptData":
            suggest = "script_data"
        elif key == "scriptSource":
            suggest = "script_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_arguments: Optional[str] = None,
                 script_data: Optional[str] = None,
                 script_source: Optional[str] = None,
                 timeout: Optional[str] = None):
        """
        Script reference
        :param str script_arguments: Optional command line arguments passed to the script to run.
        :param str script_data: The location of scripts in the mounted volume.
        :param str script_source: The storage source of the script: inline, workspace.
        :param str timeout: Optional time period passed to timeout command.
        """
        if script_arguments is not None:
            pulumi.set(__self__, "script_arguments", script_arguments)
        if script_data is not None:
            pulumi.set(__self__, "script_data", script_data)
        if script_source is not None:
            pulumi.set(__self__, "script_source", script_source)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="scriptArguments")
    def script_arguments(self) -> Optional[str]:
        """
        Optional command line arguments passed to the script to run.
        """
        return pulumi.get(self, "script_arguments")

    @property
    @pulumi.getter(name="scriptData")
    def script_data(self) -> Optional[str]:
        """
        The location of scripts in the mounted volume.
        """
        return pulumi.get(self, "script_data")

    @property
    @pulumi.getter(name="scriptSource")
    def script_source(self) -> Optional[str]:
        """
        The storage source of the script: inline, workspace.
        """
        return pulumi.get(self, "script_source")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Optional time period passed to timeout command.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ScriptsToExecuteResponse(dict):
    """
    Customized setup scripts
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationScript":
            suggest = "creation_script"
        elif key == "startupScript":
            suggest = "startup_script"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptsToExecuteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptsToExecuteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptsToExecuteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_script: Optional['outputs.ScriptReferenceResponse'] = None,
                 startup_script: Optional['outputs.ScriptReferenceResponse'] = None):
        """
        Customized setup scripts
        :param 'ScriptReferenceResponse' creation_script: Script that's run only once during provision of the compute.
        :param 'ScriptReferenceResponse' startup_script: Script that's run every time the machine starts.
        """
        if creation_script is not None:
            pulumi.set(__self__, "creation_script", creation_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)

    @property
    @pulumi.getter(name="creationScript")
    def creation_script(self) -> Optional['outputs.ScriptReferenceResponse']:
        """
        Script that's run only once during provision of the compute.
        """
        return pulumi.get(self, "creation_script")

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional['outputs.ScriptReferenceResponse']:
        """
        Script that's run every time the machine starts.
        """
        return pulumi.get(self, "startup_script")


@pulumi.output_type
class ServiceManagedResourcesSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cosmosDb":
            suggest = "cosmos_db"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceManagedResourcesSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceManagedResourcesSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceManagedResourcesSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cosmos_db: Optional['outputs.CosmosDbSettingsResponse'] = None):
        """
        :param 'CosmosDbSettingsResponse' cosmos_db: The settings for the service managed cosmosdb account.
        """
        if cosmos_db is not None:
            pulumi.set(__self__, "cosmos_db", cosmos_db)

    @property
    @pulumi.getter(name="cosmosDb")
    def cosmos_db(self) -> Optional['outputs.CosmosDbSettingsResponse']:
        """
        The settings for the service managed cosmosdb account.
        """
        return pulumi.get(self, "cosmos_db")


@pulumi.output_type
class ServicePrincipalDatastoreCredentialsResponse(dict):
    """
    Service Principal datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "credentialsType":
            suggest = "credentials_type"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "authorityUrl":
            suggest = "authority_url"
        elif key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServicePrincipalDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServicePrincipalDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServicePrincipalDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 credentials_type: str,
                 tenant_id: str,
                 authority_url: Optional[str] = None,
                 resource_uri: Optional[str] = None):
        """
        Service Principal datastore credentials configuration.
        :param str client_id: Service principal client ID.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'ServicePrincipal'.
        :param str tenant_id: ID of the tenant to which the service principal belongs.
        :param str authority_url: Authority URL used for authentication.
        :param str resource_uri: Resource the service principal has access to.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'ServicePrincipal')
        pulumi.set(__self__, "tenant_id", tenant_id)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "credentials_type")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[str]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[str]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class SetupScriptsResponse(dict):
    """
    Details of customized scripts to execute for setting up the cluster.
    """
    def __init__(__self__, *,
                 scripts: Optional['outputs.ScriptsToExecuteResponse'] = None):
        """
        Details of customized scripts to execute for setting up the cluster.
        :param 'ScriptsToExecuteResponse' scripts: Customized setup scripts
        """
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)

    @property
    @pulumi.getter
    def scripts(self) -> Optional['outputs.ScriptsToExecuteResponse']:
        """
        Customized setup scripts
        """
        return pulumi.get(self, "scripts")


@pulumi.output_type
class SharedPrivateLinkResourceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "privateLinkResourceId":
            suggest = "private_link_resource_id"
        elif key == "requestMessage":
            suggest = "request_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedPrivateLinkResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedPrivateLinkResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedPrivateLinkResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_link_resource_id: Optional[str] = None,
                 request_message: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str group_id: The private link resource group id.
        :param str name: Unique name of the private link.
        :param str private_link_resource_id: The resource id that private link links to.
        :param str request_message: Request message.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[str]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[str]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SkuResponse(dict):
    """
    Sku of the resource
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 tier: Optional[str] = None):
        """
        Sku of the resource
        :param str name: Name of the sku
        :param str tier: Tier of the sku like Basic or Enterprise
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the sku
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Tier of the sku like Basic or Enterprise
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SqlAdminDatastoreCredentialsResponse(dict):
    """
    SQL Admin datastore credentials configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsType":
            suggest = "credentials_type"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlAdminDatastoreCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlAdminDatastoreCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlAdminDatastoreCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_type: str,
                 user_id: str):
        """
        SQL Admin datastore credentials configuration.
        :param str credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'SqlAdmin'.
        :param str user_id: SQL database user name.
        """
        pulumi.set(__self__, "credentials_type", 'SqlAdmin')
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> str:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'SqlAdmin'.
        """
        return pulumi.get(self, "credentials_type")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        SQL database user name.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class SslConfigurationResponse(dict):
    """
    The ssl configuration for scoring
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leafDomainLabel":
            suggest = "leaf_domain_label"
        elif key == "overwriteExistingDomain":
            suggest = "overwrite_existing_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 cname: Optional[str] = None,
                 key: Optional[str] = None,
                 leaf_domain_label: Optional[str] = None,
                 overwrite_existing_domain: Optional[bool] = None,
                 status: Optional[str] = None):
        """
        The ssl configuration for scoring
        :param str cert: Cert data
        :param str cname: CNAME of the cert
        :param str key: Key data
        :param str leaf_domain_label: Leaf domain label of public endpoint
        :param bool overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :param str status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cname(self) -> Optional[str]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[str]:
        """
        Leaf domain label of public endpoint
        """
        return pulumi.get(self, "leaf_domain_label")

    @property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[bool]:
        """
        Indicates whether to overwrite existing domain label.
        """
        return pulumi.get(self, "overwrite_existing_domain")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StatusMessageResponse(dict):
    """
    Active message associated with project
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdTimeUtc":
            suggest = "created_time_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 created_time_utc: str,
                 level: str,
                 message: str):
        """
        Active message associated with project
        :param str code: Service-defined message code.
        :param str created_time_utc: Time in UTC at which the message was created.
        :param str level: Severity level of message.
        :param str message: A human-readable representation of the message code.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "created_time_utc", created_time_utc)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Service-defined message code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="createdTimeUtc")
    def created_time_utc(self) -> str:
        """
        Time in UTC at which the message was created.
        """
        return pulumi.get(self, "created_time_utc")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        Severity level of message.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable representation of the message code.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class SweepJobResponse(dict):
    """
    Sweep job definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "interactionEndpoints":
            suggest = "interaction_endpoints"
        elif key == "jobType":
            suggest = "job_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "searchSpace":
            suggest = "search_space"
        elif key == "earlyTermination":
            suggest = "early_termination"
        elif key == "experimentName":
            suggest = "experiment_name"
        elif key == "maxConcurrentTrials":
            suggest = "max_concurrent_trials"
        elif key == "maxTotalTrials":
            suggest = "max_total_trials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SweepJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SweepJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SweepJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 compute: 'outputs.ComputeConfigurationResponse',
                 interaction_endpoints: Mapping[str, 'outputs.JobEndpointResponse'],
                 job_type: str,
                 objective: 'outputs.ObjectiveResponse',
                 output: 'outputs.JobOutputResponse',
                 provisioning_state: str,
                 search_space: Mapping[str, Any],
                 status: str,
                 description: Optional[str] = None,
                 early_termination: Optional[Any] = None,
                 experiment_name: Optional[str] = None,
                 identity: Optional[Any] = None,
                 max_concurrent_trials: Optional[int] = None,
                 max_total_trials: Optional[int] = None,
                 priority: Optional[int] = None,
                 properties: Optional[Mapping[str, str]] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 timeout: Optional[str] = None,
                 trial: Optional['outputs.TrialComponentResponse'] = None):
        """
        Sweep job definition.
        :param str algorithm: Type of the hyperparameter sampling algorithms
        :param 'ComputeConfigurationResponse' compute: Compute binding for the job.
        :param Mapping[str, 'JobEndpointResponse'] interaction_endpoints: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param str job_type: Enum to determine the type of job.
               Expected value is 'Sweep'.
        :param 'ObjectiveResponse' objective: Optimization objective.
        :param 'JobOutputResponse' output: Location of the job output logs and artifacts.
        :param str provisioning_state: Specifies the job provisioning state.
        :param Mapping[str, Any] search_space: A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        :param str status: The status of a job.
        :param str description: The asset description text.
        :param Union['BanditPolicyResponse', 'MedianStoppingPolicyResponse', 'TruncationSelectionPolicyResponse'] early_termination: Early termination policies enable canceling poor-performing runs before they complete.
        :param str experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param Union['AmlTokenResponse', 'ManagedIdentityResponse'] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity or null.
               Defaults to AmlToken if null.
        :param int max_concurrent_trials: An upper bound on the number of trials performed in parallel.
        :param int max_total_trials: An upper bound on the number of trials to perform.
        :param int priority: Job priority for scheduling policy. Only applies to AMLCompute.
               Private preview feature and only available to users on the allow list.
        :param Mapping[str, str] properties: The asset property dictionary.
        :param Mapping[str, str] tags: Tag dictionary. Tags can be added, removed, and updated.
        :param str timeout: The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes.
        :param 'TrialComponentResponse' trial: Trial component definition.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "compute", compute)
        pulumi.set(__self__, "interaction_endpoints", interaction_endpoints)
        pulumi.set(__self__, "job_type", 'Sweep')
        pulumi.set(__self__, "objective", objective)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "search_space", search_space)
        pulumi.set(__self__, "status", status)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_total_trials is not None:
            pulumi.set(__self__, "max_total_trials", max_total_trials)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial is not None:
            pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        Type of the hyperparameter sampling algorithms
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def compute(self) -> 'outputs.ComputeConfigurationResponse':
        """
        Compute binding for the job.
        """
        return pulumi.get(self, "compute")

    @property
    @pulumi.getter(name="interactionEndpoints")
    def interaction_endpoints(self) -> Mapping[str, 'outputs.JobEndpointResponse']:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "interaction_endpoints")

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> str:
        """
        Enum to determine the type of job.
        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_type")

    @property
    @pulumi.getter
    def objective(self) -> 'outputs.ObjectiveResponse':
        """
        Optimization objective.
        """
        return pulumi.get(self, "objective")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.JobOutputResponse':
        """
        Location of the job output logs and artifacts.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Specifies the job provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Mapping[str, Any]:
        """
        A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        """
        return pulumi.get(self, "search_space")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of a job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[Any]:
        """
        Early termination policies enable canceling poor-performing runs before they complete.
        """
        return pulumi.get(self, "early_termination")

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[str]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @property
    @pulumi.getter
    def identity(self) -> Optional[Any]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[int]:
        """
        An upper bound on the number of trials performed in parallel.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @property
    @pulumi.getter(name="maxTotalTrials")
    def max_total_trials(self) -> Optional[int]:
        """
        An upper bound on the number of trials to perform.
        """
        return pulumi.get(self, "max_total_trials")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Job priority for scheduling policy. Only applies to AMLCompute.
        Private preview feature and only available to users on the allow list.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, str]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The total timeout in ISO 8601 format. Only supports duration with precision as low as Minutes.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def trial(self) -> Optional['outputs.TrialComponentResponse']:
        """
        Trial component definition.
        """
        return pulumi.get(self, "trial")


@pulumi.output_type
class SynapseSparkPoolPropertiesResponseProperties(dict):
    """
    AKS properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoPauseProperties":
            suggest = "auto_pause_properties"
        elif key == "autoScaleProperties":
            suggest = "auto_scale_properties"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeSize":
            suggest = "node_size"
        elif key == "nodeSizeFamily":
            suggest = "node_size_family"
        elif key == "poolName":
            suggest = "pool_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sparkVersion":
            suggest = "spark_version"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "workspaceName":
            suggest = "workspace_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SynapseSparkPoolPropertiesResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SynapseSparkPoolPropertiesResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SynapseSparkPoolPropertiesResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_pause_properties: Optional['outputs.AutoPausePropertiesResponse'] = None,
                 auto_scale_properties: Optional['outputs.AutoScalePropertiesResponse'] = None,
                 node_count: Optional[int] = None,
                 node_size: Optional[str] = None,
                 node_size_family: Optional[str] = None,
                 pool_name: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 spark_version: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 workspace_name: Optional[str] = None):
        """
        AKS properties
        :param 'AutoPausePropertiesResponse' auto_pause_properties: Auto pause properties.
        :param 'AutoScalePropertiesResponse' auto_scale_properties: Auto scale properties.
        :param int node_count: The number of compute nodes currently assigned to the compute.
        :param str node_size: Node size.
        :param str node_size_family: Node size family.
        :param str pool_name: Pool name.
        :param str resource_group: Name of the resource group in which workspace is located.
        :param str spark_version: Spark version.
        :param str subscription_id: Azure subscription identifier.
        :param str workspace_name: Name of Azure Machine Learning workspace.
        """
        if auto_pause_properties is not None:
            pulumi.set(__self__, "auto_pause_properties", auto_pause_properties)
        if auto_scale_properties is not None:
            pulumi.set(__self__, "auto_scale_properties", auto_scale_properties)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if node_size_family is not None:
            pulumi.set(__self__, "node_size_family", node_size_family)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)

    @property
    @pulumi.getter(name="autoPauseProperties")
    def auto_pause_properties(self) -> Optional['outputs.AutoPausePropertiesResponse']:
        """
        Auto pause properties.
        """
        return pulumi.get(self, "auto_pause_properties")

    @property
    @pulumi.getter(name="autoScaleProperties")
    def auto_scale_properties(self) -> Optional['outputs.AutoScalePropertiesResponse']:
        """
        Auto scale properties.
        """
        return pulumi.get(self, "auto_scale_properties")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[str]:
        """
        Node size.
        """
        return pulumi.get(self, "node_size")

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> Optional[str]:
        """
        Node size family.
        """
        return pulumi.get(self, "node_size_family")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[str]:
        """
        Pool name.
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Name of the resource group in which workspace is located.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[str]:
        """
        Spark version.
        """
        return pulumi.get(self, "spark_version")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Azure subscription identifier.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[str]:
        """
        Name of Azure Machine Learning workspace.
        """
        return pulumi.get(self, "workspace_name")


@pulumi.output_type
class SynapseSparkResponse(dict):
    """
    A SynapseSpark compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SynapseSparkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SynapseSparkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SynapseSparkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.SynapseSparkPoolPropertiesResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A SynapseSpark compute.
        :param str compute_type: The type of compute
               Expected value is 'SynapseSpark'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param 'SynapseSparkPoolPropertiesResponseProperties' properties: AKS properties
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'SynapseSpark')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'SynapseSpark'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.SynapseSparkPoolPropertiesResponseProperties']:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class SystemServiceResponse(dict):
    """
    A system service running on a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddress":
            suggest = "public_ip_address"
        elif key == "systemServiceType":
            suggest = "system_service_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ip_address: str,
                 system_service_type: str,
                 version: str):
        """
        A system service running on a compute.
        :param str public_ip_address: Public IP address
        :param str system_service_type: The type of this system service.
        :param str version: The version for this type.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "system_service_type", system_service_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        Public IP address
        """
        return pulumi.get(self, "public_ip_address")

    @property
    @pulumi.getter(name="systemServiceType")
    def system_service_type(self) -> str:
        """
        The type of this system service.
        """
        return pulumi.get(self, "system_service_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version for this type.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class TensorFlowResponse(dict):
    """
    TensorFlow distribution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "distributionType":
            suggest = "distribution_type"
        elif key == "parameterServerCount":
            suggest = "parameter_server_count"
        elif key == "workerCount":
            suggest = "worker_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TensorFlowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TensorFlowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TensorFlowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution_type: str,
                 parameter_server_count: Optional[int] = None,
                 worker_count: Optional[int] = None):
        """
        TensorFlow distribution configuration.
        :param str distribution_type: Enum to determine the job distribution type.
               Expected value is 'TensorFlow'.
        :param int parameter_server_count: Number of parameter server tasks.
        :param int worker_count: Number of workers. Overwrites the node count in compute binding.
        """
        pulumi.set(__self__, "distribution_type", 'TensorFlow')
        if parameter_server_count is not None:
            pulumi.set(__self__, "parameter_server_count", parameter_server_count)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> str:
        """
        Enum to determine the job distribution type.
        Expected value is 'TensorFlow'.
        """
        return pulumi.get(self, "distribution_type")

    @property
    @pulumi.getter(name="parameterServerCount")
    def parameter_server_count(self) -> Optional[int]:
        """
        Number of parameter server tasks.
        """
        return pulumi.get(self, "parameter_server_count")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[int]:
        """
        Number of workers. Overwrites the node count in compute binding.
        """
        return pulumi.get(self, "worker_count")


@pulumi.output_type
class TrialComponentResponse(dict):
    """
    Trial component definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeId":
            suggest = "code_id"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "inputDataBindings":
            suggest = "input_data_bindings"
        elif key == "outputDataBindings":
            suggest = "output_data_bindings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrialComponentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrialComponentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrialComponentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: str,
                 code_id: Optional[str] = None,
                 distribution: Optional[Any] = None,
                 environment_id: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, str]] = None,
                 input_data_bindings: Optional[Mapping[str, 'outputs.InputDataBindingResponse']] = None,
                 output_data_bindings: Optional[Mapping[str, 'outputs.OutputDataBindingResponse']] = None,
                 timeout: Optional[str] = None):
        """
        Trial component definition.
        :param str command: The command to execute on startup of the job. eg. "python train.py"
        :param str code_id: ARM resource ID of the code asset.
        :param Union['MpiResponse', 'PyTorchResponse', 'TensorFlowResponse'] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param str environment_id: The ARM resource ID of the Environment specification for the job.
        :param Mapping[str, str] environment_variables: Environment variables included in the job.
        :param Mapping[str, 'InputDataBindingResponse'] input_data_bindings: Mapping of input data bindings used in the job.
        :param Mapping[str, 'OutputDataBindingResponse'] output_data_bindings: Mapping of output data bindings used in the job.
        :param str timeout: The max run duration in ISO 8601 format, after which the trial component will be cancelled.
               Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "command", command)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if input_data_bindings is not None:
            pulumi.set(__self__, "input_data_bindings", input_data_bindings)
        if output_data_bindings is not None:
            pulumi.set(__self__, "output_data_bindings", output_data_bindings)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[str]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @property
    @pulumi.getter
    def distribution(self) -> Optional[Any]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, str]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="inputDataBindings")
    def input_data_bindings(self) -> Optional[Mapping[str, 'outputs.InputDataBindingResponse']]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "input_data_bindings")

    @property
    @pulumi.getter(name="outputDataBindings")
    def output_data_bindings(self) -> Optional[Mapping[str, 'outputs.OutputDataBindingResponse']]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "output_data_bindings")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        The max run duration in ISO 8601 format, after which the trial component will be cancelled.
        Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TruncationSelectionPolicyResponse(dict):
    """
    Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "delayEvaluation":
            suggest = "delay_evaluation"
        elif key == "evaluationInterval":
            suggest = "evaluation_interval"
        elif key == "truncationPercentage":
            suggest = "truncation_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TruncationSelectionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TruncationSelectionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TruncationSelectionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: str,
                 delay_evaluation: Optional[int] = None,
                 evaluation_interval: Optional[int] = None,
                 truncation_percentage: Optional[int] = None):
        """
        Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
        :param str policy_type: 
               Expected value is 'TruncationSelection'.
        :param int delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param int evaluation_interval: Interval (number of runs) between policy evaluations.
        :param int truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        """
        pulumi.set(__self__, "policy_type", 'TruncationSelection')
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if truncation_percentage is not None:
            pulumi.set(__self__, "truncation_percentage", truncation_percentage)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """

        Expected value is 'TruncationSelection'.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[int]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[int]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @property
    @pulumi.getter(name="truncationPercentage")
    def truncation_percentage(self) -> Optional[int]:
        """
        The percentage of runs to cancel at each evaluation interval.
        """
        return pulumi.get(self, "truncation_percentage")


@pulumi.output_type
class UserAccountCredentialsResponse(dict):
    """
    Settings for user account that gets created on each on the nodes of a compute.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "adminUserPassword":
            suggest = "admin_user_password"
        elif key == "adminUserSshPublicKey":
            suggest = "admin_user_ssh_public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAccountCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAccountCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_user_name: str,
                 admin_user_password: Optional[str] = None,
                 admin_user_ssh_public_key: Optional[str] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param str admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param str admin_user_password: Password of the administrator user account.
        :param str admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[str]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[str]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")


@pulumi.output_type
class UserAssignedIdentityMetaResponse(dict):
    """
    User assigned identities associated with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityMetaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityMetaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityMetaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        """
        User assigned identities associated with a resource.
        :param str client_id: Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning.
        :param str principal_id: The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        Aka application ID, a unique identifier generated by Azure AD that is tied to an application and service principal during its initial provisioning.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The object ID of the service principal object for your managed identity that is used to grant role-based access to an Azure resource.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User Assigned Identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str,
                 tenant_id: str):
        """
        User Assigned Identity
        :param str client_id: The clientId(aka appId) of the user assigned identity.
        :param str principal_id: The principal ID of the user assigned identity.
        :param str tenant_id: The tenant ID of the user assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The clientId(aka appId) of the user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the user assigned identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class VirtualMachineImageResponse(dict):
    """
    Virtual Machine image for Windows AML Compute
    """
    def __init__(__self__, *,
                 id: str):
        """
        Virtual Machine image for Windows AML Compute
        :param str id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualMachineResponse(dict):
    """
    A Machine Learning compute based on Azure Virtual Machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeType":
            suggest = "compute_type"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "isAttachedCompute":
            suggest = "is_attached_compute"
        elif key == "modifiedOn":
            suggest = "modified_on"
        elif key == "provisioningErrors":
            suggest = "provisioning_errors"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "computeLocation":
            suggest = "compute_location"
        elif key == "disableLocalAuth":
            suggest = "disable_local_auth"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_type: str,
                 created_on: str,
                 is_attached_compute: bool,
                 modified_on: str,
                 provisioning_errors: Sequence['outputs.ErrorResponseResponse'],
                 provisioning_state: str,
                 compute_location: Optional[str] = None,
                 description: Optional[str] = None,
                 disable_local_auth: Optional[bool] = None,
                 properties: Optional['outputs.VirtualMachineResponseProperties'] = None,
                 resource_id: Optional[str] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param str compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param str created_on: The time at which the compute was created.
        :param bool is_attached_compute: Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        :param str modified_on: The time at which the compute was last modified.
        :param Sequence['ErrorResponseResponse'] provisioning_errors: Errors during provisioning
        :param str provisioning_state: The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        :param str compute_location: Location for the underlying compute
        :param str description: The description of the Machine Learning compute.
        :param bool disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param str resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "is_attached_compute", is_attached_compute)
        pulumi.set(__self__, "modified_on", modified_on)
        pulumi.set(__self__, "provisioning_errors", provisioning_errors)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> str:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The time at which the compute was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="isAttachedCompute")
    def is_attached_compute(self) -> bool:
        """
        Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning service provisioned it if false.
        """
        return pulumi.get(self, "is_attached_compute")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> str:
        """
        The time at which the compute was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="provisioningErrors")
    def provisioning_errors(self) -> Sequence['outputs.ErrorResponseResponse']:
        """
        Errors during provisioning
        """
        return pulumi.get(self, "provisioning_errors")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[str]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[bool]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.VirtualMachineResponseProperties']:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class VirtualMachineResponseProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "administratorAccount":
            suggest = "administrator_account"
        elif key == "isNotebookInstanceCompute":
            suggest = "is_notebook_instance_compute"
        elif key == "sshPort":
            suggest = "ssh_port"
        elif key == "virtualMachineSize":
            suggest = "virtual_machine_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 administrator_account: Optional['outputs.VirtualMachineSshCredentialsResponse'] = None,
                 is_notebook_instance_compute: Optional[bool] = None,
                 ssh_port: Optional[int] = None,
                 virtual_machine_size: Optional[str] = None):
        """
        :param str address: Public IP address of the virtual machine.
        :param 'VirtualMachineSshCredentialsResponse' administrator_account: Admin credentials for virtual machine
        :param bool is_notebook_instance_compute: Indicates whether this compute will be used for running notebooks.
        :param int ssh_port: Port open for ssh connections.
        :param str virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if is_notebook_instance_compute is not None:
            pulumi.set(__self__, "is_notebook_instance_compute", is_notebook_instance_compute)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional['outputs.VirtualMachineSshCredentialsResponse']:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @property
    @pulumi.getter(name="isNotebookInstanceCompute")
    def is_notebook_instance_compute(self) -> Optional[bool]:
        """
        Indicates whether this compute will be used for running notebooks.
        """
        return pulumi.get(self, "is_notebook_instance_compute")

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[int]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[str]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")


@pulumi.output_type
class VirtualMachineSshCredentialsResponse(dict):
    """
    Admin credentials for virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKeyData":
            suggest = "private_key_data"
        elif key == "publicKeyData":
            suggest = "public_key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineSshCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineSshCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: Optional[str] = None,
                 private_key_data: Optional[str] = None,
                 public_key_data: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Admin credentials for virtual machine
        :param str password: Password of admin account
        :param str private_key_data: Private key data
        :param str public_key_data: Public key data
        :param str username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[str]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[str]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")


