# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['IntegrationServiceEnvironmentManagedApiArgs', 'IntegrationServiceEnvironmentManagedApi']

@pulumi.input_type
class IntegrationServiceEnvironmentManagedApiArgs:
    def __init__(__self__, *,
                 integration_service_environment_name: pulumi.Input[str],
                 resource_group: pulumi.Input[str],
                 api_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a IntegrationServiceEnvironmentManagedApi resource.
        :param pulumi.Input[str] integration_service_environment_name: The integration service environment name.
        :param pulumi.Input[str] resource_group: The resource group name.
        :param pulumi.Input[str] api_name: The api name.
        """
        pulumi.set(__self__, "integration_service_environment_name", integration_service_environment_name)
        pulumi.set(__self__, "resource_group", resource_group)
        if api_name is not None:
            pulumi.set(__self__, "api_name", api_name)

    @property
    @pulumi.getter(name="integrationServiceEnvironmentName")
    def integration_service_environment_name(self) -> pulumi.Input[str]:
        """
        The integration service environment name.
        """
        return pulumi.get(self, "integration_service_environment_name")

    @integration_service_environment_name.setter
    def integration_service_environment_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_service_environment_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Input[str]:
        """
        The resource group name.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> Optional[pulumi.Input[str]]:
        """
        The api name.
        """
        return pulumi.get(self, "api_name")

    @api_name.setter
    def api_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_name", value)


class IntegrationServiceEnvironmentManagedApi(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_name: Optional[pulumi.Input[str]] = None,
                 integration_service_environment_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The managed api definition.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_name: The api name.
        :param pulumi.Input[str] integration_service_environment_name: The integration service environment name.
        :param pulumi.Input[str] resource_group: The resource group name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationServiceEnvironmentManagedApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The managed api definition.

        :param str resource_name: The name of the resource.
        :param IntegrationServiceEnvironmentManagedApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationServiceEnvironmentManagedApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_name: Optional[pulumi.Input[str]] = None,
                 integration_service_environment_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationServiceEnvironmentManagedApiArgs.__new__(IntegrationServiceEnvironmentManagedApiArgs)

            __props__.__dict__["api_name"] = api_name
            if integration_service_environment_name is None and not opts.urn:
                raise TypeError("Missing required property 'integration_service_environment_name'")
            __props__.__dict__["integration_service_environment_name"] = integration_service_environment_name
            if resource_group is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group'")
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["location"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["properties"] = None
            __props__.__dict__["tags"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:logic/v20190501:IntegrationServiceEnvironmentManagedApi"), pulumi.Alias(type_="azure-native:logic:IntegrationServiceEnvironmentManagedApi"), pulumi.Alias(type_="azure-nextgen:logic:IntegrationServiceEnvironmentManagedApi")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(IntegrationServiceEnvironmentManagedApi, __self__).__init__(
            'azure-native:logic/v20190501:IntegrationServiceEnvironmentManagedApi',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IntegrationServiceEnvironmentManagedApi':
        """
        Get an existing IntegrationServiceEnvironmentManagedApi resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IntegrationServiceEnvironmentManagedApiArgs.__new__(IntegrationServiceEnvironmentManagedApiArgs)

        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["properties"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return IntegrationServiceEnvironmentManagedApi(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Gets the resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.ApiResourcePropertiesResponse']:
        """
        The api resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Gets the resource type.
        """
        return pulumi.get(self, "type")

