# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSiteSensorResult',
    'AwaitableGetSiteSensorResult',
    'get_site_sensor',
]

@pulumi.output_type
class GetSiteSensorResult:
    """
    IoT sensor model
    """
    def __init__(__self__, connectivity_time=None, dynamic_learning=None, id=None, learning_mode=None, name=None, sensor_status=None, sensor_type=None, sensor_version=None, system_data=None, ti_automatic_updates=None, ti_status=None, ti_version=None, type=None, zone=None):
        if connectivity_time and not isinstance(connectivity_time, str):
            raise TypeError("Expected argument 'connectivity_time' to be a str")
        pulumi.set(__self__, "connectivity_time", connectivity_time)
        if dynamic_learning and not isinstance(dynamic_learning, bool):
            raise TypeError("Expected argument 'dynamic_learning' to be a bool")
        pulumi.set(__self__, "dynamic_learning", dynamic_learning)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if learning_mode and not isinstance(learning_mode, bool):
            raise TypeError("Expected argument 'learning_mode' to be a bool")
        pulumi.set(__self__, "learning_mode", learning_mode)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sensor_status and not isinstance(sensor_status, str):
            raise TypeError("Expected argument 'sensor_status' to be a str")
        pulumi.set(__self__, "sensor_status", sensor_status)
        if sensor_type and not isinstance(sensor_type, str):
            raise TypeError("Expected argument 'sensor_type' to be a str")
        pulumi.set(__self__, "sensor_type", sensor_type)
        if sensor_version and not isinstance(sensor_version, str):
            raise TypeError("Expected argument 'sensor_version' to be a str")
        pulumi.set(__self__, "sensor_version", sensor_version)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if ti_automatic_updates and not isinstance(ti_automatic_updates, bool):
            raise TypeError("Expected argument 'ti_automatic_updates' to be a bool")
        pulumi.set(__self__, "ti_automatic_updates", ti_automatic_updates)
        if ti_status and not isinstance(ti_status, str):
            raise TypeError("Expected argument 'ti_status' to be a str")
        pulumi.set(__self__, "ti_status", ti_status)
        if ti_version and not isinstance(ti_version, str):
            raise TypeError("Expected argument 'ti_version' to be a str")
        pulumi.set(__self__, "ti_version", ti_version)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="connectivityTime")
    def connectivity_time(self) -> str:
        """
        Last connectivity time of the IoT sensor
        """
        return pulumi.get(self, "connectivity_time")

    @property
    @pulumi.getter(name="dynamicLearning")
    def dynamic_learning(self) -> bool:
        """
        Dynamic mode status of the IoT sensor
        """
        return pulumi.get(self, "dynamic_learning")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="learningMode")
    def learning_mode(self) -> bool:
        """
        Learning mode status of the IoT sensor
        """
        return pulumi.get(self, "learning_mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sensorStatus")
    def sensor_status(self) -> str:
        """
        Status of the IoT sensor
        """
        return pulumi.get(self, "sensor_status")

    @property
    @pulumi.getter(name="sensorType")
    def sensor_type(self) -> Optional[str]:
        """
        Type of sensor
        """
        return pulumi.get(self, "sensor_type")

    @property
    @pulumi.getter(name="sensorVersion")
    def sensor_version(self) -> str:
        """
        Version of the IoT sensor
        """
        return pulumi.get(self, "sensor_version")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter(name="tiAutomaticUpdates")
    def ti_automatic_updates(self) -> Optional[bool]:
        """
        TI Automatic mode status of the IoT sensor
        """
        return pulumi.get(self, "ti_automatic_updates")

    @property
    @pulumi.getter(name="tiStatus")
    def ti_status(self) -> str:
        """
        TI Status of the IoT sensor
        """
        return pulumi.get(self, "ti_status")

    @property
    @pulumi.getter(name="tiVersion")
    def ti_version(self) -> str:
        """
        TI Version of the IoT sensor
        """
        return pulumi.get(self, "ti_version")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        Zone of the IoT sensor
        """
        return pulumi.get(self, "zone")


class AwaitableGetSiteSensorResult(GetSiteSensorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSiteSensorResult(
            connectivity_time=self.connectivity_time,
            dynamic_learning=self.dynamic_learning,
            id=self.id,
            learning_mode=self.learning_mode,
            name=self.name,
            sensor_status=self.sensor_status,
            sensor_type=self.sensor_type,
            sensor_version=self.sensor_version,
            system_data=self.system_data,
            ti_automatic_updates=self.ti_automatic_updates,
            ti_status=self.ti_status,
            ti_version=self.ti_version,
            type=self.type,
            zone=self.zone)


def get_site_sensor(iot_defender_location: Optional[str] = None,
                    sensor_name: Optional[str] = None,
                    site_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSiteSensorResult:
    """
    IoT sensor model
    API Version: 2021-09-01-preview.


    :param str iot_defender_location: Defender for IoT location
    :param str sensor_name: Name of the IoT sensor
    :param str site_name: Site Name
    """
    __args__ = dict()
    __args__['iotDefenderLocation'] = iot_defender_location
    __args__['sensorName'] = sensor_name
    __args__['siteName'] = site_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:iotsecurity:getSiteSensor', __args__, opts=opts, typ=GetSiteSensorResult).value

    return AwaitableGetSiteSensorResult(
        connectivity_time=__ret__.connectivity_time,
        dynamic_learning=__ret__.dynamic_learning,
        id=__ret__.id,
        learning_mode=__ret__.learning_mode,
        name=__ret__.name,
        sensor_status=__ret__.sensor_status,
        sensor_type=__ret__.sensor_type,
        sensor_version=__ret__.sensor_version,
        system_data=__ret__.system_data,
        ti_automatic_updates=__ret__.ti_automatic_updates,
        ti_status=__ret__.ti_status,
        ti_version=__ret__.ti_version,
        type=__ret__.type,
        zone=__ret__.zone)
