# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AzureFunctionEventSubscriptionDestinationArgs',
    'BoolEqualsAdvancedFilterArgs',
    'ConnectionStateArgs',
    'DeadLetterWithResourceIdentityArgs',
    'DeliveryWithResourceIdentityArgs',
    'EventChannelDestinationArgs',
    'EventChannelFilterArgs',
    'EventChannelSourceArgs',
    'EventHubEventSubscriptionDestinationArgs',
    'EventSubscriptionFilterArgs',
    'EventSubscriptionIdentityArgs',
    'HybridConnectionEventSubscriptionDestinationArgs',
    'IdentityInfoArgs',
    'InboundIpRuleArgs',
    'IsNotNullAdvancedFilterArgs',
    'IsNullOrUndefinedAdvancedFilterArgs',
    'JsonFieldWithDefaultArgs',
    'JsonFieldArgs',
    'JsonInputSchemaMappingArgs',
    'NumberGreaterThanAdvancedFilterArgs',
    'NumberGreaterThanOrEqualsAdvancedFilterArgs',
    'NumberInAdvancedFilterArgs',
    'NumberInRangeAdvancedFilterArgs',
    'NumberLessThanAdvancedFilterArgs',
    'NumberLessThanOrEqualsAdvancedFilterArgs',
    'NumberNotInAdvancedFilterArgs',
    'NumberNotInRangeAdvancedFilterArgs',
    'PrivateEndpointArgs',
    'RetryPolicyArgs',
    'ServiceBusQueueEventSubscriptionDestinationArgs',
    'ServiceBusTopicEventSubscriptionDestinationArgs',
    'StorageBlobDeadLetterDestinationArgs',
    'StorageQueueEventSubscriptionDestinationArgs',
    'StringBeginsWithAdvancedFilterArgs',
    'StringContainsAdvancedFilterArgs',
    'StringEndsWithAdvancedFilterArgs',
    'StringInAdvancedFilterArgs',
    'StringNotBeginsWithAdvancedFilterArgs',
    'StringNotContainsAdvancedFilterArgs',
    'StringNotEndsWithAdvancedFilterArgs',
    'StringNotInAdvancedFilterArgs',
    'UserIdentityPropertiesArgs',
    'WebHookEventSubscriptionDestinationArgs',
]

@pulumi.input_type
class AzureFunctionEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 max_events_per_batch: Optional[pulumi.Input[int]] = None,
                 preferred_batch_size_in_kilobytes: Optional[pulumi.Input[int]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the azure function destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'AzureFunction'.
        :param pulumi.Input[int] max_events_per_batch: Maximum number of events per batch.
        :param pulumi.Input[int] preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        :param pulumi.Input[str] resource_id: The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'AzureFunction')
        if max_events_per_batch is None:
            max_events_per_batch = 1
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is None:
            preferred_batch_size_in_kilobytes = 64
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'AzureFunction'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @max_events_per_batch.setter
    def max_events_per_batch(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_events_per_batch", value)

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[pulumi.Input[int]]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")

    @preferred_batch_size_in_kilobytes.setter
    def preferred_batch_size_in_kilobytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "preferred_batch_size_in_kilobytes", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class BoolEqualsAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[bool]] = None):
        """
        BoolEquals Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'BoolEquals'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[bool] value: The boolean filter value.
        """
        pulumi.set(__self__, "operator_type", 'BoolEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'BoolEquals'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[bool]]:
        """
        The boolean filter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PersistedConnectionStatus']]] = None):
        """
        ConnectionState information.
        :param pulumi.Input[str] actions_required: Actions required (if any).
        :param pulumi.Input[str] description: Description of the connection state.
        :param pulumi.Input[Union[str, 'PersistedConnectionStatus']] status: Status of the connection.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        Actions required (if any).
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the connection state.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PersistedConnectionStatus']]]:
        """
        Status of the connection.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PersistedConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class DeadLetterWithResourceIdentityArgs:
    def __init__(__self__, *,
                 dead_letter_destination: Optional[pulumi.Input['StorageBlobDeadLetterDestinationArgs']] = None,
                 identity: Optional[pulumi.Input['EventSubscriptionIdentityArgs']] = None):
        """
        Information about the deadletter destination with resource identity.
        :param pulumi.Input['StorageBlobDeadLetterDestinationArgs'] dead_letter_destination: Information about the destination where events have to be delivered for the event subscription.
               Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
        :param pulumi.Input['EventSubscriptionIdentityArgs'] identity: The identity to use when dead-lettering events.
        """
        if dead_letter_destination is not None:
            pulumi.set(__self__, "dead_letter_destination", dead_letter_destination)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="deadLetterDestination")
    def dead_letter_destination(self) -> Optional[pulumi.Input['StorageBlobDeadLetterDestinationArgs']]:
        """
        Information about the destination where events have to be delivered for the event subscription.
        Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
        """
        return pulumi.get(self, "dead_letter_destination")

    @dead_letter_destination.setter
    def dead_letter_destination(self, value: Optional[pulumi.Input['StorageBlobDeadLetterDestinationArgs']]):
        pulumi.set(self, "dead_letter_destination", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EventSubscriptionIdentityArgs']]:
        """
        The identity to use when dead-lettering events.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EventSubscriptionIdentityArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class DeliveryWithResourceIdentityArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[Union['AzureFunctionEventSubscriptionDestinationArgs', 'EventHubEventSubscriptionDestinationArgs', 'HybridConnectionEventSubscriptionDestinationArgs', 'ServiceBusQueueEventSubscriptionDestinationArgs', 'ServiceBusTopicEventSubscriptionDestinationArgs', 'StorageQueueEventSubscriptionDestinationArgs', 'WebHookEventSubscriptionDestinationArgs']]] = None,
                 identity: Optional[pulumi.Input['EventSubscriptionIdentityArgs']] = None):
        """
        Information about the delivery for an event subscription with resource identity.
        :param pulumi.Input[Union['AzureFunctionEventSubscriptionDestinationArgs', 'EventHubEventSubscriptionDestinationArgs', 'HybridConnectionEventSubscriptionDestinationArgs', 'ServiceBusQueueEventSubscriptionDestinationArgs', 'ServiceBusTopicEventSubscriptionDestinationArgs', 'StorageQueueEventSubscriptionDestinationArgs', 'WebHookEventSubscriptionDestinationArgs']] destination: Information about the destination where events have to be delivered for the event subscription.
               Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
        :param pulumi.Input['EventSubscriptionIdentityArgs'] identity: The identity to use when delivering events.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[Union['AzureFunctionEventSubscriptionDestinationArgs', 'EventHubEventSubscriptionDestinationArgs', 'HybridConnectionEventSubscriptionDestinationArgs', 'ServiceBusQueueEventSubscriptionDestinationArgs', 'ServiceBusTopicEventSubscriptionDestinationArgs', 'StorageQueueEventSubscriptionDestinationArgs', 'WebHookEventSubscriptionDestinationArgs']]]:
        """
        Information about the destination where events have to be delivered for the event subscription.
        Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[Union['AzureFunctionEventSubscriptionDestinationArgs', 'EventHubEventSubscriptionDestinationArgs', 'HybridConnectionEventSubscriptionDestinationArgs', 'ServiceBusQueueEventSubscriptionDestinationArgs', 'ServiceBusTopicEventSubscriptionDestinationArgs', 'StorageQueueEventSubscriptionDestinationArgs', 'WebHookEventSubscriptionDestinationArgs']]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['EventSubscriptionIdentityArgs']]:
        """
        The identity to use when delivering events.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['EventSubscriptionIdentityArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class EventChannelDestinationArgs:
    def __init__(__self__, *,
                 azure_subscription_id: Optional[pulumi.Input[str]] = None,
                 partner_topic_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None):
        """
        Properties of the destination of an event channel.
        :param pulumi.Input[str] azure_subscription_id: Azure subscription ID of the customer creating the event channel. The partner topic
               associated with the event channel will be created under this Azure subscription.
        :param pulumi.Input[str] partner_topic_name: Name of the partner topic associated with the event channel.
        :param pulumi.Input[str] resource_group: Azure Resource Group of the customer creating the event channel. The partner topic
               associated with the event channel will be created under this resource group.
        """
        if azure_subscription_id is not None:
            pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if partner_topic_name is not None:
            pulumi.set(__self__, "partner_topic_name", partner_topic_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)

    @property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure subscription ID of the customer creating the event channel. The partner topic
        associated with the event channel will be created under this Azure subscription.
        """
        return pulumi.get(self, "azure_subscription_id")

    @azure_subscription_id.setter
    def azure_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_subscription_id", value)

    @property
    @pulumi.getter(name="partnerTopicName")
    def partner_topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the partner topic associated with the event channel.
        """
        return pulumi.get(self, "partner_topic_name")

    @partner_topic_name.setter
    def partner_topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_topic_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Resource Group of the customer creating the event channel. The partner topic
        associated with the event channel will be created under this resource group.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)


@pulumi.input_type
class EventChannelFilterArgs:
    def __init__(__self__, *,
                 advanced_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'IsNotNullAdvancedFilterArgs', 'IsNullOrUndefinedAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberInRangeAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'NumberNotInRangeAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotBeginsWithAdvancedFilterArgs', 'StringNotContainsAdvancedFilterArgs', 'StringNotEndsWithAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]]] = None,
                 enable_advanced_filtering_on_arrays: Optional[pulumi.Input[bool]] = None):
        """
        Filter for the Event Channel.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'IsNotNullAdvancedFilterArgs', 'IsNullOrUndefinedAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberInRangeAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'NumberNotInRangeAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotBeginsWithAdvancedFilterArgs', 'StringNotContainsAdvancedFilterArgs', 'StringNotEndsWithAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]] advanced_filters: An array of advanced filters that are used for filtering event channels.
        :param pulumi.Input[bool] enable_advanced_filtering_on_arrays: Allows advanced filters to be evaluated against an array of values instead of expecting a singular value. The default value is either false or null.
        """
        if advanced_filters is not None:
            pulumi.set(__self__, "advanced_filters", advanced_filters)
        if enable_advanced_filtering_on_arrays is None:
            enable_advanced_filtering_on_arrays = False
        if enable_advanced_filtering_on_arrays is not None:
            pulumi.set(__self__, "enable_advanced_filtering_on_arrays", enable_advanced_filtering_on_arrays)

    @property
    @pulumi.getter(name="advancedFilters")
    def advanced_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'IsNotNullAdvancedFilterArgs', 'IsNullOrUndefinedAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberInRangeAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'NumberNotInRangeAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotBeginsWithAdvancedFilterArgs', 'StringNotContainsAdvancedFilterArgs', 'StringNotEndsWithAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]]]:
        """
        An array of advanced filters that are used for filtering event channels.
        """
        return pulumi.get(self, "advanced_filters")

    @advanced_filters.setter
    def advanced_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'IsNotNullAdvancedFilterArgs', 'IsNullOrUndefinedAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberInRangeAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'NumberNotInRangeAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotBeginsWithAdvancedFilterArgs', 'StringNotContainsAdvancedFilterArgs', 'StringNotEndsWithAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]]]):
        pulumi.set(self, "advanced_filters", value)

    @property
    @pulumi.getter(name="enableAdvancedFilteringOnArrays")
    def enable_advanced_filtering_on_arrays(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows advanced filters to be evaluated against an array of values instead of expecting a singular value. The default value is either false or null.
        """
        return pulumi.get(self, "enable_advanced_filtering_on_arrays")

    @enable_advanced_filtering_on_arrays.setter
    def enable_advanced_filtering_on_arrays(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_advanced_filtering_on_arrays", value)


@pulumi.input_type
class EventChannelSourceArgs:
    def __init__(__self__, *,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Properties of the source of an event channel.
        :param pulumi.Input[str] source: The identifier of the resource that's the source of the events.
               This represents a unique resource in the partner's resource model.
        """
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the resource that's the source of the events.
        This represents a unique resource in the partner's resource model.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class EventHubEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the event hub destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'EventHub'.
        :param pulumi.Input[str] resource_id: The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'EventHub')
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'EventHub'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class EventSubscriptionFilterArgs:
    def __init__(__self__, *,
                 advanced_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]]] = None,
                 included_event_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_subject_case_sensitive: Optional[pulumi.Input[bool]] = None,
                 subject_begins_with: Optional[pulumi.Input[str]] = None,
                 subject_ends_with: Optional[pulumi.Input[str]] = None):
        """
        Filter for the Event Subscription.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]] advanced_filters: An array of advanced filters that are used for filtering event subscriptions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] included_event_types: A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
        :param pulumi.Input[bool] is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
               should be compared in a case sensitive manner.
        :param pulumi.Input[str] subject_begins_with: An optional string to filter events for an event subscription based on a resource path prefix.
               The format of this depends on the publisher of the events.
               Wildcard characters are not supported in this path.
        :param pulumi.Input[str] subject_ends_with: An optional string to filter events for an event subscription based on a resource path suffix.
               Wildcard characters are not supported in this path.
        """
        if advanced_filters is not None:
            pulumi.set(__self__, "advanced_filters", advanced_filters)
        if included_event_types is not None:
            pulumi.set(__self__, "included_event_types", included_event_types)
        if is_subject_case_sensitive is None:
            is_subject_case_sensitive = False
        if is_subject_case_sensitive is not None:
            pulumi.set(__self__, "is_subject_case_sensitive", is_subject_case_sensitive)
        if subject_begins_with is not None:
            pulumi.set(__self__, "subject_begins_with", subject_begins_with)
        if subject_ends_with is not None:
            pulumi.set(__self__, "subject_ends_with", subject_ends_with)

    @property
    @pulumi.getter(name="advancedFilters")
    def advanced_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]]]:
        """
        An array of advanced filters that are used for filtering event subscriptions.
        """
        return pulumi.get(self, "advanced_filters")

    @advanced_filters.setter
    def advanced_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BoolEqualsAdvancedFilterArgs', 'NumberGreaterThanAdvancedFilterArgs', 'NumberGreaterThanOrEqualsAdvancedFilterArgs', 'NumberInAdvancedFilterArgs', 'NumberLessThanAdvancedFilterArgs', 'NumberLessThanOrEqualsAdvancedFilterArgs', 'NumberNotInAdvancedFilterArgs', 'StringBeginsWithAdvancedFilterArgs', 'StringContainsAdvancedFilterArgs', 'StringEndsWithAdvancedFilterArgs', 'StringInAdvancedFilterArgs', 'StringNotInAdvancedFilterArgs']]]]]):
        pulumi.set(self, "advanced_filters", value)

    @property
    @pulumi.getter(name="includedEventTypes")
    def included_event_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
        """
        return pulumi.get(self, "included_event_types")

    @included_event_types.setter
    def included_event_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_event_types", value)

    @property
    @pulumi.getter(name="isSubjectCaseSensitive")
    def is_subject_case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
        should be compared in a case sensitive manner.
        """
        return pulumi.get(self, "is_subject_case_sensitive")

    @is_subject_case_sensitive.setter
    def is_subject_case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_subject_case_sensitive", value)

    @property
    @pulumi.getter(name="subjectBeginsWith")
    def subject_begins_with(self) -> Optional[pulumi.Input[str]]:
        """
        An optional string to filter events for an event subscription based on a resource path prefix.
        The format of this depends on the publisher of the events.
        Wildcard characters are not supported in this path.
        """
        return pulumi.get(self, "subject_begins_with")

    @subject_begins_with.setter
    def subject_begins_with(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_begins_with", value)

    @property
    @pulumi.getter(name="subjectEndsWith")
    def subject_ends_with(self) -> Optional[pulumi.Input[str]]:
        """
        An optional string to filter events for an event subscription based on a resource path suffix.
        Wildcard characters are not supported in this path.
        """
        return pulumi.get(self, "subject_ends_with")

    @subject_ends_with.setter
    def subject_ends_with(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_ends_with", value)


@pulumi.input_type
class EventSubscriptionIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'EventSubscriptionIdentityType']]] = None,
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        The identity information with the event subscription.
        :param pulumi.Input[Union[str, 'EventSubscriptionIdentityType']] type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        :param pulumi.Input[str] user_assigned_identity: The user identity associated with the resource.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'EventSubscriptionIdentityType']]]:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'EventSubscriptionIdentityType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        The user identity associated with the resource.
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class HybridConnectionEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the HybridConnection destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'HybridConnection'.
        :param pulumi.Input[str] resource_id: The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'HybridConnection')
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'HybridConnection'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource ID of an hybrid connection that is the destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class IdentityInfoArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'IdentityType']]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]] = None):
        """
        The identity information for the resource.
        :param pulumi.Input[str] principal_id: The principal ID of resource identity.
        :param pulumi.Input[str] tenant_id: The tenant ID of resource.
        :param pulumi.Input[Union[str, 'IdentityType']] type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        :param pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]] user_assigned_identities: The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
               This property is currently not used and reserved for future usage.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'IdentityType']]]:
        """
        The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'IdentityType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]:
        """
        The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form:
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        This property is currently not used and reserved for future usage.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class InboundIpRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[Union[str, 'IpActionType']]] = None,
                 ip_mask: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Union[str, 'IpActionType']] action: Action to perform based on the match or no match of the IpMask.
        :param pulumi.Input[str] ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_mask is not None:
            pulumi.set(__self__, "ip_mask", ip_mask)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'IpActionType']]]:
        """
        Action to perform based on the match or no match of the IpMask.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'IpActionType']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address in CIDR notation e.g., 10.0.0.0/8.
        """
        return pulumi.get(self, "ip_mask")

    @ip_mask.setter
    def ip_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mask", value)


@pulumi.input_type
class IsNotNullAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        IsNotNull Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'IsNotNull'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        """
        pulumi.set(__self__, "operator_type", 'IsNotNull')
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'IsNotNull'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class IsNullOrUndefinedAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        IsNullOrUndefined Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'IsNullOrUndefined'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        """
        pulumi.set(__self__, "operator_type", 'IsNullOrUndefined')
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'IsNullOrUndefined'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class JsonFieldWithDefaultArgs:
    def __init__(__self__, *,
                 default_value: Optional[pulumi.Input[str]] = None,
                 source_field: Optional[pulumi.Input[str]] = None):
        """
        This is used to express the source of an input schema mapping for a single target field
        in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
        'eventtype' and 'dataversion' properties. This represents a field in the input event schema
        along with a default value to be used, and at least one of these two properties should be provided.
        :param pulumi.Input[str] default_value: The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
        :param pulumi.Input[str] source_field: Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        return pulumi.get(self, "source_field")

    @source_field.setter
    def source_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_field", value)


@pulumi.input_type
class JsonFieldArgs:
    def __init__(__self__, *,
                 source_field: Optional[pulumi.Input[str]] = None):
        """
        This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.
        :param pulumi.Input[str] source_field: Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        if source_field is not None:
            pulumi.set(__self__, "source_field", source_field)

    @property
    @pulumi.getter(name="sourceField")
    def source_field(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a field in the input event schema that's to be used as the source of a mapping.
        """
        return pulumi.get(self, "source_field")

    @source_field.setter
    def source_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_field", value)


@pulumi.input_type
class JsonInputSchemaMappingArgs:
    def __init__(__self__, *,
                 input_schema_mapping_type: pulumi.Input[str],
                 data_version: Optional[pulumi.Input['JsonFieldWithDefaultArgs']] = None,
                 event_time: Optional[pulumi.Input['JsonFieldArgs']] = None,
                 event_type: Optional[pulumi.Input['JsonFieldWithDefaultArgs']] = None,
                 id: Optional[pulumi.Input['JsonFieldArgs']] = None,
                 subject: Optional[pulumi.Input['JsonFieldWithDefaultArgs']] = None,
                 topic: Optional[pulumi.Input['JsonFieldArgs']] = None):
        """
        This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.
        :param pulumi.Input[str] input_schema_mapping_type: Type of the custom mapping
               Expected value is 'Json'.
        :param pulumi.Input['JsonFieldWithDefaultArgs'] data_version: The mapping information for the DataVersion property of the Event Grid Event.
        :param pulumi.Input['JsonFieldArgs'] event_time: The mapping information for the EventTime property of the Event Grid Event.
        :param pulumi.Input['JsonFieldWithDefaultArgs'] event_type: The mapping information for the EventType property of the Event Grid Event.
        :param pulumi.Input['JsonFieldArgs'] id: The mapping information for the Id property of the Event Grid Event.
        :param pulumi.Input['JsonFieldWithDefaultArgs'] subject: The mapping information for the Subject property of the Event Grid Event.
        :param pulumi.Input['JsonFieldArgs'] topic: The mapping information for the Topic property of the Event Grid Event.
        """
        pulumi.set(__self__, "input_schema_mapping_type", 'Json')
        if data_version is not None:
            pulumi.set(__self__, "data_version", data_version)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="inputSchemaMappingType")
    def input_schema_mapping_type(self) -> pulumi.Input[str]:
        """
        Type of the custom mapping
        Expected value is 'Json'.
        """
        return pulumi.get(self, "input_schema_mapping_type")

    @input_schema_mapping_type.setter
    def input_schema_mapping_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_schema_mapping_type", value)

    @property
    @pulumi.getter(name="dataVersion")
    def data_version(self) -> Optional[pulumi.Input['JsonFieldWithDefaultArgs']]:
        """
        The mapping information for the DataVersion property of the Event Grid Event.
        """
        return pulumi.get(self, "data_version")

    @data_version.setter
    def data_version(self, value: Optional[pulumi.Input['JsonFieldWithDefaultArgs']]):
        pulumi.set(self, "data_version", value)

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[pulumi.Input['JsonFieldArgs']]:
        """
        The mapping information for the EventTime property of the Event Grid Event.
        """
        return pulumi.get(self, "event_time")

    @event_time.setter
    def event_time(self, value: Optional[pulumi.Input['JsonFieldArgs']]):
        pulumi.set(self, "event_time", value)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input['JsonFieldWithDefaultArgs']]:
        """
        The mapping information for the EventType property of the Event Grid Event.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input['JsonFieldWithDefaultArgs']]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input['JsonFieldArgs']]:
        """
        The mapping information for the Id property of the Event Grid Event.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input['JsonFieldArgs']]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input['JsonFieldWithDefaultArgs']]:
        """
        The mapping information for the Subject property of the Event Grid Event.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input['JsonFieldWithDefaultArgs']]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input['JsonFieldArgs']]:
        """
        The mapping information for the Topic property of the Event Grid Event.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input['JsonFieldArgs']]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class NumberGreaterThanAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        NumberGreaterThan Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberGreaterThan'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[float] value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberGreaterThan')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberGreaterThan'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NumberGreaterThanOrEqualsAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        NumberGreaterThanOrEquals Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberGreaterThanOrEquals'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[float] value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberGreaterThanOrEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberGreaterThanOrEquals'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NumberInAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None):
        """
        NumberIn Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberIn'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberIn'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class NumberInRangeAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]]] = None):
        """
        NumberInRange Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberInRange'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberInRange')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberInRange'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class NumberLessThanAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        NumberLessThan Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberLessThan'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[float] value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberLessThan')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberLessThan'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NumberLessThanOrEqualsAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        NumberLessThanOrEquals Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberLessThanOrEquals'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[float] value: The filter value.
        """
        pulumi.set(__self__, "operator_type", 'NumberLessThanOrEquals')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberLessThanOrEquals'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        The filter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class NumberNotInAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None):
        """
        NumberNotIn Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberNotIn'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberNotIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberNotIn'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class NumberNotInRangeAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]]] = None):
        """
        NumberNotInRange Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'NumberNotInRange'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'NumberNotInRange')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'NumberNotInRange'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[float]]]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        PrivateEndpoint information.
        :param pulumi.Input[str] id: The ARM identifier for Private Endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM identifier for Private Endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RetryPolicyArgs:
    def __init__(__self__, *,
                 event_time_to_live_in_minutes: Optional[pulumi.Input[int]] = None,
                 max_delivery_attempts: Optional[pulumi.Input[int]] = None):
        """
        Information about the retry policy for an event subscription.
        :param pulumi.Input[int] event_time_to_live_in_minutes: Time To Live (in minutes) for events.
        :param pulumi.Input[int] max_delivery_attempts: Maximum number of delivery retry attempts for events.
        """
        if event_time_to_live_in_minutes is not None:
            pulumi.set(__self__, "event_time_to_live_in_minutes", event_time_to_live_in_minutes)
        if max_delivery_attempts is not None:
            pulumi.set(__self__, "max_delivery_attempts", max_delivery_attempts)

    @property
    @pulumi.getter(name="eventTimeToLiveInMinutes")
    def event_time_to_live_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Time To Live (in minutes) for events.
        """
        return pulumi.get(self, "event_time_to_live_in_minutes")

    @event_time_to_live_in_minutes.setter
    def event_time_to_live_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "event_time_to_live_in_minutes", value)

    @property
    @pulumi.getter(name="maxDeliveryAttempts")
    def max_delivery_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of delivery retry attempts for events.
        """
        return pulumi.get(self, "max_delivery_attempts")

    @max_delivery_attempts.setter
    def max_delivery_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_delivery_attempts", value)


@pulumi.input_type
class ServiceBusQueueEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the service bus destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'ServiceBusQueue'.
        :param pulumi.Input[str] resource_id: The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'ServiceBusQueue')
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'ServiceBusQueue'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource Id that represents the endpoint of the Service Bus destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ServiceBusTopicEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the service bus topic destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'ServiceBusTopic'.
        :param pulumi.Input[str] resource_id: The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'ServiceBusTopic')
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'ServiceBusTopic'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource Id that represents the endpoint of the Service Bus Topic destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class StorageBlobDeadLetterDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 blob_container_name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the storage blob based dead letter destination.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the dead letter destination
               Expected value is 'StorageBlob'.
        :param pulumi.Input[str] blob_container_name: The name of the Storage blob container that is the destination of the deadletter events
        :param pulumi.Input[str] resource_id: The Azure Resource ID of the storage account that is the destination of the deadletter events
        """
        pulumi.set(__self__, "endpoint_type", 'StorageBlob')
        if blob_container_name is not None:
            pulumi.set(__self__, "blob_container_name", blob_container_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the dead letter destination
        Expected value is 'StorageBlob'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="blobContainerName")
    def blob_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Storage blob container that is the destination of the deadletter events
        """
        return pulumi.get(self, "blob_container_name")

    @blob_container_name.setter
    def blob_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_container_name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource ID of the storage account that is the destination of the deadletter events
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class StorageQueueEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 queue_name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Information about the storage queue destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'StorageQueue'.
        :param pulumi.Input[str] queue_name: The name of the Storage queue under a storage account that is the destination of an event subscription.
        :param pulumi.Input[str] resource_id: The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
        """
        pulumi.set(__self__, "endpoint_type", 'StorageQueue')
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'StorageQueue'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Storage queue under a storage account that is the destination of an event subscription.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class StringBeginsWithAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringBeginsWith Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringBeginsWith'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringBeginsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringBeginsWith'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringContainsAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringContains Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringContains'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringContains')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringContains'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringEndsWithAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringEndsWith Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringEndsWith'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringEndsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringEndsWith'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringInAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringIn Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringIn'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringIn'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringNotBeginsWithAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringNotBeginsWith Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotBeginsWith'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotBeginsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotBeginsWith'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringNotContainsAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringNotContains Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotContains'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotContains')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotContains'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringNotEndsWithAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringNotEndsWith Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotEndsWith'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotEndsWith')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotEndsWith'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class StringNotInAdvancedFilterArgs:
    def __init__(__self__, *,
                 operator_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StringNotIn Advanced Filter.
        :param pulumi.Input[str] operator_type: The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
               Expected value is 'StringNotIn'.
        :param pulumi.Input[str] key: The field/property in the event based on which you want to filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The set of filter values.
        """
        pulumi.set(__self__, "operator_type", 'StringNotIn')
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="operatorType")
    def operator_type(self) -> pulumi.Input[str]:
        """
        The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
        Expected value is 'StringNotIn'.
        """
        return pulumi.get(self, "operator_type")

    @operator_type.setter
    def operator_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The field/property in the event based on which you want to filter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of filter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class UserIdentityPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        """
        The information about the user identity.
        :param pulumi.Input[str] client_id: The client id of user assigned identity.
        :param pulumi.Input[str] principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class WebHookEventSubscriptionDestinationArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[str],
                 azure_active_directory_application_id_or_uri: Optional[pulumi.Input[str]] = None,
                 azure_active_directory_tenant_id: Optional[pulumi.Input[str]] = None,
                 endpoint_url: Optional[pulumi.Input[str]] = None,
                 max_events_per_batch: Optional[pulumi.Input[int]] = None,
                 preferred_batch_size_in_kilobytes: Optional[pulumi.Input[int]] = None):
        """
        Information about the webhook destination for an event subscription.
        :param pulumi.Input[str] endpoint_type: Type of the endpoint for the event subscription destination.
               Expected value is 'WebHook'.
        :param pulumi.Input[str] azure_active_directory_application_id_or_uri: The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        :param pulumi.Input[str] azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        :param pulumi.Input[str] endpoint_url: The URL that represents the endpoint of the destination of an event subscription.
        :param pulumi.Input[int] max_events_per_batch: Maximum number of events per batch.
        :param pulumi.Input[int] preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
        """
        pulumi.set(__self__, "endpoint_type", 'WebHook')
        if azure_active_directory_application_id_or_uri is not None:
            pulumi.set(__self__, "azure_active_directory_application_id_or_uri", azure_active_directory_application_id_or_uri)
        if azure_active_directory_tenant_id is not None:
            pulumi.set(__self__, "azure_active_directory_tenant_id", azure_active_directory_tenant_id)
        if endpoint_url is not None:
            pulumi.set(__self__, "endpoint_url", endpoint_url)
        if max_events_per_batch is None:
            max_events_per_batch = 1
        if max_events_per_batch is not None:
            pulumi.set(__self__, "max_events_per_batch", max_events_per_batch)
        if preferred_batch_size_in_kilobytes is None:
            preferred_batch_size_in_kilobytes = 64
        if preferred_batch_size_in_kilobytes is not None:
            pulumi.set(__self__, "preferred_batch_size_in_kilobytes", preferred_batch_size_in_kilobytes)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[str]:
        """
        Type of the endpoint for the event subscription destination.
        Expected value is 'WebHook'.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="azureActiveDirectoryApplicationIdOrUri")
    def azure_active_directory_application_id_or_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "azure_active_directory_application_id_or_uri")

    @azure_active_directory_application_id_or_uri.setter
    def azure_active_directory_application_id_or_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_active_directory_application_id_or_uri", value)

    @property
    @pulumi.getter(name="azureActiveDirectoryTenantId")
    def azure_active_directory_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
        """
        return pulumi.get(self, "azure_active_directory_tenant_id")

    @azure_active_directory_tenant_id.setter
    def azure_active_directory_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_active_directory_tenant_id", value)

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that represents the endpoint of the destination of an event subscription.
        """
        return pulumi.get(self, "endpoint_url")

    @endpoint_url.setter
    def endpoint_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_url", value)

    @property
    @pulumi.getter(name="maxEventsPerBatch")
    def max_events_per_batch(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of events per batch.
        """
        return pulumi.get(self, "max_events_per_batch")

    @max_events_per_batch.setter
    def max_events_per_batch(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_events_per_batch", value)

    @property
    @pulumi.getter(name="preferredBatchSizeInKilobytes")
    def preferred_batch_size_in_kilobytes(self) -> Optional[pulumi.Input[int]]:
        """
        Preferred batch size in Kilobytes.
        """
        return pulumi.get(self, "preferred_batch_size_in_kilobytes")

    @preferred_batch_size_in_kilobytes.setter
    def preferred_batch_size_in_kilobytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "preferred_batch_size_in_kilobytes", value)


