# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AADAppResponse',
    'BackupResponse',
    'DBServerMetadataResponse',
    'HighAvailabilityResponse',
    'IdentityResponse',
    'MaintenanceWindowResponse',
    'MigrationResourceGroupResponse',
    'MigrationSecretParametersResponse',
    'MigrationStatusResponse',
    'MigrationSubStateDetailsResponse',
    'NetworkResponse',
    'ServerSkuResponse',
    'SkuResponse',
    'StorageResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AADAppResponse(dict):
    """
    Azure active directory application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AADAppResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AADAppResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AADAppResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 tenant_id: str):
        """
        Azure active directory application.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class BackupResponse(dict):
    """
    Backup properties of a server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "earliestRestoreDate":
            suggest = "earliest_restore_date"
        elif key == "backupRetentionDays":
            suggest = "backup_retention_days"
        elif key == "geoRedundantBackup":
            suggest = "geo_redundant_backup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 earliest_restore_date: str,
                 backup_retention_days: Optional[int] = None,
                 geo_redundant_backup: Optional[str] = None):
        """
        Backup properties of a server
        :param str earliest_restore_date: The earliest restore point time (ISO8601 format) for server.
        :param int backup_retention_days: Backup retention days for the server.
        :param str geo_redundant_backup: A value indicating whether Geo-Redundant backup is enabled on the server.
        """
        pulumi.set(__self__, "earliest_restore_date", earliest_restore_date)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if geo_redundant_backup is not None:
            pulumi.set(__self__, "geo_redundant_backup", geo_redundant_backup)

    @property
    @pulumi.getter(name="earliestRestoreDate")
    def earliest_restore_date(self) -> str:
        """
        The earliest restore point time (ISO8601 format) for server.
        """
        return pulumi.get(self, "earliest_restore_date")

    @property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[int]:
        """
        Backup retention days for the server.
        """
        return pulumi.get(self, "backup_retention_days")

    @property
    @pulumi.getter(name="geoRedundantBackup")
    def geo_redundant_backup(self) -> Optional[str]:
        """
        A value indicating whether Geo-Redundant backup is enabled on the server.
        """
        return pulumi.get(self, "geo_redundant_backup")


@pulumi.output_type
class DBServerMetadataResponse(dict):
    """
    Database server metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageMB":
            suggest = "storage_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DBServerMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DBServerMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DBServerMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: Optional[str] = None,
                 sku: Optional['outputs.ServerSkuResponse'] = None,
                 storage_mb: Optional[int] = None,
                 version: Optional[str] = None):
        """
        Database server metadata.
        :param 'ServerSkuResponse' sku: Sku information related properties of a server.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if storage_mb is not None:
            pulumi.set(__self__, "storage_mb", storage_mb)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.ServerSkuResponse']:
        """
        Sku information related properties of a server.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="storageMB")
    def storage_mb(self) -> Optional[int]:
        return pulumi.get(self, "storage_mb")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class HighAvailabilityResponse(dict):
    """
    High availability properties of a server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standbyAvailabilityZone":
            suggest = "standby_availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HighAvailabilityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HighAvailabilityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HighAvailabilityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 mode: Optional[str] = None,
                 standby_availability_zone: Optional[str] = None):
        """
        High availability properties of a server
        :param str state: A state of a HA server that is visible to user.
        :param str mode: The HA mode for the server.
        :param str standby_availability_zone: availability zone information of the standby.
        """
        pulumi.set(__self__, "state", state)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if standby_availability_zone is not None:
            pulumi.set(__self__, "standby_availability_zone", standby_availability_zone)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A state of a HA server that is visible to user.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        The HA mode for the server.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="standbyAvailabilityZone")
    def standby_availability_zone(self) -> Optional[str]:
        """
        availability zone information of the standby.
        """
        return pulumi.get(self, "standby_availability_zone")


@pulumi.output_type
class IdentityResponse(dict):
    """
    Identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None):
        """
        Identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MaintenanceWindowResponse(dict):
    """
    Maintenance window properties of a server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customWindow":
            suggest = "custom_window"
        elif key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMinute":
            suggest = "start_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_window: Optional[str] = None,
                 day_of_week: Optional[int] = None,
                 start_hour: Optional[int] = None,
                 start_minute: Optional[int] = None):
        """
        Maintenance window properties of a server.
        :param str custom_window: indicates whether custom window is enabled or disabled
        :param int day_of_week: day of week for maintenance window
        :param int start_hour: start hour for maintenance window
        :param int start_minute: start minute for maintenance window
        """
        if custom_window is not None:
            pulumi.set(__self__, "custom_window", custom_window)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @property
    @pulumi.getter(name="customWindow")
    def custom_window(self) -> Optional[str]:
        """
        indicates whether custom window is enabled or disabled
        """
        return pulumi.get(self, "custom_window")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[int]:
        """
        day of week for maintenance window
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[int]:
        """
        start hour for maintenance window
        """
        return pulumi.get(self, "start_hour")

    @property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[int]:
        """
        start minute for maintenance window
        """
        return pulumi.get(self, "start_minute")


@pulumi.output_type
class MigrationResourceGroupResponse(dict):
    """
    Migration resource group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "subnetResourceId":
            suggest = "subnet_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationResourceGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationResourceGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationResourceGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[str] = None,
                 subnet_resource_id: Optional[str] = None):
        """
        Migration resource group.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[str]:
        return pulumi.get(self, "subnet_resource_id")


@pulumi.output_type
class MigrationSecretParametersResponse(dict):
    """
    Migration secret parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadApp":
            suggest = "aad_app"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationSecretParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationSecretParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationSecretParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_app: 'outputs.AADAppResponse'):
        """
        Migration secret parameters.
        :param 'AADAppResponse' aad_app: Azure active directory application.
        """
        pulumi.set(__self__, "aad_app", aad_app)

    @property
    @pulumi.getter(name="aadApp")
    def aad_app(self) -> 'outputs.AADAppResponse':
        """
        Azure active directory application.
        """
        return pulumi.get(self, "aad_app")


@pulumi.output_type
class MigrationStatusResponse(dict):
    """
    Migration status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentSubStateDetails":
            suggest = "current_sub_state_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_sub_state_details: 'outputs.MigrationSubStateDetailsResponse',
                 error: str,
                 state: str):
        """
        Migration status.
        :param 'MigrationSubStateDetailsResponse' current_sub_state_details: Migration sub state details.
        :param str state: Migration state.
        """
        pulumi.set(__self__, "current_sub_state_details", current_sub_state_details)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="currentSubStateDetails")
    def current_sub_state_details(self) -> 'outputs.MigrationSubStateDetailsResponse':
        """
        Migration sub state details.
        """
        return pulumi.get(self, "current_sub_state_details")

    @property
    @pulumi.getter
    def error(self) -> str:
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Migration state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class MigrationSubStateDetailsResponse(dict):
    """
    Migration sub state details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentSubState":
            suggest = "current_sub_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationSubStateDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationSubStateDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationSubStateDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_sub_state: str):
        """
        Migration sub state details.
        :param str current_sub_state: Migration sub state.
        """
        pulumi.set(__self__, "current_sub_state", current_sub_state)

    @property
    @pulumi.getter(name="currentSubState")
    def current_sub_state(self) -> str:
        """
        Migration sub state.
        """
        return pulumi.get(self, "current_sub_state")


@pulumi.output_type
class NetworkResponse(dict):
    """
    Network properties of a server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "delegatedSubnetResourceId":
            suggest = "delegated_subnet_resource_id"
        elif key == "privateDnsZoneArmResourceId":
            suggest = "private_dns_zone_arm_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_network_access: str,
                 delegated_subnet_resource_id: Optional[str] = None,
                 private_dns_zone_arm_resource_id: Optional[str] = None):
        """
        Network properties of a server
        :param str public_network_access: public network access is enabled or not
        :param str delegated_subnet_resource_id: delegated subnet arm resource id.
        :param str private_dns_zone_arm_resource_id: private dns zone arm resource id.
        """
        pulumi.set(__self__, "public_network_access", public_network_access)
        if delegated_subnet_resource_id is not None:
            pulumi.set(__self__, "delegated_subnet_resource_id", delegated_subnet_resource_id)
        if private_dns_zone_arm_resource_id is not None:
            pulumi.set(__self__, "private_dns_zone_arm_resource_id", private_dns_zone_arm_resource_id)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> str:
        """
        public network access is enabled or not
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="delegatedSubnetResourceId")
    def delegated_subnet_resource_id(self) -> Optional[str]:
        """
        delegated subnet arm resource id.
        """
        return pulumi.get(self, "delegated_subnet_resource_id")

    @property
    @pulumi.getter(name="privateDnsZoneArmResourceId")
    def private_dns_zone_arm_resource_id(self) -> Optional[str]:
        """
        private dns zone arm resource id.
        """
        return pulumi.get(self, "private_dns_zone_arm_resource_id")


@pulumi.output_type
class ServerSkuResponse(dict):
    """
    Sku information related properties of a server.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        Sku information related properties of a server.
        :param str name: The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        :param str tier: The tier of the particular SKU, e.g. Burstable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The tier of the particular SKU, e.g. Burstable.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SkuResponse(dict):
    """
    Sku information related properties of a server.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        Sku information related properties of a server.
        :param str name: The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        :param str tier: The tier of the particular SKU, e.g. Burstable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the sku, typically, tier + family + cores, e.g. Standard_D4s_v3.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The tier of the particular SKU, e.g. Burstable.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class StorageResponse(dict):
    """
    Storage properties of a server
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageSizeGB":
            suggest = "storage_size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_size_gb: Optional[int] = None):
        """
        Storage properties of a server
        :param int storage_size_gb: Max storage allowed for a server.
        """
        if storage_size_gb is not None:
            pulumi.set(__self__, "storage_size_gb", storage_size_gb)

    @property
    @pulumi.getter(name="storageSizeGB")
    def storage_size_gb(self) -> Optional[int]:
        """
        Max storage allowed for a server.
        """
        return pulumi.get(self, "storage_size_gb")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


