# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRelationshipLinkResult',
    'AwaitableGetRelationshipLinkResult',
    'get_relationship_link',
]

@pulumi.output_type
class GetRelationshipLinkResult:
    """
    The relationship link resource format.
    """
    def __init__(__self__, description=None, display_name=None, id=None, interaction_type=None, link_name=None, mappings=None, name=None, profile_property_references=None, provisioning_state=None, related_profile_property_references=None, relationship_guid_id=None, relationship_name=None, tenant_id=None, type=None):
        if description and not isinstance(description, dict):
            raise TypeError("Expected argument 'description' to be a dict")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, dict):
            raise TypeError("Expected argument 'display_name' to be a dict")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interaction_type and not isinstance(interaction_type, str):
            raise TypeError("Expected argument 'interaction_type' to be a str")
        pulumi.set(__self__, "interaction_type", interaction_type)
        if link_name and not isinstance(link_name, str):
            raise TypeError("Expected argument 'link_name' to be a str")
        pulumi.set(__self__, "link_name", link_name)
        if mappings and not isinstance(mappings, list):
            raise TypeError("Expected argument 'mappings' to be a list")
        pulumi.set(__self__, "mappings", mappings)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if profile_property_references and not isinstance(profile_property_references, list):
            raise TypeError("Expected argument 'profile_property_references' to be a list")
        pulumi.set(__self__, "profile_property_references", profile_property_references)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if related_profile_property_references and not isinstance(related_profile_property_references, list):
            raise TypeError("Expected argument 'related_profile_property_references' to be a list")
        pulumi.set(__self__, "related_profile_property_references", related_profile_property_references)
        if relationship_guid_id and not isinstance(relationship_guid_id, str):
            raise TypeError("Expected argument 'relationship_guid_id' to be a str")
        pulumi.set(__self__, "relationship_guid_id", relationship_guid_id)
        if relationship_name and not isinstance(relationship_name, str):
            raise TypeError("Expected argument 'relationship_name' to be a str")
        pulumi.set(__self__, "relationship_name", relationship_name)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[Mapping[str, str]]:
        """
        Localized descriptions for the Relationship Link.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[Mapping[str, str]]:
        """
        Localized display name for the Relationship Link.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interactionType")
    def interaction_type(self) -> str:
        """
        The InteractionType associated with the Relationship Link.
        """
        return pulumi.get(self, "interaction_type")

    @property
    @pulumi.getter(name="linkName")
    def link_name(self) -> str:
        """
        The name of the Relationship Link.
        """
        return pulumi.get(self, "link_name")

    @property
    @pulumi.getter
    def mappings(self) -> Optional[Sequence['outputs.RelationshipLinkFieldMappingResponse']]:
        """
        The mappings between Interaction and Relationship fields.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="profilePropertyReferences")
    def profile_property_references(self) -> Sequence['outputs.ParticipantProfilePropertyReferenceResponse']:
        """
        The property references for the Profile of the Relationship.
        """
        return pulumi.get(self, "profile_property_references")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="relatedProfilePropertyReferences")
    def related_profile_property_references(self) -> Sequence['outputs.ParticipantProfilePropertyReferenceResponse']:
        """
        The property references for the Related Profile of the Relationship.
        """
        return pulumi.get(self, "related_profile_property_references")

    @property
    @pulumi.getter(name="relationshipGuidId")
    def relationship_guid_id(self) -> str:
        """
        The relationship guid id.
        """
        return pulumi.get(self, "relationship_guid_id")

    @property
    @pulumi.getter(name="relationshipName")
    def relationship_name(self) -> str:
        """
        The Relationship associated with the Link.
        """
        return pulumi.get(self, "relationship_name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The hub name.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetRelationshipLinkResult(GetRelationshipLinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRelationshipLinkResult(
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            interaction_type=self.interaction_type,
            link_name=self.link_name,
            mappings=self.mappings,
            name=self.name,
            profile_property_references=self.profile_property_references,
            provisioning_state=self.provisioning_state,
            related_profile_property_references=self.related_profile_property_references,
            relationship_guid_id=self.relationship_guid_id,
            relationship_name=self.relationship_name,
            tenant_id=self.tenant_id,
            type=self.type)


def get_relationship_link(hub_name: Optional[str] = None,
                          relationship_link_name: Optional[str] = None,
                          resource_group_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRelationshipLinkResult:
    """
    The relationship link resource format.


    :param str hub_name: The name of the hub.
    :param str relationship_link_name: The name of the relationship link.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['hubName'] = hub_name
    __args__['relationshipLinkName'] = relationship_link_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:customerinsights/v20170426:getRelationshipLink', __args__, opts=opts, typ=GetRelationshipLinkResult).value

    return AwaitableGetRelationshipLinkResult(
        description=__ret__.description,
        display_name=__ret__.display_name,
        id=__ret__.id,
        interaction_type=__ret__.interaction_type,
        link_name=__ret__.link_name,
        mappings=__ret__.mappings,
        name=__ret__.name,
        profile_property_references=__ret__.profile_property_references,
        provisioning_state=__ret__.provisioning_state,
        related_profile_property_references=__ret__.related_profile_property_references,
        relationship_guid_id=__ret__.relationship_guid_id,
        relationship_name=__ret__.relationship_name,
        tenant_id=__ret__.tenant_id,
        type=__ret__.type)
