# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConnectorMappingArgs', 'ConnectorMapping']

@pulumi.input_type
class ConnectorMappingArgs:
    def __init__(__self__, *,
                 connector_name: pulumi.Input[str],
                 entity_type: pulumi.Input['EntityTypes'],
                 entity_type_name: pulumi.Input[str],
                 hub_name: pulumi.Input[str],
                 mapping_properties: pulumi.Input['ConnectorMappingPropertiesArgs'],
                 resource_group_name: pulumi.Input[str],
                 connector_type: Optional[pulumi.Input[Union[str, 'ConnectorTypes']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 mapping_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConnectorMapping resource.
        :param pulumi.Input[str] connector_name: The name of the connector.
        :param pulumi.Input['EntityTypes'] entity_type: Defines which entity type the file should map to.
        :param pulumi.Input[str] entity_type_name: The mapping entity name.
        :param pulumi.Input[str] hub_name: The name of the hub.
        :param pulumi.Input['ConnectorMappingPropertiesArgs'] mapping_properties: The properties of the mapping.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[Union[str, 'ConnectorTypes']] connector_type: Type of connector.
        :param pulumi.Input[str] description: The description of the connector mapping.
        :param pulumi.Input[str] display_name: Display name for the connector mapping.
        :param pulumi.Input[str] mapping_name: The name of the connector mapping.
        """
        pulumi.set(__self__, "connector_name", connector_name)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "entity_type_name", entity_type_name)
        pulumi.set(__self__, "hub_name", hub_name)
        pulumi.set(__self__, "mapping_properties", mapping_properties)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if connector_type is not None:
            pulumi.set(__self__, "connector_type", connector_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if mapping_name is not None:
            pulumi.set(__self__, "mapping_name", mapping_name)

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> pulumi.Input[str]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "connector_name")

    @connector_name.setter
    def connector_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector_name", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input['EntityTypes']:
        """
        Defines which entity type the file should map to.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input['EntityTypes']):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> pulumi.Input[str]:
        """
        The mapping entity name.
        """
        return pulumi.get(self, "entity_type_name")

    @entity_type_name.setter
    def entity_type_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type_name", value)

    @property
    @pulumi.getter(name="hubName")
    def hub_name(self) -> pulumi.Input[str]:
        """
        The name of the hub.
        """
        return pulumi.get(self, "hub_name")

    @hub_name.setter
    def hub_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "hub_name", value)

    @property
    @pulumi.getter(name="mappingProperties")
    def mapping_properties(self) -> pulumi.Input['ConnectorMappingPropertiesArgs']:
        """
        The properties of the mapping.
        """
        return pulumi.get(self, "mapping_properties")

    @mapping_properties.setter
    def mapping_properties(self, value: pulumi.Input['ConnectorMappingPropertiesArgs']):
        pulumi.set(self, "mapping_properties", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[Union[str, 'ConnectorTypes']]]:
        """
        Type of connector.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[Union[str, 'ConnectorTypes']]]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the connector mapping.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name for the connector mapping.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="mappingName")
    def mapping_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connector mapping.
        """
        return pulumi.get(self, "mapping_name")

    @mapping_name.setter
    def mapping_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mapping_name", value)


class ConnectorMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_name: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[Union[str, 'ConnectorTypes']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input['EntityTypes']] = None,
                 entity_type_name: Optional[pulumi.Input[str]] = None,
                 hub_name: Optional[pulumi.Input[str]] = None,
                 mapping_name: Optional[pulumi.Input[str]] = None,
                 mapping_properties: Optional[pulumi.Input[pulumi.InputType['ConnectorMappingPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The connector mapping resource format.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connector_name: The name of the connector.
        :param pulumi.Input[Union[str, 'ConnectorTypes']] connector_type: Type of connector.
        :param pulumi.Input[str] description: The description of the connector mapping.
        :param pulumi.Input[str] display_name: Display name for the connector mapping.
        :param pulumi.Input['EntityTypes'] entity_type: Defines which entity type the file should map to.
        :param pulumi.Input[str] entity_type_name: The mapping entity name.
        :param pulumi.Input[str] hub_name: The name of the hub.
        :param pulumi.Input[str] mapping_name: The name of the connector mapping.
        :param pulumi.Input[pulumi.InputType['ConnectorMappingPropertiesArgs']] mapping_properties: The properties of the mapping.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The connector mapping resource format.

        :param str resource_name: The name of the resource.
        :param ConnectorMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connector_name: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[Union[str, 'ConnectorTypes']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input['EntityTypes']] = None,
                 entity_type_name: Optional[pulumi.Input[str]] = None,
                 hub_name: Optional[pulumi.Input[str]] = None,
                 mapping_name: Optional[pulumi.Input[str]] = None,
                 mapping_properties: Optional[pulumi.Input[pulumi.InputType['ConnectorMappingPropertiesArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorMappingArgs.__new__(ConnectorMappingArgs)

            if connector_name is None and not opts.urn:
                raise TypeError("Missing required property 'connector_name'")
            __props__.__dict__["connector_name"] = connector_name
            __props__.__dict__["connector_type"] = connector_type
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            if entity_type_name is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type_name'")
            __props__.__dict__["entity_type_name"] = entity_type_name
            if hub_name is None and not opts.urn:
                raise TypeError("Missing required property 'hub_name'")
            __props__.__dict__["hub_name"] = hub_name
            __props__.__dict__["mapping_name"] = mapping_name
            if mapping_properties is None and not opts.urn:
                raise TypeError("Missing required property 'mapping_properties'")
            __props__.__dict__["mapping_properties"] = mapping_properties
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["connector_mapping_name"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["data_format_id"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["next_run_time"] = None
            __props__.__dict__["run_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:customerinsights/v20170101:ConnectorMapping"), pulumi.Alias(type_="azure-native:customerinsights:ConnectorMapping"), pulumi.Alias(type_="azure-nextgen:customerinsights:ConnectorMapping"), pulumi.Alias(type_="azure-native:customerinsights/v20170426:ConnectorMapping"), pulumi.Alias(type_="azure-nextgen:customerinsights/v20170426:ConnectorMapping")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ConnectorMapping, __self__).__init__(
            'azure-native:customerinsights/v20170101:ConnectorMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConnectorMapping':
        """
        Get an existing ConnectorMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConnectorMappingArgs.__new__(ConnectorMappingArgs)

        __props__.__dict__["connector_mapping_name"] = None
        __props__.__dict__["connector_name"] = None
        __props__.__dict__["connector_type"] = None
        __props__.__dict__["created"] = None
        __props__.__dict__["data_format_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["entity_type"] = None
        __props__.__dict__["entity_type_name"] = None
        __props__.__dict__["last_modified"] = None
        __props__.__dict__["mapping_properties"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["next_run_time"] = None
        __props__.__dict__["run_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tenant_id"] = None
        __props__.__dict__["type"] = None
        return ConnectorMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectorMappingName")
    def connector_mapping_name(self) -> pulumi.Output[str]:
        """
        The connector mapping name
        """
        return pulumi.get(self, "connector_mapping_name")

    @property
    @pulumi.getter(name="connectorName")
    def connector_name(self) -> pulumi.Output[str]:
        """
        The connector name.
        """
        return pulumi.get(self, "connector_name")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of connector.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        The created time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="dataFormatId")
    def data_format_id(self) -> pulumi.Output[str]:
        """
        The DataFormat ID.
        """
        return pulumi.get(self, "data_format_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the connector mapping.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Display name for the connector mapping.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[str]:
        """
        Defines which entity type the file should map to.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> pulumi.Output[str]:
        """
        The mapping entity name.
        """
        return pulumi.get(self, "entity_type_name")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        The last modified time.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter(name="mappingProperties")
    def mapping_properties(self) -> pulumi.Output['outputs.ConnectorMappingPropertiesResponse']:
        """
        The properties of the mapping.
        """
        return pulumi.get(self, "mapping_properties")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextRunTime")
    def next_run_time(self) -> pulumi.Output[str]:
        """
        The next run time based on customer's settings.
        """
        return pulumi.get(self, "next_run_time")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> pulumi.Output[str]:
        """
        The RunId.
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of connector mapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The hub name.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

