# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CostAllocationProportionResponse',
    'CostAllocationRuleDetailsResponse',
    'CostAllocationRulePropertiesResponse',
    'SourceCostAllocationResourceResponse',
    'TargetCostAllocationResourceResponse',
]

@pulumi.output_type
class CostAllocationProportionResponse(dict):
    """
    Target resources and allocation
    """
    def __init__(__self__, *,
                 name: str,
                 percentage: float):
        """
        Target resources and allocation
        :param str name: Target resource for cost allocation
        :param float percentage: Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "percentage", percentage)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Target resource for cost allocation
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def percentage(self) -> float:
        """
        Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
        """
        return pulumi.get(self, "percentage")


@pulumi.output_type
class CostAllocationRuleDetailsResponse(dict):
    """
    Resource details of the cost allocation rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceResources":
            suggest = "source_resources"
        elif key == "targetResources":
            suggest = "target_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CostAllocationRuleDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CostAllocationRuleDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CostAllocationRuleDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_resources: Optional[Sequence['outputs.SourceCostAllocationResourceResponse']] = None,
                 target_resources: Optional[Sequence['outputs.TargetCostAllocationResourceResponse']] = None):
        """
        Resource details of the cost allocation rule
        :param Sequence['SourceCostAllocationResourceResponse'] source_resources: Source resources for cost allocation. At this time, this list can contain no more than one element.
        :param Sequence['TargetCostAllocationResourceResponse'] target_resources: Target resources for cost allocation. At this time, this list can contain no more than one element.
        """
        if source_resources is not None:
            pulumi.set(__self__, "source_resources", source_resources)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)

    @property
    @pulumi.getter(name="sourceResources")
    def source_resources(self) -> Optional[Sequence['outputs.SourceCostAllocationResourceResponse']]:
        """
        Source resources for cost allocation. At this time, this list can contain no more than one element.
        """
        return pulumi.get(self, "source_resources")

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[Sequence['outputs.TargetCostAllocationResourceResponse']]:
        """
        Target resources for cost allocation. At this time, this list can contain no more than one element.
        """
        return pulumi.get(self, "target_resources")


@pulumi.output_type
class CostAllocationRulePropertiesResponse(dict):
    """
    The properties of a cost allocation rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdDate":
            suggest = "created_date"
        elif key == "updatedDate":
            suggest = "updated_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CostAllocationRulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CostAllocationRulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CostAllocationRulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_date: str,
                 details: 'outputs.CostAllocationRuleDetailsResponse',
                 status: str,
                 updated_date: str,
                 description: Optional[str] = None):
        """
        The properties of a cost allocation rule
        :param str created_date: Time at which the rule was created. Rules that change cost for the same resource are applied in order of creation.
        :param 'CostAllocationRuleDetailsResponse' details: Resource information for the cost allocation rule
        :param str status: Status of the rule
        :param str updated_date: Time at which the rule was last updated.
        :param str description: Description of a cost allocation rule.
        """
        pulumi.set(__self__, "created_date", created_date)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_date", updated_date)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> str:
        """
        Time at which the rule was created. Rules that change cost for the same resource are applied in order of creation.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def details(self) -> 'outputs.CostAllocationRuleDetailsResponse':
        """
        Resource information for the cost allocation rule
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> str:
        """
        Time at which the rule was last updated.
        """
        return pulumi.get(self, "updated_date")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of a cost allocation rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class SourceCostAllocationResourceResponse(dict):
    """
    Source resources for cost allocation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceCostAllocationResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceCostAllocationResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceCostAllocationResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 resource_type: str,
                 values: Sequence[str]):
        """
        Source resources for cost allocation
        :param str name: If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        :param str resource_type: Type of resources contained in this cost allocation rule
        :param Sequence[str] values: Source Resources for cost allocation. This list cannot contain more than 25 values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of resources contained in this cost allocation rule
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Source Resources for cost allocation. This list cannot contain more than 25 values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class TargetCostAllocationResourceResponse(dict):
    """
    Target resources for cost allocation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetCostAllocationResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetCostAllocationResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetCostAllocationResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 policy_type: str,
                 resource_type: str,
                 values: Sequence['outputs.CostAllocationProportionResponse']):
        """
        Target resources for cost allocation.
        :param str name: If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        :param str policy_type: Method of cost allocation for the rule
        :param str resource_type: Type of resources contained in this cost allocation rule
        :param Sequence['CostAllocationProportionResponse'] values: Target resources for cost allocation. This list cannot contain more than 25 values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If resource type is dimension, this must be either ResourceGroupName or SubscriptionId. If resource type is tag, this must be a valid Azure tag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> str:
        """
        Method of cost allocation for the rule
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Type of resources contained in this cost allocation rule
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.CostAllocationProportionResponse']:
        """
        Target resources for cost allocation. This list cannot contain more than 25 values.
        """
        return pulumi.get(self, "values")


