# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AgentPropertiesArgs',
    'ArgumentArgs',
    'AuthInfoArgs',
    'BaseImageTriggerArgs',
    'CredentialsArgs',
    'CustomRegistryCredentialsArgs',
    'DockerBuildRequestArgs',
    'DockerBuildStepArgs',
    'EncodedTaskRunRequestArgs',
    'EncodedTaskStepArgs',
    'ExportPipelineTargetPropertiesArgs',
    'FileTaskRunRequestArgs',
    'FileTaskStepArgs',
    'IPRuleArgs',
    'IdentityPropertiesArgs',
    'ImportPipelineSourcePropertiesArgs',
    'LoggingPropertiesArgs',
    'NetworkRuleSetArgs',
    'OverrideTaskStepPropertiesArgs',
    'ParentPropertiesArgs',
    'PipelineRunRequestArgs',
    'PipelineRunSourcePropertiesArgs',
    'PipelineRunTargetPropertiesArgs',
    'PipelineSourceTriggerPropertiesArgs',
    'PipelineTriggerPropertiesArgs',
    'PlatformPropertiesArgs',
    'PoliciesArgs',
    'PrivateEndpointArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'QuarantinePolicyArgs',
    'RetentionPolicyArgs',
    'SecretObjectArgs',
    'SetValueArgs',
    'SkuArgs',
    'SourcePropertiesArgs',
    'SourceRegistryCredentialsArgs',
    'SourceTriggerArgs',
    'StorageAccountPropertiesArgs',
    'SyncPropertiesArgs',
    'TaskRunRequestArgs',
    'TimerTriggerArgs',
    'TokenCertificateArgs',
    'TokenCredentialsPropertiesArgs',
    'TokenPasswordArgs',
    'TriggerPropertiesArgs',
    'TrustPolicyArgs',
    'UserIdentityPropertiesArgs',
    'VirtualNetworkRuleArgs',
]

@pulumi.input_type
class AgentPropertiesArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[int]] = None):
        """
        The properties that determine the run agent configuration.
        :param pulumi.Input[int] cpu: The CPU configuration in terms of number of cores required for the run.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The CPU configuration in terms of number of cores required for the run.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu", value)


@pulumi.input_type
class ArgumentArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 is_secret: Optional[pulumi.Input[bool]] = None):
        """
        The properties of a run argument.
        :param pulumi.Input[str] name: The name of the argument.
        :param pulumi.Input[str] value: The value of the argument.
        :param pulumi.Input[bool] is_secret: Flag to indicate whether the argument represents a secret and want to be removed from build logs.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if is_secret is None:
            is_secret = False
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the argument.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the argument.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether the argument represents a secret and want to be removed from build logs.
        """
        return pulumi.get(self, "is_secret")

    @is_secret.setter
    def is_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret", value)


@pulumi.input_type
class AuthInfoArgs:
    def __init__(__self__, *,
                 token: pulumi.Input[str],
                 token_type: pulumi.Input[Union[str, 'TokenType']],
                 expires_in: Optional[pulumi.Input[int]] = None,
                 refresh_token: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        The authorization properties for accessing the source code repository.
        :param pulumi.Input[str] token: The access token used to access the source control provider.
        :param pulumi.Input[Union[str, 'TokenType']] token_type: The type of Auth token.
        :param pulumi.Input[int] expires_in: Time in seconds that the token remains valid
        :param pulumi.Input[str] refresh_token: The refresh token used to refresh the access token.
        :param pulumi.Input[str] scope: The scope of the access token.
        """
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "token_type", token_type)
        if expires_in is not None:
            pulumi.set(__self__, "expires_in", expires_in)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        The access token used to access the source control provider.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Input[Union[str, 'TokenType']]:
        """
        The type of Auth token.
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: pulumi.Input[Union[str, 'TokenType']]):
        pulumi.set(self, "token_type", value)

    @property
    @pulumi.getter(name="expiresIn")
    def expires_in(self) -> Optional[pulumi.Input[int]]:
        """
        Time in seconds that the token remains valid
        """
        return pulumi.get(self, "expires_in")

    @expires_in.setter
    def expires_in(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expires_in", value)

    @property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[pulumi.Input[str]]:
        """
        The refresh token used to refresh the access token.
        """
        return pulumi.get(self, "refresh_token")

    @refresh_token.setter
    def refresh_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_token", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of the access token.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class BaseImageTriggerArgs:
    def __init__(__self__, *,
                 base_image_trigger_type: pulumi.Input[Union[str, 'BaseImageTriggerType']],
                 name: pulumi.Input[str],
                 status: Optional[pulumi.Input[Union[str, 'TriggerStatus']]] = None,
                 update_trigger_endpoint: Optional[pulumi.Input[str]] = None,
                 update_trigger_payload_type: Optional[pulumi.Input[Union[str, 'UpdateTriggerPayloadType']]] = None):
        """
        The trigger based on base image dependency.
        :param pulumi.Input[Union[str, 'BaseImageTriggerType']] base_image_trigger_type: The type of the auto trigger for base image dependency updates.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of trigger.
        :param pulumi.Input[str] update_trigger_endpoint: The endpoint URL for receiving update triggers.
        :param pulumi.Input[Union[str, 'UpdateTriggerPayloadType']] update_trigger_payload_type: Type of Payload body for Base image update triggers.
        """
        pulumi.set(__self__, "base_image_trigger_type", base_image_trigger_type)
        pulumi.set(__self__, "name", name)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_trigger_endpoint is not None:
            pulumi.set(__self__, "update_trigger_endpoint", update_trigger_endpoint)
        if update_trigger_payload_type is not None:
            pulumi.set(__self__, "update_trigger_payload_type", update_trigger_payload_type)

    @property
    @pulumi.getter(name="baseImageTriggerType")
    def base_image_trigger_type(self) -> pulumi.Input[Union[str, 'BaseImageTriggerType']]:
        """
        The type of the auto trigger for base image dependency updates.
        """
        return pulumi.get(self, "base_image_trigger_type")

    @base_image_trigger_type.setter
    def base_image_trigger_type(self, value: pulumi.Input[Union[str, 'BaseImageTriggerType']]):
        pulumi.set(self, "base_image_trigger_type", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'TriggerStatus']]]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'TriggerStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTriggerEndpoint")
    def update_trigger_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint URL for receiving update triggers.
        """
        return pulumi.get(self, "update_trigger_endpoint")

    @update_trigger_endpoint.setter
    def update_trigger_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_trigger_endpoint", value)

    @property
    @pulumi.getter(name="updateTriggerPayloadType")
    def update_trigger_payload_type(self) -> Optional[pulumi.Input[Union[str, 'UpdateTriggerPayloadType']]]:
        """
        Type of Payload body for Base image update triggers.
        """
        return pulumi.get(self, "update_trigger_payload_type")

    @update_trigger_payload_type.setter
    def update_trigger_payload_type(self, value: Optional[pulumi.Input[Union[str, 'UpdateTriggerPayloadType']]]):
        pulumi.set(self, "update_trigger_payload_type", value)


@pulumi.input_type
class CredentialsArgs:
    def __init__(__self__, *,
                 custom_registries: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]]] = None,
                 source_registry: Optional[pulumi.Input['SourceRegistryCredentialsArgs']] = None):
        """
        The parameters that describes a set of credentials that will be used when a run is invoked.
        :param pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]] custom_registries: Describes the credential parameters for accessing other custom registries. The key
               for the dictionary item will be the registry login server (myregistry.azurecr.io) and
               the value of the item will be the registry credentials for accessing the registry.
        :param pulumi.Input['SourceRegistryCredentialsArgs'] source_registry: Describes the credential parameters for accessing the source registry.
        """
        if custom_registries is not None:
            pulumi.set(__self__, "custom_registries", custom_registries)
        if source_registry is not None:
            pulumi.set(__self__, "source_registry", source_registry)

    @property
    @pulumi.getter(name="customRegistries")
    def custom_registries(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]]]:
        """
        Describes the credential parameters for accessing other custom registries. The key
        for the dictionary item will be the registry login server (myregistry.azurecr.io) and
        the value of the item will be the registry credentials for accessing the registry.
        """
        return pulumi.get(self, "custom_registries")

    @custom_registries.setter
    def custom_registries(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomRegistryCredentialsArgs']]]]):
        pulumi.set(self, "custom_registries", value)

    @property
    @pulumi.getter(name="sourceRegistry")
    def source_registry(self) -> Optional[pulumi.Input['SourceRegistryCredentialsArgs']]:
        """
        Describes the credential parameters for accessing the source registry.
        """
        return pulumi.get(self, "source_registry")

    @source_registry.setter
    def source_registry(self, value: Optional[pulumi.Input['SourceRegistryCredentialsArgs']]):
        pulumi.set(self, "source_registry", value)


@pulumi.input_type
class CustomRegistryCredentialsArgs:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input['SecretObjectArgs']] = None,
                 user_name: Optional[pulumi.Input['SecretObjectArgs']] = None):
        """
        Describes the credentials that will be used to access a custom registry during a run.
        :param pulumi.Input[str] identity: Indicates the managed identity assigned to the custom credential. If a user-assigned identity
               this value is the Client ID. If a system-assigned identity, the value will be `system`. In
               the case of a system-assigned identity, the Client ID will be determined by the runner. This
               identity may be used to authenticate to key vault to retrieve credentials or it may be the only 
               source of authentication used for accessing the registry.
        :param pulumi.Input['SecretObjectArgs'] password: The password for logging into the custom registry. The password is a secret 
               object that allows multiple ways of providing the value for it.
        :param pulumi.Input['SecretObjectArgs'] user_name: The username for logging into the custom registry.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the managed identity assigned to the custom credential. If a user-assigned identity
        this value is the Client ID. If a system-assigned identity, the value will be `system`. In
        the case of a system-assigned identity, the Client ID will be determined by the runner. This
        identity may be used to authenticate to key vault to retrieve credentials or it may be the only 
        source of authentication used for accessing the registry.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['SecretObjectArgs']]:
        """
        The password for logging into the custom registry. The password is a secret 
        object that allows multiple ways of providing the value for it.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['SecretObjectArgs']]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input['SecretObjectArgs']]:
        """
        The username for logging into the custom registry.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input['SecretObjectArgs']]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class DockerBuildRequestArgs:
    def __init__(__self__, *,
                 docker_file_path: pulumi.Input[str],
                 platform: pulumi.Input['PlatformPropertiesArgs'],
                 type: pulumi.Input[str],
                 agent_configuration: Optional[pulumi.Input['AgentPropertiesArgs']] = None,
                 agent_pool_name: Optional[pulumi.Input[str]] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]] = None,
                 credentials: Optional[pulumi.Input['CredentialsArgs']] = None,
                 image_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_archive_enabled: Optional[pulumi.Input[bool]] = None,
                 is_push_enabled: Optional[pulumi.Input[bool]] = None,
                 log_template: Optional[pulumi.Input[str]] = None,
                 no_cache: Optional[pulumi.Input[bool]] = None,
                 source_location: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The parameters for a docker quick build.
        :param pulumi.Input[str] docker_file_path: The Docker file path relative to the source location.
        :param pulumi.Input['PlatformPropertiesArgs'] platform: The platform properties against which the run has to happen.
        :param pulumi.Input[str] type: The type of the run request.
               Expected value is 'DockerBuildRequest'.
        :param pulumi.Input['AgentPropertiesArgs'] agent_configuration: The machine configuration of the run agent.
        :param pulumi.Input[str] agent_pool_name: The dedicated agent pool for the run.
        :param pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]] arguments: The collection of override arguments to be used when executing the run.
        :param pulumi.Input['CredentialsArgs'] credentials: The properties that describes a set of credentials that will be used when this run is invoked.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] image_names: The fully qualified image names including the repository and tag.
        :param pulumi.Input[bool] is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param pulumi.Input[bool] is_push_enabled: The value of this property indicates whether the image built should be pushed to the registry or not.
        :param pulumi.Input[str] log_template: The template that describes the repository and tag information for run log artifact.
        :param pulumi.Input[bool] no_cache: The value of this property indicates whether the image cache is enabled or not.
        :param pulumi.Input[str] source_location: The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
               If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        :param pulumi.Input[str] target: The name of the target build stage for the docker build.
        :param pulumi.Input[int] timeout: Run timeout in seconds.
        """
        pulumi.set(__self__, "docker_file_path", docker_file_path)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "type", 'DockerBuildRequest')
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if image_names is not None:
            pulumi.set(__self__, "image_names", image_names)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if is_push_enabled is None:
            is_push_enabled = True
        if is_push_enabled is not None:
            pulumi.set(__self__, "is_push_enabled", is_push_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if no_cache is None:
            no_cache = False
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout is None:
            timeout = 3600
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="dockerFilePath")
    def docker_file_path(self) -> pulumi.Input[str]:
        """
        The Docker file path relative to the source location.
        """
        return pulumi.get(self, "docker_file_path")

    @docker_file_path.setter
    def docker_file_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "docker_file_path", value)

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Input['PlatformPropertiesArgs']:
        """
        The platform properties against which the run has to happen.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: pulumi.Input['PlatformPropertiesArgs']):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the run request.
        Expected value is 'DockerBuildRequest'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional[pulumi.Input['AgentPropertiesArgs']]:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @agent_configuration.setter
    def agent_configuration(self, value: Optional[pulumi.Input['AgentPropertiesArgs']]):
        pulumi.set(self, "agent_configuration", value)

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @agent_pool_name.setter
    def agent_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_pool_name", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]:
        """
        The collection of override arguments to be used when executing the run.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['CredentialsArgs']]:
        """
        The properties that describes a set of credentials that will be used when this run is invoked.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['CredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="imageNames")
    def image_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The fully qualified image names including the repository and tag.
        """
        return pulumi.get(self, "image_names")

    @image_names.setter
    def image_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "image_names", value)

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @is_archive_enabled.setter
    def is_archive_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archive_enabled", value)

    @property
    @pulumi.getter(name="isPushEnabled")
    def is_push_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value of this property indicates whether the image built should be pushed to the registry or not.
        """
        return pulumi.get(self, "is_push_enabled")

    @is_push_enabled.setter
    def is_push_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_push_enabled", value)

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input[str]]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_template", value)

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        The value of this property indicates whether the image cache is enabled or not.
        """
        return pulumi.get(self, "no_cache")

    @no_cache.setter
    def no_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_cache", value)

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
        If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_location", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target build stage for the docker build.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Run timeout in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class DockerBuildStepArgs:
    def __init__(__self__, *,
                 docker_file_path: pulumi.Input[str],
                 type: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]] = None,
                 context_access_token: Optional[pulumi.Input[str]] = None,
                 context_path: Optional[pulumi.Input[str]] = None,
                 image_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_push_enabled: Optional[pulumi.Input[bool]] = None,
                 no_cache: Optional[pulumi.Input[bool]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        The Docker build step.
        :param pulumi.Input[str] docker_file_path: The Docker file path relative to the source context.
        :param pulumi.Input[str] type: The type of the step.
               Expected value is 'Docker'.
        :param pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]] arguments: The collection of override arguments to be used when executing this build step.
        :param pulumi.Input[str] context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param pulumi.Input[str] context_path: The URL(absolute or relative) of the source context for the task step.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] image_names: The fully qualified image names including the repository and tag.
        :param pulumi.Input[bool] is_push_enabled: The value of this property indicates whether the image built should be pushed to the registry or not.
        :param pulumi.Input[bool] no_cache: The value of this property indicates whether the image cache is enabled or not.
        :param pulumi.Input[str] target: The name of the target build stage for the docker build.
        """
        pulumi.set(__self__, "docker_file_path", docker_file_path)
        pulumi.set(__self__, "type", 'Docker')
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if image_names is not None:
            pulumi.set(__self__, "image_names", image_names)
        if is_push_enabled is None:
            is_push_enabled = True
        if is_push_enabled is not None:
            pulumi.set(__self__, "is_push_enabled", is_push_enabled)
        if no_cache is None:
            no_cache = False
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="dockerFilePath")
    def docker_file_path(self) -> pulumi.Input[str]:
        """
        The Docker file path relative to the source context.
        """
        return pulumi.get(self, "docker_file_path")

    @docker_file_path.setter
    def docker_file_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "docker_file_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the step.
        Expected value is 'Docker'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]:
        """
        The collection of override arguments to be used when executing this build step.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @context_access_token.setter
    def context_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_access_token", value)

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @context_path.setter
    def context_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_path", value)

    @property
    @pulumi.getter(name="imageNames")
    def image_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The fully qualified image names including the repository and tag.
        """
        return pulumi.get(self, "image_names")

    @image_names.setter
    def image_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "image_names", value)

    @property
    @pulumi.getter(name="isPushEnabled")
    def is_push_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value of this property indicates whether the image built should be pushed to the registry or not.
        """
        return pulumi.get(self, "is_push_enabled")

    @is_push_enabled.setter
    def is_push_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_push_enabled", value)

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        The value of this property indicates whether the image cache is enabled or not.
        """
        return pulumi.get(self, "no_cache")

    @no_cache.setter
    def no_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_cache", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target build stage for the docker build.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class EncodedTaskRunRequestArgs:
    def __init__(__self__, *,
                 encoded_task_content: pulumi.Input[str],
                 platform: pulumi.Input['PlatformPropertiesArgs'],
                 type: pulumi.Input[str],
                 agent_configuration: Optional[pulumi.Input['AgentPropertiesArgs']] = None,
                 agent_pool_name: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['CredentialsArgs']] = None,
                 encoded_values_content: Optional[pulumi.Input[str]] = None,
                 is_archive_enabled: Optional[pulumi.Input[bool]] = None,
                 log_template: Optional[pulumi.Input[str]] = None,
                 source_location: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]] = None):
        """
        The parameters for a quick task run request.
        :param pulumi.Input[str] encoded_task_content: Base64 encoded value of the template/definition file content.
        :param pulumi.Input['PlatformPropertiesArgs'] platform: The platform properties against which the run has to happen.
        :param pulumi.Input[str] type: The type of the run request.
               Expected value is 'EncodedTaskRunRequest'.
        :param pulumi.Input['AgentPropertiesArgs'] agent_configuration: The machine configuration of the run agent.
        :param pulumi.Input[str] agent_pool_name: The dedicated agent pool for the run.
        :param pulumi.Input['CredentialsArgs'] credentials: The properties that describes a set of credentials that will be used when this run is invoked.
        :param pulumi.Input[str] encoded_values_content: Base64 encoded value of the parameters/values file content.
        :param pulumi.Input[bool] is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param pulumi.Input[str] log_template: The template that describes the repository and tag information for run log artifact.
        :param pulumi.Input[str] source_location: The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
               If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        :param pulumi.Input[int] timeout: Run timeout in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]] values: The collection of overridable values that can be passed when running a task.
        """
        pulumi.set(__self__, "encoded_task_content", encoded_task_content)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "type", 'EncodedTaskRunRequest')
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if encoded_values_content is not None:
            pulumi.set(__self__, "encoded_values_content", encoded_values_content)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if timeout is None:
            timeout = 3600
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="encodedTaskContent")
    def encoded_task_content(self) -> pulumi.Input[str]:
        """
        Base64 encoded value of the template/definition file content.
        """
        return pulumi.get(self, "encoded_task_content")

    @encoded_task_content.setter
    def encoded_task_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "encoded_task_content", value)

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Input['PlatformPropertiesArgs']:
        """
        The platform properties against which the run has to happen.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: pulumi.Input['PlatformPropertiesArgs']):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the run request.
        Expected value is 'EncodedTaskRunRequest'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional[pulumi.Input['AgentPropertiesArgs']]:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @agent_configuration.setter
    def agent_configuration(self, value: Optional[pulumi.Input['AgentPropertiesArgs']]):
        pulumi.set(self, "agent_configuration", value)

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @agent_pool_name.setter
    def agent_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_pool_name", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['CredentialsArgs']]:
        """
        The properties that describes a set of credentials that will be used when this run is invoked.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['CredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="encodedValuesContent")
    def encoded_values_content(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded value of the parameters/values file content.
        """
        return pulumi.get(self, "encoded_values_content")

    @encoded_values_content.setter
    def encoded_values_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded_values_content", value)

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @is_archive_enabled.setter
    def is_archive_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archive_enabled", value)

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input[str]]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_template", value)

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
        If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_location", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Run timeout in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class EncodedTaskStepArgs:
    def __init__(__self__, *,
                 encoded_task_content: pulumi.Input[str],
                 type: pulumi.Input[str],
                 context_access_token: Optional[pulumi.Input[str]] = None,
                 context_path: Optional[pulumi.Input[str]] = None,
                 encoded_values_content: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]] = None):
        """
        The properties of a encoded task step.
        :param pulumi.Input[str] encoded_task_content: Base64 encoded value of the template/definition file content.
        :param pulumi.Input[str] type: The type of the step.
               Expected value is 'EncodedTask'.
        :param pulumi.Input[str] context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param pulumi.Input[str] context_path: The URL(absolute or relative) of the source context for the task step.
        :param pulumi.Input[str] encoded_values_content: Base64 encoded value of the parameters/values file content.
        :param pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]] values: The collection of overridable values that can be passed when running a task.
        """
        pulumi.set(__self__, "encoded_task_content", encoded_task_content)
        pulumi.set(__self__, "type", 'EncodedTask')
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if encoded_values_content is not None:
            pulumi.set(__self__, "encoded_values_content", encoded_values_content)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="encodedTaskContent")
    def encoded_task_content(self) -> pulumi.Input[str]:
        """
        Base64 encoded value of the template/definition file content.
        """
        return pulumi.get(self, "encoded_task_content")

    @encoded_task_content.setter
    def encoded_task_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "encoded_task_content", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the step.
        Expected value is 'EncodedTask'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @context_access_token.setter
    def context_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_access_token", value)

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @context_path.setter
    def context_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_path", value)

    @property
    @pulumi.getter(name="encodedValuesContent")
    def encoded_values_content(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded value of the parameters/values file content.
        """
        return pulumi.get(self, "encoded_values_content")

    @encoded_values_content.setter
    def encoded_values_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded_values_content", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ExportPipelineTargetPropertiesArgs:
    def __init__(__self__, *,
                 key_vault_uri: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The properties of the export pipeline target.
        :param pulumi.Input[str] key_vault_uri: They key vault secret uri to obtain the target storage SAS token.
        :param pulumi.Input[str] type: The type of target for the export pipeline.
        :param pulumi.Input[str] uri: The target uri of the export pipeline.
               When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
               When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
        """
        pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> pulumi.Input[str]:
        """
        They key vault secret uri to obtain the target storage SAS token.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of target for the export pipeline.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The target uri of the export pipeline.
        When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
        When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class FileTaskRunRequestArgs:
    def __init__(__self__, *,
                 platform: pulumi.Input['PlatformPropertiesArgs'],
                 task_file_path: pulumi.Input[str],
                 type: pulumi.Input[str],
                 agent_configuration: Optional[pulumi.Input['AgentPropertiesArgs']] = None,
                 agent_pool_name: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['CredentialsArgs']] = None,
                 is_archive_enabled: Optional[pulumi.Input[bool]] = None,
                 log_template: Optional[pulumi.Input[str]] = None,
                 source_location: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]] = None,
                 values_file_path: Optional[pulumi.Input[str]] = None):
        """
        The request parameters for a scheduling run against a task file.
        :param pulumi.Input['PlatformPropertiesArgs'] platform: The platform properties against which the run has to happen.
        :param pulumi.Input[str] task_file_path: The template/definition file path relative to the source.
        :param pulumi.Input[str] type: The type of the run request.
               Expected value is 'FileTaskRunRequest'.
        :param pulumi.Input['AgentPropertiesArgs'] agent_configuration: The machine configuration of the run agent.
        :param pulumi.Input[str] agent_pool_name: The dedicated agent pool for the run.
        :param pulumi.Input['CredentialsArgs'] credentials: The properties that describes a set of credentials that will be used when this run is invoked.
        :param pulumi.Input[bool] is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param pulumi.Input[str] log_template: The template that describes the repository and tag information for run log artifact.
        :param pulumi.Input[str] source_location: The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
               If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        :param pulumi.Input[int] timeout: Run timeout in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]] values: The collection of overridable values that can be passed when running a task.
        :param pulumi.Input[str] values_file_path: The values/parameters file path relative to the source.
        """
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "task_file_path", task_file_path)
        pulumi.set(__self__, "type", 'FileTaskRunRequest')
        if agent_configuration is not None:
            pulumi.set(__self__, "agent_configuration", agent_configuration)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if timeout is None:
            timeout = 3600
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if values_file_path is not None:
            pulumi.set(__self__, "values_file_path", values_file_path)

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Input['PlatformPropertiesArgs']:
        """
        The platform properties against which the run has to happen.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: pulumi.Input['PlatformPropertiesArgs']):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="taskFilePath")
    def task_file_path(self) -> pulumi.Input[str]:
        """
        The template/definition file path relative to the source.
        """
        return pulumi.get(self, "task_file_path")

    @task_file_path.setter
    def task_file_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_file_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the run request.
        Expected value is 'FileTaskRunRequest'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="agentConfiguration")
    def agent_configuration(self) -> Optional[pulumi.Input['AgentPropertiesArgs']]:
        """
        The machine configuration of the run agent.
        """
        return pulumi.get(self, "agent_configuration")

    @agent_configuration.setter
    def agent_configuration(self, value: Optional[pulumi.Input['AgentPropertiesArgs']]):
        pulumi.set(self, "agent_configuration", value)

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @agent_pool_name.setter
    def agent_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_pool_name", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['CredentialsArgs']]:
        """
        The properties that describes a set of credentials that will be used when this run is invoked.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['CredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @is_archive_enabled.setter
    def is_archive_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archive_enabled", value)

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input[str]]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_template", value)

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
        If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_location", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Run timeout in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter(name="valuesFilePath")
    def values_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The values/parameters file path relative to the source.
        """
        return pulumi.get(self, "values_file_path")

    @values_file_path.setter
    def values_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "values_file_path", value)


@pulumi.input_type
class FileTaskStepArgs:
    def __init__(__self__, *,
                 task_file_path: pulumi.Input[str],
                 type: pulumi.Input[str],
                 context_access_token: Optional[pulumi.Input[str]] = None,
                 context_path: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]] = None,
                 values_file_path: Optional[pulumi.Input[str]] = None):
        """
        The properties of a task step.
        :param pulumi.Input[str] task_file_path: The task template/definition file path relative to the source context.
        :param pulumi.Input[str] type: The type of the step.
               Expected value is 'FileTask'.
        :param pulumi.Input[str] context_access_token: The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        :param pulumi.Input[str] context_path: The URL(absolute or relative) of the source context for the task step.
        :param pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]] values: The collection of overridable values that can be passed when running a task.
        :param pulumi.Input[str] values_file_path: The task values/parameters file path relative to the source context.
        """
        pulumi.set(__self__, "task_file_path", task_file_path)
        pulumi.set(__self__, "type", 'FileTask')
        if context_access_token is not None:
            pulumi.set(__self__, "context_access_token", context_access_token)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if values is not None:
            pulumi.set(__self__, "values", values)
        if values_file_path is not None:
            pulumi.set(__self__, "values_file_path", values_file_path)

    @property
    @pulumi.getter(name="taskFilePath")
    def task_file_path(self) -> pulumi.Input[str]:
        """
        The task template/definition file path relative to the source context.
        """
        return pulumi.get(self, "task_file_path")

    @task_file_path.setter
    def task_file_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_file_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the step.
        Expected value is 'FileTask'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="contextAccessToken")
    def context_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        The token (git PAT or SAS token of storage account blob) associated with the context for a step.
        """
        return pulumi.get(self, "context_access_token")

    @context_access_token.setter
    def context_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_access_token", value)

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL(absolute or relative) of the source context for the task step.
        """
        return pulumi.get(self, "context_path")

    @context_path.setter
    def context_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_path", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]:
        """
        The collection of overridable values that can be passed when running a task.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter(name="valuesFilePath")
    def values_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The task values/parameters file path relative to the source context.
        """
        return pulumi.get(self, "values_file_path")

    @values_file_path.setter
    def values_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "values_file_path", value)


@pulumi.input_type
class IPRuleArgs:
    def __init__(__self__, *,
                 i_p_address_or_range: pulumi.Input[str],
                 action: Optional[pulumi.Input[Union[str, 'Action']]] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param pulumi.Input[str] i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param pulumi.Input[Union[str, 'Action']] action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> pulumi.Input[str]:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @i_p_address_or_range.setter
    def i_p_address_or_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "i_p_address_or_range", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'Action']]]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'Action']]]):
        pulumi.set(self, "action", value)


@pulumi.input_type
class IdentityPropertiesArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]] = None):
        """
        Managed identity for the resource.
        :param pulumi.Input[str] principal_id: The principal ID of resource identity.
        :param pulumi.Input[str] tenant_id: The tenant ID of resource.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type.
        :param pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]] user_assigned_identities: The list of user identities associated with the resource. The user identity 
               dictionary key references will be ARM resource ids in the form: 
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
                   providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]:
        """
        The list of user identities associated with the resource. The user identity 
        dictionary key references will be ARM resource ids in the form: 
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
            providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ImportPipelineSourcePropertiesArgs:
    def __init__(__self__, *,
                 key_vault_uri: pulumi.Input[str],
                 type: Optional[pulumi.Input[Union[str, 'PipelineSourceType']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The properties of the import pipeline source.
        :param pulumi.Input[str] key_vault_uri: They key vault secret uri to obtain the source storage SAS token.
        :param pulumi.Input[Union[str, 'PipelineSourceType']] type: The type of source for the import pipeline.
        :param pulumi.Input[str] uri: The source uri of the import pipeline.
               When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
               When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
        """
        pulumi.set(__self__, "key_vault_uri", key_vault_uri)
        if type is None:
            type = 'AzureStorageBlobContainer'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="keyVaultUri")
    def key_vault_uri(self) -> pulumi.Input[str]:
        """
        They key vault secret uri to obtain the source storage SAS token.
        """
        return pulumi.get(self, "key_vault_uri")

    @key_vault_uri.setter
    def key_vault_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_uri", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'PipelineSourceType']]]:
        """
        The type of source for the import pipeline.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'PipelineSourceType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The source uri of the import pipeline.
        When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
        When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class LoggingPropertiesArgs:
    def __init__(__self__, *,
                 audit_log_status: Optional[pulumi.Input[Union[str, 'AuditLogStatus']]] = None,
                 log_level: Optional[pulumi.Input[Union[str, 'LogLevel']]] = None):
        """
        The logging properties of the connected registry.
        :param pulumi.Input[Union[str, 'AuditLogStatus']] audit_log_status: Indicates whether audit logs are enabled on the connected registry.
        :param pulumi.Input[Union[str, 'LogLevel']] log_level: The verbosity of logs persisted on the connected registry.
        """
        if audit_log_status is None:
            audit_log_status = 'Disabled'
        if audit_log_status is not None:
            pulumi.set(__self__, "audit_log_status", audit_log_status)
        if log_level is None:
            log_level = 'Information'
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="auditLogStatus")
    def audit_log_status(self) -> Optional[pulumi.Input[Union[str, 'AuditLogStatus']]]:
        """
        Indicates whether audit logs are enabled on the connected registry.
        """
        return pulumi.get(self, "audit_log_status")

    @audit_log_status.setter
    def audit_log_status(self, value: Optional[pulumi.Input[Union[str, 'AuditLogStatus']]]):
        pulumi.set(self, "audit_log_status", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[Union[str, 'LogLevel']]]:
        """
        The verbosity of logs persisted on the connected registry.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[Union[str, 'LogLevel']]]):
        pulumi.set(self, "log_level", value)


@pulumi.input_type
class NetworkRuleSetArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[Union[str, 'DefaultAction']],
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]] = None):
        """
        The network rule set for a container registry.
        :param pulumi.Input[Union[str, 'DefaultAction']] default_action: The default action of allow or deny when no other rules match.
        :param pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]] ip_rules: The IP ACL rules.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]] virtual_network_rules: The virtual network rules.
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[Union[str, 'DefaultAction']]:
        """
        The default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[Union[str, 'DefaultAction']]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]:
        """
        The IP ACL rules.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IPRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]:
        """
        The virtual network rules.
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


@pulumi.input_type
class OverrideTaskStepPropertiesArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]] = None,
                 context_path: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 update_trigger_token: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]] arguments: Gets or sets the collection of override arguments to be used when
               executing a build step.
        :param pulumi.Input[str] context_path: The source context against which run has to be queued.
        :param pulumi.Input[str] file: The file against which run has to be queued.
        :param pulumi.Input[str] target: The name of the target build stage for the docker build.
        :param pulumi.Input[str] update_trigger_token: Base64 encoded update trigger token that will be attached with the base image trigger webhook.
        :param pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]] values: The collection of overridable values that can be passed when running a Task.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if update_trigger_token is not None:
            pulumi.set(__self__, "update_trigger_token", update_trigger_token)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]:
        """
        Gets or sets the collection of override arguments to be used when
        executing a build step.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[pulumi.Input[str]]:
        """
        The source context against which run has to be queued.
        """
        return pulumi.get(self, "context_path")

    @context_path.setter
    def context_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_path", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[str]]:
        """
        The file against which run has to be queued.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target build stage for the docker build.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="updateTriggerToken")
    def update_trigger_token(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded update trigger token that will be attached with the base image trigger webhook.
        """
        return pulumi.get(self, "update_trigger_token")

    @update_trigger_token.setter
    def update_trigger_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_trigger_token", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]:
        """
        The collection of overridable values that can be passed when running a Task.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SetValueArgs']]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ParentPropertiesArgs:
    def __init__(__self__, *,
                 sync_properties: pulumi.Input['SyncPropertiesArgs'],
                 id: Optional[pulumi.Input[str]] = None):
        """
        The properties of the connected registry parent.
        :param pulumi.Input['SyncPropertiesArgs'] sync_properties: The sync properties of the connected registry with its parent.
        :param pulumi.Input[str] id: The resource ID of the parent to which the connected registry will be associated.
        """
        pulumi.set(__self__, "sync_properties", sync_properties)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="syncProperties")
    def sync_properties(self) -> pulumi.Input['SyncPropertiesArgs']:
        """
        The sync properties of the connected registry with its parent.
        """
        return pulumi.get(self, "sync_properties")

    @sync_properties.setter
    def sync_properties(self, value: pulumi.Input['SyncPropertiesArgs']):
        pulumi.set(self, "sync_properties", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the parent to which the connected registry will be associated.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PipelineRunRequestArgs:
    def __init__(__self__, *,
                 artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 catalog_digest: Optional[pulumi.Input[str]] = None,
                 pipeline_resource_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['PipelineRunSourcePropertiesArgs']] = None,
                 target: Optional[pulumi.Input['PipelineRunTargetPropertiesArgs']] = None):
        """
        The request properties provided for a pipeline run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] artifacts: List of source artifacts to be transferred by the pipeline. 
               Specify an image by repository ('hello-world'). This will use the 'latest' tag.
               Specify an image by tag ('hello-world:latest').
               Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
        :param pulumi.Input[str] catalog_digest: The digest of the tar used to transfer the artifacts.
        :param pulumi.Input[str] pipeline_resource_id: The resource ID of the pipeline to run.
        :param pulumi.Input['PipelineRunSourcePropertiesArgs'] source: The source properties of the pipeline run.
        :param pulumi.Input['PipelineRunTargetPropertiesArgs'] target: The target properties of the pipeline run.
        """
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if catalog_digest is not None:
            pulumi.set(__self__, "catalog_digest", catalog_digest)
        if pipeline_resource_id is not None:
            pulumi.set(__self__, "pipeline_resource_id", pipeline_resource_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source artifacts to be transferred by the pipeline. 
        Specify an image by repository ('hello-world'). This will use the 'latest' tag.
        Specify an image by tag ('hello-world:latest').
        Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="catalogDigest")
    def catalog_digest(self) -> Optional[pulumi.Input[str]]:
        """
        The digest of the tar used to transfer the artifacts.
        """
        return pulumi.get(self, "catalog_digest")

    @catalog_digest.setter
    def catalog_digest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_digest", value)

    @property
    @pulumi.getter(name="pipelineResourceId")
    def pipeline_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the pipeline to run.
        """
        return pulumi.get(self, "pipeline_resource_id")

    @pipeline_resource_id.setter
    def pipeline_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_resource_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['PipelineRunSourcePropertiesArgs']]:
        """
        The source properties of the pipeline run.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['PipelineRunSourcePropertiesArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['PipelineRunTargetPropertiesArgs']]:
        """
        The target properties of the pipeline run.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['PipelineRunTargetPropertiesArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class PipelineRunSourcePropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'PipelineRunSourceType']]] = None):
        """
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input[Union[str, 'PipelineRunSourceType']] type: The type of the source.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is None:
            type = 'AzureStorageBlob'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'PipelineRunSourceType']]]:
        """
        The type of the source.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'PipelineRunSourceType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PipelineRunTargetPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'PipelineRunTargetType']]] = None):
        """
        :param pulumi.Input[str] name: The name of the target.
        :param pulumi.Input[Union[str, 'PipelineRunTargetType']] type: The type of the target.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is None:
            type = 'AzureStorageBlob'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the target.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'PipelineRunTargetType']]]:
        """
        The type of the target.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'PipelineRunTargetType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PipelineSourceTriggerPropertiesArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[Union[str, 'TriggerStatus']]):
        """
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of the source trigger.
        """
        if status is None:
            status = 'Enabled'
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'TriggerStatus']]:
        """
        The current status of the source trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'TriggerStatus']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class PipelineTriggerPropertiesArgs:
    def __init__(__self__, *,
                 source_trigger: Optional[pulumi.Input['PipelineSourceTriggerPropertiesArgs']] = None):
        """
        :param pulumi.Input['PipelineSourceTriggerPropertiesArgs'] source_trigger: The source trigger properties of the pipeline.
        """
        if source_trigger is not None:
            pulumi.set(__self__, "source_trigger", source_trigger)

    @property
    @pulumi.getter(name="sourceTrigger")
    def source_trigger(self) -> Optional[pulumi.Input['PipelineSourceTriggerPropertiesArgs']]:
        """
        The source trigger properties of the pipeline.
        """
        return pulumi.get(self, "source_trigger")

    @source_trigger.setter
    def source_trigger(self, value: Optional[pulumi.Input['PipelineSourceTriggerPropertiesArgs']]):
        pulumi.set(self, "source_trigger", value)


@pulumi.input_type
class PlatformPropertiesArgs:
    def __init__(__self__, *,
                 os: pulumi.Input[Union[str, 'OS']],
                 architecture: Optional[pulumi.Input[Union[str, 'Architecture']]] = None,
                 variant: Optional[pulumi.Input[Union[str, 'Variant']]] = None):
        """
        The platform properties against which the run has to happen.
        :param pulumi.Input[Union[str, 'OS']] os: The operating system type required for the run.
        :param pulumi.Input[Union[str, 'Architecture']] architecture: The OS architecture.
        :param pulumi.Input[Union[str, 'Variant']] variant: Variant of the CPU.
        """
        pulumi.set(__self__, "os", os)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if variant is not None:
            pulumi.set(__self__, "variant", variant)

    @property
    @pulumi.getter
    def os(self) -> pulumi.Input[Union[str, 'OS']]:
        """
        The operating system type required for the run.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: pulumi.Input[Union[str, 'OS']]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[Union[str, 'Architecture']]]:
        """
        The OS architecture.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[Union[str, 'Architecture']]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def variant(self) -> Optional[pulumi.Input[Union[str, 'Variant']]]:
        """
        Variant of the CPU.
        """
        return pulumi.get(self, "variant")

    @variant.setter
    def variant(self, value: Optional[pulumi.Input[Union[str, 'Variant']]]):
        pulumi.set(self, "variant", value)


@pulumi.input_type
class PoliciesArgs:
    def __init__(__self__, *,
                 quarantine_policy: Optional[pulumi.Input['QuarantinePolicyArgs']] = None,
                 retention_policy: Optional[pulumi.Input['RetentionPolicyArgs']] = None,
                 trust_policy: Optional[pulumi.Input['TrustPolicyArgs']] = None):
        """
        The policies for a container registry.
        :param pulumi.Input['QuarantinePolicyArgs'] quarantine_policy: The quarantine policy for a container registry.
        :param pulumi.Input['RetentionPolicyArgs'] retention_policy: The retention policy for a container registry.
        :param pulumi.Input['TrustPolicyArgs'] trust_policy: The content trust policy for a container registry.
        """
        if quarantine_policy is not None:
            pulumi.set(__self__, "quarantine_policy", quarantine_policy)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="quarantinePolicy")
    def quarantine_policy(self) -> Optional[pulumi.Input['QuarantinePolicyArgs']]:
        """
        The quarantine policy for a container registry.
        """
        return pulumi.get(self, "quarantine_policy")

    @quarantine_policy.setter
    def quarantine_policy(self, value: Optional[pulumi.Input['QuarantinePolicyArgs']]):
        pulumi.set(self, "quarantine_policy", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['RetentionPolicyArgs']]:
        """
        The retention policy for a container registry.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['RetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional[pulumi.Input['TrustPolicyArgs']]:
        """
        The content trust policy for a container registry.
        """
        return pulumi.get(self, "trust_policy")

    @trust_policy.setter
    def trust_policy(self, value: Optional[pulumi.Input['TrustPolicyArgs']]):
        pulumi.set(self, "trust_policy", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The Private Endpoint resource.
        :param pulumi.Input[str] id: This is private endpoint resource created with Microsoft.Network resource provider.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        This is private endpoint resource created with Microsoft.Network resource provider.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[Union[str, 'ActionsRequired']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]] = None):
        """
        The state of a private link service connection.
        :param pulumi.Input[Union[str, 'ActionsRequired']] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The description for connection status. For example if connection is rejected it can indicate reason for rejection.
        :param pulumi.Input[Union[str, 'ConnectionStatus']] status: The private link service connection status.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[Union[str, 'ActionsRequired']]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[Union[str, 'ActionsRequired']]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for connection status. For example if connection is rejected it can indicate reason for rejection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class QuarantinePolicyArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[Union[str, 'PolicyStatus']]] = None):
        """
        The quarantine policy for a container registry.
        :param pulumi.Input[Union[str, 'PolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        """
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PolicyStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RetentionPolicyArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PolicyStatus']]] = None):
        """
        The retention policy for a container registry.
        :param pulumi.Input[int] days: The number of days to retain an untagged manifest after which it gets purged.
        :param pulumi.Input[Union[str, 'PolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        """
        if days is None:
            days = 7
        if days is not None:
            pulumi.set(__self__, "days", days)
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days to retain an untagged manifest after which it gets purged.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PolicyStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SecretObjectArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'SecretObjectType']]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Describes the properties of a secret object value.
        :param pulumi.Input[Union[str, 'SecretObjectType']] type: The type of the secret object which determines how the value of the secret object has to be
               interpreted.
        :param pulumi.Input[str] value: The value of the secret. The format of this value will be determined
               based on the type of the secret object. If the type is Opaque, the value will be
               used as is without any modification.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'SecretObjectType']]]:
        """
        The type of the secret object which determines how the value of the secret object has to be
        interpreted.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'SecretObjectType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the secret. The format of this value will be determined
        based on the type of the secret object. If the type is Opaque, the value will be
        used as is without any modification.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SetValueArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str],
                 is_secret: Optional[pulumi.Input[bool]] = None):
        """
        The properties of a overridable value that can be passed to a task template.
        :param pulumi.Input[str] name: The name of the overridable value.
        :param pulumi.Input[str] value: The overridable value.
        :param pulumi.Input[bool] is_secret: Flag to indicate whether the value represents a secret or not.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if is_secret is None:
            is_secret = False
        if is_secret is not None:
            pulumi.set(__self__, "is_secret", is_secret)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the overridable value.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The overridable value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="isSecret")
    def is_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether the value represents a secret or not.
        """
        return pulumi.get(self, "is_secret")

    @is_secret.setter
    def is_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_secret", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        The SKU of a container registry.
        :param pulumi.Input[Union[str, 'SkuName']] name: The SKU name of the container registry. Required for registry creation.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The SKU name of the container registry. Required for registry creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SourcePropertiesArgs:
    def __init__(__self__, *,
                 repository_url: pulumi.Input[str],
                 source_control_type: pulumi.Input[Union[str, 'SourceControlType']],
                 branch: Optional[pulumi.Input[str]] = None,
                 source_control_auth_properties: Optional[pulumi.Input['AuthInfoArgs']] = None):
        """
        The properties of the source code repository.
        :param pulumi.Input[str] repository_url: The full URL to the source code repository
        :param pulumi.Input[Union[str, 'SourceControlType']] source_control_type: The type of source control service.
        :param pulumi.Input[str] branch: The branch name of the source code.
        :param pulumi.Input['AuthInfoArgs'] source_control_auth_properties: The authorization properties for accessing the source code repository and to set up
               webhooks for notifications.
        """
        pulumi.set(__self__, "repository_url", repository_url)
        pulumi.set(__self__, "source_control_type", source_control_type)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if source_control_auth_properties is not None:
            pulumi.set(__self__, "source_control_auth_properties", source_control_auth_properties)

    @property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Input[str]:
        """
        The full URL to the source code repository
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_url", value)

    @property
    @pulumi.getter(name="sourceControlType")
    def source_control_type(self) -> pulumi.Input[Union[str, 'SourceControlType']]:
        """
        The type of source control service.
        """
        return pulumi.get(self, "source_control_type")

    @source_control_type.setter
    def source_control_type(self, value: pulumi.Input[Union[str, 'SourceControlType']]):
        pulumi.set(self, "source_control_type", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        The branch name of the source code.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="sourceControlAuthProperties")
    def source_control_auth_properties(self) -> Optional[pulumi.Input['AuthInfoArgs']]:
        """
        The authorization properties for accessing the source code repository and to set up
        webhooks for notifications.
        """
        return pulumi.get(self, "source_control_auth_properties")

    @source_control_auth_properties.setter
    def source_control_auth_properties(self, value: Optional[pulumi.Input['AuthInfoArgs']]):
        pulumi.set(self, "source_control_auth_properties", value)


@pulumi.input_type
class SourceRegistryCredentialsArgs:
    def __init__(__self__, *,
                 login_mode: Optional[pulumi.Input[Union[str, 'SourceRegistryLoginMode']]] = None):
        """
        Describes the credential parameters for accessing the source registry.
        :param pulumi.Input[Union[str, 'SourceRegistryLoginMode']] login_mode: The authentication mode which determines the source registry login scope. The credentials for the source registry
               will be generated using the given scope. These credentials will be used to login to
               the source registry during the run.
        """
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[pulumi.Input[Union[str, 'SourceRegistryLoginMode']]]:
        """
        The authentication mode which determines the source registry login scope. The credentials for the source registry
        will be generated using the given scope. These credentials will be used to login to
        the source registry during the run.
        """
        return pulumi.get(self, "login_mode")

    @login_mode.setter
    def login_mode(self, value: Optional[pulumi.Input[Union[str, 'SourceRegistryLoginMode']]]):
        pulumi.set(self, "login_mode", value)


@pulumi.input_type
class SourceTriggerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 source_repository: pulumi.Input['SourcePropertiesArgs'],
                 source_trigger_events: pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]],
                 status: Optional[pulumi.Input[Union[str, 'TriggerStatus']]] = None):
        """
        The properties of a source based trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input['SourcePropertiesArgs'] source_repository: The properties that describes the source(code) for the task.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]] source_trigger_events: The source event corresponding to the trigger.
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of trigger.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source_repository", source_repository)
        pulumi.set(__self__, "source_trigger_events", source_trigger_events)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> pulumi.Input['SourcePropertiesArgs']:
        """
        The properties that describes the source(code) for the task.
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: pulumi.Input['SourcePropertiesArgs']):
        pulumi.set(self, "source_repository", value)

    @property
    @pulumi.getter(name="sourceTriggerEvents")
    def source_trigger_events(self) -> pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]]:
        """
        The source event corresponding to the trigger.
        """
        return pulumi.get(self, "source_trigger_events")

    @source_trigger_events.setter
    def source_trigger_events(self, value: pulumi.Input[Sequence[pulumi.Input[Union[str, 'SourceTriggerEvent']]]]):
        pulumi.set(self, "source_trigger_events", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'TriggerStatus']]]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'TriggerStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class StorageAccountPropertiesArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        The properties of a storage account for a container registry. Only applicable to Classic SKU.
        :param pulumi.Input[str] id: The resource ID of the storage account.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The resource ID of the storage account.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SyncPropertiesArgs:
    def __init__(__self__, *,
                 message_ttl: pulumi.Input[str],
                 token_id: pulumi.Input[str],
                 schedule: Optional[pulumi.Input[str]] = None,
                 sync_window: Optional[pulumi.Input[str]] = None):
        """
        The sync properties of the connected registry with its parent.
        :param pulumi.Input[str] message_ttl: The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        :param pulumi.Input[str] token_id: The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
        :param pulumi.Input[str] schedule: The cron expression indicating the schedule that the connected registry will sync with its parent.
        :param pulumi.Input[str] sync_window: The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        """
        pulumi.set(__self__, "message_ttl", message_ttl)
        pulumi.set(__self__, "token_id", token_id)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if sync_window is not None:
            pulumi.set(__self__, "sync_window", sync_window)

    @property
    @pulumi.getter(name="messageTtl")
    def message_ttl(self) -> pulumi.Input[str]:
        """
        The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        """
        return pulumi.get(self, "message_ttl")

    @message_ttl.setter
    def message_ttl(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_ttl", value)

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "token_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        The cron expression indicating the schedule that the connected registry will sync with its parent.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="syncWindow")
    def sync_window(self) -> Optional[pulumi.Input[str]]:
        """
        The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
        """
        return pulumi.get(self, "sync_window")

    @sync_window.setter
    def sync_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sync_window", value)


@pulumi.input_type
class TaskRunRequestArgs:
    def __init__(__self__, *,
                 task_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 agent_pool_name: Optional[pulumi.Input[str]] = None,
                 is_archive_enabled: Optional[pulumi.Input[bool]] = None,
                 log_template: Optional[pulumi.Input[str]] = None,
                 override_task_step_properties: Optional[pulumi.Input['OverrideTaskStepPropertiesArgs']] = None):
        """
        The parameters for a task run request.
        :param pulumi.Input[str] task_id: The resource ID of task against which run has to be queued.
        :param pulumi.Input[str] type: The type of the run request.
               Expected value is 'TaskRunRequest'.
        :param pulumi.Input[str] agent_pool_name: The dedicated agent pool for the run.
        :param pulumi.Input[bool] is_archive_enabled: The value that indicates whether archiving is enabled for the run or not.
        :param pulumi.Input[str] log_template: The template that describes the repository and tag information for run log artifact.
        :param pulumi.Input['OverrideTaskStepPropertiesArgs'] override_task_step_properties: Set of overridable parameters that can be passed when running a Task.
        """
        pulumi.set(__self__, "task_id", task_id)
        pulumi.set(__self__, "type", 'TaskRunRequest')
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if is_archive_enabled is None:
            is_archive_enabled = False
        if is_archive_enabled is not None:
            pulumi.set(__self__, "is_archive_enabled", is_archive_enabled)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if override_task_step_properties is not None:
            pulumi.set(__self__, "override_task_step_properties", override_task_step_properties)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> pulumi.Input[str]:
        """
        The resource ID of task against which run has to be queued.
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the run request.
        Expected value is 'TaskRunRequest'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated agent pool for the run.
        """
        return pulumi.get(self, "agent_pool_name")

    @agent_pool_name.setter
    def agent_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_pool_name", value)

    @property
    @pulumi.getter(name="isArchiveEnabled")
    def is_archive_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value that indicates whether archiving is enabled for the run or not.
        """
        return pulumi.get(self, "is_archive_enabled")

    @is_archive_enabled.setter
    def is_archive_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archive_enabled", value)

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input[str]]:
        """
        The template that describes the repository and tag information for run log artifact.
        """
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_template", value)

    @property
    @pulumi.getter(name="overrideTaskStepProperties")
    def override_task_step_properties(self) -> Optional[pulumi.Input['OverrideTaskStepPropertiesArgs']]:
        """
        Set of overridable parameters that can be passed when running a Task.
        """
        return pulumi.get(self, "override_task_step_properties")

    @override_task_step_properties.setter
    def override_task_step_properties(self, value: Optional[pulumi.Input['OverrideTaskStepPropertiesArgs']]):
        pulumi.set(self, "override_task_step_properties", value)


@pulumi.input_type
class TimerTriggerArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 schedule: pulumi.Input[str],
                 status: Optional[pulumi.Input[Union[str, 'TriggerStatus']]] = None):
        """
        The properties of a timer trigger.
        :param pulumi.Input[str] name: The name of the trigger.
        :param pulumi.Input[str] schedule: The CRON expression for the task schedule
        :param pulumi.Input[Union[str, 'TriggerStatus']] status: The current status of trigger.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schedule", schedule)
        if status is None:
            status = 'Enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        The CRON expression for the task schedule
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'TriggerStatus']]]:
        """
        The current status of trigger.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'TriggerStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class TokenCertificateArgs:
    def __init__(__self__, *,
                 encoded_pem_certificate: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[Union[str, 'TokenCertificateName']]] = None,
                 thumbprint: Optional[pulumi.Input[str]] = None):
        """
        The properties of a certificate used for authenticating a token.
        :param pulumi.Input[str] encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
        :param pulumi.Input[str] expiry: The expiry datetime of the certificate.
        :param pulumi.Input[str] thumbprint: The thumbprint of the certificate.
        """
        if encoded_pem_certificate is not None:
            pulumi.set(__self__, "encoded_pem_certificate", encoded_pem_certificate)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="encodedPemCertificate")
    def encoded_pem_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
        """
        return pulumi.get(self, "encoded_pem_certificate")

    @encoded_pem_certificate.setter
    def encoded_pem_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded_pem_certificate", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry datetime of the certificate.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'TokenCertificateName']]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'TokenCertificateName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class TokenCredentialsPropertiesArgs:
    def __init__(__self__, *,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['TokenCertificateArgs']]]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input['TokenPasswordArgs']]]] = None):
        """
        The properties of the credentials that can be used for authenticating the token.
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenCertificateArgs']]]]:
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TokenPasswordArgs']]]]:
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TokenPasswordArgs']]]]):
        pulumi.set(self, "passwords", value)


@pulumi.input_type
class TokenPasswordArgs:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[Union[str, 'TokenPasswordName']]] = None):
        """
        The password that will be used for authenticating the token of a container registry.
        :param pulumi.Input[str] creation_time: The creation datetime of the password.
        :param pulumi.Input[str] expiry: The expiry datetime of the password.
        :param pulumi.Input[Union[str, 'TokenPasswordName']] name: The password name "password1" or "password2"
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation datetime of the password.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry datetime of the password.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'TokenPasswordName']]]:
        """
        The password name "password1" or "password2"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'TokenPasswordName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class TriggerPropertiesArgs:
    def __init__(__self__, *,
                 base_image_trigger: Optional[pulumi.Input['BaseImageTriggerArgs']] = None,
                 source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]]] = None,
                 timer_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['TimerTriggerArgs']]]] = None):
        """
        The properties of a trigger.
        :param pulumi.Input['BaseImageTriggerArgs'] base_image_trigger: The trigger based on base image dependencies.
        :param pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]] source_triggers: The collection of triggers based on source code repository.
        :param pulumi.Input[Sequence[pulumi.Input['TimerTriggerArgs']]] timer_triggers: The collection of timer triggers.
        """
        if base_image_trigger is not None:
            pulumi.set(__self__, "base_image_trigger", base_image_trigger)
        if source_triggers is not None:
            pulumi.set(__self__, "source_triggers", source_triggers)
        if timer_triggers is not None:
            pulumi.set(__self__, "timer_triggers", timer_triggers)

    @property
    @pulumi.getter(name="baseImageTrigger")
    def base_image_trigger(self) -> Optional[pulumi.Input['BaseImageTriggerArgs']]:
        """
        The trigger based on base image dependencies.
        """
        return pulumi.get(self, "base_image_trigger")

    @base_image_trigger.setter
    def base_image_trigger(self, value: Optional[pulumi.Input['BaseImageTriggerArgs']]):
        pulumi.set(self, "base_image_trigger", value)

    @property
    @pulumi.getter(name="sourceTriggers")
    def source_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]]]:
        """
        The collection of triggers based on source code repository.
        """
        return pulumi.get(self, "source_triggers")

    @source_triggers.setter
    def source_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceTriggerArgs']]]]):
        pulumi.set(self, "source_triggers", value)

    @property
    @pulumi.getter(name="timerTriggers")
    def timer_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TimerTriggerArgs']]]]:
        """
        The collection of timer triggers.
        """
        return pulumi.get(self, "timer_triggers")

    @timer_triggers.setter
    def timer_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TimerTriggerArgs']]]]):
        pulumi.set(self, "timer_triggers", value)


@pulumi.input_type
class TrustPolicyArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[Union[str, 'PolicyStatus']]] = None,
                 type: Optional[pulumi.Input[Union[str, 'TrustPolicyType']]] = None):
        """
        The content trust policy for a container registry.
        :param pulumi.Input[Union[str, 'PolicyStatus']] status: The value that indicates whether the policy is enabled or not.
        :param pulumi.Input[Union[str, 'TrustPolicyType']] type: The type of trust policy.
        """
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is None:
            type = 'Notary'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PolicyStatus']]]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PolicyStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'TrustPolicyType']]]:
        """
        The type of trust policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'TrustPolicyType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class UserIdentityPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: The client id of user assigned identity.
        :param pulumi.Input[str] principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class VirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 virtual_network_resource_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[Union[str, 'Action']]] = None):
        """
        Virtual network rule.
        :param pulumi.Input[str] virtual_network_resource_id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :param pulumi.Input[Union[str, 'Action']] action: The action of virtual network rule.
        """
        pulumi.set(__self__, "virtual_network_resource_id", virtual_network_resource_id)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="virtualNetworkResourceId")
    def virtual_network_resource_id(self) -> pulumi.Input[str]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "virtual_network_resource_id")

    @virtual_network_resource_id.setter
    def virtual_network_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "virtual_network_resource_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'Action']]]:
        """
        The action of virtual network rule.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'Action']]]):
        pulumi.set(self, "action", value)


