# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['VirtualMachineScaleSetArgs', 'VirtualMachineScaleSet']

@pulumi.input_type
class VirtualMachineScaleSetArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 additional_capabilities: Optional[pulumi.Input['AdditionalCapabilitiesArgs']] = None,
                 automatic_repairs_policy: Optional[pulumi.Input['AutomaticRepairsPolicyArgs']] = None,
                 do_not_run_extensions_on_overprovisioned_vms: Optional[pulumi.Input[bool]] = None,
                 extended_location: Optional[pulumi.Input['ExtendedLocationArgs']] = None,
                 host_group: Optional[pulumi.Input['SubResourceArgs']] = None,
                 identity: Optional[pulumi.Input['VirtualMachineScaleSetIdentityArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 orchestration_mode: Optional[pulumi.Input[Union[str, 'OrchestrationMode']]] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input['PlanArgs']] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 proximity_placement_group: Optional[pulumi.Input['SubResourceArgs']] = None,
                 scale_in_policy: Optional[pulumi.Input['ScaleInPolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 sku: Optional[pulumi.Input['SkuArgs']] = None,
                 spot_restore_policy: Optional[pulumi.Input['SpotRestorePolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input['UpgradePolicyArgs']] = None,
                 virtual_machine_profile: Optional[pulumi.Input['VirtualMachineScaleSetVMProfileArgs']] = None,
                 vm_scale_set_name: Optional[pulumi.Input[str]] = None,
                 zone_balance: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a VirtualMachineScaleSet resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input['AdditionalCapabilitiesArgs'] additional_capabilities: Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
        :param pulumi.Input['AutomaticRepairsPolicyArgs'] automatic_repairs_policy: Policy for automatic repairs.
        :param pulumi.Input[bool] do_not_run_extensions_on_overprovisioned_vms: When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        :param pulumi.Input['ExtendedLocationArgs'] extended_location: The extended location of the Virtual Machine Scale Set.
        :param pulumi.Input['SubResourceArgs'] host_group: Specifies information about the dedicated host group that the virtual machine scale set resides in. <br><br>Minimum api-version: 2020-06-01.
        :param pulumi.Input['VirtualMachineScaleSetIdentityArgs'] identity: The identity of the virtual machine scale set, if configured.
        :param pulumi.Input[str] location: Resource location
        :param pulumi.Input[Union[str, 'OrchestrationMode']] orchestration_mode: Specifies the orchestration mode for the virtual machine scale set.
        :param pulumi.Input[bool] overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
        :param pulumi.Input['PlanArgs'] plan: Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        :param pulumi.Input[int] platform_fault_domain_count: Fault Domain count for each placement group.
        :param pulumi.Input['SubResourceArgs'] proximity_placement_group: Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
        :param pulumi.Input['ScaleInPolicyArgs'] scale_in_policy: Specifies the scale-in policy that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled-in.
        :param pulumi.Input[bool] single_placement_group: When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :param pulumi.Input['SkuArgs'] sku: The virtual machine scale set sku.
        :param pulumi.Input['SpotRestorePolicyArgs'] spot_restore_policy: Specifies the Spot Restore properties for the virtual machine scale set.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input['UpgradePolicyArgs'] upgrade_policy: The upgrade policy.
        :param pulumi.Input['VirtualMachineScaleSetVMProfileArgs'] virtual_machine_profile: The virtual machine profile.
        :param pulumi.Input[str] vm_scale_set_name: The name of the VM scale set to create or update.
        :param pulumi.Input[bool] zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if additional_capabilities is not None:
            pulumi.set(__self__, "additional_capabilities", additional_capabilities)
        if automatic_repairs_policy is not None:
            pulumi.set(__self__, "automatic_repairs_policy", automatic_repairs_policy)
        if do_not_run_extensions_on_overprovisioned_vms is not None:
            pulumi.set(__self__, "do_not_run_extensions_on_overprovisioned_vms", do_not_run_extensions_on_overprovisioned_vms)
        if extended_location is not None:
            pulumi.set(__self__, "extended_location", extended_location)
        if host_group is not None:
            pulumi.set(__self__, "host_group", host_group)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if orchestration_mode is not None:
            pulumi.set(__self__, "orchestration_mode", orchestration_mode)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if platform_fault_domain_count is not None:
            pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if proximity_placement_group is not None:
            pulumi.set(__self__, "proximity_placement_group", proximity_placement_group)
        if scale_in_policy is not None:
            pulumi.set(__self__, "scale_in_policy", scale_in_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if spot_restore_policy is not None:
            pulumi.set(__self__, "spot_restore_policy", spot_restore_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if virtual_machine_profile is not None:
            pulumi.set(__self__, "virtual_machine_profile", virtual_machine_profile)
        if vm_scale_set_name is not None:
            pulumi.set(__self__, "vm_scale_set_name", vm_scale_set_name)
        if zone_balance is not None:
            pulumi.set(__self__, "zone_balance", zone_balance)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> Optional[pulumi.Input['AdditionalCapabilitiesArgs']]:
        """
        Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
        """
        return pulumi.get(self, "additional_capabilities")

    @additional_capabilities.setter
    def additional_capabilities(self, value: Optional[pulumi.Input['AdditionalCapabilitiesArgs']]):
        pulumi.set(self, "additional_capabilities", value)

    @property
    @pulumi.getter(name="automaticRepairsPolicy")
    def automatic_repairs_policy(self) -> Optional[pulumi.Input['AutomaticRepairsPolicyArgs']]:
        """
        Policy for automatic repairs.
        """
        return pulumi.get(self, "automatic_repairs_policy")

    @automatic_repairs_policy.setter
    def automatic_repairs_policy(self, value: Optional[pulumi.Input['AutomaticRepairsPolicyArgs']]):
        pulumi.set(self, "automatic_repairs_policy", value)

    @property
    @pulumi.getter(name="doNotRunExtensionsOnOverprovisionedVMs")
    def do_not_run_extensions_on_overprovisioned_vms(self) -> Optional[pulumi.Input[bool]]:
        """
        When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        """
        return pulumi.get(self, "do_not_run_extensions_on_overprovisioned_vms")

    @do_not_run_extensions_on_overprovisioned_vms.setter
    def do_not_run_extensions_on_overprovisioned_vms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "do_not_run_extensions_on_overprovisioned_vms", value)

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> Optional[pulumi.Input['ExtendedLocationArgs']]:
        """
        The extended location of the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "extended_location")

    @extended_location.setter
    def extended_location(self, value: Optional[pulumi.Input['ExtendedLocationArgs']]):
        pulumi.set(self, "extended_location", value)

    @property
    @pulumi.getter(name="hostGroup")
    def host_group(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Specifies information about the dedicated host group that the virtual machine scale set resides in. <br><br>Minimum api-version: 2020-06-01.
        """
        return pulumi.get(self, "host_group")

    @host_group.setter
    def host_group(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "host_group", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['VirtualMachineScaleSetIdentityArgs']]:
        """
        The identity of the virtual machine scale set, if configured.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['VirtualMachineScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="orchestrationMode")
    def orchestration_mode(self) -> Optional[pulumi.Input[Union[str, 'OrchestrationMode']]]:
        """
        Specifies the orchestration mode for the virtual machine scale set.
        """
        return pulumi.get(self, "orchestration_mode")

    @orchestration_mode.setter
    def orchestration_mode(self, value: Optional[pulumi.Input[Union[str, 'OrchestrationMode']]]):
        pulumi.set(self, "orchestration_mode", value)

    @property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the Virtual Machine Scale Set should be overprovisioned.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overprovision", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['PlanArgs']]:
        """
        Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['PlanArgs']]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> Optional[pulumi.Input[int]]:
        """
        Fault Domain count for each placement group.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @platform_fault_domain_count.setter
    def platform_fault_domain_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "platform_fault_domain_count", value)

    @property
    @pulumi.getter(name="proximityPlacementGroup")
    def proximity_placement_group(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
        """
        return pulumi.get(self, "proximity_placement_group")

    @proximity_placement_group.setter
    def proximity_placement_group(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "proximity_placement_group", value)

    @property
    @pulumi.getter(name="scaleInPolicy")
    def scale_in_policy(self) -> Optional[pulumi.Input['ScaleInPolicyArgs']]:
        """
        Specifies the scale-in policy that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled-in.
        """
        return pulumi.get(self, "scale_in_policy")

    @scale_in_policy.setter
    def scale_in_policy(self, value: Optional[pulumi.Input['ScaleInPolicyArgs']]):
        pulumi.set(self, "scale_in_policy", value)

    @property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[bool]]:
        """
        When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "single_placement_group", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['SkuArgs']]:
        """
        The virtual machine scale set sku.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['SkuArgs']]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="spotRestorePolicy")
    def spot_restore_policy(self) -> Optional[pulumi.Input['SpotRestorePolicyArgs']]:
        """
        Specifies the Spot Restore properties for the virtual machine scale set.
        """
        return pulumi.get(self, "spot_restore_policy")

    @spot_restore_policy.setter
    def spot_restore_policy(self, value: Optional[pulumi.Input['SpotRestorePolicyArgs']]):
        pulumi.set(self, "spot_restore_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['UpgradePolicyArgs']]:
        """
        The upgrade policy.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['UpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @property
    @pulumi.getter(name="virtualMachineProfile")
    def virtual_machine_profile(self) -> Optional[pulumi.Input['VirtualMachineScaleSetVMProfileArgs']]:
        """
        The virtual machine profile.
        """
        return pulumi.get(self, "virtual_machine_profile")

    @virtual_machine_profile.setter
    def virtual_machine_profile(self, value: Optional[pulumi.Input['VirtualMachineScaleSetVMProfileArgs']]):
        pulumi.set(self, "virtual_machine_profile", value)

    @property
    @pulumi.getter(name="vmScaleSetName")
    def vm_scale_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VM scale set to create or update.
        """
        return pulumi.get(self, "vm_scale_set_name")

    @vm_scale_set_name.setter
    def vm_scale_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_scale_set_name", value)

    @property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
        """
        return pulumi.get(self, "zone_balance")

    @zone_balance.setter
    def zone_balance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "zone_balance", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


class VirtualMachineScaleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[pulumi.InputType['AdditionalCapabilitiesArgs']]] = None,
                 automatic_repairs_policy: Optional[pulumi.Input[pulumi.InputType['AutomaticRepairsPolicyArgs']]] = None,
                 do_not_run_extensions_on_overprovisioned_vms: Optional[pulumi.Input[bool]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 host_group: Optional[pulumi.Input[pulumi.InputType['SubResourceArgs']]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['VirtualMachineScaleSetIdentityArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 orchestration_mode: Optional[pulumi.Input[Union[str, 'OrchestrationMode']]] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[pulumi.InputType['PlanArgs']]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 proximity_placement_group: Optional[pulumi.Input[pulumi.InputType['SubResourceArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 scale_in_policy: Optional[pulumi.Input[pulumi.InputType['ScaleInPolicyArgs']]] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 sku: Optional[pulumi.Input[pulumi.InputType['SkuArgs']]] = None,
                 spot_restore_policy: Optional[pulumi.Input[pulumi.InputType['SpotRestorePolicyArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[pulumi.InputType['UpgradePolicyArgs']]] = None,
                 virtual_machine_profile: Optional[pulumi.Input[pulumi.InputType['VirtualMachineScaleSetVMProfileArgs']]] = None,
                 vm_scale_set_name: Optional[pulumi.Input[str]] = None,
                 zone_balance: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Describes a Virtual Machine Scale Set.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AdditionalCapabilitiesArgs']] additional_capabilities: Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
        :param pulumi.Input[pulumi.InputType['AutomaticRepairsPolicyArgs']] automatic_repairs_policy: Policy for automatic repairs.
        :param pulumi.Input[bool] do_not_run_extensions_on_overprovisioned_vms: When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        :param pulumi.Input[pulumi.InputType['ExtendedLocationArgs']] extended_location: The extended location of the Virtual Machine Scale Set.
        :param pulumi.Input[pulumi.InputType['SubResourceArgs']] host_group: Specifies information about the dedicated host group that the virtual machine scale set resides in. <br><br>Minimum api-version: 2020-06-01.
        :param pulumi.Input[pulumi.InputType['VirtualMachineScaleSetIdentityArgs']] identity: The identity of the virtual machine scale set, if configured.
        :param pulumi.Input[str] location: Resource location
        :param pulumi.Input[Union[str, 'OrchestrationMode']] orchestration_mode: Specifies the orchestration mode for the virtual machine scale set.
        :param pulumi.Input[bool] overprovision: Specifies whether the Virtual Machine Scale Set should be overprovisioned.
        :param pulumi.Input[pulumi.InputType['PlanArgs']] plan: Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        :param pulumi.Input[int] platform_fault_domain_count: Fault Domain count for each placement group.
        :param pulumi.Input[pulumi.InputType['SubResourceArgs']] proximity_placement_group: Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
        :param pulumi.Input[str] resource_group_name: The name of the resource group.
        :param pulumi.Input[pulumi.InputType['ScaleInPolicyArgs']] scale_in_policy: Specifies the scale-in policy that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled-in.
        :param pulumi.Input[bool] single_placement_group: When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        :param pulumi.Input[pulumi.InputType['SkuArgs']] sku: The virtual machine scale set sku.
        :param pulumi.Input[pulumi.InputType['SpotRestorePolicyArgs']] spot_restore_policy: Specifies the Spot Restore properties for the virtual machine scale set.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags
        :param pulumi.Input[pulumi.InputType['UpgradePolicyArgs']] upgrade_policy: The upgrade policy.
        :param pulumi.Input[pulumi.InputType['VirtualMachineScaleSetVMProfileArgs']] virtual_machine_profile: The virtual machine profile.
        :param pulumi.Input[str] vm_scale_set_name: The name of the VM scale set to create or update.
        :param pulumi.Input[bool] zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineScaleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Describes a Virtual Machine Scale Set.

        :param str resource_name: The name of the resource.
        :param VirtualMachineScaleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineScaleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_capabilities: Optional[pulumi.Input[pulumi.InputType['AdditionalCapabilitiesArgs']]] = None,
                 automatic_repairs_policy: Optional[pulumi.Input[pulumi.InputType['AutomaticRepairsPolicyArgs']]] = None,
                 do_not_run_extensions_on_overprovisioned_vms: Optional[pulumi.Input[bool]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 host_group: Optional[pulumi.Input[pulumi.InputType['SubResourceArgs']]] = None,
                 identity: Optional[pulumi.Input[pulumi.InputType['VirtualMachineScaleSetIdentityArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 orchestration_mode: Optional[pulumi.Input[Union[str, 'OrchestrationMode']]] = None,
                 overprovision: Optional[pulumi.Input[bool]] = None,
                 plan: Optional[pulumi.Input[pulumi.InputType['PlanArgs']]] = None,
                 platform_fault_domain_count: Optional[pulumi.Input[int]] = None,
                 proximity_placement_group: Optional[pulumi.Input[pulumi.InputType['SubResourceArgs']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 scale_in_policy: Optional[pulumi.Input[pulumi.InputType['ScaleInPolicyArgs']]] = None,
                 single_placement_group: Optional[pulumi.Input[bool]] = None,
                 sku: Optional[pulumi.Input[pulumi.InputType['SkuArgs']]] = None,
                 spot_restore_policy: Optional[pulumi.Input[pulumi.InputType['SpotRestorePolicyArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[pulumi.InputType['UpgradePolicyArgs']]] = None,
                 virtual_machine_profile: Optional[pulumi.Input[pulumi.InputType['VirtualMachineScaleSetVMProfileArgs']]] = None,
                 vm_scale_set_name: Optional[pulumi.Input[str]] = None,
                 zone_balance: Optional[pulumi.Input[bool]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineScaleSetArgs.__new__(VirtualMachineScaleSetArgs)

            __props__.__dict__["additional_capabilities"] = additional_capabilities
            __props__.__dict__["automatic_repairs_policy"] = automatic_repairs_policy
            __props__.__dict__["do_not_run_extensions_on_overprovisioned_vms"] = do_not_run_extensions_on_overprovisioned_vms
            __props__.__dict__["extended_location"] = extended_location
            __props__.__dict__["host_group"] = host_group
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["orchestration_mode"] = orchestration_mode
            __props__.__dict__["overprovision"] = overprovision
            __props__.__dict__["plan"] = plan
            __props__.__dict__["platform_fault_domain_count"] = platform_fault_domain_count
            __props__.__dict__["proximity_placement_group"] = proximity_placement_group
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["scale_in_policy"] = scale_in_policy
            __props__.__dict__["single_placement_group"] = single_placement_group
            __props__.__dict__["sku"] = sku
            __props__.__dict__["spot_restore_policy"] = spot_restore_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgrade_policy"] = upgrade_policy
            __props__.__dict__["virtual_machine_profile"] = virtual_machine_profile
            __props__.__dict__["vm_scale_set_name"] = vm_scale_set_name
            __props__.__dict__["zone_balance"] = zone_balance
            __props__.__dict__["zones"] = zones
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["unique_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-nextgen:compute/v20210401:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20150615:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20150615:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20160330:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20160330:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20160430preview:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20160430preview:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20170330:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20170330:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20171201:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20171201:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20180401:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20180401:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20180601:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20180601:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20181001:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20181001:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20190301:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20190301:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20190701:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20190701:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20191201:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20191201:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20200601:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20200601:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20201201:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20201201:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20210301:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20210301:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-native:compute/v20210701:VirtualMachineScaleSet"), pulumi.Alias(type_="azure-nextgen:compute/v20210701:VirtualMachineScaleSet")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(VirtualMachineScaleSet, __self__).__init__(
            'azure-native:compute/v20210401:VirtualMachineScaleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VirtualMachineScaleSet':
        """
        Get an existing VirtualMachineScaleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VirtualMachineScaleSetArgs.__new__(VirtualMachineScaleSetArgs)

        __props__.__dict__["additional_capabilities"] = None
        __props__.__dict__["automatic_repairs_policy"] = None
        __props__.__dict__["do_not_run_extensions_on_overprovisioned_vms"] = None
        __props__.__dict__["extended_location"] = None
        __props__.__dict__["host_group"] = None
        __props__.__dict__["identity"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["orchestration_mode"] = None
        __props__.__dict__["overprovision"] = None
        __props__.__dict__["plan"] = None
        __props__.__dict__["platform_fault_domain_count"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["proximity_placement_group"] = None
        __props__.__dict__["scale_in_policy"] = None
        __props__.__dict__["single_placement_group"] = None
        __props__.__dict__["sku"] = None
        __props__.__dict__["spot_restore_policy"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["unique_id"] = None
        __props__.__dict__["upgrade_policy"] = None
        __props__.__dict__["virtual_machine_profile"] = None
        __props__.__dict__["zone_balance"] = None
        __props__.__dict__["zones"] = None
        return VirtualMachineScaleSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalCapabilities")
    def additional_capabilities(self) -> pulumi.Output[Optional['outputs.AdditionalCapabilitiesResponse']]:
        """
        Specifies additional capabilities enabled or disabled on the Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines have the capability to support attaching managed data disks with UltraSSD_LRS storage account type.
        """
        return pulumi.get(self, "additional_capabilities")

    @property
    @pulumi.getter(name="automaticRepairsPolicy")
    def automatic_repairs_policy(self) -> pulumi.Output[Optional['outputs.AutomaticRepairsPolicyResponse']]:
        """
        Policy for automatic repairs.
        """
        return pulumi.get(self, "automatic_repairs_policy")

    @property
    @pulumi.getter(name="doNotRunExtensionsOnOverprovisionedVMs")
    def do_not_run_extensions_on_overprovisioned_vms(self) -> pulumi.Output[Optional[bool]]:
        """
        When Overprovision is enabled, extensions are launched only on the requested number of VMs which are finally kept. This property will hence ensure that the extensions do not run on the extra overprovisioned VMs.
        """
        return pulumi.get(self, "do_not_run_extensions_on_overprovisioned_vms")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Output[Optional['outputs.ExtendedLocationResponse']]:
        """
        The extended location of the Virtual Machine Scale Set.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter(name="hostGroup")
    def host_group(self) -> pulumi.Output[Optional['outputs.SubResourceResponse']]:
        """
        Specifies information about the dedicated host group that the virtual machine scale set resides in. <br><br>Minimum api-version: 2020-06-01.
        """
        return pulumi.get(self, "host_group")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.VirtualMachineScaleSetIdentityResponse']]:
        """
        The identity of the virtual machine scale set, if configured.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Resource location
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="orchestrationMode")
    def orchestration_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the orchestration mode for the virtual machine scale set.
        """
        return pulumi.get(self, "orchestration_mode")

    @property
    @pulumi.getter
    def overprovision(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the Virtual Machine Scale Set should be overprovisioned.
        """
        return pulumi.get(self, "overprovision")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional['outputs.PlanResponse']]:
        """
        Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> pulumi.Output[Optional[int]]:
        """
        Fault Domain count for each placement group.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state, which only appears in the response.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="proximityPlacementGroup")
    def proximity_placement_group(self) -> pulumi.Output[Optional['outputs.SubResourceResponse']]:
        """
        Specifies information about the proximity placement group that the virtual machine scale set should be assigned to. <br><br>Minimum api-version: 2018-04-01.
        """
        return pulumi.get(self, "proximity_placement_group")

    @property
    @pulumi.getter(name="scaleInPolicy")
    def scale_in_policy(self) -> pulumi.Output[Optional['outputs.ScaleInPolicyResponse']]:
        """
        Specifies the scale-in policy that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled-in.
        """
        return pulumi.get(self, "scale_in_policy")

    @property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> pulumi.Output[Optional[bool]]:
        """
        When true this limits the scale set to a single placement group, of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to false. However, if singlePlacementGroup is false, it may not be modified to true.
        """
        return pulumi.get(self, "single_placement_group")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional['outputs.SkuResponse']]:
        """
        The virtual machine scale set sku.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="spotRestorePolicy")
    def spot_restore_policy(self) -> pulumi.Output[Optional['outputs.SpotRestorePolicyResponse']]:
        """
        Specifies the Spot Restore properties for the virtual machine scale set.
        """
        return pulumi.get(self, "spot_restore_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Resource type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
        """
        return pulumi.get(self, "unique_id")

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> pulumi.Output[Optional['outputs.UpgradePolicyResponse']]:
        """
        The upgrade policy.
        """
        return pulumi.get(self, "upgrade_policy")

    @property
    @pulumi.getter(name="virtualMachineProfile")
    def virtual_machine_profile(self) -> pulumi.Output[Optional['outputs.VirtualMachineScaleSetVMProfileResponse']]:
        """
        The virtual machine profile.
        """
        return pulumi.get(self, "virtual_machine_profile")

    @property
    @pulumi.getter(name="zoneBalance")
    def zone_balance(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to force strictly even Virtual Machine distribution cross x-zones in case there is zone outage. zoneBalance property can only be set if the zones property of the scale set contains more than one zone. If there are no zones or only one zone specified, then zoneBalance property should not be set.
        """
        return pulumi.get(self, "zone_balance")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The virtual machine scale set zones. NOTE: Availability zones can only be set when you create the scale set
        """
        return pulumi.get(self, "zones")

