# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CacheExpirationActionParametersResponse',
    'CacheKeyQueryStringActionParametersResponse',
    'CookiesMatchConditionParametersResponse',
    'DeepCreatedOriginGroupResponse',
    'DeepCreatedOriginResponse',
    'DeliveryRuleCacheExpirationActionResponse',
    'DeliveryRuleCacheKeyQueryStringActionResponse',
    'DeliveryRuleCookiesConditionResponse',
    'DeliveryRuleHttpVersionConditionResponse',
    'DeliveryRuleIsDeviceConditionResponse',
    'DeliveryRulePostArgsConditionResponse',
    'DeliveryRuleQueryStringConditionResponse',
    'DeliveryRuleRemoteAddressConditionResponse',
    'DeliveryRuleRequestBodyConditionResponse',
    'DeliveryRuleRequestHeaderActionResponse',
    'DeliveryRuleRequestHeaderConditionResponse',
    'DeliveryRuleRequestMethodConditionResponse',
    'DeliveryRuleRequestSchemeConditionResponse',
    'DeliveryRuleRequestUriConditionResponse',
    'DeliveryRuleResponse',
    'DeliveryRuleResponseHeaderActionResponse',
    'DeliveryRuleUrlFileExtensionConditionResponse',
    'DeliveryRuleUrlFileNameConditionResponse',
    'DeliveryRuleUrlPathConditionResponse',
    'EndpointPropertiesUpdateParametersResponseDeliveryPolicy',
    'GeoFilterResponse',
    'HeaderActionParametersResponse',
    'HealthProbeParametersResponse',
    'HttpErrorRangeParametersResponse',
    'HttpVersionMatchConditionParametersResponse',
    'IsDeviceMatchConditionParametersResponse',
    'OriginGroupOverrideActionParametersResponse',
    'OriginGroupOverrideActionResponse',
    'PostArgsMatchConditionParametersResponse',
    'QueryStringMatchConditionParametersResponse',
    'RemoteAddressMatchConditionParametersResponse',
    'RequestBodyMatchConditionParametersResponse',
    'RequestHeaderMatchConditionParametersResponse',
    'RequestMethodMatchConditionParametersResponse',
    'RequestSchemeMatchConditionParametersResponse',
    'RequestUriMatchConditionParametersResponse',
    'ResourceReferenceResponse',
    'ResponseBasedOriginErrorDetectionParametersResponse',
    'SkuResponse',
    'UrlFileExtensionMatchConditionParametersResponse',
    'UrlFileNameMatchConditionParametersResponse',
    'UrlPathMatchConditionParametersResponse',
    'UrlRedirectActionParametersResponse',
    'UrlRedirectActionResponse',
    'UrlRewriteActionParametersResponse',
    'UrlRewriteActionResponse',
]

@pulumi.output_type
class CacheExpirationActionParametersResponse(dict):
    """
    Defines the parameters for the cache expiration action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheBehavior":
            suggest = "cache_behavior"
        elif key == "cacheType":
            suggest = "cache_type"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "cacheDuration":
            suggest = "cache_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheExpirationActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheExpirationActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheExpirationActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_behavior: str,
                 cache_type: str,
                 odata_type: str,
                 cache_duration: Optional[str] = None):
        """
        Defines the parameters for the cache expiration action.
        :param str cache_behavior: Caching behavior for the requests
        :param str cache_type: The level at which the content needs to be cached.
        :param str cache_duration: The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
        """
        pulumi.set(__self__, "cache_behavior", cache_behavior)
        pulumi.set(__self__, "cache_type", cache_type)
        pulumi.set(__self__, "odata_type", odata_type)
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)

    @property
    @pulumi.getter(name="cacheBehavior")
    def cache_behavior(self) -> str:
        """
        Caching behavior for the requests
        """
        return pulumi.get(self, "cache_behavior")

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> str:
        """
        The level at which the content needs to be cached.
        """
        return pulumi.get(self, "cache_type")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[str]:
        """
        The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
        """
        return pulumi.get(self, "cache_duration")


@pulumi.output_type
class CacheKeyQueryStringActionParametersResponse(dict):
    """
    Defines the parameters for the cache-key query string action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheKeyQueryStringActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheKeyQueryStringActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheKeyQueryStringActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 query_string_behavior: str,
                 query_parameters: Optional[str] = None):
        """
        Defines the parameters for the cache-key query string action.
        :param str query_string_behavior: Caching behavior for the requests
        :param str query_parameters: query parameters to include or exclude (comma separated).
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> str:
        """
        Caching behavior for the requests
        """
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[str]:
        """
        query parameters to include or exclude (comma separated).
        """
        return pulumi.get(self, "query_parameters")


@pulumi.output_type
class CookiesMatchConditionParametersResponse(dict):
    """
    Defines the parameters for Cookies match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CookiesMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CookiesMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CookiesMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for Cookies match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of Cookies to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of Cookies to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class DeepCreatedOriginGroupResponse(dict):
    """
    The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthProbeSettings":
            suggest = "health_probe_settings"
        elif key == "responseBasedOriginErrorDetectionSettings":
            suggest = "response_based_origin_error_detection_settings"
        elif key == "trafficRestorationTimeToHealedOrNewEndpointsInMinutes":
            suggest = "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeepCreatedOriginGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeepCreatedOriginGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeepCreatedOriginGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 origins: Sequence['outputs.ResourceReferenceResponse'],
                 health_probe_settings: Optional['outputs.HealthProbeParametersResponse'] = None,
                 response_based_origin_error_detection_settings: Optional['outputs.ResponseBasedOriginErrorDetectionParametersResponse'] = None,
                 traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Optional[int] = None):
        """
        The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent to the origins within the origin group based on origin health.
        :param str name: Origin group name which must be unique within the endpoint.
        :param Sequence['ResourceReferenceResponse'] origins: The source of the content being delivered via CDN within given origin group.
        :param 'HealthProbeParametersResponse' health_probe_settings: Health probe settings to the origin that is used to determine the health of the origin.
        :param 'ResponseBasedOriginErrorDetectionParametersResponse' response_based_origin_error_detection_settings: The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
        :param int traffic_restoration_time_to_healed_or_new_endpoints_in_minutes: Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "origins", origins)
        if health_probe_settings is not None:
            pulumi.set(__self__, "health_probe_settings", health_probe_settings)
        if response_based_origin_error_detection_settings is not None:
            pulumi.set(__self__, "response_based_origin_error_detection_settings", response_based_origin_error_detection_settings)
        if traffic_restoration_time_to_healed_or_new_endpoints_in_minutes is not None:
            pulumi.set(__self__, "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes", traffic_restoration_time_to_healed_or_new_endpoints_in_minutes)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Origin group name which must be unique within the endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def origins(self) -> Sequence['outputs.ResourceReferenceResponse']:
        """
        The source of the content being delivered via CDN within given origin group.
        """
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="healthProbeSettings")
    def health_probe_settings(self) -> Optional['outputs.HealthProbeParametersResponse']:
        """
        Health probe settings to the origin that is used to determine the health of the origin.
        """
        return pulumi.get(self, "health_probe_settings")

    @property
    @pulumi.getter(name="responseBasedOriginErrorDetectionSettings")
    def response_based_origin_error_detection_settings(self) -> Optional['outputs.ResponseBasedOriginErrorDetectionParametersResponse']:
        """
        The JSON object that contains the properties to determine origin health using real requests/responses.This property is currently not supported.
        """
        return pulumi.get(self, "response_based_origin_error_detection_settings")

    @property
    @pulumi.getter(name="trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    def traffic_restoration_time_to_healed_or_new_endpoints_in_minutes(self) -> Optional[int]:
        """
        Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint is added. Default is 10 mins. This property is currently not supported.
        """
        return pulumi.get(self, "traffic_restoration_time_to_healed_or_new_endpoints_in_minutes")


@pulumi.output_type
class DeepCreatedOriginResponse(dict):
    """
    The main origin of CDN content which is added when creating a CDN endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "originHostHeader":
            suggest = "origin_host_header"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeepCreatedOriginResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeepCreatedOriginResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeepCreatedOriginResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 name: str,
                 enabled: Optional[bool] = None,
                 http_port: Optional[int] = None,
                 https_port: Optional[int] = None,
                 origin_host_header: Optional[str] = None,
                 priority: Optional[int] = None,
                 weight: Optional[int] = None):
        """
        The main origin of CDN content which is added when creating a CDN endpoint.
        :param str host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint.
        :param str name: Origin name which must be unique within the endpoint. 
        :param bool enabled: Origin is enabled for load balancing or not. By default, origin is always enabled.
        :param int http_port: The value of the HTTP port. Must be between 1 and 65535.
        :param int https_port: The value of the HTTPS port. Must be between 1 and 65535.
        :param str origin_host_header: The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. If endpoint uses multiple origins for load balancing, then the host header at endpoint is ignored and this one is considered.
        :param int priority: Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
        :param int weight: Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "name", name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if origin_host_header is not None:
            pulumi.set(__self__, "origin_host_header", origin_host_header)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across all origins in an endpoint.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Origin name which must be unique within the endpoint. 
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Origin is enabled for load balancing or not. By default, origin is always enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The value of the HTTP port. Must be between 1 and 65535.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[int]:
        """
        The value of the HTTPS port. Must be between 1 and 65535.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> Optional[str]:
        """
        The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default. If endpoint uses multiple origins for load balancing, then the host header at endpoint is ignored and this one is considered.
        """
        return pulumi.get(self, "origin_host_header")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy.Must be between 1 and 5.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class DeliveryRuleCacheExpirationActionResponse(dict):
    """
    Defines the cache expiration action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.CacheExpirationActionParametersResponse'):
        """
        Defines the cache expiration action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'CacheExpiration'.
        :param 'CacheExpirationActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'CacheExpiration')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'CacheExpiration'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.CacheExpirationActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleCacheKeyQueryStringActionResponse(dict):
    """
    Defines the cache-key query string action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.CacheKeyQueryStringActionParametersResponse'):
        """
        Defines the cache-key query string action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'CacheKeyQueryString'.
        :param 'CacheKeyQueryStringActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'CacheKeyQueryString')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'CacheKeyQueryString'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.CacheKeyQueryStringActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleCookiesConditionResponse(dict):
    """
    Defines the Cookies condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.CookiesMatchConditionParametersResponse'):
        """
        Defines the Cookies condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'Cookies'.
        :param 'CookiesMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'Cookies')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'Cookies'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.CookiesMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleHttpVersionConditionResponse(dict):
    """
    Defines the HttpVersion condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.HttpVersionMatchConditionParametersResponse'):
        """
        Defines the HttpVersion condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'HttpVersion'.
        :param 'HttpVersionMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'HttpVersion')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'HttpVersion'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.HttpVersionMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleIsDeviceConditionResponse(dict):
    """
    Defines the IsDevice condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.IsDeviceMatchConditionParametersResponse'):
        """
        Defines the IsDevice condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'IsDevice'.
        :param 'IsDeviceMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'IsDevice')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'IsDevice'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.IsDeviceMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRulePostArgsConditionResponse(dict):
    """
    Defines the PostArgs condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.PostArgsMatchConditionParametersResponse'):
        """
        Defines the PostArgs condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'PostArgs'.
        :param 'PostArgsMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'PostArgs')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'PostArgs'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.PostArgsMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleQueryStringConditionResponse(dict):
    """
    Defines the QueryString condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.QueryStringMatchConditionParametersResponse'):
        """
        Defines the QueryString condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'QueryString'.
        :param 'QueryStringMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'QueryString')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'QueryString'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.QueryStringMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRemoteAddressConditionResponse(dict):
    """
    Defines the RemoteAddress condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RemoteAddressMatchConditionParametersResponse'):
        """
        Defines the RemoteAddress condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RemoteAddress'.
        :param 'RemoteAddressMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RemoteAddress')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RemoteAddress'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RemoteAddressMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestBodyConditionResponse(dict):
    """
    Defines the RequestBody condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestBodyMatchConditionParametersResponse'):
        """
        Defines the RequestBody condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestBody'.
        :param 'RequestBodyMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestBody')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestBody'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestBodyMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestHeaderActionResponse(dict):
    """
    Defines the request header action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.HeaderActionParametersResponse'):
        """
        Defines the request header action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'ModifyRequestHeader'.
        :param 'HeaderActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'ModifyRequestHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'ModifyRequestHeader'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.HeaderActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestHeaderConditionResponse(dict):
    """
    Defines the RequestHeader condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestHeaderMatchConditionParametersResponse'):
        """
        Defines the RequestHeader condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestHeader'.
        :param 'RequestHeaderMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestHeader'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestHeaderMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestMethodConditionResponse(dict):
    """
    Defines the RequestMethod condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestMethodMatchConditionParametersResponse'):
        """
        Defines the RequestMethod condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestMethod'.
        :param 'RequestMethodMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestMethod')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestMethod'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestMethodMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestSchemeConditionResponse(dict):
    """
    Defines the RequestScheme condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestSchemeMatchConditionParametersResponse'):
        """
        Defines the RequestScheme condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestScheme'.
        :param 'RequestSchemeMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestScheme')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestScheme'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestSchemeMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestUriConditionResponse(dict):
    """
    Defines the RequestUri condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestUriMatchConditionParametersResponse'):
        """
        Defines the RequestUri condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestUri'.
        :param 'RequestUriMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestUri')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestUri'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestUriMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleResponse(dict):
    """
    A rule that specifies a set of actions and conditions
    """
    def __init__(__self__, *,
                 actions: Sequence[Any],
                 order: int,
                 conditions: Optional[Sequence[Any]] = None,
                 name: Optional[str] = None):
        """
        A rule that specifies a set of actions and conditions
        :param Sequence[Union['DeliveryRuleCacheExpirationActionResponse', 'DeliveryRuleCacheKeyQueryStringActionResponse', 'DeliveryRuleRequestHeaderActionResponse', 'DeliveryRuleResponseHeaderActionResponse', 'OriginGroupOverrideActionResponse', 'UrlRedirectActionResponse', 'UrlRewriteActionResponse']] actions: A list of actions that are executed when all the conditions of a rule are satisfied.
        :param int order: The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
        :param Sequence[Union['DeliveryRuleCookiesConditionResponse', 'DeliveryRuleHttpVersionConditionResponse', 'DeliveryRuleIsDeviceConditionResponse', 'DeliveryRulePostArgsConditionResponse', 'DeliveryRuleQueryStringConditionResponse', 'DeliveryRuleRemoteAddressConditionResponse', 'DeliveryRuleRequestBodyConditionResponse', 'DeliveryRuleRequestHeaderConditionResponse', 'DeliveryRuleRequestMethodConditionResponse', 'DeliveryRuleRequestSchemeConditionResponse', 'DeliveryRuleRequestUriConditionResponse', 'DeliveryRuleUrlFileExtensionConditionResponse', 'DeliveryRuleUrlFileNameConditionResponse', 'DeliveryRuleUrlPathConditionResponse']] conditions: A list of conditions that must be matched for the actions to be executed
        :param str name: Name of the rule
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "order", order)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[Any]:
        """
        A list of actions that are executed when all the conditions of a rule are satisfied.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence[Any]]:
        """
        A list of conditions that must be matched for the actions to be executed
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeliveryRuleResponseHeaderActionResponse(dict):
    """
    Defines the response header action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.HeaderActionParametersResponse'):
        """
        Defines the response header action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'ModifyResponseHeader'.
        :param 'HeaderActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'ModifyResponseHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'ModifyResponseHeader'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.HeaderActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleUrlFileExtensionConditionResponse(dict):
    """
    Defines the UrlFileExtension condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlFileExtensionMatchConditionParametersResponse'):
        """
        Defines the UrlFileExtension condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'UrlFileExtension'.
        :param 'UrlFileExtensionMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlFileExtension')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlFileExtension'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlFileExtensionMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleUrlFileNameConditionResponse(dict):
    """
    Defines the UrlFileName condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlFileNameMatchConditionParametersResponse'):
        """
        Defines the UrlFileName condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'UrlFileName'.
        :param 'UrlFileNameMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlFileName')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlFileName'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlFileNameMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleUrlPathConditionResponse(dict):
    """
    Defines the UrlPath condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlPathMatchConditionParametersResponse'):
        """
        Defines the UrlPath condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'UrlPath'.
        :param 'UrlPathMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlPath')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlPath'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlPathMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class EndpointPropertiesUpdateParametersResponseDeliveryPolicy(dict):
    """
    A policy that specifies the delivery rules to be used for an endpoint.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.DeliveryRuleResponse'],
                 description: Optional[str] = None):
        """
        A policy that specifies the delivery rules to be used for an endpoint.
        :param Sequence['DeliveryRuleResponse'] rules: A list of the delivery rules.
        :param str description: User-friendly description of the policy.
        """
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.DeliveryRuleResponse']:
        """
        A list of the delivery rules.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User-friendly description of the policy.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GeoFilterResponse(dict):
    """
    Rules defining user's geo access within a CDN endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCodes":
            suggest = "country_codes"
        elif key == "relativePath":
            suggest = "relative_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeoFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeoFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeoFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 country_codes: Sequence[str],
                 relative_path: str):
        """
        Rules defining user's geo access within a CDN endpoint.
        :param str action: Action of the geo filter, i.e. allow or block access.
        :param Sequence[str] country_codes: Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
        :param str relative_path: Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "country_codes", country_codes)
        pulumi.set(__self__, "relative_path", relative_path)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action of the geo filter, i.e. allow or block access.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="countryCodes")
    def country_codes(self) -> Sequence[str]:
        """
        Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
        """
        return pulumi.get(self, "country_codes")

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> str:
        """
        Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
        """
        return pulumi.get(self, "relative_path")


@pulumi.output_type
class HeaderActionParametersResponse(dict):
    """
    Defines the parameters for the request header action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerAction":
            suggest = "header_action"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeaderActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeaderActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeaderActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_action: str,
                 header_name: str,
                 odata_type: str,
                 value: Optional[str] = None):
        """
        Defines the parameters for the request header action.
        :param str header_action: Action to perform
        :param str header_name: Name of the header to modify
        :param str value: Value for the specified action
        """
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "odata_type", odata_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> str:
        """
        Action to perform
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Name of the header to modify
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value for the specified action
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HealthProbeParametersResponse(dict):
    """
    The JSON object that contains the properties to send health probes to origin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "probeIntervalInSeconds":
            suggest = "probe_interval_in_seconds"
        elif key == "probePath":
            suggest = "probe_path"
        elif key == "probeProtocol":
            suggest = "probe_protocol"
        elif key == "probeRequestType":
            suggest = "probe_request_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthProbeParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthProbeParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthProbeParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 probe_interval_in_seconds: Optional[int] = None,
                 probe_path: Optional[str] = None,
                 probe_protocol: Optional[str] = None,
                 probe_request_type: Optional[str] = None):
        """
        The JSON object that contains the properties to send health probes to origin.
        :param int probe_interval_in_seconds: The number of seconds between health probes.Default is 240sec.
        :param str probe_path: The path relative to the origin that is used to determine the health of the origin.
        :param str probe_protocol: Protocol to use for health probe.
        :param str probe_request_type: The type of health probe request that is made.
        """
        if probe_interval_in_seconds is not None:
            pulumi.set(__self__, "probe_interval_in_seconds", probe_interval_in_seconds)
        if probe_path is not None:
            pulumi.set(__self__, "probe_path", probe_path)
        if probe_protocol is not None:
            pulumi.set(__self__, "probe_protocol", probe_protocol)
        if probe_request_type is not None:
            pulumi.set(__self__, "probe_request_type", probe_request_type)

    @property
    @pulumi.getter(name="probeIntervalInSeconds")
    def probe_interval_in_seconds(self) -> Optional[int]:
        """
        The number of seconds between health probes.Default is 240sec.
        """
        return pulumi.get(self, "probe_interval_in_seconds")

    @property
    @pulumi.getter(name="probePath")
    def probe_path(self) -> Optional[str]:
        """
        The path relative to the origin that is used to determine the health of the origin.
        """
        return pulumi.get(self, "probe_path")

    @property
    @pulumi.getter(name="probeProtocol")
    def probe_protocol(self) -> Optional[str]:
        """
        Protocol to use for health probe.
        """
        return pulumi.get(self, "probe_protocol")

    @property
    @pulumi.getter(name="probeRequestType")
    def probe_request_type(self) -> Optional[str]:
        """
        The type of health probe request that is made.
        """
        return pulumi.get(self, "probe_request_type")


@pulumi.output_type
class HttpErrorRangeParametersResponse(dict):
    """
    The JSON object that represents the range for http status codes
    """
    def __init__(__self__, *,
                 begin: Optional[int] = None,
                 end: Optional[int] = None):
        """
        The JSON object that represents the range for http status codes
        :param int begin: The inclusive start of the http status code range.
        :param int end: The inclusive end of the http status code range.
        """
        if begin is not None:
            pulumi.set(__self__, "begin", begin)
        if end is not None:
            pulumi.set(__self__, "end", end)

    @property
    @pulumi.getter
    def begin(self) -> Optional[int]:
        """
        The inclusive start of the http status code range.
        """
        return pulumi.get(self, "begin")

    @property
    @pulumi.getter
    def end(self) -> Optional[int]:
        """
        The inclusive end of the http status code range.
        """
        return pulumi.get(self, "end")


@pulumi.output_type
class HttpVersionMatchConditionParametersResponse(dict):
    """
    Defines the parameters for HttpVersion match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpVersionMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpVersionMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpVersionMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None):
        """
        Defines the parameters for HttpVersion match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")


@pulumi.output_type
class IsDeviceMatchConditionParametersResponse(dict):
    """
    Defines the parameters for IsDevice match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IsDeviceMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IsDeviceMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IsDeviceMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for IsDevice match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class OriginGroupOverrideActionParametersResponse(dict):
    """
    Defines the parameters for the Origin Group override action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "originGroup":
            suggest = "origin_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginGroupOverrideActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginGroupOverrideActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginGroupOverrideActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 origin_group: 'outputs.ResourceReferenceResponse'):
        """
        Defines the parameters for the Origin Group override action.
        :param 'ResourceReferenceResponse' origin_group: A reference to the origin group from where the content will be fetched from when CDN does not have it
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "origin_group", origin_group)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="originGroup")
    def origin_group(self) -> 'outputs.ResourceReferenceResponse':
        """
        A reference to the origin group from where the content will be fetched from when CDN does not have it
        """
        return pulumi.get(self, "origin_group")


@pulumi.output_type
class OriginGroupOverrideActionResponse(dict):
    """
    Defines the Origin Group override action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.OriginGroupOverrideActionParametersResponse'):
        """
        Defines the Origin Group override action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'OriginGroupOverride'.
        :param 'OriginGroupOverrideActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'OriginGroupOverride')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'OriginGroupOverride'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.OriginGroupOverrideActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class PostArgsMatchConditionParametersResponse(dict):
    """
    Defines the parameters for PostArgs match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostArgsMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostArgsMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostArgsMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for PostArgs match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of PostArg to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of PostArg to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class QueryStringMatchConditionParametersResponse(dict):
    """
    Defines the parameters for QueryString match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryStringMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryStringMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryStringMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for QueryString match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RemoteAddressMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RemoteAddress match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemoteAddressMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemoteAddressMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemoteAddressMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RemoteAddress match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RequestBodyMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestBody match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestBodyMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestBodyMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestBodyMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RequestBody match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RequestHeaderMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestHeader match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestHeaderMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestHeaderMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestHeaderMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RequestHeader match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of Header to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of Header to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RequestMethodMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestMethod match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestMethodMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestMethodMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestMethodMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None):
        """
        Defines the parameters for RequestMethod match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")


@pulumi.output_type
class RequestSchemeMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestScheme match conditions 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestSchemeMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestSchemeMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestSchemeMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None):
        """
        Defines the parameters for RequestScheme match conditions 
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")


@pulumi.output_type
class RequestUriMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestUri match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestUriMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestUriMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestUriMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RequestUri match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class ResourceReferenceResponse(dict):
    """
    Reference to another resource.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Reference to another resource.
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ResponseBasedOriginErrorDetectionParametersResponse(dict):
    """
    The JSON object that contains the properties to determine origin health using real requests/responses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpErrorRanges":
            suggest = "http_error_ranges"
        elif key == "responseBasedDetectedErrorTypes":
            suggest = "response_based_detected_error_types"
        elif key == "responseBasedFailoverThresholdPercentage":
            suggest = "response_based_failover_threshold_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResponseBasedOriginErrorDetectionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResponseBasedOriginErrorDetectionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResponseBasedOriginErrorDetectionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_error_ranges: Optional[Sequence['outputs.HttpErrorRangeParametersResponse']] = None,
                 response_based_detected_error_types: Optional[str] = None,
                 response_based_failover_threshold_percentage: Optional[int] = None):
        """
        The JSON object that contains the properties to determine origin health using real requests/responses.
        :param Sequence['HttpErrorRangeParametersResponse'] http_error_ranges: The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
        :param str response_based_detected_error_types: Type of response errors for real user requests for which origin will be deemed unhealthy
        :param int response_based_failover_threshold_percentage: The percentage of failed requests in the sample where failover should trigger.
        """
        if http_error_ranges is not None:
            pulumi.set(__self__, "http_error_ranges", http_error_ranges)
        if response_based_detected_error_types is not None:
            pulumi.set(__self__, "response_based_detected_error_types", response_based_detected_error_types)
        if response_based_failover_threshold_percentage is not None:
            pulumi.set(__self__, "response_based_failover_threshold_percentage", response_based_failover_threshold_percentage)

    @property
    @pulumi.getter(name="httpErrorRanges")
    def http_error_ranges(self) -> Optional[Sequence['outputs.HttpErrorRangeParametersResponse']]:
        """
        The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
        """
        return pulumi.get(self, "http_error_ranges")

    @property
    @pulumi.getter(name="responseBasedDetectedErrorTypes")
    def response_based_detected_error_types(self) -> Optional[str]:
        """
        Type of response errors for real user requests for which origin will be deemed unhealthy
        """
        return pulumi.get(self, "response_based_detected_error_types")

    @property
    @pulumi.getter(name="responseBasedFailoverThresholdPercentage")
    def response_based_failover_threshold_percentage(self) -> Optional[int]:
        """
        The percentage of failed requests in the sample where failover should trigger.
        """
        return pulumi.get(self, "response_based_failover_threshold_percentage")


@pulumi.output_type
class SkuResponse(dict):
    """
    The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
        :param str name: Name of the pricing tier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the pricing tier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UrlFileExtensionMatchConditionParametersResponse(dict):
    """
    Defines the parameters for UrlFileExtension match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlFileExtensionMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlFileExtensionMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlFileExtensionMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for UrlFileExtension match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class UrlFileNameMatchConditionParametersResponse(dict):
    """
    Defines the parameters for UrlFilename match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlFileNameMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlFileNameMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlFileNameMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for UrlFilename match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class UrlPathMatchConditionParametersResponse(dict):
    """
    Defines the parameters for UrlPath match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlPathMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlPathMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlPathMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for UrlPath match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class UrlRedirectActionParametersResponse(dict):
    """
    Defines the parameters for the url redirect action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "redirectType":
            suggest = "redirect_type"
        elif key == "customFragment":
            suggest = "custom_fragment"
        elif key == "customHostname":
            suggest = "custom_hostname"
        elif key == "customPath":
            suggest = "custom_path"
        elif key == "customQueryString":
            suggest = "custom_query_string"
        elif key == "destinationProtocol":
            suggest = "destination_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlRedirectActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlRedirectActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlRedirectActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 redirect_type: str,
                 custom_fragment: Optional[str] = None,
                 custom_hostname: Optional[str] = None,
                 custom_path: Optional[str] = None,
                 custom_query_string: Optional[str] = None,
                 destination_protocol: Optional[str] = None):
        """
        Defines the parameters for the url redirect action.
        :param str redirect_type: The redirect type the rule will use when redirecting traffic.
        :param str custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param str custom_hostname: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param str custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param str custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
        :param str destination_protocol: Protocol to use for the redirect. The default value is MatchRequest
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "redirect_type", redirect_type)
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_hostname is not None:
            pulumi.set(__self__, "custom_hostname", custom_hostname)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if destination_protocol is not None:
            pulumi.set(__self__, "destination_protocol", destination_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> str:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[str]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @property
    @pulumi.getter(name="customHostname")
    def custom_hostname(self) -> Optional[str]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_hostname")

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[str]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[str]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
        """
        return pulumi.get(self, "custom_query_string")

    @property
    @pulumi.getter(name="destinationProtocol")
    def destination_protocol(self) -> Optional[str]:
        """
        Protocol to use for the redirect. The default value is MatchRequest
        """
        return pulumi.get(self, "destination_protocol")


@pulumi.output_type
class UrlRedirectActionResponse(dict):
    """
    Defines the url redirect action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlRedirectActionParametersResponse'):
        """
        Defines the url redirect action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'UrlRedirect'.
        :param 'UrlRedirectActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'UrlRedirect')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'UrlRedirect'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlRedirectActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class UrlRewriteActionParametersResponse(dict):
    """
    Defines the parameters for the url rewrite action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "sourcePattern":
            suggest = "source_pattern"
        elif key == "preserveUnmatchedPath":
            suggest = "preserve_unmatched_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlRewriteActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlRewriteActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlRewriteActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: str,
                 odata_type: str,
                 source_pattern: str,
                 preserve_unmatched_path: Optional[bool] = None):
        """
        Defines the parameters for the url rewrite action.
        :param str destination: Define the relative URL to which the above requests will be rewritten by.
        :param str source_pattern: define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
        :param bool preserve_unmatched_path: Whether to preserve unmatched path. Default value is true.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "source_pattern", source_pattern)
        if preserve_unmatched_path is not None:
            pulumi.set(__self__, "preserve_unmatched_path", preserve_unmatched_path)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Define the relative URL to which the above requests will be rewritten by.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="sourcePattern")
    def source_pattern(self) -> str:
        """
        define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all strings are matched.
        """
        return pulumi.get(self, "source_pattern")

    @property
    @pulumi.getter(name="preserveUnmatchedPath")
    def preserve_unmatched_path(self) -> Optional[bool]:
        """
        Whether to preserve unmatched path. Default value is true.
        """
        return pulumi.get(self, "preserve_unmatched_path")


@pulumi.output_type
class UrlRewriteActionResponse(dict):
    """
    Defines the url rewrite action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlRewriteActionParametersResponse'):
        """
        Defines the url rewrite action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'UrlRewrite'.
        :param 'UrlRewriteActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'UrlRewrite')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'UrlRewrite'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlRewriteActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


