# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CacheExpirationActionParametersResponse',
    'CacheKeyQueryStringActionParametersResponse',
    'CdnCertificateSourceParametersResponse',
    'CdnEndpointResponse',
    'CdnManagedHttpsParametersResponse',
    'CookiesMatchConditionParametersResponse',
    'CustomRuleListResponse',
    'CustomRuleResponse',
    'DeepCreatedOriginResponse',
    'DeliveryRuleCacheExpirationActionResponse',
    'DeliveryRuleCacheKeyQueryStringActionResponse',
    'DeliveryRuleCookiesConditionResponse',
    'DeliveryRuleHttpVersionConditionResponse',
    'DeliveryRuleIsDeviceConditionResponse',
    'DeliveryRulePostArgsConditionResponse',
    'DeliveryRuleQueryStringConditionResponse',
    'DeliveryRuleRemoteAddressConditionResponse',
    'DeliveryRuleRequestBodyConditionResponse',
    'DeliveryRuleRequestHeaderActionResponse',
    'DeliveryRuleRequestHeaderConditionResponse',
    'DeliveryRuleRequestMethodConditionResponse',
    'DeliveryRuleRequestSchemeConditionResponse',
    'DeliveryRuleRequestUriConditionResponse',
    'DeliveryRuleResponse',
    'DeliveryRuleResponseHeaderActionResponse',
    'DeliveryRuleUrlFileExtensionConditionResponse',
    'DeliveryRuleUrlFileNameConditionResponse',
    'DeliveryRuleUrlPathConditionResponse',
    'EndpointPropertiesUpdateParametersResponseDeliveryPolicy',
    'EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink',
    'GeoFilterResponse',
    'HeaderActionParametersResponse',
    'HttpVersionMatchConditionParametersResponse',
    'IsDeviceMatchConditionParametersResponse',
    'KeyVaultCertificateSourceParametersResponse',
    'ManagedRuleGroupOverrideResponse',
    'ManagedRuleOverrideResponse',
    'ManagedRuleSetListResponse',
    'ManagedRuleSetResponse',
    'MatchConditionResponse',
    'PolicySettingsResponse',
    'PostArgsMatchConditionParametersResponse',
    'QueryStringMatchConditionParametersResponse',
    'RateLimitRuleListResponse',
    'RateLimitRuleResponse',
    'RemoteAddressMatchConditionParametersResponse',
    'RequestBodyMatchConditionParametersResponse',
    'RequestHeaderMatchConditionParametersResponse',
    'RequestMethodMatchConditionParametersResponse',
    'RequestSchemeMatchConditionParametersResponse',
    'RequestUriMatchConditionParametersResponse',
    'SkuResponse',
    'UrlFileExtensionMatchConditionParametersResponse',
    'UrlFileNameMatchConditionParametersResponse',
    'UrlPathMatchConditionParametersResponse',
    'UrlRedirectActionParametersResponse',
    'UrlRedirectActionResponse',
    'UrlRewriteActionParametersResponse',
    'UrlRewriteActionResponse',
    'UserManagedHttpsParametersResponse',
]

@pulumi.output_type
class CacheExpirationActionParametersResponse(dict):
    """
    Defines the parameters for the cache expiration action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheBehavior":
            suggest = "cache_behavior"
        elif key == "cacheType":
            suggest = "cache_type"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "cacheDuration":
            suggest = "cache_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheExpirationActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheExpirationActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheExpirationActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_behavior: str,
                 cache_type: str,
                 odata_type: str,
                 cache_duration: Optional[str] = None):
        """
        Defines the parameters for the cache expiration action.
        :param str cache_behavior: Caching behavior for the requests
        :param str cache_type: The level at which the content needs to be cached.
        :param str cache_duration: The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
        """
        pulumi.set(__self__, "cache_behavior", cache_behavior)
        pulumi.set(__self__, "cache_type", cache_type)
        pulumi.set(__self__, "odata_type", odata_type)
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)

    @property
    @pulumi.getter(name="cacheBehavior")
    def cache_behavior(self) -> str:
        """
        Caching behavior for the requests
        """
        return pulumi.get(self, "cache_behavior")

    @property
    @pulumi.getter(name="cacheType")
    def cache_type(self) -> str:
        """
        The level at which the content needs to be cached.
        """
        return pulumi.get(self, "cache_type")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[str]:
        """
        The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
        """
        return pulumi.get(self, "cache_duration")


@pulumi.output_type
class CacheKeyQueryStringActionParametersResponse(dict):
    """
    Defines the parameters for the cache-key query string action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "queryStringBehavior":
            suggest = "query_string_behavior"
        elif key == "queryParameters":
            suggest = "query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CacheKeyQueryStringActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CacheKeyQueryStringActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CacheKeyQueryStringActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 query_string_behavior: str,
                 query_parameters: Optional[str] = None):
        """
        Defines the parameters for the cache-key query string action.
        :param str query_string_behavior: Caching behavior for the requests
        :param str query_parameters: query parameters to include or exclude (comma separated).
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "query_string_behavior", query_string_behavior)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="queryStringBehavior")
    def query_string_behavior(self) -> str:
        """
        Caching behavior for the requests
        """
        return pulumi.get(self, "query_string_behavior")

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[str]:
        """
        query parameters to include or exclude (comma separated).
        """
        return pulumi.get(self, "query_parameters")


@pulumi.output_type
class CdnCertificateSourceParametersResponse(dict):
    """
    Defines the parameters for using CDN managed certificate for securing custom domain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateType":
            suggest = "certificate_type"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CdnCertificateSourceParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CdnCertificateSourceParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CdnCertificateSourceParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_type: str,
                 odata_type: str):
        """
        Defines the parameters for using CDN managed certificate for securing custom domain.
        :param str certificate_type: Type of certificate used
        """
        pulumi.set(__self__, "certificate_type", certificate_type)
        pulumi.set(__self__, "odata_type", odata_type)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> str:
        """
        Type of certificate used
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class CdnEndpointResponse(dict):
    """
    Defines the ARM Resource ID for the linked endpoints
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Defines the ARM Resource ID for the linked endpoints
        :param str id: ARM Resource ID string.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ARM Resource ID string.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class CdnManagedHttpsParametersResponse(dict):
    """
    Defines the certificate source parameters using CDN managed certificate for enabling SSL.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateSourceParameters":
            suggest = "certificate_source_parameters"
        elif key == "protocolType":
            suggest = "protocol_type"
        elif key == "minimumTlsVersion":
            suggest = "minimum_tls_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CdnManagedHttpsParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CdnManagedHttpsParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CdnManagedHttpsParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_source: str,
                 certificate_source_parameters: 'outputs.CdnCertificateSourceParametersResponse',
                 protocol_type: str,
                 minimum_tls_version: Optional[str] = None):
        """
        Defines the certificate source parameters using CDN managed certificate for enabling SSL.
        :param str certificate_source: Defines the source of the SSL certificate.
               Expected value is 'Cdn'.
        :param 'CdnCertificateSourceParametersResponse' certificate_source_parameters: Defines the certificate source parameters using CDN managed certificate for enabling SSL.
        :param str protocol_type: Defines the TLS extension protocol that is used for secure delivery.
        :param str minimum_tls_version: TLS protocol version that will be used for Https
        """
        pulumi.set(__self__, "certificate_source", 'Cdn')
        pulumi.set(__self__, "certificate_source_parameters", certificate_source_parameters)
        pulumi.set(__self__, "protocol_type", protocol_type)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> str:
        """
        Defines the source of the SSL certificate.
        Expected value is 'Cdn'.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateSourceParameters")
    def certificate_source_parameters(self) -> 'outputs.CdnCertificateSourceParametersResponse':
        """
        Defines the certificate source parameters using CDN managed certificate for enabling SSL.
        """
        return pulumi.get(self, "certificate_source_parameters")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> str:
        """
        Defines the TLS extension protocol that is used for secure delivery.
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[str]:
        """
        TLS protocol version that will be used for Https
        """
        return pulumi.get(self, "minimum_tls_version")


@pulumi.output_type
class CookiesMatchConditionParametersResponse(dict):
    """
    Defines the parameters for Cookies match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CookiesMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CookiesMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CookiesMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for Cookies match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of Cookies to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of Cookies to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class CustomRuleListResponse(dict):
    """
    Defines contents of custom rules
    """
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.CustomRuleResponse']] = None):
        """
        Defines contents of custom rules
        :param Sequence['CustomRuleResponse'] rules: List of rules
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.CustomRuleResponse']]:
        """
        List of rules
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class CustomRuleResponse(dict):
    """
    Defines the common attributes for a custom rule that can be included in a waf policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"
        elif key == "enabledState":
            suggest = "enabled_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 match_conditions: Sequence['outputs.MatchConditionResponse'],
                 name: str,
                 priority: int,
                 enabled_state: Optional[str] = None):
        """
        Defines the common attributes for a custom rule that can be included in a waf policy
        :param str action: Describes what action to be applied when rule matches
        :param Sequence['MatchConditionResponse'] match_conditions: List of match conditions.
        :param str name: Defines the name of the custom rule
        :param int priority: Defines in what order this rule be evaluated in the overall list of custom rules
        :param str enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Describes what action to be applied when rule matches
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Sequence['outputs.MatchConditionResponse']:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Defines the name of the custom rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Defines in what order this rule be evaluated in the overall list of custom rules
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        return pulumi.get(self, "enabled_state")


@pulumi.output_type
class DeepCreatedOriginResponse(dict):
    """
    The main origin of CDN content which is added when creating a CDN endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeepCreatedOriginResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeepCreatedOriginResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeepCreatedOriginResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 name: str,
                 http_port: Optional[int] = None,
                 https_port: Optional[int] = None):
        """
        The main origin of CDN content which is added when creating a CDN endpoint.
        :param str host_name: The address of the origin. It can be a domain name, IPv4 address, or IPv6 address.
        :param str name: Origin name
        :param int http_port: The value of the HTTP port. Must be between 1 and 65535
        :param int https_port: The value of the HTTPS port. Must be between 1 and 65535
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "name", name)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The address of the origin. It can be a domain name, IPv4 address, or IPv6 address.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Origin name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The value of the HTTP port. Must be between 1 and 65535
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[int]:
        """
        The value of the HTTPS port. Must be between 1 and 65535
        """
        return pulumi.get(self, "https_port")


@pulumi.output_type
class DeliveryRuleCacheExpirationActionResponse(dict):
    """
    Defines the cache expiration action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.CacheExpirationActionParametersResponse'):
        """
        Defines the cache expiration action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'CacheExpiration'.
        :param 'CacheExpirationActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'CacheExpiration')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'CacheExpiration'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.CacheExpirationActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleCacheKeyQueryStringActionResponse(dict):
    """
    Defines the cache-key query string action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.CacheKeyQueryStringActionParametersResponse'):
        """
        Defines the cache-key query string action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'CacheKeyQueryString'.
        :param 'CacheKeyQueryStringActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'CacheKeyQueryString')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'CacheKeyQueryString'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.CacheKeyQueryStringActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleCookiesConditionResponse(dict):
    """
    Defines the Cookies condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.CookiesMatchConditionParametersResponse'):
        """
        Defines the Cookies condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'Cookies'.
        :param 'CookiesMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'Cookies')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'Cookies'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.CookiesMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleHttpVersionConditionResponse(dict):
    """
    Defines the HttpVersion condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.HttpVersionMatchConditionParametersResponse'):
        """
        Defines the HttpVersion condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'HttpVersion'.
        :param 'HttpVersionMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'HttpVersion')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'HttpVersion'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.HttpVersionMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleIsDeviceConditionResponse(dict):
    """
    Defines the IsDevice condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.IsDeviceMatchConditionParametersResponse'):
        """
        Defines the IsDevice condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'IsDevice'.
        :param 'IsDeviceMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'IsDevice')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'IsDevice'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.IsDeviceMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRulePostArgsConditionResponse(dict):
    """
    Defines the PostArgs condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.PostArgsMatchConditionParametersResponse'):
        """
        Defines the PostArgs condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'PostArgs'.
        :param 'PostArgsMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'PostArgs')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'PostArgs'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.PostArgsMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleQueryStringConditionResponse(dict):
    """
    Defines the QueryString condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.QueryStringMatchConditionParametersResponse'):
        """
        Defines the QueryString condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'QueryString'.
        :param 'QueryStringMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'QueryString')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'QueryString'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.QueryStringMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRemoteAddressConditionResponse(dict):
    """
    Defines the RemoteAddress condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RemoteAddressMatchConditionParametersResponse'):
        """
        Defines the RemoteAddress condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RemoteAddress'.
        :param 'RemoteAddressMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RemoteAddress')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RemoteAddress'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RemoteAddressMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestBodyConditionResponse(dict):
    """
    Defines the RequestBody condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestBodyMatchConditionParametersResponse'):
        """
        Defines the RequestBody condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestBody'.
        :param 'RequestBodyMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestBody')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestBody'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestBodyMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestHeaderActionResponse(dict):
    """
    Defines the request header action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.HeaderActionParametersResponse'):
        """
        Defines the request header action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'ModifyRequestHeader'.
        :param 'HeaderActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'ModifyRequestHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'ModifyRequestHeader'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.HeaderActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestHeaderConditionResponse(dict):
    """
    Defines the RequestHeader condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestHeaderMatchConditionParametersResponse'):
        """
        Defines the RequestHeader condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestHeader'.
        :param 'RequestHeaderMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestHeader'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestHeaderMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestMethodConditionResponse(dict):
    """
    Defines the RequestMethod condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestMethodMatchConditionParametersResponse'):
        """
        Defines the RequestMethod condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestMethod'.
        :param 'RequestMethodMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestMethod')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestMethod'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestMethodMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestSchemeConditionResponse(dict):
    """
    Defines the RequestScheme condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestSchemeMatchConditionParametersResponse'):
        """
        Defines the RequestScheme condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestScheme'.
        :param 'RequestSchemeMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestScheme')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestScheme'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestSchemeMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleRequestUriConditionResponse(dict):
    """
    Defines the RequestUri condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.RequestUriMatchConditionParametersResponse'):
        """
        Defines the RequestUri condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'RequestUri'.
        :param 'RequestUriMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'RequestUri')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'RequestUri'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.RequestUriMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleResponse(dict):
    """
    A rule that specifies a set of actions and conditions
    """
    def __init__(__self__, *,
                 actions: Sequence[Any],
                 order: int,
                 conditions: Optional[Sequence[Any]] = None,
                 name: Optional[str] = None):
        """
        A rule that specifies a set of actions and conditions
        :param Sequence[Union['DeliveryRuleCacheExpirationActionResponse', 'DeliveryRuleCacheKeyQueryStringActionResponse', 'DeliveryRuleRequestHeaderActionResponse', 'DeliveryRuleResponseHeaderActionResponse', 'UrlRedirectActionResponse', 'UrlRewriteActionResponse']] actions: A list of actions that are executed when all the conditions of a rule are satisfied.
        :param int order: The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
        :param Sequence[Union['DeliveryRuleCookiesConditionResponse', 'DeliveryRuleHttpVersionConditionResponse', 'DeliveryRuleIsDeviceConditionResponse', 'DeliveryRulePostArgsConditionResponse', 'DeliveryRuleQueryStringConditionResponse', 'DeliveryRuleRemoteAddressConditionResponse', 'DeliveryRuleRequestBodyConditionResponse', 'DeliveryRuleRequestHeaderConditionResponse', 'DeliveryRuleRequestMethodConditionResponse', 'DeliveryRuleRequestSchemeConditionResponse', 'DeliveryRuleRequestUriConditionResponse', 'DeliveryRuleUrlFileExtensionConditionResponse', 'DeliveryRuleUrlFileNameConditionResponse', 'DeliveryRuleUrlPathConditionResponse']] conditions: A list of conditions that must be matched for the actions to be executed
        :param str name: Name of the rule
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "order", order)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def actions(self) -> Sequence[Any]:
        """
        A list of actions that are executed when all the conditions of a rule are satisfied.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence[Any]]:
        """
        A list of conditions that must be matched for the actions to be executed
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the rule
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeliveryRuleResponseHeaderActionResponse(dict):
    """
    Defines the response header action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.HeaderActionParametersResponse'):
        """
        Defines the response header action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'ModifyResponseHeader'.
        :param 'HeaderActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'ModifyResponseHeader')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'ModifyResponseHeader'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.HeaderActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleUrlFileExtensionConditionResponse(dict):
    """
    Defines the UrlFileExtension condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlFileExtensionMatchConditionParametersResponse'):
        """
        Defines the UrlFileExtension condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'UrlFileExtension'.
        :param 'UrlFileExtensionMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlFileExtension')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlFileExtension'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlFileExtensionMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleUrlFileNameConditionResponse(dict):
    """
    Defines the UrlFileName condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlFileNameMatchConditionParametersResponse'):
        """
        Defines the UrlFileName condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'UrlFileName'.
        :param 'UrlFileNameMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlFileName')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlFileName'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlFileNameMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class DeliveryRuleUrlPathConditionResponse(dict):
    """
    Defines the UrlPath condition for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlPathMatchConditionParametersResponse'):
        """
        Defines the UrlPath condition for the delivery rule.
        :param str name: The name of the condition for the delivery rule.
               Expected value is 'UrlPath'.
        :param 'UrlPathMatchConditionParametersResponse' parameters: Defines the parameters for the condition.
        """
        pulumi.set(__self__, "name", 'UrlPath')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the condition for the delivery rule.
        Expected value is 'UrlPath'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlPathMatchConditionParametersResponse':
        """
        Defines the parameters for the condition.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class EndpointPropertiesUpdateParametersResponseDeliveryPolicy(dict):
    """
    A policy that specifies the delivery rules to be used for an endpoint.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.DeliveryRuleResponse'],
                 description: Optional[str] = None):
        """
        A policy that specifies the delivery rules to be used for an endpoint.
        :param Sequence['DeliveryRuleResponse'] rules: A list of the delivery rules.
        :param str description: User-friendly description of the policy.
        """
        pulumi.set(__self__, "rules", rules)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.DeliveryRuleResponse']:
        """
        A list of the delivery rules.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        User-friendly description of the policy.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EndpointPropertiesUpdateParametersResponseWebApplicationFirewallPolicyLink(dict):
    """
    Defines the Web Application Firewall policy for the endpoint (if applicable)
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Defines the Web Application Firewall policy for the endpoint (if applicable)
        :param str id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GeoFilterResponse(dict):
    """
    Rules defining user's geo access within a CDN endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCodes":
            suggest = "country_codes"
        elif key == "relativePath":
            suggest = "relative_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GeoFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GeoFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GeoFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 country_codes: Sequence[str],
                 relative_path: str):
        """
        Rules defining user's geo access within a CDN endpoint.
        :param str action: Action of the geo filter, i.e. allow or block access.
        :param Sequence[str] country_codes: Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
        :param str relative_path: Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "country_codes", country_codes)
        pulumi.set(__self__, "relative_path", relative_path)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action of the geo filter, i.e. allow or block access.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="countryCodes")
    def country_codes(self) -> Sequence[str]:
        """
        Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
        """
        return pulumi.get(self, "country_codes")

    @property
    @pulumi.getter(name="relativePath")
    def relative_path(self) -> str:
        """
        Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
        """
        return pulumi.get(self, "relative_path")


@pulumi.output_type
class HeaderActionParametersResponse(dict):
    """
    Defines the parameters for the request header action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerAction":
            suggest = "header_action"
        elif key == "headerName":
            suggest = "header_name"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HeaderActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HeaderActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HeaderActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_action: str,
                 header_name: str,
                 odata_type: str,
                 value: Optional[str] = None):
        """
        Defines the parameters for the request header action.
        :param str header_action: Action to perform
        :param str header_name: Name of the header to modify
        :param str value: Value for the specified action
        """
        pulumi.set(__self__, "header_action", header_action)
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "odata_type", odata_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> str:
        """
        Action to perform
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Name of the header to modify
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value for the specified action
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HttpVersionMatchConditionParametersResponse(dict):
    """
    Defines the parameters for HttpVersion match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpVersionMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpVersionMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpVersionMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None):
        """
        Defines the parameters for HttpVersion match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")


@pulumi.output_type
class IsDeviceMatchConditionParametersResponse(dict):
    """
    Defines the parameters for IsDevice match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IsDeviceMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IsDeviceMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IsDeviceMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for IsDevice match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class KeyVaultCertificateSourceParametersResponse(dict):
    """
    Describes the parameters for using a user's KeyVault certificate for securing custom domain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteRule":
            suggest = "delete_rule"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "resourceGroupName":
            suggest = "resource_group_name"
        elif key == "secretName":
            suggest = "secret_name"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "updateRule":
            suggest = "update_rule"
        elif key == "vaultName":
            suggest = "vault_name"
        elif key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultCertificateSourceParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultCertificateSourceParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultCertificateSourceParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_rule: str,
                 odata_type: str,
                 resource_group_name: str,
                 secret_name: str,
                 subscription_id: str,
                 update_rule: str,
                 vault_name: str,
                 secret_version: Optional[str] = None):
        """
        Describes the parameters for using a user's KeyVault certificate for securing custom domain.
        :param str delete_rule: Describes the action that shall be taken when the certificate is removed from Key Vault.
        :param str resource_group_name: Resource group of the user's Key Vault containing the SSL certificate
        :param str secret_name: The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
        :param str subscription_id: Subscription Id of the user's Key Vault containing the SSL certificate
        :param str update_rule: Describes the action that shall be taken when the certificate is updated in Key Vault.
        :param str vault_name: The name of the user's Key Vault containing the SSL certificate
        :param str secret_version: The version(GUID) of Key Vault Secret in Key Vault.
        """
        pulumi.set(__self__, "delete_rule", delete_rule)
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "update_rule", update_rule)
        pulumi.set(__self__, "vault_name", vault_name)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="deleteRule")
    def delete_rule(self) -> str:
        """
        Describes the action that shall be taken when the certificate is removed from Key Vault.
        """
        return pulumi.get(self, "delete_rule")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> str:
        """
        Resource group of the user's Key Vault containing the SSL certificate
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        Subscription Id of the user's Key Vault containing the SSL certificate
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="updateRule")
    def update_rule(self) -> str:
        """
        Describes the action that shall be taken when the certificate is updated in Key Vault.
        """
        return pulumi.get(self, "update_rule")

    @property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> str:
        """
        The name of the user's Key Vault containing the SSL certificate
        """
        return pulumi.get(self, "vault_name")

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[str]:
        """
        The version(GUID) of Key Vault Secret in Key Vault.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ManagedRuleGroupOverrideResponse(dict):
    """
    Defines a managed rule group override setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleGroupName":
            suggest = "rule_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleGroupOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleGroupOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleGroupOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_group_name: str,
                 rules: Optional[Sequence['outputs.ManagedRuleOverrideResponse']] = None):
        """
        Defines a managed rule group override setting.
        :param str rule_group_name: Describes the managed rule group within the rule set to override
        :param Sequence['ManagedRuleOverrideResponse'] rules: List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> str:
        """
        Describes the managed rule group within the rule set to override
        """
        return pulumi.get(self, "rule_group_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ManagedRuleOverrideResponse']]:
        """
        List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ManagedRuleOverrideResponse(dict):
    """
    Defines a managed rule group override setting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "enabledState":
            suggest = "enabled_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleOverrideResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleOverrideResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleOverrideResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_id: str,
                 action: Optional[str] = None,
                 enabled_state: Optional[str] = None):
        """
        Defines a managed rule group override setting.
        :param str rule_id: Identifier for the managed rule.
        :param str action: Describes the override action to be applied when rule matches.
        :param str enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> str:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Describes the override action to be applied when rule matches.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
        """
        return pulumi.get(self, "enabled_state")


@pulumi.output_type
class ManagedRuleSetListResponse(dict):
    """
    Defines the list of managed rule sets for the policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedRuleSets":
            suggest = "managed_rule_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleSetListResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleSetListResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleSetListResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed_rule_sets: Optional[Sequence['outputs.ManagedRuleSetResponse']] = None):
        """
        Defines the list of managed rule sets for the policy.
        :param Sequence['ManagedRuleSetResponse'] managed_rule_sets: List of rule sets.
        """
        if managed_rule_sets is not None:
            pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)

    @property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> Optional[Sequence['outputs.ManagedRuleSetResponse']]:
        """
        List of rule sets.
        """
        return pulumi.get(self, "managed_rule_sets")


@pulumi.output_type
class ManagedRuleSetResponse(dict):
    """
    Defines a managed rule set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleSetType":
            suggest = "rule_set_type"
        elif key == "ruleSetVersion":
            suggest = "rule_set_version"
        elif key == "anomalyScore":
            suggest = "anomaly_score"
        elif key == "ruleGroupOverrides":
            suggest = "rule_group_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_set_type: str,
                 rule_set_version: str,
                 anomaly_score: Optional[int] = None,
                 rule_group_overrides: Optional[Sequence['outputs.ManagedRuleGroupOverrideResponse']] = None):
        """
        Defines a managed rule set.
        :param str rule_set_type: Defines the rule set type to use.
        :param str rule_set_version: Defines the version of the rule set to use.
        :param int anomaly_score: Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
        :param Sequence['ManagedRuleGroupOverrideResponse'] rule_group_overrides: Defines the rule overrides to apply to the rule set.
        """
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if anomaly_score is not None:
            pulumi.set(__self__, "anomaly_score", anomaly_score)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> str:
        """
        Defines the rule set type to use.
        """
        return pulumi.get(self, "rule_set_type")

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> str:
        """
        Defines the version of the rule set to use.
        """
        return pulumi.get(self, "rule_set_version")

    @property
    @pulumi.getter(name="anomalyScore")
    def anomaly_score(self) -> Optional[int]:
        """
        Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
        """
        return pulumi.get(self, "anomaly_score")

    @property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[Sequence['outputs.ManagedRuleGroupOverrideResponse']]:
        """
        Defines the rule overrides to apply to the rule set.
        """
        return pulumi.get(self, "rule_group_overrides")


@pulumi.output_type
class MatchConditionResponse(dict):
    """
    Define match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchValue":
            suggest = "match_value"
        elif key == "matchVariable":
            suggest = "match_variable"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_value: Sequence[str],
                 match_variable: str,
                 operator: str,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Define match conditions
        :param Sequence[str] match_value: List of possible match values.
        :param str match_variable: Match variable to compare against.
        :param str operator: Describes operator to be matched
        :param bool negate_condition: Describes if the result of this condition should be negated.
        :param str selector: Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
        :param Sequence[str] transforms: List of transforms.
        """
        pulumi.set(__self__, "match_value", match_value)
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="matchValue")
    def match_value(self) -> Sequence[str]:
        """
        List of possible match values.
        """
        return pulumi.get(self, "match_value")

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> str:
        """
        Match variable to compare against.
        """
        return pulumi.get(self, "match_variable")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if the result of this condition should be negated.
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms.
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class PolicySettingsResponse(dict):
    """
    Defines contents of a web application firewall global configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultCustomBlockResponseBody":
            suggest = "default_custom_block_response_body"
        elif key == "defaultCustomBlockResponseStatusCode":
            suggest = "default_custom_block_response_status_code"
        elif key == "defaultRedirectUrl":
            suggest = "default_redirect_url"
        elif key == "enabledState":
            suggest = "enabled_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicySettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicySettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicySettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_custom_block_response_body: Optional[str] = None,
                 default_custom_block_response_status_code: Optional[int] = None,
                 default_redirect_url: Optional[str] = None,
                 enabled_state: Optional[str] = None,
                 mode: Optional[str] = None):
        """
        Defines contents of a web application firewall global configuration
        :param str default_custom_block_response_body: If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
        :param int default_custom_block_response_status_code: If the action type is block, this field defines the default customer overridable http response status code.
        :param str default_redirect_url: If action type is redirect, this field represents the default redirect URL for the client.
        :param str enabled_state: describes if the policy is in enabled state or disabled state
        :param str mode: Describes if it is in detection mode or prevention mode at policy level.
        """
        if default_custom_block_response_body is not None:
            pulumi.set(__self__, "default_custom_block_response_body", default_custom_block_response_body)
        if default_custom_block_response_status_code is not None:
            pulumi.set(__self__, "default_custom_block_response_status_code", default_custom_block_response_status_code)
        if default_redirect_url is not None:
            pulumi.set(__self__, "default_redirect_url", default_redirect_url)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="defaultCustomBlockResponseBody")
    def default_custom_block_response_body(self) -> Optional[str]:
        """
        If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "default_custom_block_response_body")

    @property
    @pulumi.getter(name="defaultCustomBlockResponseStatusCode")
    def default_custom_block_response_status_code(self) -> Optional[int]:
        """
        If the action type is block, this field defines the default customer overridable http response status code.
        """
        return pulumi.get(self, "default_custom_block_response_status_code")

    @property
    @pulumi.getter(name="defaultRedirectUrl")
    def default_redirect_url(self) -> Optional[str]:
        """
        If action type is redirect, this field represents the default redirect URL for the client.
        """
        return pulumi.get(self, "default_redirect_url")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        describes if the policy is in enabled state or disabled state
        """
        return pulumi.get(self, "enabled_state")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        Describes if it is in detection mode or prevention mode at policy level.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class PostArgsMatchConditionParametersResponse(dict):
    """
    Defines the parameters for PostArgs match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostArgsMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostArgsMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostArgsMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for PostArgs match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of PostArg to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of PostArg to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class QueryStringMatchConditionParametersResponse(dict):
    """
    Defines the parameters for QueryString match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryStringMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryStringMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryStringMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for QueryString match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RateLimitRuleListResponse(dict):
    """
    Defines contents of rate limit rules
    """
    def __init__(__self__, *,
                 rules: Optional[Sequence['outputs.RateLimitRuleResponse']] = None):
        """
        Defines contents of rate limit rules
        :param Sequence['RateLimitRuleResponse'] rules: List of rules
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RateLimitRuleResponse']]:
        """
        List of rules
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class RateLimitRuleResponse(dict):
    """
    Defines a rate limiting rule that can be included in a waf policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchConditions":
            suggest = "match_conditions"
        elif key == "rateLimitDurationInMinutes":
            suggest = "rate_limit_duration_in_minutes"
        elif key == "rateLimitThreshold":
            suggest = "rate_limit_threshold"
        elif key == "enabledState":
            suggest = "enabled_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RateLimitRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RateLimitRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RateLimitRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 match_conditions: Sequence['outputs.MatchConditionResponse'],
                 name: str,
                 priority: int,
                 rate_limit_duration_in_minutes: int,
                 rate_limit_threshold: int,
                 enabled_state: Optional[str] = None):
        """
        Defines a rate limiting rule that can be included in a waf policy
        :param str action: Describes what action to be applied when rule matches
        :param Sequence['MatchConditionResponse'] match_conditions: List of match conditions.
        :param str name: Defines the name of the custom rule
        :param int priority: Defines in what order this rule be evaluated in the overall list of custom rules
        :param int rate_limit_duration_in_minutes: Defines rate limit duration. Default is 1 minute.
        :param int rate_limit_threshold: Defines rate limit threshold.
        :param str enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rate_limit_duration_in_minutes", rate_limit_duration_in_minutes)
        pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Describes what action to be applied when rule matches
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Sequence['outputs.MatchConditionResponse']:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Defines the name of the custom rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Defines in what order this rule be evaluated in the overall list of custom rules
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="rateLimitDurationInMinutes")
    def rate_limit_duration_in_minutes(self) -> int:
        """
        Defines rate limit duration. Default is 1 minute.
        """
        return pulumi.get(self, "rate_limit_duration_in_minutes")

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> int:
        """
        Defines rate limit threshold.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[str]:
        """
        Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        return pulumi.get(self, "enabled_state")


@pulumi.output_type
class RemoteAddressMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RemoteAddress match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemoteAddressMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemoteAddressMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemoteAddressMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RemoteAddress match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RequestBodyMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestBody match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestBodyMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestBodyMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestBodyMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RequestBody match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RequestHeaderMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestHeader match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestHeaderMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestHeaderMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestHeaderMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 selector: Optional[str] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RequestHeader match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param str selector: Name of Header to be matched
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        Name of Header to be matched
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class RequestMethodMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestMethod match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestMethodMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestMethodMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestMethodMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None):
        """
        Defines the parameters for RequestMethod match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")


@pulumi.output_type
class RequestSchemeMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestScheme match conditions 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestSchemeMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestSchemeMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestSchemeMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None):
        """
        Defines the parameters for RequestScheme match conditions 
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")


@pulumi.output_type
class RequestUriMatchConditionParametersResponse(dict):
    """
    Defines the parameters for RequestUri match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestUriMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestUriMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestUriMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for RequestUri match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class SkuResponse(dict):
    """
    The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
        :param str name: Name of the pricing tier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the pricing tier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UrlFileExtensionMatchConditionParametersResponse(dict):
    """
    Defines the parameters for UrlFileExtension match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlFileExtensionMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlFileExtensionMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlFileExtensionMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for UrlFileExtension match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class UrlFileNameMatchConditionParametersResponse(dict):
    """
    Defines the parameters for UrlFilename match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlFileNameMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlFileNameMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlFileNameMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for UrlFilename match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class UrlPathMatchConditionParametersResponse(dict):
    """
    Defines the parameters for UrlPath match conditions
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "matchValues":
            suggest = "match_values"
        elif key == "negateCondition":
            suggest = "negate_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlPathMatchConditionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlPathMatchConditionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlPathMatchConditionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 operator: str,
                 match_values: Optional[Sequence[str]] = None,
                 negate_condition: Optional[bool] = None,
                 transforms: Optional[Sequence[str]] = None):
        """
        Defines the parameters for UrlPath match conditions
        :param str operator: Describes operator to be matched
        :param Sequence[str] match_values: The match value for the condition of the delivery rule
        :param bool negate_condition: Describes if this is negate condition or not
        :param Sequence[str] transforms: List of transforms
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "operator", operator)
        if match_values is not None:
            pulumi.set(__self__, "match_values", match_values)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter
    def operator(self) -> str:
        """
        Describes operator to be matched
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="matchValues")
    def match_values(self) -> Optional[Sequence[str]]:
        """
        The match value for the condition of the delivery rule
        """
        return pulumi.get(self, "match_values")

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[bool]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @property
    @pulumi.getter
    def transforms(self) -> Optional[Sequence[str]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")


@pulumi.output_type
class UrlRedirectActionParametersResponse(dict):
    """
    Defines the parameters for the url redirect action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "redirectType":
            suggest = "redirect_type"
        elif key == "customFragment":
            suggest = "custom_fragment"
        elif key == "customHostname":
            suggest = "custom_hostname"
        elif key == "customPath":
            suggest = "custom_path"
        elif key == "customQueryString":
            suggest = "custom_query_string"
        elif key == "destinationProtocol":
            suggest = "destination_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlRedirectActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlRedirectActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlRedirectActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 redirect_type: str,
                 custom_fragment: Optional[str] = None,
                 custom_hostname: Optional[str] = None,
                 custom_path: Optional[str] = None,
                 custom_query_string: Optional[str] = None,
                 destination_protocol: Optional[str] = None):
        """
        Defines the parameters for the url redirect action.
        :param str redirect_type: The redirect type the rule will use when redirecting traffic.
        :param str custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param str custom_hostname: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param str custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param str custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
        :param str destination_protocol: Protocol to use for the redirect. The default value is MatchRequest
        """
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "redirect_type", redirect_type)
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_hostname is not None:
            pulumi.set(__self__, "custom_hostname", custom_hostname)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if destination_protocol is not None:
            pulumi.set(__self__, "destination_protocol", destination_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> str:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[str]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @property
    @pulumi.getter(name="customHostname")
    def custom_hostname(self) -> Optional[str]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_hostname")

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[str]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[str]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. ? and & will be added automatically so do not include them.
        """
        return pulumi.get(self, "custom_query_string")

    @property
    @pulumi.getter(name="destinationProtocol")
    def destination_protocol(self) -> Optional[str]:
        """
        Protocol to use for the redirect. The default value is MatchRequest
        """
        return pulumi.get(self, "destination_protocol")


@pulumi.output_type
class UrlRedirectActionResponse(dict):
    """
    Defines the url redirect action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlRedirectActionParametersResponse'):
        """
        Defines the url redirect action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'UrlRedirect'.
        :param 'UrlRedirectActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'UrlRedirect')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'UrlRedirect'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlRedirectActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class UrlRewriteActionParametersResponse(dict):
    """
    Defines the parameters for the url rewrite action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "sourcePattern":
            suggest = "source_pattern"
        elif key == "preserveUnmatchedPath":
            suggest = "preserve_unmatched_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlRewriteActionParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlRewriteActionParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlRewriteActionParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: str,
                 odata_type: str,
                 source_pattern: str,
                 preserve_unmatched_path: Optional[bool] = None):
        """
        Defines the parameters for the url rewrite action.
        :param str destination: Define the destination path for be used in the rewrite. This will overwrite the source pattern 
        :param str source_pattern: define a request URI pattern that identifies the type of requests that may be rewritten. Currently, source pattern uses a prefix-based match. To match all URL paths, use "/" as the source pattern value. To match only the root directory and re-write this path, use the origin path field
        :param bool preserve_unmatched_path: If True, the remaining path after the source pattern will be appended to the new destination path.  
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "odata_type", odata_type)
        pulumi.set(__self__, "source_pattern", source_pattern)
        if preserve_unmatched_path is not None:
            pulumi.set(__self__, "preserve_unmatched_path", preserve_unmatched_path)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Define the destination path for be used in the rewrite. This will overwrite the source pattern 
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="sourcePattern")
    def source_pattern(self) -> str:
        """
        define a request URI pattern that identifies the type of requests that may be rewritten. Currently, source pattern uses a prefix-based match. To match all URL paths, use "/" as the source pattern value. To match only the root directory and re-write this path, use the origin path field
        """
        return pulumi.get(self, "source_pattern")

    @property
    @pulumi.getter(name="preserveUnmatchedPath")
    def preserve_unmatched_path(self) -> Optional[bool]:
        """
        If True, the remaining path after the source pattern will be appended to the new destination path.  
        """
        return pulumi.get(self, "preserve_unmatched_path")


@pulumi.output_type
class UrlRewriteActionResponse(dict):
    """
    Defines the url rewrite action for the delivery rule.
    """
    def __init__(__self__, *,
                 name: str,
                 parameters: 'outputs.UrlRewriteActionParametersResponse'):
        """
        Defines the url rewrite action for the delivery rule.
        :param str name: The name of the action for the delivery rule.
               Expected value is 'UrlRewrite'.
        :param 'UrlRewriteActionParametersResponse' parameters: Defines the parameters for the action.
        """
        pulumi.set(__self__, "name", 'UrlRewrite')
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the action for the delivery rule.
        Expected value is 'UrlRewrite'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> 'outputs.UrlRewriteActionParametersResponse':
        """
        Defines the parameters for the action.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class UserManagedHttpsParametersResponse(dict):
    """
    Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSource":
            suggest = "certificate_source"
        elif key == "certificateSourceParameters":
            suggest = "certificate_source_parameters"
        elif key == "protocolType":
            suggest = "protocol_type"
        elif key == "minimumTlsVersion":
            suggest = "minimum_tls_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserManagedHttpsParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserManagedHttpsParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserManagedHttpsParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_source: str,
                 certificate_source_parameters: 'outputs.KeyVaultCertificateSourceParametersResponse',
                 protocol_type: str,
                 minimum_tls_version: Optional[str] = None):
        """
        Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
        :param str certificate_source: Defines the source of the SSL certificate.
               Expected value is 'AzureKeyVault'.
        :param 'KeyVaultCertificateSourceParametersResponse' certificate_source_parameters: Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
        :param str protocol_type: Defines the TLS extension protocol that is used for secure delivery.
        :param str minimum_tls_version: TLS protocol version that will be used for Https
        """
        pulumi.set(__self__, "certificate_source", 'AzureKeyVault')
        pulumi.set(__self__, "certificate_source_parameters", certificate_source_parameters)
        pulumi.set(__self__, "protocol_type", protocol_type)
        if minimum_tls_version is not None:
            pulumi.set(__self__, "minimum_tls_version", minimum_tls_version)

    @property
    @pulumi.getter(name="certificateSource")
    def certificate_source(self) -> str:
        """
        Defines the source of the SSL certificate.
        Expected value is 'AzureKeyVault'.
        """
        return pulumi.get(self, "certificate_source")

    @property
    @pulumi.getter(name="certificateSourceParameters")
    def certificate_source_parameters(self) -> 'outputs.KeyVaultCertificateSourceParametersResponse':
        """
        Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
        """
        return pulumi.get(self, "certificate_source_parameters")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> str:
        """
        Defines the TLS extension protocol that is used for secure delivery.
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter(name="minimumTlsVersion")
    def minimum_tls_version(self) -> Optional[str]:
        """
        TLS protocol version that will be used for Https
        """
        return pulumi.get(self, "minimum_tls_version")


