# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ClusterNodeResponse',
    'ClusterReportedPropertiesResponse',
]

@pulumi.output_type
class ClusterNodeResponse(dict):
    """
    Cluster node details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"
        elif key == "memoryInGiB":
            suggest = "memory_in_gi_b"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: float,
                 id: float,
                 manufacturer: str,
                 memory_in_gi_b: float,
                 model: str,
                 name: str,
                 os_name: str,
                 os_version: str,
                 serial_number: str):
        """
        Cluster node details.
        :param float core_count: Number of physical cores on the cluster node.
        :param float id: Id of the node in the cluster.
        :param str manufacturer: Manufacturer of the cluster node hardware.
        :param float memory_in_gi_b: Total available memory on the cluster node (in GiB).
        :param str model: Model name of the cluster node hardware.
        :param str name: Name of the cluster node.
        :param str os_name: Operating system running on the cluster node.
        :param str os_version: Version of the operating system running on the cluster node.
        :param str serial_number: Immutable id of the cluster node.
        """
        pulumi.set(__self__, "core_count", core_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "manufacturer", manufacturer)
        pulumi.set(__self__, "memory_in_gi_b", memory_in_gi_b)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "os_version", os_version)
        pulumi.set(__self__, "serial_number", serial_number)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> float:
        """
        Number of physical cores on the cluster node.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def id(self) -> float:
        """
        Id of the node in the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def manufacturer(self) -> str:
        """
        Manufacturer of the cluster node hardware.
        """
        return pulumi.get(self, "manufacturer")

    @property
    @pulumi.getter(name="memoryInGiB")
    def memory_in_gi_b(self) -> float:
        """
        Total available memory on the cluster node (in GiB).
        """
        return pulumi.get(self, "memory_in_gi_b")

    @property
    @pulumi.getter
    def model(self) -> str:
        """
        Model name of the cluster node hardware.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the cluster node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        Operating system running on the cluster node.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        Version of the operating system running on the cluster node.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        Immutable id of the cluster node.
        """
        return pulumi.get(self, "serial_number")


@pulumi.output_type
class ClusterReportedPropertiesResponse(dict):
    """
    Properties reported by cluster agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "clusterVersion":
            suggest = "cluster_version"
        elif key == "lastUpdated":
            suggest = "last_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReportedPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReportedPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReportedPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 cluster_name: str,
                 cluster_version: str,
                 last_updated: str,
                 nodes: Sequence['outputs.ClusterNodeResponse']):
        """
        Properties reported by cluster agent.
        :param str cluster_id: Unique id generated by the on-prem cluster.
        :param str cluster_name: Name of the on-prem cluster connected to this resource.
        :param str cluster_version: Version of the cluster software.
        :param str last_updated: Last time the cluster reported the data.
        :param Sequence['ClusterNodeResponse'] nodes: List of nodes reported by the cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_version", cluster_version)
        pulumi.set(__self__, "last_updated", last_updated)
        pulumi.set(__self__, "nodes", nodes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        Unique id generated by the on-prem cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Name of the on-prem cluster connected to this resource.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> str:
        """
        Version of the cluster software.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> str:
        """
        Last time the cluster reported the data.
        """
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.ClusterNodeResponse']:
        """
        List of nodes reported by the cluster.
        """
        return pulumi.get(self, "nodes")


