# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetWorkloadNetworkPublicIPResult',
    'AwaitableGetWorkloadNetworkPublicIPResult',
    'get_workload_network_public_ip',
]

@pulumi.output_type
class GetWorkloadNetworkPublicIPResult:
    """
    NSX Public IP Block
    """
    def __init__(__self__, display_name=None, id=None, name=None, number_of_public_ips=None, provisioning_state=None, public_ip_block=None, type=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if number_of_public_ips and not isinstance(number_of_public_ips, float):
            raise TypeError("Expected argument 'number_of_public_ips' to be a float")
        pulumi.set(__self__, "number_of_public_ips", number_of_public_ips)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_ip_block and not isinstance(public_ip_block, str):
            raise TypeError("Expected argument 'public_ip_block' to be a str")
        pulumi.set(__self__, "public_ip_block", public_ip_block)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the Public IP Block.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfPublicIPs")
    def number_of_public_ips(self) -> Optional[float]:
        """
        Number of Public IPs requested.
        """
        return pulumi.get(self, "number_of_public_ips")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicIPBlock")
    def public_ip_block(self) -> str:
        """
        CIDR Block of the Public IP Block.
        """
        return pulumi.get(self, "public_ip_block")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetWorkloadNetworkPublicIPResult(GetWorkloadNetworkPublicIPResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkloadNetworkPublicIPResult(
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            number_of_public_ips=self.number_of_public_ips,
            provisioning_state=self.provisioning_state,
            public_ip_block=self.public_ip_block,
            type=self.type)


def get_workload_network_public_ip(private_cloud_name: Optional[str] = None,
                                   public_ip_id: Optional[str] = None,
                                   resource_group_name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkloadNetworkPublicIPResult:
    """
    NSX Public IP Block
    API Version: 2021-06-01.


    :param str private_cloud_name: Name of the private cloud
    :param str public_ip_id: NSX Public IP Block identifier. Generally the same as the Public IP Block's display name
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['privateCloudName'] = private_cloud_name
    __args__['publicIPId'] = public_ip_id
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:avs:getWorkloadNetworkPublicIP', __args__, opts=opts, typ=GetWorkloadNetworkPublicIPResult).value

    return AwaitableGetWorkloadNetworkPublicIPResult(
        display_name=__ret__.display_name,
        id=__ret__.id,
        name=__ret__.name,
        number_of_public_ips=__ret__.number_of_public_ips,
        provisioning_state=__ret__.provisioning_state,
        public_ip_block=__ret__.public_ip_block,
        type=__ret__.type)
