# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GatewayDetailsResponse',
    'ResourceSkuResponse',
    'ServerAdministratorsResponse',
]

@pulumi.output_type
class GatewayDetailsResponse(dict):
    """
    The gateway details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dmtsClusterUri":
            suggest = "dmts_cluster_uri"
        elif key == "gatewayObjectId":
            suggest = "gateway_object_id"
        elif key == "gatewayResourceId":
            suggest = "gateway_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dmts_cluster_uri: str,
                 gateway_object_id: str,
                 gateway_resource_id: Optional[str] = None):
        """
        The gateway details.
        :param str dmts_cluster_uri: Uri of the DMTS cluster.
        :param str gateway_object_id: Gateway object id from in the DMTS cluster for the gateway resource.
        :param str gateway_resource_id: Gateway resource to be associated with the server.
        """
        pulumi.set(__self__, "dmts_cluster_uri", dmts_cluster_uri)
        pulumi.set(__self__, "gateway_object_id", gateway_object_id)
        if gateway_resource_id is not None:
            pulumi.set(__self__, "gateway_resource_id", gateway_resource_id)

    @property
    @pulumi.getter(name="dmtsClusterUri")
    def dmts_cluster_uri(self) -> str:
        """
        Uri of the DMTS cluster.
        """
        return pulumi.get(self, "dmts_cluster_uri")

    @property
    @pulumi.getter(name="gatewayObjectId")
    def gateway_object_id(self) -> str:
        """
        Gateway object id from in the DMTS cluster for the gateway resource.
        """
        return pulumi.get(self, "gateway_object_id")

    @property
    @pulumi.getter(name="gatewayResourceId")
    def gateway_resource_id(self) -> Optional[str]:
        """
        Gateway resource to be associated with the server.
        """
        return pulumi.get(self, "gateway_resource_id")


@pulumi.output_type
class ResourceSkuResponse(dict):
    """
    Represents the SKU name and Azure pricing tier for Analysis Services resource.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: Optional[str] = None):
        """
        Represents the SKU name and Azure pricing tier for Analysis Services resource.
        :param str name: Name of the SKU level.
        :param str tier: The name of the Azure pricing tier to which the SKU applies.
        """
        pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the SKU level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        The name of the Azure pricing tier to which the SKU applies.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ServerAdministratorsResponse(dict):
    """
    An array of administrator user identities
    """
    def __init__(__self__, *,
                 members: Optional[Sequence[str]] = None):
        """
        An array of administrator user identities
        :param Sequence[str] members: An array of administrator user identities.
        """
        if members is not None:
            pulumi.set(__self__, "members", members)

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence[str]]:
        """
        An array of administrator user identities.
        """
        return pulumi.get(self, "members")


