# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'HealthAlertActionResponse',
    'HealthAlertCriteriaResponse',
    'HealthStateResponse',
    'VmGuestHealthAlertCriterionResponse',
]

@pulumi.output_type
class HealthAlertActionResponse(dict):
    """
    An alert action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionGroupId":
            suggest = "action_group_id"
        elif key == "webHookProperties":
            suggest = "web_hook_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthAlertActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthAlertActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthAlertActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_group_id: Optional[str] = None,
                 web_hook_properties: Optional[Mapping[str, str]] = None):
        """
        An alert action.
        :param str action_group_id: the id of the action group to use.
        :param Mapping[str, str] web_hook_properties: The properties of a webhook object.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if web_hook_properties is not None:
            pulumi.set(__self__, "web_hook_properties", web_hook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[str]:
        """
        the id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @property
    @pulumi.getter(name="webHookProperties")
    def web_hook_properties(self) -> Optional[Mapping[str, str]]:
        """
        The properties of a webhook object.
        """
        return pulumi.get(self, "web_hook_properties")


@pulumi.output_type
class HealthAlertCriteriaResponse(dict):
    """
    Specifies the resource health alert criteria for a single resource that has multiple metric criteria.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allOf":
            suggest = "all_of"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthAlertCriteriaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthAlertCriteriaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthAlertCriteriaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_of: Optional[Sequence['outputs.VmGuestHealthAlertCriterionResponse']] = None):
        """
        Specifies the resource health alert criteria for a single resource that has multiple metric criteria.
        :param Sequence['VmGuestHealthAlertCriterionResponse'] all_of: The list of metric criteria for this 'all of' operation. 
        """
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.VmGuestHealthAlertCriterionResponse']]:
        """
        The list of metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")


@pulumi.output_type
class HealthStateResponse(dict):
    """
    Specifies the health state to alert on and the corresponding severity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthStateName":
            suggest = "health_state_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_state_name: str,
                 severity: float):
        """
        Specifies the health state to alert on and the corresponding severity
        :param str health_state_name: Health state name
        :param float severity: Severity of alert fired
        """
        pulumi.set(__self__, "health_state_name", health_state_name)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="healthStateName")
    def health_state_name(self) -> str:
        """
        Health state name
        """
        return pulumi.get(self, "health_state_name")

    @property
    @pulumi.getter
    def severity(self) -> float:
        """
        Severity of alert fired
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class VmGuestHealthAlertCriterionResponse(dict):
    """
    Specifies the health alert criteria to alert on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthStates":
            suggest = "health_states"
        elif key == "monitorNames":
            suggest = "monitor_names"
        elif key == "monitorTypes":
            suggest = "monitor_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VmGuestHealthAlertCriterionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VmGuestHealthAlertCriterionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VmGuestHealthAlertCriterionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_states: Sequence['outputs.HealthStateResponse'],
                 namespace: str,
                 monitor_names: Optional[Sequence[str]] = None,
                 monitor_types: Optional[Sequence[str]] = None):
        """
        Specifies the health alert criteria to alert on.
        :param Sequence['HealthStateResponse'] health_states: Health states to alert on
        :param str namespace: specifies the type of the alert criterion.
               Expected value is 'GuestVmHealth'.
        :param Sequence[str] monitor_names: Names of health monitor on which to define alert
        :param Sequence[str] monitor_types: Names of health monitor type on which to define alert
        """
        pulumi.set(__self__, "health_states", health_states)
        pulumi.set(__self__, "namespace", 'GuestVmHealth')
        if monitor_names is not None:
            pulumi.set(__self__, "monitor_names", monitor_names)
        if monitor_types is not None:
            pulumi.set(__self__, "monitor_types", monitor_types)

    @property
    @pulumi.getter(name="healthStates")
    def health_states(self) -> Sequence['outputs.HealthStateResponse']:
        """
        Health states to alert on
        """
        return pulumi.get(self, "health_states")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        specifies the type of the alert criterion.
        Expected value is 'GuestVmHealth'.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="monitorNames")
    def monitor_names(self) -> Optional[Sequence[str]]:
        """
        Names of health monitor on which to define alert
        """
        return pulumi.get(self, "monitor_names")

    @property
    @pulumi.getter(name="monitorTypes")
    def monitor_types(self) -> Optional[Sequence[str]]:
        """
        Names of health monitor type on which to define alert
        """
        return pulumi.get(self, "monitor_types")


