# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AdditionalLocationArgs',
    'ApiCreateOrUpdatePropertiesWsdlSelectorArgs',
    'ApiManagementServiceIdentityArgs',
    'ApiManagementServiceSkuPropertiesArgs',
    'ApiVersionConstraintArgs',
    'ApiVersionSetContractDetailsArgs',
    'AuthenticationSettingsContractArgs',
    'BackendAuthorizationHeaderCredentialsArgs',
    'BackendCredentialsContractArgs',
    'BackendPropertiesArgs',
    'BackendProxyContractArgs',
    'BackendServiceFabricClusterPropertiesArgs',
    'BackendTlsPropertiesArgs',
    'BodyDiagnosticSettingsArgs',
    'CertificateConfigurationArgs',
    'CertificateInformationArgs',
    'DataMaskingEntityArgs',
    'DataMaskingArgs',
    'EmailTemplateParametersContractPropertiesArgs',
    'HostnameConfigurationArgs',
    'HttpMessageDiagnosticArgs',
    'KeyVaultContractCreatePropertiesArgs',
    'OAuth2AuthenticationSettingsContractArgs',
    'OpenIdAuthenticationSettingsContractArgs',
    'ParameterContractArgs',
    'PipelineDiagnosticSettingsArgs',
    'RepresentationContractArgs',
    'RequestContractArgs',
    'ResourceLocationDataContractArgs',
    'ResponseContractArgs',
    'SamplingSettingsArgs',
    'SubscriptionKeyParameterNamesContractArgs',
    'TokenBodyParameterContractArgs',
    'UserIdentityContractArgs',
    'UserIdentityPropertiesArgs',
    'VirtualNetworkConfigurationArgs',
    'X509CertificateNameArgs',
]

@pulumi.input_type
class AdditionalLocationArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 sku: pulumi.Input['ApiManagementServiceSkuPropertiesArgs'],
                 disable_gateway: Optional[pulumi.Input[bool]] = None,
                 virtual_network_configuration: Optional[pulumi.Input['VirtualNetworkConfigurationArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Description of an additional API Management resource location.
        :param pulumi.Input[str] location: The location name of the additional region among Azure Data center regions.
        :param pulumi.Input['ApiManagementServiceSkuPropertiesArgs'] sku: SKU properties of the API Management service.
        :param pulumi.Input[bool] disable_gateway: Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
        :param pulumi.Input['VirtualNetworkConfigurationArgs'] virtual_network_configuration: Virtual network configuration for the location.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: A list of availability zones denoting where the resource needs to come from.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "sku", sku)
        if disable_gateway is None:
            disable_gateway = False
        if disable_gateway is not None:
            pulumi.set(__self__, "disable_gateway", disable_gateway)
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location name of the additional region among Azure Data center regions.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ApiManagementServiceSkuPropertiesArgs']:
        """
        SKU properties of the API Management service.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ApiManagementServiceSkuPropertiesArgs']):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="disableGateway")
    def disable_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
        """
        return pulumi.get(self, "disable_gateway")

    @disable_gateway.setter
    def disable_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_gateway", value)

    @property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> Optional[pulumi.Input['VirtualNetworkConfigurationArgs']]:
        """
        Virtual network configuration for the location.
        """
        return pulumi.get(self, "virtual_network_configuration")

    @virtual_network_configuration.setter
    def virtual_network_configuration(self, value: Optional[pulumi.Input['VirtualNetworkConfigurationArgs']]):
        pulumi.set(self, "virtual_network_configuration", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of availability zones denoting where the resource needs to come from.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class ApiCreateOrUpdatePropertiesWsdlSelectorArgs:
    def __init__(__self__, *,
                 wsdl_endpoint_name: Optional[pulumi.Input[str]] = None,
                 wsdl_service_name: Optional[pulumi.Input[str]] = None):
        """
        Criteria to limit import of WSDL to a subset of the document.
        :param pulumi.Input[str] wsdl_endpoint_name: Name of endpoint(port) to import from WSDL
        :param pulumi.Input[str] wsdl_service_name: Name of service to import from WSDL
        """
        if wsdl_endpoint_name is not None:
            pulumi.set(__self__, "wsdl_endpoint_name", wsdl_endpoint_name)
        if wsdl_service_name is not None:
            pulumi.set(__self__, "wsdl_service_name", wsdl_service_name)

    @property
    @pulumi.getter(name="wsdlEndpointName")
    def wsdl_endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of endpoint(port) to import from WSDL
        """
        return pulumi.get(self, "wsdl_endpoint_name")

    @wsdl_endpoint_name.setter
    def wsdl_endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wsdl_endpoint_name", value)

    @property
    @pulumi.getter(name="wsdlServiceName")
    def wsdl_service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of service to import from WSDL
        """
        return pulumi.get(self, "wsdl_service_name")

    @wsdl_service_name.setter
    def wsdl_service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wsdl_service_name", value)


@pulumi.input_type
class ApiManagementServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ApimIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]] = None):
        """
        Identity properties of the Api Management service resource.
        :param pulumi.Input[Union[str, 'ApimIdentityType']] type: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        :param pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]] user_assigned_identities: The list of user identities associated with the resource. The user identity 
               dictionary key references will be ARM resource ids in the form: 
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
                   providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ApimIdentityType']]:
        """
        The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ApimIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]:
        """
        The list of user identities associated with the resource. The user identity 
        dictionary key references will be ARM resource ids in the form: 
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
            providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserIdentityPropertiesArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ApiManagementServiceSkuPropertiesArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[int],
                 name: pulumi.Input[Union[str, 'SkuType']]):
        """
        API Management service resource SKU properties.
        :param pulumi.Input[int] capacity: Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
        :param pulumi.Input[Union[str, 'SkuType']] name: Name of the Sku.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[int]:
        """
        Capacity of the SKU (number of deployed units of the SKU). For Consumption SKU capacity must be specified as 0.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuType']]:
        """
        Name of the Sku.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuType']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ApiVersionConstraintArgs:
    def __init__(__self__, *,
                 min_api_version: Optional[pulumi.Input[str]] = None):
        """
        Control Plane Apis version constraint for the API Management service.
        :param pulumi.Input[str] min_api_version: Limit control plane API calls to API Management service with version equal to or newer than this value.
        """
        if min_api_version is not None:
            pulumi.set(__self__, "min_api_version", min_api_version)

    @property
    @pulumi.getter(name="minApiVersion")
    def min_api_version(self) -> Optional[pulumi.Input[str]]:
        """
        Limit control plane API calls to API Management service with version equal to or newer than this value.
        """
        return pulumi.get(self, "min_api_version")

    @min_api_version.setter
    def min_api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_api_version", value)


@pulumi.input_type
class ApiVersionSetContractDetailsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version_header_name: Optional[pulumi.Input[str]] = None,
                 version_query_name: Optional[pulumi.Input[str]] = None,
                 versioning_scheme: Optional[pulumi.Input[str]] = None):
        """
        An API Version Set contains the common configuration for a set of API Versions relating 
        :param pulumi.Input[str] description: Description of API Version Set.
        :param pulumi.Input[str] id: Identifier for existing API Version Set. Omit this value to create a new Version Set.
        :param pulumi.Input[str] name: The display Name of the API Version Set.
        :param pulumi.Input[str] version_header_name: Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
        :param pulumi.Input[str] version_query_name: Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
        :param pulumi.Input[str] versioning_scheme: An value that determines where the API Version identifier will be located in a HTTP request.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version_header_name is not None:
            pulumi.set(__self__, "version_header_name", version_header_name)
        if version_query_name is not None:
            pulumi.set(__self__, "version_query_name", version_query_name)
        if versioning_scheme is not None:
            pulumi.set(__self__, "versioning_scheme", versioning_scheme)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of API Version Set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for existing API Version Set. Omit this value to create a new Version Set.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display Name of the API Version Set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
        """
        return pulumi.get(self, "version_header_name")

    @version_header_name.setter
    def version_header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_header_name", value)

    @property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
        """
        return pulumi.get(self, "version_query_name")

    @version_query_name.setter
    def version_query_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_query_name", value)

    @property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        An value that determines where the API Version identifier will be located in a HTTP request.
        """
        return pulumi.get(self, "versioning_scheme")

    @versioning_scheme.setter
    def versioning_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "versioning_scheme", value)


@pulumi.input_type
class AuthenticationSettingsContractArgs:
    def __init__(__self__, *,
                 o_auth2: Optional[pulumi.Input['OAuth2AuthenticationSettingsContractArgs']] = None,
                 openid: Optional[pulumi.Input['OpenIdAuthenticationSettingsContractArgs']] = None):
        """
        API Authentication Settings.
        :param pulumi.Input['OAuth2AuthenticationSettingsContractArgs'] o_auth2: OAuth2 Authentication settings
        :param pulumi.Input['OpenIdAuthenticationSettingsContractArgs'] openid: OpenID Connect Authentication Settings
        """
        if o_auth2 is not None:
            pulumi.set(__self__, "o_auth2", o_auth2)
        if openid is not None:
            pulumi.set(__self__, "openid", openid)

    @property
    @pulumi.getter(name="oAuth2")
    def o_auth2(self) -> Optional[pulumi.Input['OAuth2AuthenticationSettingsContractArgs']]:
        """
        OAuth2 Authentication settings
        """
        return pulumi.get(self, "o_auth2")

    @o_auth2.setter
    def o_auth2(self, value: Optional[pulumi.Input['OAuth2AuthenticationSettingsContractArgs']]):
        pulumi.set(self, "o_auth2", value)

    @property
    @pulumi.getter
    def openid(self) -> Optional[pulumi.Input['OpenIdAuthenticationSettingsContractArgs']]:
        """
        OpenID Connect Authentication Settings
        """
        return pulumi.get(self, "openid")

    @openid.setter
    def openid(self, value: Optional[pulumi.Input['OpenIdAuthenticationSettingsContractArgs']]):
        pulumi.set(self, "openid", value)


@pulumi.input_type
class BackendAuthorizationHeaderCredentialsArgs:
    def __init__(__self__, *,
                 parameter: pulumi.Input[str],
                 scheme: pulumi.Input[str]):
        """
        Authorization header information.
        :param pulumi.Input[str] parameter: Authentication Parameter value.
        :param pulumi.Input[str] scheme: Authentication Scheme name.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def parameter(self) -> pulumi.Input[str]:
        """
        Authentication Parameter value.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter", value)

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Input[str]:
        """
        Authentication Scheme name.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class BackendCredentialsContractArgs:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input['BackendAuthorizationHeaderCredentialsArgs']] = None,
                 certificate: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 header: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None,
                 query: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]] = None):
        """
        Details of the Credentials used to connect to Backend.
        :param pulumi.Input['BackendAuthorizationHeaderCredentialsArgs'] authorization: Authorization header authentication
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate: List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificate_ids: List of Client Certificate Ids.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] header: Header Parameter description.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]] query: Query Parameter description.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['BackendAuthorizationHeaderCredentialsArgs']]:
        """
        Authorization header authentication
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['BackendAuthorizationHeaderCredentialsArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Client Certificate Thumbprints. Will be ignored if certificatesIds are provided.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Client Certificate Ids.
        """
        return pulumi.get(self, "certificate_ids")

    @certificate_ids.setter
    def certificate_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificate_ids", value)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        Header Parameter description.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]:
        """
        Query Parameter description.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[str]]]]]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class BackendPropertiesArgs:
    def __init__(__self__, *,
                 service_fabric_cluster: Optional[pulumi.Input['BackendServiceFabricClusterPropertiesArgs']] = None):
        """
        Properties specific to the Backend Type.
        :param pulumi.Input['BackendServiceFabricClusterPropertiesArgs'] service_fabric_cluster: Backend Service Fabric Cluster Properties
        """
        if service_fabric_cluster is not None:
            pulumi.set(__self__, "service_fabric_cluster", service_fabric_cluster)

    @property
    @pulumi.getter(name="serviceFabricCluster")
    def service_fabric_cluster(self) -> Optional[pulumi.Input['BackendServiceFabricClusterPropertiesArgs']]:
        """
        Backend Service Fabric Cluster Properties
        """
        return pulumi.get(self, "service_fabric_cluster")

    @service_fabric_cluster.setter
    def service_fabric_cluster(self, value: Optional[pulumi.Input['BackendServiceFabricClusterPropertiesArgs']]):
        pulumi.set(self, "service_fabric_cluster", value)


@pulumi.input_type
class BackendProxyContractArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Details of the Backend WebProxy Server to use in the Request to Backend.
        :param pulumi.Input[str] url: WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
        :param pulumi.Input[str] password: Password to connect to the WebProxy Server
        :param pulumi.Input[str] username: Username to connect to the WebProxy server
        """
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to connect to the WebProxy Server
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username to connect to the WebProxy server
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class BackendServiceFabricClusterPropertiesArgs:
    def __init__(__self__, *,
                 management_endpoints: pulumi.Input[Sequence[pulumi.Input[str]]],
                 client_certificate_id: Optional[pulumi.Input[str]] = None,
                 client_certificatethumbprint: Optional[pulumi.Input[str]] = None,
                 max_partition_resolution_retries: Optional[pulumi.Input[int]] = None,
                 server_certificate_thumbprints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 server_x509_names: Optional[pulumi.Input[Sequence[pulumi.Input['X509CertificateNameArgs']]]] = None):
        """
        Properties of the Service Fabric Type Backend.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] management_endpoints: The cluster management endpoint.
        :param pulumi.Input[str] client_certificate_id: The client certificate id for the management endpoint.
        :param pulumi.Input[str] client_certificatethumbprint: The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
        :param pulumi.Input[int] max_partition_resolution_retries: Maximum number of retries while attempting resolve the partition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_certificate_thumbprints: Thumbprints of certificates cluster management service uses for tls communication
        :param pulumi.Input[Sequence[pulumi.Input['X509CertificateNameArgs']]] server_x509_names: Server X509 Certificate Names Collection
        """
        pulumi.set(__self__, "management_endpoints", management_endpoints)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if client_certificatethumbprint is not None:
            pulumi.set(__self__, "client_certificatethumbprint", client_certificatethumbprint)
        if max_partition_resolution_retries is not None:
            pulumi.set(__self__, "max_partition_resolution_retries", max_partition_resolution_retries)
        if server_certificate_thumbprints is not None:
            pulumi.set(__self__, "server_certificate_thumbprints", server_certificate_thumbprints)
        if server_x509_names is not None:
            pulumi.set(__self__, "server_x509_names", server_x509_names)

    @property
    @pulumi.getter(name="managementEndpoints")
    def management_endpoints(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The cluster management endpoint.
        """
        return pulumi.get(self, "management_endpoints")

    @management_endpoints.setter
    def management_endpoints(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "management_endpoints", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate id for the management endpoint.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="clientCertificatethumbprint")
    def client_certificatethumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
        """
        return pulumi.get(self, "client_certificatethumbprint")

    @client_certificatethumbprint.setter
    def client_certificatethumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificatethumbprint", value)

    @property
    @pulumi.getter(name="maxPartitionResolutionRetries")
    def max_partition_resolution_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of retries while attempting resolve the partition.
        """
        return pulumi.get(self, "max_partition_resolution_retries")

    @max_partition_resolution_retries.setter
    def max_partition_resolution_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_partition_resolution_retries", value)

    @property
    @pulumi.getter(name="serverCertificateThumbprints")
    def server_certificate_thumbprints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Thumbprints of certificates cluster management service uses for tls communication
        """
        return pulumi.get(self, "server_certificate_thumbprints")

    @server_certificate_thumbprints.setter
    def server_certificate_thumbprints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_certificate_thumbprints", value)

    @property
    @pulumi.getter(name="serverX509Names")
    def server_x509_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X509CertificateNameArgs']]]]:
        """
        Server X509 Certificate Names Collection
        """
        return pulumi.get(self, "server_x509_names")

    @server_x509_names.setter
    def server_x509_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X509CertificateNameArgs']]]]):
        pulumi.set(self, "server_x509_names", value)


@pulumi.input_type
class BackendTlsPropertiesArgs:
    def __init__(__self__, *,
                 validate_certificate_chain: Optional[pulumi.Input[bool]] = None,
                 validate_certificate_name: Optional[pulumi.Input[bool]] = None):
        """
        Properties controlling TLS Certificate Validation.
        :param pulumi.Input[bool] validate_certificate_chain: Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
        :param pulumi.Input[bool] validate_certificate_name: Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
        """
        if validate_certificate_chain is None:
            validate_certificate_chain = True
        if validate_certificate_chain is not None:
            pulumi.set(__self__, "validate_certificate_chain", validate_certificate_chain)
        if validate_certificate_name is None:
            validate_certificate_name = True
        if validate_certificate_name is not None:
            pulumi.set(__self__, "validate_certificate_name", validate_certificate_name)

    @property
    @pulumi.getter(name="validateCertificateChain")
    def validate_certificate_chain(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating whether SSL certificate chain validation should be done when using self-signed certificates for this backend host.
        """
        return pulumi.get(self, "validate_certificate_chain")

    @validate_certificate_chain.setter
    def validate_certificate_chain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_certificate_chain", value)

    @property
    @pulumi.getter(name="validateCertificateName")
    def validate_certificate_name(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag indicating whether SSL certificate name validation should be done when using self-signed certificates for this backend host.
        """
        return pulumi.get(self, "validate_certificate_name")

    @validate_certificate_name.setter
    def validate_certificate_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_certificate_name", value)


@pulumi.input_type
class BodyDiagnosticSettingsArgs:
    def __init__(__self__, *,
                 bytes: Optional[pulumi.Input[int]] = None):
        """
        Body logging settings.
        :param pulumi.Input[int] bytes: Number of request body bytes to log.
        """
        if bytes is not None:
            pulumi.set(__self__, "bytes", bytes)

    @property
    @pulumi.getter
    def bytes(self) -> Optional[pulumi.Input[int]]:
        """
        Number of request body bytes to log.
        """
        return pulumi.get(self, "bytes")

    @bytes.setter
    def bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bytes", value)


@pulumi.input_type
class CertificateConfigurationArgs:
    def __init__(__self__, *,
                 store_name: pulumi.Input[str],
                 certificate: Optional[pulumi.Input['CertificateInformationArgs']] = None,
                 certificate_password: Optional[pulumi.Input[str]] = None,
                 encoded_certificate: Optional[pulumi.Input[str]] = None):
        """
        Certificate configuration which consist of non-trusted intermediates and root certificates.
        :param pulumi.Input[str] store_name: The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
        :param pulumi.Input['CertificateInformationArgs'] certificate: Certificate information.
        :param pulumi.Input[str] certificate_password: Certificate Password.
        :param pulumi.Input[str] encoded_certificate: Base64 Encoded certificate.
        """
        pulumi.set(__self__, "store_name", store_name)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if encoded_certificate is not None:
            pulumi.set(__self__, "encoded_certificate", encoded_certificate)

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> pulumi.Input[str]:
        """
        The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
        """
        return pulumi.get(self, "store_name")

    @store_name.setter
    def store_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "store_name", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['CertificateInformationArgs']]:
        """
        Certificate information.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['CertificateInformationArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate Password.
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_password", value)

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 Encoded certificate.
        """
        return pulumi.get(self, "encoded_certificate")

    @encoded_certificate.setter
    def encoded_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded_certificate", value)


@pulumi.input_type
class CertificateInformationArgs:
    def __init__(__self__, *,
                 expiry: pulumi.Input[str],
                 subject: pulumi.Input[str],
                 thumbprint: pulumi.Input[str]):
        """
        SSL certificate information.
        :param pulumi.Input[str] expiry: Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        :param pulumi.Input[str] subject: Subject of the certificate.
        :param pulumi.Input[str] thumbprint: Thumbprint of the certificate.
        """
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def expiry(self) -> pulumi.Input[str]:
        """
        Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: pulumi.Input[str]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Input[str]:
        """
        Subject of the certificate.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: pulumi.Input[str]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[str]:
        """
        Thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class DataMaskingEntityArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[Union[str, 'DataMaskingMode']]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Union[str, 'DataMaskingMode']] mode: Data masking mode.
        :param pulumi.Input[str] value: The name of an entity to mask (e.g. a name of a header or a query parameter).
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'DataMaskingMode']]]:
        """
        Data masking mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'DataMaskingMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an entity to mask (e.g. a name of a header or a query parameter).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DataMaskingArgs:
    def __init__(__self__, *,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]]] = None,
                 query_params: Optional[pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]] headers: Masking settings for headers
        :param pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]] query_params: Masking settings for Url query parameters
        """
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]]]:
        """
        Masking settings for headers
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]]]:
        """
        Masking settings for Url query parameters
        """
        return pulumi.get(self, "query_params")

    @query_params.setter
    def query_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataMaskingEntityArgs']]]]):
        pulumi.set(self, "query_params", value)


@pulumi.input_type
class EmailTemplateParametersContractPropertiesArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Email Template Parameter contract.
        :param pulumi.Input[str] description: Template parameter description.
        :param pulumi.Input[str] name: Template parameter name.
        :param pulumi.Input[str] title: Template parameter title.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Template parameter description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Template parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Template parameter title.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class HostnameConfigurationArgs:
    def __init__(__self__, *,
                 host_name: pulumi.Input[str],
                 type: pulumi.Input[Union[str, 'HostnameType']],
                 certificate: Optional[pulumi.Input['CertificateInformationArgs']] = None,
                 certificate_password: Optional[pulumi.Input[str]] = None,
                 default_ssl_binding: Optional[pulumi.Input[bool]] = None,
                 encoded_certificate: Optional[pulumi.Input[str]] = None,
                 identity_client_id: Optional[pulumi.Input[str]] = None,
                 key_vault_id: Optional[pulumi.Input[str]] = None,
                 negotiate_client_certificate: Optional[pulumi.Input[bool]] = None):
        """
        Custom hostname configuration.
        :param pulumi.Input[str] host_name: Hostname to configure on the Api Management service.
        :param pulumi.Input[Union[str, 'HostnameType']] type: Hostname type.
        :param pulumi.Input['CertificateInformationArgs'] certificate: Certificate information.
        :param pulumi.Input[str] certificate_password: Certificate Password.
        :param pulumi.Input[bool] default_ssl_binding: Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
        :param pulumi.Input[str] encoded_certificate: Base64 Encoded certificate.
        :param pulumi.Input[str] identity_client_id: System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
        :param pulumi.Input[str] key_vault_id: Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
        :param pulumi.Input[bool] negotiate_client_certificate: Specify true to always negotiate client certificate on the hostname. Default Value is false.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "type", type)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if default_ssl_binding is None:
            default_ssl_binding = False
        if default_ssl_binding is not None:
            pulumi.set(__self__, "default_ssl_binding", default_ssl_binding)
        if encoded_certificate is not None:
            pulumi.set(__self__, "encoded_certificate", encoded_certificate)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if negotiate_client_certificate is None:
            negotiate_client_certificate = False
        if negotiate_client_certificate is not None:
            pulumi.set(__self__, "negotiate_client_certificate", negotiate_client_certificate)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        """
        Hostname to configure on the Api Management service.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'HostnameType']]:
        """
        Hostname type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'HostnameType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['CertificateInformationArgs']]:
        """
        Certificate information.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['CertificateInformationArgs']]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate Password.
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_password", value)

    @property
    @pulumi.getter(name="defaultSslBinding")
    def default_ssl_binding(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify true to setup the certificate associated with this Hostname as the Default SSL Certificate. If a client does not send the SNI header, then this will be the certificate that will be challenged. The property is useful if a service has multiple custom hostname enabled and it needs to decide on the default ssl certificate. The setting only applied to Proxy Hostname Type.
        """
        return pulumi.get(self, "default_ssl_binding")

    @default_ssl_binding.setter
    def default_ssl_binding(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_ssl_binding", value)

    @property
    @pulumi.getter(name="encodedCertificate")
    def encoded_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 Encoded certificate.
        """
        return pulumi.get(self, "encoded_certificate")

    @encoded_certificate.setter
    def encoded_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoded_certificate", value)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        System or User Assigned Managed identity clientId as generated by Azure AD, which has GET access to the keyVault containing the SSL certificate.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_client_id", value)

    @property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        Url to the KeyVault Secret containing the Ssl Certificate. If absolute Url containing version is provided, auto-update of ssl certificate will not work. This requires Api Management service to be configured with aka.ms/apimmsi. The secret should be of type *application/x-pkcs12*
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_id", value)

    @property
    @pulumi.getter(name="negotiateClientCertificate")
    def negotiate_client_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify true to always negotiate client certificate on the hostname. Default Value is false.
        """
        return pulumi.get(self, "negotiate_client_certificate")

    @negotiate_client_certificate.setter
    def negotiate_client_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negotiate_client_certificate", value)


@pulumi.input_type
class HttpMessageDiagnosticArgs:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input['BodyDiagnosticSettingsArgs']] = None,
                 data_masking: Optional[pulumi.Input['DataMaskingArgs']] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Http message diagnostic settings.
        :param pulumi.Input['BodyDiagnosticSettingsArgs'] body: Body logging settings.
        :param pulumi.Input['DataMaskingArgs'] data_masking: Data masking settings.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] headers: Array of HTTP Headers to log.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input['BodyDiagnosticSettingsArgs']]:
        """
        Body logging settings.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input['BodyDiagnosticSettingsArgs']]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional[pulumi.Input['DataMaskingArgs']]:
        """
        Data masking settings.
        """
        return pulumi.get(self, "data_masking")

    @data_masking.setter
    def data_masking(self, value: Optional[pulumi.Input['DataMaskingArgs']]):
        pulumi.set(self, "data_masking", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of HTTP Headers to log.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)


@pulumi.input_type
class KeyVaultContractCreatePropertiesArgs:
    def __init__(__self__, *,
                 identity_client_id: Optional[pulumi.Input[str]] = None,
                 secret_identifier: Optional[pulumi.Input[str]] = None):
        """
        Create keyVault contract details.
        :param pulumi.Input[str] identity_client_id: SystemAssignedIdentity or UserAssignedIdentity Client Id which will be used to access key vault secret.
        :param pulumi.Input[str] secret_identifier: Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires Api Management service to be configured with aka.ms/apimmsi
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if secret_identifier is not None:
            pulumi.set(__self__, "secret_identifier", secret_identifier)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        SystemAssignedIdentity or UserAssignedIdentity Client Id which will be used to access key vault secret.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_client_id", value)

    @property
    @pulumi.getter(name="secretIdentifier")
    def secret_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Key vault secret identifier for fetching secret. Providing a versioned secret will prevent auto-refresh. This requires Api Management service to be configured with aka.ms/apimmsi
        """
        return pulumi.get(self, "secret_identifier")

    @secret_identifier.setter
    def secret_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_identifier", value)


@pulumi.input_type
class OAuth2AuthenticationSettingsContractArgs:
    def __init__(__self__, *,
                 authorization_server_id: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        API OAuth2 Authentication settings details.
        :param pulumi.Input[str] authorization_server_id: OAuth authorization server identifier.
        :param pulumi.Input[str] scope: operations scope.
        """
        if authorization_server_id is not None:
            pulumi.set(__self__, "authorization_server_id", authorization_server_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="authorizationServerId")
    def authorization_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth authorization server identifier.
        """
        return pulumi.get(self, "authorization_server_id")

    @authorization_server_id.setter
    def authorization_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_server_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        operations scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class OpenIdAuthenticationSettingsContractArgs:
    def __init__(__self__, *,
                 bearer_token_sending_methods: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'BearerTokenSendingMethods']]]]] = None,
                 openid_provider_id: Optional[pulumi.Input[str]] = None):
        """
        API OAuth2 Authentication settings details.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'BearerTokenSendingMethods']]]] bearer_token_sending_methods: How to send token to the server.
        :param pulumi.Input[str] openid_provider_id: OAuth authorization server identifier.
        """
        if bearer_token_sending_methods is not None:
            pulumi.set(__self__, "bearer_token_sending_methods", bearer_token_sending_methods)
        if openid_provider_id is not None:
            pulumi.set(__self__, "openid_provider_id", openid_provider_id)

    @property
    @pulumi.getter(name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'BearerTokenSendingMethods']]]]]:
        """
        How to send token to the server.
        """
        return pulumi.get(self, "bearer_token_sending_methods")

    @bearer_token_sending_methods.setter
    def bearer_token_sending_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'BearerTokenSendingMethods']]]]]):
        pulumi.set(self, "bearer_token_sending_methods", value)

    @property
    @pulumi.getter(name="openidProviderId")
    def openid_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        OAuth authorization server identifier.
        """
        return pulumi.get(self, "openid_provider_id")

    @openid_provider_id.setter
    def openid_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "openid_provider_id", value)


@pulumi.input_type
class ParameterContractArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Operation parameters details.
        :param pulumi.Input[str] name: Parameter name.
        :param pulumi.Input[str] type: Parameter type.
        :param pulumi.Input[str] default_value: Default parameter value.
        :param pulumi.Input[str] description: Parameter description.
        :param pulumi.Input[bool] required: Specifies whether parameter is required or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: Parameter values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Parameter type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        Default parameter value.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether parameter is required or not.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Parameter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class PipelineDiagnosticSettingsArgs:
    def __init__(__self__, *,
                 request: Optional[pulumi.Input['HttpMessageDiagnosticArgs']] = None,
                 response: Optional[pulumi.Input['HttpMessageDiagnosticArgs']] = None):
        """
        Diagnostic settings for incoming/outgoing HTTP messages to the Gateway.
        :param pulumi.Input['HttpMessageDiagnosticArgs'] request: Diagnostic settings for request.
        :param pulumi.Input['HttpMessageDiagnosticArgs'] response: Diagnostic settings for response.
        """
        if request is not None:
            pulumi.set(__self__, "request", request)
        if response is not None:
            pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input['HttpMessageDiagnosticArgs']]:
        """
        Diagnostic settings for request.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input['HttpMessageDiagnosticArgs']]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter
    def response(self) -> Optional[pulumi.Input['HttpMessageDiagnosticArgs']]:
        """
        Diagnostic settings for response.
        """
        return pulumi.get(self, "response")

    @response.setter
    def response(self, value: Optional[pulumi.Input['HttpMessageDiagnosticArgs']]):
        pulumi.set(self, "response", value)


@pulumi.input_type
class RepresentationContractArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[str],
                 form_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]] = None,
                 sample: Optional[pulumi.Input[str]] = None,
                 schema_id: Optional[pulumi.Input[str]] = None,
                 type_name: Optional[pulumi.Input[str]] = None):
        """
        Operation request/response representation details.
        :param pulumi.Input[str] content_type: Specifies a registered or custom content type for this representation, e.g. application/xml.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]] form_parameters: Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        :param pulumi.Input[str] sample: An example of the representation.
        :param pulumi.Input[str] schema_id: Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        :param pulumi.Input[str] type_name: Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        pulumi.set(__self__, "content_type", content_type)
        if form_parameters is not None:
            pulumi.set(__self__, "form_parameters", form_parameters)
        if sample is not None:
            pulumi.set(__self__, "sample", sample)
        if schema_id is not None:
            pulumi.set(__self__, "schema_id", schema_id)
        if type_name is not None:
            pulumi.set(__self__, "type_name", type_name)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        Specifies a registered or custom content type for this representation, e.g. application/xml.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="formParameters")
    def form_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]:
        """
        Collection of form parameters. Required if 'contentType' value is either 'application/x-www-form-urlencoded' or 'multipart/form-data'..
        """
        return pulumi.get(self, "form_parameters")

    @form_parameters.setter
    def form_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]):
        pulumi.set(self, "form_parameters", value)

    @property
    @pulumi.getter
    def sample(self) -> Optional[pulumi.Input[str]]:
        """
        An example of the representation.
        """
        return pulumi.get(self, "sample")

    @sample.setter
    def sample(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample", value)

    @property
    @pulumi.getter(name="schemaId")
    def schema_id(self) -> Optional[pulumi.Input[str]]:
        """
        Schema identifier. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        return pulumi.get(self, "schema_id")

    @schema_id.setter
    def schema_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_id", value)

    @property
    @pulumi.getter(name="typeName")
    def type_name(self) -> Optional[pulumi.Input[str]]:
        """
        Type name defined by the schema. Applicable only if 'contentType' value is neither 'application/x-www-form-urlencoded' nor 'multipart/form-data'.
        """
        return pulumi.get(self, "type_name")

    @type_name.setter
    def type_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_name", value)


@pulumi.input_type
class RequestContractArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]] = None,
                 query_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]] = None,
                 representations: Optional[pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]]] = None):
        """
        Operation request details.
        :param pulumi.Input[str] description: Operation request description.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]] headers: Collection of operation request headers.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]] query_parameters: Collection of operation request query parameters.
        :param pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]] representations: Collection of operation request representations.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Operation request description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]:
        """
        Collection of operation request headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]:
        """
        Collection of operation request query parameters.
        """
        return pulumi.get(self, "query_parameters")

    @query_parameters.setter
    def query_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]):
        pulumi.set(self, "query_parameters", value)

    @property
    @pulumi.getter
    def representations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]]]:
        """
        Collection of operation request representations.
        """
        return pulumi.get(self, "representations")

    @representations.setter
    def representations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]]]):
        pulumi.set(self, "representations", value)


@pulumi.input_type
class ResourceLocationDataContractArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 city: Optional[pulumi.Input[str]] = None,
                 country_or_region: Optional[pulumi.Input[str]] = None,
                 district: Optional[pulumi.Input[str]] = None):
        """
        Resource location data properties.
        :param pulumi.Input[str] name: A canonical name for the geographic or physical location.
        :param pulumi.Input[str] city: The city or locality where the resource is located.
        :param pulumi.Input[str] country_or_region: The country or region where the resource is located.
        :param pulumi.Input[str] district: The district, state, or province where the resource is located.
        """
        pulumi.set(__self__, "name", name)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_or_region is not None:
            pulumi.set(__self__, "country_or_region", country_or_region)
        if district is not None:
            pulumi.set(__self__, "district", district)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A canonical name for the geographic or physical location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="countryOrRegion")
    def country_or_region(self) -> Optional[pulumi.Input[str]]:
        """
        The country or region where the resource is located.
        """
        return pulumi.get(self, "country_or_region")

    @country_or_region.setter
    def country_or_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country_or_region", value)

    @property
    @pulumi.getter
    def district(self) -> Optional[pulumi.Input[str]]:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")

    @district.setter
    def district(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "district", value)


@pulumi.input_type
class ResponseContractArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]] = None,
                 representations: Optional[pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]]] = None):
        """
        Operation response details.
        :param pulumi.Input[int] status_code: Operation response HTTP status code.
        :param pulumi.Input[str] description: Operation response description.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]] headers: Collection of operation response headers.
        :param pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]] representations: Collection of operation response representations.
        """
        pulumi.set(__self__, "status_code", status_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if representations is not None:
            pulumi.set(__self__, "representations", representations)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[int]:
        """
        Operation response HTTP status code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[int]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Operation response description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]:
        """
        Collection of operation response headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterContractArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def representations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]]]:
        """
        Collection of operation response representations.
        """
        return pulumi.get(self, "representations")

    @representations.setter
    def representations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepresentationContractArgs']]]]):
        pulumi.set(self, "representations", value)


@pulumi.input_type
class SamplingSettingsArgs:
    def __init__(__self__, *,
                 percentage: Optional[pulumi.Input[float]] = None,
                 sampling_type: Optional[pulumi.Input[Union[str, 'SamplingType']]] = None):
        """
        Sampling settings for Diagnostic.
        :param pulumi.Input[float] percentage: Rate of sampling for fixed-rate sampling.
        :param pulumi.Input[Union[str, 'SamplingType']] sampling_type: Sampling type.
        """
        if percentage is not None:
            pulumi.set(__self__, "percentage", percentage)
        if sampling_type is not None:
            pulumi.set(__self__, "sampling_type", sampling_type)

    @property
    @pulumi.getter
    def percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Rate of sampling for fixed-rate sampling.
        """
        return pulumi.get(self, "percentage")

    @percentage.setter
    def percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "percentage", value)

    @property
    @pulumi.getter(name="samplingType")
    def sampling_type(self) -> Optional[pulumi.Input[Union[str, 'SamplingType']]]:
        """
        Sampling type.
        """
        return pulumi.get(self, "sampling_type")

    @sampling_type.setter
    def sampling_type(self, value: Optional[pulumi.Input[Union[str, 'SamplingType']]]):
        pulumi.set(self, "sampling_type", value)


@pulumi.input_type
class SubscriptionKeyParameterNamesContractArgs:
    def __init__(__self__, *,
                 header: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None):
        """
        Subscription key parameter names details.
        :param pulumi.Input[str] header: Subscription key header name.
        :param pulumi.Input[str] query: Subscription key query string parameter name.
        """
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription key header name.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription key query string parameter name.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)


@pulumi.input_type
class TokenBodyParameterContractArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        OAuth acquire token request body parameter (www-url-form-encoded).
        :param pulumi.Input[str] name: body parameter name.
        :param pulumi.Input[str] value: body parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        body parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        body parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class UserIdentityContractArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[str]] = None):
        """
        User identity details.
        :param pulumi.Input[str] id: Identifier value within provider.
        :param pulumi.Input[str] provider: Identity provider name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier value within provider.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input[str]]:
        """
        Identity provider name.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider", value)


@pulumi.input_type
class UserIdentityPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: The client id of user assigned identity.
        :param pulumi.Input[str] principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class VirtualNetworkConfigurationArgs:
    def __init__(__self__, *,
                 subnet_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Configuration of a virtual network to which API Management service is deployed.
        :param pulumi.Input[str] subnet_resource_id: The full resource ID of a subnet in a virtual network to deploy the API Management service in.
        """
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)

    @property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource ID of a subnet in a virtual network to deploy the API Management service in.
        """
        return pulumi.get(self, "subnet_resource_id")

    @subnet_resource_id.setter
    def subnet_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_resource_id", value)


@pulumi.input_type
class X509CertificateNameArgs:
    def __init__(__self__, *,
                 issuer_certificate_thumbprint: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Properties of server X509Names.
        :param pulumi.Input[str] issuer_certificate_thumbprint: Thumbprint for the Issuer of the Certificate.
        :param pulumi.Input[str] name: Common Name of the Certificate.
        """
        if issuer_certificate_thumbprint is not None:
            pulumi.set(__self__, "issuer_certificate_thumbprint", issuer_certificate_thumbprint)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="issuerCertificateThumbprint")
    def issuer_certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Thumbprint for the Issuer of the Certificate.
        """
        return pulumi.get(self, "issuer_certificate_thumbprint")

    @issuer_certificate_thumbprint.setter
    def issuer_certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_certificate_thumbprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Common Name of the Certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


