# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActivityEntityQueriesPropertiesResponseQueryDefinitions',
    'ActivityTimelineItemResponse',
    'AlertsDataTypeOfDataConnectorResponse',
    'AutomationRuleModifyPropertiesActionResponse',
    'AutomationRuleModifyPropertiesActionResponseActionConfiguration',
    'AutomationRulePropertyValuesConditionResponse',
    'AutomationRulePropertyValuesConditionResponseConditionProperties',
    'AutomationRuleRunPlaybookActionResponse',
    'AutomationRuleRunPlaybookActionResponseActionConfiguration',
    'AutomationRuleTriggeringLogicResponse',
    'AwsCloudTrailDataConnectorDataTypesResponse',
    'AwsCloudTrailDataConnectorDataTypesResponseLogs',
    'BookmarkTimelineItemResponse',
    'ClientInfoResponse',
    'ContentPathMapResponse',
    'DataConnectorDataTypeCommonResponse',
    'EntityInsightItemResponse',
    'EntityInsightItemResponseQueryTimeInterval',
    'GetInsightsErrorResponse',
    'GetInsightsResultsMetadataResponse',
    'IncidentAdditionalDataResponse',
    'IncidentInfoResponse',
    'IncidentLabelResponse',
    'IncidentOwnerInfoResponse',
    'InsightsTableResultResponse',
    'InsightsTableResultResponseColumns',
    'MCASDataConnectorDataTypesResponse',
    'MetadataAuthorResponse',
    'MetadataDependenciesResponse',
    'MetadataSourceResponse',
    'MetadataSupportResponse',
    'OfficeDataConnectorDataTypesResponse',
    'OfficeDataConnectorDataTypesResponseExchange',
    'OfficeDataConnectorDataTypesResponseSharePoint',
    'OfficeDataConnectorDataTypesResponseTeams',
    'RepoResponse',
    'RepositoryResponse',
    'SecurityAlertTimelineItemResponse',
    'SystemDataResponse',
    'TIDataConnectorDataTypesResponse',
    'TIDataConnectorDataTypesResponseIndicators',
    'TimelineAggregationResponse',
    'TimelineErrorResponse',
    'TimelineResultsMetadataResponse',
    'UserInfoResponse',
    'WatchlistUserInfoResponse',
]

@pulumi.output_type
class ActivityEntityQueriesPropertiesResponseQueryDefinitions(dict):
    """
    The Activity query definitions
    """
    def __init__(__self__, *,
                 query: Optional[str] = None):
        """
        The Activity query definitions
        :param str query: The Activity query to run on a given entity
        """
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        """
        The Activity query to run on a given entity
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ActivityTimelineItemResponse(dict):
    """
    Represents Activity timeline item.
    """
    def __init__(__self__, *,
                 bucket_end_time_utc: str,
                 bucket_start_time_utc: str,
                 content: str,
                 first_activity_time_utc: str,
                 kind: str,
                 last_activity_time_utc: str,
                 query_id: str,
                 title: str):
        """
        Represents Activity timeline item.
        :param str bucket_end_time_utc: The grouping bucket end time.
        :param str bucket_start_time_utc: The grouping bucket start time.
        :param str content: The activity timeline content.
        :param str first_activity_time_utc: The time of the first activity in the grouping bucket.
        :param str kind: The entity query kind
               Expected value is 'Activity'.
        :param str last_activity_time_utc: The time of the last activity in the grouping bucket.
        :param str query_id: The activity query id.
        :param str title: The activity timeline title.
        """
        pulumi.set(__self__, "bucket_end_time_utc", bucket_end_time_utc)
        pulumi.set(__self__, "bucket_start_time_utc", bucket_start_time_utc)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "first_activity_time_utc", first_activity_time_utc)
        pulumi.set(__self__, "kind", 'Activity')
        pulumi.set(__self__, "last_activity_time_utc", last_activity_time_utc)
        pulumi.set(__self__, "query_id", query_id)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="bucketEndTimeUTC")
    def bucket_end_time_utc(self) -> str:
        """
        The grouping bucket end time.
        """
        return pulumi.get(self, "bucket_end_time_utc")

    @property
    @pulumi.getter(name="bucketStartTimeUTC")
    def bucket_start_time_utc(self) -> str:
        """
        The grouping bucket start time.
        """
        return pulumi.get(self, "bucket_start_time_utc")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The activity timeline content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="firstActivityTimeUTC")
    def first_activity_time_utc(self) -> str:
        """
        The time of the first activity in the grouping bucket.
        """
        return pulumi.get(self, "first_activity_time_utc")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The entity query kind
        Expected value is 'Activity'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastActivityTimeUTC")
    def last_activity_time_utc(self) -> str:
        """
        The time of the last activity in the grouping bucket.
        """
        return pulumi.get(self, "last_activity_time_utc")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> str:
        """
        The activity query id.
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The activity timeline title.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class AlertsDataTypeOfDataConnectorResponse(dict):
    """
    Alerts data type for data connectors.
    """
    def __init__(__self__, *,
                 alerts: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None):
        """
        Alerts data type for data connectors.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")


@pulumi.output_type
class AutomationRuleModifyPropertiesActionResponse(dict):
    """
    Describes an automation rule action to modify an object's properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionConfiguration":
            suggest = "action_configuration"
        elif key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleModifyPropertiesActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleModifyPropertiesActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleModifyPropertiesActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_configuration: 'outputs.AutomationRuleModifyPropertiesActionResponseActionConfiguration',
                 action_type: str,
                 order: int):
        """
        Describes an automation rule action to modify an object's properties
        :param 'AutomationRuleModifyPropertiesActionResponseActionConfiguration' action_configuration: The configuration of the modify properties automation rule action
        :param str action_type: The type of the automation rule action
               Expected value is 'ModifyProperties'.
        :param int order: The order of execution of the automation rule action
        """
        pulumi.set(__self__, "action_configuration", action_configuration)
        pulumi.set(__self__, "action_type", 'ModifyProperties')
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> 'outputs.AutomationRuleModifyPropertiesActionResponseActionConfiguration':
        """
        The configuration of the modify properties automation rule action
        """
        return pulumi.get(self, "action_configuration")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the automation rule action
        Expected value is 'ModifyProperties'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of execution of the automation rule action
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class AutomationRuleModifyPropertiesActionResponseActionConfiguration(dict):
    """
    The configuration of the modify properties automation rule action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationComment":
            suggest = "classification_comment"
        elif key == "classificationReason":
            suggest = "classification_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleModifyPropertiesActionResponseActionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleModifyPropertiesActionResponseActionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleModifyPropertiesActionResponseActionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: Optional[str] = None,
                 classification_comment: Optional[str] = None,
                 classification_reason: Optional[str] = None,
                 labels: Optional[Sequence['outputs.IncidentLabelResponse']] = None,
                 owner: Optional['outputs.IncidentOwnerInfoResponse'] = None,
                 severity: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The configuration of the modify properties automation rule action
        :param str classification: The reason the incident was closed
        :param str classification_comment: Describes the reason the incident was closed
        :param str classification_reason: The classification reason to close the incident with
        :param Sequence['IncidentLabelResponse'] labels: List of labels to add to the incident
        :param 'IncidentOwnerInfoResponse' owner: Describes a user that the incident is assigned to
        :param str severity: The severity of the incident
        :param str status: The status of the incident
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if classification_comment is not None:
            pulumi.set(__self__, "classification_comment", classification_comment)
        if classification_reason is not None:
            pulumi.set(__self__, "classification_reason", classification_reason)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def classification(self) -> Optional[str]:
        """
        The reason the incident was closed
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="classificationComment")
    def classification_comment(self) -> Optional[str]:
        """
        Describes the reason the incident was closed
        """
        return pulumi.get(self, "classification_comment")

    @property
    @pulumi.getter(name="classificationReason")
    def classification_reason(self) -> Optional[str]:
        """
        The classification reason to close the incident with
        """
        return pulumi.get(self, "classification_reason")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.IncidentLabelResponse']]:
        """
        List of labels to add to the incident
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def owner(self) -> Optional['outputs.IncidentOwnerInfoResponse']:
        """
        Describes a user that the incident is assigned to
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the incident
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AutomationRulePropertyValuesConditionResponse(dict):
    """
    Describes an automation rule condition that evaluates a property's value
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionProperties":
            suggest = "condition_properties"
        elif key == "conditionType":
            suggest = "condition_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRulePropertyValuesConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRulePropertyValuesConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRulePropertyValuesConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition_properties: 'outputs.AutomationRulePropertyValuesConditionResponseConditionProperties',
                 condition_type: str):
        """
        Describes an automation rule condition that evaluates a property's value
        :param 'AutomationRulePropertyValuesConditionResponseConditionProperties' condition_properties: The configuration of the automation rule condition
        :param str condition_type: The type of the automation rule condition
               Expected value is 'Property'.
        """
        pulumi.set(__self__, "condition_properties", condition_properties)
        pulumi.set(__self__, "condition_type", 'Property')

    @property
    @pulumi.getter(name="conditionProperties")
    def condition_properties(self) -> 'outputs.AutomationRulePropertyValuesConditionResponseConditionProperties':
        """
        The configuration of the automation rule condition
        """
        return pulumi.get(self, "condition_properties")

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> str:
        """
        The type of the automation rule condition
        Expected value is 'Property'.
        """
        return pulumi.get(self, "condition_type")


@pulumi.output_type
class AutomationRulePropertyValuesConditionResponseConditionProperties(dict):
    """
    The configuration of the automation rule condition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyName":
            suggest = "property_name"
        elif key == "propertyValues":
            suggest = "property_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRulePropertyValuesConditionResponseConditionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRulePropertyValuesConditionResponseConditionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRulePropertyValuesConditionResponseConditionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: Optional[str] = None,
                 property_name: Optional[str] = None,
                 property_values: Optional[Sequence[str]] = None):
        """
        The configuration of the automation rule condition
        :param str operator: The operator to use for evaluation the condition
        :param str property_name: The property to evaluate
        :param Sequence[str] property_values: The values to use for evaluating the condition
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if property_values is not None:
            pulumi.set(__self__, "property_values", property_values)

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        The operator to use for evaluation the condition
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[str]:
        """
        The property to evaluate
        """
        return pulumi.get(self, "property_name")

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Optional[Sequence[str]]:
        """
        The values to use for evaluating the condition
        """
        return pulumi.get(self, "property_values")


@pulumi.output_type
class AutomationRuleRunPlaybookActionResponse(dict):
    """
    Describes an automation rule action to run a playbook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionConfiguration":
            suggest = "action_configuration"
        elif key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleRunPlaybookActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleRunPlaybookActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleRunPlaybookActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_configuration: 'outputs.AutomationRuleRunPlaybookActionResponseActionConfiguration',
                 action_type: str,
                 order: int):
        """
        Describes an automation rule action to run a playbook
        :param 'AutomationRuleRunPlaybookActionResponseActionConfiguration' action_configuration: The configuration of the run playbook automation rule action
        :param str action_type: The type of the automation rule action
               Expected value is 'RunPlaybook'.
        :param int order: The order of execution of the automation rule action
        """
        pulumi.set(__self__, "action_configuration", action_configuration)
        pulumi.set(__self__, "action_type", 'RunPlaybook')
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> 'outputs.AutomationRuleRunPlaybookActionResponseActionConfiguration':
        """
        The configuration of the run playbook automation rule action
        """
        return pulumi.get(self, "action_configuration")

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of the automation rule action
        Expected value is 'RunPlaybook'.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of execution of the automation rule action
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class AutomationRuleRunPlaybookActionResponseActionConfiguration(dict):
    """
    The configuration of the run playbook automation rule action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicAppResourceId":
            suggest = "logic_app_resource_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleRunPlaybookActionResponseActionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleRunPlaybookActionResponseActionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleRunPlaybookActionResponseActionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logic_app_resource_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        The configuration of the run playbook automation rule action
        :param str logic_app_resource_id: The resource id of the playbook resource
        :param str tenant_id: The tenant id of the playbook resource
        """
        if logic_app_resource_id is not None:
            pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> Optional[str]:
        """
        The resource id of the playbook resource
        """
        return pulumi.get(self, "logic_app_resource_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant id of the playbook resource
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AutomationRuleTriggeringLogicResponse(dict):
    """
    Describes automation rule triggering logic
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "triggersOn":
            suggest = "triggers_on"
        elif key == "triggersWhen":
            suggest = "triggers_when"
        elif key == "expirationTimeUtc":
            suggest = "expiration_time_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRuleTriggeringLogicResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRuleTriggeringLogicResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRuleTriggeringLogicResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool,
                 triggers_on: str,
                 triggers_when: str,
                 conditions: Optional[Sequence['outputs.AutomationRulePropertyValuesConditionResponse']] = None,
                 expiration_time_utc: Optional[str] = None):
        """
        Describes automation rule triggering logic
        :param bool is_enabled: Determines whether the automation rule is enabled or disabled.
        :param str triggers_on: The type of object the automation rule triggers on
        :param str triggers_when: The type of event the automation rule triggers on
        :param Sequence['AutomationRulePropertyValuesConditionResponse'] conditions: The conditions to evaluate to determine if the automation rule should be triggered on a given object
        :param str expiration_time_utc: Determines when the automation rule should automatically expire and be disabled.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "triggers_on", triggers_on)
        pulumi.set(__self__, "triggers_when", triggers_when)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if expiration_time_utc is not None:
            pulumi.set(__self__, "expiration_time_utc", expiration_time_utc)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Determines whether the automation rule is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> str:
        """
        The type of object the automation rule triggers on
        """
        return pulumi.get(self, "triggers_on")

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> str:
        """
        The type of event the automation rule triggers on
        """
        return pulumi.get(self, "triggers_when")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.AutomationRulePropertyValuesConditionResponse']]:
        """
        The conditions to evaluate to determine if the automation rule should be triggered on a given object
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> Optional[str]:
        """
        Determines when the automation rule should automatically expire and be disabled.
        """
        return pulumi.get(self, "expiration_time_utc")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponse(dict):
    """
    The available data types for Amazon Web Services CloudTrail data connector.
    """
    def __init__(__self__, *,
                 logs: Optional['outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs'] = None):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param 'AwsCloudTrailDataConnectorDataTypesResponseLogs' logs: Logs data type.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> Optional['outputs.AwsCloudTrailDataConnectorDataTypesResponseLogs']:
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")


@pulumi.output_type
class AwsCloudTrailDataConnectorDataTypesResponseLogs(dict):
    """
    Logs data type.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Logs data type.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class BookmarkTimelineItemResponse(dict):
    """
    Represents bookmark timeline item.
    """
    def __init__(__self__, *,
                 azure_resource_id: str,
                 kind: str,
                 created_by: Optional['outputs.UserInfoResponse'] = None,
                 display_name: Optional[str] = None,
                 end_time_utc: Optional[str] = None,
                 event_time: Optional[str] = None,
                 labels: Optional[Sequence[str]] = None,
                 notes: Optional[str] = None,
                 start_time_utc: Optional[str] = None):
        """
        Represents bookmark timeline item.
        :param str azure_resource_id: The bookmark azure resource id.
        :param str kind: The entity query kind
               Expected value is 'Bookmark'.
        :param 'UserInfoResponse' created_by: Describes a user that created the bookmark
        :param str display_name: The bookmark display name.
        :param str end_time_utc: The bookmark end time.
        :param str event_time: The bookmark event time.
        :param Sequence[str] labels: List of labels relevant to this bookmark
        :param str notes: The notes of the bookmark
        :param str start_time_utc: The bookmark start time.
        """
        pulumi.set(__self__, "azure_resource_id", azure_resource_id)
        pulumi.set(__self__, "kind", 'Bookmark')
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_time_utc is not None:
            pulumi.set(__self__, "end_time_utc", end_time_utc)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if start_time_utc is not None:
            pulumi.set(__self__, "start_time_utc", start_time_utc)

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> str:
        """
        The bookmark azure resource id.
        """
        return pulumi.get(self, "azure_resource_id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The entity query kind
        Expected value is 'Bookmark'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional['outputs.UserInfoResponse']:
        """
        Describes a user that created the bookmark
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The bookmark display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> Optional[str]:
        """
        The bookmark end time.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[str]:
        """
        The bookmark event time.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[str]]:
        """
        List of labels relevant to this bookmark
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def notes(self) -> Optional[str]:
        """
        The notes of the bookmark
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> Optional[str]:
        """
        The bookmark start time.
        """
        return pulumi.get(self, "start_time_utc")


@pulumi.output_type
class ClientInfoResponse(dict):
    """
    Information on the client (user or application) that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: Optional[str] = None,
                 name: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the client (user or application) that made some action
        :param str email: The email of the client.
        :param str name: The name of the client.
        :param str object_id: The object id of the client.
        :param str user_principal_name: The user principal name of the client.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the client.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the client.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the client.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class ContentPathMapResponse(dict):
    """
    The mapping of content type to a repo path.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentPathMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentPathMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentPathMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional[str] = None,
                 path: Optional[str] = None):
        """
        The mapping of content type to a repo path.
        :param str content_type: Content type.
        :param str path: The path to the content.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to the content.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DataConnectorDataTypeCommonResponse(dict):
    """
    Common field for data type in data connectors.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Common field for data type in data connectors.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EntityInsightItemResponse(dict):
    """
    Entity insight Item.
    """
    def __init__(__self__, *,
                 chart_query_results: Optional[Sequence['outputs.InsightsTableResultResponse']] = None,
                 query_id: Optional[str] = None,
                 query_time_interval: Optional['outputs.EntityInsightItemResponseQueryTimeInterval'] = None,
                 table_query_results: Optional['outputs.InsightsTableResultResponse'] = None):
        """
        Entity insight Item.
        :param Sequence['InsightsTableResultResponse'] chart_query_results: Query results for table insights query.
        :param str query_id: The query id of the insight
        :param 'EntityInsightItemResponseQueryTimeInterval' query_time_interval: The Time interval that the query actually executed on.
        :param 'InsightsTableResultResponse' table_query_results: Query results for table insights query.
        """
        if chart_query_results is not None:
            pulumi.set(__self__, "chart_query_results", chart_query_results)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if query_time_interval is not None:
            pulumi.set(__self__, "query_time_interval", query_time_interval)
        if table_query_results is not None:
            pulumi.set(__self__, "table_query_results", table_query_results)

    @property
    @pulumi.getter(name="chartQueryResults")
    def chart_query_results(self) -> Optional[Sequence['outputs.InsightsTableResultResponse']]:
        """
        Query results for table insights query.
        """
        return pulumi.get(self, "chart_query_results")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[str]:
        """
        The query id of the insight
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter(name="queryTimeInterval")
    def query_time_interval(self) -> Optional['outputs.EntityInsightItemResponseQueryTimeInterval']:
        """
        The Time interval that the query actually executed on.
        """
        return pulumi.get(self, "query_time_interval")

    @property
    @pulumi.getter(name="tableQueryResults")
    def table_query_results(self) -> Optional['outputs.InsightsTableResultResponse']:
        """
        Query results for table insights query.
        """
        return pulumi.get(self, "table_query_results")


@pulumi.output_type
class EntityInsightItemResponseQueryTimeInterval(dict):
    """
    The Time interval that the query actually executed on.
    """
    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        The Time interval that the query actually executed on.
        :param str end_time: Insight query end time
        :param str start_time: Insight query start time
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Insight query end time
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Insight query start time
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetInsightsErrorResponse(dict):
    """
    GetInsights Query Errors.
    """
    def __init__(__self__, *,
                 error_message: str,
                 kind: str,
                 query_id: Optional[str] = None):
        """
        GetInsights Query Errors.
        :param str error_message: the error message
        :param str kind: the query kind
        :param str query_id: the query id
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "kind", kind)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        the error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        the query kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[str]:
        """
        the query id
        """
        return pulumi.get(self, "query_id")


@pulumi.output_type
class GetInsightsResultsMetadataResponse(dict):
    """
    Get Insights result metadata.
    """
    def __init__(__self__, *,
                 total_count: int,
                 errors: Optional[Sequence['outputs.GetInsightsErrorResponse']] = None):
        """
        Get Insights result metadata.
        :param int total_count: the total items found for the insights request
        :param Sequence['GetInsightsErrorResponse'] errors: information about the failed queries
        """
        pulumi.set(__self__, "total_count", total_count)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        the total items found for the insights request
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.GetInsightsErrorResponse']]:
        """
        information about the failed queries
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class IncidentAdditionalDataResponse(dict):
    """
    Incident additional data property bag.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alertProductNames":
            suggest = "alert_product_names"
        elif key == "alertsCount":
            suggest = "alerts_count"
        elif key == "bookmarksCount":
            suggest = "bookmarks_count"
        elif key == "commentsCount":
            suggest = "comments_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentAdditionalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentAdditionalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alert_product_names: Sequence[str],
                 alerts_count: int,
                 bookmarks_count: int,
                 comments_count: int,
                 tactics: Sequence[str]):
        """
        Incident additional data property bag.
        :param Sequence[str] alert_product_names: List of product names of alerts in the incident
        :param int alerts_count: The number of alerts in the incident
        :param int bookmarks_count: The number of bookmarks in the incident
        :param int comments_count: The number of comments in the incident
        :param Sequence[str] tactics: The tactics associated with incident
        """
        pulumi.set(__self__, "alert_product_names", alert_product_names)
        pulumi.set(__self__, "alerts_count", alerts_count)
        pulumi.set(__self__, "bookmarks_count", bookmarks_count)
        pulumi.set(__self__, "comments_count", comments_count)
        pulumi.set(__self__, "tactics", tactics)

    @property
    @pulumi.getter(name="alertProductNames")
    def alert_product_names(self) -> Sequence[str]:
        """
        List of product names of alerts in the incident
        """
        return pulumi.get(self, "alert_product_names")

    @property
    @pulumi.getter(name="alertsCount")
    def alerts_count(self) -> int:
        """
        The number of alerts in the incident
        """
        return pulumi.get(self, "alerts_count")

    @property
    @pulumi.getter(name="bookmarksCount")
    def bookmarks_count(self) -> int:
        """
        The number of bookmarks in the incident
        """
        return pulumi.get(self, "bookmarks_count")

    @property
    @pulumi.getter(name="commentsCount")
    def comments_count(self) -> int:
        """
        The number of comments in the incident
        """
        return pulumi.get(self, "comments_count")

    @property
    @pulumi.getter
    def tactics(self) -> Sequence[str]:
        """
        The tactics associated with incident
        """
        return pulumi.get(self, "tactics")


@pulumi.output_type
class IncidentInfoResponse(dict):
    """
    Describes related incident information for the bookmark
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incidentId":
            suggest = "incident_id"
        elif key == "relationName":
            suggest = "relation_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incident_id: Optional[str] = None,
                 relation_name: Optional[str] = None,
                 severity: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Describes related incident information for the bookmark
        :param str incident_id: Incident Id
        :param str relation_name: Relation Name
        :param str severity: The severity of the incident
        :param str title: The title of the incident
        """
        if incident_id is not None:
            pulumi.set(__self__, "incident_id", incident_id)
        if relation_name is not None:
            pulumi.set(__self__, "relation_name", relation_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="incidentId")
    def incident_id(self) -> Optional[str]:
        """
        Incident Id
        """
        return pulumi.get(self, "incident_id")

    @property
    @pulumi.getter(name="relationName")
    def relation_name(self) -> Optional[str]:
        """
        Relation Name
        """
        return pulumi.get(self, "relation_name")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        """
        The title of the incident
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IncidentLabelResponse(dict):
    """
    Represents an incident label
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"
        elif key == "labelType":
            suggest = "label_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentLabelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentLabelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: str,
                 label_type: str):
        """
        Represents an incident label
        :param str label_name: The name of the label
        :param str label_type: The type of the label
        """
        pulumi.set(__self__, "label_name", label_name)
        pulumi.set(__self__, "label_type", label_type)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> str:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @property
    @pulumi.getter(name="labelType")
    def label_type(self) -> str:
        """
        The type of the label
        """
        return pulumi.get(self, "label_type")


@pulumi.output_type
class IncidentOwnerInfoResponse(dict):
    """
    Information on the user an incident is assigned to
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignedTo":
            suggest = "assigned_to"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "userPrincipalName":
            suggest = "user_principal_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IncidentOwnerInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IncidentOwnerInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assigned_to: Optional[str] = None,
                 email: Optional[str] = None,
                 object_id: Optional[str] = None,
                 user_principal_name: Optional[str] = None):
        """
        Information on the user an incident is assigned to
        :param str assigned_to: The name of the user the incident is assigned to.
        :param str email: The email of the user the incident is assigned to.
        :param str object_id: The object id of the user the incident is assigned to.
        :param str user_principal_name: The user principal name of the user the incident is assigned to.
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[str]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[str]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")


@pulumi.output_type
class InsightsTableResultResponse(dict):
    """
    Query results for table insights query.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.InsightsTableResultResponseColumns']] = None,
                 rows: Optional[Sequence[Sequence[str]]] = None):
        """
        Query results for table insights query.
        :param Sequence['InsightsTableResultResponseColumns'] columns: Columns Metadata of the table
        :param Sequence[Sequence[str]] rows: Rows data of the table
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if rows is not None:
            pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.InsightsTableResultResponseColumns']]:
        """
        Columns Metadata of the table
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter
    def rows(self) -> Optional[Sequence[Sequence[str]]]:
        """
        Rows data of the table
        """
        return pulumi.get(self, "rows")


@pulumi.output_type
class InsightsTableResultResponseColumns(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: the name of the colum
        :param str type: the type of the colum
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        the name of the colum
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        the type of the colum
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MCASDataConnectorDataTypesResponse(dict):
    """
    The available data types for MCAS (Microsoft Cloud App Security) data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryLogs":
            suggest = "discovery_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MCASDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MCASDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alerts: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None,
                 discovery_logs: Optional['outputs.DataConnectorDataTypeCommonResponse'] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param 'DataConnectorDataTypeCommonResponse' alerts: Alerts data type connection.
        :param 'DataConnectorDataTypeCommonResponse' discovery_logs: Discovery log data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional['outputs.DataConnectorDataTypeCommonResponse']:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")


@pulumi.output_type
class MetadataAuthorResponse(dict):
    """
    Publisher or creator of the content item.
    """
    def __init__(__self__, *,
                 email: Optional[str] = None,
                 link: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Publisher or creator of the content item.
        :param str email: Email of author contact
        :param str link: Link for author/vendor page
        :param str name: Name of the author. Company or person.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of author contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link for author/vendor page
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the author. Company or person.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MetadataDependenciesResponse(dict):
    """
    Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentId":
            suggest = "content_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataDependenciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataDependenciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataDependenciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_id: Optional[str] = None,
                 criteria: Optional[Sequence['outputs.MetadataDependenciesResponse']] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 operator: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Dependencies for the content item, what other content items it requires to work.  Can describe more complex dependencies using a recursive/nested structure. For a single dependency an id/kind/version can be supplied or operator/criteria for complex dependencies.
        :param str content_id: Id of the content item we depend on
        :param Sequence['MetadataDependenciesResponse'] criteria: This is the list of dependencies we must fulfill, according to the AND/OR operator
        :param str kind: Type of the content item we depend on
        :param str name: Name of the content item
        :param str operator: Operator used for list of dependencies in criteria array.
        :param str version: Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        if content_id is not None:
            pulumi.set(__self__, "content_id", content_id)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentId")
    def content_id(self) -> Optional[str]:
        """
        Id of the content item we depend on
        """
        return pulumi.get(self, "content_id")

    @property
    @pulumi.getter
    def criteria(self) -> Optional[Sequence['outputs.MetadataDependenciesResponse']]:
        """
        This is the list of dependencies we must fulfill, according to the AND/OR operator
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Type of the content item we depend on
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the content item
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> Optional[str]:
        """
        Operator used for list of dependencies in criteria array.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the the content item we depend on.  Can be blank, * or missing to indicate any version fulfills the dependency.  If version does not match our defined numeric format then an exact match is required.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MetadataSourceResponse(dict):
    """
    The original source of the content item, where it comes from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceId":
            suggest = "source_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: Optional[str] = None,
                 source_id: Optional[str] = None):
        """
        The original source of the content item, where it comes from.
        :param str kind: Source type of the content
        :param str name: Name of the content source.  The repo name, solution name, LA workspace name etc.
        :param str source_id: ID of the content source.  The solution ID, workspace ID, etc
        """
        pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Source type of the content
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the content source.  The repo name, solution name, LA workspace name etc.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[str]:
        """
        ID of the content source.  The solution ID, workspace ID, etc
        """
        return pulumi.get(self, "source_id")


@pulumi.output_type
class MetadataSupportResponse(dict):
    """
    Support information for the content item.
    """
    def __init__(__self__, *,
                 tier: str,
                 email: Optional[str] = None,
                 link: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Support information for the content item.
        :param str tier: Type of support for content item
        :param str email: Email of support contact
        :param str link: Link for support help, like to support page to open a ticket etc.
        :param str name: Name of the support contact. Company or person.
        """
        pulumi.set(__self__, "tier", tier)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        Type of support for content item
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Email of support contact
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def link(self) -> Optional[str]:
        """
        Link for support help, like to support page to open a ticket etc.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the support contact. Company or person.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponse(dict):
    """
    The available data types for office data connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharePoint":
            suggest = "share_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OfficeDataConnectorDataTypesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OfficeDataConnectorDataTypesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exchange: Optional['outputs.OfficeDataConnectorDataTypesResponseExchange'] = None,
                 share_point: Optional['outputs.OfficeDataConnectorDataTypesResponseSharePoint'] = None,
                 teams: Optional['outputs.OfficeDataConnectorDataTypesResponseTeams'] = None):
        """
        The available data types for office data connector.
        :param 'OfficeDataConnectorDataTypesResponseExchange' exchange: Exchange data type connection.
        :param 'OfficeDataConnectorDataTypesResponseSharePoint' share_point: SharePoint data type connection.
        :param 'OfficeDataConnectorDataTypesResponseTeams' teams: Teams data type connection.
        """
        if exchange is not None:
            pulumi.set(__self__, "exchange", exchange)
        if share_point is not None:
            pulumi.set(__self__, "share_point", share_point)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> Optional['outputs.OfficeDataConnectorDataTypesResponseExchange']:
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> Optional['outputs.OfficeDataConnectorDataTypesResponseSharePoint']:
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @property
    @pulumi.getter
    def teams(self) -> Optional['outputs.OfficeDataConnectorDataTypesResponseTeams']:
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseExchange(dict):
    """
    Exchange data type connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Exchange data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseSharePoint(dict):
    """
    SharePoint data type connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        SharePoint data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class OfficeDataConnectorDataTypesResponseTeams(dict):
    """
    Teams data type connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Teams data type connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class RepoResponse(dict):
    """
    Represents a repository.
    """
    def __init__(__self__, *,
                 branches: Optional[Sequence[str]] = None,
                 full_name: Optional[str] = None,
                 repo_url: Optional[str] = None):
        """
        Represents a repository.
        :param Sequence[str] branches: Array of branches.
        :param str full_name: The name of the repository.
        :param str repo_url: The url to access the repository.
        """
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if repo_url is not None:
            pulumi.set(__self__, "repo_url", repo_url)

    @property
    @pulumi.getter
    def branches(self) -> Optional[Sequence[str]]:
        """
        Array of branches.
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[str]:
        """
        The name of the repository.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="repoUrl")
    def repo_url(self) -> Optional[str]:
        """
        The url to access the repository.
        """
        return pulumi.get(self, "repo_url")


@pulumi.output_type
class RepositoryResponse(dict):
    """
    metadata of a repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathMapping":
            suggest = "path_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 path_mapping: Optional[Sequence['outputs.ContentPathMapResponse']] = None,
                 url: Optional[str] = None):
        """
        metadata of a repository.
        :param str branch: Branch name of repository.
        :param Sequence['ContentPathMapResponse'] path_mapping: Dictionary of source control content type and path mapping.
        :param str url: Url of repository.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if path_mapping is not None:
            pulumi.set(__self__, "path_mapping", path_mapping)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        Branch name of repository.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="pathMapping")
    def path_mapping(self) -> Optional[Sequence['outputs.ContentPathMapResponse']]:
        """
        Dictionary of source control content type and path mapping.
        """
        return pulumi.get(self, "path_mapping")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Url of repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class SecurityAlertTimelineItemResponse(dict):
    """
    Represents security alert timeline item.
    """
    def __init__(__self__, *,
                 alert_type: str,
                 azure_resource_id: str,
                 display_name: str,
                 end_time_utc: str,
                 kind: str,
                 severity: str,
                 start_time_utc: str,
                 time_generated: str,
                 description: Optional[str] = None,
                 product_name: Optional[str] = None):
        """
        Represents security alert timeline item.
        :param str alert_type: The name of the alert type.
        :param str azure_resource_id: The alert azure resource id.
        :param str display_name: The alert name.
        :param str end_time_utc: The alert end time.
        :param str kind: The entity query kind
               Expected value is 'SecurityAlert'.
        :param str severity: The alert severity.
        :param str start_time_utc: The alert start time.
        :param str time_generated: The alert generated time.
        :param str description: The alert description.
        :param str product_name: The alert product name.
        """
        pulumi.set(__self__, "alert_type", alert_type)
        pulumi.set(__self__, "azure_resource_id", azure_resource_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "end_time_utc", end_time_utc)
        pulumi.set(__self__, "kind", 'SecurityAlert')
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "start_time_utc", start_time_utc)
        pulumi.set(__self__, "time_generated", time_generated)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if product_name is not None:
            pulumi.set(__self__, "product_name", product_name)

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> str:
        """
        The name of the alert type.
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter(name="azureResourceId")
    def azure_resource_id(self) -> str:
        """
        The alert azure resource id.
        """
        return pulumi.get(self, "azure_resource_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The alert name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> str:
        """
        The alert end time.
        """
        return pulumi.get(self, "end_time_utc")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The entity query kind
        Expected value is 'SecurityAlert'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The alert severity.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> str:
        """
        The alert start time.
        """
        return pulumi.get(self, "start_time_utc")

    @property
    @pulumi.getter(name="timeGenerated")
    def time_generated(self) -> str:
        """
        The alert generated time.
        """
        return pulumi.get(self, "time_generated")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The alert description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[str]:
        """
        The alert product name.
        """
        return pulumi.get(self, "product_name")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TIDataConnectorDataTypesResponse(dict):
    """
    The available data types for TI (Threat Intelligence) data connector.
    """
    def __init__(__self__, *,
                 indicators: Optional['outputs.TIDataConnectorDataTypesResponseIndicators'] = None):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param 'TIDataConnectorDataTypesResponseIndicators' indicators: Data type for indicators connection.
        """
        if indicators is not None:
            pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> Optional['outputs.TIDataConnectorDataTypesResponseIndicators']:
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")


@pulumi.output_type
class TIDataConnectorDataTypesResponseIndicators(dict):
    """
    Data type for indicators connection.
    """
    def __init__(__self__, *,
                 state: Optional[str] = None):
        """
        Data type for indicators connection.
        :param str state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class TimelineAggregationResponse(dict):
    """
    timeline aggregation information per kind
    """
    def __init__(__self__, *,
                 count: int,
                 kind: str):
        """
        timeline aggregation information per kind
        :param int count: the total items found for a kind
        :param str kind: the query kind
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def count(self) -> int:
        """
        the total items found for a kind
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        the query kind
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class TimelineErrorResponse(dict):
    """
    Timeline Query Errors.
    """
    def __init__(__self__, *,
                 error_message: str,
                 kind: str,
                 query_id: Optional[str] = None):
        """
        Timeline Query Errors.
        :param str error_message: the error message
        :param str kind: the query kind
        :param str query_id: the query id
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "kind", kind)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        the error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        the query kind
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[str]:
        """
        the query id
        """
        return pulumi.get(self, "query_id")


@pulumi.output_type
class TimelineResultsMetadataResponse(dict):
    """
    Expansion result metadata.
    """
    def __init__(__self__, *,
                 aggregations: Sequence['outputs.TimelineAggregationResponse'],
                 total_count: int,
                 errors: Optional[Sequence['outputs.TimelineErrorResponse']] = None):
        """
        Expansion result metadata.
        :param Sequence['TimelineAggregationResponse'] aggregations: timeline aggregation per kind
        :param int total_count: the total items found for the timeline request
        :param Sequence['TimelineErrorResponse'] errors: information about the failure queries
        """
        pulumi.set(__self__, "aggregations", aggregations)
        pulumi.set(__self__, "total_count", total_count)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)

    @property
    @pulumi.getter
    def aggregations(self) -> Sequence['outputs.TimelineAggregationResponse']:
        """
        timeline aggregation per kind
        """
        return pulumi.get(self, "aggregations")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        the total items found for the timeline request
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.TimelineErrorResponse']]:
        """
        information about the failure queries
        """
        return pulumi.get(self, "errors")


@pulumi.output_type
class UserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: Optional[str] = None):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


@pulumi.output_type
class WatchlistUserInfoResponse(dict):
    """
    User information that made some action
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WatchlistUserInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WatchlistUserInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 name: str,
                 object_id: Optional[str] = None):
        """
        User information that made some action
        :param str email: The email of the user.
        :param str name: The name of the user.
        :param str object_id: The object id of the user.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")


