# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'HttpAuthenticationResponse',
    'HttpRequestResponse',
    'JobActionResponse',
    'JobCollectionPropertiesResponse',
    'JobCollectionQuotaResponse',
    'JobErrorActionResponse',
    'JobMaxRecurrenceResponse',
    'JobPropertiesResponse',
    'JobRecurrenceResponse',
    'JobRecurrenceScheduleMonthlyOccurrenceResponse',
    'JobRecurrenceScheduleResponse',
    'JobStatusResponse',
    'RetryPolicyResponse',
    'ServiceBusAuthenticationResponse',
    'ServiceBusBrokeredMessagePropertiesResponse',
    'ServiceBusQueueMessageResponse',
    'ServiceBusTopicMessageResponse',
    'SkuResponse',
    'StorageQueueMessageResponse',
]

@pulumi.output_type
class HttpAuthenticationResponse(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: Gets or sets the http authentication type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the http authentication type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HttpRequestResponse(dict):
    def __init__(__self__, *,
                 authentication: Optional['outputs.HttpAuthenticationResponse'] = None,
                 body: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 method: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param 'HttpAuthenticationResponse' authentication: Gets or sets the http authentication.
        :param str body: Gets or sets the request body.
        :param Mapping[str, str] headers: Gets or sets the headers.
        :param str method: Gets or sets the method of the request.
        :param str uri: Gets or sets the Uri.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.HttpAuthenticationResponse']:
        """
        Gets or sets the http authentication.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def body(self) -> Optional[str]:
        """
        Gets or sets the request body.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        Gets or sets the headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        Gets or sets the method of the request.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        Gets or sets the Uri.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class JobActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorAction":
            suggest = "error_action"
        elif key == "queueMessage":
            suggest = "queue_message"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "serviceBusQueueMessage":
            suggest = "service_bus_queue_message"
        elif key == "serviceBusTopicMessage":
            suggest = "service_bus_topic_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_action: Optional['outputs.JobErrorActionResponse'] = None,
                 queue_message: Optional['outputs.StorageQueueMessageResponse'] = None,
                 request: Optional['outputs.HttpRequestResponse'] = None,
                 retry_policy: Optional['outputs.RetryPolicyResponse'] = None,
                 service_bus_queue_message: Optional['outputs.ServiceBusQueueMessageResponse'] = None,
                 service_bus_topic_message: Optional['outputs.ServiceBusTopicMessageResponse'] = None,
                 type: Optional[str] = None):
        """
        :param 'JobErrorActionResponse' error_action: Gets or sets the error action.
        :param 'StorageQueueMessageResponse' queue_message: Gets or sets the storage queue message.
        :param 'HttpRequestResponse' request: Gets or sets the http requests.
        :param 'RetryPolicyResponse' retry_policy: Gets or sets the retry policy.
        :param 'ServiceBusQueueMessageResponse' service_bus_queue_message: Gets or sets the service bus queue message.
        :param 'ServiceBusTopicMessageResponse' service_bus_topic_message: Gets or sets the service bus topic message.
        :param str type: Gets or sets the job action type.
        """
        if error_action is not None:
            pulumi.set(__self__, "error_action", error_action)
        if queue_message is not None:
            pulumi.set(__self__, "queue_message", queue_message)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_bus_queue_message is not None:
            pulumi.set(__self__, "service_bus_queue_message", service_bus_queue_message)
        if service_bus_topic_message is not None:
            pulumi.set(__self__, "service_bus_topic_message", service_bus_topic_message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="errorAction")
    def error_action(self) -> Optional['outputs.JobErrorActionResponse']:
        """
        Gets or sets the error action.
        """
        return pulumi.get(self, "error_action")

    @property
    @pulumi.getter(name="queueMessage")
    def queue_message(self) -> Optional['outputs.StorageQueueMessageResponse']:
        """
        Gets or sets the storage queue message.
        """
        return pulumi.get(self, "queue_message")

    @property
    @pulumi.getter
    def request(self) -> Optional['outputs.HttpRequestResponse']:
        """
        Gets or sets the http requests.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.RetryPolicyResponse']:
        """
        Gets or sets the retry policy.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="serviceBusQueueMessage")
    def service_bus_queue_message(self) -> Optional['outputs.ServiceBusQueueMessageResponse']:
        """
        Gets or sets the service bus queue message.
        """
        return pulumi.get(self, "service_bus_queue_message")

    @property
    @pulumi.getter(name="serviceBusTopicMessage")
    def service_bus_topic_message(self) -> Optional['outputs.ServiceBusTopicMessageResponse']:
        """
        Gets or sets the service bus topic message.
        """
        return pulumi.get(self, "service_bus_topic_message")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the job action type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobCollectionPropertiesResponse(dict):
    def __init__(__self__, *,
                 quota: Optional['outputs.JobCollectionQuotaResponse'] = None,
                 sku: Optional['outputs.SkuResponse'] = None,
                 state: Optional[str] = None):
        """
        :param 'JobCollectionQuotaResponse' quota: Gets or sets the job collection quota.
        :param 'SkuResponse' sku: Gets or sets the SKU.
        :param str state: Gets or sets the state.
        """
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def quota(self) -> Optional['outputs.JobCollectionQuotaResponse']:
        """
        Gets or sets the job collection quota.
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuResponse']:
        """
        Gets or sets the SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets or sets the state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class JobCollectionQuotaResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxJobCount":
            suggest = "max_job_count"
        elif key == "maxJobOccurrence":
            suggest = "max_job_occurrence"
        elif key == "maxRecurrence":
            suggest = "max_recurrence"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCollectionQuotaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCollectionQuotaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCollectionQuotaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_job_count: Optional[int] = None,
                 max_job_occurrence: Optional[int] = None,
                 max_recurrence: Optional['outputs.JobMaxRecurrenceResponse'] = None):
        """
        :param int max_job_count: Gets or set the maximum job count.
        :param int max_job_occurrence: Gets or sets the maximum job occurrence.
        :param 'JobMaxRecurrenceResponse' max_recurrence: Gets or set the maximum recurrence.
        """
        if max_job_count is not None:
            pulumi.set(__self__, "max_job_count", max_job_count)
        if max_job_occurrence is not None:
            pulumi.set(__self__, "max_job_occurrence", max_job_occurrence)
        if max_recurrence is not None:
            pulumi.set(__self__, "max_recurrence", max_recurrence)

    @property
    @pulumi.getter(name="maxJobCount")
    def max_job_count(self) -> Optional[int]:
        """
        Gets or set the maximum job count.
        """
        return pulumi.get(self, "max_job_count")

    @property
    @pulumi.getter(name="maxJobOccurrence")
    def max_job_occurrence(self) -> Optional[int]:
        """
        Gets or sets the maximum job occurrence.
        """
        return pulumi.get(self, "max_job_occurrence")

    @property
    @pulumi.getter(name="maxRecurrence")
    def max_recurrence(self) -> Optional['outputs.JobMaxRecurrenceResponse']:
        """
        Gets or set the maximum recurrence.
        """
        return pulumi.get(self, "max_recurrence")


@pulumi.output_type
class JobErrorActionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueMessage":
            suggest = "queue_message"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "serviceBusQueueMessage":
            suggest = "service_bus_queue_message"
        elif key == "serviceBusTopicMessage":
            suggest = "service_bus_topic_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobErrorActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobErrorActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobErrorActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue_message: Optional['outputs.StorageQueueMessageResponse'] = None,
                 request: Optional['outputs.HttpRequestResponse'] = None,
                 retry_policy: Optional['outputs.RetryPolicyResponse'] = None,
                 service_bus_queue_message: Optional['outputs.ServiceBusQueueMessageResponse'] = None,
                 service_bus_topic_message: Optional['outputs.ServiceBusTopicMessageResponse'] = None,
                 type: Optional[str] = None):
        """
        :param 'StorageQueueMessageResponse' queue_message: Gets or sets the storage queue message.
        :param 'HttpRequestResponse' request: Gets or sets the http requests.
        :param 'RetryPolicyResponse' retry_policy: Gets or sets the retry policy.
        :param 'ServiceBusQueueMessageResponse' service_bus_queue_message: Gets or sets the service bus queue message.
        :param 'ServiceBusTopicMessageResponse' service_bus_topic_message: Gets or sets the service bus topic message.
        :param str type: Gets or sets the job error action type.
        """
        if queue_message is not None:
            pulumi.set(__self__, "queue_message", queue_message)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_bus_queue_message is not None:
            pulumi.set(__self__, "service_bus_queue_message", service_bus_queue_message)
        if service_bus_topic_message is not None:
            pulumi.set(__self__, "service_bus_topic_message", service_bus_topic_message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="queueMessage")
    def queue_message(self) -> Optional['outputs.StorageQueueMessageResponse']:
        """
        Gets or sets the storage queue message.
        """
        return pulumi.get(self, "queue_message")

    @property
    @pulumi.getter
    def request(self) -> Optional['outputs.HttpRequestResponse']:
        """
        Gets or sets the http requests.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.RetryPolicyResponse']:
        """
        Gets or sets the retry policy.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="serviceBusQueueMessage")
    def service_bus_queue_message(self) -> Optional['outputs.ServiceBusQueueMessageResponse']:
        """
        Gets or sets the service bus queue message.
        """
        return pulumi.get(self, "service_bus_queue_message")

    @property
    @pulumi.getter(name="serviceBusTopicMessage")
    def service_bus_topic_message(self) -> Optional['outputs.ServiceBusTopicMessageResponse']:
        """
        Gets or sets the service bus topic message.
        """
        return pulumi.get(self, "service_bus_topic_message")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the job error action type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobMaxRecurrenceResponse(dict):
    def __init__(__self__, *,
                 frequency: Optional[str] = None,
                 interval: Optional[int] = None):
        """
        :param str frequency: Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        :param int interval: Gets or sets the interval between retries.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Gets or sets the interval between retries.
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class JobPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: 'outputs.JobStatusResponse',
                 action: Optional['outputs.JobActionResponse'] = None,
                 recurrence: Optional['outputs.JobRecurrenceResponse'] = None,
                 start_time: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param 'JobStatusResponse' status: Gets the job status.
        :param 'JobActionResponse' action: Gets or sets the job action.
        :param 'JobRecurrenceResponse' recurrence: Gets or sets the job recurrence.
        :param str start_time: Gets or sets the job start time.
        :param str state: Gets or set the job state.
        """
        pulumi.set(__self__, "status", status)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def status(self) -> 'outputs.JobStatusResponse':
        """
        Gets the job status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.JobActionResponse']:
        """
        Gets or sets the job action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.JobRecurrenceResponse']:
        """
        Gets or sets the job recurrence.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Gets or sets the job start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Gets or set the job state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class JobRecurrenceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobRecurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobRecurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobRecurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 end_time: Optional[str] = None,
                 frequency: Optional[str] = None,
                 interval: Optional[int] = None,
                 schedule: Optional['outputs.JobRecurrenceScheduleResponse'] = None):
        """
        :param int count: Gets or sets the maximum number of times that the job should run.
        :param str end_time: Gets or sets the time at which the job will complete.
        :param str frequency: Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        :param int interval: Gets or sets the interval between retries.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Gets or sets the maximum number of times that the job should run.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        Gets or sets the time at which the job will complete.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> Optional[str]:
        """
        Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        Gets or sets the interval between retries.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.JobRecurrenceScheduleResponse']:
        return pulumi.get(self, "schedule")


@pulumi.output_type
class JobRecurrenceScheduleMonthlyOccurrenceResponse(dict):
    def __init__(__self__, *,
                 day: Optional[str] = None,
                 occurrence: Optional[int] = None):
        """
        :param str day: Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        :param int occurrence: Gets or sets the occurrence. Must be between -5 and 5.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[str]:
        """
        Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[int]:
        """
        Gets or sets the occurrence. Must be between -5 and 5.
        """
        return pulumi.get(self, "occurrence")


@pulumi.output_type
class JobRecurrenceScheduleResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDays":
            suggest = "month_days"
        elif key == "monthlyOccurrences":
            suggest = "monthly_occurrences"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobRecurrenceScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobRecurrenceScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobRecurrenceScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hours: Optional[Sequence[int]] = None,
                 minutes: Optional[Sequence[int]] = None,
                 month_days: Optional[Sequence[int]] = None,
                 monthly_occurrences: Optional[Sequence['outputs.JobRecurrenceScheduleMonthlyOccurrenceResponse']] = None,
                 week_days: Optional[Sequence[str]] = None):
        """
        :param Sequence[int] hours: Gets or sets the hours of the day that the job should execute at.
        :param Sequence[int] minutes: Gets or sets the minutes of the hour that the job should execute at.
        :param Sequence[int] month_days: Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
        :param Sequence['JobRecurrenceScheduleMonthlyOccurrenceResponse'] monthly_occurrences: Gets or sets the occurrences of days within a month.
        :param Sequence[str] week_days: Gets or sets the days of the week that the job should execute on.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[Sequence[int]]:
        """
        Gets or sets the hours of the day that the job should execute at.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> Optional[Sequence[int]]:
        """
        Gets or sets the minutes of the hour that the job should execute at.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[Sequence[int]]:
        """
        Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
        """
        return pulumi.get(self, "month_days")

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[Sequence['outputs.JobRecurrenceScheduleMonthlyOccurrenceResponse']]:
        """
        Gets or sets the occurrences of days within a month.
        """
        return pulumi.get(self, "monthly_occurrences")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the days of the week that the job should execute on.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class JobStatusResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionCount":
            suggest = "execution_count"
        elif key == "failureCount":
            suggest = "failure_count"
        elif key == "faultedCount":
            suggest = "faulted_count"
        elif key == "lastExecutionTime":
            suggest = "last_execution_time"
        elif key == "nextExecutionTime":
            suggest = "next_execution_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_count: int,
                 failure_count: int,
                 faulted_count: int,
                 last_execution_time: str,
                 next_execution_time: str):
        """
        :param int execution_count: Gets the number of times this job has executed.
        :param int failure_count: Gets the number of times this job has failed.
        :param int faulted_count: Gets the number of faulted occurrences (occurrences that were retried and failed as many times as the retry policy states).
        :param str last_execution_time: Gets the time the last occurrence executed in ISO-8601 format.  Could be empty if job has not run yet.
        :param str next_execution_time: Gets the time of the next occurrence in ISO-8601 format. Could be empty if the job is completed.
        """
        pulumi.set(__self__, "execution_count", execution_count)
        pulumi.set(__self__, "failure_count", failure_count)
        pulumi.set(__self__, "faulted_count", faulted_count)
        pulumi.set(__self__, "last_execution_time", last_execution_time)
        pulumi.set(__self__, "next_execution_time", next_execution_time)

    @property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> int:
        """
        Gets the number of times this job has executed.
        """
        return pulumi.get(self, "execution_count")

    @property
    @pulumi.getter(name="failureCount")
    def failure_count(self) -> int:
        """
        Gets the number of times this job has failed.
        """
        return pulumi.get(self, "failure_count")

    @property
    @pulumi.getter(name="faultedCount")
    def faulted_count(self) -> int:
        """
        Gets the number of faulted occurrences (occurrences that were retried and failed as many times as the retry policy states).
        """
        return pulumi.get(self, "faulted_count")

    @property
    @pulumi.getter(name="lastExecutionTime")
    def last_execution_time(self) -> str:
        """
        Gets the time the last occurrence executed in ISO-8601 format.  Could be empty if job has not run yet.
        """
        return pulumi.get(self, "last_execution_time")

    @property
    @pulumi.getter(name="nextExecutionTime")
    def next_execution_time(self) -> str:
        """
        Gets the time of the next occurrence in ISO-8601 format. Could be empty if the job is completed.
        """
        return pulumi.get(self, "next_execution_time")


@pulumi.output_type
class RetryPolicyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryCount":
            suggest = "retry_count"
        elif key == "retryInterval":
            suggest = "retry_interval"
        elif key == "retryType":
            suggest = "retry_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetryPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetryPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retry_count: Optional[int] = None,
                 retry_interval: Optional[str] = None,
                 retry_type: Optional[str] = None):
        """
        :param int retry_count: Gets or sets the number of times a retry should be attempted.
        :param str retry_interval: Gets or sets the retry interval between retries.
        :param str retry_type: Gets or sets the retry strategy to be used.
        """
        if retry_count is not None:
            pulumi.set(__self__, "retry_count", retry_count)
        if retry_interval is not None:
            pulumi.set(__self__, "retry_interval", retry_interval)
        if retry_type is not None:
            pulumi.set(__self__, "retry_type", retry_type)

    @property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> Optional[int]:
        """
        Gets or sets the number of times a retry should be attempted.
        """
        return pulumi.get(self, "retry_count")

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[str]:
        """
        Gets or sets the retry interval between retries.
        """
        return pulumi.get(self, "retry_interval")

    @property
    @pulumi.getter(name="retryType")
    def retry_type(self) -> Optional[str]:
        """
        Gets or sets the retry strategy to be used.
        """
        return pulumi.get(self, "retry_type")


@pulumi.output_type
class ServiceBusAuthenticationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasKey":
            suggest = "sas_key"
        elif key == "sasKeyName":
            suggest = "sas_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusAuthenticationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusAuthenticationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusAuthenticationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_key: Optional[str] = None,
                 sas_key_name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str sas_key: Gets or sets the SAS key.
        :param str sas_key_name: Gets or sets the SAS key name.
        :param str type: Gets or sets the authentication type.
        """
        if sas_key is not None:
            pulumi.set(__self__, "sas_key", sas_key)
        if sas_key_name is not None:
            pulumi.set(__self__, "sas_key_name", sas_key_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> Optional[str]:
        """
        Gets or sets the SAS key.
        """
        return pulumi.get(self, "sas_key")

    @property
    @pulumi.getter(name="sasKeyName")
    def sas_key_name(self) -> Optional[str]:
        """
        Gets or sets the SAS key name.
        """
        return pulumi.get(self, "sas_key_name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the authentication type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceBusBrokeredMessagePropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "correlationId":
            suggest = "correlation_id"
        elif key == "forcePersistence":
            suggest = "force_persistence"
        elif key == "messageId":
            suggest = "message_id"
        elif key == "partitionKey":
            suggest = "partition_key"
        elif key == "replyTo":
            suggest = "reply_to"
        elif key == "replyToSessionId":
            suggest = "reply_to_session_id"
        elif key == "scheduledEnqueueTimeUtc":
            suggest = "scheduled_enqueue_time_utc"
        elif key == "sessionId":
            suggest = "session_id"
        elif key == "timeToLive":
            suggest = "time_to_live"
        elif key == "viaPartitionKey":
            suggest = "via_partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusBrokeredMessagePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusBrokeredMessagePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusBrokeredMessagePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional[str] = None,
                 correlation_id: Optional[str] = None,
                 force_persistence: Optional[bool] = None,
                 label: Optional[str] = None,
                 message_id: Optional[str] = None,
                 partition_key: Optional[str] = None,
                 reply_to: Optional[str] = None,
                 reply_to_session_id: Optional[str] = None,
                 scheduled_enqueue_time_utc: Optional[str] = None,
                 session_id: Optional[str] = None,
                 time_to_live: Optional[str] = None,
                 to: Optional[str] = None,
                 via_partition_key: Optional[str] = None):
        """
        :param str content_type: Gets or sets the content type.
        :param str correlation_id: Gets or sets the correlation id.
        :param bool force_persistence: Gets or sets the force persistence.
        :param str label: Gets or sets the label.
        :param str message_id: Gets or sets the message id.
        :param str partition_key: Gets or sets the partition key.
        :param str reply_to: Gets or sets the reply to.
        :param str reply_to_session_id: Gets or sets the reply to session id.
        :param str scheduled_enqueue_time_utc: Gets or sets the scheduled enqueue time UTC.
        :param str session_id: Gets or sets the session id.
        :param str time_to_live: Gets or sets the time to live.
        :param str to: Gets or sets the to.
        :param str via_partition_key: Gets or sets the via partition key.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if correlation_id is not None:
            pulumi.set(__self__, "correlation_id", correlation_id)
        if force_persistence is not None:
            pulumi.set(__self__, "force_persistence", force_persistence)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if reply_to is not None:
            pulumi.set(__self__, "reply_to", reply_to)
        if reply_to_session_id is not None:
            pulumi.set(__self__, "reply_to_session_id", reply_to_session_id)
        if scheduled_enqueue_time_utc is not None:
            pulumi.set(__self__, "scheduled_enqueue_time_utc", scheduled_enqueue_time_utc)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)
        if to is not None:
            pulumi.set(__self__, "to", to)
        if via_partition_key is not None:
            pulumi.set(__self__, "via_partition_key", via_partition_key)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Gets or sets the content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> Optional[str]:
        """
        Gets or sets the correlation id.
        """
        return pulumi.get(self, "correlation_id")

    @property
    @pulumi.getter(name="forcePersistence")
    def force_persistence(self) -> Optional[bool]:
        """
        Gets or sets the force persistence.
        """
        return pulumi.get(self, "force_persistence")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Gets or sets the label.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[str]:
        """
        Gets or sets the message id.
        """
        return pulumi.get(self, "message_id")

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[str]:
        """
        Gets or sets the partition key.
        """
        return pulumi.get(self, "partition_key")

    @property
    @pulumi.getter(name="replyTo")
    def reply_to(self) -> Optional[str]:
        """
        Gets or sets the reply to.
        """
        return pulumi.get(self, "reply_to")

    @property
    @pulumi.getter(name="replyToSessionId")
    def reply_to_session_id(self) -> Optional[str]:
        """
        Gets or sets the reply to session id.
        """
        return pulumi.get(self, "reply_to_session_id")

    @property
    @pulumi.getter(name="scheduledEnqueueTimeUtc")
    def scheduled_enqueue_time_utc(self) -> Optional[str]:
        """
        Gets or sets the scheduled enqueue time UTC.
        """
        return pulumi.get(self, "scheduled_enqueue_time_utc")

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[str]:
        """
        Gets or sets the session id.
        """
        return pulumi.get(self, "session_id")

    @property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[str]:
        """
        Gets or sets the time to live.
        """
        return pulumi.get(self, "time_to_live")

    @property
    @pulumi.getter
    def to(self) -> Optional[str]:
        """
        Gets or sets the to.
        """
        return pulumi.get(self, "to")

    @property
    @pulumi.getter(name="viaPartitionKey")
    def via_partition_key(self) -> Optional[str]:
        """
        Gets or sets the via partition key.
        """
        return pulumi.get(self, "via_partition_key")


@pulumi.output_type
class ServiceBusQueueMessageResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brokeredMessageProperties":
            suggest = "brokered_message_properties"
        elif key == "customMessageProperties":
            suggest = "custom_message_properties"
        elif key == "queueName":
            suggest = "queue_name"
        elif key == "transportType":
            suggest = "transport_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusQueueMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusQueueMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusQueueMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication: Optional['outputs.ServiceBusAuthenticationResponse'] = None,
                 brokered_message_properties: Optional['outputs.ServiceBusBrokeredMessagePropertiesResponse'] = None,
                 custom_message_properties: Optional[Mapping[str, str]] = None,
                 message: Optional[str] = None,
                 namespace: Optional[str] = None,
                 queue_name: Optional[str] = None,
                 transport_type: Optional[str] = None):
        """
        :param 'ServiceBusAuthenticationResponse' authentication: Gets or sets the authentication.
        :param 'ServiceBusBrokeredMessagePropertiesResponse' brokered_message_properties: Gets or sets the brokered message properties.
        :param Mapping[str, str] custom_message_properties: Gets or sets the custom message properties.
        :param str message: Gets or sets the message.
        :param str namespace: Gets or sets the namespace.
        :param str queue_name: Gets or sets the queue name.
        :param str transport_type: Gets or sets the transport type.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if brokered_message_properties is not None:
            pulumi.set(__self__, "brokered_message_properties", brokered_message_properties)
        if custom_message_properties is not None:
            pulumi.set(__self__, "custom_message_properties", custom_message_properties)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if transport_type is not None:
            pulumi.set(__self__, "transport_type", transport_type)

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.ServiceBusAuthenticationResponse']:
        """
        Gets or sets the authentication.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="brokeredMessageProperties")
    def brokered_message_properties(self) -> Optional['outputs.ServiceBusBrokeredMessagePropertiesResponse']:
        """
        Gets or sets the brokered message properties.
        """
        return pulumi.get(self, "brokered_message_properties")

    @property
    @pulumi.getter(name="customMessageProperties")
    def custom_message_properties(self) -> Optional[Mapping[str, str]]:
        """
        Gets or sets the custom message properties.
        """
        return pulumi.get(self, "custom_message_properties")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Gets or sets the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Gets or sets the namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Gets or sets the queue name.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> Optional[str]:
        """
        Gets or sets the transport type.
        """
        return pulumi.get(self, "transport_type")


@pulumi.output_type
class ServiceBusTopicMessageResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "brokeredMessageProperties":
            suggest = "brokered_message_properties"
        elif key == "customMessageProperties":
            suggest = "custom_message_properties"
        elif key == "topicPath":
            suggest = "topic_path"
        elif key == "transportType":
            suggest = "transport_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBusTopicMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBusTopicMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBusTopicMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication: Optional['outputs.ServiceBusAuthenticationResponse'] = None,
                 brokered_message_properties: Optional['outputs.ServiceBusBrokeredMessagePropertiesResponse'] = None,
                 custom_message_properties: Optional[Mapping[str, str]] = None,
                 message: Optional[str] = None,
                 namespace: Optional[str] = None,
                 topic_path: Optional[str] = None,
                 transport_type: Optional[str] = None):
        """
        :param 'ServiceBusAuthenticationResponse' authentication: Gets or sets the authentication.
        :param 'ServiceBusBrokeredMessagePropertiesResponse' brokered_message_properties: Gets or sets the brokered message properties.
        :param Mapping[str, str] custom_message_properties: Gets or sets the custom message properties.
        :param str message: Gets or sets the message.
        :param str namespace: Gets or sets the namespace.
        :param str topic_path: Gets or sets the topic path.
        :param str transport_type: Gets or sets the transport type.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if brokered_message_properties is not None:
            pulumi.set(__self__, "brokered_message_properties", brokered_message_properties)
        if custom_message_properties is not None:
            pulumi.set(__self__, "custom_message_properties", custom_message_properties)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if topic_path is not None:
            pulumi.set(__self__, "topic_path", topic_path)
        if transport_type is not None:
            pulumi.set(__self__, "transport_type", transport_type)

    @property
    @pulumi.getter
    def authentication(self) -> Optional['outputs.ServiceBusAuthenticationResponse']:
        """
        Gets or sets the authentication.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="brokeredMessageProperties")
    def brokered_message_properties(self) -> Optional['outputs.ServiceBusBrokeredMessagePropertiesResponse']:
        """
        Gets or sets the brokered message properties.
        """
        return pulumi.get(self, "brokered_message_properties")

    @property
    @pulumi.getter(name="customMessageProperties")
    def custom_message_properties(self) -> Optional[Mapping[str, str]]:
        """
        Gets or sets the custom message properties.
        """
        return pulumi.get(self, "custom_message_properties")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Gets or sets the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Gets or sets the namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="topicPath")
    def topic_path(self) -> Optional[str]:
        """
        Gets or sets the topic path.
        """
        return pulumi.get(self, "topic_path")

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> Optional[str]:
        """
        Gets or sets the transport type.
        """
        return pulumi.get(self, "transport_type")


@pulumi.output_type
class SkuResponse(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        :param str name: Gets or set the SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or set the SKU.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class StorageQueueMessageResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueName":
            suggest = "queue_name"
        elif key == "sasToken":
            suggest = "sas_token"
        elif key == "storageAccount":
            suggest = "storage_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageQueueMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageQueueMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageQueueMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message: Optional[str] = None,
                 queue_name: Optional[str] = None,
                 sas_token: Optional[str] = None,
                 storage_account: Optional[str] = None):
        """
        :param str message: Gets or sets the message.
        :param str queue_name: Gets or sets the queue name.
        :param str sas_token: Gets or sets the SAS key.
        :param str storage_account: Gets or sets the storage account name.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Gets or sets the message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Gets or sets the queue name.
        """
        return pulumi.get(self, "queue_name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[str]:
        """
        Gets or sets the SAS key.
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[str]:
        """
        Gets or sets the storage account name.
        """
        return pulumi.get(self, "storage_account")


