# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActiveConnectivityConfigurationResponse',
    'ActiveDefaultSecurityAdminRuleResponse',
    'ActiveDefaultSecurityUserRuleResponse',
    'ActiveSecurityAdminRuleResponse',
    'ActiveSecurityUserRuleResponse',
    'AddressPrefixItemResponse',
    'ConfigurationGroupResponse',
    'ConnectivityGroupItemResponse',
    'EffectiveConnectivityConfigurationResponse',
    'EffectiveDefaultSecurityAdminRuleResponse',
    'EffectiveSecurityAdminRuleResponse',
    'EffectiveVirtualNetworkResponse',
    'GroupMembersItemResponse',
    'NetworkManagerDeploymentStatusResponse',
    'NetworkManagerPropertiesResponseNetworkManagerScopes',
    'NetworkManagerSecurityGroupItemResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class ActiveConnectivityConfigurationResponse(dict):
    """
    Active connectivity configuration.
    """
    def __init__(__self__, *,
                 connectivity_topology: str,
                 provisioning_state: str,
                 applies_to_groups: Optional[Sequence['outputs.ConnectivityGroupItemResponse']] = None,
                 commit_time: Optional[str] = None,
                 configuration_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None,
                 delete_existing_peering: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 hub_id: Optional[str] = None,
                 id: Optional[str] = None,
                 is_global: Optional[str] = None,
                 region: Optional[str] = None):
        """
        Active connectivity configuration.
        :param str connectivity_topology: Connectivity topology type.
        :param str provisioning_state: The provisioning state of the connectivity configuration resource.
        :param Sequence['ConnectivityGroupItemResponse'] applies_to_groups: Groups for configuration
        :param str commit_time: Deployment time string.
        :param Sequence['ConfigurationGroupResponse'] configuration_groups: Effective configuration groups.
        :param str delete_existing_peering: Flag if need to remove current existing peerings.
        :param str description: A description of the connectivity configuration.
        :param str display_name: A friendly name for the resource.
        :param str hub_id: The hub vnet Id.
        :param str id: Resource ID.
        :param str is_global: Flag if global mesh is supported.
        :param str region: Deployment region.
        """
        pulumi.set(__self__, "connectivity_topology", connectivity_topology)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if applies_to_groups is not None:
            pulumi.set(__self__, "applies_to_groups", applies_to_groups)
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if configuration_groups is not None:
            pulumi.set(__self__, "configuration_groups", configuration_groups)
        if delete_existing_peering is not None:
            pulumi.set(__self__, "delete_existing_peering", delete_existing_peering)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if hub_id is not None:
            pulumi.set(__self__, "hub_id", hub_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_global is not None:
            pulumi.set(__self__, "is_global", is_global)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="connectivityTopology")
    def connectivity_topology(self) -> str:
        """
        Connectivity topology type.
        """
        return pulumi.get(self, "connectivity_topology")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the connectivity configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appliesToGroups")
    def applies_to_groups(self) -> Optional[Sequence['outputs.ConnectivityGroupItemResponse']]:
        """
        Groups for configuration
        """
        return pulumi.get(self, "applies_to_groups")

    @property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[str]:
        """
        Deployment time string.
        """
        return pulumi.get(self, "commit_time")

    @property
    @pulumi.getter(name="configurationGroups")
    def configuration_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "configuration_groups")

    @property
    @pulumi.getter(name="deleteExistingPeering")
    def delete_existing_peering(self) -> Optional[str]:
        """
        Flag if need to remove current existing peerings.
        """
        return pulumi.get(self, "delete_existing_peering")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the connectivity configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A friendly name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> Optional[str]:
        """
        The hub vnet Id.
        """
        return pulumi.get(self, "hub_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isGlobal")
    def is_global(self) -> Optional[str]:
        """
        Flag if global mesh is supported.
        """
        return pulumi.get(self, "is_global")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Deployment region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class ActiveDefaultSecurityAdminRuleResponse(dict):
    """
    Network default admin rule.
    """
    def __init__(__self__, *,
                 access: str,
                 description: str,
                 destination_port_ranges: Sequence[str],
                 destinations: Sequence['outputs.AddressPrefixItemResponse'],
                 direction: str,
                 display_name: str,
                 kind: str,
                 priority: int,
                 protocol: str,
                 provisioning_state: str,
                 source_port_ranges: Sequence[str],
                 sources: Sequence['outputs.AddressPrefixItemResponse'],
                 commit_time: Optional[str] = None,
                 configuration_description: Optional[str] = None,
                 configuration_display_name: Optional[str] = None,
                 flag: Optional[str] = None,
                 id: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_collection_applies_to_groups: Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']] = None,
                 rule_collection_description: Optional[str] = None,
                 rule_collection_display_name: Optional[str] = None,
                 rule_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None):
        """
        Network default admin rule.
        :param str access: Indicates the access allowed for this particular rule
        :param str description: A description for this rule. Restricted to 140 chars.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param Sequence['AddressPrefixItemResponse'] destinations: The destination address prefixes. CIDR or destination IP ranges.
        :param str direction: Indicates if the traffic matched against the rule in inbound or outbound.
        :param str display_name: A friendly name for the rule.
        :param str kind: Whether the rule is custom or default.
               Expected value is 'Default'.
        :param int priority: The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the resource.
        :param Sequence[str] source_port_ranges: The source port ranges.
        :param Sequence['AddressPrefixItemResponse'] sources: The CIDR or source IP ranges.
        :param str commit_time: Deployment time string.
        :param str configuration_description: A description of the security admin configuration.
        :param str configuration_display_name: A display name of the security admin configuration.
        :param str flag: Default rule flag.
        :param str id: Resource ID.
        :param str region: Deployment region.
        :param Sequence['NetworkManagerSecurityGroupItemResponse'] rule_collection_applies_to_groups: Groups for rule collection
        :param str rule_collection_description: A description of the rule collection.
        :param str rule_collection_display_name: A display name of the rule collection.
        :param Sequence['ConfigurationGroupResponse'] rule_groups: Effective configuration groups.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "kind", 'Default')
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        pulumi.set(__self__, "sources", sources)
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if configuration_description is not None:
            pulumi.set(__self__, "configuration_description", configuration_description)
        if configuration_display_name is not None:
            pulumi.set(__self__, "configuration_display_name", configuration_display_name)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_collection_applies_to_groups is not None:
            pulumi.set(__self__, "rule_collection_applies_to_groups", rule_collection_applies_to_groups)
        if rule_collection_description is not None:
            pulumi.set(__self__, "rule_collection_description", rule_collection_description)
        if rule_collection_display_name is not None:
            pulumi.set(__self__, "rule_collection_display_name", rule_collection_display_name)
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        Indicates the access allowed for this particular rule
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Sequence[str]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.AddressPrefixItemResponse']:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Indicates if the traffic matched against the rule in inbound or outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A friendly name for the rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Whether the rule is custom or default.
        Expected value is 'Default'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Sequence[str]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.AddressPrefixItemResponse']:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[str]:
        """
        Deployment time string.
        """
        return pulumi.get(self, "commit_time")

    @property
    @pulumi.getter(name="configurationDescription")
    def configuration_description(self) -> Optional[str]:
        """
        A description of the security admin configuration.
        """
        return pulumi.get(self, "configuration_description")

    @property
    @pulumi.getter(name="configurationDisplayName")
    def configuration_display_name(self) -> Optional[str]:
        """
        A display name of the security admin configuration.
        """
        return pulumi.get(self, "configuration_display_name")

    @property
    @pulumi.getter
    def flag(self) -> Optional[str]:
        """
        Default rule flag.
        """
        return pulumi.get(self, "flag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Deployment region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleCollectionAppliesToGroups")
    def rule_collection_applies_to_groups(self) -> Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']]:
        """
        Groups for rule collection
        """
        return pulumi.get(self, "rule_collection_applies_to_groups")

    @property
    @pulumi.getter(name="ruleCollectionDescription")
    def rule_collection_description(self) -> Optional[str]:
        """
        A description of the rule collection.
        """
        return pulumi.get(self, "rule_collection_description")

    @property
    @pulumi.getter(name="ruleCollectionDisplayName")
    def rule_collection_display_name(self) -> Optional[str]:
        """
        A display name of the rule collection.
        """
        return pulumi.get(self, "rule_collection_display_name")

    @property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "rule_groups")


@pulumi.output_type
class ActiveDefaultSecurityUserRuleResponse(dict):
    """
    Network security default user rule.
    """
    def __init__(__self__, *,
                 description: str,
                 destination_port_ranges: Sequence[str],
                 destinations: Sequence['outputs.AddressPrefixItemResponse'],
                 direction: str,
                 display_name: str,
                 kind: str,
                 protocol: str,
                 provisioning_state: str,
                 source_port_ranges: Sequence[str],
                 sources: Sequence['outputs.AddressPrefixItemResponse'],
                 commit_time: Optional[str] = None,
                 configuration_description: Optional[str] = None,
                 configuration_display_name: Optional[str] = None,
                 flag: Optional[str] = None,
                 id: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_collection_applies_to_groups: Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']] = None,
                 rule_collection_description: Optional[str] = None,
                 rule_collection_display_name: Optional[str] = None,
                 rule_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None):
        """
        Network security default user rule.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param Sequence['AddressPrefixItemResponse'] destinations: The destination address prefixes. CIDR or destination IP ranges.
        :param str direction: Indicates if the traffic matched against the rule in inbound or outbound.
        :param str display_name: A friendly name for the rule.
        :param str kind: Whether the rule is custom or default.
               Expected value is 'Default'.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the security configuration user rule resource.
        :param Sequence[str] source_port_ranges: The source port ranges.
        :param Sequence['AddressPrefixItemResponse'] sources: The CIDR or source IP ranges.
        :param str commit_time: Deployment time string.
        :param str configuration_description: A description of the security user configuration.
        :param str configuration_display_name: A display name of the security user configuration.
        :param str flag: Default rule flag.
        :param str id: Resource ID.
        :param str region: Deployment region.
        :param Sequence['NetworkManagerSecurityGroupItemResponse'] rule_collection_applies_to_groups: Groups for rule collection
        :param str rule_collection_description: A description of the rule collection.
        :param str rule_collection_display_name: A display name of the rule collection.
        :param Sequence['ConfigurationGroupResponse'] rule_groups: Effective configuration groups.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "kind", 'Default')
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        pulumi.set(__self__, "sources", sources)
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if configuration_description is not None:
            pulumi.set(__self__, "configuration_description", configuration_description)
        if configuration_display_name is not None:
            pulumi.set(__self__, "configuration_display_name", configuration_display_name)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_collection_applies_to_groups is not None:
            pulumi.set(__self__, "rule_collection_applies_to_groups", rule_collection_applies_to_groups)
        if rule_collection_description is not None:
            pulumi.set(__self__, "rule_collection_description", rule_collection_description)
        if rule_collection_display_name is not None:
            pulumi.set(__self__, "rule_collection_display_name", rule_collection_display_name)
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Sequence[str]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.AddressPrefixItemResponse']:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Indicates if the traffic matched against the rule in inbound or outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A friendly name for the rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Whether the rule is custom or default.
        Expected value is 'Default'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the security configuration user rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Sequence[str]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.AddressPrefixItemResponse']:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[str]:
        """
        Deployment time string.
        """
        return pulumi.get(self, "commit_time")

    @property
    @pulumi.getter(name="configurationDescription")
    def configuration_description(self) -> Optional[str]:
        """
        A description of the security user configuration.
        """
        return pulumi.get(self, "configuration_description")

    @property
    @pulumi.getter(name="configurationDisplayName")
    def configuration_display_name(self) -> Optional[str]:
        """
        A display name of the security user configuration.
        """
        return pulumi.get(self, "configuration_display_name")

    @property
    @pulumi.getter
    def flag(self) -> Optional[str]:
        """
        Default rule flag.
        """
        return pulumi.get(self, "flag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Deployment region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleCollectionAppliesToGroups")
    def rule_collection_applies_to_groups(self) -> Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']]:
        """
        Groups for rule collection
        """
        return pulumi.get(self, "rule_collection_applies_to_groups")

    @property
    @pulumi.getter(name="ruleCollectionDescription")
    def rule_collection_description(self) -> Optional[str]:
        """
        A description of the rule collection.
        """
        return pulumi.get(self, "rule_collection_description")

    @property
    @pulumi.getter(name="ruleCollectionDisplayName")
    def rule_collection_display_name(self) -> Optional[str]:
        """
        A display name of the rule collection.
        """
        return pulumi.get(self, "rule_collection_display_name")

    @property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "rule_groups")


@pulumi.output_type
class ActiveSecurityAdminRuleResponse(dict):
    """
    Network admin rule.
    """
    def __init__(__self__, *,
                 access: str,
                 direction: str,
                 kind: str,
                 protocol: str,
                 provisioning_state: str,
                 commit_time: Optional[str] = None,
                 configuration_description: Optional[str] = None,
                 configuration_display_name: Optional[str] = None,
                 description: Optional[str] = None,
                 destination_port_ranges: Optional[Sequence[str]] = None,
                 destinations: Optional[Sequence['outputs.AddressPrefixItemResponse']] = None,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 priority: Optional[int] = None,
                 region: Optional[str] = None,
                 rule_collection_applies_to_groups: Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']] = None,
                 rule_collection_description: Optional[str] = None,
                 rule_collection_display_name: Optional[str] = None,
                 rule_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None,
                 source_port_ranges: Optional[Sequence[str]] = None,
                 sources: Optional[Sequence['outputs.AddressPrefixItemResponse']] = None):
        """
        Network admin rule.
        :param str access: Indicates the access allowed for this particular rule
        :param str direction: Indicates if the traffic matched against the rule in inbound or outbound.
        :param str kind: Whether the rule is custom or default.
               Expected value is 'Custom'.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the resource.
        :param str commit_time: Deployment time string.
        :param str configuration_description: A description of the security admin configuration.
        :param str configuration_display_name: A display name of the security admin configuration.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param Sequence['AddressPrefixItemResponse'] destinations: The destination address prefixes. CIDR or destination IP ranges.
        :param str display_name: A friendly name for the rule.
        :param str id: Resource ID.
        :param int priority: The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str region: Deployment region.
        :param Sequence['NetworkManagerSecurityGroupItemResponse'] rule_collection_applies_to_groups: Groups for rule collection
        :param str rule_collection_description: A description of the rule collection.
        :param str rule_collection_display_name: A display name of the rule collection.
        :param Sequence['ConfigurationGroupResponse'] rule_groups: Effective configuration groups.
        :param Sequence[str] source_port_ranges: The source port ranges.
        :param Sequence['AddressPrefixItemResponse'] sources: The CIDR or source IP ranges.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "kind", 'Custom')
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if configuration_description is not None:
            pulumi.set(__self__, "configuration_description", configuration_description)
        if configuration_display_name is not None:
            pulumi.set(__self__, "configuration_display_name", configuration_display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_collection_applies_to_groups is not None:
            pulumi.set(__self__, "rule_collection_applies_to_groups", rule_collection_applies_to_groups)
        if rule_collection_description is not None:
            pulumi.set(__self__, "rule_collection_description", rule_collection_description)
        if rule_collection_display_name is not None:
            pulumi.set(__self__, "rule_collection_display_name", rule_collection_display_name)
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        Indicates the access allowed for this particular rule
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Indicates if the traffic matched against the rule in inbound or outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Whether the rule is custom or default.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[str]:
        """
        Deployment time string.
        """
        return pulumi.get(self, "commit_time")

    @property
    @pulumi.getter(name="configurationDescription")
    def configuration_description(self) -> Optional[str]:
        """
        A description of the security admin configuration.
        """
        return pulumi.get(self, "configuration_description")

    @property
    @pulumi.getter(name="configurationDisplayName")
    def configuration_display_name(self) -> Optional[str]:
        """
        A display name of the security admin configuration.
        """
        return pulumi.get(self, "configuration_display_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.AddressPrefixItemResponse']]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A friendly name for the rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Deployment region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleCollectionAppliesToGroups")
    def rule_collection_applies_to_groups(self) -> Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']]:
        """
        Groups for rule collection
        """
        return pulumi.get(self, "rule_collection_applies_to_groups")

    @property
    @pulumi.getter(name="ruleCollectionDescription")
    def rule_collection_description(self) -> Optional[str]:
        """
        A description of the rule collection.
        """
        return pulumi.get(self, "rule_collection_description")

    @property
    @pulumi.getter(name="ruleCollectionDisplayName")
    def rule_collection_display_name(self) -> Optional[str]:
        """
        A display name of the rule collection.
        """
        return pulumi.get(self, "rule_collection_display_name")

    @property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "rule_groups")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AddressPrefixItemResponse']]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class ActiveSecurityUserRuleResponse(dict):
    """
    Network security user rule.
    """
    def __init__(__self__, *,
                 direction: str,
                 kind: str,
                 protocol: str,
                 provisioning_state: str,
                 commit_time: Optional[str] = None,
                 configuration_description: Optional[str] = None,
                 configuration_display_name: Optional[str] = None,
                 description: Optional[str] = None,
                 destination_port_ranges: Optional[Sequence[str]] = None,
                 destinations: Optional[Sequence['outputs.AddressPrefixItemResponse']] = None,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 region: Optional[str] = None,
                 rule_collection_applies_to_groups: Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']] = None,
                 rule_collection_description: Optional[str] = None,
                 rule_collection_display_name: Optional[str] = None,
                 rule_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None,
                 source_port_ranges: Optional[Sequence[str]] = None,
                 sources: Optional[Sequence['outputs.AddressPrefixItemResponse']] = None):
        """
        Network security user rule.
        :param str direction: Indicates if the traffic matched against the rule in inbound or outbound.
        :param str kind: Whether the rule is custom or default.
               Expected value is 'Custom'.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the security configuration user rule resource.
        :param str commit_time: Deployment time string.
        :param str configuration_description: A description of the security user configuration.
        :param str configuration_display_name: A display name of the security user configuration.
        :param str description: A description for this rule.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param Sequence['AddressPrefixItemResponse'] destinations: The destination address prefixes. CIDR or destination IP ranges.
        :param str display_name: A friendly name for the rule.
        :param str id: Resource ID.
        :param str region: Deployment region.
        :param Sequence['NetworkManagerSecurityGroupItemResponse'] rule_collection_applies_to_groups: Groups for rule collection
        :param str rule_collection_description: A description of the rule collection.
        :param str rule_collection_display_name: A display name of the rule collection.
        :param Sequence['ConfigurationGroupResponse'] rule_groups: Effective configuration groups.
        :param Sequence[str] source_port_ranges: The source port ranges.
        :param Sequence['AddressPrefixItemResponse'] sources: The CIDR or source IP ranges.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "kind", 'Custom')
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if configuration_description is not None:
            pulumi.set(__self__, "configuration_description", configuration_description)
        if configuration_display_name is not None:
            pulumi.set(__self__, "configuration_display_name", configuration_display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rule_collection_applies_to_groups is not None:
            pulumi.set(__self__, "rule_collection_applies_to_groups", rule_collection_applies_to_groups)
        if rule_collection_description is not None:
            pulumi.set(__self__, "rule_collection_description", rule_collection_description)
        if rule_collection_display_name is not None:
            pulumi.set(__self__, "rule_collection_display_name", rule_collection_display_name)
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Indicates if the traffic matched against the rule in inbound or outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Whether the rule is custom or default.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the security configuration user rule resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[str]:
        """
        Deployment time string.
        """
        return pulumi.get(self, "commit_time")

    @property
    @pulumi.getter(name="configurationDescription")
    def configuration_description(self) -> Optional[str]:
        """
        A description of the security user configuration.
        """
        return pulumi.get(self, "configuration_description")

    @property
    @pulumi.getter(name="configurationDisplayName")
    def configuration_display_name(self) -> Optional[str]:
        """
        A display name of the security user configuration.
        """
        return pulumi.get(self, "configuration_display_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.AddressPrefixItemResponse']]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A friendly name for the rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Deployment region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleCollectionAppliesToGroups")
    def rule_collection_applies_to_groups(self) -> Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']]:
        """
        Groups for rule collection
        """
        return pulumi.get(self, "rule_collection_applies_to_groups")

    @property
    @pulumi.getter(name="ruleCollectionDescription")
    def rule_collection_description(self) -> Optional[str]:
        """
        A description of the rule collection.
        """
        return pulumi.get(self, "rule_collection_description")

    @property
    @pulumi.getter(name="ruleCollectionDisplayName")
    def rule_collection_display_name(self) -> Optional[str]:
        """
        A display name of the rule collection.
        """
        return pulumi.get(self, "rule_collection_display_name")

    @property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "rule_groups")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AddressPrefixItemResponse']]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class AddressPrefixItemResponse(dict):
    """
    Address prefix item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "addressPrefixType":
            suggest = "address_prefix_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddressPrefixItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddressPrefixItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddressPrefixItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: Optional[str] = None,
                 address_prefix_type: Optional[str] = None):
        """
        Address prefix item.
        :param str address_prefix: Address prefix.
        :param str address_prefix_type: Address prefix type.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefix_type is not None:
            pulumi.set(__self__, "address_prefix_type", address_prefix_type)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        Address prefix.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="addressPrefixType")
    def address_prefix_type(self) -> Optional[str]:
        """
        Address prefix type.
        """
        return pulumi.get(self, "address_prefix_type")


@pulumi.output_type
class ConfigurationGroupResponse(dict):
    """
    The network configuration group resource
    """
    def __init__(__self__, *,
                 provisioning_state: str,
                 conditional_membership: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 group_members: Optional[Sequence['outputs.GroupMembersItemResponse']] = None,
                 id: Optional[str] = None,
                 member_type: Optional[str] = None):
        """
        The network configuration group resource
        :param str provisioning_state: The provisioning state of the scope assignment resource.
        :param str conditional_membership: Network group conditional filter.
        :param str description: A description of the network group.
        :param str display_name: A friendly name for the network group.
        :param Sequence['GroupMembersItemResponse'] group_members: Group members of network group.
        :param str id: Resource ID.
        :param str member_type: Group member type.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if conditional_membership is not None:
            pulumi.set(__self__, "conditional_membership", conditional_membership)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if group_members is not None:
            pulumi.set(__self__, "group_members", group_members)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if member_type is not None:
            pulumi.set(__self__, "member_type", member_type)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the scope assignment resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="conditionalMembership")
    def conditional_membership(self) -> Optional[str]:
        """
        Network group conditional filter.
        """
        return pulumi.get(self, "conditional_membership")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the network group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A friendly name for the network group.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="groupMembers")
    def group_members(self) -> Optional[Sequence['outputs.GroupMembersItemResponse']]:
        """
        Group members of network group.
        """
        return pulumi.get(self, "group_members")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="memberType")
    def member_type(self) -> Optional[str]:
        """
        Group member type.
        """
        return pulumi.get(self, "member_type")


@pulumi.output_type
class ConnectivityGroupItemResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupConnectivity":
            suggest = "group_connectivity"
        elif key == "isGlobal":
            suggest = "is_global"
        elif key == "networkGroupId":
            suggest = "network_group_id"
        elif key == "useHubGateway":
            suggest = "use_hub_gateway"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectivityGroupItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectivityGroupItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectivityGroupItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_connectivity: Optional[str] = None,
                 is_global: Optional[str] = None,
                 network_group_id: Optional[str] = None,
                 use_hub_gateway: Optional[str] = None):
        """
        :param str group_connectivity: Group connectivity type.
        :param str is_global: Flag if global is supported.
        :param str network_group_id: Network group Id.
        :param str use_hub_gateway: Flag if need to use hub gateway.
        """
        if group_connectivity is not None:
            pulumi.set(__self__, "group_connectivity", group_connectivity)
        if is_global is not None:
            pulumi.set(__self__, "is_global", is_global)
        if network_group_id is not None:
            pulumi.set(__self__, "network_group_id", network_group_id)
        if use_hub_gateway is not None:
            pulumi.set(__self__, "use_hub_gateway", use_hub_gateway)

    @property
    @pulumi.getter(name="groupConnectivity")
    def group_connectivity(self) -> Optional[str]:
        """
        Group connectivity type.
        """
        return pulumi.get(self, "group_connectivity")

    @property
    @pulumi.getter(name="isGlobal")
    def is_global(self) -> Optional[str]:
        """
        Flag if global is supported.
        """
        return pulumi.get(self, "is_global")

    @property
    @pulumi.getter(name="networkGroupId")
    def network_group_id(self) -> Optional[str]:
        """
        Network group Id.
        """
        return pulumi.get(self, "network_group_id")

    @property
    @pulumi.getter(name="useHubGateway")
    def use_hub_gateway(self) -> Optional[str]:
        """
        Flag if need to use hub gateway.
        """
        return pulumi.get(self, "use_hub_gateway")


@pulumi.output_type
class EffectiveConnectivityConfigurationResponse(dict):
    """
    The network manager effective connectivity configuration
    """
    def __init__(__self__, *,
                 connectivity_topology: str,
                 provisioning_state: str,
                 applies_to_groups: Optional[Sequence['outputs.ConnectivityGroupItemResponse']] = None,
                 configuration_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None,
                 delete_existing_peering: Optional[str] = None,
                 description: Optional[str] = None,
                 display_name: Optional[str] = None,
                 hub_id: Optional[str] = None,
                 id: Optional[str] = None,
                 is_global: Optional[str] = None):
        """
        The network manager effective connectivity configuration
        :param str connectivity_topology: Connectivity topology type.
        :param str provisioning_state: The provisioning state of the connectivity configuration resource.
        :param Sequence['ConnectivityGroupItemResponse'] applies_to_groups: Groups for configuration
        :param Sequence['ConfigurationGroupResponse'] configuration_groups: Effective configuration groups.
        :param str delete_existing_peering: Flag if need to remove current existing peerings.
        :param str description: A description of the connectivity configuration.
        :param str display_name: A friendly name for the resource.
        :param str hub_id: The hub vnet Id.
        :param str id: Resource ID.
        :param str is_global: Flag if global mesh is supported.
        """
        pulumi.set(__self__, "connectivity_topology", connectivity_topology)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if applies_to_groups is not None:
            pulumi.set(__self__, "applies_to_groups", applies_to_groups)
        if configuration_groups is not None:
            pulumi.set(__self__, "configuration_groups", configuration_groups)
        if delete_existing_peering is not None:
            pulumi.set(__self__, "delete_existing_peering", delete_existing_peering)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if hub_id is not None:
            pulumi.set(__self__, "hub_id", hub_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_global is not None:
            pulumi.set(__self__, "is_global", is_global)

    @property
    @pulumi.getter(name="connectivityTopology")
    def connectivity_topology(self) -> str:
        """
        Connectivity topology type.
        """
        return pulumi.get(self, "connectivity_topology")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the connectivity configuration resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="appliesToGroups")
    def applies_to_groups(self) -> Optional[Sequence['outputs.ConnectivityGroupItemResponse']]:
        """
        Groups for configuration
        """
        return pulumi.get(self, "applies_to_groups")

    @property
    @pulumi.getter(name="configurationGroups")
    def configuration_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "configuration_groups")

    @property
    @pulumi.getter(name="deleteExistingPeering")
    def delete_existing_peering(self) -> Optional[str]:
        """
        Flag if need to remove current existing peerings.
        """
        return pulumi.get(self, "delete_existing_peering")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the connectivity configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A friendly name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hubId")
    def hub_id(self) -> Optional[str]:
        """
        The hub vnet Id.
        """
        return pulumi.get(self, "hub_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isGlobal")
    def is_global(self) -> Optional[str]:
        """
        Flag if global mesh is supported.
        """
        return pulumi.get(self, "is_global")


@pulumi.output_type
class EffectiveDefaultSecurityAdminRuleResponse(dict):
    """
    Network default admin rule.
    """
    def __init__(__self__, *,
                 access: str,
                 description: str,
                 destination_port_ranges: Sequence[str],
                 destinations: Sequence['outputs.AddressPrefixItemResponse'],
                 direction: str,
                 display_name: str,
                 kind: str,
                 priority: int,
                 protocol: str,
                 provisioning_state: str,
                 source_port_ranges: Sequence[str],
                 sources: Sequence['outputs.AddressPrefixItemResponse'],
                 configuration_description: Optional[str] = None,
                 configuration_display_name: Optional[str] = None,
                 flag: Optional[str] = None,
                 id: Optional[str] = None,
                 rule_collection_applies_to_groups: Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']] = None,
                 rule_collection_description: Optional[str] = None,
                 rule_collection_display_name: Optional[str] = None,
                 rule_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None):
        """
        Network default admin rule.
        :param str access: Indicates the access allowed for this particular rule
        :param str description: A description for this rule. Restricted to 140 chars.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param Sequence['AddressPrefixItemResponse'] destinations: The destination address prefixes. CIDR or destination IP ranges.
        :param str direction: Indicates if the traffic matched against the rule in inbound or outbound.
        :param str display_name: A friendly name for the rule.
        :param str kind: Whether the rule is custom or default.
               Expected value is 'Default'.
        :param int priority: The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the resource.
        :param Sequence[str] source_port_ranges: The source port ranges.
        :param Sequence['AddressPrefixItemResponse'] sources: The CIDR or source IP ranges.
        :param str configuration_description: A description of the security admin configuration.
        :param str configuration_display_name: A display name of the security admin configuration.
        :param str flag: Default rule flag.
        :param str id: Resource ID.
        :param Sequence['NetworkManagerSecurityGroupItemResponse'] rule_collection_applies_to_groups: Groups for rule collection
        :param str rule_collection_description: A description of the rule collection.
        :param str rule_collection_display_name: A display name of the rule collection.
        :param Sequence['ConfigurationGroupResponse'] rule_groups: Effective configuration groups.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "kind", 'Default')
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        pulumi.set(__self__, "sources", sources)
        if configuration_description is not None:
            pulumi.set(__self__, "configuration_description", configuration_description)
        if configuration_display_name is not None:
            pulumi.set(__self__, "configuration_display_name", configuration_display_name)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if rule_collection_applies_to_groups is not None:
            pulumi.set(__self__, "rule_collection_applies_to_groups", rule_collection_applies_to_groups)
        if rule_collection_description is not None:
            pulumi.set(__self__, "rule_collection_description", rule_collection_description)
        if rule_collection_display_name is not None:
            pulumi.set(__self__, "rule_collection_display_name", rule_collection_display_name)
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        Indicates the access allowed for this particular rule
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Sequence[str]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.AddressPrefixItemResponse']:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Indicates if the traffic matched against the rule in inbound or outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A friendly name for the rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Whether the rule is custom or default.
        Expected value is 'Default'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Sequence[str]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.AddressPrefixItemResponse']:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="configurationDescription")
    def configuration_description(self) -> Optional[str]:
        """
        A description of the security admin configuration.
        """
        return pulumi.get(self, "configuration_description")

    @property
    @pulumi.getter(name="configurationDisplayName")
    def configuration_display_name(self) -> Optional[str]:
        """
        A display name of the security admin configuration.
        """
        return pulumi.get(self, "configuration_display_name")

    @property
    @pulumi.getter
    def flag(self) -> Optional[str]:
        """
        Default rule flag.
        """
        return pulumi.get(self, "flag")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ruleCollectionAppliesToGroups")
    def rule_collection_applies_to_groups(self) -> Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']]:
        """
        Groups for rule collection
        """
        return pulumi.get(self, "rule_collection_applies_to_groups")

    @property
    @pulumi.getter(name="ruleCollectionDescription")
    def rule_collection_description(self) -> Optional[str]:
        """
        A description of the rule collection.
        """
        return pulumi.get(self, "rule_collection_description")

    @property
    @pulumi.getter(name="ruleCollectionDisplayName")
    def rule_collection_display_name(self) -> Optional[str]:
        """
        A display name of the rule collection.
        """
        return pulumi.get(self, "rule_collection_display_name")

    @property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "rule_groups")


@pulumi.output_type
class EffectiveSecurityAdminRuleResponse(dict):
    """
    Network admin rule.
    """
    def __init__(__self__, *,
                 access: str,
                 direction: str,
                 kind: str,
                 protocol: str,
                 provisioning_state: str,
                 configuration_description: Optional[str] = None,
                 configuration_display_name: Optional[str] = None,
                 description: Optional[str] = None,
                 destination_port_ranges: Optional[Sequence[str]] = None,
                 destinations: Optional[Sequence['outputs.AddressPrefixItemResponse']] = None,
                 display_name: Optional[str] = None,
                 id: Optional[str] = None,
                 priority: Optional[int] = None,
                 rule_collection_applies_to_groups: Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']] = None,
                 rule_collection_description: Optional[str] = None,
                 rule_collection_display_name: Optional[str] = None,
                 rule_groups: Optional[Sequence['outputs.ConfigurationGroupResponse']] = None,
                 source_port_ranges: Optional[Sequence[str]] = None,
                 sources: Optional[Sequence['outputs.AddressPrefixItemResponse']] = None):
        """
        Network admin rule.
        :param str access: Indicates the access allowed for this particular rule
        :param str direction: Indicates if the traffic matched against the rule in inbound or outbound.
        :param str kind: Whether the rule is custom or default.
               Expected value is 'Custom'.
        :param str protocol: Network protocol this rule applies to.
        :param str provisioning_state: The provisioning state of the resource.
        :param str configuration_description: A description of the security admin configuration.
        :param str configuration_display_name: A display name of the security admin configuration.
        :param str description: A description for this rule. Restricted to 140 chars.
        :param Sequence[str] destination_port_ranges: The destination port ranges.
        :param Sequence['AddressPrefixItemResponse'] destinations: The destination address prefixes. CIDR or destination IP ranges.
        :param str display_name: A friendly name for the rule.
        :param str id: Resource ID.
        :param int priority: The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        :param Sequence['NetworkManagerSecurityGroupItemResponse'] rule_collection_applies_to_groups: Groups for rule collection
        :param str rule_collection_description: A description of the rule collection.
        :param str rule_collection_display_name: A display name of the rule collection.
        :param Sequence['ConfigurationGroupResponse'] rule_groups: Effective configuration groups.
        :param Sequence[str] source_port_ranges: The source port ranges.
        :param Sequence['AddressPrefixItemResponse'] sources: The CIDR or source IP ranges.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "kind", 'Custom')
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if configuration_description is not None:
            pulumi.set(__self__, "configuration_description", configuration_description)
        if configuration_display_name is not None:
            pulumi.set(__self__, "configuration_display_name", configuration_display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_port_ranges is not None:
            pulumi.set(__self__, "destination_port_ranges", destination_port_ranges)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rule_collection_applies_to_groups is not None:
            pulumi.set(__self__, "rule_collection_applies_to_groups", rule_collection_applies_to_groups)
        if rule_collection_description is not None:
            pulumi.set(__self__, "rule_collection_description", rule_collection_description)
        if rule_collection_display_name is not None:
            pulumi.set(__self__, "rule_collection_display_name", rule_collection_display_name)
        if rule_groups is not None:
            pulumi.set(__self__, "rule_groups", rule_groups)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)

    @property
    @pulumi.getter
    def access(self) -> str:
        """
        Indicates the access allowed for this particular rule
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Indicates if the traffic matched against the rule in inbound or outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Whether the rule is custom or default.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Network protocol this rule applies to.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="configurationDescription")
    def configuration_description(self) -> Optional[str]:
        """
        A description of the security admin configuration.
        """
        return pulumi.get(self, "configuration_description")

    @property
    @pulumi.getter(name="configurationDisplayName")
    def configuration_display_name(self) -> Optional[str]:
        """
        A display name of the security admin configuration.
        """
        return pulumi.get(self, "configuration_display_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for this rule. Restricted to 140 chars.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationPortRanges")
    def destination_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The destination port ranges.
        """
        return pulumi.get(self, "destination_port_ranges")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.AddressPrefixItemResponse']]:
        """
        The destination address prefixes. CIDR or destination IP ranges.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A friendly name for the rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority of the rule. The value can be between 1 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="ruleCollectionAppliesToGroups")
    def rule_collection_applies_to_groups(self) -> Optional[Sequence['outputs.NetworkManagerSecurityGroupItemResponse']]:
        """
        Groups for rule collection
        """
        return pulumi.get(self, "rule_collection_applies_to_groups")

    @property
    @pulumi.getter(name="ruleCollectionDescription")
    def rule_collection_description(self) -> Optional[str]:
        """
        A description of the rule collection.
        """
        return pulumi.get(self, "rule_collection_description")

    @property
    @pulumi.getter(name="ruleCollectionDisplayName")
    def rule_collection_display_name(self) -> Optional[str]:
        """
        A display name of the rule collection.
        """
        return pulumi.get(self, "rule_collection_display_name")

    @property
    @pulumi.getter(name="ruleGroups")
    def rule_groups(self) -> Optional[Sequence['outputs.ConfigurationGroupResponse']]:
        """
        Effective configuration groups.
        """
        return pulumi.get(self, "rule_groups")

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[Sequence[str]]:
        """
        The source port ranges.
        """
        return pulumi.get(self, "source_port_ranges")

    @property
    @pulumi.getter
    def sources(self) -> Optional[Sequence['outputs.AddressPrefixItemResponse']]:
        """
        The CIDR or source IP ranges.
        """
        return pulumi.get(self, "sources")


@pulumi.output_type
class EffectiveVirtualNetworkResponse(dict):
    """
    Effective Virtual Network
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 location: Optional[str] = None,
                 membership_type: Optional[str] = None):
        """
        Effective Virtual Network
        :param str id: Effective vnet Id.
        :param str location: Location of vnet.
        :param str membership_type: Membership Type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if membership_type is not None:
            pulumi.set(__self__, "membership_type", membership_type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Effective vnet Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Location of vnet.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[str]:
        """
        Membership Type.
        """
        return pulumi.get(self, "membership_type")


@pulumi.output_type
class GroupMembersItemResponse(dict):
    """
    GroupMembers Item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "vnetId":
            suggest = "vnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupMembersItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupMembersItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupMembersItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: Optional[str] = None,
                 vnet_id: Optional[str] = None):
        """
        GroupMembers Item.
        :param str subnet_id: Subnet Id.
        :param str vnet_id: Vnet Id.
        """
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vnet_id is not None:
            pulumi.set(__self__, "vnet_id", vnet_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Subnet Id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vnetId")
    def vnet_id(self) -> Optional[str]:
        """
        Vnet Id.
        """
        return pulumi.get(self, "vnet_id")


@pulumi.output_type
class NetworkManagerDeploymentStatusResponse(dict):
    """
    Network Manager Deployment Status.
    """
    def __init__(__self__, *,
                 commit_time: Optional[str] = None,
                 configuration_ids: Optional[Sequence[str]] = None,
                 deployment_status: Optional[str] = None,
                 deployment_type: Optional[str] = None,
                 error_message: Optional[str] = None,
                 region: Optional[str] = None):
        """
        Network Manager Deployment Status.
        :param str commit_time: Commit Time.
        :param Sequence[str] configuration_ids: List of configuration ids.
        :param str deployment_status: Deployment Status.
        :param str deployment_type: Configuration Deployment Type.
        :param str error_message: Error Message.
        :param str region: Region Name.
        """
        if commit_time is not None:
            pulumi.set(__self__, "commit_time", commit_time)
        if configuration_ids is not None:
            pulumi.set(__self__, "configuration_ids", configuration_ids)
        if deployment_status is not None:
            pulumi.set(__self__, "deployment_status", deployment_status)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="commitTime")
    def commit_time(self) -> Optional[str]:
        """
        Commit Time.
        """
        return pulumi.get(self, "commit_time")

    @property
    @pulumi.getter(name="configurationIds")
    def configuration_ids(self) -> Optional[Sequence[str]]:
        """
        List of configuration ids.
        """
        return pulumi.get(self, "configuration_ids")

    @property
    @pulumi.getter(name="deploymentStatus")
    def deployment_status(self) -> Optional[str]:
        """
        Deployment Status.
        """
        return pulumi.get(self, "deployment_status")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        """
        Configuration Deployment Type.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Error Message.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region Name.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class NetworkManagerPropertiesResponseNetworkManagerScopes(dict):
    """
    Scope of Network Manager.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managementGroups":
            suggest = "management_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkManagerPropertiesResponseNetworkManagerScopes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkManagerPropertiesResponseNetworkManagerScopes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkManagerPropertiesResponseNetworkManagerScopes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 management_groups: Optional[Sequence[str]] = None,
                 subscriptions: Optional[Sequence[str]] = None):
        """
        Scope of Network Manager.
        :param Sequence[str] management_groups: List of management groups.
        :param Sequence[str] subscriptions: List of subscriptions.
        """
        if management_groups is not None:
            pulumi.set(__self__, "management_groups", management_groups)
        if subscriptions is not None:
            pulumi.set(__self__, "subscriptions", subscriptions)

    @property
    @pulumi.getter(name="managementGroups")
    def management_groups(self) -> Optional[Sequence[str]]:
        """
        List of management groups.
        """
        return pulumi.get(self, "management_groups")

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[Sequence[str]]:
        """
        List of subscriptions.
        """
        return pulumi.get(self, "subscriptions")


@pulumi.output_type
class NetworkManagerSecurityGroupItemResponse(dict):
    """
    Network manager security group item.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkGroupId":
            suggest = "network_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkManagerSecurityGroupItemResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkManagerSecurityGroupItemResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkManagerSecurityGroupItemResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_group_id: Optional[str] = None):
        """
        Network manager security group item.
        :param str network_group_id: Network manager group Id.
        """
        if network_group_id is not None:
            pulumi.set(__self__, "network_group_id", network_group_id)

    @property
    @pulumi.getter(name="networkGroupId")
    def network_group_id(self) -> Optional[str]:
        """
        Network manager group Id.
        """
        return pulumi.get(self, "network_group_id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The type of identity that last modified the resource.
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


