# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AgentPoolUpgradeSettingsArgs',
    'ContainerServiceLinuxProfileArgs',
    'ContainerServiceNetworkProfileArgs',
    'ContainerServiceSshConfigurationArgs',
    'ContainerServiceSshPublicKeyArgs',
    'KubeletConfigArgs',
    'LinuxOSConfigArgs',
    'ManagedClusterAADProfileArgs',
    'ManagedClusterAPIServerAccessProfileArgs',
    'ManagedClusterAddonProfileArgs',
    'ManagedClusterAgentPoolProfileArgs',
    'ManagedClusterAutoUpgradeProfileArgs',
    'ManagedClusterIdentityArgs',
    'ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs',
    'ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs',
    'ManagedClusterLoadBalancerProfileOutboundIPsArgs',
    'ManagedClusterLoadBalancerProfileArgs',
    'ManagedClusterPodIdentityExceptionArgs',
    'ManagedClusterPodIdentityProfileArgs',
    'ManagedClusterPodIdentityArgs',
    'ManagedClusterPropertiesAutoScalerProfileArgs',
    'ManagedClusterPropertiesIdentityProfileArgs',
    'ManagedClusterSKUArgs',
    'ManagedClusterServicePrincipalProfileArgs',
    'ManagedClusterWindowsProfileArgs',
    'PrivateEndpointArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ResourceReferenceArgs',
    'SysctlConfigArgs',
    'TimeInWeekArgs',
    'TimeSpanArgs',
    'UserAssignedIdentityArgs',
]

@pulumi.input_type
class AgentPoolUpgradeSettingsArgs:
    def __init__(__self__, *,
                 max_surge: Optional[pulumi.Input[str]] = None):
        """
        Settings for upgrading an agentpool
        :param pulumi.Input[str] max_surge: Count or percentage of additional nodes to be added during upgrade. If empty uses AKS default
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[pulumi.Input[str]]:
        """
        Count or percentage of additional nodes to be added during upgrade. If empty uses AKS default
        """
        return pulumi.get(self, "max_surge")

    @max_surge.setter
    def max_surge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_surge", value)


@pulumi.input_type
class ContainerServiceLinuxProfileArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[str],
                 ssh: pulumi.Input['ContainerServiceSshConfigurationArgs']):
        """
        Profile for Linux VMs in the container service cluster.
        :param pulumi.Input[str] admin_username: The administrator username to use for Linux VMs.
        :param pulumi.Input['ContainerServiceSshConfigurationArgs'] ssh: SSH configuration for Linux-based VMs running on Azure.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[str]:
        """
        The administrator username to use for Linux VMs.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter
    def ssh(self) -> pulumi.Input['ContainerServiceSshConfigurationArgs']:
        """
        SSH configuration for Linux-based VMs running on Azure.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: pulumi.Input['ContainerServiceSshConfigurationArgs']):
        pulumi.set(self, "ssh", value)


@pulumi.input_type
class ContainerServiceNetworkProfileArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 load_balancer_profile: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileArgs']] = None,
                 load_balancer_sku: Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]] = None,
                 network_mode: Optional[pulumi.Input[Union[str, 'NetworkMode']]] = None,
                 network_plugin: Optional[pulumi.Input[Union[str, 'NetworkPlugin']]] = None,
                 network_policy: Optional[pulumi.Input[Union[str, 'NetworkPolicy']]] = None,
                 outbound_type: Optional[pulumi.Input[Union[str, 'OutboundType']]] = None,
                 pod_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None):
        """
        Profile of network configuration.
        :param pulumi.Input[str] dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input[str] docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileArgs'] load_balancer_profile: Profile of the cluster load balancer.
        :param pulumi.Input[Union[str, 'LoadBalancerSku']] load_balancer_sku: The load balancer sku for the managed cluster.
        :param pulumi.Input[Union[str, 'NetworkMode']] network_mode: Network mode used for building Kubernetes network.
        :param pulumi.Input[Union[str, 'NetworkPlugin']] network_plugin: Network plugin used for building Kubernetes network.
        :param pulumi.Input[Union[str, 'NetworkPolicy']] network_policy: Network policy used for building Kubernetes network.
        :param pulumi.Input[Union[str, 'OutboundType']] outbound_type: The outbound (egress) routing method.
        :param pulumi.Input[str] pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        :param pulumi.Input[str] service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        if dns_service_ip is None:
            dns_service_ip = '10.0.0.10'
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is None:
            docker_bridge_cidr = '172.17.0.1/16'
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if load_balancer_profile is not None:
            pulumi.set(__self__, "load_balancer_profile", load_balancer_profile)
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if network_plugin is None:
            network_plugin = 'kubenet'
        if network_plugin is not None:
            pulumi.set(__self__, "network_plugin", network_plugin)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if outbound_type is None:
            outbound_type = 'loadBalancer'
        if outbound_type is not None:
            pulumi.set(__self__, "outbound_type", outbound_type)
        if pod_cidr is None:
            pod_cidr = '10.244.0.0/16'
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if service_cidr is None:
            service_cidr = '10.0.0.0/16'
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="loadBalancerProfile")
    def load_balancer_profile(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileArgs']]:
        """
        Profile of the cluster load balancer.
        """
        return pulumi.get(self, "load_balancer_profile")

    @load_balancer_profile.setter
    def load_balancer_profile(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileArgs']]):
        pulumi.set(self, "load_balancer_profile", value)

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]]:
        """
        The load balancer sku for the managed cluster.
        """
        return pulumi.get(self, "load_balancer_sku")

    @load_balancer_sku.setter
    def load_balancer_sku(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerSku']]]):
        pulumi.set(self, "load_balancer_sku", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[Union[str, 'NetworkMode']]]:
        """
        Network mode used for building Kubernetes network.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[Union[str, 'NetworkMode']]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="networkPlugin")
    def network_plugin(self) -> Optional[pulumi.Input[Union[str, 'NetworkPlugin']]]:
        """
        Network plugin used for building Kubernetes network.
        """
        return pulumi.get(self, "network_plugin")

    @network_plugin.setter
    def network_plugin(self, value: Optional[pulumi.Input[Union[str, 'NetworkPlugin']]]):
        pulumi.set(self, "network_plugin", value)

    @property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[Union[str, 'NetworkPolicy']]]:
        """
        Network policy used for building Kubernetes network.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[Union[str, 'NetworkPolicy']]]):
        pulumi.set(self, "network_policy", value)

    @property
    @pulumi.getter(name="outboundType")
    def outbound_type(self) -> Optional[pulumi.Input[Union[str, 'OutboundType']]]:
        """
        The outbound (egress) routing method.
        """
        return pulumi.get(self, "outbound_type")

    @outbound_type.setter
    def outbound_type(self, value: Optional[pulumi.Input[Union[str, 'OutboundType']]]):
        pulumi.set(self, "outbound_type", value)

    @property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_cidr", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)


@pulumi.input_type
class ContainerServiceSshConfigurationArgs:
    def __init__(__self__, *,
                 public_keys: pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]]):
        """
        SSH configuration for Linux-based VMs running on Azure.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]] public_keys: The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
        """
        pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]]:
        """
        The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: pulumi.Input[Sequence[pulumi.Input['ContainerServiceSshPublicKeyArgs']]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class ContainerServiceSshPublicKeyArgs:
    def __init__(__self__, *,
                 key_data: pulumi.Input[str]):
        """
        Contains information about SSH certificate public key data.
        :param pulumi.Input[str] key_data: Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
        """
        pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> pulumi.Input[str]:
        """
        Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
        """
        return pulumi.get(self, "key_data")

    @key_data.setter
    def key_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_data", value)


@pulumi.input_type
class KubeletConfigArgs:
    def __init__(__self__, *,
                 allowed_unsafe_sysctls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_log_max_files: Optional[pulumi.Input[int]] = None,
                 container_log_max_size_mb: Optional[pulumi.Input[int]] = None,
                 cpu_cfs_quota: Optional[pulumi.Input[bool]] = None,
                 cpu_cfs_quota_period: Optional[pulumi.Input[str]] = None,
                 cpu_manager_policy: Optional[pulumi.Input[str]] = None,
                 fail_swap_on: Optional[pulumi.Input[bool]] = None,
                 image_gc_high_threshold: Optional[pulumi.Input[int]] = None,
                 image_gc_low_threshold: Optional[pulumi.Input[int]] = None,
                 pod_max_pids: Optional[pulumi.Input[int]] = None,
                 topology_manager_policy: Optional[pulumi.Input[str]] = None):
        """
        Kubelet configurations of agent nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_unsafe_sysctls: Allowlist of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
        :param pulumi.Input[int] container_log_max_files: The maximum number of container log files that can be present for a container. The number must be ≥ 2.
        :param pulumi.Input[int] container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before it is rotated.
        :param pulumi.Input[bool] cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU limits.
        :param pulumi.Input[str] cpu_cfs_quota_period: Sets CPU CFS quota period value.
        :param pulumi.Input[str] cpu_manager_policy: CPU Manager policy to use.
        :param pulumi.Input[bool] fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled on the node.
        :param pulumi.Input[int] image_gc_high_threshold: The percent of disk usage after which image garbage collection is always run.
        :param pulumi.Input[int] image_gc_low_threshold: The percent of disk usage before which image garbage collection is never run.
        :param pulumi.Input[int] pod_max_pids: The maximum number of processes per pod.
        :param pulumi.Input[str] topology_manager_policy: Topology Manager policy to use.
        """
        if allowed_unsafe_sysctls is not None:
            pulumi.set(__self__, "allowed_unsafe_sysctls", allowed_unsafe_sysctls)
        if container_log_max_files is not None:
            pulumi.set(__self__, "container_log_max_files", container_log_max_files)
        if container_log_max_size_mb is not None:
            pulumi.set(__self__, "container_log_max_size_mb", container_log_max_size_mb)
        if cpu_cfs_quota is not None:
            pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        if cpu_cfs_quota_period is not None:
            pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        if cpu_manager_policy is not None:
            pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        if fail_swap_on is not None:
            pulumi.set(__self__, "fail_swap_on", fail_swap_on)
        if image_gc_high_threshold is not None:
            pulumi.set(__self__, "image_gc_high_threshold", image_gc_high_threshold)
        if image_gc_low_threshold is not None:
            pulumi.set(__self__, "image_gc_low_threshold", image_gc_low_threshold)
        if pod_max_pids is not None:
            pulumi.set(__self__, "pod_max_pids", pod_max_pids)
        if topology_manager_policy is not None:
            pulumi.set(__self__, "topology_manager_policy", topology_manager_policy)

    @property
    @pulumi.getter(name="allowedUnsafeSysctls")
    def allowed_unsafe_sysctls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allowlist of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
        """
        return pulumi.get(self, "allowed_unsafe_sysctls")

    @allowed_unsafe_sysctls.setter
    def allowed_unsafe_sysctls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_unsafe_sysctls", value)

    @property
    @pulumi.getter(name="containerLogMaxFiles")
    def container_log_max_files(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of container log files that can be present for a container. The number must be ≥ 2.
        """
        return pulumi.get(self, "container_log_max_files")

    @container_log_max_files.setter
    def container_log_max_files(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_log_max_files", value)

    @property
    @pulumi.getter(name="containerLogMaxSizeMB")
    def container_log_max_size_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size (e.g. 10Mi) of container log file before it is rotated.
        """
        return pulumi.get(self, "container_log_max_size_mb")

    @container_log_max_size_mb.setter
    def container_log_max_size_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_log_max_size_mb", value)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CPU CFS quota enforcement for containers that specify CPU limits.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @cpu_cfs_quota.setter
    def cpu_cfs_quota(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cpu_cfs_quota", value)

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> Optional[pulumi.Input[str]]:
        """
        Sets CPU CFS quota period value.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @cpu_cfs_quota_period.setter
    def cpu_cfs_quota_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_cfs_quota_period", value)

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> Optional[pulumi.Input[str]]:
        """
        CPU Manager policy to use.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @cpu_manager_policy.setter
    def cpu_manager_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_manager_policy", value)

    @property
    @pulumi.getter(name="failSwapOn")
    def fail_swap_on(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true it will make the Kubelet fail to start if swap is enabled on the node.
        """
        return pulumi.get(self, "fail_swap_on")

    @fail_swap_on.setter
    def fail_swap_on(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fail_swap_on", value)

    @property
    @pulumi.getter(name="imageGcHighThreshold")
    def image_gc_high_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The percent of disk usage after which image garbage collection is always run.
        """
        return pulumi.get(self, "image_gc_high_threshold")

    @image_gc_high_threshold.setter
    def image_gc_high_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_gc_high_threshold", value)

    @property
    @pulumi.getter(name="imageGcLowThreshold")
    def image_gc_low_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The percent of disk usage before which image garbage collection is never run.
        """
        return pulumi.get(self, "image_gc_low_threshold")

    @image_gc_low_threshold.setter
    def image_gc_low_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_gc_low_threshold", value)

    @property
    @pulumi.getter(name="podMaxPids")
    def pod_max_pids(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of processes per pod.
        """
        return pulumi.get(self, "pod_max_pids")

    @pod_max_pids.setter
    def pod_max_pids(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pod_max_pids", value)

    @property
    @pulumi.getter(name="topologyManagerPolicy")
    def topology_manager_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Topology Manager policy to use.
        """
        return pulumi.get(self, "topology_manager_policy")

    @topology_manager_policy.setter
    def topology_manager_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topology_manager_policy", value)


@pulumi.input_type
class LinuxOSConfigArgs:
    def __init__(__self__, *,
                 swap_file_size_mb: Optional[pulumi.Input[int]] = None,
                 sysctls: Optional[pulumi.Input['SysctlConfigArgs']] = None,
                 transparent_huge_page_defrag: Optional[pulumi.Input[str]] = None,
                 transparent_huge_page_enabled: Optional[pulumi.Input[str]] = None):
        """
        OS configurations of Linux agent nodes.
        :param pulumi.Input[int] swap_file_size_mb: SwapFileSizeMB specifies size in MB of a swap file will be created on each node.
        :param pulumi.Input['SysctlConfigArgs'] sysctls: Sysctl settings for Linux agent nodes.
        :param pulumi.Input[str] transparent_huge_page_defrag: Transparent Huge Page defrag configuration.
        :param pulumi.Input[str] transparent_huge_page_enabled: Transparent Huge Page enabled configuration.
        """
        if swap_file_size_mb is not None:
            pulumi.set(__self__, "swap_file_size_mb", swap_file_size_mb)
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)
        if transparent_huge_page_defrag is not None:
            pulumi.set(__self__, "transparent_huge_page_defrag", transparent_huge_page_defrag)
        if transparent_huge_page_enabled is not None:
            pulumi.set(__self__, "transparent_huge_page_enabled", transparent_huge_page_enabled)

    @property
    @pulumi.getter(name="swapFileSizeMB")
    def swap_file_size_mb(self) -> Optional[pulumi.Input[int]]:
        """
        SwapFileSizeMB specifies size in MB of a swap file will be created on each node.
        """
        return pulumi.get(self, "swap_file_size_mb")

    @swap_file_size_mb.setter
    def swap_file_size_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "swap_file_size_mb", value)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input['SysctlConfigArgs']]:
        """
        Sysctl settings for Linux agent nodes.
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input['SysctlConfigArgs']]):
        pulumi.set(self, "sysctls", value)

    @property
    @pulumi.getter(name="transparentHugePageDefrag")
    def transparent_huge_page_defrag(self) -> Optional[pulumi.Input[str]]:
        """
        Transparent Huge Page defrag configuration.
        """
        return pulumi.get(self, "transparent_huge_page_defrag")

    @transparent_huge_page_defrag.setter
    def transparent_huge_page_defrag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transparent_huge_page_defrag", value)

    @property
    @pulumi.getter(name="transparentHugePageEnabled")
    def transparent_huge_page_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        Transparent Huge Page enabled configuration.
        """
        return pulumi.get(self, "transparent_huge_page_enabled")

    @transparent_huge_page_enabled.setter
    def transparent_huge_page_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transparent_huge_page_enabled", value)


@pulumi.input_type
class ManagedClusterAADProfileArgs:
    def __init__(__self__, *,
                 admin_group_object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_app_id: Optional[pulumi.Input[str]] = None,
                 enable_azure_rbac: Optional[pulumi.Input[bool]] = None,
                 managed: Optional[pulumi.Input[bool]] = None,
                 server_app_id: Optional[pulumi.Input[str]] = None,
                 server_app_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        AADProfile specifies attributes for Azure Active Directory integration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] admin_group_object_ids: AAD group object IDs that will have admin role of the cluster.
        :param pulumi.Input[str] client_app_id: The client AAD application ID.
        :param pulumi.Input[bool] enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
        :param pulumi.Input[bool] managed: Whether to enable managed AAD.
        :param pulumi.Input[str] server_app_id: The server AAD application ID.
        :param pulumi.Input[str] server_app_secret: The server AAD application secret.
        :param pulumi.Input[str] tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
        """
        if admin_group_object_ids is not None:
            pulumi.set(__self__, "admin_group_object_ids", admin_group_object_ids)
        if client_app_id is not None:
            pulumi.set(__self__, "client_app_id", client_app_id)
        if enable_azure_rbac is not None:
            pulumi.set(__self__, "enable_azure_rbac", enable_azure_rbac)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if server_app_id is not None:
            pulumi.set(__self__, "server_app_id", server_app_id)
        if server_app_secret is not None:
            pulumi.set(__self__, "server_app_secret", server_app_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="adminGroupObjectIDs")
    def admin_group_object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AAD group object IDs that will have admin role of the cluster.
        """
        return pulumi.get(self, "admin_group_object_ids")

    @admin_group_object_ids.setter
    def admin_group_object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "admin_group_object_ids", value)

    @property
    @pulumi.getter(name="clientAppID")
    def client_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client AAD application ID.
        """
        return pulumi.get(self, "client_app_id")

    @client_app_id.setter
    def client_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_app_id", value)

    @property
    @pulumi.getter(name="enableAzureRBAC")
    def enable_azure_rbac(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Azure RBAC for Kubernetes authorization.
        """
        return pulumi.get(self, "enable_azure_rbac")

    @enable_azure_rbac.setter
    def enable_azure_rbac(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_azure_rbac", value)

    @property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable managed AAD.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "managed", value)

    @property
    @pulumi.getter(name="serverAppID")
    def server_app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The server AAD application ID.
        """
        return pulumi.get(self, "server_app_id")

    @server_app_id.setter
    def server_app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_app_id", value)

    @property
    @pulumi.getter(name="serverAppSecret")
    def server_app_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The server AAD application secret.
        """
        return pulumi.get(self, "server_app_secret")

    @server_app_secret.setter
    def server_app_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_app_secret", value)

    @property
    @pulumi.getter(name="tenantID")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ManagedClusterAPIServerAccessProfileArgs:
    def __init__(__self__, *,
                 authorized_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enable_private_cluster: Optional[pulumi.Input[bool]] = None,
                 private_dns_zone: Optional[pulumi.Input[str]] = None):
        """
        Access profile for managed cluster API server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
        :param pulumi.Input[bool] enable_private_cluster: Whether to create the cluster as a private cluster or not.
        :param pulumi.Input[str] private_dns_zone: Private dns zone mode for private cluster. 
        """
        if authorized_ip_ranges is not None:
            pulumi.set(__self__, "authorized_ip_ranges", authorized_ip_ranges)
        if enable_private_cluster is not None:
            pulumi.set(__self__, "enable_private_cluster", enable_private_cluster)
        if private_dns_zone is not None:
            pulumi.set(__self__, "private_dns_zone", private_dns_zone)

    @property
    @pulumi.getter(name="authorizedIPRanges")
    def authorized_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Authorized IP Ranges to kubernetes API server.
        """
        return pulumi.get(self, "authorized_ip_ranges")

    @authorized_ip_ranges.setter
    def authorized_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_ip_ranges", value)

    @property
    @pulumi.getter(name="enablePrivateCluster")
    def enable_private_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create the cluster as a private cluster or not.
        """
        return pulumi.get(self, "enable_private_cluster")

    @enable_private_cluster.setter
    def enable_private_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_cluster", value)

    @property
    @pulumi.getter(name="privateDNSZone")
    def private_dns_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Private dns zone mode for private cluster. 
        """
        return pulumi.get(self, "private_dns_zone")

    @private_dns_zone.setter
    def private_dns_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_dns_zone", value)


@pulumi.input_type
class ManagedClusterAddonProfileArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A Kubernetes add-on profile for a managed cluster.
        :param pulumi.Input[bool] enabled: Whether the add-on is enabled or not.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] config: Key-value pairs for configuring an add-on.
        """
        pulumi.set(__self__, "enabled", enabled)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the add-on is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value pairs for configuring an add-on.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class ManagedClusterAgentPoolProfileArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 count: Optional[pulumi.Input[int]] = None,
                 enable_auto_scaling: Optional[pulumi.Input[bool]] = None,
                 enable_encryption_at_host: Optional[pulumi.Input[bool]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 kubelet_config: Optional[pulumi.Input['KubeletConfigArgs']] = None,
                 kubelet_disk_type: Optional[pulumi.Input[Union[str, 'KubeletDiskType']]] = None,
                 linux_os_config: Optional[pulumi.Input['LinuxOSConfigArgs']] = None,
                 max_count: Optional[pulumi.Input[int]] = None,
                 max_pods: Optional[pulumi.Input[int]] = None,
                 min_count: Optional[pulumi.Input[int]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'AgentPoolMode']]] = None,
                 node_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 node_public_ip_prefix_id: Optional[pulumi.Input[str]] = None,
                 node_taints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 orchestrator_version: Optional[pulumi.Input[str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[int]] = None,
                 os_disk_type: Optional[pulumi.Input[Union[str, 'OSDiskType']]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OSType']]] = None,
                 pod_subnet_id: Optional[pulumi.Input[str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[str]] = None,
                 scale_set_eviction_policy: Optional[pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']]] = None,
                 scale_set_priority: Optional[pulumi.Input[Union[str, 'ScaleSetPriority']]] = None,
                 spot_max_price: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[Union[str, 'AgentPoolType']]] = None,
                 upgrade_settings: Optional[pulumi.Input['AgentPoolUpgradeSettingsArgs']] = None,
                 vm_size: Optional[pulumi.Input[Union[str, 'ContainerServiceVMSizeTypes']]] = None,
                 vnet_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Profile for the container service agent pool.
        :param pulumi.Input[str] name: Unique name of the agent pool profile in the context of the subscription and resource group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets AgentPoolType.
        :param pulumi.Input[int] count: Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for system pools. The default value is 1.
        :param pulumi.Input[bool] enable_auto_scaling: Whether to enable auto-scaler
        :param pulumi.Input[bool] enable_encryption_at_host: Whether to enable EncryptionAtHost
        :param pulumi.Input[bool] enable_node_public_ip: Enable public IP for nodes
        :param pulumi.Input['KubeletConfigArgs'] kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
        :param pulumi.Input[Union[str, 'KubeletDiskType']] kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS, resulting in Kubelet using the OS disk for data.
        :param pulumi.Input['LinuxOSConfigArgs'] linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
        :param pulumi.Input[int] max_count: Maximum number of nodes for auto-scaling
        :param pulumi.Input[int] max_pods: Maximum number of pods that can run on a node.
        :param pulumi.Input[int] min_count: Minimum number of nodes for auto-scaling
        :param pulumi.Input[Union[str, 'AgentPoolMode']] mode: AgentPoolMode represents mode of an agent pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :param pulumi.Input[str] node_public_ip_prefix_id: Public IP Prefix ID. VM nodes use IPs assigned from this Public IP Prefix.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_taints: Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        :param pulumi.Input[str] orchestrator_version: Version of orchestrator specified when creating the managed cluster.
        :param pulumi.Input[int] os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
        :param pulumi.Input[Union[str, 'OSDiskType']] os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation.
        :param pulumi.Input[Union[str, 'OSType']] os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
        :param pulumi.Input[str] pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
        :param pulumi.Input[str] proximity_placement_group_id: The ID for Proximity Placement Group.
        :param pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']] scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete.
        :param pulumi.Input[Union[str, 'ScaleSetPriority']] scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular.
        :param pulumi.Input[float] spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :param pulumi.Input[Union[str, 'AgentPoolType']] type: AgentPoolType represents types of an agent pool
        :param pulumi.Input['AgentPoolUpgradeSettingsArgs'] upgrade_settings: Settings for upgrading the agentpool
        :param pulumi.Input[Union[str, 'ContainerServiceVMSizeTypes']] vm_size: Size of agent VMs.
        :param pulumi.Input[str] vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe pods
        """
        pulumi.set(__self__, "name", name)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if enable_auto_scaling is not None:
            pulumi.set(__self__, "enable_auto_scaling", enable_auto_scaling)
        if enable_encryption_at_host is not None:
            pulumi.set(__self__, "enable_encryption_at_host", enable_encryption_at_host)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if kubelet_config is not None:
            pulumi.set(__self__, "kubelet_config", kubelet_config)
        if kubelet_disk_type is not None:
            pulumi.set(__self__, "kubelet_disk_type", kubelet_disk_type)
        if linux_os_config is not None:
            pulumi.set(__self__, "linux_os_config", linux_os_config)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods is not None:
            pulumi.set(__self__, "max_pods", max_pods)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if node_labels is not None:
            pulumi.set(__self__, "node_labels", node_labels)
        if node_public_ip_prefix_id is not None:
            pulumi.set(__self__, "node_public_ip_prefix_id", node_public_ip_prefix_id)
        if node_taints is not None:
            pulumi.set(__self__, "node_taints", node_taints)
        if orchestrator_version is not None:
            pulumi.set(__self__, "orchestrator_version", orchestrator_version)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_id is not None:
            pulumi.set(__self__, "pod_subnet_id", pod_subnet_id)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if scale_set_eviction_policy is not None:
            pulumi.set(__self__, "scale_set_eviction_policy", scale_set_eviction_policy)
        if scale_set_priority is not None:
            pulumi.set(__self__, "scale_set_priority", scale_set_priority)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)
        if vnet_subnet_id is not None:
            pulumi.set(__self__, "vnet_subnet_id", vnet_subnet_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Unique name of the agent pool profile in the context of the subscription and resource group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Availability zones for nodes. Must use VirtualMachineScaleSets AgentPoolType.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for system pools. The default value is 1.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="enableAutoScaling")
    def enable_auto_scaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-scaler
        """
        return pulumi.get(self, "enable_auto_scaling")

    @enable_auto_scaling.setter
    def enable_auto_scaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_auto_scaling", value)

    @property
    @pulumi.getter(name="enableEncryptionAtHost")
    def enable_encryption_at_host(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable EncryptionAtHost
        """
        return pulumi.get(self, "enable_encryption_at_host")

    @enable_encryption_at_host.setter
    def enable_encryption_at_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_encryption_at_host", value)

    @property
    @pulumi.getter(name="enableNodePublicIP")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable public IP for nodes
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> Optional[pulumi.Input['KubeletConfigArgs']]:
        """
        KubeletConfig specifies the configuration of kubelet on agent nodes.
        """
        return pulumi.get(self, "kubelet_config")

    @kubelet_config.setter
    def kubelet_config(self, value: Optional[pulumi.Input['KubeletConfigArgs']]):
        pulumi.set(self, "kubelet_config", value)

    @property
    @pulumi.getter(name="kubeletDiskType")
    def kubelet_disk_type(self) -> Optional[pulumi.Input[Union[str, 'KubeletDiskType']]]:
        """
        KubeletDiskType determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS, resulting in Kubelet using the OS disk for data.
        """
        return pulumi.get(self, "kubelet_disk_type")

    @kubelet_disk_type.setter
    def kubelet_disk_type(self, value: Optional[pulumi.Input[Union[str, 'KubeletDiskType']]]):
        pulumi.set(self, "kubelet_disk_type", value)

    @property
    @pulumi.getter(name="linuxOSConfig")
    def linux_os_config(self) -> Optional[pulumi.Input['LinuxOSConfigArgs']]:
        """
        LinuxOSConfig specifies the OS configuration of linux agent nodes.
        """
        return pulumi.get(self, "linux_os_config")

    @linux_os_config.setter
    def linux_os_config(self, value: Optional[pulumi.Input['LinuxOSConfigArgs']]):
        pulumi.set(self, "linux_os_config", value)

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of nodes for auto-scaling
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_count", value)

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of pods that can run on a node.
        """
        return pulumi.get(self, "max_pods")

    @max_pods.setter
    def max_pods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods", value)

    @property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of nodes for auto-scaling
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_count", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'AgentPoolMode']]]:
        """
        AgentPoolMode represents mode of an agent pool
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'AgentPoolMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="nodeLabels")
    def node_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Agent pool node labels to be persisted across all nodes in agent pool.
        """
        return pulumi.get(self, "node_labels")

    @node_labels.setter
    def node_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_labels", value)

    @property
    @pulumi.getter(name="nodePublicIPPrefixID")
    def node_public_ip_prefix_id(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP Prefix ID. VM nodes use IPs assigned from this Public IP Prefix.
        """
        return pulumi.get(self, "node_public_ip_prefix_id")

    @node_public_ip_prefix_id.setter
    def node_public_ip_prefix_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_public_ip_prefix_id", value)

    @property
    @pulumi.getter(name="nodeTaints")
    def node_taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
        """
        return pulumi.get(self, "node_taints")

    @node_taints.setter
    def node_taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_taints", value)

    @property
    @pulumi.getter(name="orchestratorVersion")
    def orchestrator_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of orchestrator specified when creating the managed cluster.
        """
        return pulumi.get(self, "orchestrator_version")

    @orchestrator_version.setter
    def orchestrator_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "orchestrator_version", value)

    @property
    @pulumi.getter(name="osDiskSizeGB")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[Union[str, 'OSDiskType']]]:
        """
        OS disk type to be used for machines in a given agent pool. Allowed values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[Union[str, 'OSDiskType']]]):
        pulumi.set(self, "os_disk_type", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OSType']]]:
        """
        OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OSType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="podSubnetID")
    def pod_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Pod SubnetID specifies the VNet's subnet identifier for pods.
        """
        return pulumi.get(self, "pod_subnet_id")

    @pod_subnet_id.setter
    def pod_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_subnet_id", value)

    @property
    @pulumi.getter(name="proximityPlacementGroupID")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for Proximity Placement Group.
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @property
    @pulumi.getter(name="scaleSetEvictionPolicy")
    def scale_set_eviction_policy(self) -> Optional[pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']]]:
        """
        ScaleSetEvictionPolicy to be used to specify eviction policy for Spot virtual machine scale set. Default to Delete.
        """
        return pulumi.get(self, "scale_set_eviction_policy")

    @scale_set_eviction_policy.setter
    def scale_set_eviction_policy(self, value: Optional[pulumi.Input[Union[str, 'ScaleSetEvictionPolicy']]]):
        pulumi.set(self, "scale_set_eviction_policy", value)

    @property
    @pulumi.getter(name="scaleSetPriority")
    def scale_set_priority(self) -> Optional[pulumi.Input[Union[str, 'ScaleSetPriority']]]:
        """
        ScaleSetPriority to be used to specify virtual machine scale set priority. Default to regular.
        """
        return pulumi.get(self, "scale_set_priority")

    @scale_set_priority.setter
    def scale_set_priority(self, value: Optional[pulumi.Input[Union[str, 'ScaleSetPriority']]]):
        pulumi.set(self, "scale_set_priority", value)

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[pulumi.Input[float]]:
        """
        SpotMaxPrice to be used to specify the maximum price you are willing to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which indicates default price to be up-to on-demand.
        """
        return pulumi.get(self, "spot_max_price")

    @spot_max_price.setter
    def spot_max_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_max_price", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Agent pool tags to be persisted on the agent pool virtual machine scale set.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'AgentPoolType']]]:
        """
        AgentPoolType represents types of an agent pool
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'AgentPoolType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['AgentPoolUpgradeSettingsArgs']]:
        """
        Settings for upgrading the agentpool
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['AgentPoolUpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[Union[str, 'ContainerServiceVMSizeTypes']]]:
        """
        Size of agent VMs.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[Union[str, 'ContainerServiceVMSizeTypes']]]):
        pulumi.set(self, "vm_size", value)

    @property
    @pulumi.getter(name="vnetSubnetID")
    def vnet_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe pods
        """
        return pulumi.get(self, "vnet_subnet_id")

    @vnet_subnet_id.setter
    def vnet_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_subnet_id", value)


@pulumi.input_type
class ManagedClusterAutoUpgradeProfileArgs:
    def __init__(__self__, *,
                 upgrade_channel: Optional[pulumi.Input[Union[str, 'UpgradeChannel']]] = None):
        """
        Auto upgrade profile for a managed cluster.
        :param pulumi.Input[Union[str, 'UpgradeChannel']] upgrade_channel: upgrade channel for auto upgrade.
        """
        if upgrade_channel is not None:
            pulumi.set(__self__, "upgrade_channel", upgrade_channel)

    @property
    @pulumi.getter(name="upgradeChannel")
    def upgrade_channel(self) -> Optional[pulumi.Input[Union[str, 'UpgradeChannel']]]:
        """
        upgrade channel for auto upgrade.
        """
        return pulumi.get(self, "upgrade_channel")

    @upgrade_channel.setter
    def upgrade_channel(self, value: Optional[pulumi.Input[Union[str, 'UpgradeChannel']]]):
        pulumi.set(self, "upgrade_channel", value)


@pulumi.input_type
class ManagedClusterIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the managed cluster.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the managed cluster. Type 'SystemAssigned' will use an implicitly created identity in master components and an auto-created user assigned identity in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user identity associated with the managed cluster. This identity will be used in control plane and only one user assigned identity is allowed. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of identity used for the managed cluster. Type 'SystemAssigned' will use an implicitly created identity in master components and an auto-created user assigned identity in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user identity associated with the managed cluster. This identity will be used in control plane and only one user assigned identity is allowed. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None):
        """
        Desired managed outbound IPs for the cluster load balancer.
        :param pulumi.Input[int] count: Desired number of outbound IP created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1. 
        """
        if count is None:
            count = 1
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Desired number of outbound IP created/managed by Azure for the cluster load balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1. 
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs:
    def __init__(__self__, *,
                 public_ip_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None):
        """
        Desired outbound IP Prefix resources for the cluster load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] public_ip_prefixes: A list of public IP prefix resources.
        """
        if public_ip_prefixes is not None:
            pulumi.set(__self__, "public_ip_prefixes", public_ip_prefixes)

    @property
    @pulumi.getter(name="publicIPPrefixes")
    def public_ip_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        A list of public IP prefix resources.
        """
        return pulumi.get(self, "public_ip_prefixes")

    @public_ip_prefixes.setter
    def public_ip_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "public_ip_prefixes", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileOutboundIPsArgs:
    def __init__(__self__, *,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None):
        """
        Desired outbound IP resources for the cluster load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] public_ips: A list of public IP resources.
        """
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)

    @property
    @pulumi.getter(name="publicIPs")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        A list of public IP resources.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "public_ips", value)


@pulumi.input_type
class ManagedClusterLoadBalancerProfileArgs:
    def __init__(__self__, *,
                 allocated_outbound_ports: Optional[pulumi.Input[int]] = None,
                 effective_outbound_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[int]] = None,
                 managed_outbound_ips: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs']] = None,
                 outbound_ip_prefixes: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs']] = None,
                 outbound_ips: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs']] = None):
        """
        Profile of the managed cluster load balancer.
        :param pulumi.Input[int] allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed values must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] effective_outbound_ips: The effective outbound IP resources of the cluster load balancer.
        :param pulumi.Input[int] idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs'] managed_outbound_ips: Desired managed outbound IPs for the cluster load balancer.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs'] outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load balancer.
        :param pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs'] outbound_ips: Desired outbound IP resources for the cluster load balancer.
        """
        if allocated_outbound_ports is None:
            allocated_outbound_ports = 0
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if effective_outbound_ips is not None:
            pulumi.set(__self__, "effective_outbound_ips", effective_outbound_ips)
        if idle_timeout_in_minutes is None:
            idle_timeout_in_minutes = 30
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if managed_outbound_ips is not None:
            pulumi.set(__self__, "managed_outbound_ips", managed_outbound_ips)
        if outbound_ip_prefixes is not None:
            pulumi.set(__self__, "outbound_ip_prefixes", outbound_ip_prefixes)
        if outbound_ips is not None:
            pulumi.set(__self__, "outbound_ips", outbound_ips)

    @property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[pulumi.Input[int]]:
        """
        Desired number of allocated SNAT ports per VM. Allowed values must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @allocated_outbound_ports.setter
    def allocated_outbound_ports(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_outbound_ports", value)

    @property
    @pulumi.getter(name="effectiveOutboundIPs")
    def effective_outbound_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        The effective outbound IP resources of the cluster load balancer.
        """
        return pulumi.get(self, "effective_outbound_ips")

    @effective_outbound_ips.setter
    def effective_outbound_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "effective_outbound_ips", value)

    @property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Desired outbound flow idle timeout in minutes. Allowed values must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="managedOutboundIPs")
    def managed_outbound_ips(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs']]:
        """
        Desired managed outbound IPs for the cluster load balancer.
        """
        return pulumi.get(self, "managed_outbound_ips")

    @managed_outbound_ips.setter
    def managed_outbound_ips(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs']]):
        pulumi.set(self, "managed_outbound_ips", value)

    @property
    @pulumi.getter(name="outboundIPPrefixes")
    def outbound_ip_prefixes(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs']]:
        """
        Desired outbound IP Prefix resources for the cluster load balancer.
        """
        return pulumi.get(self, "outbound_ip_prefixes")

    @outbound_ip_prefixes.setter
    def outbound_ip_prefixes(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs']]):
        pulumi.set(self, "outbound_ip_prefixes", value)

    @property
    @pulumi.getter(name="outboundIPs")
    def outbound_ips(self) -> Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs']]:
        """
        Desired outbound IP resources for the cluster load balancer.
        """
        return pulumi.get(self, "outbound_ips")

    @outbound_ips.setter
    def outbound_ips(self, value: Optional[pulumi.Input['ManagedClusterLoadBalancerProfileOutboundIPsArgs']]):
        pulumi.set(self, "outbound_ips", value)


@pulumi.input_type
class ManagedClusterPodIdentityExceptionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 pod_labels: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] name: Name of the pod identity exception.
        :param pulumi.Input[str] namespace: Namespace of the pod identity exception.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pod_labels: Pod labels to match.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "pod_labels", pod_labels)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the pod identity exception.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Namespace of the pod identity exception.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="podLabels")
    def pod_labels(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        Pod labels to match.
        """
        return pulumi.get(self, "pod_labels")

    @pod_labels.setter
    def pod_labels(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "pod_labels", value)


@pulumi.input_type
class ManagedClusterPodIdentityProfileArgs:
    def __init__(__self__, *,
                 allow_network_plugin_kubenet: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]]] = None,
                 user_assigned_identity_exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]]] = None):
        """
        :param pulumi.Input[bool] allow_network_plugin_kubenet: Customer consent for enabling AAD pod identity addon in cluster using Kubenet network plugin.
        :param pulumi.Input[bool] enabled: Whether the pod identity addon is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]] user_assigned_identities: User assigned pod identity settings.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]] user_assigned_identity_exceptions: User assigned pod identity exception settings.
        """
        if allow_network_plugin_kubenet is not None:
            pulumi.set(__self__, "allow_network_plugin_kubenet", allow_network_plugin_kubenet)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)
        if user_assigned_identity_exceptions is not None:
            pulumi.set(__self__, "user_assigned_identity_exceptions", user_assigned_identity_exceptions)

    @property
    @pulumi.getter(name="allowNetworkPluginKubenet")
    def allow_network_plugin_kubenet(self) -> Optional[pulumi.Input[bool]]:
        """
        Customer consent for enabling AAD pod identity addon in cluster using Kubenet network plugin.
        """
        return pulumi.get(self, "allow_network_plugin_kubenet")

    @allow_network_plugin_kubenet.setter
    def allow_network_plugin_kubenet(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_network_plugin_kubenet", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the pod identity addon is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]]]:
        """
        User assigned pod identity settings.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)

    @property
    @pulumi.getter(name="userAssignedIdentityExceptions")
    def user_assigned_identity_exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]]]:
        """
        User assigned pod identity exception settings.
        """
        return pulumi.get(self, "user_assigned_identity_exceptions")

    @user_assigned_identity_exceptions.setter
    def user_assigned_identity_exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedClusterPodIdentityExceptionArgs']]]]):
        pulumi.set(self, "user_assigned_identity_exceptions", value)


@pulumi.input_type
class ManagedClusterPodIdentityArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['UserAssignedIdentityArgs'],
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        :param pulumi.Input['UserAssignedIdentityArgs'] identity: Information of the user assigned identity.
        :param pulumi.Input[str] name: Name of the pod identity.
        :param pulumi.Input[str] namespace: Namespace of the pod identity.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input['UserAssignedIdentityArgs']:
        """
        Information of the user assigned identity.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['UserAssignedIdentityArgs']):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the pod identity.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Namespace of the pod identity.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ManagedClusterPropertiesAutoScalerProfileArgs:
    def __init__(__self__, *,
                 balance_similar_node_groups: Optional[pulumi.Input[str]] = None,
                 expander: Optional[pulumi.Input[Union[str, 'Expander']]] = None,
                 max_empty_bulk_delete: Optional[pulumi.Input[str]] = None,
                 max_graceful_termination_sec: Optional[pulumi.Input[str]] = None,
                 max_node_provision_time: Optional[pulumi.Input[str]] = None,
                 max_total_unready_percentage: Optional[pulumi.Input[str]] = None,
                 new_pod_scale_up_delay: Optional[pulumi.Input[str]] = None,
                 ok_total_unready_count: Optional[pulumi.Input[str]] = None,
                 scale_down_delay_after_add: Optional[pulumi.Input[str]] = None,
                 scale_down_delay_after_delete: Optional[pulumi.Input[str]] = None,
                 scale_down_delay_after_failure: Optional[pulumi.Input[str]] = None,
                 scale_down_unneeded_time: Optional[pulumi.Input[str]] = None,
                 scale_down_unready_time: Optional[pulumi.Input[str]] = None,
                 scale_down_utilization_threshold: Optional[pulumi.Input[str]] = None,
                 scan_interval: Optional[pulumi.Input[str]] = None,
                 skip_nodes_with_local_storage: Optional[pulumi.Input[str]] = None,
                 skip_nodes_with_system_pods: Optional[pulumi.Input[str]] = None):
        """
        Parameters to be applied to the cluster-autoscaler when enabled
        """
        if balance_similar_node_groups is not None:
            pulumi.set(__self__, "balance_similar_node_groups", balance_similar_node_groups)
        if expander is not None:
            pulumi.set(__self__, "expander", expander)
        if max_empty_bulk_delete is not None:
            pulumi.set(__self__, "max_empty_bulk_delete", max_empty_bulk_delete)
        if max_graceful_termination_sec is not None:
            pulumi.set(__self__, "max_graceful_termination_sec", max_graceful_termination_sec)
        if max_node_provision_time is not None:
            pulumi.set(__self__, "max_node_provision_time", max_node_provision_time)
        if max_total_unready_percentage is not None:
            pulumi.set(__self__, "max_total_unready_percentage", max_total_unready_percentage)
        if new_pod_scale_up_delay is not None:
            pulumi.set(__self__, "new_pod_scale_up_delay", new_pod_scale_up_delay)
        if ok_total_unready_count is not None:
            pulumi.set(__self__, "ok_total_unready_count", ok_total_unready_count)
        if scale_down_delay_after_add is not None:
            pulumi.set(__self__, "scale_down_delay_after_add", scale_down_delay_after_add)
        if scale_down_delay_after_delete is not None:
            pulumi.set(__self__, "scale_down_delay_after_delete", scale_down_delay_after_delete)
        if scale_down_delay_after_failure is not None:
            pulumi.set(__self__, "scale_down_delay_after_failure", scale_down_delay_after_failure)
        if scale_down_unneeded_time is not None:
            pulumi.set(__self__, "scale_down_unneeded_time", scale_down_unneeded_time)
        if scale_down_unready_time is not None:
            pulumi.set(__self__, "scale_down_unready_time", scale_down_unready_time)
        if scale_down_utilization_threshold is not None:
            pulumi.set(__self__, "scale_down_utilization_threshold", scale_down_utilization_threshold)
        if scan_interval is not None:
            pulumi.set(__self__, "scan_interval", scan_interval)
        if skip_nodes_with_local_storage is not None:
            pulumi.set(__self__, "skip_nodes_with_local_storage", skip_nodes_with_local_storage)
        if skip_nodes_with_system_pods is not None:
            pulumi.set(__self__, "skip_nodes_with_system_pods", skip_nodes_with_system_pods)

    @property
    @pulumi.getter(name="balanceSimilarNodeGroups")
    def balance_similar_node_groups(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "balance_similar_node_groups")

    @balance_similar_node_groups.setter
    def balance_similar_node_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "balance_similar_node_groups", value)

    @property
    @pulumi.getter
    def expander(self) -> Optional[pulumi.Input[Union[str, 'Expander']]]:
        return pulumi.get(self, "expander")

    @expander.setter
    def expander(self, value: Optional[pulumi.Input[Union[str, 'Expander']]]):
        pulumi.set(self, "expander", value)

    @property
    @pulumi.getter(name="maxEmptyBulkDelete")
    def max_empty_bulk_delete(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "max_empty_bulk_delete")

    @max_empty_bulk_delete.setter
    def max_empty_bulk_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_empty_bulk_delete", value)

    @property
    @pulumi.getter(name="maxGracefulTerminationSec")
    def max_graceful_termination_sec(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "max_graceful_termination_sec")

    @max_graceful_termination_sec.setter
    def max_graceful_termination_sec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_graceful_termination_sec", value)

    @property
    @pulumi.getter(name="maxNodeProvisionTime")
    def max_node_provision_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "max_node_provision_time")

    @max_node_provision_time.setter
    def max_node_provision_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_node_provision_time", value)

    @property
    @pulumi.getter(name="maxTotalUnreadyPercentage")
    def max_total_unready_percentage(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "max_total_unready_percentage")

    @max_total_unready_percentage.setter
    def max_total_unready_percentage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_total_unready_percentage", value)

    @property
    @pulumi.getter(name="newPodScaleUpDelay")
    def new_pod_scale_up_delay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "new_pod_scale_up_delay")

    @new_pod_scale_up_delay.setter
    def new_pod_scale_up_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_pod_scale_up_delay", value)

    @property
    @pulumi.getter(name="okTotalUnreadyCount")
    def ok_total_unready_count(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ok_total_unready_count")

    @ok_total_unready_count.setter
    def ok_total_unready_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ok_total_unready_count", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterAdd")
    def scale_down_delay_after_add(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scale_down_delay_after_add")

    @scale_down_delay_after_add.setter
    def scale_down_delay_after_add(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_add", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterDelete")
    def scale_down_delay_after_delete(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scale_down_delay_after_delete")

    @scale_down_delay_after_delete.setter
    def scale_down_delay_after_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_delete", value)

    @property
    @pulumi.getter(name="scaleDownDelayAfterFailure")
    def scale_down_delay_after_failure(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scale_down_delay_after_failure")

    @scale_down_delay_after_failure.setter
    def scale_down_delay_after_failure(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_delay_after_failure", value)

    @property
    @pulumi.getter(name="scaleDownUnneededTime")
    def scale_down_unneeded_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scale_down_unneeded_time")

    @scale_down_unneeded_time.setter
    def scale_down_unneeded_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_unneeded_time", value)

    @property
    @pulumi.getter(name="scaleDownUnreadyTime")
    def scale_down_unready_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scale_down_unready_time")

    @scale_down_unready_time.setter
    def scale_down_unready_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_unready_time", value)

    @property
    @pulumi.getter(name="scaleDownUtilizationThreshold")
    def scale_down_utilization_threshold(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scale_down_utilization_threshold")

    @scale_down_utilization_threshold.setter
    def scale_down_utilization_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scale_down_utilization_threshold", value)

    @property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "scan_interval")

    @scan_interval.setter
    def scan_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_interval", value)

    @property
    @pulumi.getter(name="skipNodesWithLocalStorage")
    def skip_nodes_with_local_storage(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "skip_nodes_with_local_storage")

    @skip_nodes_with_local_storage.setter
    def skip_nodes_with_local_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_nodes_with_local_storage", value)

    @property
    @pulumi.getter(name="skipNodesWithSystemPods")
    def skip_nodes_with_system_pods(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "skip_nodes_with_system_pods")

    @skip_nodes_with_system_pods.setter
    def skip_nodes_with_system_pods(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "skip_nodes_with_system_pods", value)


@pulumi.input_type
class ManagedClusterPropertiesIdentityProfileArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: The client id of the user assigned identity.
        :param pulumi.Input[str] object_id: The object id of the user assigned identity.
        :param pulumi.Input[str] resource_id: The resource id of the user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of the user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user assigned identity.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the user assigned identity.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ManagedClusterSKUArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUName']]] = None,
                 tier: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUTier']]] = None):
        """
        :param pulumi.Input[Union[str, 'ManagedClusterSKUName']] name: Name of a managed cluster SKU.
        :param pulumi.Input[Union[str, 'ManagedClusterSKUTier']] tier: Tier of a managed cluster SKU.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'ManagedClusterSKUName']]]:
        """
        Name of a managed cluster SKU.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUName']]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[Union[str, 'ManagedClusterSKUTier']]]:
        """
        Tier of a managed cluster SKU.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[Union[str, 'ManagedClusterSKUTier']]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class ManagedClusterServicePrincipalProfileArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 secret: Optional[pulumi.Input[str]] = None):
        """
        Information about a service principal identity for the cluster to use for manipulating Azure APIs.
        :param pulumi.Input[str] client_id: The ID for the service principal.
        :param pulumi.Input[str] secret: The secret password associated with the service principal in plain text.
        """
        pulumi.set(__self__, "client_id", client_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The ID for the service principal.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        The secret password associated with the service principal in plain text.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class ManagedClusterWindowsProfileArgs:
    def __init__(__self__, *,
                 admin_username: pulumi.Input[str],
                 admin_password: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[Union[str, 'LicenseType']]] = None):
        """
        Profile for Windows VMs in the container service cluster.
        :param pulumi.Input[str] admin_username: Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
        :param pulumi.Input[str] admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
        :param pulumi.Input[Union[str, 'LicenseType']] license_type: The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Input[str]:
        """
        Specifies the name of the administrator account. <br><br> **restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[Union[str, 'LicenseType']]]:
        """
        The licenseType to use for Windows VMs. Windows_Server is used to enable Azure Hybrid User Benefits for Windows VMs.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[Union[str, 'LicenseType']]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Private endpoint which a connection belongs to.
        :param pulumi.Input[str] id: The resource Id for private endpoint
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource Id for private endpoint
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]] = None):
        """
        The state of a private link service connection.
        :param pulumi.Input[str] description: The private link service connection description.
        :param pulumi.Input[Union[str, 'ConnectionStatus']] status: The private link service connection status.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ResourceReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        A reference to an Azure resource.
        :param pulumi.Input[str] id: The fully qualified Azure resource id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified Azure resource id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SysctlConfigArgs:
    def __init__(__self__, *,
                 fs_aio_max_nr: Optional[pulumi.Input[int]] = None,
                 fs_file_max: Optional[pulumi.Input[int]] = None,
                 fs_inotify_max_user_watches: Optional[pulumi.Input[int]] = None,
                 fs_nr_open: Optional[pulumi.Input[int]] = None,
                 kernel_threads_max: Optional[pulumi.Input[int]] = None,
                 net_core_netdev_max_backlog: Optional[pulumi.Input[int]] = None,
                 net_core_optmem_max: Optional[pulumi.Input[int]] = None,
                 net_core_rmem_default: Optional[pulumi.Input[int]] = None,
                 net_core_rmem_max: Optional[pulumi.Input[int]] = None,
                 net_core_somaxconn: Optional[pulumi.Input[int]] = None,
                 net_core_wmem_default: Optional[pulumi.Input[int]] = None,
                 net_core_wmem_max: Optional[pulumi.Input[int]] = None,
                 net_ipv4_ip_local_port_range: Optional[pulumi.Input[str]] = None,
                 net_ipv4_neigh_default_gc_thresh1: Optional[pulumi.Input[int]] = None,
                 net_ipv4_neigh_default_gc_thresh2: Optional[pulumi.Input[int]] = None,
                 net_ipv4_neigh_default_gc_thresh3: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_fin_timeout: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_keepalive_probes: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_keepalive_time: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_max_syn_backlog: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_max_tw_buckets: Optional[pulumi.Input[int]] = None,
                 net_ipv4_tcp_tw_reuse: Optional[pulumi.Input[bool]] = None,
                 net_ipv4_tcpkeepalive_intvl: Optional[pulumi.Input[int]] = None,
                 net_netfilter_nf_conntrack_buckets: Optional[pulumi.Input[int]] = None,
                 net_netfilter_nf_conntrack_max: Optional[pulumi.Input[int]] = None,
                 vm_max_map_count: Optional[pulumi.Input[int]] = None,
                 vm_swappiness: Optional[pulumi.Input[int]] = None,
                 vm_vfs_cache_pressure: Optional[pulumi.Input[int]] = None):
        """
        Sysctl settings for Linux agent nodes.
        :param pulumi.Input[int] fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
        :param pulumi.Input[int] fs_file_max: Sysctl setting fs.file-max.
        :param pulumi.Input[int] fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
        :param pulumi.Input[int] fs_nr_open: Sysctl setting fs.nr_open.
        :param pulumi.Input[int] kernel_threads_max: Sysctl setting kernel.threads-max.
        :param pulumi.Input[int] net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
        :param pulumi.Input[int] net_core_optmem_max: Sysctl setting net.core.optmem_max.
        :param pulumi.Input[int] net_core_rmem_default: Sysctl setting net.core.rmem_default.
        :param pulumi.Input[int] net_core_rmem_max: Sysctl setting net.core.rmem_max.
        :param pulumi.Input[int] net_core_somaxconn: Sysctl setting net.core.somaxconn.
        :param pulumi.Input[int] net_core_wmem_default: Sysctl setting net.core.wmem_default.
        :param pulumi.Input[int] net_core_wmem_max: Sysctl setting net.core.wmem_max.
        :param pulumi.Input[str] net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
        :param pulumi.Input[int] net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
        :param pulumi.Input[int] net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
        :param pulumi.Input[int] net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
        :param pulumi.Input[int] net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
        :param pulumi.Input[int] net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
        :param pulumi.Input[int] net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
        :param pulumi.Input[int] net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
        :param pulumi.Input[int] net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
        :param pulumi.Input[bool] net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
        :param pulumi.Input[int] net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
        :param pulumi.Input[int] net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
        :param pulumi.Input[int] net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
        :param pulumi.Input[int] vm_max_map_count: Sysctl setting vm.max_map_count.
        :param pulumi.Input[int] vm_swappiness: Sysctl setting vm.swappiness.
        :param pulumi.Input[int] vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
        """
        if fs_aio_max_nr is not None:
            pulumi.set(__self__, "fs_aio_max_nr", fs_aio_max_nr)
        if fs_file_max is not None:
            pulumi.set(__self__, "fs_file_max", fs_file_max)
        if fs_inotify_max_user_watches is not None:
            pulumi.set(__self__, "fs_inotify_max_user_watches", fs_inotify_max_user_watches)
        if fs_nr_open is not None:
            pulumi.set(__self__, "fs_nr_open", fs_nr_open)
        if kernel_threads_max is not None:
            pulumi.set(__self__, "kernel_threads_max", kernel_threads_max)
        if net_core_netdev_max_backlog is not None:
            pulumi.set(__self__, "net_core_netdev_max_backlog", net_core_netdev_max_backlog)
        if net_core_optmem_max is not None:
            pulumi.set(__self__, "net_core_optmem_max", net_core_optmem_max)
        if net_core_rmem_default is not None:
            pulumi.set(__self__, "net_core_rmem_default", net_core_rmem_default)
        if net_core_rmem_max is not None:
            pulumi.set(__self__, "net_core_rmem_max", net_core_rmem_max)
        if net_core_somaxconn is not None:
            pulumi.set(__self__, "net_core_somaxconn", net_core_somaxconn)
        if net_core_wmem_default is not None:
            pulumi.set(__self__, "net_core_wmem_default", net_core_wmem_default)
        if net_core_wmem_max is not None:
            pulumi.set(__self__, "net_core_wmem_max", net_core_wmem_max)
        if net_ipv4_ip_local_port_range is not None:
            pulumi.set(__self__, "net_ipv4_ip_local_port_range", net_ipv4_ip_local_port_range)
        if net_ipv4_neigh_default_gc_thresh1 is not None:
            pulumi.set(__self__, "net_ipv4_neigh_default_gc_thresh1", net_ipv4_neigh_default_gc_thresh1)
        if net_ipv4_neigh_default_gc_thresh2 is not None:
            pulumi.set(__self__, "net_ipv4_neigh_default_gc_thresh2", net_ipv4_neigh_default_gc_thresh2)
        if net_ipv4_neigh_default_gc_thresh3 is not None:
            pulumi.set(__self__, "net_ipv4_neigh_default_gc_thresh3", net_ipv4_neigh_default_gc_thresh3)
        if net_ipv4_tcp_fin_timeout is not None:
            pulumi.set(__self__, "net_ipv4_tcp_fin_timeout", net_ipv4_tcp_fin_timeout)
        if net_ipv4_tcp_keepalive_probes is not None:
            pulumi.set(__self__, "net_ipv4_tcp_keepalive_probes", net_ipv4_tcp_keepalive_probes)
        if net_ipv4_tcp_keepalive_time is not None:
            pulumi.set(__self__, "net_ipv4_tcp_keepalive_time", net_ipv4_tcp_keepalive_time)
        if net_ipv4_tcp_max_syn_backlog is not None:
            pulumi.set(__self__, "net_ipv4_tcp_max_syn_backlog", net_ipv4_tcp_max_syn_backlog)
        if net_ipv4_tcp_max_tw_buckets is not None:
            pulumi.set(__self__, "net_ipv4_tcp_max_tw_buckets", net_ipv4_tcp_max_tw_buckets)
        if net_ipv4_tcp_tw_reuse is not None:
            pulumi.set(__self__, "net_ipv4_tcp_tw_reuse", net_ipv4_tcp_tw_reuse)
        if net_ipv4_tcpkeepalive_intvl is not None:
            pulumi.set(__self__, "net_ipv4_tcpkeepalive_intvl", net_ipv4_tcpkeepalive_intvl)
        if net_netfilter_nf_conntrack_buckets is not None:
            pulumi.set(__self__, "net_netfilter_nf_conntrack_buckets", net_netfilter_nf_conntrack_buckets)
        if net_netfilter_nf_conntrack_max is not None:
            pulumi.set(__self__, "net_netfilter_nf_conntrack_max", net_netfilter_nf_conntrack_max)
        if vm_max_map_count is not None:
            pulumi.set(__self__, "vm_max_map_count", vm_max_map_count)
        if vm_swappiness is not None:
            pulumi.set(__self__, "vm_swappiness", vm_swappiness)
        if vm_vfs_cache_pressure is not None:
            pulumi.set(__self__, "vm_vfs_cache_pressure", vm_vfs_cache_pressure)

    @property
    @pulumi.getter(name="fsAioMaxNr")
    def fs_aio_max_nr(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.aio-max-nr.
        """
        return pulumi.get(self, "fs_aio_max_nr")

    @fs_aio_max_nr.setter
    def fs_aio_max_nr(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_aio_max_nr", value)

    @property
    @pulumi.getter(name="fsFileMax")
    def fs_file_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.file-max.
        """
        return pulumi.get(self, "fs_file_max")

    @fs_file_max.setter
    def fs_file_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_file_max", value)

    @property
    @pulumi.getter(name="fsInotifyMaxUserWatches")
    def fs_inotify_max_user_watches(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.inotify.max_user_watches.
        """
        return pulumi.get(self, "fs_inotify_max_user_watches")

    @fs_inotify_max_user_watches.setter
    def fs_inotify_max_user_watches(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_inotify_max_user_watches", value)

    @property
    @pulumi.getter(name="fsNrOpen")
    def fs_nr_open(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting fs.nr_open.
        """
        return pulumi.get(self, "fs_nr_open")

    @fs_nr_open.setter
    def fs_nr_open(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fs_nr_open", value)

    @property
    @pulumi.getter(name="kernelThreadsMax")
    def kernel_threads_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting kernel.threads-max.
        """
        return pulumi.get(self, "kernel_threads_max")

    @kernel_threads_max.setter
    def kernel_threads_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "kernel_threads_max", value)

    @property
    @pulumi.getter(name="netCoreNetdevMaxBacklog")
    def net_core_netdev_max_backlog(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.netdev_max_backlog.
        """
        return pulumi.get(self, "net_core_netdev_max_backlog")

    @net_core_netdev_max_backlog.setter
    def net_core_netdev_max_backlog(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_netdev_max_backlog", value)

    @property
    @pulumi.getter(name="netCoreOptmemMax")
    def net_core_optmem_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.optmem_max.
        """
        return pulumi.get(self, "net_core_optmem_max")

    @net_core_optmem_max.setter
    def net_core_optmem_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_optmem_max", value)

    @property
    @pulumi.getter(name="netCoreRmemDefault")
    def net_core_rmem_default(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.rmem_default.
        """
        return pulumi.get(self, "net_core_rmem_default")

    @net_core_rmem_default.setter
    def net_core_rmem_default(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_rmem_default", value)

    @property
    @pulumi.getter(name="netCoreRmemMax")
    def net_core_rmem_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.rmem_max.
        """
        return pulumi.get(self, "net_core_rmem_max")

    @net_core_rmem_max.setter
    def net_core_rmem_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_rmem_max", value)

    @property
    @pulumi.getter(name="netCoreSomaxconn")
    def net_core_somaxconn(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.somaxconn.
        """
        return pulumi.get(self, "net_core_somaxconn")

    @net_core_somaxconn.setter
    def net_core_somaxconn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_somaxconn", value)

    @property
    @pulumi.getter(name="netCoreWmemDefault")
    def net_core_wmem_default(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.wmem_default.
        """
        return pulumi.get(self, "net_core_wmem_default")

    @net_core_wmem_default.setter
    def net_core_wmem_default(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_wmem_default", value)

    @property
    @pulumi.getter(name="netCoreWmemMax")
    def net_core_wmem_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.core.wmem_max.
        """
        return pulumi.get(self, "net_core_wmem_max")

    @net_core_wmem_max.setter
    def net_core_wmem_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_core_wmem_max", value)

    @property
    @pulumi.getter(name="netIpv4IpLocalPortRange")
    def net_ipv4_ip_local_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        Sysctl setting net.ipv4.ip_local_port_range.
        """
        return pulumi.get(self, "net_ipv4_ip_local_port_range")

    @net_ipv4_ip_local_port_range.setter
    def net_ipv4_ip_local_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_ipv4_ip_local_port_range", value)

    @property
    @pulumi.getter(name="netIpv4NeighDefaultGcThresh1")
    def net_ipv4_neigh_default_gc_thresh1(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.neigh.default.gc_thresh1.
        """
        return pulumi.get(self, "net_ipv4_neigh_default_gc_thresh1")

    @net_ipv4_neigh_default_gc_thresh1.setter
    def net_ipv4_neigh_default_gc_thresh1(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_neigh_default_gc_thresh1", value)

    @property
    @pulumi.getter(name="netIpv4NeighDefaultGcThresh2")
    def net_ipv4_neigh_default_gc_thresh2(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.neigh.default.gc_thresh2.
        """
        return pulumi.get(self, "net_ipv4_neigh_default_gc_thresh2")

    @net_ipv4_neigh_default_gc_thresh2.setter
    def net_ipv4_neigh_default_gc_thresh2(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_neigh_default_gc_thresh2", value)

    @property
    @pulumi.getter(name="netIpv4NeighDefaultGcThresh3")
    def net_ipv4_neigh_default_gc_thresh3(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.neigh.default.gc_thresh3.
        """
        return pulumi.get(self, "net_ipv4_neigh_default_gc_thresh3")

    @net_ipv4_neigh_default_gc_thresh3.setter
    def net_ipv4_neigh_default_gc_thresh3(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_neigh_default_gc_thresh3", value)

    @property
    @pulumi.getter(name="netIpv4TcpFinTimeout")
    def net_ipv4_tcp_fin_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_fin_timeout.
        """
        return pulumi.get(self, "net_ipv4_tcp_fin_timeout")

    @net_ipv4_tcp_fin_timeout.setter
    def net_ipv4_tcp_fin_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_fin_timeout", value)

    @property
    @pulumi.getter(name="netIpv4TcpKeepaliveProbes")
    def net_ipv4_tcp_keepalive_probes(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_keepalive_probes.
        """
        return pulumi.get(self, "net_ipv4_tcp_keepalive_probes")

    @net_ipv4_tcp_keepalive_probes.setter
    def net_ipv4_tcp_keepalive_probes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_keepalive_probes", value)

    @property
    @pulumi.getter(name="netIpv4TcpKeepaliveTime")
    def net_ipv4_tcp_keepalive_time(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_keepalive_time.
        """
        return pulumi.get(self, "net_ipv4_tcp_keepalive_time")

    @net_ipv4_tcp_keepalive_time.setter
    def net_ipv4_tcp_keepalive_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_keepalive_time", value)

    @property
    @pulumi.getter(name="netIpv4TcpMaxSynBacklog")
    def net_ipv4_tcp_max_syn_backlog(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_max_syn_backlog.
        """
        return pulumi.get(self, "net_ipv4_tcp_max_syn_backlog")

    @net_ipv4_tcp_max_syn_backlog.setter
    def net_ipv4_tcp_max_syn_backlog(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_max_syn_backlog", value)

    @property
    @pulumi.getter(name="netIpv4TcpMaxTwBuckets")
    def net_ipv4_tcp_max_tw_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_max_tw_buckets.
        """
        return pulumi.get(self, "net_ipv4_tcp_max_tw_buckets")

    @net_ipv4_tcp_max_tw_buckets.setter
    def net_ipv4_tcp_max_tw_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcp_max_tw_buckets", value)

    @property
    @pulumi.getter(name="netIpv4TcpTwReuse")
    def net_ipv4_tcp_tw_reuse(self) -> Optional[pulumi.Input[bool]]:
        """
        Sysctl setting net.ipv4.tcp_tw_reuse.
        """
        return pulumi.get(self, "net_ipv4_tcp_tw_reuse")

    @net_ipv4_tcp_tw_reuse.setter
    def net_ipv4_tcp_tw_reuse(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "net_ipv4_tcp_tw_reuse", value)

    @property
    @pulumi.getter(name="netIpv4TcpkeepaliveIntvl")
    def net_ipv4_tcpkeepalive_intvl(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.ipv4.tcp_keepalive_intvl.
        """
        return pulumi.get(self, "net_ipv4_tcpkeepalive_intvl")

    @net_ipv4_tcpkeepalive_intvl.setter
    def net_ipv4_tcpkeepalive_intvl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_ipv4_tcpkeepalive_intvl", value)

    @property
    @pulumi.getter(name="netNetfilterNfConntrackBuckets")
    def net_netfilter_nf_conntrack_buckets(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.netfilter.nf_conntrack_buckets.
        """
        return pulumi.get(self, "net_netfilter_nf_conntrack_buckets")

    @net_netfilter_nf_conntrack_buckets.setter
    def net_netfilter_nf_conntrack_buckets(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_netfilter_nf_conntrack_buckets", value)

    @property
    @pulumi.getter(name="netNetfilterNfConntrackMax")
    def net_netfilter_nf_conntrack_max(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting net.netfilter.nf_conntrack_max.
        """
        return pulumi.get(self, "net_netfilter_nf_conntrack_max")

    @net_netfilter_nf_conntrack_max.setter
    def net_netfilter_nf_conntrack_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "net_netfilter_nf_conntrack_max", value)

    @property
    @pulumi.getter(name="vmMaxMapCount")
    def vm_max_map_count(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting vm.max_map_count.
        """
        return pulumi.get(self, "vm_max_map_count")

    @vm_max_map_count.setter
    def vm_max_map_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_max_map_count", value)

    @property
    @pulumi.getter(name="vmSwappiness")
    def vm_swappiness(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting vm.swappiness.
        """
        return pulumi.get(self, "vm_swappiness")

    @vm_swappiness.setter
    def vm_swappiness(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_swappiness", value)

    @property
    @pulumi.getter(name="vmVfsCachePressure")
    def vm_vfs_cache_pressure(self) -> Optional[pulumi.Input[int]]:
        """
        Sysctl setting vm.vfs_cache_pressure.
        """
        return pulumi.get(self, "vm_vfs_cache_pressure")

    @vm_vfs_cache_pressure.setter
    def vm_vfs_cache_pressure(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vm_vfs_cache_pressure", value)


@pulumi.input_type
class TimeInWeekArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[Union[str, 'WeekDay']]] = None,
                 hour_slots: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Time in a week.
        :param pulumi.Input[Union[str, 'WeekDay']] day: A day in a week.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hour_slots: hour slots in a day.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour_slots is not None:
            pulumi.set(__self__, "hour_slots", hour_slots)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[Union[str, 'WeekDay']]]:
        """
        A day in a week.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[Union[str, 'WeekDay']]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter(name="hourSlots")
    def hour_slots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        hour slots in a day.
        """
        return pulumi.get(self, "hour_slots")

    @hour_slots.setter
    def hour_slots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "hour_slots", value)


@pulumi.input_type
class TimeSpanArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        The time span with start and end properties.
        :param pulumi.Input[str] end: The end of a time span
        :param pulumi.Input[str] start: The start of a time span
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        The end of a time span
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        The start of a time span
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class UserAssignedIdentityArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] client_id: The client id of the user assigned identity.
        :param pulumi.Input[str] object_id: The object id of the user assigned identity.
        :param pulumi.Input[str] resource_id: The resource id of the user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of the user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user assigned identity.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the user assigned identity.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


