# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSessionHostConfigurationResult',
    'AwaitableGetSessionHostConfigurationResult',
    'get_session_host_configuration',
]

@pulumi.output_type
class GetSessionHostConfigurationResult:
    """
    Represents a SessionHostConfiguration definition.
    """
    def __init__(__self__, disk_type=None, domain_info=None, id=None, image_info=None, name=None, system_data=None, type=None, v_m_size_id=None, version=None, vm_custom_configuration_uri=None):
        if disk_type and not isinstance(disk_type, str):
            raise TypeError("Expected argument 'disk_type' to be a str")
        pulumi.set(__self__, "disk_type", disk_type)
        if domain_info and not isinstance(domain_info, dict):
            raise TypeError("Expected argument 'domain_info' to be a dict")
        pulumi.set(__self__, "domain_info", domain_info)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_info and not isinstance(image_info, dict):
            raise TypeError("Expected argument 'image_info' to be a dict")
        pulumi.set(__self__, "image_info", image_info)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if v_m_size_id and not isinstance(v_m_size_id, str):
            raise TypeError("Expected argument 'v_m_size_id' to be a str")
        pulumi.set(__self__, "v_m_size_id", v_m_size_id)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vm_custom_configuration_uri and not isinstance(vm_custom_configuration_uri, str):
            raise TypeError("Expected argument 'vm_custom_configuration_uri' to be a str")
        pulumi.set(__self__, "vm_custom_configuration_uri", vm_custom_configuration_uri)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The disk type used by virtual machine in hostpool session host.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="domainInfo")
    def domain_info(self) -> Optional['outputs.DomainInfoPropertiesResponse']:
        """
        Domain configurations of session hosts.
        """
        return pulumi.get(self, "domain_info")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageInfo")
    def image_info(self) -> Optional['outputs.ImageInfoPropertiesResponse']:
        """
        Image configurations of HostPool.
        """
        return pulumi.get(self, "image_info")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vMSizeId")
    def v_m_size_id(self) -> Optional[str]:
        """
        The id of the size of a virtual machine connected to a hostpool.
        """
        return pulumi.get(self, "v_m_size_id")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The time when session host configuration was last modified and something was changed.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vmCustomConfigurationUri")
    def vm_custom_configuration_uri(self) -> Optional[str]:
        """
        The uri to the storage blob containing scripts to be run on the virtual machine after provisioning.
        """
        return pulumi.get(self, "vm_custom_configuration_uri")


class AwaitableGetSessionHostConfigurationResult(GetSessionHostConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSessionHostConfigurationResult(
            disk_type=self.disk_type,
            domain_info=self.domain_info,
            id=self.id,
            image_info=self.image_info,
            name=self.name,
            system_data=self.system_data,
            type=self.type,
            v_m_size_id=self.v_m_size_id,
            version=self.version,
            vm_custom_configuration_uri=self.vm_custom_configuration_uri)


def get_session_host_configuration(host_pool_name: Optional[str] = None,
                                   resource_group_name: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSessionHostConfigurationResult:
    """
    Represents a SessionHostConfiguration definition.
    API Version: 2021-05-13-preview.


    :param str host_pool_name: The name of the host pool within the specified resource group
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['hostPoolName'] = host_pool_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:desktopvirtualization:getSessionHostConfiguration', __args__, opts=opts, typ=GetSessionHostConfigurationResult).value

    return AwaitableGetSessionHostConfigurationResult(
        disk_type=__ret__.disk_type,
        domain_info=__ret__.domain_info,
        id=__ret__.id,
        image_info=__ret__.image_info,
        name=__ret__.name,
        system_data=__ret__.system_data,
        type=__ret__.type,
        v_m_size_id=__ret__.v_m_size_id,
        version=__ret__.version,
        vm_custom_configuration_uri=__ret__.vm_custom_configuration_uri)
