# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureIaaSVMProtectionPolicyArgs',
    'AzureSqlProtectionPolicyArgs',
    'DailyRetentionFormatArgs',
    'DailyRetentionScheduleArgs',
    'DayArgs',
    'IdentityDataArgs',
    'LongTermRetentionPolicyArgs',
    'LongTermSchedulePolicyArgs',
    'MabProtectionPolicyArgs',
    'MonthlyRetentionScheduleArgs',
    'RetentionDurationArgs',
    'SimpleRetentionPolicyArgs',
    'SimpleSchedulePolicyArgs',
    'SkuArgs',
    'WeeklyRetentionFormatArgs',
    'WeeklyRetentionScheduleArgs',
    'YearlyRetentionScheduleArgs',
]

@pulumi.input_type
class AzureIaaSVMProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[str]] = None,
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]] = None):
        """
        Azure VM (also known as IaaS VM) workload-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureIaasVM'.
        :param pulumi.Input[int] protected_items_count: The number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: The retention policy with the details on backup copy retention ranges.
        :param pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']] schedule_policy: The backup schedule specified as part of backup policy.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", 'AzureIaasVM')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureIaasVM'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        The retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]:
        """
        The backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]):
        pulumi.set(self, "schedule_policy", value)


@pulumi.input_type
class AzureSqlProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[str]] = None,
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None):
        """
         The Azure SQL workload-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureSql'.
        :param pulumi.Input[int] protected_items_count: The number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: The retention policy details.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", 'AzureSql')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureSql'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        The retention policy details.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)


@pulumi.input_type
class DailyRetentionFormatArgs:
    def __init__(__self__, *,
                 days_of_the_month: Optional[pulumi.Input[Sequence[pulumi.Input['DayArgs']]]] = None):
        """
        Daily retention format.
        :param pulumi.Input[Sequence[pulumi.Input['DayArgs']]] days_of_the_month: List of days of the month.
        """
        if days_of_the_month is not None:
            pulumi.set(__self__, "days_of_the_month", days_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheMonth")
    def days_of_the_month(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayArgs']]]]:
        """
        List of days of the month.
        """
        return pulumi.get(self, "days_of_the_month")

    @days_of_the_month.setter
    def days_of_the_month(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayArgs']]]]):
        pulumi.set(self, "days_of_the_month", value)


@pulumi.input_type
class DailyRetentionScheduleArgs:
    def __init__(__self__, *,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Daily retention schedule.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: The retention duration of retention policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: The retention times of retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        The retention duration of retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


@pulumi.input_type
class DayArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[int]] = None,
                 is_last: Optional[pulumi.Input[bool]] = None):
        """
        Day of the week.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if is_last is not None:
            pulumi.set(__self__, "is_last", is_last)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter(name="isLast")
    def is_last(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_last")

    @is_last.setter
    def is_last(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_last", value)


@pulumi.input_type
class IdentityDataArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ResourceIdentityType']]):
        """
        Identity for the resource.
        :param pulumi.Input[Union[str, 'ResourceIdentityType']] type: The identity type.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ResourceIdentityType']]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ResourceIdentityType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LongTermRetentionPolicyArgs:
    def __init__(__self__, *,
                 daily_schedule: Optional[pulumi.Input['DailyRetentionScheduleArgs']] = None,
                 monthly_schedule: Optional[pulumi.Input['MonthlyRetentionScheduleArgs']] = None,
                 retention_policy_type: Optional[pulumi.Input[str]] = None,
                 weekly_schedule: Optional[pulumi.Input['WeeklyRetentionScheduleArgs']] = None,
                 yearly_schedule: Optional[pulumi.Input['YearlyRetentionScheduleArgs']] = None):
        """
        Long-term retention policy.
        :param pulumi.Input['DailyRetentionScheduleArgs'] daily_schedule: Daily retention schedule of the backup policy.
        :param pulumi.Input['MonthlyRetentionScheduleArgs'] monthly_schedule: Monthly retention schedule of the backup policy.
        :param pulumi.Input[str] retention_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermRetentionPolicy'.
        :param pulumi.Input['WeeklyRetentionScheduleArgs'] weekly_schedule: Weekly retention schedule of the backup policy.
        :param pulumi.Input['YearlyRetentionScheduleArgs'] yearly_schedule: Yearly retention schedule of the backup policy.
        """
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if retention_policy_type is not None:
            pulumi.set(__self__, "retention_policy_type", 'LongTermRetentionPolicy')
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)
        if yearly_schedule is not None:
            pulumi.set(__self__, "yearly_schedule", yearly_schedule)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['DailyRetentionScheduleArgs']]:
        """
        Daily retention schedule of the backup policy.
        """
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['DailyRetentionScheduleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[pulumi.Input['MonthlyRetentionScheduleArgs']]:
        """
        Monthly retention schedule of the backup policy.
        """
        return pulumi.get(self, "monthly_schedule")

    @monthly_schedule.setter
    def monthly_schedule(self, value: Optional[pulumi.Input['MonthlyRetentionScheduleArgs']]):
        pulumi.set(self, "monthly_schedule", value)

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @retention_policy_type.setter
    def retention_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_policy_type", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['WeeklyRetentionScheduleArgs']]:
        """
        Weekly retention schedule of the backup policy.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['WeeklyRetentionScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)

    @property
    @pulumi.getter(name="yearlySchedule")
    def yearly_schedule(self) -> Optional[pulumi.Input['YearlyRetentionScheduleArgs']]:
        """
        Yearly retention schedule of the backup policy.
        """
        return pulumi.get(self, "yearly_schedule")

    @yearly_schedule.setter
    def yearly_schedule(self, value: Optional[pulumi.Input['YearlyRetentionScheduleArgs']]):
        pulumi.set(self, "yearly_schedule", value)


@pulumi.input_type
class LongTermSchedulePolicyArgs:
    def __init__(__self__, *,
                 schedule_policy_type: Optional[pulumi.Input[str]] = None):
        """
        Long-term policy schedule.
        :param pulumi.Input[str] schedule_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermSchedulePolicy'.
        """
        if schedule_policy_type is not None:
            pulumi.set(__self__, "schedule_policy_type", 'LongTermSchedulePolicy')

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @schedule_policy_type.setter
    def schedule_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_policy_type", value)


@pulumi.input_type
class MabProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: Optional[pulumi.Input[str]] = None,
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]] = None):
        """
        The backup policy for the file or folder container.
        :param pulumi.Input[str] backup_management_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'MAB'.
        :param pulumi.Input[int] protected_items_count: The number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: The details specified in the Retention policy.
        :param pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']] schedule_policy: The schedule specified in the backup policy.
        """
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", 'MAB')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'MAB'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        The details specified in the Retention policy.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]:
        """
        The schedule specified in the backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input[Union['LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]):
        pulumi.set(self, "schedule_policy", value)


@pulumi.input_type
class MonthlyRetentionScheduleArgs:
    def __init__(__self__, *,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_schedule_daily: Optional[pulumi.Input['DailyRetentionFormatArgs']] = None,
                 retention_schedule_format_type: Optional[pulumi.Input['RetentionScheduleFormat']] = None,
                 retention_schedule_weekly: Optional[pulumi.Input['WeeklyRetentionFormatArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The monthly retention schedule.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of the retention policy.
        :param pulumi.Input['DailyRetentionFormatArgs'] retention_schedule_daily: Daily retention format for the monthly retention policy.
        :param pulumi.Input['RetentionScheduleFormat'] retention_schedule_format_type: Retention schedule format type for monthly retention policy.
        :param pulumi.Input['WeeklyRetentionFormatArgs'] retention_schedule_weekly: Weekly retention format for the monthly retention policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times of the retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of the retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional[pulumi.Input['DailyRetentionFormatArgs']]:
        """
        Daily retention format for the monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @retention_schedule_daily.setter
    def retention_schedule_daily(self, value: Optional[pulumi.Input['DailyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_daily", value)

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[pulumi.Input['RetentionScheduleFormat']]:
        """
        Retention schedule format type for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @retention_schedule_format_type.setter
    def retention_schedule_format_type(self, value: Optional[pulumi.Input['RetentionScheduleFormat']]):
        pulumi.set(self, "retention_schedule_format_type", value)

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional[pulumi.Input['WeeklyRetentionFormatArgs']]:
        """
        Weekly retention format for the monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @retention_schedule_weekly.setter
    def retention_schedule_weekly(self, value: Optional[pulumi.Input['WeeklyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_weekly", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times of the retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


@pulumi.input_type
class RetentionDurationArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 duration_type: Optional[pulumi.Input['RetentionDurationType']] = None):
        """
        Retention duration.
        :param pulumi.Input[int] count: Count of the duration types. Retention duration is determined by the combining the Count times and durationType. 
                  For example, if Count = 3 and durationType = Weeks, then the retention duration is three weeks.
        :param pulumi.Input['RetentionDurationType'] duration_type: The retention duration type of the retention policy.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count of the duration types. Retention duration is determined by the combining the Count times and durationType. 
           For example, if Count = 3 and durationType = Weeks, then the retention duration is three weeks.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[pulumi.Input['RetentionDurationType']]:
        """
        The retention duration type of the retention policy.
        """
        return pulumi.get(self, "duration_type")

    @duration_type.setter
    def duration_type(self, value: Optional[pulumi.Input['RetentionDurationType']]):
        pulumi.set(self, "duration_type", value)


@pulumi.input_type
class SimpleRetentionPolicyArgs:
    def __init__(__self__, *,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_policy_type: Optional[pulumi.Input[str]] = None):
        """
        Simple policy retention.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of the protection policy.
        :param pulumi.Input[str] retention_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleRetentionPolicy'.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_policy_type is not None:
            pulumi.set(__self__, "retention_policy_type", 'SimpleRetentionPolicy')

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of the protection policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @retention_policy_type.setter
    def retention_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_policy_type", value)


@pulumi.input_type
class SimpleSchedulePolicyArgs:
    def __init__(__self__, *,
                 schedule_policy_type: Optional[pulumi.Input[str]] = None,
                 schedule_run_days: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None,
                 schedule_run_frequency: Optional[pulumi.Input['ScheduleRunType']] = None,
                 schedule_run_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schedule_weekly_frequency: Optional[pulumi.Input[int]] = None):
        """
        Simple policy schedule.
        :param pulumi.Input[str] schedule_policy_type: This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleSchedulePolicy'.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] schedule_run_days: This list is the days of the week when the schedule runs.
        :param pulumi.Input['ScheduleRunType'] schedule_run_frequency: Defines the frequency interval (daily or weekly) for the schedule policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schedule_run_times: List of times, during a day, when the schedule runs.
        :param pulumi.Input[int] schedule_weekly_frequency: The number of times per week the schedule runs.
        """
        if schedule_policy_type is not None:
            pulumi.set(__self__, "schedule_policy_type", 'SimpleSchedulePolicy')
        if schedule_run_days is not None:
            pulumi.set(__self__, "schedule_run_days", schedule_run_days)
        if schedule_run_frequency is not None:
            pulumi.set(__self__, "schedule_run_frequency", schedule_run_frequency)
        if schedule_run_times is not None:
            pulumi.set(__self__, "schedule_run_times", schedule_run_times)
        if schedule_weekly_frequency is not None:
            pulumi.set(__self__, "schedule_weekly_frequency", schedule_weekly_frequency)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        This property is used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @schedule_policy_type.setter
    def schedule_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_policy_type", value)

    @property
    @pulumi.getter(name="scheduleRunDays")
    def schedule_run_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        This list is the days of the week when the schedule runs.
        """
        return pulumi.get(self, "schedule_run_days")

    @schedule_run_days.setter
    def schedule_run_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "schedule_run_days", value)

    @property
    @pulumi.getter(name="scheduleRunFrequency")
    def schedule_run_frequency(self) -> Optional[pulumi.Input['ScheduleRunType']]:
        """
        Defines the frequency interval (daily or weekly) for the schedule policy.
        """
        return pulumi.get(self, "schedule_run_frequency")

    @schedule_run_frequency.setter
    def schedule_run_frequency(self, value: Optional[pulumi.Input['ScheduleRunType']]):
        pulumi.set(self, "schedule_run_frequency", value)

    @property
    @pulumi.getter(name="scheduleRunTimes")
    def schedule_run_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of times, during a day, when the schedule runs.
        """
        return pulumi.get(self, "schedule_run_times")

    @schedule_run_times.setter
    def schedule_run_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schedule_run_times", value)

    @property
    @pulumi.getter(name="scheduleWeeklyFrequency")
    def schedule_weekly_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times per week the schedule runs.
        """
        return pulumi.get(self, "schedule_weekly_frequency")

    @schedule_weekly_frequency.setter
    def schedule_weekly_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "schedule_weekly_frequency", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        Identifies the unique system identifier for each Azure resource.
        :param pulumi.Input[Union[str, 'SkuName']] name: The Sku name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        The Sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class WeeklyRetentionFormatArgs:
    def __init__(__self__, *,
                 days_of_the_week: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None,
                 weeks_of_the_month: Optional[pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]]] = None):
        """
        Weekly retention format.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] days_of_the_week: List of days of the week.
        :param pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]] weeks_of_the_month: List of weeks of the month.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if weeks_of_the_month is not None:
            pulumi.set(__self__, "weeks_of_the_month", weeks_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        List of days of the week.
        """
        return pulumi.get(self, "days_of_the_week")

    @days_of_the_week.setter
    def days_of_the_week(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "days_of_the_week", value)

    @property
    @pulumi.getter(name="weeksOfTheMonth")
    def weeks_of_the_month(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]]]:
        """
        List of weeks of the month.
        """
        return pulumi.get(self, "weeks_of_the_month")

    @weeks_of_the_month.setter
    def weeks_of_the_month(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]]]):
        pulumi.set(self, "weeks_of_the_month", value)


@pulumi.input_type
class WeeklyRetentionScheduleArgs:
    def __init__(__self__, *,
                 days_of_the_week: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Weekly retention schedule.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] days_of_the_week: List of the days of the week for the weekly retention policy.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of retention policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times of the retention policy.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        List of the days of the week for the weekly retention policy.
        """
        return pulumi.get(self, "days_of_the_week")

    @days_of_the_week.setter
    def days_of_the_week(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "days_of_the_week", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times of the retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


@pulumi.input_type
class YearlyRetentionScheduleArgs:
    def __init__(__self__, *,
                 months_of_year: Optional[pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]]] = None,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_schedule_daily: Optional[pulumi.Input['DailyRetentionFormatArgs']] = None,
                 retention_schedule_format_type: Optional[pulumi.Input['RetentionScheduleFormat']] = None,
                 retention_schedule_weekly: Optional[pulumi.Input['WeeklyRetentionFormatArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Yearly retention schedule.
        :param pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]] months_of_year: List of the months of year for the yearly retention policy.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration for the retention policy.
        :param pulumi.Input['DailyRetentionFormatArgs'] retention_schedule_daily: Daily retention format for the yearly retention policy.
        :param pulumi.Input['RetentionScheduleFormat'] retention_schedule_format_type: Retention schedule format for the yearly retention policy.
        :param pulumi.Input['WeeklyRetentionFormatArgs'] retention_schedule_weekly: Weekly retention format for the yearly retention policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times for the retention policy.
        """
        if months_of_year is not None:
            pulumi.set(__self__, "months_of_year", months_of_year)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="monthsOfYear")
    def months_of_year(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]]]:
        """
        List of the months of year for the yearly retention policy.
        """
        return pulumi.get(self, "months_of_year")

    @months_of_year.setter
    def months_of_year(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]]]):
        pulumi.set(self, "months_of_year", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration for the retention policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional[pulumi.Input['DailyRetentionFormatArgs']]:
        """
        Daily retention format for the yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @retention_schedule_daily.setter
    def retention_schedule_daily(self, value: Optional[pulumi.Input['DailyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_daily", value)

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[pulumi.Input['RetentionScheduleFormat']]:
        """
        Retention schedule format for the yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @retention_schedule_format_type.setter
    def retention_schedule_format_type(self, value: Optional[pulumi.Input['RetentionScheduleFormat']]):
        pulumi.set(self, "retention_schedule_format_type", value)

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional[pulumi.Input['WeeklyRetentionFormatArgs']]:
        """
        Weekly retention format for the yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @retention_schedule_weekly.setter
    def retention_schedule_weekly(self, value: Optional[pulumi.Input['WeeklyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_weekly", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times for the retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


