# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDataCollectionEndpointResult',
    'AwaitableGetDataCollectionEndpointResult',
    'get_data_collection_endpoint',
]

@pulumi.output_type
class GetDataCollectionEndpointResult:
    """
    Definition of ARM tracked top level resource.
    """
    def __init__(__self__, configuration_access=None, description=None, etag=None, id=None, immutable_id=None, kind=None, location=None, logs_ingestion=None, name=None, network_acls=None, provisioning_state=None, system_data=None, tags=None, type=None):
        if configuration_access and not isinstance(configuration_access, dict):
            raise TypeError("Expected argument 'configuration_access' to be a dict")
        pulumi.set(__self__, "configuration_access", configuration_access)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if immutable_id and not isinstance(immutable_id, str):
            raise TypeError("Expected argument 'immutable_id' to be a str")
        pulumi.set(__self__, "immutable_id", immutable_id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if logs_ingestion and not isinstance(logs_ingestion, dict):
            raise TypeError("Expected argument 'logs_ingestion' to be a dict")
        pulumi.set(__self__, "logs_ingestion", logs_ingestion)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_acls and not isinstance(network_acls, dict):
            raise TypeError("Expected argument 'network_acls' to be a dict")
        pulumi.set(__self__, "network_acls", network_acls)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="configurationAccess")
    def configuration_access(self) -> Optional['outputs.DataCollectionEndpointResponseConfigurationAccess']:
        """
        The endpoint used by agents to access their configuration.
        """
        return pulumi.get(self, "configuration_access")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the data collection endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Resource entity tag (ETag).
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="immutableId")
    def immutable_id(self) -> Optional[str]:
        """
        The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
        """
        return pulumi.get(self, "immutable_id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The kind of the resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logsIngestion")
    def logs_ingestion(self) -> Optional['outputs.DataCollectionEndpointResponseLogsIngestion']:
        """
        The endpoint used by clients to ingest logs.
        """
        return pulumi.get(self, "logs_ingestion")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional['outputs.DataCollectionEndpointResponseNetworkAcls']:
        """
        Network access control rules for the endpoints.
        """
        return pulumi.get(self, "network_acls")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The resource provisioning state. This property is READ-ONLY.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.DataCollectionEndpointResourceResponseSystemData':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetDataCollectionEndpointResult(GetDataCollectionEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataCollectionEndpointResult(
            configuration_access=self.configuration_access,
            description=self.description,
            etag=self.etag,
            id=self.id,
            immutable_id=self.immutable_id,
            kind=self.kind,
            location=self.location,
            logs_ingestion=self.logs_ingestion,
            name=self.name,
            network_acls=self.network_acls,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_data_collection_endpoint(data_collection_endpoint_name: Optional[str] = None,
                                 resource_group_name: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataCollectionEndpointResult:
    """
    Definition of ARM tracked top level resource.


    :param str data_collection_endpoint_name: The name of the data collection endpoint. The name is case insensitive.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['dataCollectionEndpointName'] = data_collection_endpoint_name
    __args__['resourceGroupName'] = resource_group_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:insights/v20210401:getDataCollectionEndpoint', __args__, opts=opts, typ=GetDataCollectionEndpointResult).value

    return AwaitableGetDataCollectionEndpointResult(
        configuration_access=__ret__.configuration_access,
        description=__ret__.description,
        etag=__ret__.etag,
        id=__ret__.id,
        immutable_id=__ret__.immutable_id,
        kind=__ret__.kind,
        location=__ret__.location,
        logs_ingestion=__ret__.logs_ingestion,
        name=__ret__.name,
        network_acls=__ret__.network_acls,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)
