# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureBackupServerContainerArgs',
    'AzureFileShareProtectionPolicyArgs',
    'AzureFileshareProtectedItemArgs',
    'AzureFileshareProtectedItemExtendedInfoArgs',
    'AzureIaaSClassicComputeVMContainerArgs',
    'AzureIaaSClassicComputeVMProtectedItemArgs',
    'AzureIaaSComputeVMContainerArgs',
    'AzureIaaSComputeVMProtectedItemArgs',
    'AzureIaaSVMProtectedItemArgs',
    'AzureIaaSVMProtectedItemExtendedInfoArgs',
    'AzureIaaSVMProtectionPolicyArgs',
    'AzureSQLAGWorkloadContainerProtectionContainerArgs',
    'AzureSqlContainerArgs',
    'AzureSqlProtectedItemArgs',
    'AzureSqlProtectedItemExtendedInfoArgs',
    'AzureSqlProtectionPolicyArgs',
    'AzureStorageContainerArgs',
    'AzureVMAppContainerProtectionContainerArgs',
    'AzureVmWorkloadProtectedItemArgs',
    'AzureVmWorkloadProtectedItemExtendedInfoArgs',
    'AzureVmWorkloadProtectionPolicyArgs',
    'AzureVmWorkloadSAPAseDatabaseProtectedItemArgs',
    'AzureVmWorkloadSAPHanaDatabaseProtectedItemArgs',
    'AzureVmWorkloadSQLDatabaseProtectedItemArgs',
    'AzureWorkloadContainerArgs',
    'AzureWorkloadContainerExtendedInfoArgs',
    'ContainerIdentityInfoArgs',
    'DPMContainerExtendedInfoArgs',
    'DPMProtectedItemArgs',
    'DPMProtectedItemExtendedInfoArgs',
    'DailyRetentionFormatArgs',
    'DailyRetentionScheduleArgs',
    'DayArgs',
    'DiskExclusionPropertiesArgs',
    'DistributedNodesInfoArgs',
    'DpmContainerArgs',
    'ExtendedPropertiesArgs',
    'GenericContainerArgs',
    'GenericContainerExtendedInfoArgs',
    'GenericProtectedItemArgs',
    'GenericProtectionPolicyArgs',
    'IaaSVMContainerArgs',
    'InquiryInfoArgs',
    'InquiryValidationArgs',
    'InstantRPAdditionalDetailsArgs',
    'KPIResourceHealthDetailsArgs',
    'LogSchedulePolicyArgs',
    'LongTermRetentionPolicyArgs',
    'LongTermSchedulePolicyArgs',
    'MABContainerHealthDetailsArgs',
    'MabContainerArgs',
    'MabContainerExtendedInfoArgs',
    'MabFileFolderProtectedItemArgs',
    'MabFileFolderProtectedItemExtendedInfoArgs',
    'MabProtectionPolicyArgs',
    'MonthlyRetentionScheduleArgs',
    'PrivateEndpointArgs',
    'PrivateEndpointConnectionArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'RetentionDurationArgs',
    'SettingsArgs',
    'SimpleRetentionPolicyArgs',
    'SimpleSchedulePolicyArgs',
    'SubProtectionPolicyArgs',
    'WeeklyRetentionFormatArgs',
    'WeeklyRetentionScheduleArgs',
    'WorkloadInquiryDetailsArgs',
    'YearlyRetentionScheduleArgs',
]

@pulumi.input_type
class AzureBackupServerContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 can_re_register: Optional[pulumi.Input[bool]] = None,
                 container_id: Optional[pulumi.Input[str]] = None,
                 dpm_agent_version: Optional[pulumi.Input[str]] = None,
                 dpm_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_info: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 upgrade_available: Optional[pulumi.Input[bool]] = None):
        """
        AzureBackupServer (DPMVenus) workload-specific protection container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureBackupServerContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[bool] can_re_register: Specifies whether the container is re-registrable.
        :param pulumi.Input[str] container_id: ID of container.
        :param pulumi.Input[str] dpm_agent_version: Backup engine Agent version
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dpm_servers: List of BackupEngines protecting the container
        :param pulumi.Input['DPMContainerExtendedInfoArgs'] extended_info: Extended Info of the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[float] protected_item_count: Number of protected items in the BackupEngine
        :param pulumi.Input[str] protection_status: Protection status of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[bool] upgrade_available: To check if upgrade available
        """
        pulumi.set(__self__, "container_type", 'AzureBackupServerContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureBackupServerContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @can_re_register.setter
    def can_re_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_re_register", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @dpm_agent_version.setter
    def dpm_agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpm_agent_version", value)

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @dpm_servers.setter
    def dpm_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dpm_servers", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")

    @upgrade_available.setter
    def upgrade_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_available", value)


@pulumi.input_type
class AzureFileShareProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: pulumi.Input[str],
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 work_load_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        AzureStorage backup policy.
        :param pulumi.Input[str] backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureStorage'.
        :param pulumi.Input[int] protected_items_count: Number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: Retention policy with the details on backup copy retention ranges.
        :param pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']] schedule_policy: Backup schedule specified as part of backup policy.
        :param pulumi.Input[str] time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        :param pulumi.Input[Union[str, 'WorkloadType']] work_load_type: Type of workload for the backup management
        """
        pulumi.set(__self__, "backup_management_type", 'AzureStorage')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if work_load_type is not None:
            pulumi.set(__self__, "work_load_type", work_load_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureStorage'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        Retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]:
        """
        Backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]):
        pulumi.set(self, "schedule_policy", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="workLoadType")
    def work_load_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Type of workload for the backup management
        """
        return pulumi.get(self, "work_load_type")

    @work_load_type.setter
    def work_load_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "work_load_type", value)


@pulumi.input_type
class AzureFileshareProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure File Share workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureFileShareProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs'] extended_info: Additional information with this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the fileshare represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureFileShareProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureFileShareProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs']]:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the fileshare represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureFileshareProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information about Azure File Share backup item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param pulumi.Input[str] policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param pulumi.Input[int] recovery_point_count: Number of available backup copies associated with this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureIaaSClassicComputeVMContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_version: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific backup item representing a classic virtual machine.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param pulumi.Input[str] virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        pulumi.set(__self__, "container_type", 'Microsoft.ClassicCompute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")

    @virtual_machine_version.setter
    def virtual_machine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_version", value)


@pulumi.input_type
class AzureIaaSClassicComputeVMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']] = None,
                 extended_properties: Optional[pulumi.Input['ExtendedPropertiesArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[Union[str, 'HealthStatus']]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        IaaS VM workload-specific backup item representing the Classic Compute VM.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input['ExtendedPropertiesArgs'] extended_properties: Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input[str] friendly_name: Friendly name of the VM represented by this backup item.
        :param pulumi.Input[Union[str, 'HealthStatus']] health_status: Health status of protected item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'Microsoft.ClassicCompute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input['ExtendedPropertiesArgs']]:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input['ExtendedPropertiesArgs']]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[Union[str, 'HealthStatus']]]:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[Union[str, 'HealthStatus']]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureIaaSComputeVMContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_version: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param pulumi.Input[str] virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        pulumi.set(__self__, "container_type", 'Microsoft.Compute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")

    @virtual_machine_version.setter
    def virtual_machine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_version", value)


@pulumi.input_type
class AzureIaaSComputeVMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']] = None,
                 extended_properties: Optional[pulumi.Input['ExtendedPropertiesArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[Union[str, 'HealthStatus']]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input['ExtendedPropertiesArgs'] extended_properties: Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input[str] friendly_name: Friendly name of the VM represented by this backup item.
        :param pulumi.Input[Union[str, 'HealthStatus']] health_status: Health status of protected item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'Microsoft.Compute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input['ExtendedPropertiesArgs']]:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input['ExtendedPropertiesArgs']]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[Union[str, 'HealthStatus']]]:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[Union[str, 'HealthStatus']]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureIaaSVMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']] = None,
                 extended_properties: Optional[pulumi.Input['ExtendedPropertiesArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[Union[str, 'HealthStatus']]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        IaaS VM workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureIaaSVMProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input['ExtendedPropertiesArgs'] extended_properties: Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input[str] friendly_name: Friendly name of the VM represented by this backup item.
        :param pulumi.Input[Union[str, 'HealthStatus']] health_status: Health status of protected item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureIaaSVMProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureIaaSVMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input['ExtendedPropertiesArgs']]:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input['ExtendedPropertiesArgs']]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[Union[str, 'HealthStatus']]]:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[Union[str, 'HealthStatus']]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureIaaSVMProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_inconsistent: Optional[pulumi.Input[bool]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on Azure IaaS VM specific backup item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this backup item.
        :param pulumi.Input[bool] policy_inconsistent: Specifies if backup policy associated with the backup item is inconsistent.
        :param pulumi.Input[int] recovery_point_count: Number of backup copies available for this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_inconsistent is not None:
            pulumi.set(__self__, "policy_inconsistent", policy_inconsistent)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this backup item.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyInconsistent")
    def policy_inconsistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if backup policy associated with the backup item is inconsistent.
        """
        return pulumi.get(self, "policy_inconsistent")

    @policy_inconsistent.setter
    def policy_inconsistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "policy_inconsistent", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureIaaSVMProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: pulumi.Input[str],
                 instant_rp_details: Optional[pulumi.Input['InstantRPAdditionalDetailsArgs']] = None,
                 instant_rp_retention_range_in_days: Optional[pulumi.Input[int]] = None,
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureIaasVM'.
        :param pulumi.Input[int] instant_rp_retention_range_in_days: Instant RP retention policy range in days
        :param pulumi.Input[int] protected_items_count: Number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: Retention policy with the details on backup copy retention ranges.
        :param pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']] schedule_policy: Backup schedule specified as part of backup policy.
        :param pulumi.Input[str] time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        pulumi.set(__self__, "backup_management_type", 'AzureIaasVM')
        if instant_rp_details is not None:
            pulumi.set(__self__, "instant_rp_details", instant_rp_details)
        if instant_rp_retention_range_in_days is not None:
            pulumi.set(__self__, "instant_rp_retention_range_in_days", instant_rp_retention_range_in_days)
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureIaasVM'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="instantRPDetails")
    def instant_rp_details(self) -> Optional[pulumi.Input['InstantRPAdditionalDetailsArgs']]:
        return pulumi.get(self, "instant_rp_details")

    @instant_rp_details.setter
    def instant_rp_details(self, value: Optional[pulumi.Input['InstantRPAdditionalDetailsArgs']]):
        pulumi.set(self, "instant_rp_details", value)

    @property
    @pulumi.getter(name="instantRpRetentionRangeInDays")
    def instant_rp_retention_range_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Instant RP retention policy range in days
        """
        return pulumi.get(self, "instant_rp_retention_range_in_days")

    @instant_rp_retention_range_in_days.setter
    def instant_rp_retention_range_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instant_rp_retention_range_in_days", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        Retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]:
        """
        Backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]):
        pulumi.set(self, "schedule_policy", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class AzureSQLAGWorkloadContainerProtectionContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 extended_info: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[Union[str, 'OperationType']]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Container for SQL workloads under SQL Availability Group.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'SQLAGWorkLoadContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input['AzureWorkloadContainerExtendedInfoArgs'] extended_info: Additional details of a workload container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] last_updated_time: Time stamp when this container was updated.
        :param pulumi.Input[Union[str, 'OperationType']] operation_type: Re-Do Operation
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param pulumi.Input[Union[str, 'WorkloadType']] workload_type: Workload type for which registration was sent.
        """
        pulumi.set(__self__, "container_type", 'SQLAGWorkLoadContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'SQLAGWorkLoadContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[Union[str, 'OperationType']]]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[Union[str, 'OperationType']]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureSqlContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None):
        """
        Azure Sql workload-specific container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureSqlContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        pulumi.set(__self__, "container_type", 'AzureSqlContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureSqlContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)


@pulumi.input_type
class AzureSqlProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs']] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure SQL workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        :param pulumi.Input[Union[str, 'ProtectedItemState']] protection_state: Backup state of the backed up item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'Microsoft.Sql/servers/databases')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]:
        """
        Backup state of the backed up item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureSqlProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on Azure Sql specific protected item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param pulumi.Input[str] policy_state: State of the backup policy associated with this backup item.
        :param pulumi.Input[int] recovery_point_count: Number of available backup copies associated with this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the backup policy associated with this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureSqlProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: pulumi.Input[str],
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None):
        """
        Azure SQL workload-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureSql'.
        :param pulumi.Input[int] protected_items_count: Number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: Retention policy details.
        """
        pulumi.set(__self__, "backup_management_type", 'AzureSql')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureSql'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        Retention policy details.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)


@pulumi.input_type
class AzureStorageContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 storage_account_version: Optional[pulumi.Input[str]] = None):
        """
        Azure Storage Account workload-specific container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'StorageContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[float] protected_item_count: Number of items backed up in this container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: Fully qualified ARM url.
        :param pulumi.Input[str] storage_account_version: Storage account version.
        """
        pulumi.set(__self__, "container_type", 'StorageContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if storage_account_version is not None:
            pulumi.set(__self__, "storage_account_version", storage_account_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'StorageContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="storageAccountVersion")
    def storage_account_version(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account version.
        """
        return pulumi.get(self, "storage_account_version")

    @storage_account_version.setter
    def storage_account_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_version", value)


@pulumi.input_type
class AzureVMAppContainerProtectionContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 extended_info: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[Union[str, 'OperationType']]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Container for SQL workloads under Azure Virtual Machines.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'VMAppContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input['AzureWorkloadContainerExtendedInfoArgs'] extended_info: Additional details of a workload container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] last_updated_time: Time stamp when this container was updated.
        :param pulumi.Input[Union[str, 'OperationType']] operation_type: Re-Do Operation
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param pulumi.Input[Union[str, 'WorkloadType']] workload_type: Workload type for which registration was sent.
        """
        pulumi.set(__self__, "container_type", 'VMAppContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'VMAppContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[Union[str, 'OperationType']]]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[Union[str, 'OperationType']]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on Azure Workload for SQL specific backup item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this backup item.
        :param pulumi.Input[str] policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param pulumi.Input[int] recovery_point_count: Number of backup copies available for this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this backup item.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureVmWorkloadProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: pulumi.Input[str],
                 make_policy_consistent: Optional[pulumi.Input[bool]] = None,
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 settings: Optional[pulumi.Input['SettingsArgs']] = None,
                 sub_protection_policy: Optional[pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]]] = None,
                 work_load_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Azure VM (Mercury) workload-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'AzureWorkload'.
        :param pulumi.Input[bool] make_policy_consistent: Fix the policy inconsistency
        :param pulumi.Input[int] protected_items_count: Number of items associated with this policy.
        :param pulumi.Input['SettingsArgs'] settings: Common settings for the backup management
        :param pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]] sub_protection_policy: List of sub-protection policies which includes schedule and retention
        :param pulumi.Input[Union[str, 'WorkloadType']] work_load_type: Type of workload for the backup management
        """
        pulumi.set(__self__, "backup_management_type", 'AzureWorkload')
        if make_policy_consistent is not None:
            pulumi.set(__self__, "make_policy_consistent", make_policy_consistent)
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if sub_protection_policy is not None:
            pulumi.set(__self__, "sub_protection_policy", sub_protection_policy)
        if work_load_type is not None:
            pulumi.set(__self__, "work_load_type", work_load_type)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'AzureWorkload'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="makePolicyConsistent")
    def make_policy_consistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Fix the policy inconsistency
        """
        return pulumi.get(self, "make_policy_consistent")

    @make_policy_consistent.setter
    def make_policy_consistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "make_policy_consistent", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['SettingsArgs']]:
        """
        Common settings for the backup management
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['SettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="subProtectionPolicy")
    def sub_protection_policy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]]]:
        """
        List of sub-protection policies which includes schedule and retention
        """
        return pulumi.get(self, "sub_protection_policy")

    @sub_protection_policy.setter
    def sub_protection_policy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]]]):
        pulumi.set(self, "sub_protection_policy", value)

    @property
    @pulumi.getter(name="workLoadType")
    def work_load_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Type of workload for the backup management
        """
        return pulumi.get(self, "work_load_type")

    @work_load_type.setter
    def work_load_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "work_load_type", value)


@pulumi.input_type
class AzureVmWorkloadSAPAseDatabaseProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item representing SAP ASE Database.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPAseDatabase')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadSAPHanaDatabaseProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item representing SAP HANA Database.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPHanaDatabase')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadSQLDatabaseProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item representing SQL Database.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSQLDatabase'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSQLDatabase')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSQLDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureWorkloadContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 extended_info: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[Union[str, 'OperationType']]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'WorkloadType']]] = None):
        """
        Container for the workloads running inside Azure Compute or Classic Compute.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'AzureWorkloadContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input['AzureWorkloadContainerExtendedInfoArgs'] extended_info: Additional details of a workload container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] last_updated_time: Time stamp when this container was updated.
        :param pulumi.Input[Union[str, 'OperationType']] operation_type: Re-Do Operation
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] source_resource_id: ARM ID of the virtual machine represented by this Azure Workload Container
        :param pulumi.Input[Union[str, 'WorkloadType']] workload_type: Workload type for which registration was sent.
        """
        pulumi.set(__self__, "container_type", 'AzureWorkloadContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'AzureWorkloadContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]:
        """
        Additional details of a workload container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureWorkloadContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[Union[str, 'OperationType']]]:
        """
        Re-Do Operation
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[Union[str, 'OperationType']]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the virtual machine represented by this Azure Workload Container
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'WorkloadType']]]:
        """
        Workload type for which registration was sent.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'WorkloadType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureWorkloadContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 host_server_name: Optional[pulumi.Input[str]] = None,
                 inquiry_info: Optional[pulumi.Input['InquiryInfoArgs']] = None,
                 nodes_list: Optional[pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]]] = None):
        """
        Extended information of the container.
        :param pulumi.Input[str] host_server_name: Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        :param pulumi.Input['InquiryInfoArgs'] inquiry_info: Inquiry Status for the container.
        :param pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]] nodes_list: List of the nodes in case of distributed container.
        """
        if host_server_name is not None:
            pulumi.set(__self__, "host_server_name", host_server_name)
        if inquiry_info is not None:
            pulumi.set(__self__, "inquiry_info", inquiry_info)
        if nodes_list is not None:
            pulumi.set(__self__, "nodes_list", nodes_list)

    @property
    @pulumi.getter(name="hostServerName")
    def host_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
        """
        return pulumi.get(self, "host_server_name")

    @host_server_name.setter
    def host_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_server_name", value)

    @property
    @pulumi.getter(name="inquiryInfo")
    def inquiry_info(self) -> Optional[pulumi.Input['InquiryInfoArgs']]:
        """
        Inquiry Status for the container.
        """
        return pulumi.get(self, "inquiry_info")

    @inquiry_info.setter
    def inquiry_info(self, value: Optional[pulumi.Input['InquiryInfoArgs']]):
        pulumi.set(self, "inquiry_info", value)

    @property
    @pulumi.getter(name="nodesList")
    def nodes_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]]]:
        """
        List of the nodes in case of distributed container.
        """
        return pulumi.get(self, "nodes_list")

    @nodes_list.setter
    def nodes_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributedNodesInfoArgs']]]]):
        pulumi.set(self, "nodes_list", value)


@pulumi.input_type
class ContainerIdentityInfoArgs:
    def __init__(__self__, *,
                 aad_tenant_id: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 service_principal_client_id: Optional[pulumi.Input[str]] = None,
                 unique_name: Optional[pulumi.Input[str]] = None):
        """
        Container identity information
        :param pulumi.Input[str] aad_tenant_id: Protection container identity - AAD Tenant
        :param pulumi.Input[str] audience: Protection container identity - Audience
        :param pulumi.Input[str] service_principal_client_id: Protection container identity - AAD Service Principal
        :param pulumi.Input[str] unique_name: Unique name of the container
        """
        if aad_tenant_id is not None:
            pulumi.set(__self__, "aad_tenant_id", aad_tenant_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if service_principal_client_id is not None:
            pulumi.set(__self__, "service_principal_client_id", service_principal_client_id)
        if unique_name is not None:
            pulumi.set(__self__, "unique_name", unique_name)

    @property
    @pulumi.getter(name="aadTenantId")
    def aad_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Protection container identity - AAD Tenant
        """
        return pulumi.get(self, "aad_tenant_id")

    @aad_tenant_id.setter
    def aad_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_tenant_id", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Protection container identity - Audience
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="servicePrincipalClientId")
    def service_principal_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Protection container identity - AAD Service Principal
        """
        return pulumi.get(self, "service_principal_client_id")

    @service_principal_client_id.setter
    def service_principal_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_client_id", value)

    @property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the container
        """
        return pulumi.get(self, "unique_name")

    @unique_name.setter
    def unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_name", value)


@pulumi.input_type
class DPMContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None):
        """
        Additional information of the DPMContainer.
        :param pulumi.Input[str] last_refreshed_at: Last refresh time of the DPMContainer.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last refresh time of the DPMContainer.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)


@pulumi.input_type
class DPMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_engine_name: Optional[pulumi.Input[str]] = None,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['DPMProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Additional information on Backup engine specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'DPMProtectedItem'.
        :param pulumi.Input[str] backup_engine_name: Backup Management server protecting this backup item
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['DPMProtectedItemExtendedInfoArgs'] extended_info: Extended info of the backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the managed item
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[Union[str, 'ProtectedItemState']] protection_state: Protection state of the backup engine
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'DPMProtectedItem')
        if backup_engine_name is not None:
            pulumi.set(__self__, "backup_engine_name", backup_engine_name)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'DPMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupEngineName")
    def backup_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        Backup Management server protecting this backup item
        """
        return pulumi.get(self, "backup_engine_name")

    @backup_engine_name.setter
    def backup_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_engine_name", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['DPMProtectedItemExtendedInfoArgs']]:
        """
        Extended info of the backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['DPMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the managed item
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]:
        """
        Protection state of the backup engine
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class DPMProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 disk_storage_used_in_bytes: Optional[pulumi.Input[str]] = None,
                 is_collocated: Optional[pulumi.Input[bool]] = None,
                 is_present_on_cloud: Optional[pulumi.Input[bool]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 on_premise_latest_recovery_point: Optional[pulumi.Input[str]] = None,
                 on_premise_oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 on_premise_recovery_point_count: Optional[pulumi.Input[int]] = None,
                 protectable_object_load_path: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protected: Optional[pulumi.Input[bool]] = None,
                 protection_group_name: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None,
                 total_disk_storage_size_in_bytes: Optional[pulumi.Input[str]] = None):
        """
        Additional information of DPM Protected item.
        :param pulumi.Input[str] disk_storage_used_in_bytes: Used Disk storage in bytes.
        :param pulumi.Input[bool] is_collocated: To check if backup item is collocated.
        :param pulumi.Input[bool] is_present_on_cloud: To check if backup item is cloud protected.
        :param pulumi.Input[str] last_backup_status: Last backup status information on backup item.
        :param pulumi.Input[str] last_refreshed_at: Last refresh time on backup item.
        :param pulumi.Input[str] oldest_recovery_point: Oldest cloud recovery point time.
        :param pulumi.Input[str] on_premise_latest_recovery_point: latest disk recovery point time.
        :param pulumi.Input[str] on_premise_oldest_recovery_point: Oldest disk recovery point time.
        :param pulumi.Input[int] on_premise_recovery_point_count: disk recovery point count.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] protectable_object_load_path: Attribute to provide information on various DBs.
        :param pulumi.Input[bool] protected: To check if backup item is disk protected.
        :param pulumi.Input[str] protection_group_name: Protection group name of the backup item.
        :param pulumi.Input[int] recovery_point_count: cloud recovery point count.
        :param pulumi.Input[str] total_disk_storage_size_in_bytes: total Disk storage in bytes.
        """
        if disk_storage_used_in_bytes is not None:
            pulumi.set(__self__, "disk_storage_used_in_bytes", disk_storage_used_in_bytes)
        if is_collocated is not None:
            pulumi.set(__self__, "is_collocated", is_collocated)
        if is_present_on_cloud is not None:
            pulumi.set(__self__, "is_present_on_cloud", is_present_on_cloud)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if on_premise_latest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_latest_recovery_point", on_premise_latest_recovery_point)
        if on_premise_oldest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_oldest_recovery_point", on_premise_oldest_recovery_point)
        if on_premise_recovery_point_count is not None:
            pulumi.set(__self__, "on_premise_recovery_point_count", on_premise_recovery_point_count)
        if protectable_object_load_path is not None:
            pulumi.set(__self__, "protectable_object_load_path", protectable_object_load_path)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if protection_group_name is not None:
            pulumi.set(__self__, "protection_group_name", protection_group_name)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)
        if total_disk_storage_size_in_bytes is not None:
            pulumi.set(__self__, "total_disk_storage_size_in_bytes", total_disk_storage_size_in_bytes)

    @property
    @pulumi.getter(name="diskStorageUsedInBytes")
    def disk_storage_used_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Used Disk storage in bytes.
        """
        return pulumi.get(self, "disk_storage_used_in_bytes")

    @disk_storage_used_in_bytes.setter
    def disk_storage_used_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_storage_used_in_bytes", value)

    @property
    @pulumi.getter(name="isCollocated")
    def is_collocated(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if backup item is collocated.
        """
        return pulumi.get(self, "is_collocated")

    @is_collocated.setter
    def is_collocated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_collocated", value)

    @property
    @pulumi.getter(name="isPresentOnCloud")
    def is_present_on_cloud(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if backup item is cloud protected.
        """
        return pulumi.get(self, "is_present_on_cloud")

    @is_present_on_cloud.setter
    def is_present_on_cloud(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_present_on_cloud", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup status information on backup item.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last refresh time on backup item.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Oldest cloud recovery point time.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="onPremiseLatestRecoveryPoint")
    def on_premise_latest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        latest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_latest_recovery_point")

    @on_premise_latest_recovery_point.setter
    def on_premise_latest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_premise_latest_recovery_point", value)

    @property
    @pulumi.getter(name="onPremiseOldestRecoveryPoint")
    def on_premise_oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Oldest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_oldest_recovery_point")

    @on_premise_oldest_recovery_point.setter
    def on_premise_oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_premise_oldest_recovery_point", value)

    @property
    @pulumi.getter(name="onPremiseRecoveryPointCount")
    def on_premise_recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        disk recovery point count.
        """
        return pulumi.get(self, "on_premise_recovery_point_count")

    @on_premise_recovery_point_count.setter
    def on_premise_recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_premise_recovery_point_count", value)

    @property
    @pulumi.getter(name="protectableObjectLoadPath")
    def protectable_object_load_path(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Attribute to provide information on various DBs.
        """
        return pulumi.get(self, "protectable_object_load_path")

    @protectable_object_load_path.setter
    def protectable_object_load_path(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "protectable_object_load_path", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if backup item is disk protected.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter(name="protectionGroupName")
    def protection_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Protection group name of the backup item.
        """
        return pulumi.get(self, "protection_group_name")

    @protection_group_name.setter
    def protection_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_group_name", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        cloud recovery point count.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)

    @property
    @pulumi.getter(name="totalDiskStorageSizeInBytes")
    def total_disk_storage_size_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        total Disk storage in bytes.
        """
        return pulumi.get(self, "total_disk_storage_size_in_bytes")

    @total_disk_storage_size_in_bytes.setter
    def total_disk_storage_size_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_disk_storage_size_in_bytes", value)


@pulumi.input_type
class DailyRetentionFormatArgs:
    def __init__(__self__, *,
                 days_of_the_month: Optional[pulumi.Input[Sequence[pulumi.Input['DayArgs']]]] = None):
        """
        Daily retention format.
        :param pulumi.Input[Sequence[pulumi.Input['DayArgs']]] days_of_the_month: List of days of the month.
        """
        if days_of_the_month is not None:
            pulumi.set(__self__, "days_of_the_month", days_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheMonth")
    def days_of_the_month(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayArgs']]]]:
        """
        List of days of the month.
        """
        return pulumi.get(self, "days_of_the_month")

    @days_of_the_month.setter
    def days_of_the_month(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayArgs']]]]):
        pulumi.set(self, "days_of_the_month", value)


@pulumi.input_type
class DailyRetentionScheduleArgs:
    def __init__(__self__, *,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Daily retention schedule.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of retention Policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times of retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


@pulumi.input_type
class DayArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[int]] = None,
                 is_last: Optional[pulumi.Input[bool]] = None):
        """
        Day of the week.
        :param pulumi.Input[int] date: Date of the month
        :param pulumi.Input[bool] is_last: Whether Date is last date of month
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if is_last is not None:
            pulumi.set(__self__, "is_last", is_last)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[int]]:
        """
        Date of the month
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter(name="isLast")
    def is_last(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Date is last date of month
        """
        return pulumi.get(self, "is_last")

    @is_last.setter
    def is_last(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_last", value)


@pulumi.input_type
class DiskExclusionPropertiesArgs:
    def __init__(__self__, *,
                 disk_lun_list: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 is_inclusion_list: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        :param pulumi.Input[bool] is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        if disk_lun_list is not None:
            pulumi.set(__self__, "disk_lun_list", disk_lun_list)
        if is_inclusion_list is not None:
            pulumi.set(__self__, "is_inclusion_list", is_inclusion_list)

    @property
    @pulumi.getter(name="diskLunList")
    def disk_lun_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        """
        return pulumi.get(self, "disk_lun_list")

    @disk_lun_list.setter
    def disk_lun_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "disk_lun_list", value)

    @property
    @pulumi.getter(name="isInclusionList")
    def is_inclusion_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        return pulumi.get(self, "is_inclusion_list")

    @is_inclusion_list.setter
    def is_inclusion_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_inclusion_list", value)


@pulumi.input_type
class DistributedNodesInfoArgs:
    def __init__(__self__, *,
                 node_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        This is used to represent the various nodes of the distributed container.
        :param pulumi.Input[str] node_name: Name of the node under a distributed container.
        :param pulumi.Input[str] status: Status of this Node.
               Failed | Succeeded
        """
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the node under a distributed container.
        """
        return pulumi.get(self, "node_name")

    @node_name.setter
    def node_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of this Node.
        Failed | Succeeded
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class DpmContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 can_re_register: Optional[pulumi.Input[bool]] = None,
                 container_id: Optional[pulumi.Input[str]] = None,
                 dpm_agent_version: Optional[pulumi.Input[str]] = None,
                 dpm_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extended_info: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 upgrade_available: Optional[pulumi.Input[bool]] = None):
        """
        DPM workload-specific protection container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'DPMContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[bool] can_re_register: Specifies whether the container is re-registrable.
        :param pulumi.Input[str] container_id: ID of container.
        :param pulumi.Input[str] dpm_agent_version: Backup engine Agent version
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dpm_servers: List of BackupEngines protecting the container
        :param pulumi.Input['DPMContainerExtendedInfoArgs'] extended_info: Extended Info of the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[float] protected_item_count: Number of protected items in the BackupEngine
        :param pulumi.Input[str] protection_status: Protection status of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[bool] upgrade_available: To check if upgrade available
        """
        pulumi.set(__self__, "container_type", 'DPMContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if dpm_agent_version is not None:
            pulumi.set(__self__, "dpm_agent_version", dpm_agent_version)
        if dpm_servers is not None:
            pulumi.set(__self__, "dpm_servers", dpm_servers)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if upgrade_available is not None:
            pulumi.set(__self__, "upgrade_available", upgrade_available)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'DPMContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the container is re-registrable.
        """
        return pulumi.get(self, "can_re_register")

    @can_re_register.setter
    def can_re_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_re_register", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="dpmAgentVersion")
    def dpm_agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Backup engine Agent version
        """
        return pulumi.get(self, "dpm_agent_version")

    @dpm_agent_version.setter
    def dpm_agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dpm_agent_version", value)

    @property
    @pulumi.getter(name="dpmServers")
    def dpm_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of BackupEngines protecting the container
        """
        return pulumi.get(self, "dpm_servers")

    @dpm_servers.setter
    def dpm_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dpm_servers", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]:
        """
        Extended Info of the container.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['DPMContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of protected items in the BackupEngine
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Protection status of the container.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="upgradeAvailable")
    def upgrade_available(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if upgrade available
        """
        return pulumi.get(self, "upgrade_available")

    @upgrade_available.setter
    def upgrade_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "upgrade_available", value)


@pulumi.input_type
class ExtendedPropertiesArgs:
    def __init__(__self__, *,
                 disk_exclusion_properties: Optional[pulumi.Input['DiskExclusionPropertiesArgs']] = None):
        """
        Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input['DiskExclusionPropertiesArgs'] disk_exclusion_properties: Extended Properties for Disk Exclusion.
        """
        if disk_exclusion_properties is not None:
            pulumi.set(__self__, "disk_exclusion_properties", disk_exclusion_properties)

    @property
    @pulumi.getter(name="diskExclusionProperties")
    def disk_exclusion_properties(self) -> Optional[pulumi.Input['DiskExclusionPropertiesArgs']]:
        """
        Extended Properties for Disk Exclusion.
        """
        return pulumi.get(self, "disk_exclusion_properties")

    @disk_exclusion_properties.setter
    def disk_exclusion_properties(self, value: Optional[pulumi.Input['DiskExclusionPropertiesArgs']]):
        pulumi.set(self, "disk_exclusion_properties", value)


@pulumi.input_type
class GenericContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 extended_information: Optional[pulumi.Input['GenericContainerExtendedInfoArgs']] = None,
                 fabric_name: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None):
        """
        Base class for generic container of backup items
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'GenericContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input['GenericContainerExtendedInfoArgs'] extended_information: Extended information (not returned in List container API calls)
        :param pulumi.Input[str] fabric_name: Name of the container's fabric
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        pulumi.set(__self__, "container_type", 'GenericContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if extended_information is not None:
            pulumi.set(__self__, "extended_information", extended_information)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'GenericContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="extendedInformation")
    def extended_information(self) -> Optional[pulumi.Input['GenericContainerExtendedInfoArgs']]:
        """
        Extended information (not returned in List container API calls)
        """
        return pulumi.get(self, "extended_information")

    @extended_information.setter
    def extended_information(self, value: Optional[pulumi.Input['GenericContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_information", value)

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container's fabric
        """
        return pulumi.get(self, "fabric_name")

    @fabric_name.setter
    def fabric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_name", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)


@pulumi.input_type
class GenericContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 container_identity_info: Optional[pulumi.Input['ContainerIdentityInfoArgs']] = None,
                 raw_cert_data: Optional[pulumi.Input[str]] = None,
                 service_endpoints: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container extended information
        :param pulumi.Input['ContainerIdentityInfoArgs'] container_identity_info: Container identity information
        :param pulumi.Input[str] raw_cert_data: Public key of container cert
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_endpoints: Azure Backup Service Endpoints for the container
        """
        if container_identity_info is not None:
            pulumi.set(__self__, "container_identity_info", container_identity_info)
        if raw_cert_data is not None:
            pulumi.set(__self__, "raw_cert_data", raw_cert_data)
        if service_endpoints is not None:
            pulumi.set(__self__, "service_endpoints", service_endpoints)

    @property
    @pulumi.getter(name="containerIdentityInfo")
    def container_identity_info(self) -> Optional[pulumi.Input['ContainerIdentityInfoArgs']]:
        """
        Container identity information
        """
        return pulumi.get(self, "container_identity_info")

    @container_identity_info.setter
    def container_identity_info(self, value: Optional[pulumi.Input['ContainerIdentityInfoArgs']]):
        pulumi.set(self, "container_identity_info", value)

    @property
    @pulumi.getter(name="rawCertData")
    def raw_cert_data(self) -> Optional[pulumi.Input[str]]:
        """
        Public key of container cert
        """
        return pulumi.get(self, "raw_cert_data")

    @raw_cert_data.setter
    def raw_cert_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "raw_cert_data", value)

    @property
    @pulumi.getter(name="serviceEndpoints")
    def service_endpoints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Azure Backup Service Endpoints for the container
        """
        return pulumi.get(self, "service_endpoints")

    @service_endpoints.setter
    def service_endpoints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "service_endpoints", value)


@pulumi.input_type
class GenericProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 fabric_name: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 protected_item_id: Optional[pulumi.Input[float]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 source_associations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Base class for backup items.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'GenericProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input[str] fabric_name: Name of this backup item's fabric.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param pulumi.Input[float] protected_item_id: Data Plane Service ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_associations: Loosely coupled (type, value) associations (example - parent of a protected item)
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'GenericProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if protected_item_id is not None:
            pulumi.set(__self__, "protected_item_id", protected_item_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_associations is not None:
            pulumi.set(__self__, "source_associations", source_associations)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'GenericProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this backup item's fabric.
        """
        return pulumi.get(self, "fabric_name")

    @fabric_name.setter
    def fabric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_name", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="protectedItemId")
    def protected_item_id(self) -> Optional[pulumi.Input[float]]:
        """
        Data Plane Service ID of the protected item.
        """
        return pulumi.get(self, "protected_item_id")

    @protected_item_id.setter
    def protected_item_id(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceAssociations")
    def source_associations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Loosely coupled (type, value) associations (example - parent of a protected item)
        """
        return pulumi.get(self, "source_associations")

    @source_associations.setter
    def source_associations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_associations", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class GenericProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: pulumi.Input[str],
                 fabric_name: Optional[pulumi.Input[str]] = None,
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 sub_protection_policy: Optional[pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Azure VM (Mercury) workload-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'GenericProtectionPolicy'.
        :param pulumi.Input[str] fabric_name: Name of this policy's fabric.
        :param pulumi.Input[int] protected_items_count: Number of items associated with this policy.
        :param pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]] sub_protection_policy: List of sub-protection policies which includes schedule and retention
        :param pulumi.Input[str] time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        pulumi.set(__self__, "backup_management_type", 'GenericProtectionPolicy')
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if sub_protection_policy is not None:
            pulumi.set(__self__, "sub_protection_policy", sub_protection_policy)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'GenericProtectionPolicy'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this policy's fabric.
        """
        return pulumi.get(self, "fabric_name")

    @fabric_name.setter
    def fabric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_name", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="subProtectionPolicy")
    def sub_protection_policy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]]]:
        """
        List of sub-protection policies which includes schedule and retention
        """
        return pulumi.get(self, "sub_protection_policy")

    @sub_protection_policy.setter
    def sub_protection_policy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubProtectionPolicyArgs']]]]):
        pulumi.set(self, "sub_protection_policy", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class IaaSVMContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_version: Optional[pulumi.Input[str]] = None):
        """
        IaaS VM workload-specific container.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'IaaSVMContainer'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        :param pulumi.Input[str] resource_group: Resource group name of Recovery Services Vault.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        :param pulumi.Input[str] virtual_machine_version: Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        pulumi.set(__self__, "container_type", 'IaaSVMContainer')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if virtual_machine_version is not None:
            pulumi.set(__self__, "virtual_machine_version", virtual_machine_version)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'IaaSVMContainer'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Resource group name of Recovery Services Vault.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="virtualMachineVersion")
    def virtual_machine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the container represents a Classic or an Azure Resource Manager VM.
        """
        return pulumi.get(self, "virtual_machine_version")

    @virtual_machine_version.setter
    def virtual_machine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_version", value)


@pulumi.input_type
class InquiryInfoArgs:
    def __init__(__self__, *,
                 inquiry_details: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Details about inquired protectable items under a given container.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]] inquiry_details: Inquiry Details which will have workload specific details.
               For e.g. - For SQL and oracle this will contain different details.
        :param pulumi.Input[str] status: Inquiry Status for this container such as
               InProgress | Failed | Succeeded
        """
        if inquiry_details is not None:
            pulumi.set(__self__, "inquiry_details", inquiry_details)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="inquiryDetails")
    def inquiry_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]]]:
        """
        Inquiry Details which will have workload specific details.
        For e.g. - For SQL and oracle this will contain different details.
        """
        return pulumi.get(self, "inquiry_details")

    @inquiry_details.setter
    def inquiry_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadInquiryDetailsArgs']]]]):
        pulumi.set(self, "inquiry_details", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Inquiry Status for this container such as
        InProgress | Failed | Succeeded
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class InquiryValidationArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Validation for inquired protectable items under a given container.
        :param pulumi.Input[str] status: Status for the Inquiry Validation.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status for the Inquiry Validation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class InstantRPAdditionalDetailsArgs:
    def __init__(__self__, *,
                 azure_backup_rg_name_prefix: Optional[pulumi.Input[str]] = None,
                 azure_backup_rg_name_suffix: Optional[pulumi.Input[str]] = None):
        if azure_backup_rg_name_prefix is not None:
            pulumi.set(__self__, "azure_backup_rg_name_prefix", azure_backup_rg_name_prefix)
        if azure_backup_rg_name_suffix is not None:
            pulumi.set(__self__, "azure_backup_rg_name_suffix", azure_backup_rg_name_suffix)

    @property
    @pulumi.getter(name="azureBackupRGNamePrefix")
    def azure_backup_rg_name_prefix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "azure_backup_rg_name_prefix")

    @azure_backup_rg_name_prefix.setter
    def azure_backup_rg_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_backup_rg_name_prefix", value)

    @property
    @pulumi.getter(name="azureBackupRGNameSuffix")
    def azure_backup_rg_name_suffix(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "azure_backup_rg_name_suffix")

    @azure_backup_rg_name_suffix.setter
    def azure_backup_rg_name_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_backup_rg_name_suffix", value)


@pulumi.input_type
class KPIResourceHealthDetailsArgs:
    def __init__(__self__, *,
                 resource_health_status: Optional[pulumi.Input[Union[str, 'ResourceHealthStatus']]] = None):
        """
        KPI Resource Health Details
        :param pulumi.Input[Union[str, 'ResourceHealthStatus']] resource_health_status: Resource Health Status
        """
        if resource_health_status is not None:
            pulumi.set(__self__, "resource_health_status", resource_health_status)

    @property
    @pulumi.getter(name="resourceHealthStatus")
    def resource_health_status(self) -> Optional[pulumi.Input[Union[str, 'ResourceHealthStatus']]]:
        """
        Resource Health Status
        """
        return pulumi.get(self, "resource_health_status")

    @resource_health_status.setter
    def resource_health_status(self, value: Optional[pulumi.Input[Union[str, 'ResourceHealthStatus']]]):
        pulumi.set(self, "resource_health_status", value)


@pulumi.input_type
class LogSchedulePolicyArgs:
    def __init__(__self__, *,
                 schedule_policy_type: pulumi.Input[str],
                 schedule_frequency_in_mins: Optional[pulumi.Input[int]] = None):
        """
        Log policy schedule.
        :param pulumi.Input[str] schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LogSchedulePolicy'.
        :param pulumi.Input[int] schedule_frequency_in_mins: Frequency of the log schedule operation of this policy in minutes.
        """
        pulumi.set(__self__, "schedule_policy_type", 'LogSchedulePolicy')
        if schedule_frequency_in_mins is not None:
            pulumi.set(__self__, "schedule_frequency_in_mins", schedule_frequency_in_mins)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LogSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @schedule_policy_type.setter
    def schedule_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_policy_type", value)

    @property
    @pulumi.getter(name="scheduleFrequencyInMins")
    def schedule_frequency_in_mins(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency of the log schedule operation of this policy in minutes.
        """
        return pulumi.get(self, "schedule_frequency_in_mins")

    @schedule_frequency_in_mins.setter
    def schedule_frequency_in_mins(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "schedule_frequency_in_mins", value)


@pulumi.input_type
class LongTermRetentionPolicyArgs:
    def __init__(__self__, *,
                 retention_policy_type: pulumi.Input[str],
                 daily_schedule: Optional[pulumi.Input['DailyRetentionScheduleArgs']] = None,
                 monthly_schedule: Optional[pulumi.Input['MonthlyRetentionScheduleArgs']] = None,
                 weekly_schedule: Optional[pulumi.Input['WeeklyRetentionScheduleArgs']] = None,
                 yearly_schedule: Optional[pulumi.Input['YearlyRetentionScheduleArgs']] = None):
        """
        Long term retention policy.
        :param pulumi.Input[str] retention_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermRetentionPolicy'.
        :param pulumi.Input['DailyRetentionScheduleArgs'] daily_schedule: Daily retention schedule of the protection policy.
        :param pulumi.Input['MonthlyRetentionScheduleArgs'] monthly_schedule: Monthly retention schedule of the protection policy.
        :param pulumi.Input['WeeklyRetentionScheduleArgs'] weekly_schedule: Weekly retention schedule of the protection policy.
        :param pulumi.Input['YearlyRetentionScheduleArgs'] yearly_schedule: Yearly retention schedule of the protection policy.
        """
        pulumi.set(__self__, "retention_policy_type", 'LongTermRetentionPolicy')
        if daily_schedule is not None:
            pulumi.set(__self__, "daily_schedule", daily_schedule)
        if monthly_schedule is not None:
            pulumi.set(__self__, "monthly_schedule", monthly_schedule)
        if weekly_schedule is not None:
            pulumi.set(__self__, "weekly_schedule", weekly_schedule)
        if yearly_schedule is not None:
            pulumi.set(__self__, "yearly_schedule", yearly_schedule)

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @retention_policy_type.setter
    def retention_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "retention_policy_type", value)

    @property
    @pulumi.getter(name="dailySchedule")
    def daily_schedule(self) -> Optional[pulumi.Input['DailyRetentionScheduleArgs']]:
        """
        Daily retention schedule of the protection policy.
        """
        return pulumi.get(self, "daily_schedule")

    @daily_schedule.setter
    def daily_schedule(self, value: Optional[pulumi.Input['DailyRetentionScheduleArgs']]):
        pulumi.set(self, "daily_schedule", value)

    @property
    @pulumi.getter(name="monthlySchedule")
    def monthly_schedule(self) -> Optional[pulumi.Input['MonthlyRetentionScheduleArgs']]:
        """
        Monthly retention schedule of the protection policy.
        """
        return pulumi.get(self, "monthly_schedule")

    @monthly_schedule.setter
    def monthly_schedule(self, value: Optional[pulumi.Input['MonthlyRetentionScheduleArgs']]):
        pulumi.set(self, "monthly_schedule", value)

    @property
    @pulumi.getter(name="weeklySchedule")
    def weekly_schedule(self) -> Optional[pulumi.Input['WeeklyRetentionScheduleArgs']]:
        """
        Weekly retention schedule of the protection policy.
        """
        return pulumi.get(self, "weekly_schedule")

    @weekly_schedule.setter
    def weekly_schedule(self, value: Optional[pulumi.Input['WeeklyRetentionScheduleArgs']]):
        pulumi.set(self, "weekly_schedule", value)

    @property
    @pulumi.getter(name="yearlySchedule")
    def yearly_schedule(self) -> Optional[pulumi.Input['YearlyRetentionScheduleArgs']]:
        """
        Yearly retention schedule of the protection policy.
        """
        return pulumi.get(self, "yearly_schedule")

    @yearly_schedule.setter
    def yearly_schedule(self, value: Optional[pulumi.Input['YearlyRetentionScheduleArgs']]):
        pulumi.set(self, "yearly_schedule", value)


@pulumi.input_type
class LongTermSchedulePolicyArgs:
    def __init__(__self__, *,
                 schedule_policy_type: pulumi.Input[str]):
        """
        Long term policy schedule.
        :param pulumi.Input[str] schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'LongTermSchedulePolicy'.
        """
        pulumi.set(__self__, "schedule_policy_type", 'LongTermSchedulePolicy')

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'LongTermSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @schedule_policy_type.setter
    def schedule_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_policy_type", value)


@pulumi.input_type
class MABContainerHealthDetailsArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 recommendations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        MAB workload-specific Health Details.
        :param pulumi.Input[int] code: Health Code
        :param pulumi.Input[str] message: Health Message
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recommendations: Health Recommended Actions
        :param pulumi.Input[str] title: Health Title
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if recommendations is not None:
            pulumi.set(__self__, "recommendations", recommendations)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        Health Code
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Health Message
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def recommendations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Health Recommended Actions
        """
        return pulumi.get(self, "recommendations")

    @recommendations.setter
    def recommendations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "recommendations", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Health Title
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class MabContainerArgs:
    def __init__(__self__, *,
                 container_type: pulumi.Input[str],
                 agent_version: Optional[pulumi.Input[str]] = None,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 can_re_register: Optional[pulumi.Input[bool]] = None,
                 container_health_state: Optional[pulumi.Input[str]] = None,
                 container_id: Optional[pulumi.Input[float]] = None,
                 extended_info: Optional[pulumi.Input['MabContainerExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[str]] = None,
                 mab_container_health_details: Optional[pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]]] = None,
                 protected_item_count: Optional[pulumi.Input[float]] = None,
                 registration_status: Optional[pulumi.Input[str]] = None):
        """
        Container with items backed up using MAB backup engine.
        :param pulumi.Input[str] container_type: Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
               Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
               Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
               Backup is VMAppContainer
               Expected value is 'Windows'.
        :param pulumi.Input[str] agent_version: Agent version of this container.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the container.
        :param pulumi.Input[bool] can_re_register: Can the container be registered one more time.
        :param pulumi.Input[str] container_health_state: Health state of mab container.
        :param pulumi.Input[float] container_id: ContainerID represents the container.
        :param pulumi.Input['MabContainerExtendedInfoArgs'] extended_info: Additional information for this container
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[str] health_status: Status of health of the container.
        :param pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]] mab_container_health_details: Health details on this mab container.
        :param pulumi.Input[float] protected_item_count: Number of items backed up in this container.
        :param pulumi.Input[str] registration_status: Status of registration of the container with the Recovery Services Vault.
        """
        pulumi.set(__self__, "container_type", 'Windows')
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if can_re_register is not None:
            pulumi.set(__self__, "can_re_register", can_re_register)
        if container_health_state is not None:
            pulumi.set(__self__, "container_health_state", container_health_state)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if mab_container_health_details is not None:
            pulumi.set(__self__, "mab_container_health_details", mab_container_health_details)
        if protected_item_count is not None:
            pulumi.set(__self__, "protected_item_count", protected_item_count)
        if registration_status is not None:
            pulumi.set(__self__, "registration_status", registration_status)

    @property
    @pulumi.getter(name="containerType")
    def container_type(self) -> pulumi.Input[str]:
        """
        Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
        Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
        Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
        Backup is VMAppContainer
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "container_type")

    @container_type.setter
    def container_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_type", value)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[str]]:
        """
        Agent version of this container.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the container.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="canReRegister")
    def can_re_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Can the container be registered one more time.
        """
        return pulumi.get(self, "can_re_register")

    @can_re_register.setter
    def can_re_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_re_register", value)

    @property
    @pulumi.getter(name="containerHealthState")
    def container_health_state(self) -> Optional[pulumi.Input[str]]:
        """
        Health state of mab container.
        """
        return pulumi.get(self, "container_health_state")

    @container_health_state.setter
    def container_health_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_health_state", value)

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[pulumi.Input[float]]:
        """
        ContainerID represents the container.
        """
        return pulumi.get(self, "container_id")

    @container_id.setter
    def container_id(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "container_id", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['MabContainerExtendedInfoArgs']]:
        """
        Additional information for this container
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['MabContainerExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of health of the container.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="mabContainerHealthDetails")
    def mab_container_health_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]]]:
        """
        Health details on this mab container.
        """
        return pulumi.get(self, "mab_container_health_details")

    @mab_container_health_details.setter
    def mab_container_health_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MABContainerHealthDetailsArgs']]]]):
        pulumi.set(self, "mab_container_health_details", value)

    @property
    @pulumi.getter(name="protectedItemCount")
    def protected_item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Number of items backed up in this container.
        """
        return pulumi.get(self, "protected_item_count")

    @protected_item_count.setter
    def protected_item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_count", value)

    @property
    @pulumi.getter(name="registrationStatus")
    def registration_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of registration of the container with the Recovery Services Vault.
        """
        return pulumi.get(self, "registration_status")

    @registration_status.setter
    def registration_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_status", value)


@pulumi.input_type
class MabContainerExtendedInfoArgs:
    def __init__(__self__, *,
                 backup_item_type: Optional[pulumi.Input[Union[str, 'BackupItemType']]] = None,
                 backup_items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        Additional information of the container.
        :param pulumi.Input[Union[str, 'BackupItemType']] backup_item_type: Type of backup items associated with this container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_items: List of backup items associated with this container.
        :param pulumi.Input[str] last_backup_status: Latest backup status of this container.
        :param pulumi.Input[str] last_refreshed_at: Time stamp when this container was refreshed.
        :param pulumi.Input[str] policy_name: Backup policy associated with this container.
        """
        if backup_item_type is not None:
            pulumi.set(__self__, "backup_item_type", backup_item_type)
        if backup_items is not None:
            pulumi.set(__self__, "backup_items", backup_items)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="backupItemType")
    def backup_item_type(self) -> Optional[pulumi.Input[Union[str, 'BackupItemType']]]:
        """
        Type of backup items associated with this container.
        """
        return pulumi.get(self, "backup_item_type")

    @backup_item_type.setter
    def backup_item_type(self, value: Optional[pulumi.Input[Union[str, 'BackupItemType']]]):
        pulumi.set(self, "backup_item_type", value)

    @property
    @pulumi.getter(name="backupItems")
    def backup_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of backup items associated with this container.
        """
        return pulumi.get(self, "backup_items")

    @backup_items.setter
    def backup_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_items", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Latest backup status of this container.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time stamp when this container was refreshed.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        Backup policy associated with this container.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


@pulumi.input_type
class MabFileFolderProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 computer_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_sync_time_in_utc: Optional[pulumi.Input[float]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        MAB workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'MabFileFolderProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] computer_name: Name of the computer associated with this backup item.
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[float] deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs'] extended_info: Additional information with this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_backup_status: Status of last backup operation.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protection_state: Protected, ProtectionStopped, IRPending or ProtectionError
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'MabFileFolderProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_sync_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_sync_time_in_utc", deferred_delete_sync_time_in_utc)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'MabFileFolderProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the computer associated with this backup item.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteSyncTimeInUTC")
    def deferred_delete_sync_time_in_utc(self) -> Optional[pulumi.Input[float]]:
        """
        Sync time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_sync_time_in_utc")

    @deferred_delete_sync_time_in_utc.setter
    def deferred_delete_sync_time_in_utc(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "deferred_delete_sync_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs']]:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of last backup operation.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[str]]:
        """
        Protected, ProtectionStopped, IRPending or ProtectionError
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class MabFileFolderProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on the backed up item.
        :param pulumi.Input[str] last_refreshed_at: Last time when the agent data synced to service.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available.
        :param pulumi.Input[int] recovery_point_count: Number of backup copies associated with the backup item.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last time when the agent data synced to service.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of backup copies associated with the backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class MabProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup_management_type: pulumi.Input[str],
                 protected_items_count: Optional[pulumi.Input[int]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]] = None):
        """
        Mab container-specific backup policy.
        :param pulumi.Input[str] backup_management_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'MAB'.
        :param pulumi.Input[int] protected_items_count: Number of items associated with this policy.
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: Retention policy details.
        :param pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']] schedule_policy: Backup schedule of backup policy.
        """
        pulumi.set(__self__, "backup_management_type", 'MAB')
        if protected_items_count is not None:
            pulumi.set(__self__, "protected_items_count", protected_items_count)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'MAB'.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="protectedItemsCount")
    def protected_items_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of items associated with this policy.
        """
        return pulumi.get(self, "protected_items_count")

    @protected_items_count.setter
    def protected_items_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protected_items_count", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        Retention policy details.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]:
        """
        Backup schedule of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]):
        pulumi.set(self, "schedule_policy", value)


@pulumi.input_type
class MonthlyRetentionScheduleArgs:
    def __init__(__self__, *,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_schedule_daily: Optional[pulumi.Input['DailyRetentionFormatArgs']] = None,
                 retention_schedule_format_type: Optional[pulumi.Input[Union[str, 'RetentionScheduleFormat']]] = None,
                 retention_schedule_weekly: Optional[pulumi.Input['WeeklyRetentionFormatArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Monthly retention schedule.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of retention Policy.
        :param pulumi.Input['DailyRetentionFormatArgs'] retention_schedule_daily: Daily retention format for monthly retention policy.
        :param pulumi.Input[Union[str, 'RetentionScheduleFormat']] retention_schedule_format_type: Retention schedule format type for monthly retention policy.
        :param pulumi.Input['WeeklyRetentionFormatArgs'] retention_schedule_weekly: Weekly retention format for monthly retention policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times of retention policy.
        """
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional[pulumi.Input['DailyRetentionFormatArgs']]:
        """
        Daily retention format for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @retention_schedule_daily.setter
    def retention_schedule_daily(self, value: Optional[pulumi.Input['DailyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_daily", value)

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[pulumi.Input[Union[str, 'RetentionScheduleFormat']]]:
        """
        Retention schedule format type for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @retention_schedule_format_type.setter
    def retention_schedule_format_type(self, value: Optional[pulumi.Input[Union[str, 'RetentionScheduleFormat']]]):
        pulumi.set(self, "retention_schedule_format_type", value)

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional[pulumi.Input['WeeklyRetentionFormatArgs']]:
        """
        Weekly retention format for monthly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @retention_schedule_weekly.setter
    def retention_schedule_weekly(self, value: Optional[pulumi.Input['WeeklyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_weekly", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


@pulumi.input_type
class PrivateEndpointArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The Private Endpoint network resource that is linked to the Private Endpoint connection
        :param pulumi.Input[str] id: Gets or sets id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateEndpointConnectionArgs:
    def __init__(__self__, *,
                 private_endpoint: Optional[pulumi.Input['PrivateEndpointArgs']] = None,
                 private_link_service_connection_state: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']] = None,
                 provisioning_state: Optional[pulumi.Input[Union[str, 'ProvisioningState']]] = None):
        """
        Private Endpoint Connection Response Properties
        :param pulumi.Input['PrivateEndpointArgs'] private_endpoint: Gets or sets private endpoint associated with the private endpoint connection
        :param pulumi.Input['PrivateLinkServiceConnectionStateArgs'] private_link_service_connection_state: Gets or sets private link service connection state
        :param pulumi.Input[Union[str, 'ProvisioningState']] provisioning_state: Gets or sets provisioning state of the private endpoint connection
        """
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['PrivateEndpointArgs']]:
        """
        Gets or sets private endpoint associated with the private endpoint connection
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['PrivateEndpointArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]:
        """
        Gets or sets private link service connection state
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @private_link_service_connection_state.setter
    def private_link_service_connection_state(self, value: Optional[pulumi.Input['PrivateLinkServiceConnectionStateArgs']]):
        pulumi.set(self, "private_link_service_connection_state", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[Union[str, 'ProvisioningState']]]:
        """
        Gets or sets provisioning state of the private endpoint connection
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[Union[str, 'ProvisioningState']]]):
        pulumi.set(self, "provisioning_state", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 action_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointConnectionStatus']]] = None):
        """
        Private Link Service Connection State
        :param pulumi.Input[str] action_required: Gets or sets actions required
        :param pulumi.Input[str] description: Gets or sets description
        :param pulumi.Input[Union[str, 'PrivateEndpointConnectionStatus']] status: Gets or sets the status
        """
        if action_required is not None:
            pulumi.set(__self__, "action_required", action_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionRequired")
    def action_required(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets actions required
        """
        return pulumi.get(self, "action_required")

    @action_required.setter
    def action_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointConnectionStatus']]]:
        """
        Gets or sets the status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RetentionDurationArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[int]] = None,
                 duration_type: Optional[pulumi.Input[Union[str, 'RetentionDurationType']]] = None):
        """
        Retention duration.
        :param pulumi.Input[int] count: Count of duration types. Retention duration is obtained by the counting the duration type Count times.
               For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
        :param pulumi.Input[Union[str, 'RetentionDurationType']] duration_type: Retention duration type of retention policy.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        Count of duration types. Retention duration is obtained by the counting the duration type Count times.
        For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[pulumi.Input[Union[str, 'RetentionDurationType']]]:
        """
        Retention duration type of retention policy.
        """
        return pulumi.get(self, "duration_type")

    @duration_type.setter
    def duration_type(self, value: Optional[pulumi.Input[Union[str, 'RetentionDurationType']]]):
        pulumi.set(self, "duration_type", value)


@pulumi.input_type
class SettingsArgs:
    def __init__(__self__, *,
                 is_compression: Optional[pulumi.Input[bool]] = None,
                 issqlcompression: Optional[pulumi.Input[bool]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Common settings field for backup management
        :param pulumi.Input[bool] is_compression: Workload compression flag. This has been added so that 'isSqlCompression'
               will be deprecated once clients upgrade to consider this flag.
        :param pulumi.Input[bool] issqlcompression: SQL compression flag
        :param pulumi.Input[str] time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        if is_compression is not None:
            pulumi.set(__self__, "is_compression", is_compression)
        if issqlcompression is not None:
            pulumi.set(__self__, "issqlcompression", issqlcompression)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="isCompression")
    def is_compression(self) -> Optional[pulumi.Input[bool]]:
        """
        Workload compression flag. This has been added so that 'isSqlCompression'
        will be deprecated once clients upgrade to consider this flag.
        """
        return pulumi.get(self, "is_compression")

    @is_compression.setter
    def is_compression(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_compression", value)

    @property
    @pulumi.getter
    def issqlcompression(self) -> Optional[pulumi.Input[bool]]:
        """
        SQL compression flag
        """
        return pulumi.get(self, "issqlcompression")

    @issqlcompression.setter
    def issqlcompression(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issqlcompression", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class SimpleRetentionPolicyArgs:
    def __init__(__self__, *,
                 retention_policy_type: pulumi.Input[str],
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None):
        """
        Simple policy retention.
        :param pulumi.Input[str] retention_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleRetentionPolicy'.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of the protection policy.
        """
        pulumi.set(__self__, "retention_policy_type", 'SimpleRetentionPolicy')
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)

    @property
    @pulumi.getter(name="retentionPolicyType")
    def retention_policy_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleRetentionPolicy'.
        """
        return pulumi.get(self, "retention_policy_type")

    @retention_policy_type.setter
    def retention_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "retention_policy_type", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of the protection policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)


@pulumi.input_type
class SimpleSchedulePolicyArgs:
    def __init__(__self__, *,
                 schedule_policy_type: pulumi.Input[str],
                 schedule_run_days: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None,
                 schedule_run_frequency: Optional[pulumi.Input[Union[str, 'ScheduleRunType']]] = None,
                 schedule_run_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schedule_weekly_frequency: Optional[pulumi.Input[int]] = None):
        """
        Simple policy schedule.
        :param pulumi.Input[str] schedule_policy_type: This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
               Expected value is 'SimpleSchedulePolicy'.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] schedule_run_days: List of days of week this schedule has to be run.
        :param pulumi.Input[Union[str, 'ScheduleRunType']] schedule_run_frequency: Frequency of the schedule operation of this policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schedule_run_times: List of times of day this schedule has to be run.
        :param pulumi.Input[int] schedule_weekly_frequency: At every number weeks this schedule has to be run.
        """
        pulumi.set(__self__, "schedule_policy_type", 'SimpleSchedulePolicy')
        if schedule_run_days is not None:
            pulumi.set(__self__, "schedule_run_days", schedule_run_days)
        if schedule_run_frequency is not None:
            pulumi.set(__self__, "schedule_run_frequency", schedule_run_frequency)
        if schedule_run_times is not None:
            pulumi.set(__self__, "schedule_run_times", schedule_run_times)
        if schedule_weekly_frequency is not None:
            pulumi.set(__self__, "schedule_weekly_frequency", schedule_weekly_frequency)

    @property
    @pulumi.getter(name="schedulePolicyType")
    def schedule_policy_type(self) -> pulumi.Input[str]:
        """
        This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
        Expected value is 'SimpleSchedulePolicy'.
        """
        return pulumi.get(self, "schedule_policy_type")

    @schedule_policy_type.setter
    def schedule_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_policy_type", value)

    @property
    @pulumi.getter(name="scheduleRunDays")
    def schedule_run_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        List of days of week this schedule has to be run.
        """
        return pulumi.get(self, "schedule_run_days")

    @schedule_run_days.setter
    def schedule_run_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "schedule_run_days", value)

    @property
    @pulumi.getter(name="scheduleRunFrequency")
    def schedule_run_frequency(self) -> Optional[pulumi.Input[Union[str, 'ScheduleRunType']]]:
        """
        Frequency of the schedule operation of this policy.
        """
        return pulumi.get(self, "schedule_run_frequency")

    @schedule_run_frequency.setter
    def schedule_run_frequency(self, value: Optional[pulumi.Input[Union[str, 'ScheduleRunType']]]):
        pulumi.set(self, "schedule_run_frequency", value)

    @property
    @pulumi.getter(name="scheduleRunTimes")
    def schedule_run_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of times of day this schedule has to be run.
        """
        return pulumi.get(self, "schedule_run_times")

    @schedule_run_times.setter
    def schedule_run_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schedule_run_times", value)

    @property
    @pulumi.getter(name="scheduleWeeklyFrequency")
    def schedule_weekly_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        At every number weeks this schedule has to be run.
        """
        return pulumi.get(self, "schedule_weekly_frequency")

    @schedule_weekly_frequency.setter
    def schedule_weekly_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "schedule_weekly_frequency", value)


@pulumi.input_type
class SubProtectionPolicyArgs:
    def __init__(__self__, *,
                 policy_type: Optional[pulumi.Input[Union[str, 'PolicyType']]] = None,
                 retention_policy: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]] = None,
                 schedule_policy: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]] = None):
        """
        Sub-protection policy which includes schedule and retention
        :param pulumi.Input[Union[str, 'PolicyType']] policy_type: Type of backup policy type
        :param pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']] retention_policy: Retention policy with the details on backup copy retention ranges.
        :param pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']] schedule_policy: Backup schedule specified as part of backup policy.
        """
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if schedule_policy is not None:
            pulumi.set(__self__, "schedule_policy", schedule_policy)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[Union[str, 'PolicyType']]]:
        """
        Type of backup policy type
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[Union[str, 'PolicyType']]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]:
        """
        Retention policy with the details on backup copy retention ranges.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[Union['LongTermRetentionPolicyArgs', 'SimpleRetentionPolicyArgs']]]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="schedulePolicy")
    def schedule_policy(self) -> Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]:
        """
        Backup schedule specified as part of backup policy.
        """
        return pulumi.get(self, "schedule_policy")

    @schedule_policy.setter
    def schedule_policy(self, value: Optional[pulumi.Input[Union['LogSchedulePolicyArgs', 'LongTermSchedulePolicyArgs', 'SimpleSchedulePolicyArgs']]]):
        pulumi.set(self, "schedule_policy", value)


@pulumi.input_type
class WeeklyRetentionFormatArgs:
    def __init__(__self__, *,
                 days_of_the_week: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None,
                 weeks_of_the_month: Optional[pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]]] = None):
        """
        Weekly retention format.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] days_of_the_week: List of days of the week.
        :param pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]] weeks_of_the_month: List of weeks of month.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if weeks_of_the_month is not None:
            pulumi.set(__self__, "weeks_of_the_month", weeks_of_the_month)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        List of days of the week.
        """
        return pulumi.get(self, "days_of_the_week")

    @days_of_the_week.setter
    def days_of_the_week(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "days_of_the_week", value)

    @property
    @pulumi.getter(name="weeksOfTheMonth")
    def weeks_of_the_month(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]]]:
        """
        List of weeks of month.
        """
        return pulumi.get(self, "weeks_of_the_month")

    @weeks_of_the_month.setter
    def weeks_of_the_month(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WeekOfMonth']]]]):
        pulumi.set(self, "weeks_of_the_month", value)


@pulumi.input_type
class WeeklyRetentionScheduleArgs:
    def __init__(__self__, *,
                 days_of_the_week: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Weekly retention schedule.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] days_of_the_week: List of days of week for weekly retention policy.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of retention Policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times of retention policy.
        """
        if days_of_the_week is not None:
            pulumi.set(__self__, "days_of_the_week", days_of_the_week)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="daysOfTheWeek")
    def days_of_the_week(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        List of days of week for weekly retention policy.
        """
        return pulumi.get(self, "days_of_the_week")

    @days_of_the_week.setter
    def days_of_the_week(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "days_of_the_week", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


@pulumi.input_type
class WorkloadInquiryDetailsArgs:
    def __init__(__self__, *,
                 inquiry_validation: Optional[pulumi.Input['InquiryValidationArgs']] = None,
                 item_count: Optional[pulumi.Input[float]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Details of an inquired protectable item.
        :param pulumi.Input['InquiryValidationArgs'] inquiry_validation: Inquiry validation such as permissions and other backup validations.
        :param pulumi.Input[float] item_count: Contains the protectable item Count inside this Container.
        :param pulumi.Input[str] type: Type of the Workload such as SQL, Oracle etc.
        """
        if inquiry_validation is not None:
            pulumi.set(__self__, "inquiry_validation", inquiry_validation)
        if item_count is not None:
            pulumi.set(__self__, "item_count", item_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inquiryValidation")
    def inquiry_validation(self) -> Optional[pulumi.Input['InquiryValidationArgs']]:
        """
        Inquiry validation such as permissions and other backup validations.
        """
        return pulumi.get(self, "inquiry_validation")

    @inquiry_validation.setter
    def inquiry_validation(self, value: Optional[pulumi.Input['InquiryValidationArgs']]):
        pulumi.set(self, "inquiry_validation", value)

    @property
    @pulumi.getter(name="itemCount")
    def item_count(self) -> Optional[pulumi.Input[float]]:
        """
        Contains the protectable item Count inside this Container.
        """
        return pulumi.get(self, "item_count")

    @item_count.setter
    def item_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "item_count", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the Workload such as SQL, Oracle etc.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class YearlyRetentionScheduleArgs:
    def __init__(__self__, *,
                 months_of_year: Optional[pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]]] = None,
                 retention_duration: Optional[pulumi.Input['RetentionDurationArgs']] = None,
                 retention_schedule_daily: Optional[pulumi.Input['DailyRetentionFormatArgs']] = None,
                 retention_schedule_format_type: Optional[pulumi.Input[Union[str, 'RetentionScheduleFormat']]] = None,
                 retention_schedule_weekly: Optional[pulumi.Input['WeeklyRetentionFormatArgs']] = None,
                 retention_times: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Yearly retention schedule.
        :param pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]] months_of_year: List of months of year of yearly retention policy.
        :param pulumi.Input['RetentionDurationArgs'] retention_duration: Retention duration of retention Policy.
        :param pulumi.Input['DailyRetentionFormatArgs'] retention_schedule_daily: Daily retention format for yearly retention policy.
        :param pulumi.Input[Union[str, 'RetentionScheduleFormat']] retention_schedule_format_type: Retention schedule format for yearly retention policy.
        :param pulumi.Input['WeeklyRetentionFormatArgs'] retention_schedule_weekly: Weekly retention format for yearly retention policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] retention_times: Retention times of retention policy.
        """
        if months_of_year is not None:
            pulumi.set(__self__, "months_of_year", months_of_year)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if retention_schedule_daily is not None:
            pulumi.set(__self__, "retention_schedule_daily", retention_schedule_daily)
        if retention_schedule_format_type is not None:
            pulumi.set(__self__, "retention_schedule_format_type", retention_schedule_format_type)
        if retention_schedule_weekly is not None:
            pulumi.set(__self__, "retention_schedule_weekly", retention_schedule_weekly)
        if retention_times is not None:
            pulumi.set(__self__, "retention_times", retention_times)

    @property
    @pulumi.getter(name="monthsOfYear")
    def months_of_year(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]]]:
        """
        List of months of year of yearly retention policy.
        """
        return pulumi.get(self, "months_of_year")

    @months_of_year.setter
    def months_of_year(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonthOfYear']]]]):
        pulumi.set(self, "months_of_year", value)

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[pulumi.Input['RetentionDurationArgs']]:
        """
        Retention duration of retention Policy.
        """
        return pulumi.get(self, "retention_duration")

    @retention_duration.setter
    def retention_duration(self, value: Optional[pulumi.Input['RetentionDurationArgs']]):
        pulumi.set(self, "retention_duration", value)

    @property
    @pulumi.getter(name="retentionScheduleDaily")
    def retention_schedule_daily(self) -> Optional[pulumi.Input['DailyRetentionFormatArgs']]:
        """
        Daily retention format for yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_daily")

    @retention_schedule_daily.setter
    def retention_schedule_daily(self, value: Optional[pulumi.Input['DailyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_daily", value)

    @property
    @pulumi.getter(name="retentionScheduleFormatType")
    def retention_schedule_format_type(self) -> Optional[pulumi.Input[Union[str, 'RetentionScheduleFormat']]]:
        """
        Retention schedule format for yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_format_type")

    @retention_schedule_format_type.setter
    def retention_schedule_format_type(self, value: Optional[pulumi.Input[Union[str, 'RetentionScheduleFormat']]]):
        pulumi.set(self, "retention_schedule_format_type", value)

    @property
    @pulumi.getter(name="retentionScheduleWeekly")
    def retention_schedule_weekly(self) -> Optional[pulumi.Input['WeeklyRetentionFormatArgs']]:
        """
        Weekly retention format for yearly retention policy.
        """
        return pulumi.get(self, "retention_schedule_weekly")

    @retention_schedule_weekly.setter
    def retention_schedule_weekly(self, value: Optional[pulumi.Input['WeeklyRetentionFormatArgs']]):
        pulumi.set(self, "retention_schedule_weekly", value)

    @property
    @pulumi.getter(name="retentionTimes")
    def retention_times(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Retention times of retention policy.
        """
        return pulumi.get(self, "retention_times")

    @retention_times.setter
    def retention_times(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "retention_times", value)


