# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'BackendArgs',
    'BackendPoolArgs',
    'BackendPoolsSettingsArgs',
    'CacheConfigurationArgs',
    'ForwardingConfigurationArgs',
    'FrontendEndpointArgs',
    'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs',
    'HealthProbeSettingsModelArgs',
    'LoadBalancingSettingsModelArgs',
    'RedirectConfigurationArgs',
    'RoutingRuleArgs',
    'SubResourceArgs',
]

@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 backend_host_header: Optional[pulumi.Input[str]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'BackendEnabledState']]] = None,
                 http_port: Optional[pulumi.Input[int]] = None,
                 https_port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Backend address of a frontDoor load balancer.
        :param pulumi.Input[str] address: Location of the backend (IP address or FQDN)
        :param pulumi.Input[str] backend_host_header: The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        :param pulumi.Input[Union[str, 'BackendEnabledState']] enabled_state: Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        :param pulumi.Input[int] http_port: The HTTP TCP port number. Must be between 1 and 65535.
        :param pulumi.Input[int] https_port: The HTTPS TCP port number. Must be between 1 and 65535.
        :param pulumi.Input[int] priority: Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        :param pulumi.Input[int] weight: Weight of this endpoint for load balancing purposes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend_host_header is not None:
            pulumi.set(__self__, "backend_host_header", backend_host_header)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the backend (IP address or FQDN)
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="backendHostHeader")
    def backend_host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        """
        return pulumi.get(self, "backend_host_header")

    @backend_host_header.setter
    def backend_host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_host_header", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'BackendEnabledState']]]:
        """
        Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'BackendEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTPS TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Weight of this endpoint for load balancing purposes.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class BackendPoolArgs:
    def __init__(__self__, *,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]] = None,
                 health_probe_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 load_balancing_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A backend pool is a collection of backends that can be routed to.
        :param pulumi.Input[Sequence[pulumi.Input['BackendArgs']]] backends: The set of backends for this pool
        :param pulumi.Input['SubResourceArgs'] health_probe_settings: L7 health probe settings for a backend pool
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['SubResourceArgs'] load_balancing_settings: Load balancing settings for a backend pool
        :param pulumi.Input[str] name: Resource name.
        """
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if health_probe_settings is not None:
            pulumi.set(__self__, "health_probe_settings", health_probe_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancing_settings is not None:
            pulumi.set(__self__, "load_balancing_settings", load_balancing_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]:
        """
        The set of backends for this pool
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="healthProbeSettings")
    def health_probe_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        L7 health probe settings for a backend pool
        """
        return pulumi.get(self, "health_probe_settings")

    @health_probe_settings.setter
    def health_probe_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "health_probe_settings", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="loadBalancingSettings")
    def load_balancing_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Load balancing settings for a backend pool
        """
        return pulumi.get(self, "load_balancing_settings")

    @load_balancing_settings.setter
    def load_balancing_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "load_balancing_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BackendPoolsSettingsArgs:
    def __init__(__self__, *,
                 enforce_certificate_name_check: Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]] = None,
                 send_recv_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Settings that apply to all backend pools.
        :param pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']] enforce_certificate_name_check: Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        :param pulumi.Input[int] send_recv_timeout_seconds: Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        if enforce_certificate_name_check is None:
            enforce_certificate_name_check = 'Enabled'
        if enforce_certificate_name_check is not None:
            pulumi.set(__self__, "enforce_certificate_name_check", enforce_certificate_name_check)
        if send_recv_timeout_seconds is not None:
            pulumi.set(__self__, "send_recv_timeout_seconds", send_recv_timeout_seconds)

    @property
    @pulumi.getter(name="enforceCertificateNameCheck")
    def enforce_certificate_name_check(self) -> Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]]:
        """
        Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        """
        return pulumi.get(self, "enforce_certificate_name_check")

    @enforce_certificate_name_check.setter
    def enforce_certificate_name_check(self, value: Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]]):
        pulumi.set(self, "enforce_certificate_name_check", value)

    @property
    @pulumi.getter(name="sendRecvTimeoutSeconds")
    def send_recv_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        return pulumi.get(self, "send_recv_timeout_seconds")

    @send_recv_timeout_seconds.setter
    def send_recv_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "send_recv_timeout_seconds", value)


@pulumi.input_type
class CacheConfigurationArgs:
    def __init__(__self__, *,
                 dynamic_compression: Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]] = None,
                 query_parameter_strip_directive: Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]] = None):
        """
        Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
        :param pulumi.Input[Union[str, 'DynamicCompressionEnabled']] dynamic_compression: Whether to use dynamic compression for cached content
        :param pulumi.Input[Union[str, 'FrontDoorQuery']] query_parameter_strip_directive: Treatment of URL query terms when forming the cache key.
        """
        if dynamic_compression is not None:
            pulumi.set(__self__, "dynamic_compression", dynamic_compression)
        if query_parameter_strip_directive is not None:
            pulumi.set(__self__, "query_parameter_strip_directive", query_parameter_strip_directive)

    @property
    @pulumi.getter(name="dynamicCompression")
    def dynamic_compression(self) -> Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]]:
        """
        Whether to use dynamic compression for cached content
        """
        return pulumi.get(self, "dynamic_compression")

    @dynamic_compression.setter
    def dynamic_compression(self, value: Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]]):
        pulumi.set(self, "dynamic_compression", value)

    @property
    @pulumi.getter(name="queryParameterStripDirective")
    def query_parameter_strip_directive(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]]:
        """
        Treatment of URL query terms when forming the cache key.
        """
        return pulumi.get(self, "query_parameter_strip_directive")

    @query_parameter_strip_directive.setter
    def query_parameter_strip_directive(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]]):
        pulumi.set(self, "query_parameter_strip_directive", value)


@pulumi.input_type
class ForwardingConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 backend_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 cache_configuration: Optional[pulumi.Input['CacheConfigurationArgs']] = None,
                 custom_forwarding_path: Optional[pulumi.Input[str]] = None,
                 forwarding_protocol: Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]] = None):
        """
        Describes Forwarding Route.
        :param pulumi.Input[str] odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        :param pulumi.Input['SubResourceArgs'] backend_pool: A reference to the BackendPool which this rule routes to.
        :param pulumi.Input['CacheConfigurationArgs'] cache_configuration: The caching configuration associated with this rule.
        :param pulumi.Input[str] custom_forwarding_path: A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        :param pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']] forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration')
        if backend_pool is not None:
            pulumi.set(__self__, "backend_pool", backend_pool)
        if cache_configuration is not None:
            pulumi.set(__self__, "cache_configuration", cache_configuration)
        if custom_forwarding_path is not None:
            pulumi.set(__self__, "custom_forwarding_path", custom_forwarding_path)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="backendPool")
    def backend_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to the BackendPool which this rule routes to.
        """
        return pulumi.get(self, "backend_pool")

    @backend_pool.setter
    def backend_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_pool", value)

    @property
    @pulumi.getter(name="cacheConfiguration")
    def cache_configuration(self) -> Optional[pulumi.Input['CacheConfigurationArgs']]:
        """
        The caching configuration associated with this rule.
        """
        return pulumi.get(self, "cache_configuration")

    @cache_configuration.setter
    def cache_configuration(self, value: Optional[pulumi.Input['CacheConfigurationArgs']]):
        pulumi.set(self, "cache_configuration", value)

    @property
    @pulumi.getter(name="customForwardingPath")
    def custom_forwarding_path(self) -> Optional[pulumi.Input[str]]:
        """
        A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        """
        return pulumi.get(self, "custom_forwarding_path")

    @custom_forwarding_path.setter
    def custom_forwarding_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_forwarding_path", value)

    @property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]]:
        """
        Protocol this rule will use when forwarding traffic to backends.
        """
        return pulumi.get(self, "forwarding_protocol")

    @forwarding_protocol.setter
    def forwarding_protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]]):
        pulumi.set(self, "forwarding_protocol", value)


@pulumi.input_type
class FrontendEndpointArgs:
    def __init__(__self__, *,
                 host_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 session_affinity_enabled_state: Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]] = None,
                 session_affinity_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 web_application_firewall_policy_link: Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']] = None):
        """
        A frontend endpoint used for routing.
        :param pulumi.Input[str] host_name: The host name of the frontendEndpoint. Must be a domain name.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Union[str, 'SessionAffinityEnabledState']] session_affinity_enabled_state: Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        :param pulumi.Input[int] session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        :param pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs'] web_application_firewall_policy_link: Defines the Web Application Firewall policy for each host (if applicable)
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_affinity_enabled_state is not None:
            pulumi.set(__self__, "session_affinity_enabled_state", session_affinity_enabled_state)
        if session_affinity_ttl_seconds is not None:
            pulumi.set(__self__, "session_affinity_ttl_seconds", session_affinity_ttl_seconds)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of the frontendEndpoint. Must be a domain name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionAffinityEnabledState")
    def session_affinity_enabled_state(self) -> Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]]:
        """
        Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "session_affinity_enabled_state")

    @session_affinity_enabled_state.setter
    def session_affinity_enabled_state(self, value: Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]]):
        pulumi.set(self, "session_affinity_enabled_state", value)

    @property
    @pulumi.getter(name="sessionAffinityTtlSeconds")
    def session_affinity_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        """
        return pulumi.get(self, "session_affinity_ttl_seconds")

    @session_affinity_ttl_seconds.setter
    def session_affinity_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_affinity_ttl_seconds", value)

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']]:
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")

    @web_application_firewall_policy_link.setter
    def web_application_firewall_policy_link(self, value: Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']]):
        pulumi.set(self, "web_application_firewall_policy_link", value)


@pulumi.input_type
class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class HealthProbeSettingsModelArgs:
    def __init__(__self__, *,
                 enabled_state: Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]] = None,
                 health_probe_method: Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]] = None):
        """
        Load balancing settings for a backend pool
        :param pulumi.Input[Union[str, 'HealthProbeEnabled']] enabled_state: Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        :param pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']] health_probe_method: Configures which HTTP method to use to probe the backends defined under backendPools.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] interval_in_seconds: The number of seconds between health probes.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[str] path: The path to use for the health probe. Default is /
        :param pulumi.Input[Union[str, 'FrontDoorProtocol']] protocol: Protocol scheme to use for this probe
        """
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if health_probe_method is None:
            health_probe_method = 'HEAD'
        if health_probe_method is not None:
            pulumi.set(__self__, "health_probe_method", health_probe_method)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]]:
        """
        Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="healthProbeMethod")
    def health_probe_method(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]]:
        """
        Configures which HTTP method to use to probe the backends defined under backendPools.
        """
        return pulumi.get(self, "health_probe_method")

    @health_probe_method.setter
    def health_probe_method(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]]):
        pulumi.set(self, "health_probe_method", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between health probes.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to use for the health probe. Default is /
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]]:
        """
        Protocol scheme to use for this probe
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class LoadBalancingSettingsModelArgs:
    def __init__(__self__, *,
                 additional_latency_milliseconds: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_size: Optional[pulumi.Input[int]] = None,
                 successful_samples_required: Optional[pulumi.Input[int]] = None):
        """
        Load balancing settings for a backend pool
        :param pulumi.Input[int] additional_latency_milliseconds: The additional latency in milliseconds for probes to fall into the lowest latency bucket
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[int] sample_size: The number of samples to consider for load balancing decisions
        :param pulumi.Input[int] successful_samples_required: The number of samples within the sample period that must succeed
        """
        if additional_latency_milliseconds is not None:
            pulumi.set(__self__, "additional_latency_milliseconds", additional_latency_milliseconds)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if successful_samples_required is not None:
            pulumi.set(__self__, "successful_samples_required", successful_samples_required)

    @property
    @pulumi.getter(name="additionalLatencyMilliseconds")
    def additional_latency_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        The additional latency in milliseconds for probes to fall into the lowest latency bucket
        """
        return pulumi.get(self, "additional_latency_milliseconds")

    @additional_latency_milliseconds.setter
    def additional_latency_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_latency_milliseconds", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of samples to consider for load balancing decisions
        """
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_size", value)

    @property
    @pulumi.getter(name="successfulSamplesRequired")
    def successful_samples_required(self) -> Optional[pulumi.Input[int]]:
        """
        The number of samples within the sample period that must succeed
        """
        return pulumi.get(self, "successful_samples_required")

    @successful_samples_required.setter
    def successful_samples_required(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "successful_samples_required", value)


@pulumi.input_type
class RedirectConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 custom_fragment: Optional[pulumi.Input[str]] = None,
                 custom_host: Optional[pulumi.Input[str]] = None,
                 custom_path: Optional[pulumi.Input[str]] = None,
                 custom_query_string: Optional[pulumi.Input[str]] = None,
                 redirect_protocol: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]] = None,
                 redirect_type: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]] = None):
        """
        Describes Redirect Route.
        :param pulumi.Input[str] odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        :param pulumi.Input[str] custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param pulumi.Input[str] custom_host: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param pulumi.Input[str] custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param pulumi.Input[str] custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        :param pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']] redirect_protocol: The protocol of the destination to where the traffic is redirected
        :param pulumi.Input[Union[str, 'FrontDoorRedirectType']] redirect_type: The redirect type the rule will use when redirecting traffic.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration')
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_host is not None:
            pulumi.set(__self__, "custom_host", custom_host)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if redirect_protocol is not None:
            pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[pulumi.Input[str]]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @custom_fragment.setter
    def custom_fragment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_fragment", value)

    @property
    @pulumi.getter(name="customHost")
    def custom_host(self) -> Optional[pulumi.Input[str]]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_host")

    @custom_host.setter
    def custom_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_host", value)

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @custom_path.setter
    def custom_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_path", value)

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[pulumi.Input[str]]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        """
        return pulumi.get(self, "custom_query_string")

    @custom_query_string.setter
    def custom_query_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_query_string", value)

    @property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]]:
        """
        The protocol of the destination to where the traffic is redirected
        """
        return pulumi.get(self, "redirect_protocol")

    @redirect_protocol.setter
    def redirect_protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]]):
        pulumi.set(self, "redirect_protocol", value)

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]]:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")

    @redirect_type.setter
    def redirect_type(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]]):
        pulumi.set(self, "redirect_type", value)


@pulumi.input_type
class RoutingRuleArgs:
    def __init__(__self__, *,
                 accepted_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]] = None,
                 frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 patterns_to_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 route_configuration: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]] = None):
        """
        A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]] accepted_protocols: Protocol schemes to match for this rule
        :param pulumi.Input[Union[str, 'RoutingRuleEnabledState']] enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] frontend_endpoints: Frontend endpoints associated with this rule
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] patterns_to_match: The route patterns of the rule.
        :param pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']] route_configuration: A reference to the routing configuration.
        """
        if accepted_protocols is not None:
            pulumi.set(__self__, "accepted_protocols", accepted_protocols)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if frontend_endpoints is not None:
            pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patterns_to_match is not None:
            pulumi.set(__self__, "patterns_to_match", patterns_to_match)
        if route_configuration is not None:
            pulumi.set(__self__, "route_configuration", route_configuration)

    @property
    @pulumi.getter(name="acceptedProtocols")
    def accepted_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]]:
        """
        Protocol schemes to match for this rule
        """
        return pulumi.get(self, "accepted_protocols")

    @accepted_protocols.setter
    def accepted_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]]):
        pulumi.set(self, "accepted_protocols", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]]:
        """
        Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Frontend endpoints associated with this rule
        """
        return pulumi.get(self, "frontend_endpoints")

    @frontend_endpoints.setter
    def frontend_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "frontend_endpoints", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="patternsToMatch")
    def patterns_to_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_match")

    @patterns_to_match.setter
    def patterns_to_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "patterns_to_match", value)

    @property
    @pulumi.getter(name="routeConfiguration")
    def route_configuration(self) -> Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]:
        """
        A reference to the routing configuration.
        """
        return pulumi.get(self, "route_configuration")

    @route_configuration.setter
    def route_configuration(self, value: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]):
        pulumi.set(self, "route_configuration", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Reference to another subresource.
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


