# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AzureFileshareProtectedItemArgs',
    'AzureFileshareProtectedItemExtendedInfoArgs',
    'AzureIaaSClassicComputeVMProtectedItemArgs',
    'AzureIaaSComputeVMProtectedItemArgs',
    'AzureIaaSVMProtectedItemArgs',
    'AzureIaaSVMProtectedItemExtendedInfoArgs',
    'AzureSqlProtectedItemArgs',
    'AzureSqlProtectedItemExtendedInfoArgs',
    'AzureVmWorkloadProtectedItemArgs',
    'AzureVmWorkloadProtectedItemExtendedInfoArgs',
    'AzureVmWorkloadSAPAseDatabaseProtectedItemArgs',
    'AzureVmWorkloadSAPHanaDatabaseProtectedItemArgs',
    'AzureVmWorkloadSQLDatabaseProtectedItemArgs',
    'DPMProtectedItemArgs',
    'DPMProtectedItemExtendedInfoArgs',
    'DiskExclusionPropertiesArgs',
    'ExtendedPropertiesArgs',
    'GenericProtectedItemArgs',
    'KPIResourceHealthDetailsArgs',
    'MabFileFolderProtectedItemArgs',
    'MabFileFolderProtectedItemExtendedInfoArgs',
]

@pulumi.input_type
class AzureFileshareProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure File Share workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureFileShareProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs'] extended_info: Additional information with this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the fileshare represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureFileShareProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureFileShareProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs']]:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureFileshareProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the fileshare represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureFileshareProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information about Azure File Share backup item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param pulumi.Input[str] policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param pulumi.Input[int] recovery_point_count: Number of available backup copies associated with this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureIaaSClassicComputeVMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']] = None,
                 extended_properties: Optional[pulumi.Input['ExtendedPropertiesArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[Union[str, 'HealthStatus']]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        IaaS VM workload-specific backup item representing the Classic Compute VM.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input['ExtendedPropertiesArgs'] extended_properties: Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input[str] friendly_name: Friendly name of the VM represented by this backup item.
        :param pulumi.Input[Union[str, 'HealthStatus']] health_status: Health status of protected item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'Microsoft.ClassicCompute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'Microsoft.ClassicCompute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input['ExtendedPropertiesArgs']]:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input['ExtendedPropertiesArgs']]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[Union[str, 'HealthStatus']]]:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[Union[str, 'HealthStatus']]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureIaaSComputeVMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']] = None,
                 extended_properties: Optional[pulumi.Input['ExtendedPropertiesArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[Union[str, 'HealthStatus']]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'Microsoft.Compute/virtualMachines'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input['ExtendedPropertiesArgs'] extended_properties: Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input[str] friendly_name: Friendly name of the VM represented by this backup item.
        :param pulumi.Input[Union[str, 'HealthStatus']] health_status: Health status of protected item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'Microsoft.Compute/virtualMachines')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'Microsoft.Compute/virtualMachines'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input['ExtendedPropertiesArgs']]:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input['ExtendedPropertiesArgs']]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[Union[str, 'HealthStatus']]]:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[Union[str, 'HealthStatus']]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureIaaSVMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']] = None,
                 extended_properties: Optional[pulumi.Input['ExtendedPropertiesArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 health_status: Optional[pulumi.Input[Union[str, 'HealthStatus']]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        IaaS VM workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureIaaSVMProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input['ExtendedPropertiesArgs'] extended_properties: Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input[str] friendly_name: Friendly name of the VM represented by this backup item.
        :param pulumi.Input[Union[str, 'HealthStatus']] health_status: Health status of protected item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[str] last_backup_status: Last backup operation status.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[str] virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this item.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureIaaSVMProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if extended_properties is not None:
            pulumi.set(__self__, "extended_properties", extended_properties)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureIaaSVMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureIaaSVMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="extendedProperties")
    def extended_properties(self) -> Optional[pulumi.Input['ExtendedPropertiesArgs']]:
        """
        Extended Properties for Azure IaasVM Backup.
        """
        return pulumi.get(self, "extended_properties")

    @extended_properties.setter
    def extended_properties(self, value: Optional[pulumi.Input['ExtendedPropertiesArgs']]):
        pulumi.set(self, "extended_properties", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the VM represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[pulumi.Input[Union[str, 'HealthStatus']]]:
        """
        Health status of protected item.
        """
        return pulumi.get(self, "health_status")

    @health_status.setter
    def health_status(self, value: Optional[pulumi.Input[Union[str, 'HealthStatus']]]):
        pulumi.set(self, "health_status", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup operation status.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified ARM ID of the virtual machine represented by this item.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureIaaSVMProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_inconsistent: Optional[pulumi.Input[bool]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on Azure IaaS VM specific backup item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this backup item.
        :param pulumi.Input[bool] policy_inconsistent: Specifies if backup policy associated with the backup item is inconsistent.
        :param pulumi.Input[int] recovery_point_count: Number of backup copies available for this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_inconsistent is not None:
            pulumi.set(__self__, "policy_inconsistent", policy_inconsistent)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this backup item.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyInconsistent")
    def policy_inconsistent(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if backup policy associated with the backup item is inconsistent.
        """
        return pulumi.get(self, "policy_inconsistent")

    @policy_inconsistent.setter
    def policy_inconsistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "policy_inconsistent", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureSqlProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs']] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure SQL workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'Microsoft.Sql/servers/databases'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        :param pulumi.Input[Union[str, 'ProtectedItemState']] protection_state: Backup state of the backed up item.
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'Microsoft.Sql/servers/databases')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_id is not None:
            pulumi.set(__self__, "protected_item_data_id", protected_item_data_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'Microsoft.Sql/servers/databases'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureSqlProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataId")
    def protected_item_data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
        """
        return pulumi.get(self, "protected_item_data_id")

    @protected_item_data_id.setter
    def protected_item_data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]:
        """
        Backup state of the backed up item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureSqlProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on Azure Sql specific protected item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this item in the service.
        :param pulumi.Input[str] policy_state: State of the backup policy associated with this backup item.
        :param pulumi.Input[int] recovery_point_count: Number of available backup copies associated with this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this item in the service.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the backup policy associated with this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of available backup copies associated with this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureVmWorkloadProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on Azure Workload for SQL specific backup item.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available for this backup item.
        :param pulumi.Input[str] policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param pulumi.Input[int] recovery_point_count: Number of backup copies available for this backup item.
        """
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available for this backup item.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of backup copies available for this backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


@pulumi.input_type
class AzureVmWorkloadSAPAseDatabaseProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item representing SAP ASE Database.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPAseDatabase')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPAseDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadSAPHanaDatabaseProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item representing SAP HANA Database.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSAPHanaDatabase')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSAPHanaDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class AzureVmWorkloadSQLDatabaseProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 kpis_healths: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]] = None,
                 last_backup_status: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 parent_name: Optional[pulumi.Input[str]] = None,
                 parent_type: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protected_item_data_source_id: Optional[pulumi.Input[str]] = None,
                 protected_item_health_status: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 protection_status: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Azure VM workload-specific protected item representing SQL Database.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'AzureVmWorkloadSQLDatabase'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs'] extended_info: Additional information for this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the DB represented by this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]] kpis_healths: Health details of different KPIs
        :param pulumi.Input[Union[str, 'LastBackupStatus']] last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] parent_name: Parent name of the DB such as Instance or Availability Group.
        :param pulumi.Input[str] parent_type: Parent type of protected item, example: for a DB, standalone server or distributed
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protected_item_data_source_id: Data ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectedItemHealthStatus']] protected_item_health_status: Health status of the backup item, evaluated based on last heartbeat received
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[str] protection_status: Backup status of this backup item.
        :param pulumi.Input[str] server_name: Host/Cluster Name for instance or AG
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'AzureVmWorkloadSQLDatabase')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if kpis_healths is not None:
            pulumi.set(__self__, "kpis_healths", kpis_healths)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if parent_name is not None:
            pulumi.set(__self__, "parent_name", parent_name)
        if parent_type is not None:
            pulumi.set(__self__, "parent_type", parent_type)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protected_item_data_source_id is not None:
            pulumi.set(__self__, "protected_item_data_source_id", protected_item_data_source_id)
        if protected_item_health_status is not None:
            pulumi.set(__self__, "protected_item_health_status", protected_item_health_status)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if protection_status is not None:
            pulumi.set(__self__, "protection_status", protection_status)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'AzureVmWorkloadSQLDatabase'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]:
        """
        Additional information for this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['AzureVmWorkloadProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the DB represented by this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="kpisHealths")
    def kpis_healths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]:
        """
        Health details of different KPIs
        """
        return pulumi.get(self, "kpis_healths")

    @kpis_healths.setter
    def kpis_healths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['KPIResourceHealthDetailsArgs']]]]):
        pulumi.set(self, "kpis_healths", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]:
        """
        Last backup operation status. Possible values: Healthy, Unhealthy.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[Union[str, 'LastBackupStatus']]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parent name of the DB such as Instance or Availability Group.
        """
        return pulumi.get(self, "parent_name")

    @parent_name.setter
    def parent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_name", value)

    @property
    @pulumi.getter(name="parentType")
    def parent_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parent type of protected item, example: for a DB, standalone server or distributed
        """
        return pulumi.get(self, "parent_type")

    @parent_type.setter
    def parent_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_type", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectedItemDataSourceId")
    def protected_item_data_source_id(self) -> Optional[pulumi.Input[str]]:
        """
        Data ID of the protected item.
        """
        return pulumi.get(self, "protected_item_data_source_id")

    @protected_item_data_source_id.setter
    def protected_item_data_source_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_item_data_source_id", value)

    @property
    @pulumi.getter(name="protectedItemHealthStatus")
    def protected_item_health_status(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]:
        """
        Health status of the backup item, evaluated based on last heartbeat received
        """
        return pulumi.get(self, "protected_item_health_status")

    @protected_item_health_status.setter
    def protected_item_health_status(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemHealthStatus']]]):
        pulumi.set(self, "protected_item_health_status", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="protectionStatus")
    def protection_status(self) -> Optional[pulumi.Input[str]]:
        """
        Backup status of this backup item.
        """
        return pulumi.get(self, "protection_status")

    @protection_status.setter
    def protection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_status", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host/Cluster Name for instance or AG
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class DPMProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_engine_name: Optional[pulumi.Input[str]] = None,
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['DPMProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Additional information on Backup engine specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'DPMProtectedItem'.
        :param pulumi.Input[str] backup_engine_name: Backup Management server protecting this backup item
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['DPMProtectedItemExtendedInfoArgs'] extended_info: Extended info of the backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of the managed item
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[Union[str, 'ProtectedItemState']] protection_state: Protection state of the backup engine
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'DPMProtectedItem')
        if backup_engine_name is not None:
            pulumi.set(__self__, "backup_engine_name", backup_engine_name)
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'DPMProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupEngineName")
    def backup_engine_name(self) -> Optional[pulumi.Input[str]]:
        """
        Backup Management server protecting this backup item
        """
        return pulumi.get(self, "backup_engine_name")

    @backup_engine_name.setter
    def backup_engine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_engine_name", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['DPMProtectedItemExtendedInfoArgs']]:
        """
        Extended info of the backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['DPMProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the managed item
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]:
        """
        Protection state of the backup engine
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectedItemState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class DPMProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 disk_storage_used_in_bytes: Optional[pulumi.Input[str]] = None,
                 is_collocated: Optional[pulumi.Input[bool]] = None,
                 is_present_on_cloud: Optional[pulumi.Input[bool]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 on_premise_latest_recovery_point: Optional[pulumi.Input[str]] = None,
                 on_premise_oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 on_premise_recovery_point_count: Optional[pulumi.Input[int]] = None,
                 protectable_object_load_path: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protected: Optional[pulumi.Input[bool]] = None,
                 protection_group_name: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None,
                 total_disk_storage_size_in_bytes: Optional[pulumi.Input[str]] = None):
        """
        Additional information of DPM Protected item.
        :param pulumi.Input[str] disk_storage_used_in_bytes: Used Disk storage in bytes.
        :param pulumi.Input[bool] is_collocated: To check if backup item is collocated.
        :param pulumi.Input[bool] is_present_on_cloud: To check if backup item is cloud protected.
        :param pulumi.Input[str] last_backup_status: Last backup status information on backup item.
        :param pulumi.Input[str] last_refreshed_at: Last refresh time on backup item.
        :param pulumi.Input[str] oldest_recovery_point: Oldest cloud recovery point time.
        :param pulumi.Input[str] on_premise_latest_recovery_point: latest disk recovery point time.
        :param pulumi.Input[str] on_premise_oldest_recovery_point: Oldest disk recovery point time.
        :param pulumi.Input[int] on_premise_recovery_point_count: disk recovery point count.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] protectable_object_load_path: Attribute to provide information on various DBs.
        :param pulumi.Input[bool] protected: To check if backup item is disk protected.
        :param pulumi.Input[str] protection_group_name: Protection group name of the backup item.
        :param pulumi.Input[int] recovery_point_count: cloud recovery point count.
        :param pulumi.Input[str] total_disk_storage_size_in_bytes: total Disk storage in bytes.
        """
        if disk_storage_used_in_bytes is not None:
            pulumi.set(__self__, "disk_storage_used_in_bytes", disk_storage_used_in_bytes)
        if is_collocated is not None:
            pulumi.set(__self__, "is_collocated", is_collocated)
        if is_present_on_cloud is not None:
            pulumi.set(__self__, "is_present_on_cloud", is_present_on_cloud)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if on_premise_latest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_latest_recovery_point", on_premise_latest_recovery_point)
        if on_premise_oldest_recovery_point is not None:
            pulumi.set(__self__, "on_premise_oldest_recovery_point", on_premise_oldest_recovery_point)
        if on_premise_recovery_point_count is not None:
            pulumi.set(__self__, "on_premise_recovery_point_count", on_premise_recovery_point_count)
        if protectable_object_load_path is not None:
            pulumi.set(__self__, "protectable_object_load_path", protectable_object_load_path)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if protection_group_name is not None:
            pulumi.set(__self__, "protection_group_name", protection_group_name)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)
        if total_disk_storage_size_in_bytes is not None:
            pulumi.set(__self__, "total_disk_storage_size_in_bytes", total_disk_storage_size_in_bytes)

    @property
    @pulumi.getter(name="diskStorageUsedInBytes")
    def disk_storage_used_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Used Disk storage in bytes.
        """
        return pulumi.get(self, "disk_storage_used_in_bytes")

    @disk_storage_used_in_bytes.setter
    def disk_storage_used_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_storage_used_in_bytes", value)

    @property
    @pulumi.getter(name="isCollocated")
    def is_collocated(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if backup item is collocated.
        """
        return pulumi.get(self, "is_collocated")

    @is_collocated.setter
    def is_collocated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_collocated", value)

    @property
    @pulumi.getter(name="isPresentOnCloud")
    def is_present_on_cloud(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if backup item is cloud protected.
        """
        return pulumi.get(self, "is_present_on_cloud")

    @is_present_on_cloud.setter
    def is_present_on_cloud(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_present_on_cloud", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Last backup status information on backup item.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last refresh time on backup item.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Oldest cloud recovery point time.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="onPremiseLatestRecoveryPoint")
    def on_premise_latest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        latest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_latest_recovery_point")

    @on_premise_latest_recovery_point.setter
    def on_premise_latest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_premise_latest_recovery_point", value)

    @property
    @pulumi.getter(name="onPremiseOldestRecoveryPoint")
    def on_premise_oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Oldest disk recovery point time.
        """
        return pulumi.get(self, "on_premise_oldest_recovery_point")

    @on_premise_oldest_recovery_point.setter
    def on_premise_oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_premise_oldest_recovery_point", value)

    @property
    @pulumi.getter(name="onPremiseRecoveryPointCount")
    def on_premise_recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        disk recovery point count.
        """
        return pulumi.get(self, "on_premise_recovery_point_count")

    @on_premise_recovery_point_count.setter
    def on_premise_recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_premise_recovery_point_count", value)

    @property
    @pulumi.getter(name="protectableObjectLoadPath")
    def protectable_object_load_path(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Attribute to provide information on various DBs.
        """
        return pulumi.get(self, "protectable_object_load_path")

    @protectable_object_load_path.setter
    def protectable_object_load_path(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "protectable_object_load_path", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[bool]]:
        """
        To check if backup item is disk protected.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter(name="protectionGroupName")
    def protection_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Protection group name of the backup item.
        """
        return pulumi.get(self, "protection_group_name")

    @protection_group_name.setter
    def protection_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_group_name", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        cloud recovery point count.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)

    @property
    @pulumi.getter(name="totalDiskStorageSizeInBytes")
    def total_disk_storage_size_in_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        total Disk storage in bytes.
        """
        return pulumi.get(self, "total_disk_storage_size_in_bytes")

    @total_disk_storage_size_in_bytes.setter
    def total_disk_storage_size_in_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "total_disk_storage_size_in_bytes", value)


@pulumi.input_type
class DiskExclusionPropertiesArgs:
    def __init__(__self__, *,
                 disk_lun_list: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 is_inclusion_list: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        :param pulumi.Input[bool] is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        if disk_lun_list is not None:
            pulumi.set(__self__, "disk_lun_list", disk_lun_list)
        if is_inclusion_list is not None:
            pulumi.set(__self__, "is_inclusion_list", is_inclusion_list)

    @property
    @pulumi.getter(name="diskLunList")
    def disk_lun_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        """
        return pulumi.get(self, "disk_lun_list")

    @disk_lun_list.setter
    def disk_lun_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "disk_lun_list", value)

    @property
    @pulumi.getter(name="isInclusionList")
    def is_inclusion_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether DiskLunList is to be included/ excluded from backup.
        """
        return pulumi.get(self, "is_inclusion_list")

    @is_inclusion_list.setter
    def is_inclusion_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_inclusion_list", value)


@pulumi.input_type
class ExtendedPropertiesArgs:
    def __init__(__self__, *,
                 disk_exclusion_properties: Optional[pulumi.Input['DiskExclusionPropertiesArgs']] = None):
        """
        Extended Properties for Azure IaasVM Backup.
        :param pulumi.Input['DiskExclusionPropertiesArgs'] disk_exclusion_properties: Extended Properties for Disk Exclusion.
        """
        if disk_exclusion_properties is not None:
            pulumi.set(__self__, "disk_exclusion_properties", disk_exclusion_properties)

    @property
    @pulumi.getter(name="diskExclusionProperties")
    def disk_exclusion_properties(self) -> Optional[pulumi.Input['DiskExclusionPropertiesArgs']]:
        """
        Extended Properties for Disk Exclusion.
        """
        return pulumi.get(self, "disk_exclusion_properties")

    @disk_exclusion_properties.setter
    def disk_exclusion_properties(self, value: Optional[pulumi.Input['DiskExclusionPropertiesArgs']]):
        pulumi.set(self, "disk_exclusion_properties", value)


@pulumi.input_type
class GenericProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 fabric_name: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 policy_state: Optional[pulumi.Input[str]] = None,
                 protected_item_id: Optional[pulumi.Input[float]] = None,
                 protection_state: Optional[pulumi.Input[Union[str, 'ProtectionState']]] = None,
                 source_associations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        Base class for backup items.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'GenericProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input[str] fabric_name: Name of this backup item's fabric.
        :param pulumi.Input[str] friendly_name: Friendly name of the container.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] policy_state: Indicates consistency of policy object and policy applied to this backup item.
        :param pulumi.Input[float] protected_item_id: Data Plane Service ID of the protected item.
        :param pulumi.Input[Union[str, 'ProtectionState']] protection_state: Backup state of this backup item.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] source_associations: Loosely coupled (type, value) associations (example - parent of a protected item)
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'GenericProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if fabric_name is not None:
            pulumi.set(__self__, "fabric_name", fabric_name)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if policy_state is not None:
            pulumi.set(__self__, "policy_state", policy_state)
        if protected_item_id is not None:
            pulumi.set(__self__, "protected_item_id", protected_item_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_associations is not None:
            pulumi.set(__self__, "source_associations", source_associations)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'GenericProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="fabricName")
    def fabric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this backup item's fabric.
        """
        return pulumi.get(self, "fabric_name")

    @fabric_name.setter
    def fabric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_name", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the container.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="policyState")
    def policy_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates consistency of policy object and policy applied to this backup item.
        """
        return pulumi.get(self, "policy_state")

    @policy_state.setter
    def policy_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_state", value)

    @property
    @pulumi.getter(name="protectedItemId")
    def protected_item_id(self) -> Optional[pulumi.Input[float]]:
        """
        Data Plane Service ID of the protected item.
        """
        return pulumi.get(self, "protected_item_id")

    @protected_item_id.setter
    def protected_item_id(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "protected_item_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[Union[str, 'ProtectionState']]]:
        """
        Backup state of this backup item.
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[Union[str, 'ProtectionState']]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceAssociations")
    def source_associations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Loosely coupled (type, value) associations (example - parent of a protected item)
        """
        return pulumi.get(self, "source_associations")

    @source_associations.setter
    def source_associations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "source_associations", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class KPIResourceHealthDetailsArgs:
    def __init__(__self__, *,
                 resource_health_status: Optional[pulumi.Input[Union[str, 'ResourceHealthStatus']]] = None):
        """
        KPI Resource Health Details
        :param pulumi.Input[Union[str, 'ResourceHealthStatus']] resource_health_status: Resource Health Status
        """
        if resource_health_status is not None:
            pulumi.set(__self__, "resource_health_status", resource_health_status)

    @property
    @pulumi.getter(name="resourceHealthStatus")
    def resource_health_status(self) -> Optional[pulumi.Input[Union[str, 'ResourceHealthStatus']]]:
        """
        Resource Health Status
        """
        return pulumi.get(self, "resource_health_status")

    @resource_health_status.setter
    def resource_health_status(self, value: Optional[pulumi.Input[Union[str, 'ResourceHealthStatus']]]):
        pulumi.set(self, "resource_health_status", value)


@pulumi.input_type
class MabFileFolderProtectedItemArgs:
    def __init__(__self__, *,
                 protected_item_type: pulumi.Input[str],
                 backup_management_type: Optional[pulumi.Input[Union[str, 'BackupManagementType']]] = None,
                 backup_set_name: Optional[pulumi.Input[str]] = None,
                 computer_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 create_mode: Optional[pulumi.Input[Union[str, 'CreateMode']]] = None,
                 deferred_delete_sync_time_in_utc: Optional[pulumi.Input[float]] = None,
                 deferred_delete_time_in_utc: Optional[pulumi.Input[str]] = None,
                 deferred_delete_time_remaining: Optional[pulumi.Input[str]] = None,
                 extended_info: Optional[pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 is_deferred_delete_schedule_upcoming: Optional[pulumi.Input[bool]] = None,
                 is_rehydrate: Optional[pulumi.Input[bool]] = None,
                 is_scheduled_for_deferred_delete: Optional[pulumi.Input[bool]] = None,
                 last_backup_status: Optional[pulumi.Input[str]] = None,
                 last_backup_time: Optional[pulumi.Input[str]] = None,
                 last_recovery_point: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protection_state: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[Union[str, 'DataSourceType']]] = None):
        """
        MAB workload-specific backup item.
        :param pulumi.Input[str] protected_item_type: backup item type.
               Expected value is 'MabFileFolderProtectedItem'.
        :param pulumi.Input[Union[str, 'BackupManagementType']] backup_management_type: Type of backup management for the backed up item.
        :param pulumi.Input[str] backup_set_name: Name of the backup set the backup item belongs to
        :param pulumi.Input[str] computer_name: Name of the computer associated with this backup item.
        :param pulumi.Input[str] container_name: Unique name of container
        :param pulumi.Input[Union[str, 'CreateMode']] create_mode: Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        :param pulumi.Input[float] deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_in_utc: Time for deferred deletion in UTC
        :param pulumi.Input[str] deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete is permanently deleted
        :param pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs'] extended_info: Additional information with this backup item.
        :param pulumi.Input[str] friendly_name: Friendly name of this backup item.
        :param pulumi.Input[bool] is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is to be purged soon
        :param pulumi.Input[bool] is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state
        :param pulumi.Input[bool] is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for deferred delete
        :param pulumi.Input[str] last_backup_status: Status of last backup operation.
        :param pulumi.Input[str] last_backup_time: Timestamp of the last backup operation on this backup item.
        :param pulumi.Input[str] last_recovery_point: Timestamp when the last (latest) backup copy was created for this backup item.
        :param pulumi.Input[str] policy_id: ID of the backup policy with which this item is backed up.
        :param pulumi.Input[str] protection_state: Protected, ProtectionStopped, IRPending or ProtectionError
        :param pulumi.Input[str] source_resource_id: ARM ID of the resource to be backed up.
        :param pulumi.Input[Union[str, 'DataSourceType']] workload_type: Type of workload this item represents.
        """
        pulumi.set(__self__, "protected_item_type", 'MabFileFolderProtectedItem')
        if backup_management_type is not None:
            pulumi.set(__self__, "backup_management_type", backup_management_type)
        if backup_set_name is not None:
            pulumi.set(__self__, "backup_set_name", backup_set_name)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if deferred_delete_sync_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_sync_time_in_utc", deferred_delete_sync_time_in_utc)
        if deferred_delete_time_in_utc is not None:
            pulumi.set(__self__, "deferred_delete_time_in_utc", deferred_delete_time_in_utc)
        if deferred_delete_time_remaining is not None:
            pulumi.set(__self__, "deferred_delete_time_remaining", deferred_delete_time_remaining)
        if extended_info is not None:
            pulumi.set(__self__, "extended_info", extended_info)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if is_deferred_delete_schedule_upcoming is not None:
            pulumi.set(__self__, "is_deferred_delete_schedule_upcoming", is_deferred_delete_schedule_upcoming)
        if is_rehydrate is not None:
            pulumi.set(__self__, "is_rehydrate", is_rehydrate)
        if is_scheduled_for_deferred_delete is not None:
            pulumi.set(__self__, "is_scheduled_for_deferred_delete", is_scheduled_for_deferred_delete)
        if last_backup_status is not None:
            pulumi.set(__self__, "last_backup_status", last_backup_status)
        if last_backup_time is not None:
            pulumi.set(__self__, "last_backup_time", last_backup_time)
        if last_recovery_point is not None:
            pulumi.set(__self__, "last_recovery_point", last_recovery_point)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protection_state is not None:
            pulumi.set(__self__, "protection_state", protection_state)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="protectedItemType")
    def protected_item_type(self) -> pulumi.Input[str]:
        """
        backup item type.
        Expected value is 'MabFileFolderProtectedItem'.
        """
        return pulumi.get(self, "protected_item_type")

    @protected_item_type.setter
    def protected_item_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "protected_item_type", value)

    @property
    @pulumi.getter(name="backupManagementType")
    def backup_management_type(self) -> Optional[pulumi.Input[Union[str, 'BackupManagementType']]]:
        """
        Type of backup management for the backed up item.
        """
        return pulumi.get(self, "backup_management_type")

    @backup_management_type.setter
    def backup_management_type(self, value: Optional[pulumi.Input[Union[str, 'BackupManagementType']]]):
        pulumi.set(self, "backup_management_type", value)

    @property
    @pulumi.getter(name="backupSetName")
    def backup_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the backup set the backup item belongs to
        """
        return pulumi.get(self, "backup_set_name")

    @backup_set_name.setter
    def backup_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_set_name", value)

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the computer associated with this backup item.
        """
        return pulumi.get(self, "computer_name")

    @computer_name.setter
    def computer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "computer_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of container
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[Union[str, 'CreateMode']]]:
        """
        Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[Union[str, 'CreateMode']]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="deferredDeleteSyncTimeInUTC")
    def deferred_delete_sync_time_in_utc(self) -> Optional[pulumi.Input[float]]:
        """
        Sync time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_sync_time_in_utc")

    @deferred_delete_sync_time_in_utc.setter
    def deferred_delete_sync_time_in_utc(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "deferred_delete_sync_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeInUTC")
    def deferred_delete_time_in_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Time for deferred deletion in UTC
        """
        return pulumi.get(self, "deferred_delete_time_in_utc")

    @deferred_delete_time_in_utc.setter
    def deferred_delete_time_in_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_in_utc", value)

    @property
    @pulumi.getter(name="deferredDeleteTimeRemaining")
    def deferred_delete_time_remaining(self) -> Optional[pulumi.Input[str]]:
        """
        Time remaining before the DS marked for deferred delete is permanently deleted
        """
        return pulumi.get(self, "deferred_delete_time_remaining")

    @deferred_delete_time_remaining.setter
    def deferred_delete_time_remaining(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deferred_delete_time_remaining", value)

    @property
    @pulumi.getter(name="extendedInfo")
    def extended_info(self) -> Optional[pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs']]:
        """
        Additional information with this backup item.
        """
        return pulumi.get(self, "extended_info")

    @extended_info.setter
    def extended_info(self, value: Optional[pulumi.Input['MabFileFolderProtectedItemExtendedInfoArgs']]):
        pulumi.set(self, "extended_info", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of this backup item.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="isDeferredDeleteScheduleUpcoming")
    def is_deferred_delete_schedule_upcoming(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the deferred deleted DS is to be purged soon
        """
        return pulumi.get(self, "is_deferred_delete_schedule_upcoming")

    @is_deferred_delete_schedule_upcoming.setter
    def is_deferred_delete_schedule_upcoming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deferred_delete_schedule_upcoming", value)

    @property
    @pulumi.getter(name="isRehydrate")
    def is_rehydrate(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify that deferred deleted DS is to be moved into Pause state
        """
        return pulumi.get(self, "is_rehydrate")

    @is_rehydrate.setter
    def is_rehydrate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_rehydrate", value)

    @property
    @pulumi.getter(name="isScheduledForDeferredDelete")
    def is_scheduled_for_deferred_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to identify whether the DS is scheduled for deferred delete
        """
        return pulumi.get(self, "is_scheduled_for_deferred_delete")

    @is_scheduled_for_deferred_delete.setter
    def is_scheduled_for_deferred_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_scheduled_for_deferred_delete", value)

    @property
    @pulumi.getter(name="lastBackupStatus")
    def last_backup_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of last backup operation.
        """
        return pulumi.get(self, "last_backup_status")

    @last_backup_status.setter
    def last_backup_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_status", value)

    @property
    @pulumi.getter(name="lastBackupTime")
    def last_backup_time(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of the last backup operation on this backup item.
        """
        return pulumi.get(self, "last_backup_time")

    @last_backup_time.setter
    def last_backup_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_backup_time", value)

    @property
    @pulumi.getter(name="lastRecoveryPoint")
    def last_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp when the last (latest) backup copy was created for this backup item.
        """
        return pulumi.get(self, "last_recovery_point")

    @last_recovery_point.setter
    def last_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_recovery_point", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the backup policy with which this item is backed up.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectionState")
    def protection_state(self) -> Optional[pulumi.Input[str]]:
        """
        Protected, ProtectionStopped, IRPending or ProtectionError
        """
        return pulumi.get(self, "protection_state")

    @protection_state.setter
    def protection_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_state", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM ID of the resource to be backed up.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[Union[str, 'DataSourceType']]]:
        """
        Type of workload this item represents.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[Union[str, 'DataSourceType']]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class MabFileFolderProtectedItemExtendedInfoArgs:
    def __init__(__self__, *,
                 last_refreshed_at: Optional[pulumi.Input[str]] = None,
                 oldest_recovery_point: Optional[pulumi.Input[str]] = None,
                 recovery_point_count: Optional[pulumi.Input[int]] = None):
        """
        Additional information on the backed up item.
        :param pulumi.Input[str] last_refreshed_at: Last time when the agent data synced to service.
        :param pulumi.Input[str] oldest_recovery_point: The oldest backup copy available.
        :param pulumi.Input[int] recovery_point_count: Number of backup copies associated with the backup item.
        """
        if last_refreshed_at is not None:
            pulumi.set(__self__, "last_refreshed_at", last_refreshed_at)
        if oldest_recovery_point is not None:
            pulumi.set(__self__, "oldest_recovery_point", oldest_recovery_point)
        if recovery_point_count is not None:
            pulumi.set(__self__, "recovery_point_count", recovery_point_count)

    @property
    @pulumi.getter(name="lastRefreshedAt")
    def last_refreshed_at(self) -> Optional[pulumi.Input[str]]:
        """
        Last time when the agent data synced to service.
        """
        return pulumi.get(self, "last_refreshed_at")

    @last_refreshed_at.setter
    def last_refreshed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_refreshed_at", value)

    @property
    @pulumi.getter(name="oldestRecoveryPoint")
    def oldest_recovery_point(self) -> Optional[pulumi.Input[str]]:
        """
        The oldest backup copy available.
        """
        return pulumi.get(self, "oldest_recovery_point")

    @oldest_recovery_point.setter
    def oldest_recovery_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oldest_recovery_point", value)

    @property
    @pulumi.getter(name="recoveryPointCount")
    def recovery_point_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of backup copies associated with the backup item.
        """
        return pulumi.get(self, "recovery_point_count")

    @recovery_point_count.setter
    def recovery_point_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_point_count", value)


