# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFavoriteProcessResult',
    'AwaitableGetFavoriteProcessResult',
    'get_favorite_process',
]

@pulumi.output_type
class GetFavoriteProcessResult:
    """
    A favorite process identifier.
    """
    def __init__(__self__, actual_process_name=None, id=None, name=None, system_data=None, type=None):
        if actual_process_name and not isinstance(actual_process_name, str):
            raise TypeError("Expected argument 'actual_process_name' to be a str")
        pulumi.set(__self__, "actual_process_name", actual_process_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="actualProcessName")
    def actual_process_name(self) -> str:
        """
        The actual name of the favorite process. It will be equal to resource name except for the scenario that the process name contains characters that are not allowed in the resource name.
        """
        return pulumi.get(self, "actual_process_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        The system metadata relating to this resource
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetFavoriteProcessResult(GetFavoriteProcessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFavoriteProcessResult(
            actual_process_name=self.actual_process_name,
            id=self.id,
            name=self.name,
            system_data=self.system_data,
            type=self.type)


def get_favorite_process(favorite_process_resource_name: Optional[str] = None,
                         package_name: Optional[str] = None,
                         resource_group_name: Optional[str] = None,
                         test_base_account_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFavoriteProcessResult:
    """
    A favorite process identifier.
    API Version: 2020-12-16-preview.


    :param str favorite_process_resource_name: The resource name of a favorite process in a package. If the process name contains characters that are not allowed in Azure Resource Name, we use 'actualProcessName' in request body to submit the name.
    :param str package_name: The resource name of the Test Base Package.
    :param str resource_group_name: The name of the resource group that contains the resource.
    :param str test_base_account_name: The resource name of the Test Base Account.
    """
    __args__ = dict()
    __args__['favoriteProcessResourceName'] = favorite_process_resource_name
    __args__['packageName'] = package_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['testBaseAccountName'] = test_base_account_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('azure-native:testbase:getFavoriteProcess', __args__, opts=opts, typ=GetFavoriteProcessResult).value

    return AwaitableGetFavoriteProcessResult(
        actual_process_name=__ret__.actual_process_name,
        id=__ret__.id,
        name=__ret__.name,
        system_data=__ret__.system_data,
        type=__ret__.type)
