# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApplicationGetEndpointArgs',
    'ApplicationGetHttpsEndpointArgs',
    'ApplicationPropertiesArgs',
    'AutoscaleArgs',
    'AutoscaleCapacityArgs',
    'AutoscaleRecurrenceArgs',
    'AutoscaleScheduleArgs',
    'AutoscaleTimeAndCapacityArgs',
    'ClientGroupInfoArgs',
    'ClusterCreatePropertiesArgs',
    'ClusterDefinitionArgs',
    'ClusterIdentityArgs',
    'ClusterIdentityUserAssignedIdentitiesArgs',
    'ComputeIsolationPropertiesArgs',
    'ComputeProfileArgs',
    'DataDisksGroupsArgs',
    'DiskEncryptionPropertiesArgs',
    'EncryptionInTransitPropertiesArgs',
    'ErrorsArgs',
    'HardwareProfileArgs',
    'KafkaRestPropertiesArgs',
    'LinuxOperatingSystemProfileArgs',
    'NetworkPropertiesArgs',
    'OsProfileArgs',
    'RoleArgs',
    'RuntimeScriptActionArgs',
    'ScriptActionArgs',
    'SecurityProfileArgs',
    'SshProfileArgs',
    'SshPublicKeyArgs',
    'StorageAccountArgs',
    'StorageProfileArgs',
    'VirtualNetworkProfileArgs',
]

@pulumi.input_type
class ApplicationGetEndpointArgs:
    def __init__(__self__, *,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_port: Optional[pulumi.Input[int]] = None):
        """
        Gets the application SSH endpoint
        :param pulumi.Input[int] destination_port: The destination port to connect to.
        :param pulumi.Input[str] location: The location of the endpoint.
        :param pulumi.Input[str] private_ip_address: The private ip address of the endpoint.
        :param pulumi.Input[int] public_port: The public port to connect to.
        """
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        The destination port to connect to.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the endpoint.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private ip address of the endpoint.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[pulumi.Input[int]]:
        """
        The public port to connect to.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "public_port", value)


@pulumi.input_type
class ApplicationGetHttpsEndpointArgs:
    def __init__(__self__, *,
                 access_modes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 destination_port: Optional[pulumi.Input[int]] = None,
                 disable_gateway_auth: Optional[pulumi.Input[bool]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 sub_domain_suffix: Optional[pulumi.Input[str]] = None):
        """
        Gets the application HTTP endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] access_modes: The list of access modes for the application.
        :param pulumi.Input[int] destination_port: The destination port to connect to.
        :param pulumi.Input[bool] disable_gateway_auth: The value indicates whether to disable GatewayAuth.
        :param pulumi.Input[str] private_ip_address: The private ip address of the endpoint.
        :param pulumi.Input[str] sub_domain_suffix: The subdomain suffix of the application.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if disable_gateway_auth is not None:
            pulumi.set(__self__, "disable_gateway_auth", disable_gateway_auth)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if sub_domain_suffix is not None:
            pulumi.set(__self__, "sub_domain_suffix", sub_domain_suffix)

    @property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of access modes for the application.
        """
        return pulumi.get(self, "access_modes")

    @access_modes.setter
    def access_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "access_modes", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[int]]:
        """
        The destination port to connect to.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter(name="disableGatewayAuth")
    def disable_gateway_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        The value indicates whether to disable GatewayAuth.
        """
        return pulumi.get(self, "disable_gateway_auth")

    @disable_gateway_auth.setter
    def disable_gateway_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_gateway_auth", value)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private ip address of the endpoint.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="subDomainSuffix")
    def sub_domain_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The subdomain suffix of the application.
        """
        return pulumi.get(self, "sub_domain_suffix")

    @sub_domain_suffix.setter
    def sub_domain_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_domain_suffix", value)


@pulumi.input_type
class ApplicationPropertiesArgs:
    def __init__(__self__, *,
                 application_type: Optional[pulumi.Input[str]] = None,
                 compute_profile: Optional[pulumi.Input['ComputeProfileArgs']] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['ErrorsArgs']]]] = None,
                 https_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGetHttpsEndpointArgs']]]] = None,
                 install_script_actions: Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]]] = None,
                 ssh_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGetEndpointArgs']]]] = None,
                 uninstall_script_actions: Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]]] = None):
        """
        The HDInsight cluster application GET response.
        :param pulumi.Input[str] application_type: The application type.
        :param pulumi.Input['ComputeProfileArgs'] compute_profile: The list of roles in the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ErrorsArgs']]] errors: The list of errors.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGetHttpsEndpointArgs']]] https_endpoints: The list of application HTTPS endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]] install_script_actions: The list of install script actions.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGetEndpointArgs']]] ssh_endpoints: The list of application SSH endpoints.
        :param pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]] uninstall_script_actions: The list of uninstall script actions.
        """
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if compute_profile is not None:
            pulumi.set(__self__, "compute_profile", compute_profile)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if https_endpoints is not None:
            pulumi.set(__self__, "https_endpoints", https_endpoints)
        if install_script_actions is not None:
            pulumi.set(__self__, "install_script_actions", install_script_actions)
        if ssh_endpoints is not None:
            pulumi.set(__self__, "ssh_endpoints", ssh_endpoints)
        if uninstall_script_actions is not None:
            pulumi.set(__self__, "uninstall_script_actions", uninstall_script_actions)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[str]]:
        """
        The application type.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="computeProfile")
    def compute_profile(self) -> Optional[pulumi.Input['ComputeProfileArgs']]:
        """
        The list of roles in the cluster.
        """
        return pulumi.get(self, "compute_profile")

    @compute_profile.setter
    def compute_profile(self, value: Optional[pulumi.Input['ComputeProfileArgs']]):
        pulumi.set(self, "compute_profile", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ErrorsArgs']]]]:
        """
        The list of errors.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ErrorsArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter(name="httpsEndpoints")
    def https_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGetHttpsEndpointArgs']]]]:
        """
        The list of application HTTPS endpoints.
        """
        return pulumi.get(self, "https_endpoints")

    @https_endpoints.setter
    def https_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGetHttpsEndpointArgs']]]]):
        pulumi.set(self, "https_endpoints", value)

    @property
    @pulumi.getter(name="installScriptActions")
    def install_script_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]]]:
        """
        The list of install script actions.
        """
        return pulumi.get(self, "install_script_actions")

    @install_script_actions.setter
    def install_script_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]]]):
        pulumi.set(self, "install_script_actions", value)

    @property
    @pulumi.getter(name="sshEndpoints")
    def ssh_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGetEndpointArgs']]]]:
        """
        The list of application SSH endpoints.
        """
        return pulumi.get(self, "ssh_endpoints")

    @ssh_endpoints.setter
    def ssh_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGetEndpointArgs']]]]):
        pulumi.set(self, "ssh_endpoints", value)

    @property
    @pulumi.getter(name="uninstallScriptActions")
    def uninstall_script_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]]]:
        """
        The list of uninstall script actions.
        """
        return pulumi.get(self, "uninstall_script_actions")

    @uninstall_script_actions.setter
    def uninstall_script_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuntimeScriptActionArgs']]]]):
        pulumi.set(self, "uninstall_script_actions", value)


@pulumi.input_type
class AutoscaleArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input['AutoscaleCapacityArgs']] = None,
                 recurrence: Optional[pulumi.Input['AutoscaleRecurrenceArgs']] = None):
        """
        The autoscale request parameters
        :param pulumi.Input['AutoscaleCapacityArgs'] capacity: Parameters for load-based autoscale
        :param pulumi.Input['AutoscaleRecurrenceArgs'] recurrence: Parameters for schedule-based autoscale
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['AutoscaleCapacityArgs']]:
        """
        Parameters for load-based autoscale
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['AutoscaleCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['AutoscaleRecurrenceArgs']]:
        """
        Parameters for schedule-based autoscale
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['AutoscaleRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)


@pulumi.input_type
class AutoscaleCapacityArgs:
    def __init__(__self__, *,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None):
        """
        The load-based autoscale request parameters
        :param pulumi.Input[int] max_instance_count: The maximum instance count of the cluster
        :param pulumi.Input[int] min_instance_count: The minimum instance count of the cluster
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum instance count of the cluster
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum instance count of the cluster
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)


@pulumi.input_type
class AutoscaleRecurrenceArgs:
    def __init__(__self__, *,
                 schedule: Optional[pulumi.Input[Sequence[pulumi.Input['AutoscaleScheduleArgs']]]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Schedule-based autoscale request parameters
        :param pulumi.Input[Sequence[pulumi.Input['AutoscaleScheduleArgs']]] schedule: Array of schedule-based autoscale rules
        :param pulumi.Input[str] time_zone: The time zone for the autoscale schedule times
        """
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutoscaleScheduleArgs']]]]:
        """
        Array of schedule-based autoscale rules
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutoscaleScheduleArgs']]]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone for the autoscale schedule times
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class AutoscaleScheduleArgs:
    def __init__(__self__, *,
                 days: Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]] = None,
                 time_and_capacity: Optional[pulumi.Input['AutoscaleTimeAndCapacityArgs']] = None):
        """
        Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
        :param pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]] days: Days of the week for a schedule-based autoscale rule
        :param pulumi.Input['AutoscaleTimeAndCapacityArgs'] time_and_capacity: Time and capacity for a schedule-based autoscale rule
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if time_and_capacity is not None:
            pulumi.set(__self__, "time_and_capacity", time_and_capacity)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]]:
        """
        Days of the week for a schedule-based autoscale rule
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="timeAndCapacity")
    def time_and_capacity(self) -> Optional[pulumi.Input['AutoscaleTimeAndCapacityArgs']]:
        """
        Time and capacity for a schedule-based autoscale rule
        """
        return pulumi.get(self, "time_and_capacity")

    @time_and_capacity.setter
    def time_and_capacity(self, value: Optional[pulumi.Input['AutoscaleTimeAndCapacityArgs']]):
        pulumi.set(self, "time_and_capacity", value)


@pulumi.input_type
class AutoscaleTimeAndCapacityArgs:
    def __init__(__self__, *,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 time: Optional[pulumi.Input[str]] = None):
        """
        Time and capacity request parameters
        :param pulumi.Input[int] max_instance_count: The maximum instance count of the cluster
        :param pulumi.Input[int] min_instance_count: The minimum instance count of the cluster
        :param pulumi.Input[str] time: 24-hour time in the form xx:xx
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum instance count of the cluster
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum instance count of the cluster
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        24-hour time in the form xx:xx
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class ClientGroupInfoArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 group_name: Optional[pulumi.Input[str]] = None):
        """
        The information of AAD security group.
        :param pulumi.Input[str] group_id: The AAD security group id.
        :param pulumi.Input[str] group_name: The AAD security group name.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AAD security group id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The AAD security group name.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)


@pulumi.input_type
class ClusterCreatePropertiesArgs:
    def __init__(__self__, *,
                 cluster_definition: Optional[pulumi.Input['ClusterDefinitionArgs']] = None,
                 cluster_version: Optional[pulumi.Input[str]] = None,
                 compute_isolation_properties: Optional[pulumi.Input['ComputeIsolationPropertiesArgs']] = None,
                 compute_profile: Optional[pulumi.Input['ComputeProfileArgs']] = None,
                 disk_encryption_properties: Optional[pulumi.Input['DiskEncryptionPropertiesArgs']] = None,
                 encryption_in_transit_properties: Optional[pulumi.Input['EncryptionInTransitPropertiesArgs']] = None,
                 kafka_rest_properties: Optional[pulumi.Input['KafkaRestPropertiesArgs']] = None,
                 min_supported_tls_version: Optional[pulumi.Input[str]] = None,
                 network_properties: Optional[pulumi.Input['NetworkPropertiesArgs']] = None,
                 os_type: Optional[pulumi.Input['OSType']] = None,
                 security_profile: Optional[pulumi.Input['SecurityProfileArgs']] = None,
                 storage_profile: Optional[pulumi.Input['StorageProfileArgs']] = None,
                 tier: Optional[pulumi.Input['Tier']] = None):
        """
        The cluster create parameters.
        :param pulumi.Input['ClusterDefinitionArgs'] cluster_definition: The cluster definition.
        :param pulumi.Input[str] cluster_version: The version of the cluster.
        :param pulumi.Input['ComputeIsolationPropertiesArgs'] compute_isolation_properties: The compute isolation properties.
        :param pulumi.Input['ComputeProfileArgs'] compute_profile: The compute profile.
        :param pulumi.Input['DiskEncryptionPropertiesArgs'] disk_encryption_properties: The disk encryption properties.
        :param pulumi.Input['EncryptionInTransitPropertiesArgs'] encryption_in_transit_properties: The encryption-in-transit properties.
        :param pulumi.Input['KafkaRestPropertiesArgs'] kafka_rest_properties: The cluster kafka rest proxy configuration.
        :param pulumi.Input[str] min_supported_tls_version: The minimal supported tls version.
        :param pulumi.Input['NetworkPropertiesArgs'] network_properties: The network properties.
        :param pulumi.Input['OSType'] os_type: The type of operating system.
        :param pulumi.Input['SecurityProfileArgs'] security_profile: The security profile.
        :param pulumi.Input['StorageProfileArgs'] storage_profile: The storage profile.
        :param pulumi.Input['Tier'] tier: The cluster tier.
        """
        if cluster_definition is not None:
            pulumi.set(__self__, "cluster_definition", cluster_definition)
        if cluster_version is not None:
            pulumi.set(__self__, "cluster_version", cluster_version)
        if compute_isolation_properties is not None:
            pulumi.set(__self__, "compute_isolation_properties", compute_isolation_properties)
        if compute_profile is not None:
            pulumi.set(__self__, "compute_profile", compute_profile)
        if disk_encryption_properties is not None:
            pulumi.set(__self__, "disk_encryption_properties", disk_encryption_properties)
        if encryption_in_transit_properties is not None:
            pulumi.set(__self__, "encryption_in_transit_properties", encryption_in_transit_properties)
        if kafka_rest_properties is not None:
            pulumi.set(__self__, "kafka_rest_properties", kafka_rest_properties)
        if min_supported_tls_version is not None:
            pulumi.set(__self__, "min_supported_tls_version", min_supported_tls_version)
        if network_properties is not None:
            pulumi.set(__self__, "network_properties", network_properties)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if security_profile is not None:
            pulumi.set(__self__, "security_profile", security_profile)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)
        if tier is None:
            tier = 'Standard'
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="clusterDefinition")
    def cluster_definition(self) -> Optional[pulumi.Input['ClusterDefinitionArgs']]:
        """
        The cluster definition.
        """
        return pulumi.get(self, "cluster_definition")

    @cluster_definition.setter
    def cluster_definition(self, value: Optional[pulumi.Input['ClusterDefinitionArgs']]):
        pulumi.set(self, "cluster_definition", value)

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the cluster.
        """
        return pulumi.get(self, "cluster_version")

    @cluster_version.setter
    def cluster_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_version", value)

    @property
    @pulumi.getter(name="computeIsolationProperties")
    def compute_isolation_properties(self) -> Optional[pulumi.Input['ComputeIsolationPropertiesArgs']]:
        """
        The compute isolation properties.
        """
        return pulumi.get(self, "compute_isolation_properties")

    @compute_isolation_properties.setter
    def compute_isolation_properties(self, value: Optional[pulumi.Input['ComputeIsolationPropertiesArgs']]):
        pulumi.set(self, "compute_isolation_properties", value)

    @property
    @pulumi.getter(name="computeProfile")
    def compute_profile(self) -> Optional[pulumi.Input['ComputeProfileArgs']]:
        """
        The compute profile.
        """
        return pulumi.get(self, "compute_profile")

    @compute_profile.setter
    def compute_profile(self, value: Optional[pulumi.Input['ComputeProfileArgs']]):
        pulumi.set(self, "compute_profile", value)

    @property
    @pulumi.getter(name="diskEncryptionProperties")
    def disk_encryption_properties(self) -> Optional[pulumi.Input['DiskEncryptionPropertiesArgs']]:
        """
        The disk encryption properties.
        """
        return pulumi.get(self, "disk_encryption_properties")

    @disk_encryption_properties.setter
    def disk_encryption_properties(self, value: Optional[pulumi.Input['DiskEncryptionPropertiesArgs']]):
        pulumi.set(self, "disk_encryption_properties", value)

    @property
    @pulumi.getter(name="encryptionInTransitProperties")
    def encryption_in_transit_properties(self) -> Optional[pulumi.Input['EncryptionInTransitPropertiesArgs']]:
        """
        The encryption-in-transit properties.
        """
        return pulumi.get(self, "encryption_in_transit_properties")

    @encryption_in_transit_properties.setter
    def encryption_in_transit_properties(self, value: Optional[pulumi.Input['EncryptionInTransitPropertiesArgs']]):
        pulumi.set(self, "encryption_in_transit_properties", value)

    @property
    @pulumi.getter(name="kafkaRestProperties")
    def kafka_rest_properties(self) -> Optional[pulumi.Input['KafkaRestPropertiesArgs']]:
        """
        The cluster kafka rest proxy configuration.
        """
        return pulumi.get(self, "kafka_rest_properties")

    @kafka_rest_properties.setter
    def kafka_rest_properties(self, value: Optional[pulumi.Input['KafkaRestPropertiesArgs']]):
        pulumi.set(self, "kafka_rest_properties", value)

    @property
    @pulumi.getter(name="minSupportedTlsVersion")
    def min_supported_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        The minimal supported tls version.
        """
        return pulumi.get(self, "min_supported_tls_version")

    @min_supported_tls_version.setter
    def min_supported_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_supported_tls_version", value)

    @property
    @pulumi.getter(name="networkProperties")
    def network_properties(self) -> Optional[pulumi.Input['NetworkPropertiesArgs']]:
        """
        The network properties.
        """
        return pulumi.get(self, "network_properties")

    @network_properties.setter
    def network_properties(self, value: Optional[pulumi.Input['NetworkPropertiesArgs']]):
        pulumi.set(self, "network_properties", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input['OSType']]:
        """
        The type of operating system.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input['OSType']]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="securityProfile")
    def security_profile(self) -> Optional[pulumi.Input['SecurityProfileArgs']]:
        """
        The security profile.
        """
        return pulumi.get(self, "security_profile")

    @security_profile.setter
    def security_profile(self, value: Optional[pulumi.Input['SecurityProfileArgs']]):
        pulumi.set(self, "security_profile", value)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['StorageProfileArgs']]:
        """
        The storage profile.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['StorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['Tier']]:
        """
        The cluster tier.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['Tier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class ClusterDefinitionArgs:
    def __init__(__self__, *,
                 blueprint: Optional[pulumi.Input[str]] = None,
                 component_version: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 configurations: Optional[Any] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        The cluster definition.
        :param pulumi.Input[str] blueprint: The link to the blueprint.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] component_version: The versions of different services in the cluster.
        :param Any configurations: The cluster configurations.
        :param pulumi.Input[str] kind: The type of cluster.
        """
        if blueprint is not None:
            pulumi.set(__self__, "blueprint", blueprint)
        if component_version is not None:
            pulumi.set(__self__, "component_version", component_version)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def blueprint(self) -> Optional[pulumi.Input[str]]:
        """
        The link to the blueprint.
        """
        return pulumi.get(self, "blueprint")

    @blueprint.setter
    def blueprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blueprint", value)

    @property
    @pulumi.getter(name="componentVersion")
    def component_version(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The versions of different services in the cluster.
        """
        return pulumi.get(self, "component_version")

    @component_version.setter
    def component_version(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "component_version", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Any]:
        """
        The cluster configurations.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[Any]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The type of cluster.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class ClusterIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['ClusterIdentityUserAssignedIdentitiesArgs']]]] = None):
        """
        Identity for the cluster.
        :param pulumi.Input['ResourceIdentityType'] type: The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
        :param pulumi.Input[Mapping[str, pulumi.Input['ClusterIdentityUserAssignedIdentitiesArgs']]] user_assigned_identities: The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ClusterIdentityUserAssignedIdentitiesArgs']]]]:
        """
        The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ClusterIdentityUserAssignedIdentitiesArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ClusterIdentityUserAssignedIdentitiesArgs:
    def __init__(__self__, *,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] tenant_id: The tenant id of user assigned identity.
        """
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id of user assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ComputeIsolationPropertiesArgs:
    def __init__(__self__, *,
                 enable_compute_isolation: Optional[pulumi.Input[bool]] = None,
                 host_sku: Optional[pulumi.Input[str]] = None):
        """
        The compute isolation properties.
        :param pulumi.Input[bool] enable_compute_isolation: The flag indicates whether enable compute isolation or not.
        :param pulumi.Input[str] host_sku: The host sku.
        """
        if enable_compute_isolation is None:
            enable_compute_isolation = False
        if enable_compute_isolation is not None:
            pulumi.set(__self__, "enable_compute_isolation", enable_compute_isolation)
        if host_sku is not None:
            pulumi.set(__self__, "host_sku", host_sku)

    @property
    @pulumi.getter(name="enableComputeIsolation")
    def enable_compute_isolation(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag indicates whether enable compute isolation or not.
        """
        return pulumi.get(self, "enable_compute_isolation")

    @enable_compute_isolation.setter
    def enable_compute_isolation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_compute_isolation", value)

    @property
    @pulumi.getter(name="hostSku")
    def host_sku(self) -> Optional[pulumi.Input[str]]:
        """
        The host sku.
        """
        return pulumi.get(self, "host_sku")

    @host_sku.setter
    def host_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_sku", value)


@pulumi.input_type
class ComputeProfileArgs:
    def __init__(__self__, *,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['RoleArgs']]]] = None):
        """
        Describes the compute profile.
        :param pulumi.Input[Sequence[pulumi.Input['RoleArgs']]] roles: The list of roles in the cluster.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoleArgs']]]]:
        """
        The list of roles in the cluster.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoleArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class DataDisksGroupsArgs:
    def __init__(__self__, *,
                 disks_per_node: Optional[pulumi.Input[int]] = None):
        """
        The data disks groups for the role.
        :param pulumi.Input[int] disks_per_node: The number of disks per node.
        """
        if disks_per_node is not None:
            pulumi.set(__self__, "disks_per_node", disks_per_node)

    @property
    @pulumi.getter(name="disksPerNode")
    def disks_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The number of disks per node.
        """
        return pulumi.get(self, "disks_per_node")

    @disks_per_node.setter
    def disks_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disks_per_node", value)


@pulumi.input_type
class DiskEncryptionPropertiesArgs:
    def __init__(__self__, *,
                 encryption_algorithm: Optional[pulumi.Input[Union[str, 'JsonWebKeyEncryptionAlgorithm']]] = None,
                 encryption_at_host: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_version: Optional[pulumi.Input[str]] = None,
                 msi_resource_id: Optional[pulumi.Input[str]] = None,
                 vault_uri: Optional[pulumi.Input[str]] = None):
        """
        The disk encryption properties
        :param pulumi.Input[Union[str, 'JsonWebKeyEncryptionAlgorithm']] encryption_algorithm: Algorithm identifier for encryption, default RSA-OAEP.
        :param pulumi.Input[bool] encryption_at_host: Indicates whether or not resource disk encryption is enabled.
        :param pulumi.Input[str] key_name: Key name that is used for enabling disk encryption.
        :param pulumi.Input[str] key_version: Specific key version that is used for enabling disk encryption.
        :param pulumi.Input[str] msi_resource_id: Resource ID of Managed Identity that is used to access the key vault.
        :param pulumi.Input[str] vault_uri: Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
        """
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if encryption_at_host is None:
            encryption_at_host = False
        if encryption_at_host is not None:
            pulumi.set(__self__, "encryption_at_host", encryption_at_host)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)
        if msi_resource_id is not None:
            pulumi.set(__self__, "msi_resource_id", msi_resource_id)
        if vault_uri is not None:
            pulumi.set(__self__, "vault_uri", vault_uri)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[pulumi.Input[Union[str, 'JsonWebKeyEncryptionAlgorithm']]]:
        """
        Algorithm identifier for encryption, default RSA-OAEP.
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[pulumi.Input[Union[str, 'JsonWebKeyEncryptionAlgorithm']]]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="encryptionAtHost")
    def encryption_at_host(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not resource disk encryption is enabled.
        """
        return pulumi.get(self, "encryption_at_host")

    @encryption_at_host.setter
    def encryption_at_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption_at_host", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Key name that is used for enabling disk encryption.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specific key version that is used for enabling disk encryption.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)

    @property
    @pulumi.getter(name="msiResourceId")
    def msi_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of Managed Identity that is used to access the key vault.
        """
        return pulumi.get(self, "msi_resource_id")

    @msi_resource_id.setter
    def msi_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msi_resource_id", value)

    @property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_uri", value)


@pulumi.input_type
class EncryptionInTransitPropertiesArgs:
    def __init__(__self__, *,
                 is_encryption_in_transit_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The encryption-in-transit properties.
        :param pulumi.Input[bool] is_encryption_in_transit_enabled: Indicates whether or not inter cluster node communication is encrypted in transit.
        """
        if is_encryption_in_transit_enabled is None:
            is_encryption_in_transit_enabled = False
        if is_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_encryption_in_transit_enabled", is_encryption_in_transit_enabled)

    @property
    @pulumi.getter(name="isEncryptionInTransitEnabled")
    def is_encryption_in_transit_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not inter cluster node communication is encrypted in transit.
        """
        return pulumi.get(self, "is_encryption_in_transit_enabled")

    @is_encryption_in_transit_enabled.setter
    def is_encryption_in_transit_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_encryption_in_transit_enabled", value)


@pulumi.input_type
class ErrorsArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The error message associated with the cluster creation.
        :param pulumi.Input[str] code: The error code.
        :param pulumi.Input[str] message: The error message.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class HardwareProfileArgs:
    def __init__(__self__, *,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        The hardware profile.
        :param pulumi.Input[str] vm_size: The size of the VM
        """
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        The size of the VM
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class KafkaRestPropertiesArgs:
    def __init__(__self__, *,
                 client_group_info: Optional[pulumi.Input['ClientGroupInfoArgs']] = None,
                 configuration_override: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The kafka rest proxy configuration which contains AAD security group information.
        :param pulumi.Input['ClientGroupInfoArgs'] client_group_info: The information of AAD security group.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] configuration_override: The configurations that need to be overriden.
        """
        if client_group_info is not None:
            pulumi.set(__self__, "client_group_info", client_group_info)
        if configuration_override is not None:
            pulumi.set(__self__, "configuration_override", configuration_override)

    @property
    @pulumi.getter(name="clientGroupInfo")
    def client_group_info(self) -> Optional[pulumi.Input['ClientGroupInfoArgs']]:
        """
        The information of AAD security group.
        """
        return pulumi.get(self, "client_group_info")

    @client_group_info.setter
    def client_group_info(self, value: Optional[pulumi.Input['ClientGroupInfoArgs']]):
        pulumi.set(self, "client_group_info", value)

    @property
    @pulumi.getter(name="configurationOverride")
    def configuration_override(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The configurations that need to be overriden.
        """
        return pulumi.get(self, "configuration_override")

    @configuration_override.setter
    def configuration_override(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "configuration_override", value)


@pulumi.input_type
class LinuxOperatingSystemProfileArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 ssh_profile: Optional[pulumi.Input['SshProfileArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The ssh username, password, and ssh public key.
        :param pulumi.Input[str] password: The password.
        :param pulumi.Input['SshProfileArgs'] ssh_profile: The SSH profile.
        :param pulumi.Input[str] username: The username.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssh_profile is not None:
            pulumi.set(__self__, "ssh_profile", ssh_profile)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sshProfile")
    def ssh_profile(self) -> Optional[pulumi.Input['SshProfileArgs']]:
        """
        The SSH profile.
        """
        return pulumi.get(self, "ssh_profile")

    @ssh_profile.setter
    def ssh_profile(self, value: Optional[pulumi.Input['SshProfileArgs']]):
        pulumi.set(self, "ssh_profile", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class NetworkPropertiesArgs:
    def __init__(__self__, *,
                 private_link: Optional[pulumi.Input[Union[str, 'PrivateLink']]] = None,
                 resource_provider_connection: Optional[pulumi.Input[Union[str, 'ResourceProviderConnection']]] = None):
        """
        The network properties.
        :param pulumi.Input[Union[str, 'PrivateLink']] private_link: Indicates whether or not private link is enabled.
        :param pulumi.Input[Union[str, 'ResourceProviderConnection']] resource_provider_connection: The direction for the resource provider connection.
        """
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if resource_provider_connection is not None:
            pulumi.set(__self__, "resource_provider_connection", resource_provider_connection)

    @property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[pulumi.Input[Union[str, 'PrivateLink']]]:
        """
        Indicates whether or not private link is enabled.
        """
        return pulumi.get(self, "private_link")

    @private_link.setter
    def private_link(self, value: Optional[pulumi.Input[Union[str, 'PrivateLink']]]):
        pulumi.set(self, "private_link", value)

    @property
    @pulumi.getter(name="resourceProviderConnection")
    def resource_provider_connection(self) -> Optional[pulumi.Input[Union[str, 'ResourceProviderConnection']]]:
        """
        The direction for the resource provider connection.
        """
        return pulumi.get(self, "resource_provider_connection")

    @resource_provider_connection.setter
    def resource_provider_connection(self, value: Optional[pulumi.Input[Union[str, 'ResourceProviderConnection']]]):
        pulumi.set(self, "resource_provider_connection", value)


@pulumi.input_type
class OsProfileArgs:
    def __init__(__self__, *,
                 linux_operating_system_profile: Optional[pulumi.Input['LinuxOperatingSystemProfileArgs']] = None):
        """
        The Linux operation systems profile.
        :param pulumi.Input['LinuxOperatingSystemProfileArgs'] linux_operating_system_profile: The Linux OS profile.
        """
        if linux_operating_system_profile is not None:
            pulumi.set(__self__, "linux_operating_system_profile", linux_operating_system_profile)

    @property
    @pulumi.getter(name="linuxOperatingSystemProfile")
    def linux_operating_system_profile(self) -> Optional[pulumi.Input['LinuxOperatingSystemProfileArgs']]:
        """
        The Linux OS profile.
        """
        return pulumi.get(self, "linux_operating_system_profile")

    @linux_operating_system_profile.setter
    def linux_operating_system_profile(self, value: Optional[pulumi.Input['LinuxOperatingSystemProfileArgs']]):
        pulumi.set(self, "linux_operating_system_profile", value)


@pulumi.input_type
class RoleArgs:
    def __init__(__self__, *,
                 autoscale_configuration: Optional[pulumi.Input['AutoscaleArgs']] = None,
                 data_disks_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DataDisksGroupsArgs']]]] = None,
                 encrypt_data_disks: Optional[pulumi.Input[bool]] = None,
                 hardware_profile: Optional[pulumi.Input['HardwareProfileArgs']] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_profile: Optional[pulumi.Input['OsProfileArgs']] = None,
                 script_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptActionArgs']]]] = None,
                 target_instance_count: Optional[pulumi.Input[int]] = None,
                 v_m_group_name: Optional[pulumi.Input[str]] = None,
                 virtual_network_profile: Optional[pulumi.Input['VirtualNetworkProfileArgs']] = None):
        """
        Describes a role on the cluster.
        :param pulumi.Input['AutoscaleArgs'] autoscale_configuration: The autoscale configurations.
        :param pulumi.Input[Sequence[pulumi.Input['DataDisksGroupsArgs']]] data_disks_groups: The data disks groups for the role.
        :param pulumi.Input[bool] encrypt_data_disks: Indicates whether encrypt the data disks.
        :param pulumi.Input['HardwareProfileArgs'] hardware_profile: The hardware profile.
        :param pulumi.Input[int] min_instance_count: The minimum instance count of the cluster.
        :param pulumi.Input[str] name: The name of the role.
        :param pulumi.Input['OsProfileArgs'] os_profile: The operating system profile.
        :param pulumi.Input[Sequence[pulumi.Input['ScriptActionArgs']]] script_actions: The list of script actions on the role.
        :param pulumi.Input[int] target_instance_count: The instance count of the cluster.
        :param pulumi.Input[str] v_m_group_name: The name of the virtual machine group.
        :param pulumi.Input['VirtualNetworkProfileArgs'] virtual_network_profile: The virtual network profile.
        """
        if autoscale_configuration is not None:
            pulumi.set(__self__, "autoscale_configuration", autoscale_configuration)
        if data_disks_groups is not None:
            pulumi.set(__self__, "data_disks_groups", data_disks_groups)
        if encrypt_data_disks is None:
            encrypt_data_disks = False
        if encrypt_data_disks is not None:
            pulumi.set(__self__, "encrypt_data_disks", encrypt_data_disks)
        if hardware_profile is not None:
            pulumi.set(__self__, "hardware_profile", hardware_profile)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if script_actions is not None:
            pulumi.set(__self__, "script_actions", script_actions)
        if target_instance_count is not None:
            pulumi.set(__self__, "target_instance_count", target_instance_count)
        if v_m_group_name is not None:
            pulumi.set(__self__, "v_m_group_name", v_m_group_name)
        if virtual_network_profile is not None:
            pulumi.set(__self__, "virtual_network_profile", virtual_network_profile)

    @property
    @pulumi.getter(name="autoscaleConfiguration")
    def autoscale_configuration(self) -> Optional[pulumi.Input['AutoscaleArgs']]:
        """
        The autoscale configurations.
        """
        return pulumi.get(self, "autoscale_configuration")

    @autoscale_configuration.setter
    def autoscale_configuration(self, value: Optional[pulumi.Input['AutoscaleArgs']]):
        pulumi.set(self, "autoscale_configuration", value)

    @property
    @pulumi.getter(name="dataDisksGroups")
    def data_disks_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDisksGroupsArgs']]]]:
        """
        The data disks groups for the role.
        """
        return pulumi.get(self, "data_disks_groups")

    @data_disks_groups.setter
    def data_disks_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDisksGroupsArgs']]]]):
        pulumi.set(self, "data_disks_groups", value)

    @property
    @pulumi.getter(name="encryptDataDisks")
    def encrypt_data_disks(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether encrypt the data disks.
        """
        return pulumi.get(self, "encrypt_data_disks")

    @encrypt_data_disks.setter
    def encrypt_data_disks(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_data_disks", value)

    @property
    @pulumi.getter(name="hardwareProfile")
    def hardware_profile(self) -> Optional[pulumi.Input['HardwareProfileArgs']]:
        """
        The hardware profile.
        """
        return pulumi.get(self, "hardware_profile")

    @hardware_profile.setter
    def hardware_profile(self, value: Optional[pulumi.Input['HardwareProfileArgs']]):
        pulumi.set(self, "hardware_profile", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum instance count of the cluster.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['OsProfileArgs']]:
        """
        The operating system profile.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['OsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="scriptActions")
    def script_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScriptActionArgs']]]]:
        """
        The list of script actions on the role.
        """
        return pulumi.get(self, "script_actions")

    @script_actions.setter
    def script_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScriptActionArgs']]]]):
        pulumi.set(self, "script_actions", value)

    @property
    @pulumi.getter(name="targetInstanceCount")
    def target_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The instance count of the cluster.
        """
        return pulumi.get(self, "target_instance_count")

    @target_instance_count.setter
    def target_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_instance_count", value)

    @property
    @pulumi.getter(name="vMGroupName")
    def v_m_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the virtual machine group.
        """
        return pulumi.get(self, "v_m_group_name")

    @v_m_group_name.setter
    def v_m_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_m_group_name", value)

    @property
    @pulumi.getter(name="virtualNetworkProfile")
    def virtual_network_profile(self) -> Optional[pulumi.Input['VirtualNetworkProfileArgs']]:
        """
        The virtual network profile.
        """
        return pulumi.get(self, "virtual_network_profile")

    @virtual_network_profile.setter
    def virtual_network_profile(self, value: Optional[pulumi.Input['VirtualNetworkProfileArgs']]):
        pulumi.set(self, "virtual_network_profile", value)


@pulumi.input_type
class RuntimeScriptActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 roles: pulumi.Input[Sequence[pulumi.Input[str]]],
                 uri: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[str]] = None):
        """
        Describes a script action on a running cluster.
        :param pulumi.Input[str] name: The name of the script action.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: The list of roles where script will be executed.
        :param pulumi.Input[str] uri: The URI to the script.
        :param pulumi.Input[str] parameters: The parameters for the script
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "uri", uri)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the script action.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of roles where script will be executed.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The URI to the script.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        The parameters for the script
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class ScriptActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 parameters: pulumi.Input[str],
                 uri: pulumi.Input[str]):
        """
        Describes a script action on role on the cluster.
        :param pulumi.Input[str] name: The name of the script action.
        :param pulumi.Input[str] parameters: The parameters for the script provided.
        :param pulumi.Input[str] uri: The URI to the script.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the script action.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[str]:
        """
        The parameters for the script provided.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The URI to the script.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class SecurityProfileArgs:
    def __init__(__self__, *,
                 aadds_resource_id: Optional[pulumi.Input[str]] = None,
                 cluster_users_group_dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 directory_type: Optional[pulumi.Input['DirectoryType']] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 domain_user_password: Optional[pulumi.Input[str]] = None,
                 domain_username: Optional[pulumi.Input[str]] = None,
                 ldaps_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 msi_resource_id: Optional[pulumi.Input[str]] = None,
                 organizational_unit_dn: Optional[pulumi.Input[str]] = None):
        """
        The security profile which contains Ssh public key for the HDInsight cluster.
        :param pulumi.Input[str] aadds_resource_id: The resource ID of the user's Azure Active Directory Domain Service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_users_group_dns: Optional. The Distinguished Names for cluster user groups
        :param pulumi.Input['DirectoryType'] directory_type: The directory type.
        :param pulumi.Input[str] domain: The organization's active directory domain.
        :param pulumi.Input[str] domain_user_password: The domain admin password.
        :param pulumi.Input[str] domain_username: The domain user account that will have admin privileges on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ldaps_urls: The LDAPS protocol URLs to communicate with the Active Directory.
        :param pulumi.Input[str] msi_resource_id: User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
        :param pulumi.Input[str] organizational_unit_dn: The organizational unit within the Active Directory to place the cluster and service accounts.
        """
        if aadds_resource_id is not None:
            pulumi.set(__self__, "aadds_resource_id", aadds_resource_id)
        if cluster_users_group_dns is not None:
            pulumi.set(__self__, "cluster_users_group_dns", cluster_users_group_dns)
        if directory_type is not None:
            pulumi.set(__self__, "directory_type", directory_type)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_user_password is not None:
            pulumi.set(__self__, "domain_user_password", domain_user_password)
        if domain_username is not None:
            pulumi.set(__self__, "domain_username", domain_username)
        if ldaps_urls is not None:
            pulumi.set(__self__, "ldaps_urls", ldaps_urls)
        if msi_resource_id is not None:
            pulumi.set(__self__, "msi_resource_id", msi_resource_id)
        if organizational_unit_dn is not None:
            pulumi.set(__self__, "organizational_unit_dn", organizational_unit_dn)

    @property
    @pulumi.getter(name="aaddsResourceId")
    def aadds_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the user's Azure Active Directory Domain Service.
        """
        return pulumi.get(self, "aadds_resource_id")

    @aadds_resource_id.setter
    def aadds_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aadds_resource_id", value)

    @property
    @pulumi.getter(name="clusterUsersGroupDNs")
    def cluster_users_group_dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The Distinguished Names for cluster user groups
        """
        return pulumi.get(self, "cluster_users_group_dns")

    @cluster_users_group_dns.setter
    def cluster_users_group_dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_users_group_dns", value)

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> Optional[pulumi.Input['DirectoryType']]:
        """
        The directory type.
        """
        return pulumi.get(self, "directory_type")

    @directory_type.setter
    def directory_type(self, value: Optional[pulumi.Input['DirectoryType']]):
        pulumi.set(self, "directory_type", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The organization's active directory domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="domainUserPassword")
    def domain_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        The domain admin password.
        """
        return pulumi.get(self, "domain_user_password")

    @domain_user_password.setter
    def domain_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_user_password", value)

    @property
    @pulumi.getter(name="domainUsername")
    def domain_username(self) -> Optional[pulumi.Input[str]]:
        """
        The domain user account that will have admin privileges on the cluster.
        """
        return pulumi.get(self, "domain_username")

    @domain_username.setter
    def domain_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_username", value)

    @property
    @pulumi.getter(name="ldapsUrls")
    def ldaps_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The LDAPS protocol URLs to communicate with the Active Directory.
        """
        return pulumi.get(self, "ldaps_urls")

    @ldaps_urls.setter
    def ldaps_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ldaps_urls", value)

    @property
    @pulumi.getter(name="msiResourceId")
    def msi_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
        """
        return pulumi.get(self, "msi_resource_id")

    @msi_resource_id.setter
    def msi_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msi_resource_id", value)

    @property
    @pulumi.getter(name="organizationalUnitDN")
    def organizational_unit_dn(self) -> Optional[pulumi.Input[str]]:
        """
        The organizational unit within the Active Directory to place the cluster and service accounts.
        """
        return pulumi.get(self, "organizational_unit_dn")

    @organizational_unit_dn.setter
    def organizational_unit_dn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizational_unit_dn", value)


@pulumi.input_type
class SshProfileArgs:
    def __init__(__self__, *,
                 public_keys: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]] = None):
        """
        The list of SSH public keys.
        :param pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]] public_keys: The list of SSH public keys.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]:
        """
        The list of SSH public keys.
        """
        return pulumi.get(self, "public_keys")

    @public_keys.setter
    def public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SshPublicKeyArgs']]]]):
        pulumi.set(self, "public_keys", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 certificate_data: Optional[pulumi.Input[str]] = None):
        """
        The SSH public key for the cluster nodes.
        :param pulumi.Input[str] certificate_data: The certificate for SSH.
        """
        if certificate_data is not None:
            pulumi.set(__self__, "certificate_data", certificate_data)

    @property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate for SSH.
        """
        return pulumi.get(self, "certificate_data")

    @certificate_data.setter
    def certificate_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_data", value)


@pulumi.input_type
class StorageAccountArgs:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input[str]] = None,
                 file_system: Optional[pulumi.Input[str]] = None,
                 fileshare: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 msi_resource_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 saskey: Optional[pulumi.Input[str]] = None):
        """
        The storage Account.
        :param pulumi.Input[str] container: The container in the storage account, only to be specified for WASB storage accounts.
        :param pulumi.Input[str] file_system: The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
        :param pulumi.Input[str] fileshare: The file share name.
        :param pulumi.Input[bool] is_default: Whether or not the storage account is the default storage account.
        :param pulumi.Input[str] key: The storage account access key.
        :param pulumi.Input[str] msi_resource_id: The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
        :param pulumi.Input[str] name: The name of the storage account.
        :param pulumi.Input[str] resource_id: The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
        :param pulumi.Input[str] saskey: The shared access signature key.
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)
        if fileshare is not None:
            pulumi.set(__self__, "fileshare", fileshare)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if msi_resource_id is not None:
            pulumi.set(__self__, "msi_resource_id", msi_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if saskey is not None:
            pulumi.set(__self__, "saskey", saskey)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        The container in the storage account, only to be specified for WASB storage accounts.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional[pulumi.Input[str]]:
        """
        The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
        """
        return pulumi.get(self, "file_system")

    @file_system.setter
    def file_system(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system", value)

    @property
    @pulumi.getter
    def fileshare(self) -> Optional[pulumi.Input[str]]:
        """
        The file share name.
        """
        return pulumi.get(self, "fileshare")

    @fileshare.setter
    def fileshare(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fileshare", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the storage account is the default storage account.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The storage account access key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="msiResourceId")
    def msi_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage Gen 2.
        """
        return pulumi.get(self, "msi_resource_id")

    @msi_resource_id.setter
    def msi_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "msi_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the storage account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def saskey(self) -> Optional[pulumi.Input[str]]:
        """
        The shared access signature key.
        """
        return pulumi.get(self, "saskey")

    @saskey.setter
    def saskey(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "saskey", value)


@pulumi.input_type
class StorageProfileArgs:
    def __init__(__self__, *,
                 storageaccounts: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]] = None):
        """
        The storage profile.
        :param pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]] storageaccounts: The list of storage accounts in the cluster.
        """
        if storageaccounts is not None:
            pulumi.set(__self__, "storageaccounts", storageaccounts)

    @property
    @pulumi.getter
    def storageaccounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]:
        """
        The list of storage accounts in the cluster.
        """
        return pulumi.get(self, "storageaccounts")

    @storageaccounts.setter
    def storageaccounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountArgs']]]]):
        pulumi.set(self, "storageaccounts", value)


@pulumi.input_type
class VirtualNetworkProfileArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        The virtual network properties.
        :param pulumi.Input[str] id: The ID of the virtual network.
        :param pulumi.Input[str] subnet: The name of the subnet.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the virtual network.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subnet.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


