# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CloudServiceExtensionProfileArgs',
    'CloudServiceExtensionPropertiesArgs',
    'CloudServiceNetworkProfileArgs',
    'CloudServiceOsProfileArgs',
    'CloudServicePropertiesArgs',
    'CloudServiceRoleProfileArgs',
    'CloudServiceRoleProfilePropertiesArgs',
    'CloudServiceRoleSkuArgs',
    'CloudServiceVaultAndSecretReferenceArgs',
    'CloudServiceVaultCertificateArgs',
    'CloudServiceVaultSecretGroupArgs',
    'ExtensionArgs',
    'LoadBalancerConfigurationArgs',
    'LoadBalancerConfigurationPropertiesArgs',
    'LoadBalancerFrontendIPConfigurationArgs',
    'LoadBalancerFrontendIPConfigurationPropertiesArgs',
    'SubResourceArgs',
]

@pulumi.input_type
class CloudServiceExtensionProfileArgs:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]]] = None):
        """
        Describes a cloud service extension profile.
        :param pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]] extensions: List of extensions for the cloud service.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]]]:
        """
        List of extensions for the cloud service.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)


@pulumi.input_type
class CloudServiceExtensionPropertiesArgs:
    def __init__(__self__, *,
                 auto_upgrade_minor_version: Optional[pulumi.Input[bool]] = None,
                 force_update_tag: Optional[pulumi.Input[str]] = None,
                 protected_settings: Optional[pulumi.Input[str]] = None,
                 protected_settings_from_key_vault: Optional[pulumi.Input['CloudServiceVaultAndSecretReferenceArgs']] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 roles_applied_to: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 type_handler_version: Optional[pulumi.Input[str]] = None):
        """
        Extension Properties.
        :param pulumi.Input[bool] auto_upgrade_minor_version: Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
        :param pulumi.Input[str] force_update_tag: Tag to force apply the provided public and protected settings.
               Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
               If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
               If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
               it is up to handler implementation whether to re-run it or not
        :param pulumi.Input[str] protected_settings: Protected settings for the extension which are encrypted before sent to the role instance.
        :param pulumi.Input[str] publisher: The name of the extension handler publisher.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles_applied_to: Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
        :param pulumi.Input[str] settings: Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
        :param pulumi.Input[str] type: Specifies the type of the extension.
        :param pulumi.Input[str] type_handler_version: Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
        """
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if roles_applied_to is not None:
            pulumi.set(__self__, "roles_applied_to", roles_applied_to)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Tag to force apply the provided public and protected settings.
        Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
        If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
        If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
        it is up to handler implementation whether to re-run it or not
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Protected settings for the extension which are encrypted before sent to the role instance.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protected_settings", value)

    @property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional[pulumi.Input['CloudServiceVaultAndSecretReferenceArgs']]:
        return pulumi.get(self, "protected_settings_from_key_vault")

    @protected_settings_from_key_vault.setter
    def protected_settings_from_key_vault(self, value: Optional[pulumi.Input['CloudServiceVaultAndSecretReferenceArgs']]):
        pulumi.set(self, "protected_settings_from_key_vault", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="rolesAppliedTo")
    def roles_applied_to(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
        """
        return pulumi.get(self, "roles_applied_to")

    @roles_applied_to.setter
    def roles_applied_to(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles_applied_to", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[str]]:
        """
        Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the extension.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_handler_version", value)


@pulumi.input_type
class CloudServiceNetworkProfileArgs:
    def __init__(__self__, *,
                 load_balancer_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]]] = None,
                 swappable_cloud_service: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Network Profile for the cloud service.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]] load_balancer_configurations: The list of load balancer configurations for the cloud service.
        """
        if load_balancer_configurations is not None:
            pulumi.set(__self__, "load_balancer_configurations", load_balancer_configurations)
        if swappable_cloud_service is not None:
            pulumi.set(__self__, "swappable_cloud_service", swappable_cloud_service)

    @property
    @pulumi.getter(name="loadBalancerConfigurations")
    def load_balancer_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]]]:
        """
        The list of load balancer configurations for the cloud service.
        """
        return pulumi.get(self, "load_balancer_configurations")

    @load_balancer_configurations.setter
    def load_balancer_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerConfigurationArgs']]]]):
        pulumi.set(self, "load_balancer_configurations", value)

    @property
    @pulumi.getter(name="swappableCloudService")
    def swappable_cloud_service(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        return pulumi.get(self, "swappable_cloud_service")

    @swappable_cloud_service.setter
    def swappable_cloud_service(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "swappable_cloud_service", value)


@pulumi.input_type
class CloudServiceOsProfileArgs:
    def __init__(__self__, *,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]]] = None):
        """
        Describes the OS profile for the cloud service.
        :param pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]] secrets: Specifies set of certificates that should be installed onto the role instances.
        """
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]]]:
        """
        Specifies set of certificates that should be installed onto the role instances.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultSecretGroupArgs']]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class CloudServicePropertiesArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input[str]] = None,
                 configuration_url: Optional[pulumi.Input[str]] = None,
                 extension_profile: Optional[pulumi.Input['CloudServiceExtensionProfileArgs']] = None,
                 network_profile: Optional[pulumi.Input['CloudServiceNetworkProfileArgs']] = None,
                 os_profile: Optional[pulumi.Input['CloudServiceOsProfileArgs']] = None,
                 package_url: Optional[pulumi.Input[str]] = None,
                 role_profile: Optional[pulumi.Input['CloudServiceRoleProfileArgs']] = None,
                 start_cloud_service: Optional[pulumi.Input[bool]] = None,
                 upgrade_mode: Optional[pulumi.Input[Union[str, 'CloudServiceUpgradeMode']]] = None):
        """
        Cloud service properties
        :param pulumi.Input[str] configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
        :param pulumi.Input[str] configuration_url: Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
               This is a write-only property and is not returned in GET calls.
        :param pulumi.Input['CloudServiceExtensionProfileArgs'] extension_profile: Describes a cloud service extension profile.
        :param pulumi.Input['CloudServiceNetworkProfileArgs'] network_profile: Network Profile for the cloud service.
        :param pulumi.Input['CloudServiceOsProfileArgs'] os_profile: Describes the OS profile for the cloud service.
        :param pulumi.Input[str] package_url: Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
               This is a write-only property and is not returned in GET calls.
        :param pulumi.Input['CloudServiceRoleProfileArgs'] role_profile: Describes the role profile for the cloud service.
        :param pulumi.Input[bool] start_cloud_service: (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
               If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
        :param pulumi.Input[Union[str, 'CloudServiceUpgradeMode']] upgrade_mode: Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
               Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
               If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if configuration_url is not None:
            pulumi.set(__self__, "configuration_url", configuration_url)
        if extension_profile is not None:
            pulumi.set(__self__, "extension_profile", extension_profile)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if package_url is not None:
            pulumi.set(__self__, "package_url", package_url)
        if role_profile is not None:
            pulumi.set(__self__, "role_profile", role_profile)
        if start_cloud_service is not None:
            pulumi.set(__self__, "start_cloud_service", start_cloud_service)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the XML service configuration (.cscfg) for the cloud service.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter(name="configurationUrl")
    def configuration_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a URL that refers to the location of the service configuration in the Blob service. The service package URL  can be Shared Access Signature (SAS) URI from any storage account.
        This is a write-only property and is not returned in GET calls.
        """
        return pulumi.get(self, "configuration_url")

    @configuration_url.setter
    def configuration_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_url", value)

    @property
    @pulumi.getter(name="extensionProfile")
    def extension_profile(self) -> Optional[pulumi.Input['CloudServiceExtensionProfileArgs']]:
        """
        Describes a cloud service extension profile.
        """
        return pulumi.get(self, "extension_profile")

    @extension_profile.setter
    def extension_profile(self, value: Optional[pulumi.Input['CloudServiceExtensionProfileArgs']]):
        pulumi.set(self, "extension_profile", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['CloudServiceNetworkProfileArgs']]:
        """
        Network Profile for the cloud service.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['CloudServiceNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['CloudServiceOsProfileArgs']]:
        """
        Describes the OS profile for the cloud service.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['CloudServiceOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a URL that refers to the location of the service package in the Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage account.
        This is a write-only property and is not returned in GET calls.
        """
        return pulumi.get(self, "package_url")

    @package_url.setter
    def package_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_url", value)

    @property
    @pulumi.getter(name="roleProfile")
    def role_profile(self) -> Optional[pulumi.Input['CloudServiceRoleProfileArgs']]:
        """
        Describes the role profile for the cloud service.
        """
        return pulumi.get(self, "role_profile")

    @role_profile.setter
    def role_profile(self, value: Optional[pulumi.Input['CloudServiceRoleProfileArgs']]):
        pulumi.set(self, "role_profile", value)

    @property
    @pulumi.getter(name="startCloudService")
    def start_cloud_service(self) -> Optional[pulumi.Input[bool]]:
        """
        (Optional) Indicates whether to start the cloud service immediately after it is created. The default value is `true`.
        If false, the service model is still deployed, but the code is not run immediately. Instead, the service is PoweredOff until you call Start, at which time the service will be started. A deployed service still incurs charges, even if it is poweredoff.
        """
        return pulumi.get(self, "start_cloud_service")

    @start_cloud_service.setter
    def start_cloud_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_cloud_service", value)

    @property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[Union[str, 'CloudServiceUpgradeMode']]]:
        """
        Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
        Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
        If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[Union[str, 'CloudServiceUpgradeMode']]]):
        pulumi.set(self, "upgrade_mode", value)


@pulumi.input_type
class CloudServiceRoleProfileArgs:
    def __init__(__self__, *,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]]] = None):
        """
        Describes the role profile for the cloud service.
        :param pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]] roles: List of roles for the cloud service.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]]]:
        """
        List of roles for the cloud service.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceRoleProfilePropertiesArgs']]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class CloudServiceRoleProfilePropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input['CloudServiceRoleSkuArgs']] = None):
        """
        Describes the role properties.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input['CloudServiceRoleSkuArgs'] sku: Describes the cloud service role sku.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['CloudServiceRoleSkuArgs']]:
        """
        Describes the cloud service role sku.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['CloudServiceRoleSkuArgs']]):
        pulumi.set(self, "sku", value)


@pulumi.input_type
class CloudServiceRoleSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None):
        """
        Describes the cloud service role sku.
        :param pulumi.Input[float] capacity: Specifies the number of role instances in the cloud service.
        :param pulumi.Input[str] name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
        :param pulumi.Input[str] tier: Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the number of role instances in the cloud service.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The sku name. NOTE: If the new SKU is not supported on the hardware the cloud service is currently on, you need to delete and recreate the cloud service or move back to the old sku.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the tier of the cloud service. Possible Values are <br /><br /> **Standard** <br /><br /> **Basic**
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class CloudServiceVaultAndSecretReferenceArgs:
    def __init__(__self__, *,
                 secret_url: Optional[pulumi.Input[str]] = None,
                 source_vault: Optional[pulumi.Input['SubResourceArgs']] = None):
        if secret_url is not None:
            pulumi.set(__self__, "secret_url", secret_url)
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)

    @property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_url")

    @secret_url.setter
    def secret_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_url", value)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "source_vault", value)


@pulumi.input_type
class CloudServiceVaultCertificateArgs:
    def __init__(__self__, *,
                 certificate_url: Optional[pulumi.Input[str]] = None):
        """
        Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role instance.
        :param pulumi.Input[str] certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as a secret.
        """
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[pulumi.Input[str]]:
        """
        This is the URL of a certificate that has been uploaded to Key Vault as a secret.
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_url", value)


@pulumi.input_type
class CloudServiceVaultSecretGroupArgs:
    def __init__(__self__, *,
                 source_vault: Optional[pulumi.Input['SubResourceArgs']] = None,
                 vault_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]]] = None):
        """
        Describes a set of certificates which are all in the same Key Vault.
        :param pulumi.Input['SubResourceArgs'] source_vault: The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        :param pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]] vault_certificates: The list of key vault references in SourceVault which contain certificates.
        """
        if source_vault is not None:
            pulumi.set(__self__, "source_vault", source_vault)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @property
    @pulumi.getter(name="sourceVault")
    def source_vault(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
        """
        return pulumi.get(self, "source_vault")

    @source_vault.setter
    def source_vault(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "source_vault", value)

    @property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]]]:
        """
        The list of key vault references in SourceVault which contain certificates.
        """
        return pulumi.get(self, "vault_certificates")

    @vault_certificates.setter
    def vault_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudServiceVaultCertificateArgs']]]]):
        pulumi.set(self, "vault_certificates", value)


@pulumi.input_type
class ExtensionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['CloudServiceExtensionPropertiesArgs']] = None):
        """
        Describes a cloud service Extension.
        :param pulumi.Input[str] name: The name of the extension.
        :param pulumi.Input['CloudServiceExtensionPropertiesArgs'] properties: Extension Properties.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['CloudServiceExtensionPropertiesArgs']]:
        """
        Extension Properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['CloudServiceExtensionPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class LoadBalancerConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['LoadBalancerConfigurationPropertiesArgs']] = None):
        """
        Describes the load balancer configuration.
        :param pulumi.Input[str] name: Resource Name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['LoadBalancerConfigurationPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['LoadBalancerConfigurationPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class LoadBalancerConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]] frontend_ip_configurations: List of IP
        """
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)

    @property
    @pulumi.getter(name="frontendIPConfigurations")
    def frontend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]]]:
        """
        List of IP
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerFrontendIPConfigurationArgs']]]]):
        pulumi.set(self, "frontend_ip_configurations", value)


@pulumi.input_type
class LoadBalancerFrontendIPConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs']] = None):
        """
        :param pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs'] properties: Describes a cloud service IP Configuration
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs']]:
        """
        Describes a cloud service IP Configuration
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['LoadBalancerFrontendIPConfigurationPropertiesArgs']]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class LoadBalancerFrontendIPConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 public_ip_address: Optional[pulumi.Input['SubResourceArgs']] = None,
                 subnet: Optional[pulumi.Input['SubResourceArgs']] = None):
        """
        Describes a cloud service IP Configuration
        :param pulumi.Input[str] private_ip_address: The private IP address referenced by the cloud service.
        """
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address referenced by the cloud service.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="publicIPAddress")
    def public_ip_address(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "public_ip_address", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: Resource Id
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


